% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_state_demograhpics.R
\name{get_state_demographics}
\alias{get_state_demographics}
\title{Get a handful of demographic variables on US States from the US Census Bureau as a data.frame.}
\usage{
get_state_demographics(endyear = 2013, span = 5)
}
\arguments{
\item{endyear}{The end year for the survey}

\item{span}{The span of the survey}
}
\description{
The data comes from the American Community Survey (ACS). The variables are: total population, percent White 
not Hispanic, Percent Black or African American not Hispanic, percent Asian not Hispanic,
percent Hispanic all races, per-capita income, median rent and median age.
}
\examples{
\dontrun{
# get some demographic data on US states from the 2010 5-year ACS
df = get_state_demographics(endyear=2010, span=5)
colnames(df)

# analyze the percent of people who are white not hispanic
# a boxplot shows the distribution
boxplot(df$percent_white)

# a choropleth map shows the location of the values
# set the 'value' column to be the column we want to render
df$value = df$percent_white
state_choropleth(df)
}
}
\references{
The choroplethr guide to Census data: http://www.arilamstein.com/open-source/choroplethr/mapping-us-census-data/

A list of all ACS Surveys: http://factfinder.census.gov/faces/affhelp/jsf/pages/metadata.xhtml?lang=en&type=survey&id=survey.en.ACS_ACS
}
