% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-lte.R
\name{chk_lte}
\alias{chk_lte}
\alias{vld_lte}
\title{Check Less Than or Equal To}
\usage{
chk_lte(x, value = 0, x_name = NULL)

vld_lte(x, value = 0)
}
\arguments{
\item{x}{The object to check.}

\item{value}{A non-missing scalar of a value.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all non-missing values are less than or equal to y using

\code{all(x[!is.na(x)] <= value)}
}
\section{Functions}{
\itemize{
\item \code{vld_lte}: Validate Less Than or Equal To
}}

\examples{
# chk_lte
chk_lte(0)
try(chk_lte(0.1))
# vld_lte
vld_lte(numeric(0))
vld_lte(0)
vld_lte(0.1)
vld_lte(c(-0.1, -0.2, NA))
vld_lte(c(-0.1, -0.2, NA), value = -1)
}
\seealso{
Other chk_ranges: 
\code{\link{chk_gte}()},
\code{\link{chk_gt}()},
\code{\link{chk_lt}()},
\code{\link{chk_range}()}
}
\concept{chk_ranges}
