% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-datetime.R
\name{chk_datetime}
\alias{chk_datetime}
\alias{vld_datetime}
\title{Check DateTime}
\usage{
chk_datetime(x, x_name = NULL)

vld_datetime(x, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} functions throw an informative error if the test fails.

The \code{vld_} functions return a flag indicating whether the test was met.
}
\description{
Checks if non-missing POSIXct scalar using

\code{inherits(x, "POSIXct") && length(x) == 1L && !anyNA(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_datetime}: Validate DateTime
}}

\examples{

# chk_datetime
chk_datetime(as.POSIXct("2001-01-02"))
try(chk_datetime(1))

# vld_datetime
vld_datetime(as.POSIXct("2001-01-02"))
vld_datetime(Sys.time())
vld_datetime(1)
vld_datetime("2001-01-02")
vld_datetime(c(Sys.time(), Sys.time()))
}
\seealso{
Other chk_scalars: 
\code{\link{chk_date}()},
\code{\link{chk_number}()},
\code{\link{chk_scalar}()},
\code{\link{chk_string}()},
\code{\link{chk_whole_number}()}
}
\concept{chk_scalars}
