% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_treeshap_minimal_port.r
\name{treeshap}
\alias{treeshap}
\title{Calculate SHAP values of a tree ensemble model.}
\source{
\strong{treeshap}, \url{https://github.com/ModelOriented/treeshap}
}
\usage{
treeshap(unified_model, x, interactions = FALSE, verbose = TRUE)
}
\arguments{
\item{unified_model}{Unified data.frame representation of the model created with a (model).unify function. A \code{\link{model_unified.object}} object.}

\item{x}{Observations to be explained. A \code{data.frame} or \code{matrix} object with the same columns as in the training set of the model. Keep in mind that objects different than \code{data.frame} or plain \code{matrix} will cause an error or unpredictable behavior.}

\item{interactions}{Whether to calculate SHAP interaction values. By default is \code{FALSE}. Basic SHAP values are always calculated.}

\item{verbose}{Whether to print progress bar to the console. Should be logical. Progress bar will not be displayed on Windows.}
}
\value{
A \code{\link{treeshap.object}} object. SHAP values can be accessed with \code{$shaps}. Interaction values can be accessed with \code{$interactions}.
}
\description{
Calculate SHAP values and optionally SHAP Interaction values.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Fit a model:
rf_fit <- default_rf(X, Y)
unified_model <- unify_tree_model(rf_fit, X)

## Calculate SHAP explanation for X, a subset, or OOS observations. 
shaps <- treeshap(unified_model, head(X, 3))
str(shaps)
}
\seealso{
\code{\link{unify_tree_model}}, a wrapper function unifying these models.
\code{\link{xgboost.unify}} for \code{XGBoost models}
\code{\link{lightgbm.unify}} for \code{LightGBM models}
\code{\link{gbm.unify}} for \code{GBM models}
\code{\link{randomForest.unify}} for \code{randomForest models}
\code{\link{ranger.unify}} for \code{ranger models}
}
\author{
Konrad Komisarczyk, Przemyslaw Biecek, et al.
}
