% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{manip_var_of_attr_df}
\alias{manip_var_of_attr_df}
\title{Find the manip var from a given attr_df}
\usage{
manip_var_of_attr_df(attr_df, primary_obs, comparison_obs)
}
\arguments{
\item{attr_df}{A data frame of local explanation attributions,
such as a return from \code{attr_df_treeshap()}.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line.}
}
\value{
A single number of the variable with the largest difference.
}
\description{
Find the number of the variable with the largest difference between the
primary and comparison observations.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model and treeSHAP explanation:
rf_fit  <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)

## Suggest the number of a variable to manipulate:
manip_var_of_attr_df(shap_df, primary_obs = 1, comparison_obs = 2)
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{basis_attr_df}()},
\code{\link{color_scale_of}()},
\code{\link{does_contain_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()}
}
\concept{cheem utility}
