% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_treeshap_minimal_port.r
\name{gbm.unify}
\alias{gbm.unify}
\title{Unify GBM model}
\source{
\strong{treeshap}, \url{https://github.com/ModelOriented/treeshap}
}
\usage{
gbm.unify(gbm_model, data)
}
\arguments{
\item{gbm_model}{An object of \code{gbm} class. At the moment, models built on data with categorical features
are not supported - please encode them before training.}

\item{data}{Reference dataset. A \code{data.frame} or \code{matrix} with the same columns as in the training set of the model. Usually dataset used to train model.}
}
\value{
a unified model representation - a \code{\link{model_unified.object}} object
}
\description{
Convert your GBM model into a standardized representation.
The returned representation is easy to be interpreted by the user and ready to be used as an argument in \code{treeshap()} function.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Fit a model:
gbm_model <- gbm::gbm(
  formula = Y ~ .,
  data = data.frame(X, Y),
  distribution = "gaussian",
  n.trees = 50,
  interaction.depth = 4,
  n.cores = 1)
unified_model <- gbm.unify(gbm_model, X)

## Calculate treeSHAP: 
shaps <- treeshap(unified_model, X[1:2,])
str(shaps)
}
\seealso{
\code{\link{unify_tree_model}}, a wrapper function unifying these models.
\code{\link{lightgbm.unify}} for \code{\link[lightgbm:lightgbm]{LightGBM models}}
\code{\link{xgboost.unify}} for \code{\link[xgboost:xgboost]{XGBoost models}}
\code{\link{ranger.unify}} for \code{\link[ranger:ranger]{ranger models}}
\code{\link{randomForest.unify}} for \code{\link[randomForest:randomForest]{randomForest models}}
}
\author{
Konrad Komisarczyk, Przemyslaw Biecek, et al.
}
