% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{color_scale_of}
\alias{color_scale_of}
\alias{colour_scale_of}
\title{Suggest a color and fill scale.}
\usage{
color_scale_of(x, mid_pt = 0, limits = NULL, ...)
}
\arguments{
\item{x}{A vector to to scale the color to.}

\item{mid_pt}{A single number checking divergence from. Defaults to 0.}

\item{limits}{A vector of the min and max values for the scale.
Useful for setting an absolute range, such as (-1, 1) for attribution/y
correlation of each point. Points outside of limits show as default grey.
Defaults to NULL; the range of x.}

\item{...}{Optional other arguments passed to ggplot2::continuous_scale
or ggplot2::discrete_scale.}
}
\value{
A list containing a scale_color, and scale_fill;
the suggested color/fill scale for a ggplot.
}
\description{
Whether or not a vector is a diverges a value, returns a logical.
Used to help default a scale_color for ggplot2.
}
\examples{
library(cheem)
library(ggplot2)
g <- ggplot(mtcars, aes(disp, mpg))

## Discrete
g + geom_point(aes(color = factor(vs))) +
  color_scale_of(mtcars$vs) 
## Sequential increasing
g + geom_point(aes(color = mpg)) +
  color_scale_of(mtcars$mpg)
## Dummy sequential decr
g + geom_point(aes(color = -1 *mpg)) +
  color_scale_of(-1 * mtcars$mpg)
## Dummy diverging
g + geom_point(aes(color = mpg - median(mpg))) +
  color_scale_of(mtcars$mpg - median(mtcars$mpg))
## Dummy limits
g + geom_point(aes(color = mpg - median(mpg))) +
  color_scale_of(mtcars$mpg - median(mtcars$mpg), limits = c(-5, 5))
}
\seealso{
Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{basis_attr_df}()},
\code{\link{does_contain_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{manip_var_of_attr_df}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()}
}
\concept{cheem utility}
