% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asInteger.R
\name{asInteger}
\alias{asCount}
\alias{asInt}
\alias{asInteger}
\title{Convert an argument to an integer}
\usage{
asInteger(x, ..., tol = sqrt(.Machine$double.eps), add = NULL,
  .var.name = vname(x))

asCount(x, na.ok = FALSE, positive = FALSE,
  tol = sqrt(.Machine$double.eps), add = NULL, .var.name = vname(x))

asInt(x, na.ok = FALSE, lower = -Inf, upper = Inf,
  tol = sqrt(.Machine$double.eps), add = NULL, .var.name = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to convert.}

\item{...}{[any]\cr
Additional arguments passed to \code{\link{assertIntegerish}}.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in error messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{na.ok}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{FALSE}.}

\item{positive}{[\code{logical(1)}]\cr
Must \code{x} be positive (>= 1)?
Default is \code{FALSE}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}
}
\value{
Converted \code{x}.
}
\description{
\code{asInteger} is intended to be used for vectors while \code{asInt} is
a specialization for scalar integers and \code{asCount} for scalar
non-negative integers.
Convertible are (a) atomic vectors with all elements \code{NA}
and (b) double vectors with all elements being within \code{tol}
range of an integer.
}
\examples{
asInteger(c(1, 2, 3))
asCount(1)
asInt(1)
}

