% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkEnvironment.r
\name{checkEnvironment}
\alias{assertEnvironment}
\alias{assert_environment}
\alias{checkEnvironment}
\alias{expect_environment}
\alias{testEnvironment}
\alias{test_environment}
\title{Check if an argument is an environment}
\usage{
checkEnvironment(x, contains = character(0L))

assertEnvironment(x, contains = character(0L), add = NULL, .var.name)

assert_environment(x, contains = character(0L), add = NULL, .var.name)

testEnvironment(x, contains = character(0L))

test_environment(x, contains = character(0L))

expect_environment(x, contains = character(0L), info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{contains}{[\code{character}]\cr
Vector of object names expected in the environment.
Defaults to \code{character(0)}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertEnvironment}/\code{assert_environment}
 throws an error message, \code{testEnvironment}/\code{test_environment}
 returns \code{FALSE},
 and \code{checkEnvironment} returns a string with the error message.
 The function \code{expect_environment} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is an environment
}
\examples{
ee = as.environment(list(a = 1))
testEnvironment(ee)
testEnvironment(ee, contains = "a")
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomicVector}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}}, \code{\link{checkFactor}},
  \code{\link{checkFunction}},
  \code{\link{checkIntegerish}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNumeric}}, \code{\link{checkVector}}
}

