#' ChatGPT: Create Variable Name
#'
#' @param code The code for which to give a variable name to its result. If not provided, it will
#'   use what's copied on the clipboard.
#'
#' @examples
#' \dontrun{
#' cat(create_variable_name("sapply(1:10, function(i) i ** 2)"))
#' }
#'
#' @importFrom clipr read_clip
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
create_variable_name <- function(code = clipr::read_clip(allow_non_interactive = TRUE)) {
  code <- paste(gsub('"', "'", code), collapse = "\n")
  prompt <- paste0('Give a good variable name to the result of the following R code: "', code, '"')
  parse_response(gpt_get_completions(prompt))
}
