% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Edges.R
\name{plotEdges}
\alias{plotEdges}
\title{Plot some edges}
\usage{
plotEdges(
  vertices,
  edges,
  color = "black",
  lwd = 2,
  edgesAsTubes = TRUE,
  tubesRadius = 0.03,
  verticesAsSpheres = TRUE,
  only = NULL,
  spheresRadius = 0.05,
  spheresColor = color
)
}
\arguments{
\item{vertices}{a three-columns matrix giving the coordinates of the vertices}

\item{edges}{a two-columns integer matrix giving the edges by pairs of
vertex indices}

\item{color}{a color for the edges}

\item{lwd}{line width, a positive number, ignored if \code{edgesAsTubes=TRUE}}

\item{edgesAsTubes}{Boolean, whether to draw the edges as tubes}

\item{tubesRadius}{the radius of the tubes when \code{edgesAsTubes=TRUE}}

\item{verticesAsSpheres}{Boolean, whether to draw the vertices as spheres}

\item{only}{integer vector made of the indices of the vertices you want
to plot (as spheres), or \code{NULL} to plot all vertices}

\item{spheresRadius}{the radius of the spheres when
\code{verticesAsSpheres=TRUE}}

\item{spheresColor}{the color of the spheres when
\code{verticesAsSpheres=TRUE}}
}
\value{
No value, just produces a 3D graphic.
}
\description{
Plot the given edges with \strong{rgl}.
}
\examples{
library(cgalMeshes)
library(rgl)

mesh <- cgalMesh$new(pentagrammicPrism, clean = FALSE)
vertices <- mesh$vertices()
edges <- mesh$edges()
extEdges <- exteriorEdges(edges)
tmesh <- mesh$triangulate()$getMesh(normals = FALSE)

\donttest{open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.9)
shade3d(tmesh, color = "navy")
# we plot the exterior edges only
plotEdges(
  vertices, extEdges, color = "gold",
  tubesRadius = 0.02, spheresRadius = 0.02
)}

# or only plot the edges whose corresponding dihedral angle is acute:
sharpEdges <- as.matrix(subset(edges, angle <= 91, select = c("i1", "i2")))
open3d(windowRect = 50 + c(0, 0, 512, 512), zoom = 0.9)
shade3d(tmesh, color = "maroon")
plotEdges(
  vertices, sharpEdges, color = "darkred", 
  tubesRadius = 0.02, spheresRadius = 0.02
)
}
