% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-schema.R
\name{cff_schema}
\alias{cff_schema}
\alias{cff_schema_keys}
\alias{cff_schema_keys_license}
\alias{cff_schema_definitions_person}
\alias{cff_schema_definitions_entity}
\alias{cff_schema_definitions_refs}
\title{Schema utils}
\source{
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Guide to Citation File Format schema version 1.2.0}.
}
\usage{
cff_schema_keys(sorted = FALSE)

cff_schema_keys_license()

cff_schema_definitions_person()

cff_schema_definitions_entity()

cff_schema_definitions_refs()
}
\arguments{
\item{sorted}{Logical \code{TRUE/FALSE}. Should the keys be arranged
alphabetically?}
}
\value{
A vector of characters with the names of the valid keys to be used on a
Citation File Format version 1.2.0
}
\description{
Helper functions with the valid values of different fields, according to the
\href{https://github.com/citation-file-format/citation-file-format/blob/main/schema-guide.md}{Citation File Format schema version 1.2.0}.
\itemize{
\item \code{\link[=cff_schema_keys]{cff_schema_keys()}} provides the valid high-level keys of the Citation
File Format.
\item \code{\link[=cff_schema_keys_license]{cff_schema_keys_license()}} provides the valid
\href{https://spdx.dev/ids/}{SPDX license identifier(s)} to be used on the
\code{CITATION.cff} file.
\item \code{\link[=cff_schema_definitions_person]{cff_schema_definitions_person()}} and \code{\link[=cff_schema_definitions_entity]{cff_schema_definitions_entity()}}
returns the valid fields to be included when defining a
person or entity.
\item \code{\link[=cff_schema_definitions_refs]{cff_schema_definitions_refs()}} provides the valid
keys to be used on the \code{preferred-citation} and \code{references} keys.
}
}
\examples{

cff_schema_keys(sorted = TRUE)

# Valid Licenses keys
head(cff_schema_keys_license(), 20)

cff_schema_definitions_person()

cff_schema_definitions_entity()

cff_schema_definitions_refs()
}
\concept{schemas}
