% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_ratings_sp}
\alias{cfbd_ratings_sp}
\title{\strong{Get SP historical rating data}}
\usage{
cfbd_ratings_sp(year = NULL, team = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}
}
\value{
\code{\link[=cfbd_ratings_sp]{cfbd_ratings_sp()}} - A data frame with 26 variables:
\describe{
\item{\code{year}: integer.}{Season of the ratings.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{rating}: double.}{SP+ rating.}
\item{\code{ranking}: integer.}{Ranking in the SP+ ratings.}
\item{\code{second_order_wins}: logical.}{Total second-order wins - Not available for recent seasons.}
\item{\code{sos}: logical.}{Strength of schedule - Not available for recent seasons.}
\item{\code{offense_ranking}: integer.}{Overall offense ranking.}
\item{\code{offense_rating}: double.}{Overall offense rating.}
\item{\code{offense_success}: logical.}{Offense success rating - Not available for recent seasons.}
\item{\code{offense_explosiveness}: logical.}{Offense explosiveness rating - Not available for recent seasons.}
\item{\code{offense_rushing}: logical.}{Offense rushing rating - Not available for recent seasons.}
\item{\code{offense_passing}: logical.}{Offense passing rating - Not available for recent seasons.}
\item{\code{offense_standard_downs}: logical.}{Offense standard downs rating - Not available for recent seasons.}
\item{\code{offense_passing_downs}: logical.}{Offensive passing downs rating - Not available for recent seasons.}
\item{\code{offense_run_rate}: logical.}{Offense rushing rate - Not available for recent seasons.}
\item{\code{offense_pace}: logical.}{Offense pace factor - Not available for recent seasons.}
\item{\code{defense_ranking}: integer.}{Overall defense ranking.}
\item{\code{defense_rating}: double.}{Overall defense rating.}
\item{\code{defense_success}: logical.}{Defense success rating - Not available for recent seasons.}
\item{\code{defense_explosiveness}: logical.}{Defense explosiveness rating - Not available for recent seasons.}
\item{\code{defense_rushing}: logical.}{Defense rushing rating - Not available for recent seasons.}
\item{\code{defense_passing}: logical.}{Defense passing rating - Not available for recent seasons.}
\item{\code{defense_standard_downs}: logical.}{Defense standard downs rating - Not available for recent seasons.}
\item{\code{defense_passing_downs}: logical.}{Defensive passing downs rating - Not available for recent seasons.}
\item{\code{defense_havoc_total}: logical.}{Total defensive havoc rate - Not available for recent seasons.}
\item{\code{defense_havoc_front_seven}: logical.}{Defense havoc rate from front 7 players - Not available for recent seasons.}
\item{\code{defense_havoc_db}: logical.}{Defense havoc rate from defensive backs - Not available for recent seasons.}
\item{\code{special_teams_rating}: double.}{Special teams rating.}
}
}
\description{
At least one of \strong{year} or \strong{team} must be specified for the function to run
}
\examples{
\donttest{
  try(cfbd_ratings_sp(year = 2018))

  try(cfbd_ratings_sp(team = "Texas A&M"))

  try(cfbd_ratings_sp(year = 2019, team = "Texas"))
}

}
\keyword{SP+}
