% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GNPC.R
\name{GNPC}
\alias{GNPC}
\title{General nonparametric classification method}
\usage{
GNPC(
  dat,
  Q,
  initiate = "AND",
  min.change = 0.001,
  maxitr = 1000,
  verbose = TRUE
)
}
\arguments{
\item{dat}{A \emph{N} individuals x \emph{J} items (\code{matrix} or \code{data.frame}). Missing values need to be coded as \code{NA}. Caution is advised if missing data are present.}

\item{Q}{A \emph{J} items x \emph{K} attributes Q-matrix (\code{matrix} or \code{data.frame}).}

\item{initiate}{Should the conjunctive (\code{"AND"}) or disjunctive (\code{"OR"}) NPC be used to initiate the procedure? Default is \code{"AND"}.}

\item{min.change}{Minimum proportion of modified attribute profiles to use as a stopping criterion. Default is .001.}

\item{maxitr}{Maximum number of iterations. Default is 1000.}

\item{verbose}{Print information after each iteration. Default is \code{TRUE}.}
}
\value{
\code{GNPC} returns an object of class \code{GNPC}.
\describe{
\item{\code{alpha.est}}{Estimated attribute profiles (\code{matrix}).}
\item{\code{loss.matrix}}{The distances between the weighted ideal responses from each latent class (rows) and examinees' observed responses (columns) (\code{matrix}).}
\item{\code{eta.w}}{The weighted ideal responses for each latent class (rows) on each item (columns) (\code{matrix}).}
\item{\code{w}}{The estimated weights, used to compute the weighted ideal responses (\code{matrix}).}
\item{\code{n.ite}}{Number of iterations required to achieve convergence (\code{double}).}
\item{\code{hist.change}}{Proportion of modified attribute profiles in each iteration (\code{vector}).}
\item{\code{specifications}}{Function call specifications (\code{list}).}
}
}
\description{
Attribute profile estimation using the \emph{general nonparametric classification method} (GNPC; Chiu, Sun, & Bian, 2018).
The GNPC can be considered as a robust alternative to the parametric G-DINA model with low sample sizes.
The \code{AlphaNP} function from the \code{NPCD} package (Zheng & Chiu, 2019; Chiu, Sun, & Bian, 2018) using weighted Hamming distances is used to initiate the procedure.
}
\examples{
\donttest{
library(GDINA)
Q <- sim30GDINA$simQ # Q-matrix
K <- ncol(Q)
J <- nrow(Q)
set.seed(123)
GS <- data.frame(guessing = rep(0.1, J), slip = rep(0.1, J))
sim <- simGDINA(200, Q, GS)
simdat <- sim$dat # Simulated data
simatt <- sim$attribute # Generating attributes
fit.GNPC <- GNPC(simdat, Q) # Apply the GNPC method
ClassRate(fit.GNPC$alpha.est, simatt) # Check classification accuracy
}
}
\references{
Chiu, C.-Y., & Douglas, J. (2013). A nonparametric approach to cognitive diagnosis by proximity to ideal response patterns. \emph{Journal of Classification}, \emph{30}, 225-250. DOI: 10.1007/s00357-013-9132-9

Chiu, C.-Y., Sun, Y., & Bian, Y. (2018). Cognitive diagnosis for small education programs: The general nonparametric classification method. \emph{Psychometrika}, \emph{83}, 355-375. DOI: 10.1007/s11336-017-9595-4

Zheng, Y., & Chiu, C.-Y. (2019). \emph{NPCD: Nonparametric methods for cognitive diagnosis}. R package version 1.0-11. https://cran.r-project.org/web/packages/NPCD/.
}
\author{
{Pablo Nájera, Universidad Pontificia Comillas}
}
