% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrPlot.R
\name{plot.cdfqr}
\alias{plot.cdfqr}
\title{Plot Fitted Values/Residuals of A Cdfqr Object or Distribution}
\usage{
\method{plot}{cdfqr}(
  x,
  mu = NULL,
  sigma = NULL,
  theta = NULL,
  fd = NULL,
  sd = NULL,
  n = 10000,
  inner = TRUE,
  version = "V",
  type = c("fitted"),
  ...
)
}
\arguments{
\item{x}{If the plot is based on the fitted values, provide a fitted cdfqr object, alternatively, mu and sigma, and the distribution can be specified.}

\item{mu}{Location parameter value}

\item{sigma}{Sigma parameter value}

\item{theta}{Skew parameter value}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the sub-family distribution.}

\item{n}{The number of random variates to be generated for user specified plot.}

\item{inner}{If finite-tailed distribution is used: a logic value that indicates if the inner (\code{inner = TRUE}) case or outer (\code{inner = FALSE}) will be used. Currently inner case can only be used for 2-parameter distributions.}

\item{version}{If finite-tailed distribution is used: A string indicates that which version will be used. "V" is the tilt parameter function while "W" indicates the Jones Pewsey transformation.}

\item{type}{Currently only fitted values are available for generating plots.}

\item{...}{other plot parameters pass onto \code{\link[graphics]{plot}}.}
}
\description{
Plot Fitted Values/Residuals of A cdfqr Object or Distribution
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2','t2', data = JurorData)
plot(fit)


}
