#' cde: Download Water Framework Directive (WFD) data from the 
#' Environment Agency Catchment Data Explorer (CDE) website.
#'
#' Facilitates searching and download of the WFD-related
#' data for all waterbodies within the Environment Agency area (i.e. England).
#' The types of data that can be downloaded are: WFD status classification 
#' data, Reasons for Not Achieving Good (RNAG) status, objectives set for 
#' waterbodies, measures put in place to improve water quality and details 
#' of associated protected areas. Default plots can also be produced from the 
#' data downloaded (form of plot depends on data type).
#'
#' The website that is accessed is: 
#' \url{https://environment.data.gov.uk/catchment-planning/}.

#' The data accessed by and included within the package are made available 
#' under the Open Government Licence v3.0 
#' \url{https://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/}
#'
#' @docType package
#'
#' @name cde
NULL
