% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdcsis.R
\name{cdcsis}
\alias{cdcsis}
\title{Conditional Distance Correlation Sure Independence Screening (CDC-SIS)}
\usage{
cdcsis(
  x,
  y,
  z = NULL,
  width,
  threshold = nrow(y),
  distance = FALSE,
  index = 1,
  num.threads = 1
)
}
\arguments{
\item{x}{a numeric matrix, or a list which contains multiple numeric matrix}

\item{y}{a numeric vector, matrix, or \code{dist} object}

\item{z}{\code{z} is a numeric vector or matrix. It is the variable being conditioned.}

\item{width}{a user-specified positive value (univariate conditional variable) or vector (multivariate conditional variable) for 
gaussian kernel bandwidth. Its default value is relies on \code{stats::bw.nrd0} function when conditional variable is univariate, 
\code{ks::Hpi.diag} when conditional variable with at most trivariate, and \code{stats::bw.nrd} on the other cases.}

\item{threshold}{the threshold of the number of predictors recuited by CDC-SIS. 
Should be less than or equal than the number of column of \code{x}. Default value \code{threshold} is sample size.}

\item{distance}{if \code{distance = TRUE}, only \code{y} will be considered as distance matrices. Default: \code{distance = FALSE}}

\item{index}{exponent on Euclidean distance, in \eqn{(0,2]}}

\item{num.threads}{number of threads. Default \code{num.threads = 1}.}
}
\value{
\item{ ix }{the vector of indices selected by CDC-SIS } 
\item{ cdcor }{ the conditional distance correlation for each univariate/multivariate variable in \code{x}}
}
\description{
Performs conditional distance correlation sure independence screening (CDC-SIS).
}
\examples{
\dontrun{

library(cdcsis)

########## univariate explanative variables ##########
set.seed(1)
num <- 100
p <- 150
x <- matrix(rnorm(num * p), nrow = num)
z <- rnorm(num)
y <- 3 * x[, 1] + 1.5 * x[, 2] + 4 * z * x[, 5] + rnorm(num)
res <- cdcsis(x, y, z)
head(res[["ix"]], n = 10)

########## multivariate explanative variables ##########
x <- as.list(as.data.frame(x))
x <- lapply(x, as.matrix)
x[[1]] <- cbind(x[[1]], x[[2]])
x[[2]] <- NULL
res <- cdcsis(x, y, z)
head(res[["ix"]], n = 10)

########## multivariate response variables ##########
num <- 100
p <- 150
x <- matrix(rnorm(num * p), nrow = num)
z <- rnorm(num)
y1 <- 3 * x[, 1] + 5 * z * x[, 4] + rnorm(num)
y2 <- 3 * x[, 2] + 5 * x[, 3] + 2 * z + rnorm(num)
y <- cbind(y1, y2)
res <- cdcsis(x, y, z)
head(res[["ix"]], n = 10)
}
}
\references{
Wen, C., Pan, W., Huang, M. and Wang, X., 2018. Sure independence screening adjusted for confounding covariates with ultrahigh-dimensional data. Statistica Sinica, 28, pp.293-317. URL http://www3.stat.sinica.edu.tw/statistica/J28N1/J28N114/J28N114.html
}
\seealso{
\code{\link{cdcor}}
}
\author{
Canhong Wen, Wenliang Pan, Mian Huang, and Xueqin Wang
}
