% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage-map.r
\name{cdc_basemap}
\alias{cdc_basemap}
\title{Retrieve CDC U.S. Basemaps}
\usage{
cdc_basemap(basemap = c("national", "hhs", "census", "states", "spread",
  "surv"))
}
\arguments{
\item{basemap}{select the CDC basemap. One of:
\itemize{
\item "\code{national}": outline of the U.S. + AK, HI, PR + VI
\item "\code{hhs}": outline of the U.S. + HHS Region Outlines + AK, HI, PR + VI
\item "\code{census}": outline of the U.S. + Census Region Outlines + AK, HI, PR + VI
\item "\code{states}": outline of the U.S. + State Outlines + AK, HI, PR + VI
\item "\code{spread}": outline of the U.S. + State Outlines + AK, HI, PR + VI & Guam
\item "\code{surv}": outline of the U.S. + State Outlines + AK, HI, PR + VI
}}
}
\description{
The CDC FluView application uses a composite basemaps of coverage areas
within the United States that elides and scales Alaska, Hawaii,
Puerto Rico & the Virgin Islands and some further provide elided and scaled
breakouts for New York City and the District of Columbia.\cr
\cr
This function retrieves the given shapefile, projects to EPSG:5069 and
returns it as an \code{sf} (simple features) object.
}
\note{
These are just the basemaps. You need to pair it with the data you wish to visualize.
}
\examples{
\dontrun{
plot(cdc_basemap("national"))
}
}
