% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callNCW.R
\name{callNCW}
\alias{callNCW}
\title{Calculate normalized consensus weight(NCW) matrix based on permutation.}
\usage{
callNCW(
  title,
  label,
  nperm = 10,
  ncore = 1,
  seedn = 100,
  stability = TRUE,
  plot = NULL
)
}
\arguments{
\item{title}{A character value for output directory. Directory is created only if not existed. This title can be an abosulte or relative path.}

\item{label}{A matrix or data frame of input labels, columns=different clustering results and rows are samples.}

\item{nperm}{A integer value of the permutation numbers, or nperm=10(default), which means \code{nperm}*1000 times of permutation.}

\item{ncore}{A integer value of cores to use, or ncore=1 (default). It's the input core numbers for the parallel computation in this package \code{parallel}.}

\item{seedn}{A numerical value to set the start random seed for reproducible results, or seedn=100 (default). For every 1000 iteration, the seed will +1 to get repeat results.}

\item{stability}{A logical value. Should estimate the stability of normalized consensus weight based on permutation numbers (default stability=TRUE), or not?}

\item{plot}{character value. NULL(default) - print to screen, 'pdf', 'png', 'pngBMP' for bitmap png, helpful for large datasets, or 'pdf'. Input for \code{randConsensusMatrix}.}
}
\value{
A matrix of normalized consensus weights.
}
\description{
Calculate normalized consensus weight(NCW) matrix based on permutation.
}
\examples{

# load data
data(example_data)
label=example_data

# if plot is not NULL, results will be saved in "result_output" directory
title="result_output"

\donttest{
# run ncw
ncw<-callNCW(title=title,label=label,stability=TRUE,nperm=4,ncore=1)
}

}
