% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccml.R
\name{ccml}
\alias{ccml}
\title{A two-step consensus clustering inputing multiple predictive labels with different sample coverages (missing labels)}
\usage{
ccml(
  title,
  label,
  output = "rdata",
  nperm = 10,
  ncore = 1,
  seedn = 100,
  stability = TRUE,
  maxK = 15,
  reps = 1000,
  pItem = 0.9,
  plot = NULL,
  clusterAlg = "spectralClusteringAffinity",
  innerLinkage = "complete",
  ...
)
}
\arguments{
\item{title}{A character value for output directory. Directory is created only if not existed. This title can be an abosulte or relative path. Input for \code{callNCW, plotCompareCW, ConsensusClusterPlus::ConsensusClusterPlus, ConsensusClusterPlus::calcICL}}

\item{label}{A matrix or data frame of input labels or a character value of input file name, columns=different clustering results and rows are samples. \code{label} could be import as '.rdata', '.rda', or '.csv'. Input for \code{callNCW, plotCompareCW}}

\item{output}{A character value for output format, or "rdata"(default) as save to .rdata, others will return to workspace.}

\item{nperm}{A integer value of the permutation numbers, or nperm=10(default), which means \code{nperm}*1000 times of permutation. Input for \code{callNCW}}

\item{ncore}{A integer value of cores to use, or ncore=1 (default). It's the input core numbers for the parallel computation in this package \code{parallel}. Input for \code{callNCW}}

\item{seedn}{A numerical value to set the start random seed for reproducible results, or seedn=100 (default). For every 1000 iteration, the seed will +1 to get repeat results. Input for \code{callNCW, ConsensusClusterPlus::ConsensusClusterPlus}}

\item{stability}{A logical value. Should estimate the stability of normalized consensus weight based on permutation numbers (default stability=TRUE), or not? Input for \code{callNCW}}

\item{maxK}{integer value. maximum cluster number to evaluate. Input for \code{ConsensusClusterPlus::ConsensusClusterPlus} for the consensus clustering based on normalized consensus weights.}

\item{reps}{integer value. number of subsamples. Input for \code{ConsensusClusterPlus::ConsensusClusterPlus}}

\item{pItem}{numerical value. proportion of items to sample. Input for \code{ConsensusClusterPlus::ConsensusClusterPlus}}

\item{plot}{character value. NULL(default) - print to screen, 'pdf', 'png', 'pngBMP' for bitmap png, helpful for large datasets, or 'pdf'. Input for \code{ConsensusClusterPlus::ConsensusClusterPlus, ConsensusClusterPlus::calcICL,callNCW,plotCompareCW}}

\item{clusterAlg}{character value. cluster algorithm. 'spectralClusteringAffinity' for spectral clustering of similarity/affinity matrix(default), other methods for clustering of distance matrix, 'hc' heirarchical (hclust), 'pam' for paritioning around medoids,
'km' for k-means upon data matrix, 'kmdist' for k-means upon distance matrices (former km option), or a function that returns a clustering. Input for \code{ConsensusClusterPlus::ConsensusClusterPlus}.}

\item{innerLinkage}{heirarchical linkage method for subsampling, or "complete"(default). Input for \code{ConsensusClusterPlus::ConsensusClusterPlus}}

\item{...}{Other input arguments for \code{ConsensusClusterPlus::ConsensusClusterPlus}}
}
\value{
A list of three items
\itemize{
\item ncw - A matrix of normalized consensus weights. Output from \code{callNCW}.
\item fcluster - A list of length maxK. Each element is a list containing consensusMatrix (numerical matrix), consensusTree (hclust), consensusClass (consensus class asssignments). ConsensusClusterPlus also produces images. Output from \code{ConsensusClusterPlus::ConsensusClusterPlus}
\item icl a list of two elements clusterConsensus and itemConsensus corresponding to cluster-consensus and item-consensus. Output from \code{ConsensusClusterPlus::ConsensusClusterPlus}
}
}
\description{
A two-step consensus clustering inputing multiple predictive labels with different sample coverages (missing labels)
}
\examples{

# load data
data(example_data)
label=example_data

# run ccml
title="output"

\donttest{
# not estimate stability of permutation numbers.
res_1=ccml(title=title,label=label,nperm = 3,ncore=1,stability=FALSE,maxK=3,pItem=0.8)

# other methods for clustering of distance matrix
res_2<-ccml(title=title,label=label,nperm = 10,ncore=1,stability=FALSE,maxK=3,
            pItem=0.9,clusterAlg = "hc")

# not output as "rdata"
res_3<-ccml(title=title,label=label,output=FALSE,nperm = 5,ncore=1,stability=TRUE,maxK=3,
           pItem=0.9)
}

}
