% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs-batch.R
\name{get_msready_by_formula_batch}
\alias{get_msready_by_formula_batch}
\title{Get msready by formula batch search}
\usage{
get_msready_by_formula_batch(
  formula_list = NULL,
  API_key = NULL,
  rate_limit = 0L,
  verbose = FALSE
)
}
\arguments{
\item{formula_list}{A list of strings denoting the input chemicals formulas}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between each request}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A named list of character lists of DTXSIDs with chemical formulas
matching the search criteria
}
\description{
Get msready by formula batch search
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull msready data for several chemical formulas
msready_data <- get_msready_by_formula_batch(formula_list = c('C16H24N2O5S',
                                                              'C15H16O2'))
\dontshow{\}) # examplesIf}
}
