% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_search.R
\name{cbs_search}
\alias{cbs_search}
\title{Find tables containing search words}
\usage{
cbs_search(
  query,
  catalog = "CBS",
  language = "nl",
  format = c("datasets", "docs", "raw"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{query}{\code{character} with the words to search for.}

\item{catalog}{the subset in which the table is to be found, see
\code{\link[=cbs_get_catalogs]{cbs_get_catalogs()}}, set to \code{NULL} to query all catalogs.}

\item{language}{should the \code{"nl"} (Dutch) or \code{"en"} (English) search index
be used.}

\item{format}{format in which the result should be returned, see details}

\item{verbose}{\code{logical} should the communication with the server be shown?}

\item{...}{not used}
}
\description{
Find tables containing search words.
}
\details{
The \code{format} can be either:
\itemize{
\item \code{datasets}: the same format as \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}, with an extra \code{score} column.
\item \code{docs}: the table results from the solr query,
\item \code{raw}: the complete results from the solr query.
}
}
\examples{
if (interactive()){
  # search for tables containing the word birth
  
  ds_en <- cbs_search("Birth", language="en")
  ds_en[1:3, c("Identifier", "ShortTitle")]
  
  # or in Dutch
  
  ds_nl <- cbs_search(c("geboorte"), language="nl")
  ds_nl[1:3, c("Identifier", "ShortTitle")]
  
  # Search in an other catalog
  ds_rivm <- cbs_search(c("geboorte"), catalog = "RIVM", language="nl")
  ds_rivm[1:3, c("Identifier", "ShortTitle")]
  
  # search in all catalogs
  ds_all <- cbs_search(c("geboorte"), catalog = NULL, language="nl")

  # docs
  docs <- cbs_search(c("geboorte,sterfte"), language="nl", format="docs")
  names(docs)
  docs[1:2,]
  
  #raw 
  raw_res <- cbs_search(c("geboorte,sterfte"), language="nl", format="raw")
  raw_res
}
}
