% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_get_data.R
\name{cbs_get_data}
\alias{cbs_get_data}
\title{Get data from Statistics Netherlands (CBS)}
\usage{
cbs_get_data(
  id,
  ...,
  catalog = "CBS",
  select = NULL,
  typed = TRUE,
  add_column_labels = TRUE,
  dir = tempdir(),
  verbose = FALSE,
  base_url = getOption("cbsodataR.base_url", BASE_URL),
  include_ID = FALSE
)
}
\arguments{
\item{id}{Identifier of table, can be found in \code{\link[=cbs_get_toc]{cbs_get_toc()}}}

\item{...}{optional filter statements, see details.}

\item{catalog}{catalog id, can be retrieved with \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}}

\item{select}{\code{character} optional, columns to select}

\item{typed}{Should the data automatically be converted into integer and numeric?}

\item{add_column_labels}{Should column titles be added as a label (TRUE) which are visible in \code{View}}

\item{dir}{Directory where the table should be downloaded. Defaults to temporary
directory}

\item{verbose}{Print extra messages what is happening.}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}

\item{include_ID}{Should the data include the ID column for the rows?}
}
\value{
\code{data.frame} with the requested data. Note that a csv copy of
the data is stored in \code{dir}.
}
\description{
Retrieves data from a table of Statistics Netherlands. A list of available tables
can be retrieved with \code{\link[=cbs_get_toc]{cbs_get_toc()}}. Use the \code{Identifier} column of
\code{cbs_get_toc} as \code{id} in \code{cbs_get_data} and \code{cbs_get_meta}.
}
\details{
To reduce the download time, optionaly the data can be filtered on category values:
for large tables (> 100k records) this is a wise thing to do.

The filter is specified with (see examples below):
\itemize{
\item \verb{<column_name> = <values>} in which \verb{<values>} is a character vector.
Rows with values that are not part of the character vector are not returned.
\strong{Note that the values have to be values from the \verb{$Key} column of the corresponding meta data. These may contain trailing spaces...}
\item \verb{<column_name> = has_substring(x)} in which x is a character vector. Rows with values that
do not have a substring that is in x are not returned. Useful substrings are
"JJ", "KW", "MM" for Periods (years, quarters, months) and "PV", "CR" and "GM"
for Regions (provinces, corops, municipalities).
\item \verb{<column_name> = eq(<values>) | has_substring(x)}, which combines the two statements above.
}

By default the columns will be converted to their type (\code{typed=TRUE}).
CBS uses multiple types of missing (unknown, surpressed, not measured, missing): users
wanting all these nuances can use \code{typed=FALSE} which results in character columns.
}
\note{
All data are downloaded using \code{\link[=cbs_download_table]{cbs_download_table()}}
}
\examples{
\dontrun{
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = "2000MM03"     # March 2000
            , CPI     = "000000"       # Category code for total 
            )

# useful substrings:
## Periods: "JJ": years, "KW": quarters, "MM", months
## Regions: "NL", "PV": provinces, "GM": municipalities
  
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = has_substring("JJ")     # all years
            , CPI     = "000000"       # Category code for total 
            )

cbs_get_data( id      = "7196ENG"      # table id
            , Periods = c("2000MM03","2001MM12")     # March 2000 and Dec 2001
            , CPI     = "000000"       # Category code for total 
            )

# combine either this
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = has_substring("JJ") | "2000MM01" # all years and Jan 2001
            , CPI     = "000000"       # Category code for total 
            )

# or this: note the "eq" function
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = eq("2000MM01") | has_substring("JJ") # Jan 2000 and all years
            , CPI     = "000000"       # Category code for total 
            )
}
}
\seealso{
\code{\link[=cbs_get_meta]{cbs_get_meta()}}, \code{\link[=cbs_download_data]{cbs_download_data()}}

Other data retrieval: 
\code{\link{cbs_add_date_column}()},
\code{\link{cbs_add_label_columns}()},
\code{\link{cbs_download_data}()},
\code{\link{cbs_extract_table_id}()},
\code{\link{cbs_get_data_from_link}()}

Other query: 
\code{\link{eq}()},
\code{\link{has_substring}()}
}
\concept{data retrieval}
\concept{query}
