% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{eq}
\alias{eq}
\title{Detect codes in a column}
\usage{
eq(x, column = NULL)
}
\arguments{
\item{x}{exact code(s) to be matched in \code{column}}

\item{column}{name of column}
}
\value{
query object
}
\description{
Detects for codes in a column. \code{eq} filters the data set at CBS: rows that have
a code that is not in \code{x} are filtered out.
}
\examples{
\dontrun{
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = "2000MM03"     # March 2000
            , CPI     = "000000"       # Category code for total 
            )

# useful substrings:
## Periods: "JJ": years, "KW": quarters, "MM", months
## Regions: "NL", "PV": provinces, "GM": municipalities
  
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = has_substring("JJ")     # all years
            , CPI     = "000000"       # Category code for total 
            )

cbs_get_data( id      = "7196ENG"      # table id
            , Periods = c("2000MM03","2001MM12")     # March 2000 and Dec 2001
            , CPI     = "000000"       # Category code for total 
            )

cbs_get_data( id      = "7196ENG"      # table id
            , Periods = eq("2000MM01") | has_substring("JJ") # Jan 2000 and all years
            , CPI     = "000000"       # Category code for total 
            )
}
}
\seealso{
Other query: 
\code{\link{cbs_get_data}()},
\code{\link{has_substring}()}
}
\concept{query}
