% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_add_date_column.R
\name{cbs_add_date_column}
\alias{cbs_add_date_column}
\title{Convert the time variable into either a date or numeric.}
\usage{
cbs_add_date_column(x, date_type = c("Date", "numeric"), ...)
}
\arguments{
\item{x}{\code{data.frame} retrieved using \code{\link[=cbs_get_data]{cbs_get_data()}}}

\item{date_type}{Type of date column: "Date", "numeric. Numeric creates a fractional
number which signs the "middle" of the period. e.g. 2018JJ00 -> 2018.5 and
2018KW01 -> 2018.167. This is for the following reasons: otherwise 2018.0 could mean
2018, 2018 Q1 or 2018 Jan, and furthermore 2018.75 is a bit strange for 2018 Q4.
If all codes in the dataset have frequency "Y" the numeric output will be \code{integer}.}

\item{...}{future use.}
}
\value{
original dataset with two added columns: \code{<period>_date} and
\code{<period>_freq}. This last column is a factor with levels: \code{Y}, \code{Q} and \code{M}
}
\description{
Time periods in data of CBS are coded: yyyyXXww (e.g. 2018JJ00, 2018MM10, 2018KW02),
which contains year (yyyy), type (XX) and index (ww). \code{cbs_add_date_column} converts
these codes into a \code{\link[=Date]{Date()}} or \code{numeric}. In addition it adds
a frequency column denoting the type of the column.
}
\seealso{
Other data retrieval: \code{\link{cbs_add_label_columns}},
  \code{\link{cbs_download_data}},
  \code{\link{cbs_extract_table_id}},
  \code{\link{cbs_get_data_from_link}},
  \code{\link{cbs_get_data}}

Other meta data: \code{\link{cbs_add_label_columns}},
  \code{\link{cbs_download_meta}},
  \code{\link{cbs_get_meta}}
}
\concept{data retrieval}
\concept{meta data}
