% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_cdcorr.R
\name{cb.detect.caus_cdcorr}
\alias{cb.detect.caus_cdcorr}
\title{Causal Conditional Distance Correlation}
\usage{
cb.detect.caus_cdcorr(
  Ys,
  Ts,
  Xs,
  R = 1000,
  dist.method = "euclidean",
  distance = FALSE,
  seed = 1,
  num.threads = 1,
  retain.ratio = 0.05,
  ddx = FALSE
)
}
\arguments{
\item{Ys}{Either:
\itemize{
   \item{\code{[n, d]} matrix} the outcome variables with \code{n} samples in \code{d} dimensions. In this case, \code{distance} should be \code{FALSE}.
   \item{\code{[n, n]} \code{dist} object} a distance object for the \code{n} samples. In this case, \code{distance} should be \code{TRUE}.
}}

\item{Ts}{\code{[n]} the labels of the samples, with \code{K < n} levels, as a factor variable.}

\item{Xs}{\code{[n, r]} the \code{r} covariates/confounding variables, for each of the \code{n} samples.}

\item{R}{the number of repetitions for permutation testing. Defaults to \code{1000}.}

\item{dist.method}{the method used for computing distance matrices. Defaults to \code{"euclidean"}. Other options
can be identified by seeing the appropriate documention for the \code{method} argument for the \code{\link[stats]{dist}} function.}

\item{distance}{a boolean for whether (or not) \code{Ys} are already distance matrices. Defaults to \code{FALSE}, which
will use \code{dist.method} parameter to compute an \code{[n, n]} pairwise distance matrix for \code{Ys}.}

\item{seed}{a random seed to set. Defaults to \code{1}.}

\item{num.threads}{The number of threads for parallel processing (if desired). Defaults to \code{1}.}

\item{retain.ratio}{If the number of samples retained is less than \code{retain.ratio*n}, throws a warning. Defaults to \code{0.05}.}

\item{ddx}{whether to show additional diagnosis messages. Defaults to \code{FALSE}. Can help with debugging if unexpected results are obtained.}
}
\value{
a list, containing the following:
\itemize{
   \item{\code{Test}} The outcome of the statistical test, from \code{\link[cdcsis]{cdcov.test}}.
   \item{\code{Retained.Ids}} The sample indices retained after vertex matching, which correspond to the samples for which statistical inference is performed.
}
}
\description{
A function for implementing the causal conditional distance correlation (causal cDCorr) algorithm.
This algorithm allows users to identify whether a treatment causes changes in an outcome, given assorted
covariates/confounding variables. It is imperative that this function is used in conjunction with domain
expertise (e.g., to ensure that the covariates are not colliders, and that the system satisfies the strong
ignorability condiiton) to derive causal conclusions. See citation for more details as to the conditions
under which conclusions derived are causal.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("causal_cdcorr", package = "causalBatch")}
}

\examples{
library(causalBatch)
sim <- cb.sims.sim_linear(a=-1, n=100, err=1/8, unbalancedness=3)
cb.detect.caus_cdcorr(sim$Ys, sim$Ts, sim$Xs)

}
\references{
Eric W. Bridgeford, et al. "A Causal Perspective for Batch Effects: When is no answer better than a wrong answer?" Biorxiv (2024).

Eric W. Bridgeford, et al. "Learning sources of variability from high-dimensional observational studies" arXiv (2023).

Xueqin Wang, et al. "Conditional Distance Correlation" American Statistical Association (2015).
}
\author{
Eric W. Bridgeford
}
