% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization.R
\name{fit_function}
\alias{fit_function}
\title{Maximum Likelihood estimator for a Cauchy model}
\usage{
fit_function(
  minus_like,
  tree,
  trait,
  X,
  model,
  start.values,
  lower.values,
  upper.values,
  optim,
  rootTip
)
}
\arguments{
\item{minus_like}{a function giving the minus likelihood of the model.}

\item{trait}{named vector of traits at the tips.}

\item{model}{a model for the trait evolution. One of \code{"cauchy"} or \code{"lambda"} (see Details).}

\item{optim}{if "local", only a local optimization around the initial parameter values is performed (the default).
If "global", a global maximization is attempted using the "MLSL" approach (see \code{\link{nloptr}}).}

\item{rootTip}{root tip for the reml.}
}
\value{
A list, with the maximum likelihood rate parameter, and the likelihood value.
}
\description{
Find the maximum likelihood.
}
\keyword{internal}
