% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/other_methods.R
\name{wrapper}
\alias{leapp.wrapper}
\alias{ruv.wrapper}
\alias{sva.wrapper}
\alias{wrapper}
\title{Wrapper functions for some previous methods}
\usage{
sva.wrapper(X, Y, X.nuis = NULL, r, sva.method = c("irw", "two-step"),
  B = 5)

ruv.wrapper(X, Y, X.nuis = NULL, r, nc, lambda = 1, ruv.method = c("RUV2",
  "RUV4", "RUVinv"))

leapp.wrapper(X, Y, X.nuis = NULL, r, search.tuning = F,
  ipod.method = c("hard", "soft"))
}
\arguments{
\item{X}{treatment variable, n*d0 matrix}

\item{Y}{outcome, n*p matrix}

\item{X.nuis}{nuissance covarites, n*d1 matrix}

\item{r}{number of latent factors, can be estimated using the function \code{est.confounder.num}}

\item{sva.method}{parameter for \code{\link[sva]{sva}}.
whether to use an iterative reweighted algorithm (irw) or a two-step algorithm (two-step).}

\item{B}{parameter for \code{\link[sva]{sva}}. the number of iterations of the irwsva algorithm}

\item{nc}{parameter for \link[ruv]{ruv} functions: position of the negative controls}

\item{lambda}{parameter for \code{\link[ruv]{RUVinv}}}

\item{ruv.method}{either using \code{\link[ruv]{RUV2}}, \code{\link[ruv]{RUV4}} or
\code{\link[ruv]{RUVinv}} functions}

\item{search.tuning}{logical parameter for \code{\link[leapp]{leapp}}, whether using BIC to search for tuning parameter of IPOD}

\item{ipod.method}{parameter for \code{\link[leapp]{leapp}}. "hard": hard thresholding in the IPOD algorithm;
"soft": soft thresholding in the IPOD algorithm}
}
\value{
All functions return \code{beta.p.value} which are the p-values after adjustment.
For the other returned objects, refer to \link{cate} for their meaning.
}
\description{
These functions provide an uniform interface to three existing methods: SVA, RUV, LEAPP
The wrapper functions transform the data into desired forms and call the corresponding functions in the package
\link{sva}, \link{ruv}, \link[leapp]{leapp}
}
\details{
These functions add an intercept term automatically if \code{X.nuis} is \code{NULL}.

Only 1 variable of interest is allowed for \code{leapp.wrapper}.
}
\examples{
## this is the simulation example in Wang et al. (2015).
n <- 100
p <- 1000
r <- 2
set.seed(1)
data <- gen.sim.data(n = n, p = p, r = r,
                     alpha = rep(1 / sqrt(r), r),
                     beta.strength = 3 * sqrt(1 + 1) / sqrt(n),
                     Gamma.strength = c(seq(3, 1, length = r)) * sqrt(p),
                     Sigma = 1 / rgamma(p, 3, rate = 2),
                     beta.nonzero.frac = 0.05)
sva.results <- sva.wrapper(data$X1, data$Y, data$X0, r = r, sva.method = "irw")
ruv.results <- ruv.wrapper(data$X1, data$Y, data$X0, r = r, nc = sample(data$beta.zero.pos, 30),
                           ruv.method = "RUV4")
leapp.results <- leapp.wrapper(data$X1, data$Y, data$X0, r = r)
cate.results <- cate(data$X1, data$Y, data$X0, r = r)

## p-values after adjustment
par(mfrow = c(2, 2))
hist(sva.results$beta.p.value)
hist(ruv.results$beta.p.value)
hist(leapp.results$beta.p.value)
hist(cate.results$beta.p.value)

## type I error
mean(sva.results$beta.p.value[data$beta.zero.pos] < 0.05)

## power
mean(sva.results$beta.p.value[data$beta.nonzero.pos] < 0.05)

## false discovery proportion for sva
discoveries.sva <- which(p.adjust(sva.results$beta.p.value, "BH") < 0.2)
fdp.sva <- length(setdiff(discoveries.sva, data$beta.nonzero.pos)) / max(length(discoveries.sva), 1)
fdp.sva
}

