% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat_agg.R
\name{cat2cat_agg}
\alias{cat2cat_agg}
\title{Manual mapping for an aggregated panel dataset}
\usage{
cat2cat_agg(
  data = list(old = NULL, new = NULL, cat_var = NULL, time_var = NULL, freq_var = NULL),
  ...
)
}
\arguments{
\item{data}{list with 5 named fields
`old`, `new`, `cat_var`, `time_var`, `freq_var`.}

\item{...}{mapping equations where direction is set with any of,
`>`, `<`, `\%>\%`, `\%<\%`.}
}
\value{
`list` of two data.frame objects.
}
\description{
Manual mapping of an inconsistently coded categorical variable
according to the user provided mappings (equations).
}
\details{
data argument - list with fields
\itemize{
 \item{"old"}{ data.frame older time point in the panel}
 \item{"new"} { data.frame more recent time point in the panel}
 \item{"cat_var"}{ character name of the categorical variable}
 \item{"time_var"}{ character name of time variable}
 \item{"freq_var"}{ character name of frequency variable}
}
}
\examples{
data("verticals", package = "cat2cat")
agg_old <- verticals[verticals$v_date == "2020-04-01", ]
agg_new <- verticals[verticals$v_date == "2020-05-01", ]

# cat2cat_agg - can map in both directions at once
# although usually we want to have the old or the new representation

agg <- cat2cat_agg(
  data = list(
    old = agg_old,
    new = agg_new,
    cat_var = "vertical",
    time_var = "v_date",
    freq_var = "counts"
  ),
  Automotive \%<\% c(Automotive1, Automotive2),
  c(Kids1, Kids2) \%>\% c(Kids),
  Home \%>\% c(Home, Supermarket)
)

## possible processing
library("dplyr")
agg \%>\%
  bind_rows() \%>\%
  group_by(v_date, vertical) \%>\%
  summarise(
    sales = sum(sales * prop_c2c),
    counts = sum(counts * prop_c2c),
    v_date = first(v_date)
  )
}
