% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat.R
\name{cat2cat}
\alias{cat2cat}
\title{Automatic mapping of a categorical variable in a panel dataset according to a new encoding}
\usage{
cat2cat(
  data = list(old = NULL, new = NULL, cat_var = NULL, id_var = NULL, time_var = NULL,
    multiplier_var = NULL, freqs_df = NULL),
  mappings = list(trans = NULL, direction = NULL),
  ml = list(method = NULL, features = NULL, args = NULL)
)
}
\arguments{
\item{data}{list with 4, 5, 6 or 7 named fields `old` `new` `cat_var` `time_var` and optional `id_var`,`multiplier_var`,`freq_df`}

\item{mappings}{list with 2 named fields `trans` `direction`}

\item{ml}{list with 3 named fields `method` `features` `args`}
}
\value{
named list with 2 fields old an new - 2 data.frames.
There will be added additional columns like index_c2c, g_new_c2c, wei_freq_c2c, rep_c2c, wei_(ml method name)_c2c.
Additional columns will be informative only for a one data.frame as we always make a changes to one direction.
}
\description{
This function is built to work for two time points at once.
Thus for more periods some recursion will be needed.
The \code{prune_c2c} might be needed when we have many interactions to limit growing number of replications.
This function might seems to be a complex at the first glance though it is built to offer a wide range of applications for complex tasks.
}
\details{
data args
\itemize{
 \item{"old"}{ data.frame older time point in a panel}
 \item{"new"} { data.frame more recent time point in a panel}
 \item{"cat_var"}{ character name of the categorical variable. NA values are automatically converted to "NA" strings.}
 \item{"time_var"}{ character name of the time variable}
 \item{"id_var"}{ optional character name of the unique identifier variable - if this is specified then for subjects observe in both periods the direct mapping is applied.}
 \item{"multiplier_var"}{ optional character name of the multiplier variable - number of replication needed to reproduce the population}
 \item{"freqs_df"}{ optional only for advanced users - data.frame with 2 columns where first one is category name and second counts which will be used to assess the probabilities.}
}
mappings args
\itemize{
 \item{"trans"}{ data.frame with 2 columns - transition table - all categories for cat_var in old and new datasets have to be included.
  First column contains an old encoding and second a new one.
  The transition table should to have a candidate for each category from the targeted for an update period.
}
 \item{"direction"}{ character direction - "backward" or "forward"}
}
optional ml args
\itemize{
 \item{"method"}{ character vector - one or a few from "knn", "rf" and "lda" methods - "knn" k-NearestNeighbors, "lda" Linear Discrimination Analysis, "rf" Random Forest }
 \item{"features"}{ character vector of features names where all have to be numeric or logical}
 \item{"args"}{ list parameters: knn: k ; rf: ntree  }
}

Without ml section only simple frequencies are assessed.
When ml model is broken then weights from simple frequencies are taken.
Method knn is recommended for smaller datasets.
}
\note{
The transition table should to have a candidate for each category from the targeted for an update period.
The observation from targeted for an updated period without a matched category from base period is removed.
If you want to leave NA values add `c(NA, NA)` row to the `trans` table.
}
\examples{
\dontrun{
data(occup_small)
data(occup)
data(trans)

occup_old <- occup_small[occup_small$year == 2008, ]
occup_new <- occup_small[occup_small$year == 2010, ]

# default only simple frequencies

occup_simple <- cat2cat(
  data = list(old = occup_old, new = occup_new, cat_var = "code", time_var = "year"),
  mappings = list(trans = trans, direction = "forward")
)

# additionally add probabilities from knn
occup_ml <- cat2cat(
  data = list(old = occup_old, new = occup_new, cat_var = "code", time_var = "year"),
  mappings = list(trans = trans, direction = "forward"),
  ml = list(
    method = "knn",
    features = c("age", "sex", "edu", "exp", "parttime", "salary"),
    args = list(k = 10)
  )
)
}

}
