% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\docType{methods}
\name{claimSimulation}
\alias{claimSimulation}
\alias{claimSimulation,Simulation-method}
\alias{claimSimulation,ANY-method}
\title{Claim simulation at line/type/status level}
\usage{
claimSimulation(object, ...)

\S4method{claimSimulation}{Simulation}(object, claimData = data.frame(),
  startDate = as.Date("2012-01-01"),
  evaluationDate = as.Date("2016-12-31"),
  futureDate = as.Date("2017-12-31"), append = TRUE)
}
\arguments{
\item{object}{Simulation object}

\item{...}{Additional parameters that may or may not be used.}

\item{claimData}{claim data including existing claims for RBNER and claim reopenness analysis;}

\item{startDate}{Date after which claims are analyzed;}

\item{evaluationDate}{Date of evaluation for existing claims and IBNR;}

\item{futureDate}{Date of evaluation for UPR (future claims).}

\item{append}{Boolean variable to indicate whether existing simulation results need to be kept.}
}
\description{
Claim simulation at line/type/status level
}
\examples{
library(cascsim)
data(claimdata)
lines <- c("Auto")
types <- c("N")
AutoN <- new("ClaimType", line = "Auto", claimType = "N")
AutoN@exposureIndex <- setIndex(new("Index",indexID="I1",tabulate= FALSE,
startDate=as.Date("2012-01-01"), annualizedRate = 0)) # level exposure across time
AutoN@frequency <- new("Poisson", p1 =50)
AutoN@severityIndex <- setIndex(new("Index",indexID="I2",tabulate= FALSE,
startDate=as.Date("2012-01-01"), annualizedRate = 0.02)) #assuming a 2\% annual inflation
AutoN@severity <- new("Lognormal", p1 =2, p2 =3)
AutoN@deductible <- new("Empirical", empirical=matrix(c(0,1,100,100),2,2))
AutoN@limit <- new("Empirical", empirical=matrix(c(0,1,1e8,1e8),2,2))
AutoN@p0<-new("DevFac",meanList=c(0,0),volList=c(0,0))
AutoN@reportLag <- new("Exponential", p1 =0.1)
AutoN@settlementLag <- new("Exponential", p1 =0.05)
AutoN@iCopula <- TRUE #use copula
AutoN@ssrCopula <- new("CopulaObj", type ="normal", dimension = 3, 
param = c(0.1,0.2,0.1))#A Gaussian Copula
AutoN@ssrCopula@marginal <- c(AutoN@severity,AutoN@settlementLag,AutoN@reportLag)
AutoN@laeDevFac <- new("DevFac",FacID="F1",FacModel= TRUE,fun="linear",
paras =c(5,1.5,0.005,1.2,3))
AutoN@fIBNER <- new("DevFac",FacID="D1",FacModel= FALSE,
meanList =c(1.2,1.15,1.1,1.05,1),volList =c(0,0,0,0,0))
AutoN@reopen <- new("DevFac",FacID="D2",FacModel= FALSE,
meanList =c(0.02,0.015,0.01,0.005,0),volList =c(0.003, 0.002, 0.001, 0.001, 0))
AutoN@roDevFac <- new("DevFac",FacID="D3",FacModel= FALSE,
meanList =c(1.05,1.1,1,1,1),volList =c(0.00589,0.0037,0.00632,0.00815,0))
AutoN@reopenLag <- new("Exponential", p1 =0.01)
AutoN@resettleLag <- new("Exponential", p1 =0.25)
simobj <- new("Simulation", lines=lines, types=types, 
claimobjs= list(AutoN),workingFolder=tempdir())
simobj@simNo <- 1
simobj@iRBNER <-FALSE
simobj@iROPEN <-FALSE
simobj@iIBNR <-TRUE
simobj@iUPR <-FALSE
simdata <- claimSimulation(simobj,claimdata, startDate = as.Date("2012-01-01"), 
evaluationDate = as.Date("2016-12-31"), futureDate = as.Date("2017-12-31"))
}
