% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.R
\name{item}
\alias{item}
\title{Flex items}
\usage{
item(
  x,
  align = "stretch",
  order = NULL,
  fill = NULL,
  grow = NULL,
  shrink = NULL
)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{align}{A \link{responsive} argument.

One of \code{"auto"}, \code{"start"}, \code{"end"}, \code{"center"}, \code{"baseline"}, or \code{"stretch"} specifying how to align the item
on the cross axis, defaults to \code{"stretch"}. Overrides the \code{\link[=flex]{flex()}} \code{align}
argument.}

\item{order}{A \link{responsive} argument.

One of \code{0}, \code{1}, \code{2}, \code{3}, \code{4}, \code{5}, \code{6}, or \code{7} specifying the order of the item, defaults to
\code{1}. Items of the same order are then sorted by their source code
order. Defaults to \code{NULL}, in which case the argument is ignored.}

\item{fill}{A \link{responsive} argument.

If \code{TRUE}, the flex parent element's horizontal space is divided
proportionally amongst this tag element and all other flex items with \code{fill = TRUE}, defaults to \code{NULL}, in which case the argument is ignored.}

\item{grow}{A \link{responsive} argument.

One of \code{TRUE} or \code{FALSE}, defaults to \code{NULL}, in which case the argument
is ignored.}

\item{shrink}{A \link{responsive} argument.

One of \code{TRUE} or \code{FALSE}, defaults to \code{NULL}, in which case the argument
is ignored.}
}
\description{
The \code{item()} function adjusts a flex item. Unlike \code{\link[=flex]{flex()}}, which adjusts
the flex box layout through the flex container element, \code{item()} is used to
change specific flex items. A flex item may be reordered, expanded, or
shrunk.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    display("flex"),
  div(
    .style \%>\%
      item(order = 2),
    "Second"
  ),
  div(
    "First"
  )
)

}
