% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{legendPropTriangles}
\alias{legendPropTriangles}
\title{Legend for Double Proportional Triangles Maps}
\usage{
legendPropTriangles(pos = "topleft", title.txt, var.txt, var2.txt,
  title.cex = 0.8, cex = 1, values.cex = 0.6, var, var2, r, r2,
  col = "red", col2 = "blue", frame = FALSE, values.rnd = 0,
  style = "c")
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{title.txt}{title of the legend.}

\item{var.txt}{name of var.}

\item{var2.txt}{name of var2.}

\item{title.cex}{size of the legend title.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{values.cex}{size of the values in the legend.}

\item{var}{a first vector of positive values.}

\item{var2}{a second vector of positive values.}

\item{r}{a first vector of sizes.}

\item{r2}{a second vector of sizes.}

\item{col}{color of symbols.}

\item{col2}{second color of symbols.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{values.rnd}{number of decimal places of the values in 
the legend.}

\item{style}{either "c" or "e". The legend has two display 
styles, "c" stands for compact and "e" for extended.}
}
\description{
Plot legends for double proportional triangles maps.
}
\examples{
library(sp)
data("nuts2006")
plot(nuts0.spdf)
box()
var <- round((nuts0.df$pop2008 / sum(nuts0.df$pop2008))*100,2)
var2 <- round((nuts0.df$gdppps2008 / sum(nuts0.df$gdppps2008))*100,2)
r <- sqrt(var)/2*1000000
r2 <- sqrt(var2)/2*1000000
legendPropTriangles(pos = "topright", var.txt = "population totale (habs)",
                        var2.txt = "pib (euros)", title.txt="PIB par habitant",
                        title.cex = 0.8, values.cex = 0.6, cex = 1,
                        var = var, var2 = var2, r = r, r2 = r2,
                        col="green", col2="yellow", frame=TRUE, values.rnd=2, 
                        style="c")
}
