% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layoutLayer.R
\name{layoutLayer}
\alias{layoutLayer}
\title{Layout Layer}
\usage{
layoutLayer(title = "Title of the map, year", sources = "Source(s)",
  author = "Author(s)", col = "black", coltitle = "white", theme = NULL,
  bg = NULL, scale = 0, frame = TRUE, north = FALSE, south = FALSE,
  extent = NULL, tabtitle = FALSE, postitle = "left")
}
\arguments{
\item{title}{title of the map.}

\item{sources}{sources of the map (or something else).}

\item{author}{author of the map (or something else).}

\item{col}{color of the title box and frame border.}

\item{coltitle}{color of the title.}

\item{theme}{name of a cartographic palette (see \link{carto.pal.info}). 
col and coltitle are set according to the chosen palette.}

\item{bg}{color of the frame background.}

\item{scale}{size of the scale bar in kilometers. If set to NULL, no scale bar is 
displayed, if set to 0 an automatic scale bar is displayed (1/10 of the map width).}

\item{frame}{whether displaying a frame (TRUE) or not (FALSE).}

\item{north}{whether displaying a North arrow (TRUE) or not (FALSE).}

\item{south}{whether displaying a South arrow (TRUE) or not (FALSE).}

\item{extent}{sf object or Spatial*DataFrame; sets the extent of the frame to 
the one of a spatial object. (optional)}

\item{tabtitle}{size of the title box either a full banner (FALSE) or a "tab" (TRUE).}

\item{postitle}{position of the title, one of "left", "center", "right".}
}
\description{
Plot a layout layer.
}
\details{
If extent is not set, plot.new has to be called first.\cr
The size of the title box in layoutLayer is fixed to 1.2 lines height.
}
\examples{
# Example 1
library(sf)
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
plot(st_geometry(mtq), col = "grey60",border = "grey20")
# Layout plot
layoutLayer()

# Example 2
library(sp)
data("nuts2006")
plot(nuts0.spdf, col=NA, border = NA, bg ="#A6CAE0")
plot(world.spdf, col  = "#E3DEBF", border=NA, add=TRUE)
plot(nuts0.spdf, col = "#D1914D",border = "white", lwd=1, add=TRUE)
layoutLayer(col = NA, coltitle = "black",
            sources = "", author = "",
            frame = FALSE, postitle = "center",
            south = TRUE)

# Example 3
nuts3.df$gdphab <- 1000000 * nuts3.df$gdppps2008 / nuts3.df$pop2008
choroLayer(spdf = nuts3.spdf, df = nuts3.df, var = "gdphab",
           legend.pos = "right", border = NA, nclass = 6,
           col = carto.pal('green.pal', 6))
# Layout plot
layoutLayer(title = "GDP per Inhabitants", sources = "", 
            tabtitle = TRUE, scale = NULL,
            author = "Eurostat, 2008", theme = "green.pal")
}
\seealso{
\link{labelLayer}
}
