% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.cartogramR.R
\name{residuals.cartogramR}
\alias{residuals.cartogramR}
\title{Errors of a cartogram object}
\usage{
\method{residuals}{cartogramR}(object, ...)
}
\arguments{
\item{object}{a cartogramR object}

\item{\\dots}{arguments passed to or from other methods. The following
arguments are available:
- type; a character string giving the type of residuals (see details)
- "relative error"
- "error"
- "symmetric difference"
- center ; a character string giving the type of center:
- "point_on_surface" (\link{st_point_on_surface} applied on original
and on deformed/cartogram region).
- "deformed_center" (the center function, see
\link{cartogramR_options}, is applied on region and
this center follows the deformation  giving
the center on the deformed/cartogram region)
- "centroid" (centroid of original and
deformed/cartogram region).
Can be abbreviated.}
}
\value{
A numeric vector which contains for each region observed
area minus theorical area
}
\description{
Errors of a cartogram object
}
\details{
The error vector contains the values of the differences
between actual area of regions in the cartogram and theorical area
(obtained with conservation of total area and constant density over
region in the final cartogram)\preformatted{Relative error are the error vector divided by the theorical area

Symmetric difference are the symmetric difference between
actual area of regions in the cartogram and the original
area. Each region is scaled to have an area equal to 1 and centered
around the chosen center.
}
}
\examples{
\donttest{
  data(usa)
  carto <- cartogramR(usa, "electors64")
  residuals(carto)
}

}
