% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caretEnsemble.R
\name{caretEnsemble}
\alias{caretEnsemble}
\title{Combine several predictive models via weights}
\usage{
caretEnsemble(all.models, optFUN = NULL, ...)
}
\arguments{
\item{all.models}{an object of class caretList}

\item{optFUN}{the optimization function to use}

\item{...}{additional arguments to pass to the optimization function}
}
\value{
a \code{\link{caretEnsemble}} object
}
\description{
Find a good linear combination of several classification or regression models,
using either linear regression, elastic net regression, or greedy optimization.
}
\details{
Every model in the "library" must be a separate \code{train} object.  For
example, if you wish to combine a random forests with several different
values of mtry, you must build a model for each value of mtry.  If you
use several values of mtry in one train model, (e.g. tuneGrid =
expand.grid(.mtry=2:5)), caret will select the best value of mtry
before we get a chance to include it in the ensemble.  By default,
RMSE is used to ensemble regression models, and AUC is used to ensemble
Classification models.  This function does not currently support multi-class
problems
}
\note{
Currently when missing values are present in the training data, weights
are calculated using only observations which are complete across all models
in the library.The optimizer ignores missing values and calculates the weights with the
observations and predictions available for each model separately. If each of the
models has a different pattern of missingness in the predictors, then the resulting
ensemble weights may be biased and the function issues a message.
}
\examples{
\dontrun{
set.seed(42)
models <- caretList(iris[1:50,1:2], iris[1:50,3], methodList=c('glm', 'lm'))
ens <- caretEnsemble(models)
summary(ens)
}
}
\references{
\url{http://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.60.2859&rep=rep1&type=pdf}
}

