% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R, R/rfe.R
\name{ggplot.rfe}
\alias{ggplot.rfe}
\alias{plot.rfe}
\title{Plot RFE Performance Profiles}
\usage{
\method{ggplot}{rfe}(
  data = NULL,
  mapping = NULL,
  metric = data$metric[1],
  output = "layered",
  ...,
  environment = NULL
)

\method{plot}{rfe}(x, metric = x$metric, ...)
}
\arguments{
\item{data}{an object of class \code{\link{rfe}}.}

\item{mapping, environment}{unused arguments to make consistent with
\pkg{ggplot2} generic method}

\item{metric}{What measure of performance to plot. Examples of possible
values are "RMSE", "Rsquared", "Accuracy" or "Kappa". Other values can be
used depending on what metrics have been calculated.}

\item{output}{either "data", "ggplot" or "layered". The first returns a data
frame while the second returns a simple \code{ggplot} object with no layers.
The third value returns a plot with a set of layers.}

\item{\dots}{\code{plot} only: specifications to be passed to
\code{\link[lattice]{xyplot}}. The function automatically sets some
arguments (e.g. axis labels) but passing in values here will over-ride the
defaults.}

\item{x}{an object of class \code{\link{rfe}}.}
}
\value{
a lattice or ggplot object
}
\description{
These functions plot the resampling results for the candidate subset sizes
evaluated during the recursive feature elimination (RFE) process
}
\details{
These plots show the average performance versus the subset sizes.
}
\note{
We using a recipe as an input, there may be some subset sizes that are
 not well-replicated over resamples. The `ggplot` method will only show
 subset sizes where at least half of the resamples have associated results.
}
\examples{

\dontrun{
data(BloodBrain)

x <- scale(bbbDescr[,-nearZeroVar(bbbDescr)])
x <- x[, -findCorrelation(cor(x), .8)]
x <- as.data.frame(x, stringsAsFactors = TRUE)

set.seed(1)
lmProfile <- rfe(x, logBBB,
                 sizes = c(2:25, 30, 35, 40, 45, 50, 55, 60, 65),
                 rfeControl = rfeControl(functions = lmFuncs,
                                         number = 200))
plot(lmProfile)
plot(lmProfile, metric = "Rsquared")
ggplot(lmProfile)
}
}
\references{
Kuhn (2008), ``Building Predictive Models in R Using the caret''
(\url{https://www.jstatsoft.org/article/view/v028i05/v28i05.pdf})
}
\seealso{
\code{\link{rfe}}, \code{\link[lattice]{xyplot}},
\code{\link[ggplot2]{ggplot}}
}
\author{
Max Kuhn
}
\keyword{hplot}
