probFunction <- function(method, modelFit, newdata, preProc = NULL, param = NULL, custom = NULL)
{
  
  if(method != "custom" && !any(modelLookup(method)$probModel))
    stop("no probability method for this model")
  
  
  if(method %in% c(
                   "svmradial", "svmpoly", "svmRadialCost",
                   "svmRadial", "svmPoly", "svmLinear",
                   "gaussprRadial", "gaussprPoly", "gaussprLinear",
                   "lssvmRadial", "lssvmLinear",
                   "ctree", "ctree2",  "cforest",
                   "penalized", "Linda", "QdaCov"))
    {
      
      obsLevels <- switch(method,
                          svmradial =, svmpoly =, 
                          svmRadial =, svmPoly =, svmLinear =,
                          svmRadialCost =, 
                          gaussprRadial =, gaussprPoly =, gaussprLinear =,
                          lssvmRadial =, lssvmLinear =
                          {
                            library(kernlab)
                            lev(modelFit)
                          },

                          Linda =, QdaCov = names(modelFit@prior),
                          
                          ctree =, ctree2 =, cforest =
                          {
                            library(party)
                            levels(modelFit@data@get("response")[,1])
                          })
    } else {
      obsLevels <- modelFit$obsLevels
    }
  
  if(any(colnames(newdata) == ".outcome")) newdata$.outcome <- NULL

  if(!is.null(preProc)) newdata <- predict(preProc, newdata)

  
  classProb <- switch(method,
                      lda =, rda =, slda =, qda =, rrlda = 
                      {
                        switch(method,
                               lda =, qda =  library(MASS),
                               rda        =  library(klaR),
                               slda       = library(ipred),
                               rrlda      = library(rrlda))
                        
                        out <- predict(modelFit, newdata)$posterior
                        out
                      },

                      sparseLDA =
                      {                  
                        library(sparseLDA)
                        if(!is.matrix(newdata)) newdata <- as.matrix(newdata)
                        sparseLDA::predict.sda(modelFit, newdata)$posterior
                      },

                      lda2 = 
                      {
                        library(MASS)
                        out <- predict(modelFit, newdata, dimen = modelFit$tuneValue$.dimen)$posterior
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.dimen))
                              {
                                tmpProb <- predict(modelFit, newdata, dimen = param$.dimen[j])$posterior
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])
                              }
                            out <- tmp
                          }                        
                        out
                      },
                      

                      knn =
                      {
                        out <- predict(modelFit, newdata, type = "prob")
                        out
                        
                      },

                      svmLinear =, svmlinear =,
                      svmradial =, svmpoly =,
                      svmRadial =, svmPoly =,
                      lssvmRadial =,
                      gaussprRadial =, gaussprPoly =,
                      svmRadialCost =
                      {
                        library(kernlab)
                        
                        out <- try(predict(modelFit, newdata, type="probabilities"),
                                   silent = TRUE)
                        if(class(out)[1] != "try-error")
                          {
                            ## There are times when the SVM probability model will
                            ## produce negative class probabilities, so we
                            ## induce vlaues between 0 and 1
                            if(any(out < 0))
                              {
                                out[out < 0] <- 0
                                out <- t(apply(out, 1, function(x) x/sum(x)))
                              }
                            out <- out[, lev(modelFit), drop = FALSE]
                          } else {
                            warning("kernlab class probability calculations failed; returning NAs")
                            out <- matrix(NA, nrow(newdata) * length(obsLevels), ncol = length(obsLevels))
                            colnames(out) <- obsLevels
                          }
                        out
                      },
                      
                      gbm =
                      {
                        library(gbm)
                        out <- predict(modelFit, newdata, type = "response",
                                       n.trees = modelFit$tuneValue$.n.trees)
                        
                        if(modelFit$distribution$name != "multinomial") 
                          {
                            out <- data.frame(a = out, b = 1-out) 
                            names(out) <-  modelFit$obsLevels
                          } else out <- as.data.frame(out[,,1])
                        if(!is.null(param))
                          {
                            tmp <- predict(modelFit, newdata, type = "response", n.trees = param$.n.trees)

                            if(modelFit$problemType == "Classification")
                              {
                                if(modelFit$distribution$name != "multinomial")
                                  {
                                    tmp <- apply(tmp, 2,
                                                 function(x, nm = modelFit$obsLevels)
                                                 {
                                                   x <- data.frame(x = x, y = 1 - x)
                                                   colnames(x) <- nm
                                                   x
                                                 })
                                  } else {
                                    ## Does anyone know of a better
                                    ## way to convert an array to a
                                    ## list of matrices or data
                                    ## frames?                   
                                    tmp <- apply(tmp, 3, function(x) data.frame(x))
                                  }
                              }
                            out <- c(list(out), tmp)
                          } 
                        out
                      },

                      avNNet =, nnet =, pcaNNet =
                      {
                        library(nnet)
                        out <- predict(modelFit, newdata)
                        if(dim(as.data.frame(out))[2] == 1)
                          {
                            out <- cbind(out, 1-out)
                            dimnames(out)[[2]] <-  rev(modelFit$obsLevels)
                          }
                        out
                      },
                      pls =, simpls =, widekernelpls =, kernelpls = 
                      {
                        library(pls)
                        if(!is.matrix(newdata)) newdata <- as.matrix(newdata)
                        out <- predict(modelFit, newdata, type = "prob",  ncomp = modelFit$tuneValue$.ncomp)
                        if(length(dim(out)) == 3) out <- out[,,1]
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.ncomp))
                              {
                                tmpProb <- predict(modelFit, newdata, type = "prob",  ncomp = param$.ncomp[j])
                                if(length(dim(tmpProb)) == 3) tmpProb <- tmpProb[,,1]
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])
                              }
                            out <- tmp
                          }                        
                        out
                      },
                      rf =, treebag  =, parRF =, Boruta = 
                      {
                        library(randomForest)
                        out <- predict(modelFit, newdata, type = "prob")            
                        out
                      },
                      rpart2 =
                      {
                        library(rpart)
                        if(!is.data.frame(newdata)) newdata <- as.data.frame(newdata)
                        out <- predict(modelFit, newdata, type = "prob")
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            cpValues <- depth2cp(modelFit$cptable, param$.maxdepth)
                            
                            for(j in seq(along = cpValues))
                              {
                                prunedFit <- prune.rpart(modelFit, cp = cpValues[j])
                                tmpProb <- predict(prunedFit, newdata, type = "prob")
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])
                              }
                            out <- tmp
                          }                            
                        out
                      },
                      rpart =
                      {
                        library(rpart)
                        if(!is.data.frame(newdata)) newdata <- as.data.frame(newdata)
                        out <- predict(modelFit, newdata, type = "prob")

                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            for(j in seq(along = param$.cp))
                              {
                                prunedFit <- prune.rpart(modelFit, cp = param$.cp[j])
                                tmpProb <- predict(prunedFit, newdata, type = "prob")
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])
                              }
                            out <- tmp
                          }                              
                        out
                      },                          
                      gpls =
                      {
                        library(gpls)
                        out <- predict(modelFit, newdata)$predicted
                        out <- cbind(out, 1-out)
                        dimnames(out)[[2]] <-  modelFit$obsLevels
                        out
                      },
                      pam =
                      {
                        library(pamr)
                        out <- pamr.predict(modelFit, t(newdata),
                                            threshold = modelFit$tuneValue$.threshold, type= "posterior")
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.threshold))
                              {
                                tmpProb <-  pamr.predict(modelFit, t(newdata),
                                                         threshold =  param$.threshold[j], type= "posterior")
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])

                              }
                            out <- tmp
                          }   
                        out
                      },
                      nb =
                      {
                        library(klaR)
                        out <- predict(modelFit, newdata, type = "raw")$posterior
                        out
                      },
 
                      earth =, bagEarth =
                      {
                        library(earth)
                        out <- predict(modelFit, newdata, type= "response")
                        out <- cbind(1-out, out)
                        colnames(out) <-  modelFit$obsLevels
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.nprune))
                              {
                                prunedFit <- update(modelFit, nprune = param$.nprune[j])
                                tmp2 <- predict(prunedFit, newdata, type= "response")
                                tmp2 <- cbind(1-tmp2, tmp2)
                                colnames(tmp2) <-  modelFit$obsLevels
                                tmp[[j+1]] <- tmp2
                              }
                            out <- tmp
                          }
                        out
                      },

                      gcvEarth =
                      {
                        library(earth)
                        out <- predict(modelFit, newdata, type= "response")
                        out <- cbind(1-out, out)
                        colnames(out) <-  modelFit$obsLevels
                        out
                      },
                      
                      fda =
                      {
                        library(mda)
                        library(earth)
                        out <- predict(modelFit, newdata, type= "posterior")
                        out
                      },
                      
                      bagFDA =
                      {
                        library(mda)
                        library(earth)
                        out <- predict(modelFit, newdata, type= "probs")
                        out
                      },
                      
                      multinom =
                      {
                        library(nnet)
                        out <- predict(modelFit, newdata, type = "probs")
                        if(dim(as.data.frame(out))[2] == 1)
                          {
                            out <- cbind(out, 1-out)
                            dimnames(out)[[2]] <-  rev(modelFit$obsLevels)
                          }
                        out
                      },
                      ctree =, ctree2=, cforest =
                      {
                        library(party)
                        rawProbs <- treeresponse(modelFit, newdata)
                        probMatrix <- matrix(unlist(rawProbs), ncol = length(obsLevels), byrow = TRUE)
                        out <- data.frame(probMatrix)
                        colnames(out) <- obsLevels
                        rownames(out) <- NULL
                        out
                      },
                      gamboost =, blackboost =, glmboost =
                      {
                        ## glmboost defies conveintion a bit by having higher values of the lp
                        ## correspond to the second factor level (as opposed to the first),
                        ## so we use the -lp for the first factor level prob
                        library(mboost)
                        if(method == "glmboost" & !is.matrix(newdata)) newdata <- as.matrix(newdata)
                        
                        lp <- predict(modelFit, newdata)
                        out <- cbind(
                                     binomial()$linkinv(-lp),
                                     1 - binomial()$linkinv(-lp))
                        colnames(out) <- modelFit$obsLevels
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.mstop))
                              {                           
                                tmpProb <- predict(modelFit[param$.mstop[j]], newdata)
                                tmpProb <- cbind(binomial()$linkinv(-tmpProb),
                                                 1 - binomial()$linkinv(-tmpProb))
                                colnames(tmpProb) <- modelFit$obsLevels
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])           
                              }
                            out <- tmp
                          }                        
                        out
                      },
                      ada =
                      {
                        library(ada)
                        out <- predict(modelFit, newdata, type = "prob")
                        colnames(out) <-  modelFit$obsLevels
                        out
                      },
                      sddaLDA =, sddaQDA =
                      {
                        library(SDDA)
                        predict(modelFit, as.matrix(newdata), type = "prob")
                      },
                      logitBoost =
                      {
                        library(caTools)
                        out <- caTools::predict.LogitBoost(modelFit, newdata, type = "raw")
                        ## I've seen them not be on [0, 1]
                        out <- t(apply(out, 1, function(x) x/sum(x)))
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.nIter))
                              {                           
                                tmpProb <- caTools::predict.LogitBoost(modelFit,
                                                                       newdata,
                                                                       type = "raw",
                                                                       nIter = param$.nIter[j])
                                tmpProb <- out <- t(apply(tmpProb, 1, function(x) x/sum(x)))
                                tmp[[j+1]] <- as.data.frame(tmpProb[, modelFit$obsLevels])           
                              }
                            out <- tmp
                          }                       
                        out
                      },
                      J48 =, LMT =, JRip =, OneR =, PART = 
                      {
                        library(RWeka)
                        out <- predict(modelFit,
                                       newdata,
                                       type = "probability")
                        out
                      },
                      penalized =
                      {
                        library(penalized)
                        out <- predict(modelFit, newdata)
                        out <- cbind(out, 1-out)
                        dimnames(out)[[2]] <-  modelFit$obsLevels
                        out
                      },
                      spls =
                      {
                        library(spls)
                        if(!is.matrix(newdata)) newdata <- as.matrix(newdata)
                        caret:::predict.splsda(modelFit, newdata, type = "prob")
                      },
                      sda =
                      {                  
                        library(sda)
                        if(!is.matrix(newdata)) newdata <- as.matrix(newdata)
                        sda::predict.sda(modelFit, newdata)$posterior
                      },
                      glm =, gam =, gamLoess =, gamSpline =, glmStepAIC =, bayesglm = 
                      {
                        
                        out <- predict(modelFit, newdata, type = "response")
                        out <- cbind(1-out, out)
                        ## glm models the second factor level. See Details in ?glm
                        dimnames(out)[[2]] <-  modelFit$obsLevels
                        out
                      },                    
                      plsGlmBinomial =
                      {                      
                        out <- predict(modelFit$FinalModel, newdata, type = "response")
                        out <- cbind(1-out, out)
                        dimnames(out)[[2]] <-  modelFit$obsLevels
                        out
                      },
                      mda =, pda =, pda2 =
                      {
                        library(mda)
                        predict(modelFit, newdata, type = "posterior")
                      },
                      vbmpRadial =
                      {
                        library(vbmp)
                        probs <- predictCPP(modelFit, newdata)
                        colnames(probs) <- obsLevels
                        probs
                      },
                      glmnet =
                      {
                        
                        if(length(obsLevels) == 2)
                          {
                            if(!is.null(param))
                              {
                                probs <- predict(modelFit,
                                                 as.matrix(newdata),
                                                 s = param$.lambda,
                                                 type = "response")

                                probs <- as.list(as.data.frame(probs))
                                probs <- lapply(probs,
                                                function(x, lev)
                                                {
                                                  tmp <- data.frame(x, 1-x)
                                                  names(tmp) <- lev
                                                  tmp
                                                },
                                                lev = modelFit$obsLevels)
                                
                              } else {
                                probs <- predict(modelFit,
                                                 as.matrix(newdata),
                                                 s = modelFit$lambdaOpt,
                                                 type = "response")
                                probs <- cbind(1-probs, probs)
                                colnames(probs) <- modelFit$obsLevels
                              }
                          } else {
                            if(!is.null(param))
                              {
                                ## This generates a 3d array
                                probs <- predict(modelFit,
                                                 as.matrix(newdata),
                                                 s = param$.lambda,
                                                 type = "response")
                                ## convert it to a list of 2d structures
                                probs <- apply(probs, 3, function(x) data.frame(x))
                              } else {
                                probs <- predict(modelFit,
                                                 as.matrix(newdata),
                                                 s = modelFit$lambdaOpt,
                                                 type = "response")
                                probs <- probs[,,1]
                              }
                          }
                        
                        probs
                      },
                      nodeHarvest =
                      {
                        out <- predict(modelFit, as.matrix(newdata), maxshow = 0)
                        if(is.vector(out))
                          {
                            out <- cbind(out, 1 - out)
                            colnames(out) <- obsLevels
                          }
                            out
                      },
                      Linda =, QdaCov =
                      {
                        library(rrcov)
                        probs <- predict(modelFit, newdata)@posterior
                        colnames(probs) <- names(modelFit@prior)
                        probs
                      },
                      stepLDA =, stepQDA =
                      {
                        library(MASS)
                        predict(modelFit$fit,
                                newdata[, predictors(modelFit), drop = FALSE])$posterior
                      },
                      plr =
                      {
                        library(stepPlr)
                        out <- predict(modelFit, newdata, type = "response")
                        out <- cbind(out, 1-out)
                        dimnames(out)[[2]] <-  modelFit$obsLevels
                        out
                      },
                      hda =
                      {
                        library(hda)
                        tmp <- predict(modelFit, as.matrix(newdata))
                        if(is.vector(tmp)) tmp <- matrix(tmp, ncol = 1)
                        predict(modelFit$naivebayes, tmp, type = "raw")
                      },
                      bag =
                      {
                        predict(modelFit, newdata, type = "prob")

                      },
                      hdda =
                      {
                        library(HDclassif)
                        data.frame(unclass(predict(modelFit, newdata)$posterior))
                      },
                      logreg =
                      {
                        library(LogicReg)
                        tmp <- predict(modelFit, newbin = newdata)
                        out <- cbind(tmp, 1 - tmp)
                        names(out) <- modelFit$obsLevels
                        out
                      },
                      logforest =
                      {
                        library(LogicForest)
                        tmp <- predict(modelFit, newdata = newdata)$proportion_one
                        out <- as.data.frame(cbind(tmp, 1 - tmp))
                        names(out) <- modelFit$obsLevels
                        out
                      },
                      logicBag =
                      {
                        library(logicFS)

                        if(length(modelFit$obsLevels) == 2)
                          {
                            out <- predict(modelFit, newData = newdata, type = "prob")
                            out <- as.data.frame(cbind(out, 1 - out))
                            colnames(out) <- modelFit$obsLevels
                          } else {
                            out <- predict(modelFit, newData = newdata, type = "prob")
                          }
                        out
                      },
                      ORFridge =, ORFpls =, ORFsvm =, ORFlog =
                      {
                        library(obliqueRF)
                        out <- predict(modelFit, newdata, type = "prob")            
                        out
                      },
                      evtree =
                      {
                        library(evtree)
                        out <- predict(modelFit, newdata, type = "prob")            
                        out
                      },
                      xyf =, bdk =
                      {
                        library(kohonen)
                        preds <- predict(modelFit, as.matrix(newdata))
                        preds$unit.predictions[preds$unit.classif,]
                      },
                      mlp =, mlpWeightDecay =, rbf =, rbfDDA =   
                      {
                        library(RSNNS)
                        out <- predict(modelFit, newdata)
                        colnames(out) <- modelFit$obsLevels
                        out
                      },
                      RRF =, RRFglobal =  
                      {
                        library(RRF)
                        out <- predict(modelFit, newdata, type = "prob")            
                        out
                      },
                      C5.0 =, C5.0Tree =, C5.0Rules =
                      {
                        library(C50)
                        out <- predict(modelFit, newdata, type= "prob")
                        
                        if(!is.null(param))
                          {
                            tmp <- vector(mode = "list", length = nrow(param) + 1)
                            tmp[[1]] <- out
                            
                            for(j in seq(along = param$.trials))
                              {
                                tmp[[j+1]] <- predict(modelFit, newdata, type= "prob", trials = param$.trials[j])
                              }
                            out <- tmp
                          }
                        out
                      },                      
                      custom =
                      {
                        custom(object = modelFit, newdata = newdata)
                      }                      
                      )

  if(!is.data.frame(classProb) & is.null(param))
    {
      classProb <- as.data.frame(classProb)
      if(!is.null(obsLevels)) classprob <- classProb[, obsLevels]
    }
  classProb
}

