% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuel_and_co2.R
\name{wood_to_co2}
\alias{wood_to_co2}
\title{Convert Wood Volume to CO2 Equivalents}
\usage{
wood_to_co2(volume_m3, raw_density_kg_m3, water_perc = 12)
}
\arguments{
\item{volume_m3}{Wood volume to be converted in cubic meters}

\item{raw_density_kg_m3}{The raw density of the wood in kg/m³}

\item{water_perc}{The water content of the wood at raw density in percent
(usually defined as 12 \%, i.e. air-dry)}
}
\value{
The CO2 equivalent of the input wood volume in kg
}
\description{
Convert Wood Volume to CO2 Equivalents
}
\examples{
  # Conversion of 1 m³ wood with typical values for important tree species
  wood_to_co2(1, raw_density_kg_m3 = 520) # Scots pine
  wood_to_co2(1, raw_density_kg_m3 = 470) # Norway spruce
  wood_to_co2(1, raw_density_kg_m3 = 600) # European larch
  wood_to_co2(1, raw_density_kg_m3 = 700) # sessile/pedunculate oak
  wood_to_co2(1, raw_density_kg_m3 = 730) # European beech


}
