% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_evaluation.R
\name{fuel_and_co2_evaluation}
\alias{fuel_and_co2_evaluation}
\title{Overarching Evaluation of Fuel Consumption and CO2 Emissions}
\usage{
fuel_and_co2_evaluation(
  x,
  road_density_m_ha,
  raw_density_kg_m3 = 520,
  harvest_loss = 0.1,
  bark_share = 0.12,
  mode = c("standard", "nordic")
)
}
\arguments{
\item{x}{An object of class \code{c4c_base_result}}

\item{road_density_m_ha}{The forest road density on the whole area in m/ha}

\item{raw_density_kg_m3}{The raw wood density (kg/m³) to be used for wood
volume conversions (i.e. density of air-dry wood (12\% water content)).
Default is 520 kg/m³ (typical for Scots pine). Internally, wood volume is
converted into CO2 equivalents with \code{\link{wood_to_co2}}.}

\item{harvest_loss}{Relative loss fraction of wood volume during harvest,
mainly comprising the stumps (default = 0.1). Does not include bark losses.}

\item{bark_share}{Relative wood volume share of the bark. Required, as the
CO2 equivalents of harvested wood are calculated for wood volume under
bark.}

\item{mode}{Character string indicating the mode of calculating fuel
consumption due to harvest operations. This relates to the functions
\code{\link{co2_eval_cutting}} and \code{\link{co2_eval_moving}}, see the
documentation of these functions for details.}
}
\value{
An object of class \code{c4c_co2_result} which is, in essence, a list
of three result data frames (and metadata about the underlying simulation),
providing information about co2 emissions, storage, and fuel consumption on
different levels of aggregation.
}
\description{
Given the output of a simulation run generated with
\code{\link{simulate_single_concept}}, i.e. an object of class
\code{c4c_base_result}, a set of information related to CO2 emissions and
storage is generated on different levels of aggregation.
}
\examples{
  # Make a simulation run first
  # The resulting object base_output (class c4c_base_result) comprises
  # the simulated phase area dynamics as well as extended growth and yield
  # information
  base_output <- simulate_single_concept(
    pine_thinning_from_above_1,
    init_areas = c(1000, 0, 0, 0, 0, 0),
    time_span  = 200,
    risk_level = 3
  )

  # Generate fuel and CO2 related information
  fuel_and_co2_evaluation(
    base_output,
    road_density_m_ha = 35,
    mode = "nordic"
  )

}
