% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_wilcoxtest.R
\name{ard_wilcoxtest}
\alias{ard_wilcoxtest}
\alias{ard_paired_wilcoxtest}
\title{ARD Wilcoxon Rank-Sum Test}
\usage{
ard_wilcoxtest(data, by, variable, ...)

ard_paired_wilcoxtest(data, by, variable, id, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame. See below for details.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to be compared.}

\item{...}{arguments passed to \code{wilcox.test(...)}}

\item{id}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name of the subject or participant ID.}
}
\value{
ARD data frame
}
\description{
Analysis results data for paired and non-paired Wilcoxon Rank-Sum tests.
}
\details{
For the \code{ard_wilcoxtest()} function, the data is expected to be one row per subject.
The data is passed as \code{wilcox.test(data[[variable]] ~ data[[by]], paired = FALSE, ...)}.

For the \code{ard_paired_wilcoxtest()} function, the data is expected to be one row
per subject per by level. Before the test is calculated, the data are
reshaped to a wide format to be one row per subject.
The data are then passed as
\verb{wilcox.test(x = data_wide[[<by level 1>]], y = data_wide[[<by level 2>]], paired = TRUE, ...)}.
}
\examples{
cards::ADSL |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  ard_wilcoxtest(by = "ARM", variable = "AGE")

# constructing a paired data set,
# where patients receive both treatments
cards::ADSL[c("ARM", "AGE")] |>
  dplyr::filter(ARM \%in\% c("Placebo", "Xanomeline High Dose")) |>
  dplyr::mutate(.by = ARM, USUBJID = dplyr::row_number()) |>
  dplyr::arrange(USUBJID, ARM) |>
  ard_paired_wilcoxtest(by = ARM, variable = AGE, id = USUBJID)
}
