% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrv_modeling.R
\name{build_sequential_models}
\alias{build_sequential_models}
\title{Model Building}
\usage{
build_sequential_models(formula, data, exposure = NULL, engine = "lm")
}
\arguments{
\item{formula}{an object of class \code{formula} that shows the names of the
outcomes (can be more than 1) and the names of the predictors (which should
contain the \code{exposure} variable).}

\item{data}{data frame or data table (or tibble) that contains the named
variables}

\item{exposure}{Variable that is forced to be maintained in every model as a
predictor.}

\item{engine}{Set the "engine" or the regression tool that will be used}
}
\value{
A tidy tibble of models. Each one will likely be grouped by its
outcome, and then with sequential columns using increased/additive models.
Each model, in a tidy format, will have two additional columns.
\itemize{
\item \code{outcomes} identifies which outcome was used for the specific regression
\item \code{covar} number of covariates used in sequence of predictors given, with
exposure always being placed in position 1
}
}
\description{
Simplify the process of building multiple models in a sequential
order. This is particularly helpful in epidemiological cases of testing
effect of additional parameters. Every parameter should be theoretically a
part of the causal model for the exposure-outcome relationship.
}
\details{
This is considering what is available with the \code{modelr} package and
the \code{tidymodels} approach, and finding an in-between for the causality /
epidemiology approach of building intentional, sequentional models. Expect
changes in the process, and potential future dependencies on the
\code{tidymodels} appraoches.
}
\examples{
data(geh)
f <- svg_mag + qrs_tang ~ lab_hba1c + bmi
build_sequential_models(f, data = geh)

}
