% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_gti.R
\name{relative_gti}
\alias{relative_gti}
\title{Relative GTI Plot}
\usage{
relative_gti(
  data = data,
  time = time,
  date_format = c("\%d/\%m/\%Y"),
  name = theatre,
  val = emissions,
  gti_by = c("default", "month", "year")
)
}
\arguments{
\item{data}{The data frame containing the data.}

\item{time}{The variable representing the time dimension.}

\item{date_format}{The date format for the time variable (optional, default: c("\%d/\%m/\%Y")).}

\item{name}{The variable representing the grouping variable.}

\item{val}{The variable representing the value.}

\item{gti_by}{The grouping type for calculating the GTI ("default", "month", "year").}
}
\value{
A ggplot2 object showing the relative GTI (Growth to Index) over time.
}
\description{
Calculate and plot the relative growth to index (GTI) over time
}
\examples{
# Example dataset
emission_data <- data.frame(
  theatre = c("Theatre A", "Theatre A", "Theatre B", "Theatre B", "Theatre A", "Theatre B"),
  emissions = c(200, 250, 150, 180, 300, 220),
  date = c("01/01/2023", "01/02/2023", "01/01/2023", "01/02/2023", "01/03/2023", "01/03/2023")
  )
  
# Using the relative_gti function
relative_gti_plot <- relative_gti(
  data = emission_data,
  time = date,
  date_format = "\%d/\%m/\%Y",  # Date format used in the dataset
  name = theatre,
  val = emissions,
  gti_by = "default"  # Calculating based on default time period
)

# Plot the relative GTI
print(relative_gti_plot)
}
