/**
 *
 * CanvasXpress 46.9 - JavaScript Canvas Library
 *
 * Copyright (c) 2009-2023 - license@canvasxpress.org
 *
 * Redistributions of the source code must retain this copyright
 * notice and the following disclaimer.
 *
 * CanvasXpress is released as open source for personal and
 * educational use with dual licensing for commercial purposes.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Please see a copy of the CanvasXpress License at
 * https://www.canvasxpress.org/docs/license.html.
 *
 * Dual licensing:
 * Commercial use may be granted to the extent that this source
 * code does NOT become part of any other Open Source or
 * Commercially licensed development library or toolkit without
 * explicit permission from CanvasXpress.
 *
 */
/**
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.CanvasXpress=b.CanvasXpress||{})))}}(this,(function(b){var c,a;if(this){c=this.window;a=this.document}CanvasXpress=typeof CanvasXpress!="undefined"&&CanvasXpress.ready?CanvasXpress:function(k,h,g,o,f,l,n,j){var i=this;var m=function(){i.init(k,h,g,o,f,l,n,j)};var e=function(p){if(p){i.init(p)}else{i.init(k,h,g,o,f,l,n,j)}};if((g&&g.fonts)||(k&&k.config&&k.config.fonts)){if(g&&g.fonts){CanvasXpress.loadFonts(g.fonts,m)}else{CanvasXpress.loadFonts(k.config.fonts,m)}}else{if((g&&g.fontsExternal)||(k&&k.config&&k.config.fontsExternal)){if(g&&g.fontsExternal){CanvasXpress.loadFontsExternal(g.fontsExternal,m)}else{CanvasXpress.loadFontsExternal(k.config.fontsExternal,m)}}else{if((g&&g.topoJSON&&typeof g.topoJSON=="string")||(k&&k.config&&k.config.topoJSON&&typeof k.config.topoJSON=="string")||(g&&g.useLeaflet)||(k&&k.config&&k.config.useLeaflet)){if((g&&g.useLeaflet)||(k&&k.config&&k.config.useLeaflet)){var d=function(){if(g&&g.topoJSON){CanvasXpress.loadTopoJSON(g.topoJSON,g.mapId,m)}else{if(k&&k.config&&k.config.topoJSON){CanvasXpress.loadTopoJSON(k.config.topoJSON,k.config.mapId,m)}else{m()}}};CanvasXpress.loadLeaflet(d,i)}else{if(g&&g.topoJSON){CanvasXpress.loadTopoJSON(g.topoJSON,g.mapId,m)}else{CanvasXpress.loadTopoJSON(k.config.topoJSON,k.config.mapId,m)}}}else{if((h&&typeof h=="string")||(k&&k.data&&typeof k.data=="string")){if(h){CanvasXpress.loadRemoteData(k,h,g,o,e)}else{CanvasXpress.loadRemoteData(k.renderTo,k.data,k.config,k.events,e)}}else{this.init(k,h,g,o,f,l,n,j)}}}}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.cxplot=b.cxplot||{})))}}(this,(function(){cxplot=function(u,v,j,a){if(typeof(u)=="object"&&u.isGGPlot){var l=function(f){if(Array.isArray(f)&&!f.length){return{}}else{return f}};var k=function(){if(u.order){u.aes.meta={};for(var f in u.order){u.aes.meta[f]=u.order[f]}}if(!u.aes.hasOwnProperty("x")){for(var f=0;f<n.length;f++){var m=n[f];if(u.layers[m]&&u.layers[m].hasOwnProperty("x")){u.aes.x=u.layers[m].x;break}}}if(!u.aes.hasOwnProperty("y")){for(var f=0;f<n.length;f++){var m=n[f];if(u.layers[m]&&u.layers[m].hasOwnProperty("y")){u.aes.y=u.layers[m].y;break}}}return u.aes};delete (u.isGGPlot);var o=JSON.stringify(u);var n=Array.isArray(u.geoms)?u.geoms:[u.geoms];var d=new cxplot(u.renderTo,u.data,aes(k()),a);var e={};d.skipGeoms=false;d.meta.config.user.geoms=n;d.meta.config.user.layers=u.layers;d.meta.config.user.cxplot=o;for(var q=0;q<n.length;q++){var r=n[q];var p=e[r]?r+"."+e[r]:r;var s=r.toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l").replace("ridgesgradient","ridges_gradient").replace("ridges","_ridges");if(d[s]&&!d.skipGeoms){d[s](l(u.layers[p]))}e[r]=e[r]?e[r]+1:1}d.skipGeoms=false;d.pl(l(u.labels));d.DS(l(u.scales));d.Ul(l(u.coords));d.vU(l(u.theme));d.Jl(l(u.facet));d.mH(u.config);return d}else{if(j){var b=["x","y"];for(var q=0;q<b.length;q++){if(j[b[q]]&&j[b[q]].match(/\*/)){var h=j[b[q]].split("*");h[0]=h[0].replace(/\s*$/,"");h[1]=Number(h[1].replace(/^\s*/,""));j[b[q]]=h[0];if(!isNaN(h[1])){j[b[q]]=h[0];j[b[q]+"AxisFactorValue"]=h[1]}}}}var t={aes:(j||{}),remoteTransitionEffect:"none",theme:"GGPlot",widthFactor:3,sizes:[8,10,12,14,16,18,20,22,24,26,28],shapes:["circle","equilateral","square","plus","minus","diamond","star","pentagon","hexagon","octagon"],isCxplot:true};if(j.hasOwnProperty("xAxisFactorValue")){t.xAxisFactorValue=j.xAxisFactorValue}if(j.hasOwnProperty("yAxisFactorValue")){t.yAxisFactorValue=j.yAxisFactorValue}var c=new CanvasXpress(u,v,t,a);c.meta.ggplot.aes=j||{};c.meta.ggplot.data=v[0];c.meta.ggplot.order=j&&j.order?j.order:{};return c}}})));(function(b,a){if(typeof exports==="object"&&typeof module!=="undefined"){a(exports)}else{(a((b.aes=b.aes||{})))}}(this,(function(){aes=function(){var b=arguments;var f={};var e=["x","y","z","fill","color","shape","size"];var a=function(){if(!f.stringSampleFactors){f.stringSampleFactors=[]}if(!f.stringVariableFactors){f.stringVariableFactors=[]}if(!f.asSampleFactors){f.asSampleFactors=[]}if(!f.asVariableFactors){f.asVariableFactors=[]}};for(var c=0;c<b.length;c++){if(Array.isArray(b[c])&&Array.isArray(b[c][0])){f.data=b[c]}else{if(b[c] instanceof Object){for(var d in b[c]){f[d]=b[c][d];if(d=="factor"){a();f.stringSampleFactors.push(b[c][d]);f.stringVariableFactors.push(b[c][d]);f.asSampleFactors.push(b[c][d]);f.asVariableFactors.push(b[c][d]);if(b.length>1){if(c==0){f.x=b[c][d]}else{if(c==1){f.y=b[c][d]}else{if(c==2){f.z=b[c][d]}}}}}else{if(e.includes(d)){if(b[c][d] instanceof Object&&b[c][d].factor){a();f.stringSampleFactors.push(b[c][d].factor);f.stringVariableFactors.push(b[c][d].factor);f.asSampleFactors.push(b[c][d].factor);f.asVariableFactors.push(b[c][d].factor);f[d]=b[c][d].factor}else{if(b[c][d].toString().match(/^factor\(.+\)/)){f[d]=b[c][d].replace(/^factor\(/,"").replace(/\)$/,"");a();f.stringSampleFactors.push(f[d]);f.stringVariableFactors.push(f[d]);f.asSampleFactors.push(f[d]);f.asVariableFactors.push(f[d])}}}else{if(d=="sample"){f.x=b[c][d]}}}}}else{if(c==0){f.x=b[c]}else{if(c==1){f.y=b[c]}else{if(c==2){f.z=b[c]}}}f[b[c]]=b[c]}}}return f}})));CanvasXpress.instances=CanvasXpress.instances||[];CanvasXpress.config=CanvasXpress.config||[];CanvasXpress.transitions=CanvasXpress.transitions||{};CanvasXpress.remoteUpdating=CanvasXpress.remoteUpdating||false;CanvasXpress.cacheImages=CanvasXpress.cacheImages||{};CanvasXpress.cacheImagesReady=CanvasXpress.cacheImagesReady||false;CanvasXpress.cachePatterns=CanvasXpress.cachePatterns||{};CanvasXpress.cacheText=CanvasXpress.cacheText||{};CanvasXpress.tabPanels=CanvasXpress.tabPanels||{};CanvasXpress.fonts=CanvasXpress.fonts||{"American Typewriter":true,"Andale Mono":true,Arial:true,Baskerville:true,"Bradley Hand":true,"Brush Script MT":true,"Comic Sans MS":true,Courier:true,Didot:true,Georgia:true,"Gill Sans":true,Helvetica:true,Impact:true,"Lucida Console":true,Luminari:true,Monaco:true,Optima:true,Palatino:true,Roboto:true,Tahoma:true,"Times New Roman":true,"Trebuchet MS":true,Verdana:true};CanvasXpress.selector=CanvasXpress.selector||{vars:{},smps:{},meta:{},comp:{},nodes:{},edges:{},mixed:{},selections:0,groups:{},graphType:false};CanvasXpress.hidden=CanvasXpress.hidden||{hiddenVars:{},hiddenSmps:{},hiddenGrps:{},hiddenMapFeatures:{},hiddenNodes:{},hiddenEdges:{}};CanvasXpress.stack=CanvasXpress.stack||{};CanvasXpress.current=CanvasXpress.current||false;CanvasXpress.chain=CanvasXpress.chain||{};CanvasXpress.resizing=CanvasXpress.resizing||false;CanvasXpress.registered="7A64D88307896160595C253EA";CanvasXpress.system=CanvasXpress.system||{};CanvasXpress.ready=CanvasXpress.ready||false;CanvasXpress.readyFonts=CanvasXpress.readyFonts||false;CanvasXpress.factory=CanvasXpress.factory||{version:46.9,buildDate:"10-31-2023",client:"",siteSrc:false,valid:typeof window.cX=="string"?window.cX:undefined,href:window.location.href};CanvasXpress.factory.services="https://www.canvasxpress.org/cgi-bin/services.pl";CanvasXpress.onReady=function(){var f=[];var a=false;var d=false;var c=function(){if(!a){var g=CanvasXpress.instances[0];if(g){g.T4("canvasXpress JS ready");a=true;for(var h=0;h<f.length;h++){f[h].fn.call(window,f[h].ctx)}f=[]}}};var b=function(){if(window.document.readyState==="complete"){c()}};var e=function(){c()};window.onReady=function(h,g){if(a){setTimeout(function(){h(g)},1);return}else{f.push({fn:h,ctx:g})}if(window.document.readyState==="complete"){setTimeout(c,1)}else{if(!d){if(window.document.addEventListener){window.document.addEventListener("DOMContentLoaded",c,false);window.addEventListener("load",e,false)}else{window.document.attachEvent("onreadystatechange",b);window.attachEvent("onload",e)}d=true}}};return true}();CanvasXpress.loadLeaflet=function(c,d){var b=document.createElement("script");b.type="text/javascript";b.src="https://www.canvasxpress.org/assets/leaflet/leaflet.js";b.crossOrigin="anonymous";var a=document.createElement("link");a.type="text/css";a.rel="stylesheet";a.href="https://www.canvasxpress.org/assets/leaflet/leaflet.css";a.crossOrigin="anonymous";if(window.L){if(c){if(typeof(c)=="function"){c.call(d)}}}else{CanvasXpress.loadScripts([a,b],c,d)}};CanvasXpress.loadScripts=function(files){var i=0;return function(files,callback,scope){var head=window.document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;loadScript(files[i-1],count)}}();CanvasXpress.transferDatasetAttributes=function(e,a,f){var d=JSON.parse(JSON.stringify(e.dataset));for(var c in d){if(d.hasOwnProperty(c)){if(f){a[c.replace(/^data-/,"")]=d[c]}else{var b="data-"+c.replace(/([a-zA-Z])(?=[A-Z])/g,"$1-").toLowerCase();a.setAttribute(b,d[c])}}}};CanvasXpress.initCanvas=function(){var e=window.document.getElementsByTagName("canvas");for(var d=0;d<e.length;d++){var g=e[d];if(g.className=="CanvasXpress"&&g.id){var f=false;var a={};var b=CanvasXpress.getObject(g.id);if(g.hasAttribute("data-src")&&!b){f=g.getAttribute("data-src");CanvasXpress.transferDatasetAttributes(g,a,true);if(Object.keys(a).length){new CanvasXpress(g.id,f,a)}else{new CanvasXpress(g.id,f)}}}}};CanvasXpress.initImage=function(){var a=window.document.getElementsByTagName("img");for(var c=0;c<a.length;c++){var g=a[c];if(g.className=="CanvasXpress"&&g.id){var f=CanvasXpress.getObject(g.id);var d=g.parentNode;if(!f){var e=g.src;var h=g.id;var b=window.document.createElement("canvas");b.width=g.clientWidth;b.height=g.clientHeight;CanvasXpress.transferDatasetAttributes(g,b);d.removeChild(g);b.id=h;d.appendChild(b);new CanvasXpress(h,e)}}}};CanvasXpress.initTable=function(){var c=window.document.getElementsByTagName("table");for(var b=0;b<c.length;b++){var e=c[b];if(e.className=="CanvasXpress"&&e.id){var g=CanvasXpress.getObject(e.id);var d=e.parentNode;if(!g){var f=e.id;var a=window.document.createElement("canvas");a.id="temp-table-id-"+e.id;a.width=e.hasAttribute("data-width")?e.getAttribute("data-width"):500;a.height=e.hasAttribute("data-height")?e.getAttribute("data-height"):500;CanvasXpress.transferDatasetAttributes(e,a);d.appendChild(a);new CanvasXpress("temp-table-id-"+e.id,f)}}}};CanvasXpress.getObject=function(f,b){if(f){while(CanvasXpress.chain.hasOwnProperty(f)){f=CanvasXpress.chain[f]}for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==f){return CanvasXpress.instances[a]}}}else{if(b){var d=window.document.getElementById(f);if(!d){var e=window.document.createElement("canvas");e.id=f;e.width=100;e.height=100;window.document.body.appendChild(e);d=new CanvasXpress({renderTo:f})}return d}else{if(CanvasXpress.instances.length){return CanvasXpress.instances[0]}}}};CanvasXpress.json=function(a,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="json";b.onload=function(){var d=b.status;if(d==200){c(null,b.response)}else{c(d)}};b.send()};CanvasXpress.csv=function(a,c){var b=new XMLHttpRequest();b.open("GET",a,true);b.responseType="text";b.onload=function(){var d=b.status;if(d==200){c(null,b.response)}else{c(d)}};b.send()};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(b,a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(b,a)}};CanvasXpress.create=function(c,b,a){CanvasXpress.inject(c);return new CanvasXpress(id,b,a)};CanvasXpress.createObject=function(f,d,b,c,e,h,g,a){if(!f){throw new Error("No target provided")}else{if(typeof(f)=="object"&&f.renderTo){d=f.tracks?{tracks:f.tracks}:f.nodes?{nodes:f.nodes}:f.venn?{venn:f.venn}:f.data?f.data:false;b=f.config||false;if(f.version){b.createVersion=f.version}if(f.factory){b.createFactory=f.factory}c=f.events||false;e=f.info?f.info.replace(/'/g,"'").replace(/"/g,"'"):false;h=f.afterRender||false;g=f.callback||false;a=f.noValidate?f.noValidate:b&&b.noValidate?b.noValidate:false;f=f.renderTo;CanvasXpress.inject(f)}else{if(typeof f==="string"||f instanceof String){CanvasXpress.inject(f)}}}return{target:f,data:d,config:b,events:c,info:e,afterRender:h,callback:g,noValidate:a}};CanvasXpress.inject=function(c){if(typeof c==="string"||c instanceof String){var b=document.getElementById(c);if(b!==null){if(b.tagName.toLowerCase()=="canvas"){if(!b.width){b.width=500}if(!b.height){b.height=500}}else{if(b.tagName.toLowerCase()=="div"){b.id=c+"-div";var a=document.createElement("canvas");a.id=c;a.width=500;a.height=500;b.appendChild(a)}}}else{var a=document.createElement("canvas");a.id=c;a.width=500;a.height=500;document.body.appendChild(a)}}};CanvasXpress.prototype.init=function(f,d,b,c,e,h,g,a){this.N5=function(i){this.target=i.target;this.events=i.events;this.info=i.info;this.userId=1;this.url={};this.meta={ids:{},time:{start:parseInt(performance.timeOrigin),current:0,end:null,elapsed:[]},data:false,canvas:{},config:{user:i.config,orig:{},vals:{},remote:false},ggplot:{aes:{},config:[],coords:[],data:[],facet:[],geoms:[],labels:{},layers:{},order:{},scales:[],theme:[],map:{}},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},console:[],events:{},state:{save:0,clip:false,translate:[0,0],rotate:[0],scale:[1,1],last:{translate:[0,0],rotate:[0],scale:[1,1]}},stack:[],def:{},dom:{},layout:{}};this.config={};this.legend={color:{},shape:{},size:{},sample:{},variable:{},line:{},pattern:{},outline:{},connect:{},contour:{},bin2d:{},decoration:{},oncoprint:{},overlays:{},colorNode:{},shapeNode:{},sizeNode:{},patternNode:{},colorEdge:{},sizeEdge:{},colorLabel:{},sizeLabel:{}};this.scales={};this.panel={};this.plot={}};this.wu=function(i){var k=this.meta.time.current||performance.now();if(!i){i=""}var j=performance.now();this.meta.time.elapsed.push([i,parseInt(j-k),parseInt(j)]);this.meta.time.current=j};this.GW=function(i){this.gh(i);this.qS(i);this.eg(i);this.jk(i);this.sK(i)};this.gh=function(j){if(typeof(j.data)=="function"){try{j.data=d.call(this)}catch(i){alert("Not a valid Data object:\n"+i)}}else{if(!j.noValidate){try{JSON.stringify(j.data)}catch(i){alert("Data object malformed:\n"+i)}}}};this.qS=function(j){if(j.config){if(typeof(j.config)=="function"){try{j.config=j.config.call(this)}catch(i){alert("Not a valid Data object:\n"+i)}}else{if(!j.noValidate){try{JSON.stringify(j.config)}catch(i){alert("Config object malformed:\n"+i)}}}}};this.eg=function(i){};this.jk=function(i){if(!i.info){i.info=""}};this.sK=function(j){if(j.afterRender){try{JSON.stringify(j.afterRender)}catch(i){alert("AfterRender object malformed:\n"+i)}}};this.hu=function(i){if(!i){i=this}if(i.transposeData){return true}if(i.transformData){}if(i.asSampleFactors&&i.asSampleFactors.length){return true}if(i.asVariableFactors&&i.asVariableFactors.length){return true}if(i.stringSampleFactors&&i.stringSampleFactors.length){return true}if(i.stringVariableFactors&&i.stringVariableFactors.length){return true}if(i.stringNodeAttributes&&i.stringNodeAttributes.length){return true}if(i.stringEdgeAttributes&&i.stringEdgeAttributes.length){return true}if(i.histogramData){return true}if(i.ridgeBy){return true}if(i.sortData&&i.sortData.length){return true}if(i.asDOE){}return false};this.Vs=function(l){var k=[];if(l.histogramData||l.ridgeBy){if(l.histogramData===true&&l.colorBy){k.unshift(["createHistogram",[],{}])}else{k.unshift(["createHistogram",[l.ridgeBy||l.histogramData||l.colorBy],{}])}}if(l.stringVariableFactors&&l.stringVariableFactors.length){for(var j=0;j<l.stringVariableFactors.length;j++){k.unshift(["switchNumericToString",[l.stringVariableFactors[j]],{}])}}if(l.stringSampleFactors&&l.stringSampleFactors.length){for(var j=0;j<l.stringSampleFactors.length;j++){k.unshift(["switchNumericToString",[l.stringSampleFactors[j],true],{}])}}if(l.stringNodeAttributes&&l.stringNodeAttributes.length){for(var j=0;j<l.stringNodeAttributes.length;j++){k.unshift(["switchNumericToString",[l.stringNodeAttributes[j],false],{}])}}if(l.stringEdgeAttributes&&l.stringEdgeAttributes.length){for(var j=0;j<l.stringEdgeAttributes.length;j++){k.unshift(["switchNumericToString",[l.stringEdgeAttributes[j],true],{}])}}if(l.asVariableFactors&&l.asVariableFactors.length){for(var j=0;j<l.asVariableFactors.length;j++){k.unshift(["switchVarToAnnotation",[l.asVariableFactors[j]],{}])}}if(l.asSampleFactors&&l.asSampleFactors.length){for(var j=0;j<l.asSampleFactors.length;j++){k.unshift(["switchSmpToAnnotation",[l.asSampleFactors[j]],{}])}}if(l.transposeData){k.unshift(["transpose",[false,true],{}])}if(l.transformData){k.unshift(["transform",[l.transformData,l.transformAxis,false,true],{}])}if(l.sortData&&l.sortData.length){for(var j=0;j<l.sortData.length;j++){k.push(["modifySort",[l.sortData[j][0],l.sortData[j][1],l.sortData[j][2],false,j==this.sortData.length-1?true:false],{}])}}if(l.asDOE){k.push(["createDOE",[],{}])}return k};this.lA=function(){if(this.isCxplot&&this.meta.config.user.aes){var i=this.meta.config.user.aes;if(i.stringVariableFactors){this.stringVariableFactors=this.ZD(i.stringVariableFactors)}if(i.stringSampleFactors){this.stringSampleFactors=this.ZD(i.stringSampleFactors)}if(i.asVariableFactors){this.asVariableFactors=this.ZD(this.asVariableFactors)}if(i.asSampleFactors){this.asSampleFactors=this.ZD(i.asSampleFactors)}}};this.AH=function(q){this.afterRendering=true;if(!q){q=[]}var B=this.meta.time.start;var y=this.graphType=="Scatter2D"&&this.scatterType=="visium";this.lA();if(this.histogramData||this.ridgeBy){if(this.histogramData===true){q.push(["createHistogram",[],{},B,true])}else{q.push(["createHistogram",[this.ridgeBy||this.histogramData],{},B,true])}this.histogramData=false;delete (CanvasXpress.stack[this.target].config.histogramData)}if(this.stringVariableFactors.length){for(var o=0;o<this.stringVariableFactors.length;o++){q.unshift(["switchNumericToString",[this.stringVariableFactors[o],false],{},B,true])}this.stringVariableFactors=[];this.layoutRestore=false}if(this.stringSampleFactors.length){for(var o=0;o<this.stringSampleFactors.length;o++){q.unshift(["switchNumericToString",[this.stringSampleFactors[o],true],{},B,true])}this.stringSampleFactors=[];this.layoutRestore=false}if(this.stringNodeAttributes.length){for(var o=0;o<this.stringNodeAttributes.length;o++){q.unshift(["switchNumericToString",[this.stringNodeAttributes[o],false],{},B,true])}this.stringNodeAttributes=[];this.layoutRestore=false}if(this.stringEdgeAttributes.length){for(var o=0;o<this.stringEdgeAttributes.length;o++){q.unshift(["switchNumericToString",[this.stringEdgeAttributes[o],true],{},B,true])}this.stringEdgeAttributes=[];this.layoutRestore=false}if(this.asVariableFactors.length){for(var o=0;o<this.asVariableFactors.length;o++){q.unshift(["switchVarToAnnotation",[this.asVariableFactors[o],false],{},B,true])}this.asVariableFactors=[];this.layoutRestore=false}if(this.asSampleFactors.length){for(var o=0;o<this.asSampleFactors.length;o++){q.unshift(["switchSmpToAnnotation",[this.asSampleFactors[o],false],{},B,true])}this.asSampleFactors=[];this.layoutRestore=false}if(this.transposeData){q.unshift(["transpose",[false,this.sortData.length||this.selectedDataPoints.length],{},B,true]);this.transposeData=false;delete (CanvasXpress.stack[this.target].config.transposeData)}if(this.sortData){for(var o=0;o<this.sortData.length;o++){q.push(["modifySort",[this.sortData[o][0],this.sortData[o][1],this.sortData[o][2],false,o==this.sortData.length-1?true:false],{},B,true])}this.sortData=[];delete (CanvasXpress.stack[this.target].config.sortData)}if(this.selectedDataPoints.length&&this.xAxisIndices&&this.xAxisIndices.length&&this.yAxisIndices&&this.yAxisIndices.length){var x=false;for(var o=0;o<this.selectedDataPoints.length;o++){var n=this.qv(this.selectedDataPoints[o]);if(n>=0){this.ZZ([n,this.xAxisIndices[0],this.yAxisIndices[0]]);x=true}}if(x){q.unshift(["broadcastDraw",[{func:"afterRender"}],{},B,true])}}var r=q.length-1;var k=false;for(var o=0;o<q.length;o++){var m=q[o];var u=m.shift();if(u){var j=m.length>0?m.shift():[];var w=m.length>0?m.shift():{};var A=m.length>0?m.shift():B;var p=m.length>0?m.shift():false;if(this.showFunctionNamesAfterRender){this.oC(20,20,u)}var l=q[o+1]&&q[o+1][0]&&q[o+1][0].match(/drag/i)?true:false;this.skipRender=u=="createDOE"||u=="createHistogram"||u=="modifyColorScheme"||u.match(/segregate/)||l?false:!this.showTransition&&o<r?true:this.view=="table"?false:false;if(u.match(/switch/)){this.skipRender=o<r?true:false}for(var s in w){this[s]=w[s]}if(u.match(/switch/)&&y&&o==r){k=true}if(this[u]){this[u].apply(this,j)}if(u.match(/switch|clickGraphMaxMin/)&&o==r&&!k){this.j8()}if(u=="moveCanvas"){CanvasXpress.stack[this.target].afterRender.push([u,j])}if(p){var z=CanvasXpress.stack[this.target].afterRender.length-1;CanvasXpress.stack[this.target].afterRender[z][4]=true}if(k){this.CA()}}}if(this.asDOE&&this.uf()){this.iA(this.asDOE)}if(this.view=="table"){this.view="canvas";this.WX()}else{if(this.view=="layout"){this.view="canvas";this.Hd(false,false,"none")}}this.Ki("afterRender");this.afterRendering=false};this.yh=function(){if(window.location.search!=""){var l=location.search.substring(1).split("&");for(var k=0;k<l.length;k++){var j=l[k].split("=");if(!j[0]){continue}if(j[0].match(/^cX/)){this.url[j[0]]=j[1]||true}else{this.url[j[0]]=j[1]=="false"?false:j[1]=="true"?true:j[1]}}}};this.Hz=function(){var o=CanvasXpress.alias.split("#");var r=o.pop().split("");var q=o.shift().split("");var v={};for(var m=0;m<r.length;m++){v[q[m]]=r[m]}for(var m=0;m<o.length;m++){var u=o[m].split("");var k=u.length;var s="";for(var l=0;l<k-2;l++){s+=v[u[l]]}var p=u[k-2]+u[k-1];if(this[p]){this[s]=this[p]}}};this.h3=function(){if(this.url.hasOwnProperty("cXprint")||this.printThumbnail){this.printThumbnail=false;var j=this.url.cXprint!==true&&this.url.cXprint!=="true"?this.url.cXprint:this.saveFilename?this.saveFilename:this.target+".png";var i=this;var k=function(l,m){i.Ff(l,m);setTimeout(function(){window.close()},4000)};i.Mk(false,j,k)}else{if(this.url.hasOwnProperty("cXprintBase64")||this.cacheBase64){this.cacheBase64=false;var k=function(){return};if(CanvasXpress.$(this.target)){this.Mk(false,false,k)}}}};this.T4=function(m,l){var j=this;var i=window;var k=j.$w;if(this.verbose){i[k(8)][k(31)][k(32)](m)}};this.Ki=function(l,j){var k=this;var i=function(){var m=j||k;if(m.graphType=="Map"&&m.mapId&&!window[m.mapId]){return}if(m.fonts&&m.fonts.length>0&&!CanvasXpress.readyFonts){CanvasXpress.readyFonts=true;return}m.T4("canvasXpress data ready - "+l);m.h3();CanvasXpress.ready=true};if(CanvasXpress.cacheImagesReady){if(l=="afterRender"){if(!this.isAnimation&&!this.isTransitionOn&&!this.isUpdateRemoteData){i()}}else{if(this.graphType=="Network"){if(!this.isAnimation&&!this.isUpdateRemoteData){i()}}else{if(!this.isTransitionOn){i()}}}}};this.iS=function(){CanvasXpress.stack[this.target].stateCX.push(this.tD())};this.fo=function(){var j=CanvasXpress.stack[this.target];var i=this.hu();this.Yh(false,false,false,false,false,false,i);this.AH(j.afterRenderInit);this.iS();CanvasXpress.current=this.target;this.meta.time.end=parseInt(performance.now());this.Jb()};this.dU=function(){if(!this.lazyLoad||(!this.loaded&&this.hW(this.meta.canvas.ctx.canvas))){this.fo()}};this.A2=function(j){var i=this;i.N5(j);i.wu("init");i.yh();i.GW(j);i.nb();i.Hz();i.PW();i.Cb();i.cQ(j.config);i.Qp();i.CZ();i.cA();i.LH(j.data);i.wu("initData");i.mW();i.nt();i.Bk();i.Al();i.fO(j.data,j.config,j.events,j.info,j.afterRender);i.Ec();i.Hz();i.dU()};this.VL=function(j){try{CanvasXpress}catch(i){return false}CanvasXpress.instances.push(this);this.initIO();this.initDOM();this.initSVG();this.initInterface();this.initSave();this.initConfig();this.initDate();this.initViewport();this.initPrimitives();this.initUtils();this.initNumeric();this.initjLouvain();this.initCola();this.initCrypt();this.initMathUtils();this.initLegendUtils();this.initMarkerUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initExample();this.initDataUtils();this.initRandom();this.initData();this.initFunctionData();this.initLayout();this.initEvents();this.initTooltip();this.initTooltipMouse();this.initTooltipDiv();this.initToolbar();this.initTabpanel();this.initMenus();this.initLinks();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initCustomizer();this.initAnimation();this.initRemote();this.initAxes();this.initGraph();this.initCxplot();this.A2(j)};if(!f){throw new Error("No target provided")}else{if(typeof(f)=="object"&&f.isGGPlot){return new cxplot(f)}else{this.VL(CanvasXpress.createObject(f,d,b,c,e,h,g,a))}}};CanvasXpress.prototype.initIO=function(){this.c9=function(s,r){try{return JSON.parse(s,r)}catch(e){if(s.toString().match(/<!DOCTYPE/)){return undefined}else{if(r){return JSON.parse(s,r)}else{return JSON.parse(s,function(k,v){if(typeof v==="string"&&v.startsWith&&v.startsWith("/Function(")&&v.endsWith&&v.endsWith(")/")){v=v.substring(10,v.length-2).replace(/&quot;/g,'"');return eval("("+v+")")}else{return v}})}}}};this.uY=function(js,r,s){if(r){return JSON.stringify(js,r,s||null)}else{return js?JSON.stringify(js,function(k,v){if(typeof v==="function"){return"/Function("+v.toString().replace(/"/g,"&quot;").replace(/{\s*/g,"{").replace(/;\s*/g,";")+")/"}else{if(k=="events"&&typeof v==="object"){return v}else{if(k=="stateCX"||k=="stateIndexCX"||k=="gantt"){return undefined}else{if(v instanceof Array){for(var i=0;i<v.length;i++){if(typeof v[i]==="string"){v[i]=v[i].replace(/\[/g,"&lsqb;").replace(/\]/g,"&rsqb;").replace(/\{/g,"&lcub;").replace(/\}/g,"&rcub;")}}for(var p in v){if(Array.isArray(v[p])||v[p] instanceof Object){return v}}return JSON.stringify(v)}else{return v}}}}},s||null).replace(/\\n/g,"").replace(/\\/g,"").replace(/"\[/g,"[").replace(/\]"/g,"]").replace(/"\{/g,"{").replace(/\}"/g,"}").replace(/u0000/g,"").replace(/&lsqb;/g,"[").replace(/&rsqb;/g,"]").replace(/&lcub;/g,"{").replace(/&rcub;/g,"}"):false}};this.yi=function(str){function bwt_reverse(src,primary){var len=src.length;if(primary>=len){throw RangeError("Out of bound")}if(primary<0){throw RangeError("Out of bound")}var A=src;src=src.join("");A.sort();var start={};for(var i=len-1;i>=0;i--){start[A[i]]=i}var links=[];for(i=0;i<len;i++){links.push(start[src[i]]++)}var i,first=A[i=primary],ret=[];for(var j=1;j<len;j++){ret.push(A[i=links[i]])}return first+ret.reverse().join("")}function move_to_front_and_store(a,c,buff){var v=a[c];for(var i=c;i>0;a[i]=a[--i]){}buff.push(a[0]=v)}var RBitfield=function(){this.initbit=function(x){this.masks=[];for(var i=0;i<31;i++){this.masks[i]=(1<<i)-1}this.masks[31]=-2147483648;this.f=x;this.bits=0;this.bitfield=0;this.count=0};this.readbits2=function readbits2(n){var n2=n>>1;return this.readbits(n2)*(1<<n2)+this.readbits(n-n2)};this.readbits=function readbits(n){while(this.bits<n){this.bitfield=(this.bitfield<<8)+this.f.charCodeAt(this.count++);this.bits+=8}var m=this.masks[n];var r=(this.bitfield>>(this.bits-n))&m;this.bits-=n;this.bitfield&=~(m<<this.bits);return r}};var HuffmanLength=function(code,bits){this.code=code;this.bits=bits;this.symbol=undefined};var OrderedHuffmanTable=function(){this.process=function(lengths){var len=lengths.length;var z=[];for(var i=0;i<len;i++){z.push([i,lengths[i]])}z.push([len,-1]);var l=[];var b=z[0];var start=b[0],bits=b[1];for(var p=1;p<z.length;p++){var finish=z[p][0],endbits=z[p][1];if(bits){for(var code=start;code<finish;code++){l.push(new HuffmanLength(code,bits))}}start=finish;bits=endbits;if(endbits==-1){break}}l.sort(function(a,b){return(a.bits-b.bits)||(a.code-b.code)});this.table=l;var temp_bits=0;var symbol=-1;this.faht=[];var cb=null;for(var i=0;i<this.table.length;i++){var x=this.table[i];symbol+=1;if(x.bits!=temp_bits){symbol<<=x.bits-temp_bits;cb=this.faht[temp_bits=x.bits]={}}cb[x.symbol=symbol]=x}this.min_bits=16;this.max_bits=-1;this.table.forEach(function(x){if(x.bits<this.min_bits){this.min_bits=x.bits}if(x.bits>this.max_bits){this.max_bits=x.bits}},this)}};var decode=function(input){var b=new RBitfield();b.initbit(input);b.readbits(16);var method=b.readbits(8);if(method!=104){throw"Unknown (not type 'h'uffman Bzip2) compression method"}var blocksize=b.readbits(8);if(49<=blocksize&&blocksize<=57){blocksize-=48}else{throw"Unknown (not size '1'-'9') Bzip2 blocksize"}function getUsedCharTable(b){var a=[];var used_groups=b.readbits(16);for(var m1=1<<15;m1>0;m1>>=1){if(!(used_groups&m1)){for(var i=0;i<16;i++){a.push(false)}continue}var used_chars=b.readbits(16);for(var m2=1<<15;m2>0;m2>>=1){a.push(Boolean(used_chars&m2))}}return a}var out=[];function main_loop(){while(true){var blocktype=b.readbits2(48);var crc=b.readbits2(32);if(blocktype==54156738319193){if(b.readbits(1)){throw"Bzip2 randomised support not implemented"}var pointer=b.readbits(24);var used=getUsedCharTable(b);var huffman_groups=b.readbits(3);if(2>huffman_groups||huffman_groups>6){throw RangeError("Bzip2: Number of Huffman groups not in range 2..6")}var mtf=[0,1,2,3,4,5,6].slice(0,huffman_groups);var selectors_list=[];for(var i=0,selectors_used=b.readbits(15);i<selectors_used;i++){var c=0;while(b.readbits(1)){if(c++>=huffman_groups){throw RangeError("More than max ("+huffman_groups+") groups")}}move_to_front_and_store(mtf,c,selectors_list)}var groups_lengths=[];var symbols_in_use=used.reduce(function(a,b){return a+b},0)+2;for(var j=0;j<huffman_groups;j++){var length=b.readbits(5);var lengths=[];for(var i=0;i<symbols_in_use;i++){if(length<0||length>20){throw RangeError("Bzip2 Huffman length code outside range 0..20")}while(b.readbits(1)){length-=(b.readbits(1)*2)-1}lengths.push(length)}groups_lengths.push(lengths)}var tables=[];for(var g=0;g<groups_lengths.length;g++){var codes=new OrderedHuffmanTable();codes.process(groups_lengths[g]);tables.push(codes)}var favourites=[];for(var c=used.length-1;c>=0;c--){if(used[c]){favourites.push(String.fromCharCode(c))}}favourites.reverse();var selector_pointer=0;var decoded=0;var t;var repeat=0;var repeat_power=0;var buffer=[],r;while(true){if(--decoded<=0){decoded=50;if(selector_pointer<=selectors_list.length){t=tables[selectors_list[selector_pointer++]]}}for(var bb in t.faht){if(b.bits<bb){b.bitfield=(b.bitfield<<8)+b.f.charCodeAt(b.count++);b.bits+=8}if(r=t.faht[bb][b.bitfield>>(b.bits-bb)]){b.bitfield&=b.masks[b.bits-=bb];r=r.code;break}}if(0<=r&&r<=1){if(repeat==0){repeat_power=1}repeat+=repeat_power<<r;repeat_power<<=1;continue}else{var v=favourites[0];for(;repeat>0;repeat--){buffer.push(v)}}if(r==symbols_in_use-1){break}else{move_to_front_and_store(favourites,r-1,buffer)}}var nt=bwt_reverse(buffer,pointer);var done=[];var i=0;var len=nt.length;while(i<len){var c=nt.charCodeAt(i);if((i<len-4)&&nt.charCodeAt(i+1)==c&&nt.charCodeAt(i+2)==c&&nt.charCodeAt(i+3)==c){var c=nt.charAt(i);var rep=nt.charCodeAt(i+4)+4;for(;rep>0;rep--){done.push(c)}i+=5}else{done.push(nt[i++])}}out.push(done.join(""))}else{if(blocktype==25779555029136){b.readbits(b.bits&7);break}else{throw"Illegal Bzip2 blocktype = 0x"+blocktype.toString(16)}}}}main_loop();return out.join("")};return decode(str)};this.af=function(str){isNumber=function(n){return n===null||n===undefined?true:!isNaN(parseFloat(n))&&isFinite(n)};if(str.match(/^<\?xml/)){return false}var tc=str.split(",").length-1;var tt=str.split("\t").length-1;var ts=str.split(";").length-1;if(tc<2&&tt<2&&ts<2){return false}var delim=tc>tt&&tc>ts?",":ts>tc&&ts>tt?";":"\t";var pat=new RegExp(("(\\"+delim+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+delim+"\\r\\n]*))"),"gi");var arr=[[]];var arrM=null;while(arrM=pat.exec(str)){var strM=arrM[1];if(strM.length&&strM!==delim){arr.push([])}var strV;if(arrM[2]){strV=arrM[2].replace(new RegExp('""',"g"),'"')}else{strV=arrM[3]}arr[arr.length-1].push(isNumber(strV)?Number(strV):strV!="NA"?strV:null)}for(var i=0;i<arr.length;i++){if(arr[i][0].toString().match(/^#/)){arr.splice(i,1);i--;continue}}var l=arr.length-1;while(arr[l].length==1&&arr[l][0].toString()==""){arr.pop();l=arr.length-1}return arr};this.k8=function(x){var d=null;if(window.DOMParser){try{d=(new DOMParser()).parseFromString(x,"text/xml")}catch(e){d=null}}else{if(window.ActiveXObject){try{d=new ActiveXObject("Microsoft.XMLDOM");d.async=false}catch(e){d=null}}else{alert("cannot parse xml string!")}}return d};this.FV=function(gml){var forIn=function(object,callback){Object.keys(object).forEach(function(key){callback(key,object[key])})};var json=("{\n"+gml+"\n}").replace(/^(\s*)(\w+)\s*\[/gm,'$1"$2": {').replace(/^(\s*)\]/gm,"$1},").replace(/^(\s*)(\w+)\s+(.+)$/gm,'$1"$2": $3,').replace(/,(\s*)\}/g,"$1}");var graph={};var nodes=[];var edges=[];var i=0;json=json.replace(/^(\s*)"node"/gm,function(all,indent){return(indent+'"node['+(i++)+']"')});i=0;json=json.replace(/^(\s*)"edge"/gm,function(all,indent){return(indent+'"edge['+(i++)+']"')});try{json=this.c9(json)}catch(err){throw new SyntaxError("bad format")}if(!json.graph instanceof Object){throw new SyntaxError("no graph tag")}forIn(json.graph,function(key,value){var matches=key.match(/^(\w+)\[(\d+)\]$/);var name;var i;if(matches){name=matches[1];i=parseInt(matches[2],10);if(name==="node"){nodes[i]=value}else{if(name==="edge"){edges[i]=value;edges[i].id1=edges[i].source;edges[i].id2=edges[i].target;delete (edges[i].source);delete (edges[i].target)}else{graph[key]=value}}}else{graph[key]=value}});graph.nodes=nodes;graph.edges=edges;return{data:graph,config:{graphType:"Network"}}};this.MR=function(xml,json,p,current){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p){json[p].push(j)}}else{if(p=="alt"){json[p].push(xml.textContent.replace(/\"/g,"'").replace(/\[/g,"&#91").replace(/\]/g,"&#93"))}}if(xml.hasChildNodes()&&!current){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();this.MR(n,json,p)}}}}}return json};this.ir=function(b){var d=function(n,l){var o="";for(var m=0;m<4;m++){o+=String.fromCharCode(n.getUint8(l+m))}return o=="tEXt"};var c=function(o,m,l){var p="";for(var n=0;n<l;n++){p+=String.fromCharCode(o.getUint8(m+n))}return p.match(/CanvasXpress/)};var a=new DataView(b);var f=a.getUint32(8);var h=a.getUint32(8+4+4+f+4);if(d(a,8+4+4+f+4+4)&&c(a,8+4+4+f+4+4+4,h)){var k=a.getUint32(8+4+4+f+4+4+4+h+4);var g=8+4+4+f+4+4+4+h+4+4+4;var j="";for(var e=0;e<k;e++){j+=String.fromCharCode(a.getUint8(g+e))}j=j.replace("ReproducibleResearch\0","");return this.c9(j)}else{alert("Oooops! Not a valid CanvasXpress Image")}};this.we=function(x){var d=this.k8(x);var s=d.childNodes[0];if(s.tagName.match(/svg/i)){var d=s.getAttribute("desc");if(d){return this.c9(d)}}};this.wD=function(arr,config){var unique=function(a){return a.filter(function(x,i){return a.indexOf(x)===i})};var isDate=function(arr){var check=function(v){if(toString.call(v)==="[object Date]"){return true}if(typeof v.replace==="function"){v.replace(/^\s+|\s+$/gm,"")}var f=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return f.test(v)};var n=arr.length;for(var i=0;i<n;i++){if(arr[i]!=null&&!check(arr[i])){return false}}return true};var isNumeric=function(n){return n===null||n===undefined?true:!isNaN(parseFloat(n))&&isFinite(n)};var data={y:{vars:[],smps:[],data:[]}};var g="Scatter2D";var cols=arr[0].filter(Number.isFinite);var mts=false;if(cols.length==0){cols=arr.shift()}else{cols=[];mts=true;for(var i=0;i<arr[0].length;i++){cols.push("C"+(i+1))}}var rows=[];var hasDot=false;for(var i=0;i<arr.length;i++){var v=arr[i][0];if(v!=null){rows.push(arr[i][0].toString());if(arr[i][0].toString().match(/\./)){hasDot=true}}}var urow=unique(rows);if(urow.length==rows.length&&!hasDot){for(var i=0;i<arr.length;i++){arr[i].shift(arr[i][0])}}else{rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}if(cols.length>arr[0].length){cols.shift();if(!cols.length==arr[0].length){return false}}if(arr[0].length!=arr[arr.length-1].length){arr.pop();rows.pop();if(arr[0].length!=arr[arr.length-1].length){return false}}var isrd=isDate(rows);if(isrd){cols.unshift("Date");for(var i=0;i<rows.length;i++){arr[i].unshift(new Date(rows[i]))}rows=[];for(var i=0;i<arr.length;i++){rows.push("R"+(i+1))}}var iscd=isDate(cols);var types=[];var yAxis=[];var total=0;for(var i=0;i<cols.length;i++){types[i]=false;for(var j=0;j<rows.length;j++){if(isNaN(arr[j][i])){types[i]=true;break}}if(!types[i]){for(var j=0;j<rows.length;j++){if(i==0&&isrd){continue}else{arr[j][i]=arr[j][i]==null||arr[j][i]==undefined?null:!isNaN(parseFloat(arr[j][i]))&&isFinite(arr[j][i])?Number(arr[j][i]):null}}total++}else{data.z={}}}var ts=true;var uts={};for(var i=0;i<types.length;i++){if(!types[i]&&!isNumeric(arr[0][i])){ts=false;break}else{var v=arr[0][i];if(v!=null){if(uts.hasOwnProperty(arr[0][i].toString())){ts=false;break}else{uts[arr[0][i].toString()]=true}}}}if(ts&&mts){if(data.z){delete data.z;data.x={}}}var trans=false;if(total>1){var n=Math.ceil(total*0.6);var q=0;for(var i=types.length-1;i>=0;i--){if(!types[i]){q++}else{if(q<n){trans=true}}}}if(config&&config.topoJSON){delete data.z;data.x={};data.y.vars.push("Dummy");var ii=0;for(var i=ii;i<rows.length;i++){data.y.smps.push(rows[i])}data.y.data=[[0]];for(var i=0;i<cols.length;i++){data.x[cols[i]]=[];for(var j=0;j<rows.length;j++){data.x[cols[i]].push(arr[j][i])}}}else{if(ts&&mts){var ii=1;for(var i=0;i<cols.length;i++){if(types[i]){data.x[arr[0][i]]=[]}else{data.y.vars.push("V"+ii);ii++}}data.y.smps=["Time"];for(var i=1;i<rows.length;i++){yAxis.push(rows[i]);data.y.smps.push(rows[i])}var ii=0;for(var i=0;i<cols.length;i++){if(types[i]){for(var j=0;j<rows.length;j++){data.x[arr[0][i]].push(j==0?"":arr[j][i])}}else{data.y.data[ii]=[];for(var j=0;j<rows.length;j++){data.y.data[ii][j]=arr[j][i]}ii++}}}else{for(var i=0;i<rows.length;i++){data.y.data[i]=[];data.y.vars.push(rows[i])}for(var i=0;i<cols.length;i++){if(config&&config.isCxplot){var str=config.aes.hasOwnProperty("stringSampleFactors")&&config.aes.stringSampleFactors.includes(cols[i])?true:false;if(!types[i]&&(cols[i]==config.aes.x||cols[i]==config.aes.y||cols[i]==config.aes.z)&&!str){data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}else{if(!data.z){data.z={}}data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}}else{if(config&&config.metaData&&config.metaData.hasOwnProperty(cols[i])){data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}else{if(types[i]){data.z[cols[i]]=[];for(var j=0;j<rows.length;j++){data.z[cols[i]].push(arr[j][i])}}else{data.y.smps.push(cols[i]);for(var j=0;j<rows.length;j++){data.y.data[j].push(arr[j][i])}}}}}}}if(data.y.smps.length==0){var n=data.y.data.length;data.y.data=[[]];for(var i=0;i<n;i++){data.y.data[0].push(1)}data.y.smps=data.y.vars;data.y.vars=["counts"];data.x=data.z;delete (data.z);g="Bar"}else{if(data.y.smps.length==1||(trans&&(!config||(config&&!config.topoJSON)))){var trp=function(mat){return mat[0].map(function(_,c){return mat.map(function(r){return r[c]})})};data.y.data=trp(data.y.data);data.y.vars=data.y.smps;data.y.smps=rows;data.x=data.z;delete (data.z);g="Bar"}}if(ts&&mts){return{data:data,config:{graphType:g,xAxis:["Time"],yAxis:yAxis,scatterType:"line"}}}else{return{data:data,config:{graphType:g}}}};this.dL=function(arr,target,config,events,data,type){var obj={data:{nodes:[],edges:[]}};if(data){var map={};var cols=arr[0];var nodes=0;var edges=0;var fail=0;for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(data.nodeIndices.hasOwnProperty(n)&&data.nodeIndices.hasOwnProperty(m)){edges++}else{if(data.nodeIndices.hasOwnProperty(n)){nodes++}else{fail++}}map[n]=i}if(!nodes&&!edges){for(var i=0;i<data.nodes.length;i++){var n=data.nodes[i];if(n.hasOwnProperty("extId")&&map.hasOwnProperty(n.extId)){arr[map[n.extId]][0]=n.id;nodes++}}}if(edges>nodes){nodes=0;edges=0;fail=0;type="edge";for(var i=1;i<arr.length;i++){var n=arr[i][0];var m=arr[i][1];if(data.nodeIndices.hasOwnProperty(n)&&data.nodeIndices.hasOwnProperty(m)){edges++;obj[n+":"+m]={};for(var j=2;j<cols.length;j++){obj[n+":"+m][cols[j]]=arr[i][j]}}else{fail++}}}else{if(nodes>8){nodes=0;edges=0;fail=0;type="node";for(var i=1;i<arr.length;i++){var n=arr[i][0];if(data.nodeIndices.hasOwnProperty(n)){nodes++;obj[n]={};for(var j=1;j<cols.length;j++){obj[n][cols[j]]=arr[i][j]}}else{fail++}}}else{return arr}}if((type=="edge"&&(edges>5||edges>=arr.length-1))||(type=="node"&&(nodes>5||nodes>=arr.length-1))){return{data:obj,rows:Math.max(nodes,edges),fail:fail,type:type}}else{return arr}}else{if(!type||type=="edge"){var done={};for(var i=1;i<arr.length;i++){var i1=arr[i][0];var i2=arr[i][1];if(i1&&i2){var n1={id:i1};var n2={id:i2};var e={id1:i1,id2:i2};for(var j=2;j<arr[i].length;j++){n1[arr[0][j]]=arr[i][j];n2[arr[0][j]]=arr[i][j];e[arr[0][j]]=arr[i][j]}if(!done.hasOwnProperty(i1)){obj.data.nodes.push(n1);done[i1]=true}if(!done.hasOwnProperty(i2)){obj.data.nodes.push(n2);done[i2]=true}obj.data.edges.push(e)}}obj.renderTo=target;obj.config=config?config:obj.config={graphType:"Network"};obj.events=events}}return obj};this.WL=function(xml,target,config,events){var nodes=[];var edges=[];var cl=true;var gexf=xml.childNodes[0];if(gexf.tagName.toLowerCase()=="gexf"){for(var i=0;i<gexf.childNodes.length;i++){var el=gexf.childNodes[i];if(el.nodeName&&el.nodeName.toLowerCase()=="graph"){for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="nodes"){for(var k=0;k<nd.childNodes.length;k++){var n=nd.childNodes[k];if(n.nodeName&&n.nodeName.toLowerCase()=="node"){var js=this.MR(n);var node={};if(js.id){for(var p in js){switch(p.toLowerCase()){case"id":node.id=js.id;break;case"label":node.name=js.label;break;case"color":node.color="rgb("+js[p][0].r+","+js[p][0].g+","+js[p][0].b+")";break;case"position":node.x=Number(js[p][0].x);node.y=Number(js[p][0].y);node.z=Number(js[p][0].z);cl=false;break;case"size":node.width=Number(js[p][0].value);node.height=Number(js[p][0].value);break}}nodes.push(node)}}}}else{if(nd.nodeName&&nd.nodeName.toLowerCase()=="edges"){for(var k=0;k<nd.childNodes.length;k++){var e=nd.childNodes[k];if(e.nodeName&&e.nodeName.toLowerCase()=="edge"){js=this.MR(e);var edge={};if(js.source&&js.target){edge.id1=js.source;edge.id2=js.target;edges.push(edge)}}}}}}}}}else{alert("Ooops! Not a Gephi gexf file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{graphType:"Network",calculateLayout:cl,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Gephi"},renderTo:target,events:events,afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}return data};this.l1=function(xml,target,config,events){var that=this;var loc={3:"microsome",13:"epr",21:"lysosome",43:"nucleus",67:"golgi",1287:"mitochondria",1312:"peroxisome"};var ctx=window.document.createElement("canvas").getContext("2d",{willReadFrequently:true});var wrapText=function(str,width){var re=new RegExp("(?![^\\n]{1,"+width+"}$)([^\\n]{1,"+width+"})([\\s|-])","g");return str.toString().replace(re,"$1$2\n").replace(" \n","\n")};var measureTextMultiple=function(t,f){var l=t.split(/\n/);var m=0;ctx.font=f;for(var i=0;i<l.length;i++){m=Math.max(m,ctx.measureText(l[i]).width)}return m};var getMembrane=function(node){var getNode=function(){return{shape:"rectangle",color:"rgba(255,255,255,0)",outline:"rgba(0,0,0,0)",outlineWidth:0,hideLabel:true,immutable:true,eventless:true,type:node.type,zorder:node.zorder+1,width:32,height:32}};var getNodeTL=function(){var nd=getNode();nd.id=node.id+"-membraneTL";nd.pattern="membraneTL";nd.x=node.x-(node.width*0.5);nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeTR=function(){var nd=getNode();nd.id=node.id+"-membraneTR";nd.pattern="membraneTR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y-(node.height*0.5);nd.width=64;nd.height=64;return nd};var getNodeBL=function(){var nd=getNode();nd.id=node.id+"-membraneBL";nd.pattern="membraneBL";nd.x=node.x-(node.width*0.5);nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeBR=function(){var nd=getNode();nd.id=node.id+"-membraneBR";nd.pattern="membraneBR";nd.x=node.x+(node.width*0.5)-32;nd.y=node.y+(node.height*0.5)-32;nd.width=64;nd.height=64;return nd};var getNodeTop=function(s){var nd=getNode();nd.id=node.id+"-membraneT";nd.pattern="membraneTop";nd.x=node.x+(s==0?0:s==1?-16:s==2?16:0);nd.y=node.y-(node.height*0.5);nd.width=node.width-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeBottom=function(s){var nd=getNodeTop(s);nd.id=node.id+"-membraneB";nd.pattern="membraneBottom";nd.y=node.y+(node.height*0.5)-16;return nd};var getNodeRight=function(s){var nd=getNode();nd.id=node.id+"-membraneR";nd.pattern="membraneRight";nd.x=node.x+(node.width*0.5)-16;nd.y=node.y+(s==0?0:s==1?-16:s==2?16:0);nd.height=node.height-(s==0?0:s==1?32:s==2?32:64);return nd};var getNodeLeft=function(s){var nd=getNodeRight(s);nd.id=node.id+"-membraneL";nd.pattern="membraneLeft";nd.x=node.x-(node.width*0.5);return nd};switch(node.type){case 1:node.shape="rectangle";return[getNodeTop(0)];case 2:node.shape="rectangle";return[getNodeRight(0)];case 3:node.shape="roundrecttr";return[getNodeTop(1),getNodeRight(2),getNodeTR()];case 4:node.shape="rectangle";return[getNodeBottom(0)];case 5:node.shape="rectangle";return[getNodeTop(0),getNodeBottom(0)];case 6:node.shape="roundrectbr";return[getNodeBottom(1),getNodeRight(1),getNodeBR()];case 7:node.shape="roundrectr";return[getNodeTop(1),getNodeBottom(1),getNodeRight(3),getNodeBR(),getNodeTR()];case 8:node.shape="rectangle";return[getNodeLeft(0)];case 9:node.shape="roundrecttl";return[getNodeTop(2),getNodeLeft(2),getNodeTL()];case 10:node.shape="rectangle";return[getNodeRight(0),getNodeLeft(0)];case 11:node.shape="roundrectt";return[getNodeTop(3),getNodeRight(2),getNodeLeft(2),getNodeTR(),getNodeTL()];case 12:node.shape="roundrectbl";return[getNodeBottom(2),getNodeLeft(1),getNodeBL()];case 13:node.shape="roundrectl";return[getNodeTop(2),getNodeBottom(2),getNodeLeft(3),getNodeTL(),getNodeBL()];case 14:node.shape="roundrectb";return[getNodeBottom(3),getNodeRight(1),getNodeLeft(1),getNodeBR(),getNodeBL()];case 15:if(node.width<64||node.height<64){node.shape="rectangle";delete node.gradient;delete node.color1;delete node.color2;delete node.color3;return[getNodeTop(0)]}node.shape="roundrect2";return[getNodeTop(3),getNodeBottom(3),getNodeRight(3),getNodeLeft(3),getNodeTR(),getNodeTL(),getNodeBR(),getNodeBL()]}return[]};var getRadians=function(x0,y0,x1,y1){return(Math.atan2(y1-y0,x1-x0)+2*Math.PI)%(2*Math.PI)};var getCoordinateAtDistance=function(x0,y0,x1,y1,d){const dx=x1-x0;const dy=y1-y0;const distance=Math.hypot(dx,dy);if(distance===0){return[x0,y0]}const ratio=d/distance;const newX=x0+dx*ratio;const newY=y0+dy*ratio;return[newX,newY]};var getLengthToNodeBoundary=function(x0,y0,x1,y1,node){const dx=x1-x0;const dy=y1-y0;let intersectionX=x0;let intersectionY=y0;const nodeLeft=node.x-node.width/2;const nodeRight=node.x+node.width/2;const nodeTop=node.y-node.height/2;const nodeBottom=node.y+node.height/2;if(dx!==0){const leftIntersect=(nodeLeft-x0)/dx;const rightIntersect=(nodeRight-x0)/dx;if(dx>0){intersectionX=nodeLeft}else{intersectionX=nodeRight}if(leftIntersect>=0&&leftIntersect<=1){intersectionY=y0+leftIntersect*dy}else{if(rightIntersect>=0&&rightIntersect<=1){intersectionY=y0+rightIntersect*dy}}}if(dy!==0){const topIntersect=(nodeTop-y0)/dy;const bottomIntersect=(nodeBottom-y0)/dy;if(dy>0){intersectionY=nodeTop}else{intersectionY=nodeBottom}if(topIntersect>=0&&topIntersect<=1){intersectionX=x0+topIntersect*dx}else{if(bottomIntersect>=0&&bottomIntersect<=1){intersectionX=x0+bottomIntersect*dx}}}const distance=Math.sqrt(Math.pow(intersectionX-x0,2)+Math.pow(intersectionY-y0,2));return distance+2};var nodes=[];var edges=[];var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="map"){var seen={};var sord=[];var n=0;var ob=this.MR(pw,false,false,true);nodes.push({id:"__background__",type:"background",shape:"rectangle",color:"rgb(220,231,232)",outline:"rgb(29,154,195)",outlineWidth:3,width:Number(ob.width),height:Number(ob.height),x:Number(ob.width)*0.5,y:Number(ob.height)*0.5,hideLabel:true,immutable:true,eventless:true,zorder:1});sord.push(n++);for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"localizations":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="loc"){var js=this.MR(nd);var shp=loc.hasOwnProperty(js.id)?"image":js.id=="16"?"roundrect2":"roundrect";var node={id:"loc"+(j+1),shape:shp,hideLabel:true,immutable:true,eventless:true,x:Number(js.x)+(Number(js.width)*0.5),y:Number(js.y)+(Number(js.height)*0.5),width:Number(js.width),height:Number(js.height),type:Number(js.type),zorder:js.appearance&&js.appearance[0].zorder?Number(js.appearance[0].zorder.replace("Integer: ","")):2};if(shp!="image"){node.color="rgba(0,0,0,0)";node.outline=js.id=="16"?"rgba(0,0,0,0)":"rgb(83,158,188)";node.outlineWidth=js.id!="16"?3:0;if(js.id!="16"){node.width-=6;node.height-=6}}if(js.appearance&&js.appearance[0].rotateangle){node.rotate=Number(js.appearance&&js.appearance[0].rotateangle.split(": ")[1]);if(!node.rotate){delete node.rotate}else{node.widthTMP=node.width;node.width=node.height;node.height=node.widthTMP;delete node.widthTMP}}if(js.id=="16"){node.gradient="linear";node.color1="rgb(122,194,226)";node.color2="rgb(223,237,248)";node.color3="rgb(223,237,248)"}if(shp=="image"){if(js.id=="1287"){node.imagePath=js.type=="1"?CanvasXpress.images.mitochondria2:CanvasXpress.images.mitochondria}else{node.imagePath=CanvasXpress.images[loc[js.id]]}}for(var p in js){if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(": ");switch(vk[0]){case"String":node[a]=vk[1];break;case"Integer":case"Double":node[a]=Number(vk[1]);break;case"Boolean":node[a]=vk[1]=="true"?true:false;break}}}}nodes.push(node);sord.push(n++);if(Number(js.id)==16){var mem=getMembrane(node);if(mem.length){for(var k=0;k<mem.length;k++){nodes.push(mem[k]);sord.push(n++)}}}}}break;case"nodes":for(var j=0;j<el.childNodes.length;j++){var nd=el.childNodes[j];if(nd.nodeName&&nd.nodeName.toLowerCase()=="node"){var js=this.MR(nd);var node={};for(var p in js){if(p.toLowerCase()=="alt"){if(js[p][0].match(/\w/)){node.tooltip=js[p][0].replace(/\"/g,"'");node.tooltip=js[p][0].replace(/\[/g,"&#91");node.tooltip=js[p][0].replace(/\]/g,"&#93")}}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){vk=js[p][0][a].split(":");switch(vk[0]){case"String":node[a]=vk[1].replace(/\s/g,"");break;case"Integer":case"Double":node[a]=Number(vk[1].replace(/\s/g,""));break;case"Boolean":node[a]=vk[1].replace(/\s/g,"")=="true"?true:false;break;case"Rectangle":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"Color":node[a]=vk[1].replace(/\s/g,"").split(",").map(Number);node[a][3]=Math.round(node[a][3]/255*10)/10;node[a]="rgba("+node[a].join(",")+")";break;case"Font":node[a]=vk[1].replace(/\s/g,"").split(",");break}}}node[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}node.extId=js.id;node.id=js.nodeid.toString();node.x=Number(js.x)+(Number(js.width)*0.5);node.y=Number(js.y)+(Number(js.height)*0.5);node.width=Number(js.width);node.height=Number(js.height);if(node.iconarea){node.width=node.iconarea[2];node.height=node.iconarea[3];node.x=node.iconarea[0]+(node.width*0.5);node.y=node.iconarea[1]+(node.height*0.5);delete node.iconarea}if(js.icontype&&(js.type==0||js.type==16)){if(isNaN(js.icontype)){js.icontype=1000}if(Number(js.icontype)<10){js.icontype="0"+js.icontype}if(CanvasXpress.images.hasOwnProperty(js.icontype)){node.zoomX=50/node.width;node.zoomY=50/node.height;node.shape="image";node.imagePath=CanvasXpress.images[js.icontype];node.immutable=false}else{node.shape="roundrect";node.immutable=true}}else{if(js.icontype){switch(js.type){case"-10":node.width-=5;node.height-=5;node.x+=2.5;node.y+=2.5;node.shape=node.arcwidth>40?"roundrecto":"roundrect";break;case"21":case"61":case"63":case"91":case"-11":case"-12":node.width-=4;node.height-=4;node.x+=2;node.y+=2;node.shape="roundrect";break;default:break}node.immutable=true}else{node.shape="roundrect";node.immutable=true}}if(node.name==""){node.hideLabel=true}else{node.name=node.name.toString().replace(/\[/g,"&#91").replace(/\]/g,"&#93").replace(/\"/g,"&quot")}if(node.textarea){var lines=1;if(node.font){lines=Math.floor(node.textarea[3]/(Number(node.font[2])+(Number(node.font[2])>12?1:0)));node.labelSize=node.font[2]==14?1.1:1;if(node.font[0].match(/Bold Italic/i)){node.labelStyle="Bold Italic"}else{if(node.font[0].match(/Bold/i)){node.labelStyle="Bold"}else{if(node.font[0].match(/Italic/i)){node.labelStyle="Italic"}}}}if(lines>1&&!node.name.toString().match(/\n/)){var fnt=Math.floor(10*node.labelSize)+"px Arial";var tst=Math.floor(node.textarea[2]/5.5);var wrp=tst>0?wrapText(node.name.toString(),tst):node.name.toString();var lns=wrp.split(/\n/);var max=measureTextMultiple(wrp,fnt);if(lns.length>lines){while(lns.length>lines&&tst<node.name.toString().length){wrp=wrapText(node.name.toString(),tst++);lns=wrp.split(/\n/);max=measureTextMultiple(wrp,fnt)}}if(max>node.textarea[2]){wrp=wrp.replace("(","\n(");lns=wrp.split(/\n/);max=measureTextMultiple(wrp,fnt);while((max>node.textarea[2]||lns.length*fnt>node.textarea[3]||lns.length<lines)&&tst>3){wrp=wrapText(node.name,tst--);lns=wrp.split(/\n/);max=measureTextMultiple(wrp,fnt)}}node.name=wrp}else{if(lines==0){node.hideLabel=true}}node.labelX=node.textarea[0]+(node.textarea[2]*0.5);node.labelY=node.textarea[1]+(node.textarea[3]*0.5)}if(node.textalignment!=null){if(node.textalignment==0){node.labelAlign="left";node.labelX-=(node.textarea[2]*0.45)}else{if(node.textalignment==1){node.labelAlign="center"}else{if(node.textalignment==2){node.labelAlign="right";node.labelX+=(node.textarea[2]*0.45)}}}}delete node.textarea;if(node.fontcolor){node.labelColor=node.fontcolor;delete node.fontcolor}if(node.backgroundcolor){node.color=node.backgroundcolor;delete node.backgroundcolor}if(node.bordercolor){node.outline=node.bordercolor;delete node.bordercolor}if(node.rotateangle){node.rotate=node.shape=="image"?-node.rotateangle:270-node.rotateangle;if(node.shape!="image"){node.labelRotate=-node.rotateangle}delete node.rotateangle}if(node.borderwidth){node.outlineWidth=Number(node.borderwidth)-1;delete node.borderwidth}seen[node.id]=n;delete node.appearance;delete node.icontype;nodes.push(node);sord.push(n++);if(node.complex){nodes.push({id:node.id+"-complex",x:node.x,y:node.y,width:14,height:14,shape:"star",color:"rgb(255,255,255)",hideLabel:true,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-complex"]=n;sord.push(n++);delete node.complex}if(node.pathstart){var rot=0;var ptx=0;var pty=0;switch(node.sideofpathstarteditor){case 0:rot=90;pty=-(40+node.pathstartarrowmargin);break;case 1:rot=180;ptx=(40+node.pathstartarrowmargin);break;case 2:rot=270;pty=(40+node.pathstartarrowmargin);break;case 3:rot=0;ptx=-(40+node.pathstartarrowmargin);break}nodes.push({id:node.id+"-pathstart",x:node.x+ptx,y:node.y+pty,width:40,height:40,shape:"image",imagePath:CanvasXpress.images["99"],hideLabel:true,immutable:true,rotate:rot,zorder:node.zorder+1,parentNode:node.id});seen[node.id+"-pathstart"]=n;sord.push(n++);delete node.sideofpathstarteditor;delete node.pathstartarrowmargin;delete node.pathstart}if(node.organismspecificobject){nodes.push({id:node.id+"-organism",x:node.x,y:node.y,width:60,height:60,shape:"circle",color:"rgba(0,0,0,0.1)",outline:"rgb(255,255,0)",outlineWidth:3,hideLabel:true,zorder:node.zorder-1,parentNode:node.id});seen[node.id+"-organism"]=n;sord.push(n++);delete node.organismspecificobject}}}break;case"edges":for(var j=0;j<el.childNodes.length;j++){var ed=el.childNodes[j];if(ed.nodeName&&ed.nodeName.toLowerCase()=="edge"){var js=this.MR(ed);var edge={};for(var p in js){if(p.toLowerCase()=="alt"){continue}if(p.toLowerCase()=="appearance"){for(var a in js[p][0]){if(a=="linkhighlighting"){vk=js[p][0][a].split(":");if(vk[1]=="Color"&&vk[2]){vk[2]=vk[2].split(",");vk[2].pop();edge.highlight="rgb("+vk[2].join(",")+")"}}else{vk=js[p][0][a].split(": ");switch(vk[0]){case"String":edge[a]=vk[1];break;case"Integer":case"Double":edge[a]=Number(vk[1]);break;case"Boolean":edge[a]=vk[1]=="true"?true:false;break;case"Rectangle":edge[a]=vk[1].replace(/\s/g,"").split(",").map(Number);break;case"PointArray":var cp=[];vk[1]=vk[1].replace(/\s/g,"").split(";");for(var k=0;k<vk[1].length-1;k++){cp.push(vk[1][k].split(",").map(Number))}edge[a]=cp;break}}}}edge[p]=js[p]=="true"?true:js[p]=="false"?false:!isNaN(js[p])?Number(js[p]):js[p]}edge.id1=js.src;edge.id2=js.dst;if(edge.type){edge.EdgeType=edge.type;delete edge.type}if(edge.directed){edge.endArrow="arrow";delete edge.directed}edge.color="grey";edge.type=edge.enhances?"dashed":"solid";if(edge.visualization=="Round"){edge.type="quadratic";edge.angle=edge.angle}else{if(edge.visualization=="Bezier"){if(!edge.controlpoints){edge.type="solid";edge.linksourcepointindex=0;edge.linktargetpointindex=0}else{edge.type="bezier";edge.angle=edge.angle}}}if(edge.hasOwnProperty("effect")){if(edge.effect>=0){switch(edge.effect){case 0:edge.color="rgb(152,156,158)";break;case 1:edge.color="rgb(0,128,0)";break;case 2:edge.color="rgb(170,0,0)";break}}if(edge.mech!=null){var dec={};if(edge.showhexagon){var col=edge.hexagoncustomcolor||edge.color;var idx=edge.hexagonindex||0;var pos=edge.hexagoncoordinate||0.5;var cll=edge.effect==0?"black":"rgb(242,216,0)";var getDec=function(lbl){return{label:lbl,labelColor:cll,shape:"hexagon",color:col,index:idx,pos:pos}};switch(edge.mech){case -1:dec=getDec("");break;case 0:dec=getDec("?");break;case 2:dec=getDec("CM");break;case 3:dec=getDec("+P");break;case 4:dec=getDec("-P");break;case 5:dec=getDec("B");break;case 6:dec=getDec("Cn");break;case 7:dec=getDec("T");break;case 8:dec=getDec("C");break;case 9:dec=getDec("TR");break;case 10:dec=getDec("GR");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 11:dec=getDec("CR");break;case 12:dec=getDec("IE");break;case 14:dec=getDec("CS");dec.labelColor="white";dec.color="rgb(0,0,170)";break;case 15:dec=getDec("Z");break;case 16:dec=getDec("Tn");break;case 20:dec=getDec("cRT");break;case 21:dec=getDec("PE");break;case 22:dec=getDec("TE");break;case 24:dec=getDec("M");break;case 31:dec=getDec("SR");break;case 44:dec=getDec("RG");break;default:dec=getDec("");break}if(dec.label!=""){edge.decoration=[dec]}}delete edge.effect;delete edge.mech;delete edge.hexagonindex;delete edge.hexagoncoordinate;delete edge.showhexagon;delete edge.hexagoncustomcolor}}if(edge.broken){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"X",labelColor:"purple",fontSize:20,shape:"square",color:"rgba(0,0,0,0)",index:(edge.brokenindex||0),pos:(edge.brokencoordinate||0.5)});delete edge.broken;delete edge.brokenindex;delete edge.brokencoordinate}if(edge.weakens){if(!edge.decoration){edge.decoration=[]}edge.decoration.push({label:"-x-",labelColor:"purple",fontSize:12,shape:"square",color:"rgba(0,0,0,0)",index:(edge.weakensindex||0),pos:(edge.weakenscoordinate||0.5)});delete edge.weakens;delete edge.weakensindex;delete edge.weakenscoordinate}if(edge.disease){edge.color="purple";edge.thickness=2;delete edge.disease}if(edge.enhances){edge.color="purple";edge.thickness=2;delete edge.enhances}delete edge.appearance;delete edge.src;delete edge.dst;if(seen.hasOwnProperty(edge.id1)&&seen.hasOwnProperty(edge.id2)){var src=nodes[seen[edge.id1]];var dst=nodes[seen[edge.id2]];var sx=src.x;var sy=src.y;var sw=src.width*0.5;var sh=src.height*0.5;var ex=0;var ey=0;var dx=dst.x;var dy=dst.y;var dw=dst.width*0.5;var dh=dst.height*0.5;var ss,sd,sq,ds,dd,dq,xy,cx,cy,rd,frs,lst,n1;if(edge.visualization&&edge.visualization=="Right angle polyline"){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(edge.firstleg&&edge.firstleg=="Vertical"){frs=edge.controlpoints?edge.controlpoints[0][1]:false;sy=frs&&frs[1]>0?sy+sh:src.y>dst.y?sy-sh:frs&&frs<0?sy-sh:sy+sh;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{if(ss==1){sx=sx+sw}else{if(ss==3){sx=sx-sw}}}sq="tb"}else{frs=edge.controlpoints?edge.controlpoints[0][0]:false;sx=frs&&frs>0?sx+sw:src.x>dst.x?sx-sw:frs&&frs<0?sx-sw:sx+sw;if(ss==1||ss==3){sy=(sy-sh)+(src.height*sd)}else{if(ss==0){sy=sy-sh}else{if(ss==2){sy=sy+sh}}}sq="lr"}ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(!edge.controlpoints){if(edge.firstleg&&edge.firstleg=="Vertical"){dx=src.x>dst.x?dx+dw:dx-dw;if(ds==1||ds==3){dy=(dy-dh)+(dst.height*dd)}}else{dy=src.y>dst.y?dy+dh:dy-dh;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}}}else{dq=edge.controlpoints.length%2?sq:sq=="tb"?"lr":"tb";n1=edge.controlpoints.length-1;lst=edge.controlpoints[n1];if(edge.linktargetpointindex){if(ds==1||ds==3){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}dy=(dy-dh)+(dst.height*dd)}else{if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd);if(src.y+lst[1]>dst.y){dy+=dh}else{dy-=dh}}}}else{if(edge.controlpoints.length%2){if(sq==dq&&sq=="lr"){if(src.x+lst[0]>dst.x){dx+=dw}else{dx-=dw}}}else{dx=src.x+lst[0]>dst.x?dx+dw:dx-dw}if(edge.controlpoints.length%2){if(sq!=dq||sq!="lr"){dy=src.y+lst[1]>dst.y?dy+dh:dy-dh}}else{if(src.y+lst[1]>dst.y){dy=dy+dh}}}}if(edge.controlpoints){edge.elbows=[[sx,sy]];cx=sx;cy=sy;if(edge.firstleg&&edge.firstleg=="Vertical"){for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cx=sx+edge.controlpoints[k][0]}else{cy=sy+edge.controlpoints[k][1]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([dx,cy])}else{edge.elbows.push([cx,dy])}}else{for(var k=0;k<edge.controlpoints.length;k++){if(k%2){cy=sy+edge.controlpoints[k][1]}else{cx=sx+edge.controlpoints[k][0]}edge.elbows.push([cx,cy])}if(edge.controlpoints.length%2){edge.elbows.push([cx,dy])}else{edge.elbows.push([dx,cy])}}edge.elbows.push([dx,dy])}else{if(edge.firstleg&&edge.firstleg=="Vertical"){edge.elbows=[[sx,sy],[sx,dy],[dx,dy]]}else{edge.elbows=[[sx,sy],[dx,sy],[dx,dy]]}}}else{if(edge.controlpoints&&edge.linksourcepointindex!=null&&edge.linktargetpointindex!=null&&edge.id1!=edge.id2){if(edge.linksourcepointindex||edge.controlpoints){frs=edge.controlpoints?edge.controlpoints[0]:[0,0];if(edge.linksourcepointindex==0){ds=getLengthToNodeBoundary(sx,sy,sx+frs[0],sy+frs[1],src);xy=getCoordinateAtDistance(sx,sy,sx+frs[0],sy+frs[1],ds);rd=getRadians(sx,sy,sx+frs[0],sy+frs[1]);sx=xy[0];sy=xy[1];ex=(-ds*-Math.cos(rd));ey=ds*Math.sin(rd)}else{ss=Math.floor((edge.linksourcepointindex-1)/src.linkpointcount);sd=(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1);switch(ss){case 0:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy-sh;break;case 1:ex=0;ey=(src.height*sd);sx=sx+sw;sy=ey+sy-sh;break;case 2:ex=(src.width*sd);ey=0;sx=ex+sx-sw;sy=sy+sh;break;case 3:ex=0;ey=(src.height*sd);sx=sx-sw;sy=ey+sy-sh;break}}}if(edge.linktargetpointindex||edge.controlpoints){lst=edge.controlpoints?this.c9(this.uY(edge.controlpoints[edge.controlpoints.length-1])):[0,0];if(edge.linktargetpointindex==0){if(edge.controlpoints){lst[0]=dx-(sx+lst[0]);lst[1]=dy-(sy+lst[1])}ds=getLengthToNodeBoundary(dx,dy,dx+lst[0],dy+lst[1],dst);xy=getCoordinateAtDistance(dx,dy,dx+lst[0],dy+lst[1],-ds);rd=getRadians(dx,dy,dx+lst[0],dy+lst[1]);dx=xy[0];dy=xy[1]}else{ds=Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount);dd=(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1);switch(ds){case 0:dx=(dst.width*dd)+dx-dw;dy=dy-dh;break;case 1:dx=dx+dw;dy=(dst.height*dd)+dy-dh;break;case 2:dx=(dst.width*dd)+dx-dw;dy=dy+dh;break;case 3:dx=dx-dw;dy=(dst.height*dd)+dy-dh;break}}}edge.elbows=[];for(var k=0;k<edge.controlpoints.length;k++){edge.elbows.push([sx+edge.controlpoints[k][0]+5,sy+edge.controlpoints[k][1]])}edge.elbows.unshift([sx,sy]);edge.elbows.push([dx,dy])}else{if(edge.id1==edge.id2){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;if(ss==ds){edge.self={dir:edge.angle>0,pos:(ss==0?"top":ss==1?"right":ss=2?"bottom":"left"),size:20,end:"arrow"}}else{if(ss>ds||(ss==0&&ds==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topLeft":ss=1?"topRight":ss==2?"bottomRight":"bottomLeft"),size:20,end:"arrow"}}else{if(ds>ss||(ds==0&&ss==3)){edge.self={dir:edge.angle>0,pos:(ss==0?"topRight":ss==1?"bottomRight":ss==2?"bottomLeft":"topLeft"),size:20,end:"arrow"}}}}}else{if(edge.linksourcepointindex){ss=edge.linksourcepointindex?Math.floor((edge.linksourcepointindex-1)/src.linkpointcount):-1;sd=edge.linksourcepointindex?(edge.linksourcepointindex-(src.linkpointcount*ss))/(src.linkpointcount+1):0;if(ss==0||ss==2){sx=(sx-sw)+(src.width*sd)}else{sy=(sy-sh)+(src.height*sd)}}if(edge.linktargetpointindex){ds=edge.linktargetpointindex?Math.floor((edge.linktargetpointindex-1)/dst.linkpointcount):-1;dd=edge.linktargetpointindex?(edge.linktargetpointindex-(dst.linkpointcount*ds))/(dst.linkpointcount+1):0;if(ds==0||ds==2){dx=(dx-dw)+(dst.width*dd)}else{dy=(dy-dh)+(dst.height*dd)}}if(edge.linksourcepointindex||edge.linktargetpointindex){if(edge.linksourcepointindex){switch(ss){case 0:sy-=sh;break;case 1:sx+=sw;break;case 2:sy+=sh;break;case 3:sx-=sw;break}if(!edge.linktargetpointindex){ds=getLengthToNodeBoundary(dx,dy,sx,sy,dst);xy=getCoordinateAtDistance(dx,dy,sx,sy,ds);dx=xy[0];dy=xy[1]}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}}}else{switch(ds){case 0:dy-=dh;break;case 1:dx+=dw;break;case 2:dy+=dh;break;case 3:dx-=dw;break}ds=getLengthToNodeBoundary(sx,sy,dx,dy,src);xy=getCoordinateAtDistance(sx,sy,dx,dy,ds);sx=xy[0];sy=xy[1]}edge.elbows=[[sx,sy],[dx,dy]]}}}}delete edge.linksourcepointindex;delete edge.linktargetpointindex;delete edge.controlpoints;delete edge.visualization;delete edge.firstleg;edges.push(edge)}}}break}}}sord.sort(function(a,b){if(nodes[a].zorder-nodes[b].zorder==0){return a-b}else{return nodes[a].zorder-nodes[b].zorder}});var tmp=[];for(var i=0;i<sord.length;i++){tmp.push(nodes[sord[i]])}nodes=tmp}else{alert("Ooops! Not a Metabase xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Metabase"},renderTo:target,events:events,afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}return data};this.ba=function(xml,target,config,events){var sp={ELLIPSE:"oval",arc:"circle",bitmap:"circle",line:"minus",text:"circle",ver_ellipsis:"oval",hor_ellipsis:"oval"};var nodes=[];var edges=[];var title="";var pw=xml.childNodes[0];if(pw.tagName.toLowerCase()=="graph"){for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();var js=this.MR(el);switch(nn){case"node":if(js.graphics&&js.id){var gr=js.graphics[0];var node={id:js.id,x:Number(gr.x),y:Number(gr.y),z:Number(gr.z),width:Number(gr.w),height:Number(gr.h),shape:(sp[gr.type]||gr.type),color:gr.fill,outline:gr.outline,outlineWidth:Number(gr.width)};if(js.label){node.name=js.label}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/NODE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.name=="COMMON"&&at.value){node.label=at.value}else{if(at.value){node[at.name]=at.value}}break;case"Double":case"Integer":if(at.value!=null){node[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){node[at.name]=at.value==0?false:true}break}}}}nodes.push(node)}break;case"edge":if(js.source&&js.target){var edge={id1:js.source,id2:js.target};if(js.id){edge.intId=js.id}if(js.label){edge.label=js.label}if(js.directed){edge.directed=js.directed}if(js.graphics){edge.color=js.graphics[0].fill;edge.width=js.graphics[0].width}if(js.att){for(var j=0;j<js.att.length;j++){var at=js.att[j];if(at.name&&!at.name.match(/EDGE_/)&&at.name!="selected"&&at.name!="isInPath"){switch(at.type){case"String":if(at.value){edge[at.name]=at.value}break;case"Double":case"Integer":if(at.value!=null){edge[at.name]=Number(at.value)}break;case"Boolean":if(at.value!=null){edge[at.name]=at.value==0?false:true}break}}}}edges.push(edge)}break;case"att":if(js.name&&js.value&&js.name=="Dataset Name"){title=js.value}break}}}}else{alert("Ooops! Not a cytoscape xgmml file!")}var res="Number of Nodes: "+nodes.length+"\nNumber of Edges: "+edges.length+"\n";res=res.replace(/\n/g,"<br>");var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:true,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,moveParentsWithChildren:true,ignoreEventlessOrder:true,networkVendor:"Cytoscape"},renderTo:target,events:events,afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}return data};this.Tw=function(xml,target,config,events){var pw=xml.childNodes[0];var nodes={};var edges=[];var state={};var groups={};var anchors={};var order={};var cntp=1;var cntn=0;var sord=[];var groupRef={};var groupGref={};var groupId={};var wrn="\nWarnings:\n";var htt=false;var title,subtitle;var arrowTypes={Line:false,Arrow:"arrow",TBar:"square","mim-necessary-stimulation":false,"mim-binding":false,"mim-conversion":"arrow","mim-stimulation":"arrow","mim-catalysis":"round","mim-modification":false,"mim-inhibition":"square","mim-covalent-bond":false,"mim-transcription-translation":false};var createNodeFromGroup=function(grp,id){var mnx=Number.MAX_VALUE;var mny=Number.MAX_VALUE;var mxx=-Number.MAX_VALUE;var mxy=-Number.MAX_VALUE;var ids=[];var ord=[];var shw=false;for(var i=0;i<grp.length;i++){mnx=Math.min(mnx,grp[i][1]-(grp[i][3]/2));mny=Math.min(mny,grp[i][2]-(grp[i][4]/2));mxx=Math.max(mxx,grp[i][1]+(grp[i][3]/2));mxy=Math.max(mxy,grp[i][2]+(grp[i][4]/2));ids.push(grp[i][0]);nodes[grp[i][0]].parentNode=id;ord.push(nodes[grp[i][0]].zorder);if(nodes[grp[i][0]].nodeName!="label"){shw=true}ord.sort(function(a,b){return a-b})}var w=mxx-mnx;var h=mxy-mny;var ob={id:id,x:(mnx+mxx)/2,y:(mny+mxy)/2,width:w+(grp.length>1&&w>10?5:0),height:h+(grp.length>1&&h>10?5:0),group:ids,hideLabel:true,hideTooltip:htt,type:"Group",color:(shw?"rgba(245,245,245,0.5)":"rgba(0,0,0,0)"),outline:(shw?"rgb(0,0,0)":"rgba(0,0,0,0)"),shape:"rectangle",zorder:ord[0]};order[id]=cntn--;nodes[id]=ob;sord.push(id)};var createNodeFromPoint=function(p,id){var ob={id:id,x:Math.round(p.x*10)/10,y:Math.round(p.y*10)/10,width:p.width?Math.round(p.width):1,height:p.height?Math.round(p.height):1,hideLabel:p.show?false:true,hideTooltip:!htt?false:p.show?false:true,eventless:p.show?false:true,type:p.type||"Anchor",color:p.color||"rgba(0,0,0,0)",outline:p.outline||"rgba(0,0,0,0)",shape:p.shape||"circle",label:p.label||"",zorder:p.zorder||0};order[id]=cntp++;nodes[id]=ob;sord.push(id)};var getDirection=function(s){switch(s){case"r":case"l":return"rl";case"b":case"t":case"c":return"tb"}};var getSide=function(p){if(parseInt(p.relx)==1){return"r"}else{if(parseInt(p.relx)==-1){return"l"}else{if(parseInt(p.rely)==1){return"b"}else{if(parseInt(p.rely)==-1){return"t"}else{if(Math.abs(p.relx)>Math.abs(p.rely)){if(parseFloat(p.relx)>0){return"r"}else{return"l"}}else{if(parseFloat(p.rely)>0){return"b"}else{if(parseFloat(p.rely)<0){return"t"}else{return"c"}}}}}}}};var getNumberOfLines=function(s,t){var findExtra=function(sd,p1,p2){switch(sd){case"r":if(parseFloat(p1.x)>=parseFloat(p2.x)){return 2}break;case"l":if(parseFloat(p1.x)<=parseFloat(p2.x)){return 2}break;case"t":case"c":if(parseFloat(p1.y)<=parseFloat(p2.y)){return 2}break;case"b":if(parseFloat(p1.y)>=parseFloat(p2.y)){return 2}break}return 0};var ss=getSide(s);var ts=getSide(t);var ls=2;if(getDirection(ss)==getDirection(ts)){ls++}if(ss!=ts){ls+=findExtra(ss,s,t);ls+=findExtra(ts,t,s)}return ls};var getPoint=function(s,a,f){if(f){switch(s){case"r":return[a[0]+20,a[1]];case"l":return[a[0]-20,a[1]];case"t":case"c":return[a[0],a[1]-20];case"b":return[a[0],a[1]+20]}}else{switch(s){case"r":case"l":return[a[0][0],a[1][1]];case"t":case"b":case"c":return[a[1][0],a[0][1]]}}};var getCoords=function(d,a){var r=[a[0]];var l=a[0];for(var i=1;i<a.length;i++){var c=a[i];switch(d){case"rl":r.push([c[0],l[1]]);break;case"tb":r.push([l[0],c[1]]);break}l=r[i];d=d=="rl"?"tb":"rl"}r.push(a[a.length-1]);return r};var to2DArray=function(edg){var ps=edg.point;var a=[];for(var i=0;i<ps.length;i++){a.push([Math.round(ps[i].x*10)/10,Math.round(ps[i].y*10)/10])}return a};var getElbowPoints=function(edg){var ps=edg.point;var n1=ps.length-1;var ls=getNumberOfLines(ps[0],ps[n1]);var s=getSide(ps[0]);var t=getSide(ps[n1]);var d=getDirection(s);var a=to2DArray(edg);if(ls==ps.length){a=getCoords(d,a)}else{if(ps.length==2){a.splice(1,0,getPoint(s,a[0],true));if(ls>3){if(ls>3){a.splice(2,0,getPoint(t,a[2],true))}if(ls>4){if(ls>4){a.splice(3,0,[(a[1][0]+a[2][0])/2,(a[1][1]+a[2][1])/2])}if(ls>5){a=to2DArray(edg);a=getCoords(d,a)}}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}else{if((a[0][0]==a[1][0]&&a[1][0]==a[2][0])||(a[0][1]==a[1][1]&&a[1][1]==a[2][1])){a.splice(1,1)}else{a.splice(2,0,getPoint(s,[a[1],a[2]]))}}}else{if(ps.length>ls){a=getCoords(d,a)}else{for(var i=0;i<n1;i++){var j=i*2;if(d=="tb"){d="rl";a.splice(j+1,0,[a[j][0],a[j+1][1]])}else{d="tb";a.splice(j+1,0,[a[j+1][0],a[j][1]])}}}}}var b=[[a[0][0],a[0][1]]];for(var i=1;i<a.length;i++){if(a[i][0]==a[i-1][0]&&a[i][1]==a[i-1][1]){continue}b.push([a[i][0],a[i][1]])}return b};var getBezierPoints=function(edg,sn,tn){var ps=edg.point;var n1=ps.length-1;var s=getSide(ps[0]);var t=getSide(ps[n1]);var ds=getDirection(s);var dt=getDirection(t);var ar=to2DArray(edg);var segs=[];var p0,p1,mx,my;if(n1==1){p0=ar[0];p1=ar[1];if(sn&&tn){if(ds==dt){mx=(p0[0]+p1[0])/2;my=(p0[1]+p1[1])/2;if(ds=="tb"){if(t=="t"){if(my>tn.y-tn.height){my-=tn.height}}else{if(t=="b"){if(my<tn.y+tn.height){my+=tn.height}}}segs.push([p0[0],p0[1],p0[0],my,mx,my]);segs.push([mx,my,p1[0],my,p1[0],p1[1]])}else{if(t=="l"){if(mx>tn.x-tn.width){mx-=tn.width*0.5}}else{if(t=="r"){if(mx<tn.x+tn.width){mx+=tn.width*0.5}}}segs.push([p0[0],p0[1],mx,p0[1],mx,my]);segs.push([mx,my,mx,p1[1],p1[0],p1[1]])}}else{if(s=="t"||s=="b"){mx=t=="l"?-tn.width*0.5:t=="r"?tn.width*0.5:-tn.width*0.5;my=(p1[1]-p0[1])/3;if((t=="l"&&p0[0]>tn.x-tn.width)||(t=="r"&&p0[0]<tn.x+tn.width)){segs.push([p0[0],p0[1],p0[0],p0[1]+my,p1[0],p0[1]+my]);segs.push([p1[0],p0[1]+my,p1[0]+mx,p0[1]+my,p1[0]+mx,p0[1]+my+my]);segs.push([p1[0]+mx,p0[1]+my+my,p1[0]+mx,p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}else{mx=(p1[0]-p0[0])/3;my=t=="t"?-tn.height:t=="b"?tn.height:-tn.height;if((t=="t"&&p0[1]>tn.y-tn.height)||(t=="b"&&p0[1]<tn.y+tn.height)){segs.push([p0[0],p0[1],p0[0]+mx,p0[1],p0[0]+mx,p1[1]]);segs.push([p0[0]+mx,p1[1],p0[0]+mx,p1[1]+my,p0[0]+mx+mx,p1[1]+my]);segs.push([p0[0]+mx+mx,p1[1]+my,p1[0],p1[1]+my,p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}}}}else{p0=ar[0];if(s=="t"||s=="b"){for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}}else{for(var i=1;i<n1;i++){p1=ar[i];if(i%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}p0=p1}p1=ar[n1];if(n1%2){segs.push([p0[0],p0[1],p1[0],p0[1],p1[0],p1[1]])}else{segs.push([p0[0],p0[1],p0[0],p1[1],p1[0],p1[1]])}}}return segs};var getStatePosition=function(n,s){var x=parseFloat(s.relx);var y=parseFloat(s.rely);var w=n.width/2;var h=n.height/2;return[n.x+(x*w),n.y+(y*h)]};var XMLToJSON=function(xml,json,p,parent){var j={};var prefix=new RegExp(/(?!xmlns)^.*:/);var trim=new RegExp(/^\s+|\s+$/g);if(!json){json={}}if(p&&(p=="point"||p=="anchor")&&!json[p]){json[p]=[]}if(xml.attributes&&xml.attributes.length>0){for(var i=0;i<xml.attributes.length;i++){var a=xml.attributes.item(i);var n=a.name.replace(prefix,"").replace(/\[/g,"&#91").replace(/\]/g,"&#93").toLowerCase();if(p&&(p=="point"||p=="anchor")){j[n]=a.value.replace(trim,"")}else{json[n]=a.value.replace(trim,"")}}if(p&&(p=="point"||p=="anchor")){json[p].push(j)}}if(xml.hasChildNodes()&&!parent){for(var i=0;i<xml.childNodes.length;i++){var n=xml.childNodes.item(i);var p;if(n.nodeType==4){}else{if(n.nodeType==3){}else{if(n.nodeType==1){p=n.nodeName.replace(prefix,"").toLowerCase();XMLToJSON(n,json,p)}}}}}return json};var isValidShape=function(s){var shapes=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];shapes=shapes.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);shapes=shapes.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);shapes=shapes.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var i=0;i<shapes.length;i++){if(shapes[i]==s){return true}}return false};var hexToRgb=function(h){var hexToR=function(){return parseInt(h.substring(0,2),16)};var hexToG=function(){return parseInt(h.substring(2,4),16)};var hexToB=function(){return parseInt(h.substring(4,6),16)};h=h.charAt(0)=="#"?h.substring(1,7):h;return"rgb("+hexToR()+","+hexToG()+","+hexToB()+")"};var validateColor=function(c){c=c.toString();c=c.replace(/\s/g,"");var rgb=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(c);var rgba=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(c);var hex=(/^#?([0-9abcdef]{6})/i).exec(c);var hex2=(/^([0-9abcdef]{6})/i).exec(c);if(CanvasXpress.colorNames.hasOwnProperty(c)){c=hexToRgb(CanvasXpress.colorNames[c])}else{if(rgb!=null){c=rgb[0]}else{if(rgba!=null){c=rgba[0]}else{if(hex!=null){c=hexToRgb(hex[0])}else{if(hex2!=null){c=hexToRgb("#"+hex2[0])}else{c=false}}}}}return c};if(pw.tagName.toLowerCase()=="pathway"){var ob=XMLToJSON(pw,false,false,true);title=ob.name;subtitle=ob.organism;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"comment":break;case"graphics":break;case"state":var ob=XMLToJSON(el);ob.nodeName=nn;state[ob.graphid]=ob;break;case"datanode":case"label":case"shape":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.centerx){ob.x=Math.round(ob.centerx*10)/10;delete (ob.centerx)}if(ob.centery){ob.y=Math.round(ob.centery*10)/10;delete (ob.centery)}if(ob.width){ob.width=parseInt(ob.width)}if(ob.height){ob.height=parseInt(ob.height)}if(ob.textlabel){ob.label=ob.textlabel;delete (ob.textlabel)}if(ob.database&&ob.id){ob.database+=" : "+ob.id}if(ob.graphid){ob.id=ob.graphid}if(ob.fontsize){ob.labelSize=parseInt(ob.fontsize)}if(ob.rotation){ob.rotate=(parseFloat(ob.rotation)*180/Math.PI)+180}if(ob.shapetype){if(ob.shapetype=="RoundedRectangle"){ob.shapetype=ob.value&&ob.value=="Double"?"roundrectd":"roundrect"}if(ob.shapetype=="Arc"){ob.shapetype="arc3"}if(ob.shapetype=="Mitochondria"){ob.shapetype="image";ob.imagePath="https://www.canvasxpress.org/assets/images/mit.png"}if(isValidShape(ob.shapetype.toLowerCase())){ob.shape=ob.shapetype.toLowerCase()}else{if(ob.shapetype=="None"){ob.shape="rectangle"}else{wrn+=ob.id+" has an unkown shape: "+ob.shapetype+"\n";ob.shape=ob.shapetype}}if(ob.shape=="oval"&&ob.value&&ob.value=="Double"){ob.shape="ovald"}delete (ob.shapetype)}if(!ob.shape){ob.shape="rectangle"}if(nn=="shape"){ob.labelColor=ob.color?validateColor(ob.color):"rgb(0,0,0)"}else{if(ob.color){ob.labelColor=validateColor(ob.color)}else{ob.labelColor="rgb(0,0,0)"}}if(ob.fillcolor){ob.color=validateColor(ob.fillcolor);delete (ob.fillcolor)}else{ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(0,0,0)"){ob.color="rgba(0,0,0,0)"}if(ob.color=="rgb(255,255,255)"){ob.color="rgba(255,255,255,0)"}if(nn=="label"){if(!ob.label||ob.label==""){ob.hideLabel=true;ob.hideTooltip=htt;ob.eventless=true}ob.outline="rgba(0,0,0,0)";ob.color="rgba(0,0,0,0)"}else{ob.outline=validateColor(ob.labelColor)}if(nn=="shape"&&(!ob.label||ob.label=="")){ob.hideLabel=true;ob.hideTooltip=htt;ob.outline=validateColor(ob.labelColor)}if(ob.groupref){if(!groupRef.hasOwnProperty(ob.groupref)){groupRef[ob.groupref]=[]}groupRef[ob.groupref].push([ob.id,ob.x,ob.y,ob.width,ob.height]);ob.parentNode=ob.groupref}order[ob.id]=cntp++;nodes[ob.id]=ob;sord.push(ob.id);break;case"interaction":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.anchor){for(var j=0;j<ob.anchor.length;j++){anchors[ob.anchor[j].graphid]=true}delete (ob.anchor)}var n1=ob.point.length-1;if(ob.point[0].graphref&&ob.point[n1].graphref){ob.id1=ob.point[0].graphref;ob.id2=ob.point[n1].graphref}var type="solid";if(ob.linestyle&&ob.linestyle=="Broken"){type="dashed"}if(ob.connectortype&&ob.connectortype=="Curved"){type+="Bezier"}ob.type=type;if(ob.point[0].arrowhead){if(arrowTypes[ob.point[0].arrowhead]){ob.startArrow=arrowTypes[ob.point[0].arrowhead]}}if(ob.point[n1].arrowhead){if(arrowTypes[ob.point[n1].arrowhead]){ob.endArrow=arrowTypes[ob.point[n1].arrowhead]}}if(ob.linethickness){ob.thickness=parseInt(ob.linethickness*10)/10;delete (ob.linethickness)}if(ob.point[0].relx&&ob.point[0].rely){ob.startX=parseFloat(ob.point[0].relx);ob.startY=parseFloat(ob.point[0].rely)}if(ob.point[n1].relx&&ob.point[n1].rely){ob.endX=parseFloat(ob.point[n1].relx);ob.endY=parseFloat(ob.point[n1].rely)}delete (ob.id);edges.push(ob);break;case"group":var ob=XMLToJSON(el);ob.nodeName=nn;if(ob.groupref&&ob.groupid){if(!groups.hasOwnProperty(ob.groupref)){groups[ob.groupref]=[]}groups[ob.groupref].push(ob.groupid);groupGref[ob.graphid]=ob.groupref}else{groupId[ob.graphid]=ob.groupid}break;case"infobox":break;case"legend":break;case"biopax":break}}}}else{alert("Ooops! Not a gpml file!")}for(var s in state){var g=state[s].graphref;if(nodes[g]){var c=getStatePosition(nodes[g],state[s]);var p={id:g,x:c[0],y:c[1],width:state[s].width,height:state[s].height,label:state[s].textlabel==""?" ":state[s].textlabel,type:"State",color:state[s].textlabel==""?"rgb(255,255,255)":state[s].fillcolor,outline:"rgb(0,0,0)",shape:"oval",show:true};createNodeFromPoint(p,s)}}for(var g in groupRef){createNodeFromGroup(groupRef[g],g)}for(var g in groups){if(groupRef.hasOwnProperty(g)){for(var i=0;i<groups[g].length;i++){var ob=nodes[groups[g][i]];groupRef[g].push([ob.id,ob.x,ob.y,ob.width,ob.height])}createNodeFromGroup(groupRef[g],g)}}var edgs=[];var fail=[];for(var i=0;i<edges.length;i++){var ob=edges[i];var n1=ob.point.length-1;if(!ob.point[0].graphref&&!ob.point[n1].graphref){ob.exact=true}for(var j=0;j<ob.point.length;j++){var pt=ob.point[j];if(pt.graphref){if(!nodes.hasOwnProperty(pt.graphref)){if(j==0){if(groupId[pt.graphref]){ob.id1=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactStart=anchors[pt.graphref]?true:false;ob.id1=pt.graphref}}else{if(j==ob.point.length-1){if(groupId[pt.graphref]){ob.id2=groupId[pt.graphref]}else{createNodeFromPoint(pt,pt.graphref);ob.hideTooltip=htt;ob.exactEnd=anchors[pt.graphref]?true:false;ob.id2=pt.graphref}}}}}else{if(j==0||j==ob.point.length-1){var id=j==0?ob.graphid+".1":ob.graphid+".2";var ni=j==0?ob.point.length-1:0;createNodeFromPoint(pt,id);if(j==0){ob.id1=id;ob.exactStart=true}else{ob.id2=id;ob.exactEnd=true}ob.hideTooltip=htt;if(ob.point[ni].graphref){if(!nodes.hasOwnProperty(ob.point[ni].graphref)&&groupId[ob.point[ni].graphref]){if(j==0){ob.id2=groupId[ob.point[ni].graphref]}else{ob.id1=groupId[ob.point[ni].graphref]}}else{if(j==0){ob.id2=ob.point[ni].graphref}else{ob.id1=ob.point[ni].graphref}}}}}}if(ob.connectortype){if(ob.connectortype=="Elbow"){ob.elbows=getElbowPoints(ob)}else{if(ob.connectortype=="Curved"){ob.elbows=getBezierPoints(ob,nodes[ob.id1],nodes[ob.id2])}else{if(ob.connectortype=="Segmented"){ob.elbows=to2DArray(ob)}}}}if(nodes[ob.id1]&&nodes[ob.id2]){edgs.push(ob)}else{fail.push(ob)}}sord.sort(function(a,b){if(nodes[a].zorder&&nodes[b].zorder){if(parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)==0){return order[a]-order[b]}else{return parseInt(nodes[a].zorder)-parseInt(nodes[b].zorder)}}else{return order[a]-order[b]}});var nods=[];for(var i=0;i<sord.length;i++){nods.push(nodes[sord[i]])}var res="Number of Nodes: "+nods.length+"\n";res+="Number of Edges: "+edgs.length+"\n";if(fail.length>0){res+="Number of Failed Edges: "+fail.length+"\n";for(var i=0;i<fail.length;i++){res+="\t"+(i+1)+". "+fail[i].graphid+"\n"}}if(wrn!="\nWarnings:\n"){res+=wrn}res=res.replace(/\n/g,"<br>");var data={data:{nodes:nods,edges:edgs},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:false,preScaleNetwork:false,title:title,networkVendor:"Wikipathways"},renderTo:target,events:events,afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}return data};this.yc=function(xml,target,config,events,callback){var pw=xml.childNodes[2]||xml.childNodes[1];var nodes=[];var edges=[];var title,image,link,width,height;var addAnchors=function(){nodes.push({id:"__zero__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:0,y:0,hideLabel:true},{id:"__max__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:width,y:height,hideLabel:true})};var getAngle=function(x0,y0,x1,y1){var a=(Math.atan2(y1-y0,x1-x0)*180/Math.PI)%360;var min=0;while(a<min){a+=360}while(a>=(min+360)){a-=360}return a};var mean=function(arr){var mean=0;var n=0;for(var i=0;i<arr.length;i++){if(!isNaN(arr[i])){mean+=Number(arr[i]);n++}}if(n>0){mean/=n}return mean};if(pw.tagName.toLowerCase()=="pathway"){var ob=this.MR(pw,false,false,true);title=ob.title;image=ob.image;link=ob.link;var img=new Image();img.onload=function(){width=this.width;height=this.height;var res="Number of Nodes: "+nodes.length+"\n";res+="Number of Edges: "+edges.length+"\n";addAnchors();var data={data:{nodes:nodes,edges:edges},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,networkFreeze:false,showNodeNameThreshold:20000,preScaleNetwork:false,title:title,backgroundType:"image",backgroundImage:image,networkVendor:"Kegg"},renderTo:target,events:events,afterRender:[["flashInfoSpan",[100,100,res,5000]],["appendNetworkDataFromURL",[]]]};if(config){for(var p in config){data.config[p]=config[p]}}return callback(data)};if((CanvasXpress.system.isR&&!CanvasXpress.system.isInIframe)||!CanvasXpress.system.isR){img.crossOrigin="anonymous"}img.src=ob.image;for(var i=0;i<pw.childNodes.length;i++){var el=pw.childNodes[i];if(el.nodeName){var nn=el.nodeName.toLowerCase();switch(nn){case"entry":var ob=this.MR(el);if(ob.graphics[0].type=="roundrectangle"){ob.graphics[0].type="roundrect";ob.graphics[0].fgcolor="rgba(0,0,0,0)"}if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type!="line"){var ext=ob.type=="group"?5:0;var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:ob.graphics[0].type,color:"rgba(0,0,0,0)",outline:ob.graphics[0].fgcolor||"rgb(0,0,0)",width:parseInt(ob.graphics[0].width)+ext,height:parseInt(ob.graphics[0].height)+ext,x:parseInt(ob.graphics[0].x),y:parseInt(ob.graphics[0].y),hideLabel:true,fixed:true};if(ob.type=="group"){nodes.unshift(node)}else{nodes.push(node)}}else{if(ob.graphics&&ob.graphics.length==1&&ob.graphics[0].type=="line"){var coords=ob.graphics[0].coords.split(",");if(coords.length==4){var x=[];var y=[];var w,h,r;while(coords.length>1){x.push(parseInt(coords.shift()));y.push(parseInt(coords.shift()))}var mx=parseInt(mean(x));var my=parseInt(mean(y));if(x[0]==x[1]){mx+=1;w=2;h=y[1]-y[0];r=0}else{if(y[0]==y[1]){my+=1;w=x[1]-x[0];h=2;r=0}else{h=Math.sqrt(Math.pow(x[1]-x[0],2)+Math.pow(y[1]-0[0],2));w=2;r=getAngle(x[0],y[0],x[1],y[1])}}var node={id:ob.id,type:ob.type,link:ob.link,name:ob.graphics[0].name,shape:"rect",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",x:mx,y:my,width:w,height:h,rotate:r,hideLabel:true,fixed:true};nodes.push(node)}}}break;case"relation":case"reaction":var ob=this.MR(el);ob.id1=this.c9(this.uY(ob.entry1));ob.id2=this.c9(this.uY(ob.entry2));delete (ob.entry1);delete (ob.entry2);ob.color="rgba(0,0,0,0)";edges.push(ob);break}}}}else{alert("Ooops! Not a kgml file!")}};this.b8=function(table,config){var ar=[];for(var i=0;i<table.rows.length;i++){var ln=[];for(var j=0;j<table.rows.item(i).cells.length;j++){ln.push(table.rows.item(i).cells.item(j).innerHTML)}ar.push(ln)}var cx=this.wD(ar,config);CanvasXpress.transferDatasetAttributes(table,cx.config,true);return cx};this.hE=function(str){var pattern=new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");var pattern2=new RegExp("^(\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");return pattern.test(str)||pattern2.test(str)}};CanvasXpress.loadFonts=function(d,c){if(d&&d.length&&c){var b=false;for(var a=0;a<d.length;a++){if(!CanvasXpress.fonts.hasOwnProperty(d[a])){b=true;break}}WebFontConfig={google:{families:d},timeout:2000};if(c){WebFontConfig.active=c}(function(h){if(window.navigator.onLine&&b){var e=h.createElement("script");var g=h.scripts[0];e.src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js";e.async=true;g.parentNode.insertBefore(e,g);for(var f=0;f<d.length;f++){CanvasXpress.fonts[d[f]]=true}}else{c()}})(document)}};CanvasXpress.loadFontsExternal=function(c,b){if(c&&c.length&&b){var a=false;if(!CanvasXpress.fonts.hasOwnProperty(c[0].name)){a=true}(function(f){if(window.navigator.onLine&&a){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){var d=new FontFace(c[0].name,e.response);document.fonts.add(d);CanvasXpress.fonts[c[0].name]=true;b()}}}});e.responseType="arraybuffer";e.open("get",c[0].url);e.send()}else{b()}})(document)}};CanvasXpress.loadTopoJSON=function(a,b,d){if(a&&d){var c=false;if(!b){b="cXMap"}if(!window.hasOwnProperty(b)){c=true}(function(f){if(window.navigator.onLine&&c){var e=new XMLHttpRequest();e.addEventListener("readystatechange",function(g){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){window[b]=JSON.parse(e.response);d()}}}});e.open("get",a);e.send()}else{d()}})(document)}};CanvasXpress.loadRemoteData=function(j,c,f,l,k){if(c&&k){var m=this;CanvasXpress.prototype.initIO.apply(CanvasXpress);var d=function(o,e){for(var n in e){o[n]=e[n]}};var h=null;var g=window.document.getElementById(c);if(g&&g.tagName.toLowerCase()=="table"&&g.className=="CanvasXpress"&&g.id){h=this.b8(g,f);h.renderTo=j||g.id;h.events=l;g.parentNode.removeChild(g);return k(h)}else{if(this.hE(c)){(function(n){if(window.navigator.onLine){if(!j){j="cX-data-url"}var e=new XMLHttpRequest();e.onreadystatechange=function(){if(e.readyState==2&&e.status==200){}else{if(e.readyState==3){}else{if(e.readyState==4){if(c.match(/\.json$/)){h=m.c9(e.response);if(Array.isArray(h)){var t=h[0][1];var s=[];for(var r=0;r<h.length;r++){s.push(h[r][0])}if(!f){f={}}f.remoteService=c;f.remoteData=h;f.remoteIds=s;CanvasXpress.loadRemoteData(j,t,f,l,k)}else{h.renderTo=j||h.renderTo;h.events=l||h.events;d(h.config,f);k(h)}}else{if(c.match(/\.png$/)){h=m.ir(e.response);h.renderTo=j||h.renderTo;h.events=l||h.events;d(h.config,f);k(h)}else{if(c.match(/\.txt$/)||c.match(/\.csv$/)||c.match(/\.tsv$/)||c.match(/\.tab$/)){h=m.af(e.response);if(f&&f.graphType=="Network"){h=m.dL(h,j,f,l)}else{h=m.wD(h,f);h.renderTo=j||h.renderTo;h.events=l||h.events}d(h.config,f);k(h)}else{if(c.match(/\.svg$/)){h=m.we(e.response);d(h.config,f);k(h)}else{if(c.match(/ml$/)||c.match(/ml\.bz2$/)||c.match(/\.gexf$/)){var q=c.match(/ml\.bz2$/)?m.k8(m.yi(e.response)):m.k8(e.response);var p=q.childNodes[0];var o=q.childNodes[2];if(p.tagName&&p.tagName.toLowerCase()=="gexf"){h=m.WL(q,j,f,l);k(h)}else{if(p.tagName&&p.tagName.toLowerCase()=="map"){h=m.l1(q,j,f,l);k(h)}else{if(p.tagName&&p.tagName.toLowerCase()=="graph"){h=m.ba(q,j,f,l);k(h)}else{if(p.tagName&&p.tagName.toLowerCase()=="pathway"){h=m.Tw(q,j,f,l);k(h)}else{if(o&&o.tagName&&o.tagName.toLowerCase()=="pathway"){m.yc(q,j,f,l,k)}}}}}}else{k()}}}}}}}}};e.open("get",c);if(c.match(/\.png$/)){e.responseType="arraybuffer"}else{if(c.match(/ml\.bz2$/)){e.responseType="binary"}else{e.responseType="text"}}e.send()}})(document)}else{try{h=JSON.parse(c);return k(h)}catch(i){h=null}var h=m.af(c)||null;if(h){if(f&&f.graphType=="Network"){h=m.dL(h,j,f,l)}else{h=m.wD(h,f)}return k(h)}if(window.DOMParser){try{h=(new DOMParser()).parseFromString(c,"text/xml")}catch(i){h=null}}else{if(typeof window.ActiveXObject!="undefined"&&new window.ActiveXObject("Microsoft.XMLDOM")){try{h=new window.ActiveXObject("Microsoft.XMLDOM");h.async="false"}catch(i){h=null}}}if(h!=null&&h.getElementsByTagName("parsererror").length==0){var b=h.childNodes[0];var a=h.childNodes[2]||h.childNodes[1];if(b.tagName&&b.tagName.toLowerCase()=="gexf"){return k(m.WL(h,j,f,l))}else{if(b.tagName&&b.tagName.toLowerCase()=="map"){return k(m.l1(h,j,f,l))}else{if(b.tagName&&b.tagName.toLowerCase()=="graph"){return k(m.ba(h,j,f,l))}else{if(b.tagName&&b.tagName.toLowerCase()=="pathway"){return k(m.Tw(h,j,f,l))}else{if(a&&a.tagName&&a.tagName.toLowerCase()=="pathway"){return m.yc(h,j,f,l,k)}}}}}}return null}}}};CanvasXpress.prototype.initDataset=function(){};CanvasXpress.prototype.initAesthetics=function(){};CanvasXpress.prototype.initScale=function(){};CanvasXpress.prototype.initGeometry=function(){};CanvasXpress.prototype.initStatistics=function(){};CanvasXpress.prototype.initFacets=function(){};CanvasXpress.prototype.initCoordinates=function(){};CanvasXpress.prototype.initTheme=function(){};CanvasXpress.prototype.initRender=function(){};CanvasXpress.png="data:image/png;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.dates={Sun:1,Mon:2,Tue:3,Wed:4,Thu:5,Fri:6,Sat:7,Sunday:1,Monday:2,Tuesday:3,Wednesday:4,Thursday:5,Friday:6,Saturday:7,Jan:"01",Feb:"02",Mar:"03",Apr:"04",May:"05",Jun:"06",Jul:"07",Aug:"08",Sep:"09",Oct:"10",Nov:"11",Dec:"12",January:"01",February:"02",March:"03",April:"04",May:"05",June:"06",July:"07",August:"08",September:"09",October:"10",November:"11",December:"12"};CanvasXpress.countries={AFG:["Afghanistan","Asia","South Asia","AF",33.939,67.709],ALA:["Aland Islands","Europe","North Europe","AX",48.464,-122.706],ALB:["Albania","Europe","South Europe","AL",41.153,20.168],DZA:["Algeria","Africa","North Africa","DZ",28.033,1.659],ASM:["American Samoa","Oceania","Polynesia","AS",-14.271,-170.133],AND:["Andorra","Europe","South Europe","AD",42.546,1.601],AGO:["Angola","Africa","Middle Africa","AO",-11.203,17.873],AIA:["Anguilla","America","Caribbean","AI",18.22,-63.069],ATA:["Antarctica","","","AQ",-75.251,-0.072],ATG:["Antigua and Barbuda","America","Caribbean","AG",17.06,-61.797],ARG:["Argentina","America","South America","AR",-38.417,-63.617],ARM:["Armenia","Asia","West Asia","AM",40.069,45.038],ABW:["Aruba","America","Caribbean","AW",12.521,-69.969],AUS:["Australia","Oceania","Australia and New Zealand","AU",-25.275,133.775],AUT:["Austria","Europe","West Europe","AT",47.516,14.55],AZE:["Azerbaijan","Asia","West Asia","AZ",40.143,47.576],BHS:["Bahamas","America","Caribbean","BS",25.034,-77.397],BHR:["Bahrain","Asia","West Asia","BH",25.93,50.637],BGD:["Bangladesh","Asia","South Asia","BD",23.684,90.356],BRB:["Barbados","America","Caribbean","BB",13.193,-59.544],BLR:["Belarus","Europe","East Europe","BY",53.709,27.953],BEL:["Belgium","Europe","West Europe","BE",50.503,4.469],BLZ:["Belize","America","Central America","BZ",17.189,-88.498],BEN:["Benin","Africa","West Africa","BJ",9.307,2.315],BMU:["Bermuda","America","North America","BM",32.321,-64.758],BTN:["Bhutan","Asia","South Asia","BT",27.514,90.433],BOL:["Bolivia","America","South America","BO",-16.291,-63.589],BES:["Bonaire","America","Caribbean","BQ",12.201,-68.262],BIH:["Bosnia and Herzegovina","Europe","South Europe","BA",43.915,17.679],BWA:["Botswana","Africa","South Africa","BW",-22.329,24.684],BVT:["Bouvet Island","","","BV",-54.424,3.413],BRA:["Brazil","America","South America","BR",-14.236,-51.926],IOT:["British Indian Ocean Territory","","","IO",-6.344,71.876],BRN:["Brunei Darussalam","Asia","South-East Asia","BN",4.535,114.727],BGR:["Bulgaria","Europe","East Europe","BG",42.733,25.485],BFA:["Burkina Faso","Africa","West Africa","BF",12.238,-1.562],BDI:["Burundi","Africa","East Africa","BI",-3.374,29.918],KHM:["Cambodia","Asia","South-East Asia","KH",12.565,104.99],CMR:["Cameroon","Africa","Middle Africa","CM",7.369,12.354],CAN:["Canada","America","North America","CA",56.13,-106.347],CPV:["Cabo Verde","Africa","West Africa","CV",16.002,-24.014],CYM:["Cayman Islands","America","Caribbean","KY",19.513,-80.567],CAF:["Central African Republic","Africa","Middle Africa","CF",6.611,20.939],TCD:["Chad","Africa","Middle Africa","TD",15.454,18.732],CHL:["Chile","America","South America","CL",-35.676,-71.543],CHN:["China","Asia","East Asia","CN",35.861,104.195],CXR:["Christmas Island","","","CX",-10.448,105.69],CCK:["Cocos (Keeling) Islands","","","CC",-12.165,96.87],COL:["Colombia","America","South America","CO",4.57,-74.298],COM:["Comoros","Africa","East Africa","KM",-11.876,43.872],COG:["Congo","Africa","Middle Africa","CG",-0.229,15.827],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa","CD",-4.039,21.758],COK:["Cook Islands","Oceania","Polynesia","CK",-21.237,-159.778],CRI:["Costa Rica","America","Central America","CR",9.748,-83.754],CIV:["Cote d'Ivoire","Africa","West Africa","CI",7.539,-5.548],HRV:["Croatia","Europe","South Europe","HR",45.1,15.2],CUB:["Cuba","America","Caribbean","CU",21.521,-77.782],CUW:["Cura�ao","America","Caribbean","CW",12.169,-68.99],CYP:["Cyprus","Asia","West Asia","CY",35.126,33.429],CZE:["Czech Republic","Europe","East Europe","CZ",49.817,15.472],DNK:["Denmark","Europe","North Europe","DK",56.263,9.501],DJI:["Djibouti","Africa","East Africa","DJ",11.825,42.59],DMA:["Dominica","America","Caribbean","DM",15.414,-61.371],DOM:["Dominican Republic","America","Caribbean","DO",18.735,-70.163],ECU:["Ecuador","America","South America","EC",-1.832,-78.184],EGY:["Egypt","Africa","North Africa","EG",26.82,30.802],SLV:["El Salvador","America","Central America","SV",13.794,-88.897],GNQ:["Equatorial Guinea","Africa","Middle Africa","GQ",1.65,10.267],ERI:["Eritrea","Africa","East Africa","ER",15.179,39.782],EST:["Estonia","Europe","North Europe","EE",58.595,25.013],ETH:["Ethiopia","Africa","East Africa","ET",9.145,40.489],FLK:["Falkland Islands","America","South America","FK",-51.797,-59.524],FRO:["Faroe Islands","Europe","North Europe","FO",61.892,-6.912],FJI:["Fiji","Oceania","Melanesia","FJ",-16.579,179.414],FIN:["Finland","Europe","North Europe","FI",61.924,25.748],FRA:["France","Europe","West Europe","FR",46.227,2.213],GUF:["French Guiana","America","South America","GF",3.933,-53.126],PYF:["French Polynesia","Oceania","Polynesia","PF",-17.68,-149.407],ATF:["French Southern Territories","","","TF",-49.281,69.348],GAB:["Gabon","Africa","Middle Africa","GA",-0.804,11.609],GMB:["Gambia","Africa","West Africa","GM",13.443,-15.311],GEO:["Georgia","Asia","West Asia","GE",42.315,43.356],DEU:["Germany","Europe","West Europe","DE",51.165,10.451],GHA:["Ghana","Africa","West Africa","GH",7.946,-1.024],GIB:["Gibraltar","Europe","South Europe","GI",36.137,-5.346],GRC:["Greece","Europe","South Europe","GR",39.074,21.824],GRE:["Greece","Europe","South Europe","EL",39.074,21.824],GRL:["Greenland","America","North America","GL",71.706,-42.605],GRD:["Grenada","America","Caribbean","GD",12.262,-61.605],GLP:["Guadeloupe","America","Caribbean","GP",16.995,-62.068],GUM:["Guam","Oceania","Micronesia","GU",13.444,144.793],GTM:["Guatemala","America","Central America","GT",15.783,-90.231],GGY:["Guernsey","Europe","North Europe","GG",49.465,-2.586],GIN:["Guinea","Africa","West Africa","GN",9.945,-9.697],GNB:["Guinea-Bissau","Africa","West Africa","GW",11.803,-15.181],GUY:["Guyana","America","South America","GY",4.86,-58.931],HTI:["Haiti","America","Caribbean","HT",18.971,-72.286],HMD:["Heard Island and McDonald Islands","","","HM",-53.082,73.504],VAT:["Holy See","Europe","South Europe","VA",41.902,12.453],HND:["Honduras","America","Central America","HN",15.199,-86.242],HKG:["Hong Kong","Asia","East Asia","HK",22.396,114.109],HUN:["Hungary","Europe","East Europe","HU",47.162,19.503],ISL:["Iceland","Europe","North Europe","IS",64.963,-19.021],IND:["India","Asia","South Asia","IN",20.593,78.962],IDN:["Indonesia","Asia","South-East Asia","ID",-0.79,113.921],IRN:["Iran","Asia","South Asia","IR",32.427,53.688],IRQ:["Iraq","Asia","West Asia","IQ",33.223,43.679],IRL:["Ireland","Europe","North Europe","IE",53.412,-8.244],IMN:["Isle of Man","Europe","North Europe","IM",54.236,-4.549],ISR:["Israel","Asia","West Asia","IL",31.046,34.851],ITA:["Italy","Europe","South Europe","IT",41.871,12.567],JAM:["Jamaica","America","Caribbean","JM",18.109,-77.298],JPN:["Japan","Asia","East Asia","JP",36.204,138.252],JEY:["Jersey","Europe","North Europe","JE",49.214,-2.132],JOR:["Jordan","Asia","West Asia","JO",30.585,36.238],KAZ:["Kazakhstan","Asia","Central Asia","KZ",48.019,66.923],KEN:["Kenya","Africa","East Africa","KE",-0.024,37.906],KIR:["Kiribati","Oceania","Micronesia","KI",-3.371,-168.735],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia","KP",40.339,127.51],KOR:["Korea (Republic of)","Asia","East Asia","KR",35.907,127.766],XKX:["Kosovo","Europe","South Europe","XK",42.602,20.902],KWT:["Kuwait","Asia","West Asia","KW",29.311,47.481],KGZ:["Kyrgyzstan","Asia","Central Asia","KG",41.204,74.766],LAO:["Lao People's Democratic Republic","Asia","South-East Asia","LA",19.856,102.495],LVA:["Latvia","Europe","North Europe","LV",56.879,24.603],LBN:["Lebanon","Asia","West Asia","LB",33.854,35.862],LSO:["Lesotho","Africa","South Africa","LS",-29.61,28.233],LBR:["Liberia","Africa","West Africa","LR",6.428,-9.43],LBY:["Libya","Africa","North Africa","LY",26.335,17.228],LIE:["Liechtenstein","Europe","West Europe","LI",47.166,9.555],LTU:["Lithuania","Europe","North Europe","LT",55.169,23.881],LUX:["Luxembourg","Europe","West Europe","LU",49.815,6.129],MAC:["Macao","Asia","East Asia","MO",22.198,113.543],MKD:["Macedonia","Europe","South Europe","MK",41.608,21.745],MDG:["Madagascar","Africa","East Africa","MG",-18.767,46.869],MWI:["Malawi","Africa","East Africa","MW",-13.255,34.301],MYS:["Malaysia","Asia","South-East Asia","MY",4.21,101.975],MDV:["Maldives","Asia","South Asia","MV",3.202,73.22],MLI:["Mali","Africa","West Africa","ML",17.57,-3.997],MLT:["Malta","Europe","South Europe","MT",35.937,14.375],MHL:["Marshall Islands","Oceania","Micronesia","MH",7.131,171.184],MTQ:["Martinique","America","Caribbean","MQ",14.641,-61.025],MRT:["Mauritania","Africa","West Africa","MR",21.007,-10.941],MUS:["Mauritius","Africa","East Africa","MU",-20.349,57.552],MYT:["Mayotte","Africa","East Africa","YT",-12.828,45.166],MEX:["Mexico","America","Central America","MX",23.634,-102.553],FSM:["Micronesia","Oceania","Micronesia","FM",7.425,150.55],MDA:["Moldova","Europe","East Europe","MD",47.411,28.369],MCO:["Monaco","Europe","West Europe","MC",43.75,7.412],MNG:["Mongolia","Asia","East Asia","MN",46.862,103.846],MNE:["Montenegro","Europe","South Europe","ME",42.708,19.374],MSR:["Montserrat","America","Caribbean","MS",16.742,-62.188],MAR:["Morocco","Africa","North Africa","MA",31.791,-7.093],MOZ:["Mozambique","Africa","East Africa","MZ",-18.666,35.529],MMR:["Myanmar","Asia","South-East Asia","MM",21.913,95.956],NAM:["Namibia","Africa","South Africa","NA",-22.958,18.49],NRU:["Nauru","Oceania","Micronesia","NR",-0.523,166.931],NPL:["Nepal","Asia","South Asia","NP",28.394,84.124],NLD:["Netherlands","Europe","West Europe","NL",52.132,5.291],ANT:["Netherlands Antilles","","","AN",12.226,-69.061],NCL:["New Caledonia","Oceania","Melanesia","NC",-20.905,165.618],NZL:["New Zealand","Oceania","Australia and New Zealand","NZ",-40.901,174.885],NIC:["Nicaragua","America","Central America","NI",12.865,-85.208],NER:["Niger","Africa","West Africa","NE",17.607,8.081],NGA:["Nigeria","Africa","West Africa","NG",9.081,8.675],NIU:["Niue","Oceania","Polynesia","NU",-19.055,-169.868],NFK:["Norfolk Island","Oceania","Australia and New Zealand","NF",-29.041,167.954],MNP:["West Mariana Islands","Oceania","Micronesia","MP",17.33,145.384],NOR:["Norway","Europe","North Europe","NO",60.472,8.468],OMN:["Oman","Asia","West Asia","OM",21.512,55.923],PAK:["Pakistan","Asia","South Asia","PK",30.375,69.345],PLW:["Palau","Oceania","Micronesia","PW",7.514,134.582],PSE:["Palestine","Asia","West Asia","PS",31.952,35.233],PAN:["Panama","America","Central America","PA",8.537,-80.783],PNG:["Papua New Guinea","Oceania","Melanesia","PG",-6.315,143.955],PRY:["Paraguay","America","South America","PY",-23.443,-58.444],PER:["Peru","America","South America","PE",-9.19,-75.016],PHL:["Philippines","Asia","South-East Asia","PH",12.879,121.774],PCN:["Pitcairn","Oceania","Polynesia","PN",-24.704,-127.44],POL:["Poland","Europe","East Europe","PL",51.919,19.145],PRT:["Portugal","Europe","South Europe","PT",39.399,-8.225],PRI:["Puerto Rico","America","Caribbean","PR",18.22,-66.591],QAT:["Qatar","Asia","West Asia","QA",25.354,51.183],REU:["R�union","Africa","East Africa","RE",-21.116,55.536],ROU:["Romania","Europe","East Europe","RO",45.943,24.966],RUS:["Russian Federation","Europe","East Europe","RU",61.524,105.318],RWA:["Rwanda","Africa","East Africa","RW",-1.941,29.873],BLM:["Saint Barthelemy","America","Caribbean","BL",17.899,-62.833],SHN:["Saint Helena","Africa","West Africa","SH",-24.144,-10.031],KNA:["Saint Kitts and Nevis","America","Caribbean","KN",17.357,-62.783],LCA:["Saint Lucia","America","Caribbean","LC",13.909,-60.979],MAF:["Saint Martin","America","Caribbean","MF",18.075,-63.06],SPM:["Saint Pierre and Miquelon","America","North America","PM",46.941,-56.272],VCT:["Saint Vincent and the Grenadines","America","Caribbean","VC",12.984,-61.288],WSM:["Samoa","Oceania","Polynesia","WS",-13.76,-172.105],SMR:["San Marino","Europe","South Europe","SM",43.942,12.457],STP:["Sao Tome and Principe","Africa","Middle Africa","ST",0.186,6.613],SAU:["Saudi Arabia","Asia","West Asia","SA",23.885,45.079],SEN:["Senegal","Africa","West Africa","SN",14.497,-14.453],SRB:["Serbia","Europe","South Europe","RS",44.016,21.005],SYC:["Seychelles","Africa","East Africa","SC",-4.68,55.491],SLE:["Sierra Leone","Africa","West Africa","SL",8.46,-11.78],SGP:["Singapore","Asia","South-East Asia","SG",1.352,103.819],SXM:["Sint Maarten","America","Caribbean","SX",18.042,-63.054],SVK:["Slovakia","Europe","East Europe","SK",48.669,19.699],SVN:["Slovenia","Europe","South Europe","SI",46.151,14.995],SLB:["Solomon Islands","Oceania","Melanesia","SB",-9.646,160.156],SOM:["Somalia","Africa","East Africa","SO",5.152,46.199],ZAF:["South Africa","Africa","South Africa","ZA",-30.56,22.937],SGS:["South Georgia and the South Sandwich Islands","","","GS",-54.43,-36.588],SSD:["South Sudan","Africa","East Africa","SS",4.859,31.571],ESP:["Spain","Europe","South Europe","ES",40.463,-3.75],LKA:["Sri Lanka","Asia","South Asia","LK",7.873,80.771],SDN:["Sudan","Africa","North Africa","SD",12.862,30.217],SUR:["Suriname","America","South America","SR",3.919,-56.028],SJM:["Svalbard and Jan Mayen","Europe","North Europe","SJ",77.553,23.67],SWZ:["Swaziland","Africa","South Africa","SZ",-26.523,31.465],SWE:["Sweden","Europe","North Europe","SE",60.128,18.643],CHE:["Switzerland","Europe","West Europe","CH",46.818,8.227],SYR:["Syrian Arab Republic","Asia","West Asia","SY",34.802,38.996],TWN:["Taiwan","Asia","East Asia","TW",23.697,120.96],TJK:["Tajikistan","Asia","Central Asia","TJ",38.861,71.276],TZA:["Tanzania","Africa","East Africa","TZ",-6.37,34.888],THA:["Thailand","Asia","South-East Asia","TH",15.87,100.992],TLS:["Timor-Leste","Asia","South-East Asia","TL",-8.875,125.727],TGO:["Togo","Africa","West Africa","TG",8.619,0.824],TKL:["Tokelau","Oceania","Polynesia","TK",-8.968,-171.856],TON:["Tonga","Oceania","Polynesia","TO",-21.179,-175.199],TTO:["Trinidad and Tobago","America","Caribbean","TT",10.691,-61.223],TUN:["Tunisia","Africa","North Africa","TN",33.886,9.537],TUR:["Turkey","Asia","West Asia","TR",38.963,35.243],TKM:["Turkmenistan","Asia","Central Asia","TM",38.969,59.556],TCA:["Turks and Caicos Islands","America","Caribbean","TC",21.694,-71.798],TUV:["Tuvalu","Oceania","Polynesia","TV",-7.11,177.649],UGA:["Uganda","Africa","East Africa","UG",1.373,32.29],UKR:["Ukraine","Europe","East Europe","UA",48.379,31.165],ARE:["United Arab Emirates","Asia","West Asia","AE",23.424,53.847],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","GB",55.378,-3.436],UKM:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe","UK",55.378,-3.436],USA:["United States of America","America","North America","US",37.09,-95.713],UMI:["United States Minor Outlying Islands","","","UM",-0.374,-159.996],URY:["Uruguay","America","South America","UY",-32.523,-55.766],UZB:["Uzbekistan","Asia","Central Asia","UZ",41.377,64.585],VUT:["Vanuatu","Oceania","Melanesia","VU",-15.377,166.959],VEN:["Venezuela","America","South America","VE",6.423,-66.59],VNM:["Vietnam","Asia","South-East Asia","VN",14.058,108.277],VGB:["Virgin Islands (British)","America","Caribbean","VG",18.42,-64.64],VIR:["Virgin Islands (U.S.)","America","Caribbean","VI",18.335,-64.897],WLF:["Wallis and Futuna","Oceania","Polynesia","WF",-13.769,-177.157],ESH:["Western Sahara","Africa","North Africa","EH",24.215,-12.886],XXX:["Unespecified Nationality","","","XX",],YEM:["Yemen","Asia","West Asia","YE",15.552,48.516],ZMB:["Zambia","Africa","East Africa","ZM",-13.134,27.849],ZWE:["Zimbabwe","Africa","East Africa","ZW",-19.016,29.154]};CanvasXpress.usa={AK:["Alaska",63.588753,-154.493062],AL:["Alabama",32.318231,-86.902298],AR:["Arkansas",35.20105,-91.831833],AZ:["Arizona",34.048928,-111.093731],CA:["California",36.778261,-119.417932],CO:["Colorado",39.550051,-105.782067],CT:["Connecticut",41.603221,-73.087749],DC:["District of Columbia",38.905985,-77.033418],DE:["Delaware",38.910832,-75.52767],FL:["Florida",27.664827,-81.515754],GA:["Georgia",32.157435,-82.907123],HI:["Hawaii",19.898682,-155.665857],IA:["Iowa",41.878003,-93.097702],ID:["Idaho",44.068202,-114.742041],IL:["Illinois",40.633125,-89.398528],IN:["Indiana",40.551217,-85.602364],KS:["Kansas",39.011902,-98.484246],KY:["Kentucky",37.839333,-84.270018],LA:["Louisiana",31.244823,-92.145024],MA:["Massachusetts",42.407211,-71.382437],MD:["Maryland",39.045755,-76.641271],ME:["Maine",45.253783,-69.445469],MI:["Michigan",44.314844,-85.602364],MN:["Minnesota",46.729553,-94.6859],MO:["Missouri",37.964253,-91.831833],MS:["Mississippi",32.354668,-89.398528],MT:["Montana",46.879682,-110.362566],NC:["North Carolina",35.759573,-79.0193],ND:["NorthDakota",47.551493,-101.002012],NE:["Nebraska",41.492537,-99.901813],NH:["New Hampshire",43.193852,-71.572395],NJ:["New Jersey",40.058324,-74.405661],NM:["New Mexico",34.97273,-105.032363],NV:["Nevada",38.80261,-116.419389],NY:["New York",43.299428,-74.217933],OH:["Ohio",40.417287,-82.907123],OK:["Oklahoma",35.007752,-97.092877],OR:["Oregon",43.804133,-120.554201],PA:["Pennsylvania",41.203322,-77.194525],PR:["Puerto Rico",18.220833,-66.590149],RI:["Rhode Island",41.580095,-71.477429],SC:["South Carolina",33.836081,-81.163725],SD:["South Dakota",43.969515,-99.901813],TN:["Tennessee",35.517491,-86.580447],TX:["Texas",31.968599,-99.901813],UT:["Utah",39.32098,-111.093731],VA:["Virginia",37.431573,-78.656894],VT:["Vermont",44.558803,-72.577841],WA:["Washington",47.751074,-120.740139],WI:["Wisconsin",43.78444,-88.787868],WV:["West Virginia",38.597626,-80.454903],WY:["Wyoming",43.075968,-107.290284]};CanvasXpress.maps={Africa:"/data/africa.geo.json",Argentina:"/data/argentina.geo.json",Asia:"/data/asia.geo.json",Belgium:"/data/belgium.geo.json",China:"/data/china.geo.json",Colombia:"/data/colombia.geo.json",Countries:"/data/countries.geo.json",Europe:"/data/europe.geo.json",France:"/data/france.geo.json",India:"/data/india.geo.json",Italy:"/data/italy.geo.json",NorthAmerica:"/data/north-america.geo.json",Oceania:"/data/oceania.geo.json",SouthAmerica:"/data/south-america.geo.json",Spain:"/data/spain.geo.json",UnitedKingdom:"/data/united-kindom.geo.json",USA:"/data/USA.geo.json",USACounties:"/data/usa-counties.json",USADistricts:"/data/usa-districts.json",USAStates:"/data/usa-states.json",WorldContinents:"/data/world-continents-geo.json",World:"/data/world.geo.json"};CanvasXpress.geojson={type:"FeatureCollection",features:[{type:"Feature",properties:{name:"Dummy"},geometry:{type:"Polygon",coordinates:[[[-180,-90],[180,-90],[180,90],[-180,90],[-180,-90]]]}}]};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5400000,"p36.32","gpos25"],[5400000,7200000,"p36.31","gneg"],[7200000,9200000,"p36.23","gpos25"],[9200000,12700000,"p36.22","gneg"],[12700000,16200000,"p36.21","gpos50"],[16200000,20400000,"p36.13","gneg"],[20400000,23900000,"p36.12","gpos25"],[23900000,28000000,"p36.11","gneg"],[28000000,30200000,"p35.3","gpos25"],[30200000,32400000,"p35.2","gneg"],[32400000,34600000,"p35.1","gpos25"],[34600000,40100000,"p34.3","gneg"],[40100000,44100000,"p34.2","gpos25"],[44100000,46800000,"p34.1","gneg"],[46800000,50700000,"p33","gpos75"],[50700000,56100000,"p32.3","gneg"],[56100000,59000000,"p32.2","gpos50"],[59000000,61300000,"p32.1","gneg"],[61300000,68900000,"p31.3","gpos50"],[68900000,69700000,"p31.2","gneg"],[69700000,84900000,"p31.1","gpos100"],[84900000,88400000,"p22.3","gneg"],[88400000,92000000,"p22.2","gpos75"],[92000000,94700000,"p22.1","gneg"],[94700000,99700000,"p21.3","gpos75"],[99700000,102200000,"p21.2","gneg"],[102200000,107200000,"p21.1","gpos100"],[107200000,111800000,"p13.3","gneg"],[111800000,116100000,"p13.2","gpos50"],[116100000,117800000,"p13.1","gneg"],[117800000,120600000,"p12","gpos50"],[120600000,121500000,"p11.2","gneg"],[121500000,125000000,"p11.1","acen"],[125000000,128900000,"q11","acen"],[128900000,142600000,"q12","gvar"],[142600000,147000000,"q21.1","gneg"],[147000000,150300000,"q21.2","gpos50"],[150300000,155000000,"q21.3","gneg"],[155000000,156500000,"q22","gpos50"],[156500000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,172900000,"q24.3","gpos75"],[172900000,176000000,"q25.1","gneg"],[176000000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207200000,"q32.1","gneg"],[207200000,211500000,"q32.2","gpos25"],[211500000,214500000,"q32.3","gneg"],[214500000,224100000,"q41","gpos100"],[224100000,224600000,"q42.11","gneg"],[224600000,227000000,"q42.12","gpos25"],[227000000,230700000,"q42.13","gneg"],[230700000,234700000,"q42.2","gpos50"],[234700000,236600000,"q42.3","gneg"],[236600000,243700000,"q43","gpos75"],[243700000,249250621,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,7100000,"p25.2","gpos50"],[7100000,12200000,"p25.1","gneg"],[12200000,16700000,"p24.3","gpos75"],[16700000,19200000,"p24.2","gneg"],[19200000,24000000,"p24.1","gpos75"],[24000000,27900000,"p23.3","gneg"],[27900000,30000000,"p23.2","gpos25"],[30000000,32100000,"p23.1","gneg"],[32100000,36600000,"p22.3","gpos75"],[36600000,38600000,"p22.2","gneg"],[38600000,41800000,"p22.1","gpos50"],[41800000,47800000,"p21","gneg"],[47800000,52900000,"p16.3","gpos100"],[52900000,55000000,"p16.2","gneg"],[55000000,61300000,"p16.1","gpos100"],[61300000,64100000,"p15","gneg"],[64100000,68600000,"p14","gpos50"],[68600000,71500000,"p13.3","gneg"],[71500000,73500000,"p13.2","gpos50"],[73500000,75000000,"p13.1","gneg"],[75000000,83300000,"p12","gpos100"],[83300000,90500000,"p11.2","gneg"],[90500000,93300000,"p11.1","acen"],[93300000,96800000,"q11.1","acen"],[96800000,102700000,"q11.2","gneg"],[102700000,106000000,"q12.1","gpos50"],[106000000,107500000,"q12.2","gneg"],[107500000,110200000,"q12.3","gpos25"],[110200000,114400000,"q13","gneg"],[114400000,118800000,"q14.1","gpos50"],[118800000,122400000,"q14.2","gneg"],[122400000,129900000,"q14.3","gpos50"],[129900000,132500000,"q21.1","gneg"],[132500000,135100000,"q21.2","gpos25"],[135100000,136800000,"q21.3","gneg"],[136800000,142200000,"q22.1","gpos100"],[142200000,144100000,"q22.2","gneg"],[144100000,148700000,"q22.3","gpos100"],[148700000,149900000,"q23.1","gneg"],[149900000,150500000,"q23.2","gpos25"],[150500000,154900000,"q23.3","gneg"],[154900000,159800000,"q24.1","gpos75"],[159800000,163700000,"q24.2","gneg"],[163700000,169700000,"q24.3","gpos75"],[169700000,178000000,"q31.1","gneg"],[178000000,180600000,"q31.2","gpos50"],[180600000,183000000,"q31.3","gneg"],[183000000,189400000,"q32.1","gpos75"],[189400000,191900000,"q32.2","gneg"],[191900000,197400000,"q32.3","gpos75"],[197400000,203300000,"q33.1","gneg"],[203300000,204900000,"q33.2","gpos50"],[204900000,209000000,"q33.3","gneg"],[209000000,215300000,"q34","gpos100"],[215300000,221500000,"q35","gneg"],[221500000,225200000,"q36.1","gpos75"],[225200000,226100000,"q36.2","gneg"],[226100000,231000000,"q36.3","gpos100"],[231000000,235600000,"q37.1","gneg"],[235600000,237300000,"q37.2","gpos50"],[237300000,243199373,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8700000,"p26.1","gpos50"],[8700000,11800000,"p25.3","gneg"],[11800000,13300000,"p25.2","gpos25"],[13300000,16400000,"p25.1","gneg"],[16400000,23900000,"p24.3","gpos100"],[23900000,26400000,"p24.2","gneg"],[26400000,30900000,"p24.1","gpos75"],[30900000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39400000,"p22.2","gneg"],[39400000,43700000,"p22.1","gpos75"],[43700000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63700000,"p14.2","gneg"],[63700000,69800000,"p14.1","gpos50"],[69800000,74200000,"p13","gneg"],[74200000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87200000,"p12.1","gpos75"],[87200000,87900000,"p11.2","gneg"],[87900000,91000000,"p11.1","acen"],[91000000,93900000,"q11.1","acen"],[93900000,98300000,"q11.2","gvar"],[98300000,100000000,"q12.1","gneg"],[100000000,100900000,"q12.2","gpos25"],[100900000,102800000,"q12.3","gneg"],[102800000,106200000,"q13.11","gpos75"],[106200000,107900000,"q13.12","gneg"],[107900000,111300000,"q13.13","gpos50"],[111300000,113500000,"q13.2","gneg"],[113500000,117300000,"q13.31","gpos75"],[117300000,119000000,"q13.32","gneg"],[119000000,121900000,"q13.33","gpos75"],[121900000,123800000,"q21.1","gneg"],[123800000,125800000,"q21.2","gpos25"],[125800000,129200000,"q21.3","gneg"],[129200000,133700000,"q22.1","gpos25"],[133700000,135700000,"q22.2","gneg"],[135700000,138700000,"q22.3","gpos25"],[138700000,142800000,"q23","gneg"],[142800000,148900000,"q24","gpos100"],[148900000,152100000,"q25.1","gneg"],[152100000,155000000,"q25.2","gpos50"],[155000000,157000000,"q25.31","gneg"],[157000000,159000000,"q25.32","gpos50"],[159000000,160700000,"q25.33","gneg"],[160700000,167600000,"q26.1","gpos100"],[167600000,170900000,"q26.2","gneg"],[170900000,175700000,"q26.31","gpos75"],[175700000,179000000,"q26.32","gneg"],[179000000,182700000,"q26.33","gpos75"],[182700000,184500000,"q27.1","gneg"],[184500000,186000000,"q27.2","gpos25"],[186000000,187900000,"q27.3","gneg"],[187900000,192300000,"q28","gpos75"],[192300000,198022430,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15200000,"p15.33","gpos50"],[15200000,17800000,"p15.32","gneg"],[17800000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50400000,"p11","acen"],[50400000,52700000,"q11","acen"],[52700000,59500000,"q12","gneg"],[59500000,66600000,"q13.1","gpos100"],[66600000,70500000,"q13.2","gneg"],[70500000,76300000,"q13.3","gpos75"],[76300000,78900000,"q21.1","gneg"],[78900000,82400000,"q21.21","gpos50"],[82400000,84100000,"q21.22","gneg"],[84100000,86900000,"q21.23","gpos25"],[86900000,88000000,"q21.3","gneg"],[88000000,93700000,"q22.1","gpos75"],[93700000,95100000,"q22.2","gneg"],[95100000,98800000,"q22.3","gpos75"],[98800000,101100000,"q23","gneg"],[101100000,107700000,"q24","gpos50"],[107700000,114100000,"q25","gneg"],[114100000,120800000,"q26","gpos75"],[120800000,123800000,"q27","gneg"],[123800000,128800000,"q28.1","gpos50"],[128800000,131100000,"q28.2","gneg"],[131100000,139500000,"q28.3","gpos100"],[139500000,141500000,"q31.1","gneg"],[141500000,146800000,"q31.21","gpos25"],[146800000,148500000,"q31.22","gneg"],[148500000,151100000,"q31.23","gpos25"],[151100000,155600000,"q31.3","gneg"],[155600000,161800000,"q32.1","gpos100"],[161800000,164500000,"q32.2","gneg"],[164500000,170100000,"q32.3","gpos100"],[170100000,171900000,"q33","gneg"],[171900000,176300000,"q34.1","gpos75"],[176300000,177500000,"q34.2","gneg"],[177500000,183200000,"q34.3","gpos100"],[183200000,187100000,"q35.1","gneg"],[187100000,191154276,"q35.2","gpos25"]],5:[[0,4500000,"p15.33","gneg"],[4500000,6300000,"p15.32","gpos25"],[6300000,9800000,"p15.31","gneg"],[9800000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48400000,"p11","acen"],[48400000,50700000,"q11.1","acen"],[50700000,58900000,"q11.2","gneg"],[58900000,62900000,"q12.1","gpos75"],[62900000,63200000,"q12.2","gneg"],[63200000,66700000,"q12.3","gpos75"],[66700000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76900000,"q13.3","gneg"],[76900000,81400000,"q14.1","gpos50"],[81400000,82800000,"q14.2","gneg"],[82800000,92300000,"q14.3","gpos100"],[92300000,98200000,"q15","gneg"],[98200000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121400000,"q23.1","gpos100"],[121400000,127300000,"q23.2","gneg"],[127300000,130600000,"q23.3","gpos100"],[130600000,136200000,"q31.1","gneg"],[136200000,139500000,"q31.2","gpos25"],[139500000,144500000,"q31.3","gneg"],[144500000,149800000,"q32","gpos75"],[149800000,152700000,"q33.1","gneg"],[152700000,155700000,"q33.2","gpos50"],[155700000,159900000,"q33.3","gneg"],[159900000,168500000,"q34","gpos100"],[168500000,172800000,"q35.1","gneg"],[172800000,176600000,"q35.2","gpos25"],[176600000,180915260,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27000000,"p22.2","gneg"],[27000000,30400000,"p22.1","gpos50"],[30400000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,52900000,"p12.2","gneg"],[52900000,57000000,"p12.1","gpos100"],[57000000,58700000,"p11.2","gneg"],[58700000,61000000,"p11.1","acen"],[61000000,63300000,"q11.1","acen"],[63300000,63400000,"q11.2","gneg"],[63400000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84900000,"q14.2","gneg"],[84900000,88000000,"q14.3","gpos50"],[88000000,93100000,"q15","gneg"],[93100000,99500000,"q16.1","gpos100"],[99500000,100600000,"q16.2","gneg"],[100600000,105500000,"q16.3","gpos100"],[105500000,114600000,"q21","gneg"],[114600000,118300000,"q22.1","gpos75"],[118300000,118500000,"q22.2","gneg"],[118500000,126100000,"q22.31","gpos100"],[126100000,127100000,"q22.32","gneg"],[127100000,130300000,"q22.33","gpos75"],[130300000,131200000,"q23.1","gneg"],[131200000,135200000,"q23.2","gpos50"],[135200000,139000000,"q23.3","gneg"],[139000000,142800000,"q24.1","gpos75"],[142800000,145600000,"q24.2","gneg"],[145600000,149000000,"q24.3","gpos75"],[149000000,152500000,"q25.1","gneg"],[152500000,155500000,"q25.2","gpos50"],[155500000,161000000,"q25.3","gneg"],[161000000,164500000,"q26","gpos50"],[164500000,171115067,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7300000,"p22.1","gneg"],[7300000,13800000,"p21.3","gpos100"],[13800000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,28000000,"p15.2","gpos50"],[28000000,28800000,"p15.1","gneg"],[28800000,35000000,"p14.3","gpos75"],[35000000,37200000,"p14.2","gneg"],[37200000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,54000000,"p12.1","gpos75"],[54000000,58000000,"p11.2","gneg"],[58000000,59900000,"p11.1","acen"],[59900000,61700000,"q11.1","acen"],[61700000,67000000,"q11.21","gneg"],[67000000,72200000,"q11.22","gpos50"],[72200000,77500000,"q11.23","gneg"],[77500000,86400000,"q21.11","gpos100"],[86400000,88200000,"q21.12","gneg"],[88200000,91100000,"q21.13","gpos75"],[91100000,92800000,"q21.2","gneg"],[92800000,98000000,"q21.3","gpos75"],[98000000,103800000,"q22.1","gneg"],[103800000,104500000,"q22.2","gpos50"],[104500000,107400000,"q22.3","gneg"],[107400000,114600000,"q31.1","gpos75"],[114600000,117400000,"q31.2","gneg"],[117400000,121100000,"q31.31","gpos75"],[121100000,123800000,"q31.32","gneg"],[123800000,127100000,"q31.33","gpos75"],[127100000,129200000,"q32.1","gneg"],[129200000,130400000,"q32.2","gpos25"],[130400000,132600000,"q32.3","gneg"],[132600000,138200000,"q33","gpos50"],[138200000,143100000,"q34","gneg"],[143100000,147900000,"q35","gpos75"],[147900000,152600000,"q36.1","gneg"],[152600000,155100000,"q36.2","gpos25"],[155100000,159138663,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19000000,"p22","gpos100"],[19000000,23300000,"p21.3","gneg"],[23300000,27400000,"p21.2","gpos50"],[27400000,28800000,"p21.1","gneg"],[28800000,36500000,"p12","gpos75"],[36500000,38300000,"p11.23","gneg"],[38300000,39700000,"p11.22","gpos25"],[39700000,43100000,"p11.21","gneg"],[43100000,45600000,"p11.1","acen"],[45600000,48100000,"q11.1","acen"],[48100000,52200000,"q11.21","gneg"],[52200000,52600000,"q11.22","gpos75"],[52600000,55500000,"q11.23","gneg"],[55500000,61600000,"q12.1","gpos50"],[61600000,62200000,"q12.2","gneg"],[62200000,66000000,"q12.3","gpos50"],[66000000,68000000,"q13.1","gneg"],[68000000,70500000,"q13.2","gpos50"],[70500000,73900000,"q13.3","gneg"],[73900000,78300000,"q21.11","gpos100"],[78300000,80100000,"q21.12","gneg"],[80100000,84600000,"q21.13","gpos75"],[84600000,86900000,"q21.2","gneg"],[86900000,93300000,"q21.3","gpos100"],[93300000,99000000,"q22.1","gneg"],[99000000,101600000,"q22.2","gpos25"],[101600000,106200000,"q22.3","gneg"],[106200000,110500000,"q23.1","gpos75"],[110500000,112100000,"q23.2","gneg"],[112100000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136400000,"q24.22","gneg"],[136400000,139900000,"q24.23","gpos75"],[139900000,146364022,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,38400000,"p13.2","gpos25"],[38400000,41000000,"p13.1","gneg"],[41000000,43600000,"p12","gpos50"],[43600000,47300000,"p11.2","gneg"],[47300000,49000000,"p11.1","acen"],[49000000,50700000,"q11","acen"],[50700000,65900000,"q12","gvar"],[65900000,68700000,"q13","gneg"],[68700000,72200000,"q21.11","gpos25"],[72200000,74000000,"q21.12","gneg"],[74000000,79200000,"q21.13","gpos50"],[79200000,81100000,"q21.2","gneg"],[81100000,84100000,"q21.31","gpos50"],[84100000,86900000,"q21.32","gneg"],[86900000,90400000,"q21.33","gpos50"],[90400000,91800000,"q22.1","gneg"],[91800000,93900000,"q22.2","gpos25"],[93900000,96600000,"q22.31","gneg"],[96600000,99300000,"q22.32","gpos25"],[99300000,102600000,"q22.33","gneg"],[102600000,108200000,"q31.1","gpos100"],[108200000,111300000,"q31.2","gneg"],[111300000,114900000,"q31.3","gpos25"],[114900000,117700000,"q32","gneg"],[117700000,122500000,"q33.1","gpos75"],[122500000,125800000,"q33.2","gneg"],[125800000,130300000,"q33.3","gpos25"],[130300000,133500000,"q34.11","gneg"],[133500000,134000000,"q34.12","gpos25"],[134000000,135900000,"q34.13","gneg"],[135900000,137400000,"q34.2","gpos25"],[137400000,141213431,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18600000,"p12.33","gpos75"],[18600000,18700000,"p12.32","gneg"],[18700000,22600000,"p12.31","gpos75"],[22600000,24600000,"p12.2","gneg"],[24600000,29600000,"p12.1","gpos50"],[29600000,31300000,"p11.23","gneg"],[31300000,34400000,"p11.22","gpos25"],[34400000,38000000,"p11.21","gneg"],[38000000,40200000,"p11.1","acen"],[40200000,42300000,"q11.1","acen"],[42300000,46100000,"q11.21","gneg"],[46100000,49900000,"q11.22","gpos25"],[49900000,52900000,"q11.23","gneg"],[52900000,61200000,"q21.1","gpos100"],[61200000,64500000,"q21.2","gneg"],[64500000,70600000,"q21.3","gpos100"],[70600000,74900000,"q22.1","gneg"],[74900000,77700000,"q22.2","gpos50"],[77700000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89500000,"q23.2","gneg"],[89500000,92900000,"q23.31","gpos75"],[92900000,94100000,"q23.32","gneg"],[94100000,97000000,"q23.33","gpos50"],[97000000,99300000,"q24.1","gneg"],[99300000,101900000,"q24.2","gpos50"],[101900000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105800000,"q24.33","gneg"],[105800000,111900000,"q25.1","gpos100"],[111900000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127500000,"q26.13","gneg"],[127500000,130600000,"q26.2","gpos50"],[130600000,135534747,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12700000,"p15.3","gneg"],[12700000,16200000,"p15.2","gpos50"],[16200000,21700000,"p15.1","gneg"],[21700000,26100000,"p14.3","gpos100"],[26100000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43500000,"p12","gpos100"],[43500000,48800000,"p11.2","gneg"],[48800000,51600000,"p11.12","gpos75"],[51600000,53700000,"p11.11","acen"],[53700000,55700000,"q11","acen"],[55700000,59900000,"q12.1","gpos75"],[59900000,61700000,"q12.2","gneg"],[61700000,63400000,"q12.3","gpos25"],[63400000,65900000,"q13.1","gneg"],[65900000,68400000,"q13.2","gpos25"],[68400000,70400000,"q13.3","gneg"],[70400000,75200000,"q13.4","gpos50"],[75200000,77100000,"q13.5","gneg"],[77100000,85600000,"q14.1","gpos100"],[85600000,88300000,"q14.2","gneg"],[88300000,92800000,"q14.3","gpos100"],[92800000,97200000,"q21","gneg"],[97200000,102100000,"q22.1","gpos100"],[102100000,102900000,"q22.2","gneg"],[102900000,110400000,"q22.3","gpos100"],[110400000,112500000,"q23.1","gneg"],[112500000,114500000,"q23.2","gpos50"],[114500000,121200000,"q23.3","gneg"],[121200000,123900000,"q24.1","gpos50"],[123900000,127800000,"q24.2","gneg"],[127800000,130800000,"q24.3","gpos50"],[130800000,135006516,"q25","gneg"]],12:[[0,3300000,"p13.33","gneg"],[3300000,5400000,"p13.32","gpos25"],[5400000,10100000,"p13.31","gneg"],[10100000,12800000,"p13.2","gpos75"],[12800000,14800000,"p13.1","gneg"],[14800000,20000000,"p12.3","gpos100"],[20000000,21300000,"p12.2","gneg"],[21300000,26500000,"p12.1","gpos100"],[26500000,27800000,"p11.23","gneg"],[27800000,30700000,"p11.22","gpos50"],[30700000,33300000,"p11.21","gneg"],[33300000,35800000,"p11.1","acen"],[35800000,38200000,"q11","acen"],[38200000,46400000,"q12","gpos100"],[46400000,49100000,"q13.11","gneg"],[49100000,51500000,"q13.12","gpos25"],[51500000,54900000,"q13.13","gneg"],[54900000,56600000,"q13.2","gpos25"],[56600000,58100000,"q13.3","gneg"],[58100000,63100000,"q14.1","gpos75"],[63100000,65100000,"q14.2","gneg"],[65100000,67700000,"q14.3","gpos50"],[67700000,71500000,"q15","gneg"],[71500000,75700000,"q21.1","gpos75"],[75700000,80300000,"q21.2","gneg"],[80300000,86700000,"q21.31","gpos100"],[86700000,89000000,"q21.32","gneg"],[89000000,92600000,"q21.33","gpos100"],[92600000,96200000,"q22","gneg"],[96200000,101600000,"q23.1","gpos75"],[101600000,103800000,"q23.2","gneg"],[103800000,109000000,"q23.3","gpos50"],[109000000,111700000,"q24.11","gneg"],[111700000,112300000,"q24.12","gpos25"],[112300000,114300000,"q24.13","gneg"],[114300000,116800000,"q24.21","gpos50"],[116800000,118100000,"q24.22","gneg"],[118100000,120700000,"q24.23","gpos50"],[120700000,125900000,"q24.31","gneg"],[125900000,129300000,"q24.32","gpos50"],[129300000,133851895,"q24.33","gneg"]],13:[[0,4500000,"p13","gvar"],[4500000,10000000,"p12","stalk"],[10000000,16300000,"p11.2","gvar"],[16300000,17900000,"p11.1","acen"],[17900000,19500000,"q11","acen"],[19500000,23300000,"q12.11","gneg"],[23300000,25500000,"q12.12","gpos25"],[25500000,27800000,"q12.13","gneg"],[27800000,28900000,"q12.2","gpos25"],[28900000,32200000,"q12.3","gneg"],[32200000,34000000,"q13.1","gpos50"],[34000000,35500000,"q13.2","gneg"],[35500000,40100000,"q13.3","gpos75"],[40100000,45200000,"q14.11","gneg"],[45200000,45800000,"q14.12","gpos25"],[45800000,47300000,"q14.13","gneg"],[47300000,50900000,"q14.2","gpos50"],[50900000,55300000,"q14.3","gneg"],[55300000,59600000,"q21.1","gpos100"],[59600000,62300000,"q21.2","gneg"],[62300000,65700000,"q21.31","gpos75"],[65700000,68600000,"q21.32","gneg"],[68600000,73300000,"q21.33","gpos100"],[73300000,75400000,"q22.1","gneg"],[75400000,77200000,"q22.2","gpos50"],[77200000,79000000,"q22.3","gneg"],[79000000,87700000,"q31.1","gpos100"],[87700000,90000000,"q31.2","gneg"],[90000000,95000000,"q31.3","gpos100"],[95000000,98200000,"q32.1","gneg"],[98200000,99300000,"q32.2","gpos25"],[99300000,101700000,"q32.3","gneg"],[101700000,104800000,"q33.1","gpos100"],[104800000,107000000,"q33.2","gneg"],[107000000,110300000,"q33.3","gpos100"],[110300000,115169878,"q34","gneg"]],14:[[0,3700000,"p13","gvar"],[3700000,8100000,"p12","stalk"],[8100000,16100000,"p11.2","gvar"],[16100000,17600000,"p11.1","acen"],[17600000,19100000,"q11.1","acen"],[19100000,24600000,"q11.2","gneg"],[24600000,33300000,"q12","gpos100"],[33300000,35300000,"q13.1","gneg"],[35300000,36600000,"q13.2","gpos50"],[36600000,37800000,"q13.3","gneg"],[37800000,43500000,"q21.1","gpos100"],[43500000,47200000,"q21.2","gneg"],[47200000,50900000,"q21.3","gpos100"],[50900000,54100000,"q22.1","gneg"],[54100000,55500000,"q22.2","gpos25"],[55500000,58100000,"q22.3","gneg"],[58100000,62100000,"q23.1","gpos75"],[62100000,64800000,"q23.2","gneg"],[64800000,67900000,"q23.3","gpos50"],[67900000,70200000,"q24.1","gneg"],[70200000,73800000,"q24.2","gpos50"],[73800000,79300000,"q24.3","gneg"],[79300000,83600000,"q31.1","gpos100"],[83600000,84900000,"q31.2","gneg"],[84900000,89800000,"q31.3","gpos100"],[89800000,91900000,"q32.11","gneg"],[91900000,94700000,"q32.12","gpos25"],[94700000,96300000,"q32.13","gneg"],[96300000,101400000,"q32.2","gpos50"],[101400000,103200000,"q32.31","gneg"],[103200000,104000000,"q32.32","gpos50"],[104000000,107349540,"q32.33","gneg"]],15:[[0,3900000,"p13","gvar"],[3900000,8700000,"p12","stalk"],[8700000,15800000,"p11.2","gvar"],[15800000,19000000,"p11.1","acen"],[19000000,20700000,"q11.1","acen"],[20700000,25700000,"q11.2","gneg"],[25700000,28100000,"q12","gpos50"],[28100000,30300000,"q13.1","gneg"],[30300000,31200000,"q13.2","gpos50"],[31200000,33600000,"q13.3","gneg"],[33600000,40100000,"q14","gpos75"],[40100000,42800000,"q15.1","gneg"],[42800000,43600000,"q15.2","gpos25"],[43600000,44800000,"q15.3","gneg"],[44800000,49500000,"q21.1","gpos75"],[49500000,52900000,"q21.2","gneg"],[52900000,59100000,"q21.3","gpos75"],[59100000,59300000,"q22.1","gneg"],[59300000,63700000,"q22.2","gpos25"],[63700000,67200000,"q22.31","gneg"],[67200000,67300000,"q22.32","gpos25"],[67300000,67500000,"q22.33","gneg"],[67500000,72700000,"q23","gpos25"],[72700000,75200000,"q24.1","gneg"],[75200000,76600000,"q24.2","gpos25"],[76600000,78300000,"q24.3","gneg"],[78300000,81700000,"q25.1","gpos50"],[81700000,85200000,"q25.2","gneg"],[85200000,89100000,"q25.3","gpos50"],[89100000,94300000,"q26.1","gneg"],[94300000,98500000,"q26.2","gpos50"],[98500000,102531392,"q26.3","gneg"]],16:[[0,7900000,"p13.3","gneg"],[7900000,10500000,"p13.2","gpos50"],[10500000,12600000,"p13.13","gneg"],[12600000,14800000,"p13.12","gpos50"],[14800000,16800000,"p13.11","gneg"],[16800000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28100000,"p12.1","gpos50"],[28100000,34600000,"p11.2","gneg"],[34600000,36600000,"p11.1","acen"],[36600000,38600000,"q11.1","acen"],[38600000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56700000,"q12.2","gpos50"],[56700000,57400000,"q13","gneg"],[57400000,66700000,"q21","gpos100"],[66700000,70800000,"q22.1","gneg"],[70800000,72900000,"q22.2","gpos50"],[72900000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81700000,"q23.2","gneg"],[81700000,84200000,"q23.3","gpos50"],[84200000,87100000,"q24.1","gneg"],[87100000,88700000,"q24.2","gpos25"],[88700000,90354753,"q24.3","gneg"]],17:[[0,3300000,"p13.3","gneg"],[3300000,6500000,"p13.2","gpos50"],[6500000,10700000,"p13.1","gneg"],[10700000,16000000,"p12","gpos75"],[16000000,22200000,"p11.2","gneg"],[22200000,24000000,"p11.1","acen"],[24000000,25800000,"q11.1","acen"],[25800000,31800000,"q11.2","gneg"],[31800000,38100000,"q12","gpos50"],[38100000,38400000,"q21.1","gneg"],[38400000,40900000,"q21.2","gpos25"],[40900000,44900000,"q21.31","gneg"],[44900000,47400000,"q21.32","gpos25"],[47400000,50200000,"q21.33","gneg"],[50200000,57600000,"q22","gpos75"],[57600000,58300000,"q23.1","gneg"],[58300000,61100000,"q23.2","gpos75"],[61100000,62600000,"q23.3","gneg"],[62600000,64200000,"q24.1","gpos50"],[64200000,67100000,"q24.2","gneg"],[67100000,70900000,"q24.3","gpos75"],[70900000,74800000,"q25.1","gneg"],[74800000,75300000,"q25.2","gpos25"],[75300000,81195210,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7100000,"p11.31","gpos50"],[7100000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,17200000,"p11.1","acen"],[17200000,19000000,"q11.1","acen"],[19000000,25000000,"q11.2","gneg"],[25000000,32700000,"q12.1","gpos100"],[32700000,37200000,"q12.2","gneg"],[37200000,43500000,"q12.3","gpos75"],[43500000,48200000,"q21.1","gneg"],[48200000,53800000,"q21.2","gpos75"],[53800000,56200000,"q21.31","gneg"],[56200000,59000000,"q21.32","gpos50"],[59000000,61600000,"q21.33","gneg"],[61600000,66800000,"q22.1","gpos100"],[66800000,68700000,"q22.2","gneg"],[68700000,73100000,"q22.3","gpos25"],[73100000,78077248,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,13900000,"p13.2","gpos25"],[13900000,14000000,"p13.13","gneg"],[14000000,16300000,"p13.12","gpos25"],[16300000,20000000,"p13.11","gneg"],[20000000,24400000,"p12","gvar"],[24400000,26500000,"p11","acen"],[26500000,28600000,"q11","acen"],[28600000,32400000,"q12","gvar"],[32400000,35500000,"q13.11","gneg"],[35500000,38300000,"q13.12","gpos25"],[38300000,38700000,"q13.13","gneg"],[38700000,43400000,"q13.2","gpos25"],[43400000,45200000,"q13.31","gneg"],[45200000,48000000,"q13.32","gpos25"],[48000000,51400000,"q13.33","gneg"],[51400000,53600000,"q13.41","gpos25"],[53600000,56300000,"q13.42","gneg"],[56300000,59128983,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12100000,"p12.2","gneg"],[12100000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25600000,"p11.21","gneg"],[25600000,27500000,"p11.1","acen"],[27500000,29400000,"q11.1","acen"],[29400000,32100000,"q11.21","gneg"],[32100000,34400000,"q11.22","gpos25"],[34400000,37600000,"q11.23","gneg"],[37600000,41700000,"q12","gpos75"],[41700000,42100000,"q13.11","gneg"],[42100000,46400000,"q13.12","gpos25"],[46400000,49800000,"q13.13","gneg"],[49800000,55000000,"q13.2","gpos75"],[55000000,56500000,"q13.31","gneg"],[56500000,58400000,"q13.32","gpos50"],[58400000,63025520,"q13.33","gneg"]],21:[[0,2800000,"p13","gvar"],[2800000,6800000,"p12","stalk"],[6800000,10900000,"p11.2","gvar"],[10900000,13200000,"p11.1","acen"],[13200000,14300000,"q11.1","acen"],[14300000,16400000,"q11.2","gneg"],[16400000,24000000,"q21.1","gpos100"],[24000000,26800000,"q21.2","gneg"],[26800000,31500000,"q21.3","gpos75"],[31500000,35800000,"q22.11","gneg"],[35800000,37800000,"q22.12","gpos50"],[37800000,39700000,"q22.13","gneg"],[39700000,42600000,"q22.2","gpos50"],[42600000,48129895,"q22.3","gneg"]],22:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,12200000,"p11.2","gvar"],[12200000,14700000,"p11.1","acen"],[14700000,17900000,"q11.1","acen"],[17900000,22200000,"q11.21","gneg"],[22200000,23500000,"q11.22","gpos25"],[23500000,25900000,"q11.23","gneg"],[25900000,29600000,"q12.1","gpos50"],[29600000,32200000,"q12.2","gneg"],[32200000,37600000,"q12.3","gpos50"],[37600000,41000000,"q13.1","gneg"],[41000000,44200000,"q13.2","gpos50"],[44200000,48400000,"q13.31","gneg"],[48400000,49400000,"q13.32","gpos50"],[49400000,51304566,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19300000,"p22.13","gneg"],[19300000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37600000,"p21.1","gpos100"],[37600000,42400000,"p11.4","gneg"],[42400000,46400000,"p11.3","gpos75"],[46400000,49800000,"p11.23","gneg"],[49800000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,60600000,"p11.1","acen"],[60600000,63000000,"q11.1","acen"],[63000000,64600000,"q11.2","gneg"],[64600000,67800000,"q12","gpos50"],[67800000,71800000,"q13.1","gneg"],[71800000,73900000,"q13.2","gpos50"],[73900000,76000000,"q13.3","gneg"],[76000000,84600000,"q21.1","gpos100"],[84600000,86200000,"q21.2","gneg"],[86200000,91800000,"q21.31","gpos100"],[91800000,93500000,"q21.32","gneg"],[93500000,98300000,"q21.33","gpos75"],[98300000,102600000,"q22.1","gneg"],[102600000,103700000,"q22.2","gpos50"],[103700000,108700000,"q22.3","gneg"],[108700000,116500000,"q23","gpos75"],[116500000,120900000,"q24","gneg"],[120900000,128700000,"q25","gpos100"],[128700000,130400000,"q26.1","gneg"],[130400000,133600000,"q26.2","gpos25"],[133600000,138000000,"q26.3","gneg"],[138000000,140300000,"q27.1","gpos75"],[140300000,142100000,"q27.2","gneg"],[142100000,147100000,"q27.3","gpos100"],[147100000,155270560,"q28","gneg"]],Y:[[0,2500000,"p11.32","gneg"],[2500000,3000000,"p11.31","gpos50"],[3000000,11600000,"p11.2","gneg"],[11600000,12500000,"p11.1","acen"],[12500000,13400000,"q11.1","acen"],[13400000,15100000,"q11.21","gneg"],[15100000,19800000,"q11.221","gpos50"],[19800000,22100000,"q11.222","gneg"],[22100000,26200000,"q11.223","gpos50"],[26200000,28800000,"q11.23","gneg"],[28800000,59373566,"q12","gvar"]]}},hg38:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9100000,"p36.23","gpos25"],[9100000,12500000,"p36.22","gneg"],[12500000,15900000,"p36.21","gpos50"],[15900000,20100000,"p36.13","gneg"],[20100000,23600000,"p36.12","gpos25"],[23600000,27600000,"p36.11","gneg"],[27600000,29900000,"p35.3","gpos25"],[29900000,32300000,"p35.2","gneg"],[32300000,34300000,"p35.1","gpos25"],[34300000,39600000,"p34.3","gneg"],[39600000,43700000,"p34.2","gpos25"],[43700000,46300000,"p34.1","gneg"],[46300000,50200000,"p33","gpos75"],[50200000,55600000,"p32.3","gneg"],[55600000,58500000,"p32.2","gpos50"],[58500000,60800000,"p32.1","gneg"],[60800000,68500000,"p31.3","gpos50"],[68500000,69300000,"p31.2","gneg"],[69300000,84400000,"p31.1","gpos100"],[84400000,87900000,"p22.3","gneg"],[87900000,91500000,"p22.2","gpos75"],[91500000,94300000,"p22.1","gneg"],[94300000,99300000,"p21.3","gpos75"],[99300000,101800000,"p21.2","gneg"],[101800000,106700000,"p21.1","gpos100"],[106700000,111200000,"p13.3","gneg"],[111200000,115500000,"p13.2","gpos50"],[115500000,117200000,"p13.1","gneg"],[117200000,120400000,"p12","gpos50"],[120400000,121700000,"p11.2","gneg"],[121700000,123400000,"p11.1","acen"],[123400000,125100000,"q11","acen"],[125100000,143200000,"q12","gvar"],[143200000,147500000,"q21.1","gneg"],[147500000,150600000,"q21.2","gpos50"],[150600000,155100000,"q21.3","gneg"],[155100000,156600000,"q22","gpos50"],[156600000,159100000,"q23.1","gneg"],[159100000,160500000,"q23.2","gpos50"],[160500000,165500000,"q23.3","gneg"],[165500000,167200000,"q24.1","gpos50"],[167200000,170900000,"q24.2","gneg"],[170900000,173000000,"q24.3","gpos75"],[173000000,176100000,"q25.1","gneg"],[176100000,180300000,"q25.2","gpos50"],[180300000,185800000,"q25.3","gneg"],[185800000,190800000,"q31.1","gpos100"],[190800000,193800000,"q31.2","gneg"],[193800000,198700000,"q31.3","gpos100"],[198700000,207100000,"q32.1","gneg"],[207100000,211300000,"q32.2","gpos25"],[211300000,214400000,"q32.3","gneg"],[214400000,223900000,"q41","gpos100"],[223900000,224400000,"q42.11","gneg"],[224400000,226800000,"q42.12","gpos25"],[226800000,230500000,"q42.13","gneg"],[230500000,234600000,"q42.2","gpos50"],[234600000,236400000,"q42.3","gneg"],[236400000,243500000,"q43","gpos75"],[243500000,248956422,"q44","gneg"]],2:[[0,4400000,"p25.3","gneg"],[4400000,6900000,"p25.2","gpos50"],[6900000,12000000,"p25.1","gneg"],[12000000,16500000,"p24.3","gpos75"],[16500000,19000000,"p24.2","gneg"],[19000000,23800000,"p24.1","gpos75"],[23800000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31800000,"p23.1","gneg"],[31800000,36300000,"p22.3","gpos75"],[36300000,38300000,"p22.2","gneg"],[38300000,41500000,"p22.1","gpos50"],[41500000,47500000,"p21","gneg"],[47500000,52600000,"p16.3","gpos100"],[52600000,54700000,"p16.2","gneg"],[54700000,61000000,"p16.1","gpos100"],[61000000,63900000,"p15","gneg"],[63900000,68400000,"p14","gpos50"],[68400000,71300000,"p13.3","gneg"],[71300000,73300000,"p13.2","gpos50"],[73300000,74800000,"p13.1","gneg"],[74800000,83100000,"p12","gpos100"],[83100000,91800000,"p11.2","gneg"],[91800000,93900000,"p11.1","acen"],[93900000,96000000,"q11.1","acen"],[96000000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108700000,"q12.3","gpos25"],[108700000,112200000,"q13","gneg"],[112200000,118100000,"q14.1","gpos50"],[118100000,121600000,"q14.2","gneg"],[121600000,129100000,"q14.3","gpos50"],[129100000,131700000,"q21.1","gneg"],[131700000,134300000,"q21.2","gpos25"],[134300000,136100000,"q21.3","gneg"],[136100000,141500000,"q22.1","gpos100"],[141500000,143400000,"q22.2","gneg"],[143400000,147900000,"q22.3","gpos100"],[147900000,149000000,"q23.1","gneg"],[149000000,149600000,"q23.2","gpos25"],[149600000,154000000,"q23.3","gneg"],[154000000,158900000,"q24.1","gpos75"],[158900000,162900000,"q24.2","gneg"],[162900000,168900000,"q24.3","gpos75"],[168900000,177100000,"q31.1","gneg"],[177100000,179700000,"q31.2","gpos50"],[179700000,182100000,"q31.3","gneg"],[182100000,188500000,"q32.1","gpos75"],[188500000,191100000,"q32.2","gneg"],[191100000,196600000,"q32.3","gpos75"],[196600000,202500000,"q33.1","gneg"],[202500000,204100000,"q33.2","gpos50"],[204100000,208200000,"q33.3","gneg"],[208200000,214500000,"q34","gpos100"],[214500000,220700000,"q35","gneg"],[220700000,224300000,"q36.1","gpos75"],[224300000,225200000,"q36.2","gneg"],[225200000,230100000,"q36.3","gpos100"],[230100000,234700000,"q37.1","gneg"],[234700000,236400000,"q37.2","gpos50"],[236400000,242193529,"q37.3","gneg"]],3:[[0,2800000,"p26.3","gpos50"],[2800000,4000000,"p26.2","gneg"],[4000000,8100000,"p26.1","gpos50"],[8100000,11600000,"p25.3","gneg"],[11600000,13200000,"p25.2","gpos25"],[13200000,16300000,"p25.1","gneg"],[16300000,23800000,"p24.3","gpos100"],[23800000,26300000,"p24.2","gneg"],[26300000,30800000,"p24.1","gpos75"],[30800000,32000000,"p23","gneg"],[32000000,36400000,"p22.3","gpos50"],[36400000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44100000,"p21.33","gneg"],[44100000,44200000,"p21.32","gpos50"],[44200000,50600000,"p21.31","gneg"],[50600000,52300000,"p21.2","gpos25"],[52300000,54400000,"p21.1","gneg"],[54400000,58600000,"p14.3","gpos50"],[58600000,63800000,"p14.2","gneg"],[63800000,69700000,"p14.1","gpos50"],[69700000,74100000,"p13","gneg"],[74100000,79800000,"p12.3","gpos75"],[79800000,83500000,"p12.2","gneg"],[83500000,87100000,"p12.1","gpos75"],[87100000,87800000,"p11.2","gneg"],[87800000,90900000,"p11.1","acen"],[90900000,94000000,"q11.1","acen"],[94000000,98600000,"q11.2","gvar"],[98600000,100300000,"q12.1","gneg"],[100300000,101200000,"q12.2","gpos25"],[101200000,103100000,"q12.3","gneg"],[103100000,106500000,"q13.11","gpos75"],[106500000,108200000,"q13.12","gneg"],[108200000,111600000,"q13.13","gpos50"],[111600000,113700000,"q13.2","gneg"],[113700000,117600000,"q13.31","gpos75"],[117600000,119300000,"q13.32","gneg"],[119300000,122200000,"q13.33","gpos75"],[122200000,124100000,"q21.1","gneg"],[124100000,126100000,"q21.2","gpos25"],[126100000,129500000,"q21.3","gneg"],[129500000,134000000,"q22.1","gpos25"],[134000000,136000000,"q22.2","gneg"],[136000000,139000000,"q22.3","gpos25"],[139000000,143100000,"q23","gneg"],[143100000,149200000,"q24","gpos100"],[149200000,152300000,"q25.1","gneg"],[152300000,155300000,"q25.2","gpos50"],[155300000,157300000,"q25.31","gneg"],[157300000,159300000,"q25.32","gpos50"],[159300000,161000000,"q25.33","gneg"],[161000000,167900000,"q26.1","gpos100"],[167900000,171200000,"q26.2","gneg"],[171200000,176000000,"q26.31","gpos75"],[176000000,179300000,"q26.32","gneg"],[179300000,183000000,"q26.33","gpos75"],[183000000,184800000,"q27.1","gneg"],[184800000,186300000,"q27.2","gpos25"],[186300000,188200000,"q27.3","gneg"],[188200000,192600000,"q28","gpos75"],[192600000,198295559,"q29","gneg"]],4:[[0,4500000,"p16.3","gneg"],[4500000,6000000,"p16.2","gpos25"],[6000000,11300000,"p16.1","gneg"],[11300000,15000000,"p15.33","gpos50"],[15000000,17700000,"p15.32","gneg"],[17700000,21300000,"p15.31","gpos75"],[21300000,27700000,"p15.2","gneg"],[27700000,35800000,"p15.1","gpos100"],[35800000,41200000,"p14","gneg"],[41200000,44600000,"p13","gpos50"],[44600000,48200000,"p12","gneg"],[48200000,50000000,"p11","acen"],[50000000,51800000,"q11","acen"],[51800000,58500000,"q12","gneg"],[58500000,65500000,"q13.1","gpos100"],[65500000,69400000,"q13.2","gneg"],[69400000,75300000,"q13.3","gpos75"],[75300000,78000000,"q21.1","gneg"],[78000000,81500000,"q21.21","gpos50"],[81500000,83200000,"q21.22","gneg"],[83200000,86000000,"q21.23","gpos25"],[86000000,87100000,"q21.3","gneg"],[87100000,92800000,"q22.1","gpos75"],[92800000,94200000,"q22.2","gneg"],[94200000,97900000,"q22.3","gpos75"],[97900000,100100000,"q23","gneg"],[100100000,106700000,"q24","gpos50"],[106700000,113200000,"q25","gneg"],[113200000,119900000,"q26","gpos75"],[119900000,122800000,"q27","gneg"],[122800000,127900000,"q28.1","gpos50"],[127900000,130100000,"q28.2","gneg"],[130100000,138500000,"q28.3","gpos100"],[138500000,140600000,"q31.1","gneg"],[140600000,145900000,"q31.21","gpos25"],[145900000,147500000,"q31.22","gneg"],[147500000,150200000,"q31.23","gpos25"],[150200000,154600000,"q31.3","gneg"],[154600000,160800000,"q32.1","gpos100"],[160800000,163600000,"q32.2","gneg"],[163600000,169200000,"q32.3","gpos100"],[169200000,171000000,"q33","gneg"],[171000000,175400000,"q34.1","gpos75"],[175400000,176600000,"q34.2","gneg"],[176600000,182300000,"q34.3","gpos100"],[182300000,186200000,"q35.1","gneg"],[186200000,190214555,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6300000,"p15.32","gpos25"],[6300000,9900000,"p15.31","gneg"],[9900000,15000000,"p15.2","gpos50"],[15000000,18400000,"p15.1","gneg"],[18400000,23300000,"p14.3","gpos100"],[23300000,24600000,"p14.2","gneg"],[24600000,28900000,"p14.1","gpos100"],[28900000,33800000,"p13.3","gneg"],[33800000,38400000,"p13.2","gpos25"],[38400000,42500000,"p13.1","gneg"],[42500000,46100000,"p12","gpos50"],[46100000,48800000,"p11","acen"],[48800000,51400000,"q11.1","acen"],[51400000,59600000,"q11.2","gneg"],[59600000,63600000,"q12.1","gpos75"],[63600000,63900000,"q12.2","gneg"],[63900000,67400000,"q12.3","gpos75"],[67400000,69100000,"q13.1","gneg"],[69100000,74000000,"q13.2","gpos50"],[74000000,77600000,"q13.3","gneg"],[77600000,82100000,"q14.1","gpos50"],[82100000,83500000,"q14.2","gneg"],[83500000,93000000,"q14.3","gpos100"],[93000000,98900000,"q15","gneg"],[98900000,103400000,"q21.1","gpos100"],[103400000,105100000,"q21.2","gneg"],[105100000,110200000,"q21.3","gpos100"],[110200000,112200000,"q22.1","gneg"],[112200000,113800000,"q22.2","gpos50"],[113800000,115900000,"q22.3","gneg"],[115900000,122100000,"q23.1","gpos100"],[122100000,127900000,"q23.2","gneg"],[127900000,131200000,"q23.3","gpos100"],[131200000,136900000,"q31.1","gneg"],[136900000,140100000,"q31.2","gpos25"],[140100000,145100000,"q31.3","gneg"],[145100000,150400000,"q32","gpos75"],[150400000,153300000,"q33.1","gneg"],[153300000,156300000,"q33.2","gpos50"],[156300000,160500000,"q33.3","gneg"],[160500000,169000000,"q34","gpos100"],[169000000,173300000,"q35.1","gneg"],[173300000,177100000,"q35.2","gpos25"],[177100000,181538259,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4200000,"p25.2","gpos25"],[4200000,7100000,"p25.1","gneg"],[7100000,10600000,"p24.3","gpos50"],[10600000,11600000,"p24.2","gneg"],[11600000,13400000,"p24.1","gpos25"],[13400000,15200000,"p23","gneg"],[15200000,25200000,"p22.3","gpos75"],[25200000,27100000,"p22.2","gneg"],[27100000,30500000,"p22.1","gpos50"],[30500000,32100000,"p21.33","gneg"],[32100000,33500000,"p21.32","gpos25"],[33500000,36600000,"p21.31","gneg"],[36600000,40500000,"p21.2","gpos25"],[40500000,46200000,"p21.1","gneg"],[46200000,51800000,"p12.3","gpos100"],[51800000,53000000,"p12.2","gneg"],[53000000,57200000,"p12.1","gpos100"],[57200000,58500000,"p11.2","gneg"],[58500000,59800000,"p11.1","acen"],[59800000,62600000,"q11.1","acen"],[62600000,62700000,"q11.2","gneg"],[62700000,69200000,"q12","gpos100"],[69200000,75200000,"q13","gneg"],[75200000,83200000,"q14.1","gpos50"],[83200000,84200000,"q14.2","gneg"],[84200000,87300000,"q14.3","gpos50"],[87300000,92500000,"q15","gneg"],[92500000,98900000,"q16.1","gpos100"],[98900000,100000000,"q16.2","gneg"],[100000000,105000000,"q16.3","gpos100"],[105000000,114200000,"q21","gneg"],[114200000,117900000,"q22.1","gpos75"],[117900000,118100000,"q22.2","gneg"],[118100000,125800000,"q22.31","gpos100"],[125800000,126800000,"q22.32","gneg"],[126800000,130000000,"q22.33","gpos75"],[130000000,130900000,"q23.1","gneg"],[130900000,134700000,"q23.2","gpos50"],[134700000,138300000,"q23.3","gneg"],[138300000,142200000,"q24.1","gpos75"],[142200000,145100000,"q24.2","gneg"],[145100000,148500000,"q24.3","gpos75"],[148500000,152100000,"q25.1","gneg"],[152100000,155200000,"q25.2","gpos50"],[155200000,160600000,"q25.3","gneg"],[160600000,164100000,"q26","gpos50"],[164100000,170805979,"q27","gneg"]],7:[[0,2800000,"p22.3","gneg"],[2800000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13700000,"p21.3","gpos100"],[13700000,16500000,"p21.2","gneg"],[16500000,20900000,"p21.1","gpos100"],[20900000,25500000,"p15.3","gneg"],[25500000,27900000,"p15.2","gpos50"],[27900000,28800000,"p15.1","gneg"],[28800000,34900000,"p14.3","gpos75"],[34900000,37100000,"p14.2","gneg"],[37100000,43300000,"p14.1","gpos75"],[43300000,45400000,"p13","gneg"],[45400000,49000000,"p12.3","gpos75"],[49000000,50500000,"p12.2","gneg"],[50500000,53900000,"p12.1","gpos75"],[53900000,58100000,"p11.2","gneg"],[58100000,60100000,"p11.1","acen"],[60100000,62100000,"q11.1","acen"],[62100000,67500000,"q11.21","gneg"],[67500000,72700000,"q11.22","gpos50"],[72700000,77900000,"q11.23","gneg"],[77900000,86700000,"q21.11","gpos100"],[86700000,88500000,"q21.12","gneg"],[88500000,91500000,"q21.13","gpos75"],[91500000,93300000,"q21.2","gneg"],[93300000,98400000,"q21.3","gpos75"],[98400000,104200000,"q22.1","gneg"],[104200000,104900000,"q22.2","gpos50"],[104900000,107800000,"q22.3","gneg"],[107800000,115000000,"q31.1","gpos75"],[115000000,117700000,"q31.2","gneg"],[117700000,121400000,"q31.31","gpos75"],[121400000,124100000,"q31.32","gneg"],[124100000,127500000,"q31.33","gpos75"],[127500000,129600000,"q32.1","gneg"],[129600000,130800000,"q32.2","gpos25"],[130800000,132900000,"q32.3","gneg"],[132900000,138500000,"q33","gpos50"],[138500000,143400000,"q34","gneg"],[143400000,148200000,"q35","gpos75"],[148200000,152800000,"q36.1","gneg"],[152800000,155200000,"q36.2","gpos25"],[155200000,159345973,"q36.3","gneg"]],8:[[0,2300000,"p23.3","gneg"],[2300000,6300000,"p23.2","gpos75"],[6300000,12800000,"p23.1","gneg"],[12800000,19200000,"p22","gpos100"],[19200000,23500000,"p21.3","gneg"],[23500000,27500000,"p21.2","gpos50"],[27500000,29000000,"p21.1","gneg"],[29000000,36700000,"p12","gpos75"],[36700000,38500000,"p11.23","gneg"],[38500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,47200000,"q11.1","acen"],[47200000,51300000,"q11.21","gneg"],[51300000,51700000,"q11.22","gpos75"],[51700000,54600000,"q11.23","gneg"],[54600000,60600000,"q12.1","gpos50"],[60600000,61300000,"q12.2","gneg"],[61300000,65100000,"q12.3","gpos50"],[65100000,67100000,"q13.1","gneg"],[67100000,69600000,"q13.2","gpos50"],[69600000,72000000,"q13.3","gneg"],[72000000,74600000,"q21.11","gpos100"],[74600000,74700000,"q21.12","gneg"],[74700000,83500000,"q21.13","gpos75"],[83500000,85900000,"q21.2","gneg"],[85900000,92300000,"q21.3","gpos100"],[92300000,97900000,"q22.1","gneg"],[97900000,100500000,"q22.2","gpos25"],[100500000,105100000,"q22.3","gneg"],[105100000,109500000,"q23.1","gpos75"],[109500000,111100000,"q23.2","gneg"],[111100000,116700000,"q23.3","gpos100"],[116700000,118300000,"q24.11","gneg"],[118300000,121500000,"q24.12","gpos50"],[121500000,126300000,"q24.13","gneg"],[126300000,130400000,"q24.21","gpos50"],[130400000,135400000,"q24.22","gneg"],[135400000,138900000,"q24.23","gpos75"],[138900000,145138636,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14200000,"p23","gpos75"],[14200000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25600000,"p21.3","gpos100"],[25600000,28000000,"p21.2","gneg"],[28000000,33200000,"p21.1","gpos100"],[33200000,36300000,"p13.3","gneg"],[36300000,37900000,"p13.2","gpos25"],[37900000,39000000,"p13.1","gneg"],[39000000,40000000,"p12","gpos50"],[40000000,42200000,"p11.2","gneg"],[42200000,43000000,"p11.1","acen"],[43000000,45500000,"q11","acen"],[45500000,61500000,"q12","gvar"],[61500000,65000000,"q13","gneg"],[65000000,69300000,"q21.11","gpos25"],[69300000,71300000,"q21.12","gneg"],[71300000,76600000,"q21.13","gpos50"],[76600000,78500000,"q21.2","gneg"],[78500000,81500000,"q21.31","gpos50"],[81500000,84300000,"q21.32","gneg"],[84300000,87800000,"q21.33","gpos50"],[87800000,89200000,"q22.1","gneg"],[89200000,91200000,"q22.2","gpos25"],[91200000,93900000,"q22.31","gneg"],[93900000,96500000,"q22.32","gpos25"],[96500000,99800000,"q22.33","gneg"],[99800000,105400000,"q31.1","gpos100"],[105400000,108500000,"q31.2","gneg"],[108500000,112100000,"q31.3","gpos25"],[112100000,114900000,"q32","gneg"],[114900000,119800000,"q33.1","gpos75"],[119800000,123100000,"q33.2","gneg"],[123100000,127500000,"q33.3","gpos25"],[127500000,130600000,"q34.11","gneg"],[130600000,131100000,"q34.12","gpos25"],[131100000,133100000,"q34.13","gneg"],[133100000,134500000,"q34.2","gpos25"],[134500000,138394717,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6600000,"p15.1","gneg"],[6600000,12200000,"p14","gpos75"],[12200000,17300000,"p13","gneg"],[17300000,18300000,"p12.33","gpos75"],[18300000,18400000,"p12.32","gneg"],[18400000,22300000,"p12.31","gpos75"],[22300000,24300000,"p12.2","gneg"],[24300000,29300000,"p12.1","gpos50"],[29300000,31100000,"p11.23","gneg"],[31100000,34200000,"p11.22","gpos25"],[34200000,38000000,"p11.21","gneg"],[38000000,39800000,"p11.1","acen"],[39800000,41600000,"q11.1","acen"],[41600000,45500000,"q11.21","gneg"],[45500000,48600000,"q11.22","gpos25"],[48600000,51100000,"q11.23","gneg"],[51100000,59400000,"q21.1","gpos100"],[59400000,62800000,"q21.2","gneg"],[62800000,68800000,"q21.3","gpos100"],[68800000,73100000,"q22.1","gneg"],[73100000,75900000,"q22.2","gpos50"],[75900000,80300000,"q22.3","gneg"],[80300000,86100000,"q23.1","gpos100"],[86100000,87700000,"q23.2","gneg"],[87700000,91100000,"q23.31","gpos75"],[91100000,92300000,"q23.32","gneg"],[92300000,95300000,"q23.33","gpos50"],[95300000,97500000,"q24.1","gneg"],[97500000,100100000,"q24.2","gpos50"],[100100000,101200000,"q24.31","gneg"],[101200000,103100000,"q24.32","gpos25"],[103100000,104000000,"q24.33","gneg"],[104000000,110100000,"q25.1","gpos100"],[110100000,113100000,"q25.2","gneg"],[113100000,117300000,"q25.3","gpos75"],[117300000,119900000,"q26.11","gneg"],[119900000,121400000,"q26.12","gpos50"],[121400000,125700000,"q26.13","gneg"],[125700000,128800000,"q26.2","gpos50"],[128800000,133797422,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,11700000,"p15.4","gpos50"],[11700000,13800000,"p15.3","gneg"],[13800000,16900000,"p15.2","gpos50"],[16900000,22000000,"p15.1","gneg"],[22000000,26200000,"p14.3","gpos100"],[26200000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51000000,"p11.12","gpos75"],[51000000,53400000,"p11.11","acen"],[53400000,55800000,"q11","acen"],[55800000,60100000,"q12.1","gpos75"],[60100000,61900000,"q12.2","gneg"],[61900000,63600000,"q12.3","gpos25"],[63600000,66100000,"q13.1","gneg"],[66100000,68700000,"q13.2","gpos25"],[68700000,70500000,"q13.3","gneg"],[70500000,75500000,"q13.4","gpos50"],[75500000,77400000,"q13.5","gneg"],[77400000,85900000,"q14.1","gpos100"],[85900000,88600000,"q14.2","gneg"],[88600000,93000000,"q14.3","gpos100"],[93000000,97400000,"q21","gneg"],[97400000,102300000,"q22.1","gpos100"],[102300000,103000000,"q22.2","gneg"],[103000000,110600000,"q22.3","gpos100"],[110600000,112700000,"q23.1","gneg"],[112700000,114600000,"q23.2","gpos50"],[114600000,121300000,"q23.3","gneg"],[121300000,124000000,"q24.1","gpos50"],[124000000,127900000,"q24.2","gneg"],[127900000,130900000,"q24.3","gpos50"],[130900000,135086622,"q25","gneg"]],12:[[0,3200000,"p13.33","gneg"],[3200000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14600000,"p13.1","gneg"],[14600000,19800000,"p12.3","gpos100"],[19800000,21100000,"p12.2","gneg"],[21100000,26300000,"p12.1","gpos100"],[26300000,27600000,"p11.23","gneg"],[27600000,30500000,"p11.22","gpos50"],[30500000,33200000,"p11.21","gneg"],[33200000,35500000,"p11.1","acen"],[35500000,37800000,"q11","acen"],[37800000,46000000,"q12","gpos100"],[46000000,48700000,"q13.11","gneg"],[48700000,51100000,"q13.12","gpos25"],[51100000,54500000,"q13.13","gneg"],[54500000,56200000,"q13.2","gpos25"],[56200000,57700000,"q13.3","gneg"],[57700000,62700000,"q14.1","gpos75"],[62700000,64700000,"q14.2","gneg"],[64700000,67300000,"q14.3","gpos50"],[67300000,71100000,"q15","gneg"],[71100000,75300000,"q21.1","gpos75"],[75300000,79900000,"q21.2","gneg"],[79900000,86300000,"q21.31","gpos100"],[86300000,88600000,"q21.32","gneg"],[88600000,92200000,"q21.33","gpos100"],[92200000,95800000,"q22","gneg"],[95800000,101200000,"q23.1","gpos75"],[101200000,103500000,"q23.2","gneg"],[103500000,108600000,"q23.3","gpos50"],[108600000,111300000,"q24.11","gneg"],[111300000,111900000,"q24.12","gpos25"],[111900000,113900000,"q24.13","gneg"],[113900000,116400000,"q24.21","gpos50"],[116400000,117700000,"q24.22","gneg"],[117700000,120300000,"q24.23","gpos50"],[120300000,125400000,"q24.31","gneg"],[125400000,128700000,"q24.32","gpos50"],[128700000,133275309,"q24.33","gneg"]],13:[[0,4600000,"p13","gvar"],[4600000,10100000,"p12","stalk"],[10100000,16500000,"p11.2","gvar"],[16500000,17700000,"p11.1","acen"],[17700000,18900000,"q11","acen"],[18900000,22600000,"q12.11","gneg"],[22600000,24900000,"q12.12","gpos25"],[24900000,27200000,"q12.13","gneg"],[27200000,28300000,"q12.2","gpos25"],[28300000,31600000,"q12.3","gneg"],[31600000,33400000,"q13.1","gpos50"],[33400000,34900000,"q13.2","gneg"],[34900000,39500000,"q13.3","gpos75"],[39500000,44600000,"q14.11","gneg"],[44600000,45200000,"q14.12","gpos25"],[45200000,46700000,"q14.13","gneg"],[46700000,50300000,"q14.2","gpos50"],[50300000,54700000,"q14.3","gneg"],[54700000,59000000,"q21.1","gpos100"],[59000000,61800000,"q21.2","gneg"],[61800000,65200000,"q21.31","gpos75"],[65200000,68100000,"q21.32","gneg"],[68100000,72800000,"q21.33","gpos100"],[72800000,74900000,"q22.1","gneg"],[74900000,76700000,"q22.2","gpos50"],[76700000,78500000,"q22.3","gneg"],[78500000,87100000,"q31.1","gpos100"],[87100000,89400000,"q31.2","gneg"],[89400000,94400000,"q31.3","gpos100"],[94400000,97500000,"q32.1","gneg"],[97500000,98700000,"q32.2","gpos25"],[98700000,101100000,"q32.3","gneg"],[101100000,104200000,"q33.1","gpos100"],[104200000,106400000,"q33.2","gneg"],[106400000,109600000,"q33.3","gpos100"],[109600000,114364328,"q34","gneg"]],14:[[0,3600000,"p13","gvar"],[3600000,8000000,"p12","stalk"],[8000000,16100000,"p11.2","gvar"],[16100000,17200000,"p11.1","acen"],[17200000,18200000,"q11.1","acen"],[18200000,24100000,"q11.2","gneg"],[24100000,32900000,"q12","gpos100"],[32900000,34800000,"q13.1","gneg"],[34800000,36100000,"q13.2","gpos50"],[36100000,37400000,"q13.3","gneg"],[37400000,43000000,"q21.1","gpos100"],[43000000,46700000,"q21.2","gneg"],[46700000,50400000,"q21.3","gpos100"],[50400000,53600000,"q22.1","gneg"],[53600000,55000000,"q22.2","gpos25"],[55000000,57600000,"q22.3","gneg"],[57600000,61600000,"q23.1","gpos75"],[61600000,64300000,"q23.2","gneg"],[64300000,67400000,"q23.3","gpos50"],[67400000,69800000,"q24.1","gneg"],[69800000,73300000,"q24.2","gpos50"],[73300000,78800000,"q24.3","gneg"],[78800000,83100000,"q31.1","gpos100"],[83100000,84400000,"q31.2","gneg"],[84400000,89300000,"q31.3","gpos100"],[89300000,91400000,"q32.11","gneg"],[91400000,94200000,"q32.12","gpos25"],[94200000,95800000,"q32.13","gneg"],[95800000,100900000,"q32.2","gpos50"],[100900000,102700000,"q32.31","gneg"],[102700000,103500000,"q32.32","gpos50"],[103500000,107043718,"q32.33","gneg"]],15:[[0,4200000,"p13","gvar"],[4200000,9700000,"p12","stalk"],[9700000,17500000,"p11.2","gvar"],[17500000,19000000,"p11.1","acen"],[19000000,20500000,"q11.1","acen"],[20500000,25500000,"q11.2","gneg"],[25500000,27800000,"q12","gpos50"],[27800000,30000000,"q13.1","gneg"],[30000000,30900000,"q13.2","gpos50"],[30900000,33400000,"q13.3","gneg"],[33400000,39800000,"q14","gpos75"],[39800000,42500000,"q15.1","gneg"],[42500000,43300000,"q15.2","gpos25"],[43300000,44500000,"q15.3","gneg"],[44500000,49200000,"q21.1","gpos75"],[49200000,52600000,"q21.2","gneg"],[52600000,58800000,"q21.3","gpos75"],[58800000,59000000,"q22.1","gneg"],[59000000,63400000,"q22.2","gpos25"],[63400000,66900000,"q22.31","gneg"],[66900000,67000000,"q22.32","gpos25"],[67000000,67200000,"q22.33","gneg"],[67200000,72400000,"q23","gpos25"],[72400000,74900000,"q24.1","gneg"],[74900000,76300000,"q24.2","gpos25"],[76300000,78000000,"q24.3","gneg"],[78000000,81400000,"q25.1","gpos50"],[81400000,84700000,"q25.2","gneg"],[84700000,88500000,"q25.3","gpos50"],[88500000,93800000,"q26.1","gneg"],[93800000,98000000,"q26.2","gpos50"],[98000000,101991189,"q26.3","gneg"]],16:[[0,7800000,"p13.3","gneg"],[7800000,10400000,"p13.2","gpos50"],[10400000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,21200000,"p12.3","gpos50"],[21200000,24200000,"p12.2","gneg"],[24200000,28500000,"p12.1","gpos50"],[28500000,35300000,"p11.2","gneg"],[35300000,36800000,"p11.1","acen"],[36800000,38400000,"q11.1","acen"],[38400000,47000000,"q11.2","gvar"],[47000000,52600000,"q12.1","gneg"],[52600000,56000000,"q12.2","gpos50"],[56000000,57300000,"q13","gneg"],[57300000,66600000,"q21","gpos100"],[66600000,70800000,"q22.1","gneg"],[70800000,72800000,"q22.2","gpos50"],[72800000,74100000,"q22.3","gneg"],[74100000,79200000,"q23.1","gpos75"],[79200000,81600000,"q23.2","gneg"],[81600000,84100000,"q23.3","gpos50"],[84100000,87000000,"q24.1","gneg"],[87000000,88700000,"q24.2","gpos25"],[88700000,90338345,"q24.3","gneg"]],17:[[0,3400000,"p13.3","gneg"],[3400000,6500000,"p13.2","gpos50"],[6500000,10800000,"p13.1","gneg"],[10800000,16100000,"p12","gpos75"],[16100000,22700000,"p11.2","gneg"],[22700000,25100000,"p11.1","acen"],[25100000,27400000,"q11.1","acen"],[27400000,33500000,"q11.2","gneg"],[33500000,39800000,"q12","gpos50"],[39800000,40200000,"q21.1","gneg"],[40200000,42800000,"q21.2","gpos25"],[42800000,46800000,"q21.31","gneg"],[46800000,49300000,"q21.32","gpos25"],[49300000,52100000,"q21.33","gneg"],[52100000,59500000,"q22","gpos75"],[59500000,60200000,"q23.1","gneg"],[60200000,63100000,"q23.2","gpos75"],[63100000,64600000,"q23.3","gneg"],[64600000,66200000,"q24.1","gpos50"],[66200000,69100000,"q24.2","gneg"],[69100000,72900000,"q24.3","gpos75"],[72900000,76800000,"q25.1","gneg"],[76800000,77200000,"q25.2","gpos25"],[77200000,83257441,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,18500000,"p11.1","acen"],[18500000,21500000,"q11.1","acen"],[21500000,27500000,"q11.2","gneg"],[27500000,35100000,"q12.1","gpos100"],[35100000,39500000,"q12.2","gneg"],[39500000,45900000,"q12.3","gpos75"],[45900000,50700000,"q21.1","gneg"],[50700000,56200000,"q21.2","gpos75"],[56200000,58600000,"q21.31","gneg"],[58600000,61300000,"q21.32","gpos50"],[61300000,63900000,"q21.33","gneg"],[63900000,69100000,"q22.1","gpos100"],[69100000,71000000,"q22.2","gneg"],[71000000,75400000,"q22.3","gpos25"],[75400000,80373285,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19900000,"p13.11","gneg"],[19900000,24200000,"p12","gvar"],[24200000,26200000,"p11","acen"],[26200000,28100000,"q11","acen"],[28100000,31900000,"q12","gvar"],[31900000,35100000,"q13.11","gneg"],[35100000,37800000,"q13.12","gpos25"],[37800000,38200000,"q13.13","gneg"],[38200000,42900000,"q13.2","gpos25"],[42900000,44700000,"q13.31","gneg"],[44700000,47500000,"q13.32","gpos25"],[47500000,50900000,"q13.33","gneg"],[50900000,53100000,"q13.41","gpos25"],[53100000,55800000,"q13.42","gneg"],[55800000,58617616,"q13.43","gpos25"]],20:[[0,5100000,"p13","gneg"],[5100000,9200000,"p12.3","gpos75"],[9200000,12000000,"p12.2","gneg"],[12000000,17900000,"p12.1","gpos75"],[17900000,21300000,"p11.23","gneg"],[21300000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,28100000,"p11.1","acen"],[28100000,30400000,"q11.1","acen"],[30400000,33500000,"q11.21","gneg"],[33500000,35800000,"q11.22","gpos25"],[35800000,39000000,"q11.23","gneg"],[39000000,43100000,"q12","gpos75"],[43100000,43500000,"q13.11","gneg"],[43500000,47800000,"q13.12","gpos25"],[47800000,51200000,"q13.13","gneg"],[51200000,56400000,"q13.2","gpos75"],[56400000,57800000,"q13.31","gneg"],[57800000,59700000,"q13.32","gpos50"],[59700000,64444167,"q13.33","gneg"]],21:[[0,3100000,"p13","gvar"],[3100000,7000000,"p12","stalk"],[7000000,10900000,"p11.2","gvar"],[10900000,12000000,"p11.1","acen"],[12000000,13000000,"q11.1","acen"],[13000000,15000000,"q11.2","gneg"],[15000000,22600000,"q21.1","gpos100"],[22600000,25500000,"q21.2","gneg"],[25500000,30200000,"q21.3","gpos75"],[30200000,34400000,"q22.11","gneg"],[34400000,36400000,"q22.12","gpos50"],[36400000,38300000,"q22.13","gneg"],[38300000,41200000,"q22.2","gpos50"],[41200000,46709983,"q22.3","gneg"]],22:[[0,4300000,"p13","gvar"],[4300000,9400000,"p12","stalk"],[9400000,13700000,"p11.2","gvar"],[13700000,15000000,"p11.1","acen"],[15000000,17400000,"q11.1","acen"],[17400000,21700000,"q11.21","gneg"],[21700000,23100000,"q11.22","gpos25"],[23100000,25500000,"q11.23","gneg"],[25500000,29200000,"q12.1","gpos50"],[29200000,31800000,"q12.2","gneg"],[31800000,37200000,"q12.3","gpos50"],[37200000,40600000,"q13.1","gneg"],[40600000,43800000,"q13.2","gpos50"],[43800000,48100000,"q13.31","gneg"],[48100000,49100000,"q13.32","gpos50"],[49100000,50818468,"q13.33","gneg"]],X:[[0,4400000,"p22.33","gneg"],[4400000,6100000,"p22.32","gpos50"],[6100000,9600000,"p22.31","gneg"],[9600000,17400000,"p22.2","gpos50"],[17400000,19200000,"p22.13","gneg"],[19200000,21900000,"p22.12","gpos50"],[21900000,24900000,"p22.11","gneg"],[24900000,29300000,"p21.3","gpos100"],[29300000,31500000,"p21.2","gneg"],[31500000,37800000,"p21.1","gpos100"],[37800000,42500000,"p11.4","gneg"],[42500000,47600000,"p11.3","gpos75"],[47600000,50100000,"p11.23","gneg"],[50100000,54800000,"p11.22","gpos25"],[54800000,58100000,"p11.21","gneg"],[58100000,61000000,"p11.1","acen"],[61000000,63800000,"q11.1","acen"],[63800000,65400000,"q11.2","gneg"],[65400000,68500000,"q12","gpos50"],[68500000,73000000,"q13.1","gneg"],[73000000,74700000,"q13.2","gpos50"],[74700000,76800000,"q13.3","gneg"],[76800000,85400000,"q21.1","gpos100"],[85400000,87000000,"q21.2","gneg"],[87000000,92700000,"q21.31","gpos100"],[92700000,94300000,"q21.32","gneg"],[94300000,99100000,"q21.33","gpos75"],[99100000,103300000,"q22.1","gneg"],[103300000,104500000,"q22.2","gpos50"],[104500000,109400000,"q22.3","gneg"],[109400000,117400000,"q23","gpos75"],[117400000,121800000,"q24","gneg"],[121800000,129500000,"q25","gpos100"],[129500000,131300000,"q26.1","gneg"],[131300000,134500000,"q26.2","gpos25"],[134500000,138900000,"q26.3","gneg"],[138900000,141200000,"q27.1","gpos75"],[141200000,143000000,"q27.2","gneg"],[143000000,148000000,"q27.3","gpos100"],[148000000,156040895,"q28","gneg"]],Y:[[0,300000,"p11.32","gneg"],[300000,600000,"p11.31","gpos50"],[600000,10300000,"p11.2","gneg"],[10300000,10400000,"p11.1","acen"],[10400000,10600000,"q11.1","acen"],[10600000,12400000,"q11.21","gneg"],[12400000,17100000,"q11.221","gpos50"],[17100000,19600000,"q11.222","gneg"],[19600000,23800000,"q11.223","gpos50"],[23800000,26600000,"q11.23","gneg"],[26600000,57227415,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Fish:["Fish"],Gantt:["Gantt"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Meter:["Meter"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],CombinationLineGraphs:["AreaLine","BarLine","DotLine","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Meter","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Fish","Gantt","Meter","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Gantt","Fish","Meter","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],AttGraphs:["Bar","BarLine","Boxplot","Dotplot","Treemap","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","ParallelCoordinates","Line","Sankey","Tree","TagCloud","Gantt"],NoneDGraphs:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn"],NonSegregatable:["Fish","Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Circular","Gantt"]};CanvasXpress.colorNames={aliceblue:"f0f8ff",antiquewhite1:"ffefdb",antiquewhite2:"eedfcc",antiquewhite3:"cdc0b0",antiquewhite4:"8b8378",antiquewhite:"faebd7",aqua:"00ffff",aquamarine1:"7fffd4",aquamarine2:"76eec6",aquamarine4:"458b74",aquamarine:"7fffd4",azure1:"f0ffff",azure2:"e0eeee",azure3:"c1cdcd",azure4:"838b8b",azure:"f0ffff",beige:"f5f5dc",bisque1:"ffe4c4",bisque2:"eed5b7",bisque3:"cdb79e",bisque4:"8b7d6b",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blue1:"0000ff",blue2:"0000ee",blue3:"1874cd",blue4:"00008b",blueviolet:"8a2be2",brown1:"ff4040",brown2:"ee3b3b",brown3:"cd3333",brown4:"8b2323",brown:"a52a2a",burlywood1:"ffd39b",burlywood2:"eec591",burlywood3:"cdaa7d",burlywood4:"8b7355",burlywood:"deb887",cadetblue1:"98f5ff",cadetblue2:"8ee5ee",cadetblue3:"7ac5cd",cadetblue4:"53868b",cadetblue:"5f9ea0",chartreuse1:"7fff00",chartreuse2:"76ee00",chartreuse3:"66cd00",chartreuse4:"458b00",chartreuse:"7fff00",chocolate1:"ff7f24",chocolate2:"ee7621",chocolate3:"cd661d",chocolate:"d2691e",coral1:"ff7256",coral2:"ee6a50",coral3:"cd5b45",coral4:"8b3e2f",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk1:"fff8dc",cornsilk2:"eee8cd",cornsilk3:"cdc8b1",cornsilk4:"8b8878",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",cyan1:"00ffff",cyan2:"00eeee",cyan3:"00cdcd",cyan4:"008b8b",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod1:"ffb90f",darkgoldenrod2:"eead0e",darkgoldenrod3:"cd950c",darkgoldenrod4:"8b6508",darkgoldenrod4:"8b6508",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen1:"caff70",darkolivegreen2:"bcee68",darkolivegreen3:"a2cd5a",darkolivegreen4:"6e8b3d",darkolivegreen:"556b2f",darkorange1:"ff7f00",darkorange2:"ee7600",darkorange3:"cd6600",darkorange4:"8b4500",darkorange:"ff8c00",darkorchid1:"bf3eff",darkorchid2:"b23aee",darkorchid3:"9a32cd",darkorchid4:"68228b",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen1:"c1ffc1",darkseagreen2:"b4eeb4",darkseagreen3:"9bcd9b",darkseagreen4:"698b69",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray1:"97ffff",darkslategray2:"8deeee",darkslategray:"2f4f4f",darkslategray3:"79cdcd",darkslategray4:"528b8b",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink1:"ff1493",deeppink2:"ee1289",deeppink3:"cd1076",deeppink4:"8b0a50",deeppink:"ff1493",deepskyblue:"00bfff",deepskyblue1:"00bfff",deepskyblue2:"00b2ee",deepskyblue3:"009acd",deepskyblue4:"00688b",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1e90ff",dodgerblue:"1e90ff",dodgerblue2:"1c86ee",dodgerblue3:"1874cd",dodgerblue4:"104e8b",firebrick1:"ff3030",firebrick2:"ee2c2c",firebrick3:"cd2626",firebrick4:"8b1a1a",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold1:"ffd700",gold2:"eec900",gold3:"cdad00",gold4:"8b7500",goldenrod1:"ffc125",goldenrod2:"eeb422",goldenrod3:"cd9b1d",goldenrod4:"8b6914",goldenrod:"daa520",goldenrod:"daa520",gold:"ffd700",gray10:"1a1a1a",gray1:"030303",gray11:"1c1c1c",gray12:"1f1f1f",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2b2b2b",gray18:"2e2e2e",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3b3b3b",gray24:"3d3d3d",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4a4a4a",gray30:"4d4d4d",gray3:"080808",gray31:"4f4f4f",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5c5c5c",gray37:"5e5e5e",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0a0a0a",gray41:"696969",gray42:"6b6b6b",gray43:"6e6e6e",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7a7a7a",gray49:"7d7d7d",gray50:"7f7f7f",gray5:"0d0d0d",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8a8a8a",gray55:"8c8c8c",gray56:"8f8f8f",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0f0f0f",gray61:"9c9c9c",gray62:"9e9e9e",gray63:"a1a1a1",gray64:"a3a3a3",gray65:"a6a6a6",gray66:"a8a8a8",gray67:"ababab",gray68:"adadad",gray69:"b0b0b0",gray70:"b3b3b3",gray7:"121212",gray71:"b5b5b5",gray72:"b8b8b8",gray73:"bababa",gray74:"bdbdbd",gray75:"bfbfbf",gray76:"c2c2c2",gray77:"c4c4c4",gray78:"c7c7c7",gray79:"c9c9c9",gray:"808080",gray80:"cccccc",gray8:"141414",gray81:"cfcfcf",gray82:"d1d1d1",gray83:"d4d4d4",gray84:"d6d6d6",gray85:"d9d9d9",gray86:"dbdbdb",gray87:"dedede",gray88:"e0e0e0",gray89:"e3e3e3",gray90:"e5e5e5",gray9:"171717",gray91:"e8e8e8",gray92:"ebebeb",gray93:"ededed",gray94:"f0f0f0",gray95:"f2f2f2",gray97:"f7f7f7",gray98:"fafafa",gray99:"fcfcfc",gray:"bebebe",green:"008000",green1:"00ff00",green2:"00ee00",green3:"00cd00",green4:"008b00",greenyellow:"adff2f",grey10:"1a1a1a",grey1:"030303",grey11:"1c1c1c",grey12:"1f1f1f",grey13:"212121",grey14:"242424",grey15:"262626",grey16:"292929",grey17:"2b2b2b",grey18:"2e2e2e",grey19:"303030",grey20:"333333",grey2:"050505",grey21:"363636",grey22:"383838",grey23:"3b3b3b",grey24:"3d3d3d",grey25:"404040",grey26:"424242",grey27:"454545",grey28:"474747",grey29:"4a4a4a",grey30:"4d4d4d",grey3:"080808",grey31:"4f4f4f",grey32:"525252",grey33:"545454",grey34:"575757",grey35:"595959",grey36:"5c5c5c",grey37:"5e5e5e",grey38:"616161",grey39:"636363",grey40:"666666",grey4:"0a0a0a",grey41:"696969",grey42:"6b6b6b",grey43:"6e6e6e",grey44:"707070",grey45:"737373",grey46:"757575",grey47:"787878",grey48:"7a7a7a",grey49:"7d7d7d",grey50:"7f7f7f",grey5:"0d0d0d",grey51:"828282",grey52:"858585",grey53:"878787",grey54:"8a8a8a",grey55:"8c8c8c",grey56:"8f8f8f",grey57:"919191",grey58:"949494",grey59:"969696",grey60:"999999",grey6:"0f0f0f",grey61:"9c9c9c",grey62:"9e9e9e",grey63:"a1a1a1",grey64:"a3a3a3",grey65:"a6a6a6",grey66:"a8a8a8",grey67:"ababab",grey68:"adadad",grey69:"b0b0b0",grey70:"b3b3b3",grey7:"121212",grey71:"b5b5b5",grey72:"b8b8b8",grey73:"bababa",grey74:"bdbdbd",grey75:"bfbfbf",grey76:"c2c2c2",grey77:"c4c4c4",grey78:"c7c7c7",grey79:"c9c9c9",grey:"808080",grey80:"cccccc",grey8:"141414",grey81:"cfcfcf",grey82:"d1d1d1",grey83:"d4d4d4",grey84:"d6d6d6",grey85:"d9d9d9",grey86:"dbdbdb",grey87:"dedede",grey88:"e0e0e0",grey89:"e3e3e3",grey90:"e5e5e5",grey9:"171717",grey91:"e8e8e8",grey92:"ebebeb",grey93:"ededed",grey94:"f0f0f0",grey95:"f2f2f2",grey97:"f7f7f7",grey98:"fafafa",grey99:"fcfcfc",grey:"808080",honeydew1:"f0fff0",honeydew2:"e0eee0",honeydew3:"c1cdc1",honeydew4:"838b83",honeydew:"f0fff0",hotpink1:"ff6eb4",hotpink2:"ee6aa7",hotpink3:"cd6090",hotpink4:"8b3a62",hotpink:"ff69b4",indianred1:"ff6a6a",indianred2:"ee6363",indianred3:"cd5555",indianred4:"8b3a3a",indianred:"cd5c5c",indigo:"4b0082",ivory1:"fffff0",ivory2:"eeeee0",ivory3:"cdcdc1",ivory4:"8b8b83",ivory:"fffff0",khaki1:"fff68f",khaki2:"eee685",khaki3:"cdc673",khaki4:"8b864e",khaki:"f0e68c",lavenderblush1:"fff0f5",lavenderblush2:"eee0e5",lavenderblush3:"cdc1c5",lavenderblush4:"8b8386",lavenderblush:"fff0f5",lavender:"e6e6fa",lawngreen:"7cfc00",lemonchiffon1:"fffacd",lemonchiffon2:"eee9bf",lemonchiffon3:"cdc9a5",lemonchiffon4:"8b8970",lemonchiffon:"fffacd",lightblue1:"bfefff",lightblue2:"b2dfee",lightblue3:"9ac0cd",lightblue4:"68838b",lightblue:"add8e6",lightcoral:"f08080",lightcyan1:"e0ffff",lightcyan2:"d1eeee",lightcyan3:"b4cdcd",lightcyan4:"7a8b8b",lightcyan:"e0ffff",light:"eedd82",lightgoldenrod1:"ffec8b",lightgoldenrod2:"eedc82",lightgoldenrod3:"cdbe70",lightgoldenrod4:"8b814c",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink1:"ffaeb9",lightpink2:"eea2ad",lightpink3:"cd8c95",lightpink4:"8b5f65",lightpink:"ffb6c1",lightsalmon1:"ffa07a",lightsalmon2:"ee9572",lightsalmon3:"cd8162",lightsalmon4:"8b5742",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue1:"b0e2ff",lightskyblue2:"a4d3ee",lightskyblue3:"8db6cd",lightskyblue4:"607b8b",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"cae1ff",lightsteelblue2:"bcd2ee",lightsteelblue3:"a2b5cd",lightsteelblue4:"6e7b8b",lightsteelblue:"b0c4de",lightyellow1:"ffffe0",lightyellow2:"eeeed1",lightyellow3:"cdcdb4",lightyellow4:"8b8b7a",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta2:"ee00ee",magenta3:"cd00cd",magenta4:"8b008b",magenta:"ff00ff",maroon1:"ff34b3",maroon2:"ee30a7",maroon3:"cd2990",maroon4:"8b1c62",maroon:"800000",maroon:"b03060",medium:"66cdaa",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid1:"e066ff",mediumorchid2:"d15fee",mediumorchid3:"b452cd",mediumorchid4:"7a378b",mediumorchid:"ba55d3",mediumpurple1:"ab82ff",mediumpurple2:"9f79ee",mediumpurple3:"8968cd",mediumpurple4:"5d478b",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose1:"ffe4e1",mistyrose2:"eed5d2",mistyrose3:"cdb7b5",mistyrose4:"8b7d7b",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite1:"ffdead",navajowhite2:"eecfa1",navajowhite3:"cdb38b",navajowhite4:"8b795e",navajowhite:"ffdead",navy:"000080",navyblue:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab1:"c0ff3e",olivedrab2:"b3ee3a",olivedrab4:"698b22",olivedrab:"6b8e23",orange1:"ffa500",orange2:"ee9a00",orange3:"cd8500",orange4:"8b5a00",orange:"ffa500",orangered1:"ff4500",orangered2:"ee4000",orangered3:"cd3700",orangered4:"8b2500",orangered:"ff4500",orchid1:"ff83fa",orchid2:"ee7ae9",orchid3:"cd69c9",orchid4:"8b4789",orchid:"da70d6",pale:"db7093",palegoldenrod:"eee8aa",palegreen1:"9aff9a",palegreen2:"90ee90",palegreen3:"7ccd7c",palegreen4:"548b54",palegreen:"98fb98",paleturquoise1:"bbffff",paleturquoise2:"aeeeee",paleturquoise3:"96cdcd",paleturquoise4:"668b8b",paleturquoise:"afeeee",palevioletred1:"ff82ab",palevioletred2:"ee799f",palevioletred3:"cd6889",palevioletred4:"8b475d",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff1:"ffdab9",peachpuff2:"eecbad",peachpuff3:"cdaf95",peachpuff4:"8b7765",peachpuff:"ffdab9",peru:"cd853f",pink1:"ffb5c5",pink2:"eea9b8",pink3:"cd919e",pink4:"8b636c",pink:"ffc0cb",plum1:"ffbbff",plum2:"eeaeee",plum3:"cd96cd",plum4:"8b668b",plum:"dda0dd",powderblue:"b0e0e6",purple1:"9b30ff",purple2:"912cee",purple3:"7d26cd",purple4:"551a8b",purple:"800080",purple:"a020f0",rebeccapurple:"663399",red1:"ff0000",red2:"ee0000",red3:"cd0000",red4:"8b0000",red:"ff0000",rosybrown1:"ffc1c1",rosybrown2:"eeb4b4",rosybrown3:"cd9b9b",rosybrown4:"8b6969",rosybrown:"bc8f8f",royalblue1:"4876ff",royalblue2:"436eee",royalblue3:"3a5fcd",royalblue:"4169e1",royalblue4:"27408b",saddlebrown:"8b4513",salmon1:"ff8c69",salmon2:"ee8262",salmon3:"cd7054",salmon4:"8b4c39",salmon:"fa8072",sandybrown:"f4a460",seagreen1:"54ff9f",seagreen2:"4eee94",seagreen:"2e8b57",seagreen3:"43cd80",seagreen4:"2e8b57",seashell1:"fff5ee",seashell2:"eee5de",seashell3:"cdc5bf",seashell4:"8b8682",seashell:"fff5ee",sienna1:"ff8247",sienna2:"ee7942",sienna3:"cd6839",sienna4:"8b4726",sienna:"a0522d",silver:"c0c0c0",skyblue1:"87ceff",skyblue2:"7ec0ee",skyblue3:"6ca6cd",skyblue4:"4a708b",skyblue:"87ceeb",slateblue1:"836fff",slateblue2:"7a67ee",slateblue3:"6959cd",slateblue4:"473c8b",slateblue:"6a5acd",slategray1:"c6e2ff",slategray2:"b9d3ee",slategray3:"9fb6cd",slategray4:"6c7b8b",slategray:"708090",slategrey:"708090",snow1:"fffafa",snow2:"eee9e9",snow3:"cdc9c9",snow4:"8b8989",snow:"fffafa",springgreen:"00ff7f",springgreen1:"00ff7f",springgreen2:"00ee76",springgreen3:"00cd66",springgreen4:"008b45",steelblue1:"63b8ff",steelblue2:"5cacee",steelblue3:"4f94cd",steelblue4:"36648b",steelblue:"4682b4",tan1:"ffa54f",tan2:"ee9a49",tan3:"cd853f",tan4:"8b5a2b",tan:"d2b48c",teal:"008080",thistle1:"ffe1ff",thistle2:"eed2ee",thistle3:"cdb5cd",thistle4:"8b7b8b",thistle:"d8bfd8",tomato1:"ff6347",tomato2:"ee5c42",tomato3:"cd4f39",tomato4:"8b3626",tomato:"ff6347",turquoise1:"00f5ff",turquoise2:"00e5ee",turquoise3:"00c5cd",turquoise4:"00868b",turquoise:"40e0d0",violet:"ee82ee",violetred1:"ff3e96",violetred2:"ee3a8c",violetred3:"cd3278",violetred4:"8b2252",violetred:"d02090",wheat1:"ffe7ba",wheat2:"eed8ae",wheat3:"cdba96",wheat4:"8b7e66",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow1:"ffff00",yellow2:"eeee00",yellow3:"cdcd00",yellow4:"8b8b00",yellow:"ffff00",yellowgreen:"9acd32"};CanvasXpress.colorWords=["4627f67737371607","465647365647f62705028607162774","475707e6944627f67737371605d28536d2","271656c636","465677f6c6c6160247f6e6022756767657265644","4627f677373716070216028647967702e4f435a402371602566716370247f6e6e61634","d65647379737","27567676572656443796","373756270785371667e61634","4707972736e656","47079727365646","374627f67527f6c6f636","5346d6","47c61637","473756769646","465686361636","4627f67737371607021602864796770274653502371602566716370247f6e6e61634","74e405d6f62764164716445637271607","56c696644616f6c6","56671637","74653556671637","47e6962707","0742","850742","8642","6742","7742","27563777f6272456a796c616964796e696","4642","472756c616","56079747f647f62707","56c6f637e6f636","76f6c6","2756767657265646","5636e616d627f666275607","37569647275607f6270556e696665646","e6f696471636f6c6","56d616e64737f686","473656a626f4","57e656d647875647e6f636","57e656d647875647e6f636e6f6","07f64737","0476e696274735f647","27f6272754","4787564577162746","27f6c6f63447e6f666","5646f6e43796","373756c6461656843796","47361656253796","46562756473796765627"];CanvasXpress.salt="7A64D88307896170036C253EA";CanvasXpress.setColorSchemes=function(){CanvasXpress.colorSchemes={YlGn:{3:"f7fcb9addd8e31a354",4:"ffffccc2e69978c679238443",5:"ffffccc2e69978c67931a354006837",6:"ffffccd9f0a3addd8e78c67931a354006837",7:"ffffccd9f0a3addd8e78c67941ab5d238443005a32",8:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443005a32",9:"ffffe5f7fcb9d9f0a3addd8e78c67941ab5d238443006837004529"},YlGnBu:{3:"edf8b17fcdbb2c7fb8",4:"ffffcca1dab441b6c4225ea8",5:"ffffcca1dab441b6c42c7fb8253494",6:"ffffccc7e9b47fcdbb41b6c42c7fb8253494",7:"ffffccc7e9b47fcdbb41b6c41d91c0225ea80c2c84",8:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea80c2c84",9:"ffffd9edf8b1c7e9b47fcdbb41b6c41d91c0225ea8253494081d58"},GnBu:{3:"e0f3dba8ddb543a2ca",4:"f0f9e8bae4bc7bccc42b8cbe",5:"f0f9e8bae4bc7bccc443a2ca0868ac",6:"f0f9e8ccebc5a8ddb57bccc443a2ca0868ac",7:"f0f9e8ccebc5a8ddb57bccc44eb3d32b8cbe08589e",8:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe08589e",9:"f7fcf0e0f3dbccebc5a8ddb57bccc44eb3d32b8cbe0868ac084081"},BuGn:{3:"e5f5f999d8c92ca25f",4:"edf8fbb2e2e266c2a4238b45",5:"edf8fbb2e2e266c2a42ca25f006d2c",6:"edf8fbccece699d8c966c2a42ca25f006d2c",7:"edf8fbccece699d8c966c2a441ae76238b45005824",8:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45005824",9:"f7fcfde5f5f9ccece699d8c966c2a441ae76238b45006d2c00441b"},PuBuGn:{3:"ece2f0a6bddb1c9099",4:"f6eff7bdc9e167a9cf02818a",5:"f6eff7bdc9e167a9cf1c9099016c59",6:"f6eff7d0d1e6a6bddb67a9cf1c9099016c59",7:"f6eff7d0d1e6a6bddb67a9cf3690c002818a016450",8:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016450",9:"fff7fbece2f0d0d1e6a6bddb67a9cf3690c002818a016c59014636"},PuBu:{3:"ece7f2a6bddb2b8cbe",4:"f1eef6bdc9e174a9cf0570b0",5:"f1eef6bdc9e174a9cf2b8cbe045a8d",6:"f1eef6d0d1e6a6bddb74a9cf2b8cbe045a8d",7:"f1eef6d0d1e6a6bddb74a9cf3690c00570b0034e7b",8:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0034e7b",9:"fff7fbece7f2d0d1e6a6bddb74a9cf3690c00570b0045a8d023858"},BuPu:{3:"e0ecf49ebcda8856a7",4:"edf8fbb3cde38c96c688419d",5:"edf8fbb3cde38c96c68856a7810f7c",6:"edf8fbbfd3e69ebcda8c96c68856a7810f7c",7:"edf8fbbfd3e69ebcda8c96c68c6bb188419d6e016b",8:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d6e016b",9:"f7fcfde0ecf4bfd3e69ebcda8c96c68c6bb188419d810f7c4d004b"},RdPu:{3:"fde0ddfa9fb5c51b8a",4:"feebe2fbb4b9f768a1ae017e",5:"feebe2fbb4b9f768a1c51b8a7a0177",6:"feebe2fcc5c0fa9fb5f768a1c51b8a7a0177",7:"feebe2fcc5c0fa9fb5f768a1dd3497ae017e7a0177",8:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a0177",9:"fff7f3fde0ddfcc5c0fa9fb5f768a1dd3497ae017e7a017749006a"},PuRd:{3:"e7e1efc994c7dd1c77",4:"f1eef6d7b5d8df65b0ce1256",5:"f1eef6d7b5d8df65b0dd1c77980043",6:"f1eef6d4b9dac994c7df65b0dd1c77980043",7:"f1eef6d4b9dac994c7df65b0e7298ace125691003f",8:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125691003f",9:"f7f4f9e7e1efd4b9dac994c7df65b0e7298ace125698004367001f"},OrRd:{3:"fee8c8fdbb84e34a33",4:"fef0d9fdcc8afc8d59d7301f",5:"fef0d9fdcc8afc8d59e34a33b30000",6:"fef0d9fdd49efdbb84fc8d59e34a33b30000",7:"fef0d9fdd49efdbb84fc8d59ef6548d7301f990000",8:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301f990000",9:"fff7ecfee8c8fdd49efdbb84fc8d59ef6548d7301fb300007f0000"},YlOrRd:{3:"ffeda0feb24cf03b20",4:"ffffb2fecc5cfd8d3ce31a1c",5:"ffffb2fecc5cfd8d3cf03b20bd0026",6:"ffffb2fed976feb24cfd8d3cf03b20bd0026",7:"ffffb2fed976feb24cfd8d3cfc4e2ae31a1cb10026",8:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cb10026",9:"ffffccffeda0fed976feb24cfd8d3cfc4e2ae31a1cbd0026800026"},YlOrBr:{3:"fff7bcfec44fd95f0e",4:"ffffd4fed98efe9929cc4c02",5:"ffffd4fed98efe9929d95f0e993404",6:"ffffd4fee391fec44ffe9929d95f0e993404",7:"ffffd4fee391fec44ffe9929ec7014cc4c028c2d04",8:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c028c2d04",9:"ffffe5fff7bcfee391fec44ffe9929ec7014cc4c02993404662506"},Purples:{3:"efedf5bcbddc756bb1",4:"f2f0f7cbc9e29e9ac86a51a3",5:"f2f0f7cbc9e29e9ac8756bb154278f",6:"f2f0f7dadaebbcbddc9e9ac8756bb154278f",7:"f2f0f7dadaebbcbddc9e9ac8807dba6a51a34a1486",8:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a34a1486",9:"fcfbfdefedf5dadaebbcbddc9e9ac8807dba6a51a354278f3f007d"},Blues:{3:"deebf79ecae13182bd",4:"eff3ffbdd7e76baed62171b5",5:"eff3ffbdd7e76baed63182bd08519c",6:"eff3ffc6dbef9ecae16baed63182bd08519c",7:"eff3ffc6dbef9ecae16baed64292c62171b5084594",8:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b5084594",9:"f7fbffdeebf7c6dbef9ecae16baed64292c62171b508519c08306b"},BluesDark:{2:"132B4356B1F7"},Greens:{3:"e5f5e0a1d99b31a354",4:"edf8e9bae4b374c476238b45",5:"edf8e9bae4b374c47631a354006d2c",6:"edf8e9c7e9c0a1d99b74c47631a354006d2c",7:"edf8e9c7e9c0a1d99b74c47641ab5d238b45005a32",8:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45005a32",9:"f7fcf5e5f5e0c7e9c0a1d99b74c47641ab5d238b45006d2c00441b"},Oranges:{3:"fee6cefdae6be6550d",4:"feeddefdbe85fd8d3cd94701",5:"feeddefdbe85fd8d3ce6550da63603",6:"feeddefdd0a2fdae6bfd8d3ce6550da63603",7:"feeddefdd0a2fdae6bfd8d3cf16913d948018c2d04",8:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d948018c2d04",9:"fff5ebfee6cefdd0a2fdae6bfd8d3cf16913d94801a636037f2704"},Reds:{3:"fee0d2fc9272de2d26",4:"fee5d9fcae91fb6a4acb181d",5:"fee5d9fcae91fb6a4ade2d26a50f15",6:"fee5d9fcbba1fc9272fb6a4ade2d26a50f15",7:"fee5d9fcbba1fc9272fb6a4aef3b2ccb181d99000d",8:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181d99000d",9:"fff5f0fee0d2fcbba1fc9272fb6a4aef3b2ccb181da50f1567000d"},Greys:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000",256:"fffffffffffffefefefefefefdfdfdfdfdfdfcfcfcfcfcfcfbfbfbfbfbfbfafafafafafaf9f9f9f9f9f9f9f9f9f8f8f8f8f8f8f7f7f7f7f7f7f6f6f6f6f6f6f5f5f5f5f5f5f4f4f4f4f4f4f3f3f3f3f3f3f2f2f2f2f2f2f1f1f1f1f1f1f0f0f0f0f0f0efefefefefefeeeeeeeeeeeeededededededececececececebebebebebebeaeaeaeaeaeae9e9e9e9e9e9e8e8e8e8e8e8e7e7e7e7e7e7e6e6e6e6e6e6e5e5e5e5e5e5e4e4e4e4e4e4e3e3e3e3e3e3e2e2e2e2e2e2e1e1e1e1e1e1e0e0e0e0e0e0dfdfdfdfdfdfdedededddddddddddddcdcdcdcdcdcdbdbdbdbdbdbdadadadadadad9d9d9d9d9d9d8d8d8d7d7d7d7d7d7d6d6d6d6d6d6d5d5d5d5d5d5d4d4d4d4d4d4d3d3d3d2d2d2d2d2d2d1d1d1d1d1d1d0d0d0cfcfcfcfcfcfcececececececdcdcdcdcdcdcccccccbcbcbcbcbcbcacacacacacac9c9c9c8c8c8c8c8c8c7c7c7c7c7c7c6c6c6c5c5c5c5c5c5c4c4c4c3c3c3c3c3c3c2c2c2c2c2c2c1c1c1c0c0c0c0c0c0bfbfbfbebebebebebebdbdbdbcbcbcbcbcbcbbbbbbbabababababab9b9b9b8b8b8b8b8b8b7b7b7b6b6b6b6b6b6b5b5b5b4b4b4b4b4b4b3b3b3b2b2b2b2b2b2b1b1b1b0b0b0afafafafafafaeaeaeadadadadadadacacacabababaaaaaaaaaaaaa9a9a9a8a8a8a7a7a7a7a7a7a6a6a6a5a5a5a4a4a4a4a4a4a3a3a3a2a2a2a1a1a1a0a0a0a0a0a09f9f9f9e9e9e9d9d9d9c9c9c9c9c9c9b9b9b9a9a9a9999999898989797979797979696969595959494949393939292929191919090909090908f8f8f8e8e8e8d8d8d8c8c8c8b8b8b8a8a8a8989898888888787878686868585858484848383838282828181818080807f7f7f7e7e7e7d7d7d7c7c7c7b7b7b7a7a7a7878787777777676767575757474747373737272727070706f6f6f6e6e6e6d6d6d6b6b6b6a6a6a6969696767676666666565656363636262626060605f5f5f5d5d5d5c5c5c5a5a5a5959595757575555555454545252525050504e4e4e4c4c4c4a4a4a4848484646464444444242424040403d3d3d3b3b3b3838383535353232322e2e2e2b2b2b2727272222221c1c1c15151500000"},PuOr:{3:"f1a340f7f7f7998ec3",4:"e66101fdb863b2abd25e3c99",5:"e66101fdb863f7f7f7b2abd25e3c99",6:"b35806f1a340fee0b6d8daeb998ec3542788",7:"b35806f1a340fee0b6f7f7f7d8daeb998ec3542788",8:"b35806e08214fdb863fee0b6d8daebb2abd28073ac542788",9:"b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac542788",10:"7f3b08b35806e08214fdb863fee0b6d8daebb2abd28073ac5427882d004b",11:"7f3b08b35806e08214fdb863fee0b6f7f7f7d8daebb2abd28073ac5427882d004b"},BrBG:{3:"d8b365f5f5f55ab4ac",4:"a6611adfc27d80cdc1018571",5:"a6611adfc27df5f5f580cdc1018571",6:"8c510ad8b365f6e8c3c7eae55ab4ac01665e",7:"8c510ad8b365f6e8c3f5f5f5c7eae55ab4ac01665e",8:"8c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e",9:"8c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e",10:"5430058c510abf812ddfc27df6e8c3c7eae580cdc135978f01665e003c30",11:"5430058c510abf812ddfc27df6e8c3f5f5f5c7eae580cdc135978f01665e003c30"},PRGn:{3:"af8dc3f7f7f77fbf7b",4:"7b3294c2a5cfa6dba0008837",5:"7b3294c2a5cff7f7f7a6dba0008837",6:"762a83af8dc3e7d4e8d9f0d37fbf7b1b7837",7:"762a83af8dc3e7d4e8f7f7f7d9f0d37fbf7b1b7837",8:"762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b7837",9:"762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b7837",10:"40004b762a839970abc2a5cfe7d4e8d9f0d3a6dba05aae611b783700441b",11:"40004b762a839970abc2a5cfe7d4e8f7f7f7d9f0d3a6dba05aae611b783700441b"},PiYG:{3:"e9a3c9f7f7f7a1d76a",4:"d01c8bf1b6dab8e1864dac26",5:"d01c8bf1b6daf7f7f7b8e1864dac26",6:"c51b7de9a3c9fde0efe6f5d0a1d76a4d9221",7:"c51b7de9a3c9fde0eff7f7f7e6f5d0a1d76a4d9221",8:"c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221",9:"c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221",10:"8e0152c51b7dde77aef1b6dafde0efe6f5d0b8e1867fbc414d9221276419",11:"8e0152c51b7dde77aef1b6dafde0eff7f7f7e6f5d0b8e1867fbc414d9221276419"},RdBu:{3:"ef8a62f7f7f767a9cf",4:"ca0020f4a58292c5de0571b0",5:"ca0020f4a582f7f7f792c5de0571b0",6:"b2182bef8a62fddbc7d1e5f067a9cf2166ac",7:"b2182bef8a62fddbc7f7f7f7d1e5f067a9cf2166ac",8:"b2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac",9:"b2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac",10:"67001fb2182bd6604df4a582fddbc7d1e5f092c5de4393c32166ac053061",11:"67001fb2182bd6604df4a582fddbc7f7f7f7d1e5f092c5de4393c32166ac053061"},RdGy:{3:"ef8a62ffffff999999",4:"ca0020f4a582bababa404040",5:"ca0020f4a582ffffffbababa404040",6:"b2182bef8a62fddbc7e0e0e09999994d4d4d",7:"b2182bef8a62fddbc7ffffffe0e0e09999994d4d4d",8:"b2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d",9:"b2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d",10:"67001fb2182bd6604df4a582fddbc7e0e0e0bababa8787874d4d4d1a1a1a",11:"67001fb2182bd6604df4a582fddbc7ffffffe0e0e0bababa8787874d4d4d1a1a1a"},RdYlBu:{3:"fc8d59ffffbf91bfdb",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},Spectral:{3:"fc8d59ffffbf99d594",4:"d7191cfdae61abdda42b83ba",5:"d7191cfdae61ffffbfabdda42b83ba",6:"d53e4ffc8d59fee08be6f59899d5943288bd",7:"d53e4ffc8d59fee08bffffbfe6f59899d5943288bd",8:"d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd",9:"d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd",10:"9e0142d53e4ff46d43fdae61fee08be6f598abdda466c2a53288bd5e4fa2",11:"9e0142d53e4ff46d43fdae61fee08bffffbfe6f598abdda466c2a53288bd5e4fa2"},RdYlGn:{3:"fc8d59ffffbf91cf60",4:"d7191cfdae61a6d96a1a9641",5:"d7191cfdae61ffffbfa6d96a1a9641",6:"d73027fc8d59fee08bd9ef8b91cf601a9850",7:"d73027fc8d59fee08bffffbfd9ef8b91cf601a9850",8:"d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850",9:"d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850",10:"a50026d73027f46d43fdae61fee08bd9ef8ba6d96a66bd631a9850006837",11:"a50026d73027f46d43fdae61fee08bffffbfd9ef8ba6d96a66bd631a9850006837"},Accent:{3:"7fc97fbeaed4fdc086",4:"7fc97fbeaed4fdc086ffff99",5:"7fc97fbeaed4fdc086ffff99386cb0",6:"7fc97fbeaed4fdc086ffff99386cb0f0027f",7:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17",8:"7fc97fbeaed4fdc086ffff99386cb0f0027fbf5b17666666"},Dark2:{3:"1b9e77d95f027570b3",4:"1b9e77d95f027570b3e7298a",5:"1b9e77d95f027570b3e7298a66a61e",6:"1b9e77d95f027570b3e7298a66a61ee6ab02",7:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d",8:"1b9e77d95f027570b3e7298a66a61ee6ab02a6761d666666"},Paired:{3:"a6cee31f78b4b2df8a",4:"a6cee31f78b4b2df8a33a02c",5:"a6cee31f78b4b2df8a33a02cfb9a99",6:"a6cee31f78b4b2df8a33a02cfb9a99e31a1c",7:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6f",8:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00",9:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d6",10:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9a",11:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99",12:"a6cee31f78b4b2df8a33a02cfb9a99e31a1cfdbf6fff7f00cab2d66a3d9affff99b15928"},Pastel1:{3:"fbb4aeb3cde3ccebc5",4:"fbb4aeb3cde3ccebc5decbe4",5:"fbb4aeb3cde3ccebc5decbe4fed9a6",6:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcc",7:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bd",8:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaec",9:"fbb4aeb3cde3ccebc5decbe4fed9a6ffffcce5d8bdfddaecf2f2f2"},Pastel2:{3:"b3e2cdfdcdaccbd5e8",4:"b3e2cdfdcdaccbd5e8f4cae4",5:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9",6:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2ae",7:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cc",8:"b3e2cdfdcdaccbd5e8f4cae4e6f5c9fff2aef1e2cccccccc"},Set1:{3:"e41a1c377eb84daf4a",4:"e41a1c377eb84daf4a984ea3",5:"e41a1c377eb84daf4a984ea3ff7f00",6:"e41a1c377eb84daf4a984ea3ff7f00ffff33",7:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628",8:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf",9:"e41a1c377eb84daf4a984ea3ff7f00ffff33a65628f781bf999999"},Set2:{3:"66c2a5fc8d628da0cb",4:"66c2a5fc8d628da0cbe78ac3",5:"66c2a5fc8d628da0cbe78ac3a6d854",6:"66c2a5fc8d628da0cbe78ac3a6d854ffd92f",7:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494",8:"66c2a5fc8d628da0cbe78ac3a6d854ffd92fe5c494b3b3b3"},Set3:{3:"8dd3c7ffffb3bebada",4:"8dd3c7ffffb3bebadafb8072",5:"8dd3c7ffffb3bebadafb807280b1d3",6:"8dd3c7ffffb3bebadafb807280b1d3fdb462",7:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69",8:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5",9:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9",10:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bd",11:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5",12:"8dd3c7ffffb3bebadafb807280b1d3fdb462b3de69fccde5d9d9d9bc80bdccebc5ffed6f"},Default:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676",36:"ff00000000ff00ff00ffff0000ffffff00ff993300000080808000ff6600008080660066ff99cc666699333300ffcc99ccffff9999ffff80803366ff339966ffcc0000ccffd020909933660066cc99cc00ff990033cccccc99ff800000333399008000ffffcc99ccff800080"},Basic:{24:"0000ffff004dffbf0074ff00a400ffff7400ffff0000ffffff0000ffd3003d00ff00ff00ff00ffff9200d3ff000090ff6d00ffff4900ffe80000ff92ff0090ffaa00aaff00004dff"},Light:{24:"6565ffff6593ffd865abff65c865ffffab65ffff6565ffffff6565ffe5658965ff65ff65ff65ffffbd65e5ff6565bcffa765ffff9165fff16565ffbdff65bcffcc65ccff656593ff"},Favorite:{1:"ff0000",2:"ff000000ffff",3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000bfff0000ff800040ffff00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",10:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ff",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080",24:"ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff0000ff4000ff8000ffbf00ffff00bfff0080ff0040ff0000ff4000ff8000ffbf00ffff00ffff00bfff0080ff0040"},Pastel:{24:"b5b5ffffb5cbffedb5d7ffb5e5b5ffffd7b5ffffb5b5ffffffb5b5fff2b5c7b5ffb5ffb5ffb5ffffdfb5f2ffb5b5dfffd5b5ffffcab5fff8b5b5ffdfffb5dfffe6b5e6ffb5b5cbff"},Balanced:{20:"fe296c487eb6a7ce31f8cc03ff8c02699696b7784483acd0c2e076fadc5aff549fffaf549ab8b7d2a6833d699b87ac22cda908d02158d07300567676"},Rpalette:{8:"000000ff000000cd000000ff00ffffff00ffffff00bebebe"},RlatticeBackground:{7:"ffe5ccccffccccffffcce6ffffccffffccccffffcc"},RlatticeShingle:{7:"ff7f0000ff0000ffff0080ffff00ffff0000ffff00"},RlatticeLine:{7:"0080ffff00ff006400ff0000ffa50000ff00a52a2a"},RlatticePolygon:{7:"ccffffffccffccffccffe5cccce6ffffffccffcccc"},Bootstrap:{1:"337ab7",2:"337ab7d9534f",3:"337ab75cb85cd9534f",4:"337ab75cb85cf0ad4ed9534f",5:"337ab75cb85c5bc0def0ad4ed9534f",6:"337ab75cb85c9370db5bc0def0ad4ed9534f",7:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976",8:"337ab75cb85cd9534ff0ad4e5bc0de84fe83ff9976c86727"},ColorSpectrum:{1:""},White:{1:"ffffff"},Black:{1:"000000"},Diverging:{5:"f5841dedbb69d0d5e155b5d90c4487"},DivergingAlt:{5:"9e0418dd6c72d0d5e135a0c8042750"},Brand:{4:"cfe2f15eaccf0e76b0042751"},Complementary:{4:"f7d6d5ff8581e040439e0418"},Colorful:{5:"fcf6c4b1ca91718be67d53b0920148"},ColorfulAlt:{5:"fcf6c4edb681c77b7a7f50930e3587"},WHO:{6:"108dc98eca3affa16ae65550ffa3005bc2e7"},NPG:{10:"e64b354dbbd500a0873c5488f39b7f8491b491d1c2dc00007e6148b09c85"},AAAS:{10:"3b4992ee0000008b45631879008280bb00215f559ba200568081801b1919"},NEJM:{8:"bc3c290072b5e1872720854e7876b16f99adffdc91ee4c97"},Lancet:{9:"00468bed000042b5400099b4925e9ffdaf91ad002aadb6b61b1919"},Jama:{7:"374e55df8f4400a1d5b2474579af976a659980796b"},JCO:{10:"0073c2efc000868686cd534c7aa6dc003c678f77003b3b3ba730304a6990"},Economist:{12:"6794a7014d6476c0c101a2d97ad2f600887dadadad7bd3f67c260bee8f7176c0c1a18376"},EconomistBG:{5:"d5e4ebc3d6dfed111aebebebc9c9c9"},Excel:{7:"ff00ffffff0000ffff8000808000000080800000ff"},Excel2:{7:"993366ffffccccffff660066ff80800066ccccccff"},Excel3:{10:"365e9698333477973d5d437c36869fd1702f8197c5c47f80acc4849887b0"},GGPlot:{1:"595959",2:"f8766d00bfc4",3:"f8766d00ba38619cff",4:"f8766d7cae0000bfc4c77cff",5:"f8766da3a50000bf7d00b0f6e76bf3",6:"f8766db79f0000ba3800bfc4619cfff564e3",7:"f8766dc49a0053b40000c09400b6eba58afffb61d7",8:"f8766dcd96007cae0000be6700bfc400a9ffc77cffff61cc",9:"f8766dd3920093aa0000ba3800c19f00b9e3619cffdb72fbff61c3",10:"f8766dd89000a3a50039b60000bf7d00bfc400b0f69590ffe76bf3ff62bc",11:"f8766ddb8e00aea20064b20000bd5c00c1a700bade00a6ffb385ffef67ebff63b6",12:"f8766dde8c00b79f007cae0000ba3800c08b00bfc400b4f0619cffc77cfff564e3ff64b0",13:"f8766de18a00be9c008cab0024b70000be7000c1ab00bbda00acfc8b93ffd575fef962ddff65ac",14:"f8766de38900c49a0099a80053b40000bc5600c09400bfc400b6eb06a4ffa58affdf70f8fb61d7ff66a8",15:"f8766de58700c99800a3a5006bb10000ba3800bf7d00c0af00bcd800b0f6619cffb983ffe76bf3fd61d1ff67a4",16:"f8766de68613cd9600aba3007cae000cb70200be6700c19a00bfc400b8e700a9ff8494ffc77cffed68edff61ccff68a1",17:"f8766de7851ed09400b2a10089ac0045b50000bc5100c08700c0b200bcd600b3f229a3ff9c8dffd277fff166e8ff61c7ff689e",18:"f8766de88526d39200b79f0093aa005eb30000ba3800bf7400c19f00bfc400b9e300adfa619cffae87ffdb72fbf564e3ff61c3ff699c"},Solarized:{1:"b58900",2:"b58900859900",3:"b58900c671c4859900",4:"b58900dc322f268bd2859900",5:"b58900dc322f6c71c4268bd2859900",6:"b58900cb4b16d336826c71c42aa198859900",7:"b58900cb4b16dc322f6c71c4268bd22aa198859900",8:"b58900cb4b16dc322fd336826c71c4268bd22aa198859900"},SolarizedBase:{7:"002b36073642586e7583949693a1a1eee8d5fdf6e3",8:"002b36073642586e75657b8383949693a1a1eee8d5fdf6e3"},PaulTol:{1:"4477aa",2:"4477aacc6677",3:"4477aaddcc77cc6677",4:"4477aa117733ddcc77cc6677",5:"4477aa88ccee117733ddcc77cc6677",6:"4477aa88ccee117733ddcc77cc6677aa4499",7:"33228888ccee44aa99117733ddcc77cc6677aa4499",8:"33228888ccee44aa99117733999933ddcc77cc6677aa4499",9:"33228888ccee44aa99117733999933ddcc77cc6677882255aa4499",10:"33228888ccee44aa99117733999933ddcc77661100cc6677882255aa4499",11:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677882255aa4499",12:"3322886699cc88ccee44aa99117733999933ddcc77661100cc6677aa4466882255aa4499"},ColorBlind:{8:"000000e69f0056b4e9009e73f0e4420072b2d55e00cc79a7"},Tableau:{20:"1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5",10:"1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf"},TableauMedium:{10:"729eceff9e4a67bf5ced665dad8bc9a8786eed97caa2a2a2cdcc5d6dccda"},TableauLight:{10:"aec7e8ffbb7898df8aff9896c5b0d5c49c94f7b6d2c7c7c7dbdb8d9edae5"},TableauGrey:{5:"60636aa5acaf4144518f8782cfcfcf"},TableauColorBlind:{10:"006ba4ff800eababab5959595f9ed1c85200898989a2c8ecffbc79cfcfcf"},TableauTrafficLight:{9:"b10318dba13a309343d82526ffc15669b764f26c64ffdd719fcd99"},TableauPurpleGrey:{12:"7b66d2a699e8dc5fbdffc0da5f5a41b4b19b995688d898baab6ad5d098ee8b7c6edbd4c5"},TableauBlueRed:{12:"2c69b0b5c8e2f02720ffb6b0ac613ce9c39b6ba3d6b5dffdac8763ddc9b4bd0a36f4737a"},TableauGreenOrange:{12:"32a251acd98dff7f0fffb9773cb7cc98d9e4b85a0dffd94a39737c86b4a982853bccc94d"},TableauCyclic:{20:"1f83b41696ac18a18829a03c54a33882a93fadb828d8bd35ffbd4cffb022ff9c0eff810ee75727d23e4ec94d8cc04aa7b446b39658b18061b46f63bb"},TableauPairSequential:{32:"bccfb49c0824bccfb409622ab4d4da26456ef0c2947b3014c3c3c31e1e1ee5e5e5ffb2b6e5e5e5b7e6a7e5e5e5c4d8f3e5e5e5ffcc9ef5cac7bd1100dbe8b43c8200f3e0c2bb5137feffd941b7c4f7e4c6bb5137efedf5807dbaf0f0f0737373"},TableauTripleDiverging:{48:"9c0824cacaca26456e9c0824cacaca09622a9c0824ffffff09622a9c0824cacaca1e1e1e9c0824ffffff1e1e1e09622acacaca26456e7b3014cacaca26456e7b3014ffffff26456effb2b6e5e5e5b7e6a7ffb2b6ffffffb7e6a7ffb2b6ffffffc6c6c6ffcc9ee5e5e5c4d8f3ffcc9effffffc4d8f3e0ad30e4e4e27492aaeda389cde1d35c8b70529985dbcf47c26b51"},WallStreetJournal:{4:"efefefe9f3ead4dee7f8f2e4"},WallStreetJournal2:{4:"d3ba68d5695d5d8ca865a479"},WallStreetJournalRedGreen:{2:"088158ba2f2a"},WallStreetJournalBlackGreen:{4:"00000059595959a77f008856"},WallStreetJournalDemRep:{3:"006a8eb1283aa8a6a7"},WallStreetJournal3:{6:"c72e29016392be9c2e098154fb832d000000"},Stata:{15:"1a476f90353b55752fe37e006e8e84c10534938dd2cac27ea0522d7b92a82d6d669c8847bfa19cffd200d9e6eb"},Stata2:{15:"ffff0000ff000080ffff00ffff7f00ff0000add8e6ffe47400ff80c0dcc0ff45000000ffff00806e8e84a0522d"},Stata3:{15:"006000ff45001a476f90353b6e8e84a0522dff7f00ff00ff00ffffff000000ff009c8847800080c0dcc0add8e6"},StataMono:{15:"606060a0a0a0808080404040000000e0e0e0202020707070909090b0b0b0d0d0d0f0f0f0303030c0c0c0505050"},BlackAndWhite:{3:"f0f0f0bdbdbd636363",4:"f7f7f7cccccc969696525252",5:"f7f7f7cccccc969696636363252525",6:"f7f7f7d9d9d9bdbdbd969696636363252525",7:"f7f7f7d9d9d9bdbdbd969696737373525252252525",8:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525",9:"fffffff0f0f0d9d9d9bdbdbd969696737373525252252525000000"},BehancePair:{2:"6b5dd3cec8ff",4:"6b5dd3cec8ffffa2c0ffc6db",6:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7",8:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f",10:"6b5dd3cec8ffffa2c0ffc6db3f8cffa0d7e7fece73ffa25f1b1d218d8e90"},BehanceTrio:{3:"6b5dd3cec8ff9d93e9",6:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a4",9:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5",12:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab",15:"6b5dd3cec8ff9d93e9ffa2c0ffc6dbff78a43f8cffa0d7e71b49c5fece73ffa25ffee2ab1b1d218d8e90494a4d"},BehanceQuartet:{4:"6b5dd3cec8ff9d93e98072dc",8:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed3",12:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4ff",16:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d",20:"6b5dd3cec8ff9d93e98072dcffa2c0ffc6dbff78a4ffbed33f8cffa0d7e71b49c5cdf4fffece73ffa25ffee2abfedd9d1b1d218d8e90494a4dfafafa"},Behance:{1:"6b5dd3",2:"6b5dd3ffa2c0",3:"6b5dd3ffa2c03f8cff",4:"6b5dd3ffa2c03f8cfffece73",5:"6b5dd33f8cffffa2c0fece731b1d21",6:"6b5dd3ffa2c03f8cff9d93e9ffc6dba0d7e7",7:"6b5dd33f8cffffa2c0fece731b1d21ffa25fcdf4ff",8:"6b5dd3ffa2c03f8cfffece739d93e9a0d7e7ffc6dbfee2ab",9:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab",10:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90",15:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d",20:"6b5dd33f8cffffa2c0fece731b1d219d93e9a0d7e7ffc6dbfee2ab8d8e90cec8ff1b49c5ff78a4ffa25f494a4d8072dccdf4ffffbed3fedd9dfafafa"},Prism:{1:"1f7ff1",2:"1f7ff1814cff",3:"1f7ff1814cffff7d00",4:"1f7ff1814cffff7d0012c5ff",5:"1f7ff1814cffff7d0012c5fff4d4fe",6:"1f7ff1814cffff7d0012c5fff4d4fee9c505",7:"1f7ff1814cffff7d0012c5fff4d4fee9c505898790"},PrismPair:{2:"1f7ff112c5ff",4:"1f7ff112c5ff814cfff4d4fe",6:"1f7ff112c5ff814cfff4d4feff7d00e9c505",8:"1f7ff112c5ff814cfff4d4feff7d00e9c505042d710ccffe"},PrismTrio:{3:"61459939d4fbfe7d29"},BMS:{4:"be2bbb585454a59fa0ede7e8",9:"be2bbb585454a59fa0ede7e8ffeccdfedccad9c5c4c6ffe6c0f2fc"},BMSPrimary:{4:"BE2BBBA69F9F595454EEE7E7"},BMSSecondary:{5:"ffeccdfedccad9c5c4c6ffe6c0f2fc",6:"ffeccdfedccaead6c8e0cbc3d9c5c4d2cac9",8:"FFECCDFEDCCAEAD5C9DFCBC3DAC5C5D2CAC8C5FFE6C0F2FB"},BMSTertiary:{2:"c6ffe6c0f2fc"},BMSTertiaryLight:{5:"59FFB9FDA97D33D6F1CB7C78FFD186"},BMSTertiaryDark:{5:"1DCE9BDF603A009FBA772A28FFAC25"},BMSBackground:{3:"f0ebeaefe6e7f9f7fa"},BMSWheat:{4:"ffeccdfed187feac25c37901"},BMSPink:{4:"fedccafea97de0613cba4421"},BMSBrown:{4:"d9c5c4cb7c79782a28511515"},BMSGreen:{4:"c6ffe652e7bd1ecd9a138967"},BMSBlue:{4:"c0f2fc33d7f102a0baa0778a"},CanvasXpress:{1:"4575b4",2:"d730274575b4",3:"d7191cfdae612c7bb6",4:"d7191cfdae61abd9e92c7bb6",5:"d7191cfdae61ffffbfabd9e92c7bb6",6:"d73027fc8d59fee090e0f3f891bfdb4575b4",7:"d73027fc8d59fee090ffffbfe0f3f891bfdb4575b4",8:"d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4",9:"d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4",10:"a50026d73027f46d43fdae61fee090e0f3f8abd9e974add14575b4313695",11:"a50026d73027f46d43fdae61fee090ffffbfe0f3f8abd9e974add14575b4313695"},CanvasXpressTraditional:{1:"f2000d",2:"f2000d000df2",3:"f2000d000df20df200",4:"f2000d000df20df200f2f20d",5:"f2000d000df20df200f2f20df20df2",6:"f2000d000df20df200f2f20df20df20df2f2",7:"f2000d000df20df200f2f20df20df20df2f2f2f2f2",8:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd3",9:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fe",10:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b",11:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d0016",12:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d",13:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00",14:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808",15:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38b",16:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe",17:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3",18:"f2000d000df20df200f2f20df20df20df2f2f2f2f2fe8bd38bd3fed3fe8b5d001600165d165d00080808fed38bd38bfe8bfed3404040"},Matlab:{7:"0072bdd95319edb1207e2f8e77ac304dbeeea2142f"},Parula:{10:"352a870f5cdd127dd8079ccf15b1b459bd8ca5be6be1b952fcce2ef9fb0e"},Viridis:{3:"44015421908cfde725",4:"44015431688e35b779fde725",5:"4401543b528b21908c5dc863fde725",6:"4401544144872a788e22a8847ad151fde725",7:"440154443a8331688e21908c35b7798fd744fde725",8:"44015446337e365c8d277f8e1fa1874ac16d9fda3afde725",9:"440154472d7b3b528b2c728e21908c27ad815dc863aadc32fde725",10:"4401544828783e4a8931688e26828e1f9e8935b7796dcd59b4de2cfde725",11:"44015448257641448735608d2a788e21908c22a88443bf717ad151bbdf27fde725",12:"440154482173433e8538598c2d708e25858e1e9b8a2bb07f51c56a85d54ac2df23fde725",256:"44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"},Magma:{3:"000004b63679fcfdbf",4:"000004721f81f1605dfcfdbf",5:"00000451127cb63679fb8861fcfdbf",6:"0000043b0f708c2981de4968fe9f6dfcfdbf",7:"0000042d1160721f81b63679f1605dfeaf77fcfdbf",8:"0000042311515f187f982d80d3436ef8765cfeba80fcfdbf",9:"0000041d114751127c822681b63679e65164fb8861fec287fcfdbf",10:"000004180f3e451077721f819f2f7fcd4071f1605dfd9567fec98dfcfdbf",11:"000004150e373b0f70641a808c2981b63679de4968f76f5cfe9f6dfece91fcfdbf",12:"000004120d323310685a167e7d2482a3307ec83e73e95562f97c5dfea873fed395fcfdbf",256:"00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"},Plasma:{3:"0d0887cc4678f0f921",4:"0d08879c179eed7953f0f921",5:"0d08877e03a8cc4678f89441f0f921",6:"0d08876a00a8b12a90e16462fca636f0f921",7:"0d08875d01a69c179ecc4678ed7953fdb32ff0f921",8:"0d08875402a38b0aa5b93289db5c68f48849febc2af0f921",9:"0d08874c02a17e03a8a92395cc4678e56b5df89441fdc328f0f921",10:"0d088747039f7301a89c179ebd3786d8576bed7953fa9e3bfdc926f0f921",11:"0d088742049e6a00a8900da4b12a90cc4678e16462f1844bfca636fcce25f0f921",12:"0d08873e049c6300a78707a6a62098c03a83d5546ee76f5af58c46fdad32fcd225f0f921",256:"0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"},Inferno:{3:"000004bb3754fcffa4",4:"000004781c6ded6925fcffa4",5:"00000456106ebb3754f98c0afcffa4",6:"000004420a68932667dd513afca50afcffa4",7:"000004330a5f781c6dbb3754ed6925fcb519fcffa4",8:"000004280b5465156e9f2a63d44842f57d15fac127fcffa4",9:"000004210c4a56106e89226abb3754e35932f98c0af9c932fcffa4",10:"0000041b0c424b0c6b781c6da52c60cf4446ed6925fb9a06f7d03cfcffa4",11:"000004170c3a420a686b186e932667bb3754dd513af3771afca50af6d645fcffa4",12:"000004140b353a096360136e85216ba92e5ecb4149e65d2ff78311fcad12f5db4bfcffa4",256:"00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"},Cividis:{3:"00204d7c7b78ffea46",4:"00204d575c6da69d75ffea46",5:"00204d414d6b7c7b78bcaf6fffea46",6:"00204d31446b666970958f78cbba69ffea46",7:"00204d233e6c575c6d7c7b78a69d75d3c164ffea46",8:"00204d16396d4b546c6c6e728e8a79b3a772dbc761ffea46",9:"00204d05366e414d6b61646f7c7b789b9477bcaf6fe0cb5effea46",10:"00204d00336f39486b575c6d7071738a8779a69d75c4b56ce4cf5bffea46",11:"00204d00326f31446b4e576c6669707c7b78958f78b0a473cbba69e7d159ffea46",12:"00204d00306f2a406c48526b5e626e7273748784799e9677b6a971d0be67ead357ffea46",256:"00204c00204e00215000225100235300235500245600255800265a00265b00275d00285f002861002963002a64002a66002b68002c6a002d6c002d6d002e6e002e6f002f6f002f6f00306f00316f00316f00326e00336e00346e00346e01356e06366e0a376d0e376d12386d15396d17396d1a3a6c1c3b6c1e3c6c203c6c223d6c243e6c263e6c273f6c29406b2b416b2c416b2e426b2f436b31446b32446b33456b35466b36466b37476b38486b3a496b3b496b3c4a6b3d4b6b3e4b6b404c6b414d6b424e6b434e6b444f6b45506b46506b47516b48526b49536b4a536b4b546b4c556b4d556b4e566b4f576c50586c51586c52596c535a6c545a6c555b6c565c6c575d6d585d6d595e6d5a5f6d5b5f6d5c606d5d616e5e626e5f626e5f636e60646e61656f62656f63666f64676f65676f666870676970686a70686a70696b716a6c716b6d716c6d726d6e726e6f726f6f726f70737071737172737272747373747474757575757575757676767777767878767978777a79777b7a777b7b787c7b787d7c787e7d787f7e78807e78817f788280788381788481788582788683788784788885788985788a86788b87788c88788d88788e89788f8a78908b78918c78928c78938d78948e78958f78968f779790779891779992779a93779b93779c94779d95779e96769f9776a09876a19876a29976a39a75a49b75a59c75a69c75a79d75a89e74a99f74aaa074aba174aca173ada273aea373afa473b0a572b1a672b2a672b4a771b5a871b6a971b7aa70b8ab70b9ab70baac6fbbad6fbcae6ebdaf6ebeb06ebfb16dc0b16dc1b26cc2b36cc3b46cc5b56bc6b66bc7b76ac8b86ac9b869cab969cbba68ccbb68cdbc67cebd67d0be66d1bf66d2c065d3c065d4c164d5c263d6c363d7c462d8c561d9c661dbc760dcc860ddc95fdeca5edfcb5de0cb5de1cc5ce3cd5be4ce5be5cf5ae6d059e7d158e8d257e9d356ebd456ecd555edd654eed753efd852f0d951f1da50f3db4ff4dc4ef5dd4df6de4cf7df4bf9e049fae048fbe147fce246fde345ffe443ffe542ffe642ffe743ffe844ffe945"},Rainbow:{3:"ff000000ff000000ff",4:"ff000080ff0000ffff8000ff",5:"ff0000ccff0000ff660066ffcc00ff",6:"ff0000ffff0000ff0000ffff0000ffff00ff",7:"ff0000ffdb0049ff0000ff920092ff4900ffff00db",8:"ff0000ffbf0080ff0000ff4000ffff0040ff8000ffff00bf",9:"ff0000ffaa00aaff0000ff0000ffaa00aaff0000ffaa00ffff00aa",10:"ff0000ff9900ccff0033ff0000ff6600ffff0066ff3300ffcc00ffff0099",11:"ff0000ff8b00e8ff005dff0000ff2e00ffb900b9ff002eff5d00ffe800ffff008b",12:"ff0000ff8000ffff0080ff0000ff0000ff8000ffff0080ff0000ff8000ffff00ffff0080"},Heat:{3:"ff0000ff8000ffff00",4:"ff0000ff8000ffff00ffff80",5:"ff0000ff5500ffaa00ffff00ffff80",6:"ff0000ff4000ff8000ffbf00ffff00ffff80",7:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff80",8:"ff0000ff3300ff6600ff9900ffcc00ffff00ffff40ffffbf",9:"ff0000ff2a00ff5500ff8000ffaa00ffd500ffff00ffff40ffffbf",10:"ff0000ff2400ff4900ff6d00ff9200ffb600ffdb00ffff00ffff40ffffbf",11:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff40ffffbf",12:"ff0000ff2000ff4000ff6000ff8000ff9f00ffbf00ffdf00ffff00ffff2affff80ffffd5"},LastAirBenderFire:{8:"ecb100a100007E605EFF45009948234B4C4E572530000000"},LastAirBenderAir:{7:"ff9933C24841FFFF338B5B4587AFD1EEB05ADBC5A0"},LastAirBenderEarth:{9:"015E05B1A8667A5C1264674225351C4C7022C7C45ED2CFABFEFED8"},LastAirBenderWater:{8:"0047ab1DB4D3A2CAEDAFB5B8120976fffafa174D79949BBC"},SpongeBob:{11:"C86925FDF56CC4433F989B46FC95765D57AFB2CE31FF2027000000B1D6C5AB8323"},Simpsons:{10:"fed90f424f46d1b271FB4122ABC67D0363C37A491E000000FC020946732E"},RickyAndMorty:{9:"01B4C697ce4cFFF874BEE5FDF675DA44281d3a4767F8D3ACE64358"},ParksAndRecreation:{10:"bdbdbda51209ffdb58ec70147A491EC24841005502f7fcb969983ab5651d"},KimPossible:{12:"FF8C0002466370D42389160402001F9CF6F7FFCE455D734DFEC3BB662C9Cfff9f5000000"},GravityFalls:{14:"417BA1ff1493ffff2e3456348b0000ff670093C0D58b45139248A71c88594747478fbc8fd2b48c000000"},GameOfThronesStark:{9:"cadde17B906F174D79fffafa898989D4CDB1708090120976000000"},GameOfThronesStannis:{7:"FF0000ff8d1aFFD700b20000cc6600FFFF66000000"},GameOfThronesLannister:{6:"89080AC5AA73FEDF25C248418B5B45000000"},GameOfThronesTyrell:{9:"068105F7DC27808000AB681BF9FE768DA08071749798FB983CB371"},GameOfThronesTargaryen:{5:"AC1F25272727ff993382878896804b"},GameOfThronesMartell:{8:"ff8000cc6600b81b1873110ff8fc23fafd7b4c2600a57642"},GameOfThronesTully:{6:"212250AE432FE4EDCA8B5B454682B4000000"},GameOfThronesGreyjoy:{6:"000000708090D4CDB1DCDCDCF7DC27808080"},GameOfThronesManderly:{7:"40e0d080808000ff00282828015202195953FFFFFF"},GameOfThronesArryn:{7:"007fff7fbfff0019334c4cffffefb2a89797FFFFFF"},Brooklyn99Regular:{10:"e7298a72bcd4e41a1cFCF40E49f149f16913525252F9FEFF000E33000000"},Brooklyn99Dark:{9:"6CA9C33A3533000E33800000CBCFD2175E78DAA520174D79000000"}};for(var e in CanvasXpress.colorSchemes){for(var f in CanvasXpress.colorSchemes[e]){var c=CanvasXpress.colorSchemes[e][f].match(/.{6}/g);CanvasXpress.colorSchemes[e][f]=c?c.map(function(a){return"#"+a}):[]}}var b=["Viridis","Magma","Plasma","Inferno","Cividis"];var b=["Viridis"];for(var d=0;d<b.length;d++){var e=JSON.parse(JSON.stringify(CanvasXpress.colorSchemes[b[d]]));CanvasXpress.colorSchemes[b[d]+"Inv"]={};for(var f in e){CanvasXpress.colorSchemes[b[d]+"Inv"][f]=e[f].reverse()}}}();CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themeDef={names:["economist","excel","tableau","stata","igray","solarized","paulTol","ggplot","wallStreetJournal","cx","blackAndWhite","lastAirBender","gameOfThrones","none"],axisTickColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],axisTickScaleFontFactor:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],axisTitleColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],axisTitleScaleFontFactor:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],background:["#D5E4EB","rgba(255,255,255,0)","#E5E5E5","#EAF2F3","#E5E5E5","#FDF6E3","rgba(255,255,255,0)","rgb(255,255,255)","#F8F2E4","rgba(255,255,255,0)","rgba(255,255,255,0)","#ECE5D3","rgba(255,255,255,0)","rgba(255,255,255,0)"],backgroundType:["solid","window","window","window","window","solid","solid","window","solid","window","solid","solid","solid","solid"],backgroundWindow:["#D5E4EB","#C0C0C0","rgba(255,255,255,0)","rgba(255,255,255,0)","rgba(255,255,255,0)","#FDF6E3","rgba(255,255,255,0)","#E5E5E5","#F8F2E4","#E8E8E8","rgba(255,255,255,0)","#ECE5D3","rgba(255,255,255,0)","#F4F4F4"],colorScheme:["Economist","Excel","TableauMedium","Stata","GGPlot","Solarized","PaulTol","GGPlot","WallStreetJournal3","CanvasXpress","BlackAndWhite",false,false,"User"],colors:[false,false,false,false,false,false,false,false,false,false,false,false,false,["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"]],fitLineColor:["#FFD700","#FFD700","#FFD700","#FFD700","#0000FF","#FFD700","#FFD700","#0000FF","#FFD700","#FFD700","#000000","#FFD700","#FFD700","#FFD700"],foreground:["#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],guides:[false,false,false,false,false,false,false,true,false,false,false,false,false,false],guidesColor:["#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#FFFFFF","#CCCCCC","#CCCCCC","#FFFFFF","#FFFFFF","#FFFFFF","#CCCCCC"],legendBackgroundBorderColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#000000","#FFFFFF","#000000","#FFFFFF","#FFFFFF","#ECE5D3","#FFFFFF","rgba(255,255,255,0)"],legendBackgroundColor:["#D5E4EB","rgba(255,255,255,0)","rgba(255,255,255,0)","rgba(255,255,255,0)","rgba(255,255,255,0)","rgba(255,255,255,0)","rgba(255,255,255,0)","rgba(255,255,255,0)","#F8F2E4","rgba(255,255,255,0)","rgba(255,255,255,0)","#ECE5D3","rgba(255,255,255,0)","rgba(255,255,255,0)"],legendColumns:[4,1,1,4,1,1,1,1,4,1,1,3,3,1],legendInside:[true,false,false,false,false,false,false,false,true,false,false,false,false,false],legendKeyBackgroundBorderColor:["#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#E5E5E5","#CCCCCC","rgba(0,0,0,0)","#CCCCCC","#CCCCCC","#CCCCCC","rgba(255,255,255,0)"],legendKeyBackgroundColor:["#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#E5E5E5","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","#CCCCCC","rgba(255,255,255,0)"],legendPosition:["top","right","right","bottom","right","right","right","right","top","right","right","bottom","bottom","right"],legendTextColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],legendTextScaleFontFactor:[1,1,1,1,1,1,1,1,1,1,1,1,1,1],legendTitleAlign:["left","left","left","center","center","left","left","left","left","center","center","center","center","center"],lineDecoration:["symbol","symbol","symbol","symbol","symbol","symbol","symbol","symbol","symbol","symbol","pattern","false","false","symbol"],mapOutlineColor:["#D5E4EB","#C0C0C0","#E5E5E5","#EAF2F3","#FFFFFF","#FDF6E3","#FFFFFF","#FFFFFF","#F8F2E4","#CCCCCC","#000000","#333333","#333333","#CCCCCC"],objectBorderColor:["#000000","#000000","#000000","#000000","#000000","#000000","#000000","rgba(0,0,0,0)","#000000","#000000","#000000","#000000","#000000","#000000"],plotBox:[false,false,false,false,false,false,false,false,false,false,true,false,false,true],plotBoxColor:["#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#000000","#337AB7","#000000","#333333","#333333","#337AB7"],showLegendBorder:[false,true,true,true,false,true,false,true,false,true,false,false,false,false],subtitleAlign:["left","left","left","center","center","left","left","left","left","center","center","center","center","center"],subtitleColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],titleAlign:["left","left","left","center","center","left","left","left","left","center","center","center","center","center"],titleColor:["#000000","#000000","#000000","#000000","#000000","#93A1A1","#000000","#000000","#000000","#000000","#000000","#333333","#333333","#000000"],xAxisTickColor:["#000000","#000000","#E5E5E5","#000000","#E5E5E5","#93A1A1","#E5E5E5","#FFFFFF","#000000","#FFFFFF","#000000","#333333","#333333","#CCCCCC"],xAxisTickGuideColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],xAxisTickGuideSize:[1,1,1,1,1,1,1,1,1,1,1,1,1,0.5],xAxisTickLeftColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],xAxisTickLeftShow:[false,true,true,true,false,true,false,true,false,true,true,true,true,true],xAxisTickLeftSize:[1,1,1,2,1,2,1,1,1,1,1,1,1,0.5],xAxisTickLineType:["solid","solid","solid","solid","solid","solid","solid","solid","dotted","solid","dotted","solid","solid","solid"],xAxisTickRightColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],xAxisTickRightShow:[false,true,true,false,false,false,false,false,false,true,true,true,true,true],xAxisTickRightSize:[1,1,1,2,1,2,1,1,1,1,1,1,1,0.5],xAxisTickSize:[2,1,1,1,1,1,1,1,2,1,1,1,1,0.5],xAxisTicksMajorShow:[false,false,true,false,true,true,true,true,false,true,true,true,true,true],xAxisTicksMinorShow:[false,false,false,false,false,false,false,false,false,false,true,true,true,true],yAxis2Show:[true,false,false,false,false,false,false,false,false,false,false,false,false,false],yAxisShow:[false,true,true,true,true,true,true,true,true,true,true,true,true,true],yAxisTickBottomColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],yAxisTickBottomShow:[true,true,true,true,false,true,false,true,true,true,true,true,true,true],yAxisTickBottomSize:[1,1,1,1,1,2,1,1,1,1,1,1,1,0.5],yAxisTickColor:["#FFFFFF","#000000","#E5E5E5","#EAF2F3","#E5E5E5","#93A1A1","#E5E5E5","#FFFFFF","#000000","#FFFFFF","#000000","#333333","#333333","#CCCCCC"],yAxisTickGuideColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],yAxisTickGuideSize:[1,1,1,1,1,1,1,1,1,1,1,1,1,0.5],yAxisTickLineType:["solid","solid","solid","solid","solid","solid","solid","solid","dotted","solid","dotted","solid","solid","solid"],yAxisTickSize:[2,1,1,1,1,1,1,1,2,1,1,1,1,0.5],yAxisTickTopColor:["#000000","#000000","#E5E5E5","#000000","#000000","#93A1A1","#E5E5E5","#FFFFFF","#000000","#337AB7","#000000","#333333","#333333","#CCCCCC"],yAxisTickTopShow:[false,true,true,false,false,false,false,false,false,true,true,true,true,true],yAxisTickTopSize:[1,1,1,1,1,2,1,1,1,1,1,1,1,0.5],yAxisTicksMajorShow:[true,true,true,true,true,true,true,true,true,true,true,true,true,true],yAxisTicksMinorShow:[false,false,false,false,false,false,false,false,false,false,true,true,true,true],conditional:[{OneDPlots:{xAxisTicksMajorShow:true}},{OneDPlots:{xAxisTicksMajorShow:true}},false,{OneDPlots:{xAxisTicksMajorShow:true}},false,false,false,false,{OneDPlots:{xAxisTicksMajorShow:true}},{OneDPlots:{plotBox:true,plotBoxColor:"#337AB7"}},false,false,false,false]};CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.digest=["01ad3bac51927a9cfe61bf4c94d9ef67","022f2967c4eb1963cd19099bdb7612e6","02d8d5ee5ef414f003e1e479b9b16d63","036a7f3e0f7baa9b7edfcddd2f78d0d6","0727931d16db9cb7dd43c58cec656ff0","0a5ecc11d1e7c1dd2b21fafd3d6f7c3a","10bb1efaa5b220d37650a78724b7b8ee","1afe97e0fc2be2cc1aefe2e14211b656","1b4d33e8ec0742ef1361700ddc785101","2499416751d56c5b3adc30d8f0a9ea04","24eb1b476ab74768de47482358b929e3","25ebeece10cd6266c5ae14e987ebb04e","260fc353429f9e864edee16ada13d684","2824e112a49fabc50aaf053e8082e18e","2d1afcbf46de43951597713ce0b85a82","2e680a84fb255f43bb3f7dfabad2501f","2e87945a2c2f0cdd71a39f4d5faae062","3070c85359bbb6151e14c2a66499fc38","3321ee242a13187dab3139d48750804b","386af7c0f5d61e83a110d2fd048d0e06","3a22481182a7645829918e578511afd7","3e7eeba6d127330b1f530ec392ef03ee","442dd7cf7597050dd151b4cd1ba75a0b","457c055d4bb65d66cd79b03fa9a3709b","45b8eee4c9c5ac984ec96e7bd01850b5","475c2fa959287f3908fc758715a3cc74","4c4a43d24c442a62039fc1dc643fe8d8","4da8a169be9dc869b89474edc9731b6d","528e7323e039ca9b9fa15be6f0b257c5","576b39ea6f02a075fbd160ea89de0779","62cb7ceb09730325cdf49cf5f32c3130","65f72c6d06e8b5f1e8eabf7e0666aa43","6767d64025fd9c9de1c97a051f843836","6910ab48318ff59d8dc5adf9917838b6","711b128f3569859334fbc4677fd98106","738ae468be23ee0f9e23f4d5e939a2fd","74a69cffa7e42ed81d122f0fe7bcb47d","79242afd417c42ceaa6e0319d7252f91","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7c1368cdbc23988b15934bf7655c765b","7ccd3079636ba799476de13cd4c77f9c","7d04ef97cbee88e7f42034b17fc7dca3","7ec5e7417a1c59001b06727924db4638","82da1383d8a842023c05e7b5d6bb4d81","85ed3561c61e9773884b8f47ff55753f","88257d4ab616aca3627a7de96dcd618f","8adbcc225ef75c70cf72dd5df586fb1d","8af6a582f98d845800be2df63642d7c0","8e4985da2c4fad1add518a836d7c4d40","8e550d571260863fcccc61f83945796e","8f08c804a90a018b2dba23e82c2d3f08","909d941034f551a6dcf21b33214a5778","911d4c68a9f3816a2e9b033a03afe87c","943c4b6b7418a276de73288040b2a9a8","947a33d5f1a9ff97e682d092346a6b66","978cd8d707805f416d49865443ed7165","97e5ed5a8320a3a979b0b981a5ec4480","9992c7b72ef9d41ad134df8dceff17ec","9ab423e4984faf95f6dd6962fc069ff2","9aef8ce26a6922de0b1112ed9c975bba","9e7870f75b6b44ef4759862cd0545ecd","a0f11947c4e64619dea0fff4680fed10","a109370398c952eac925451a1c82864f","a216c00becff4cf9d9b189e332543359","a3c91fe5638c96e1fe6dd50debd0ecd5","a5d4c490dcb92fef1e61180bc90999ea","a640817ae7cf1a1c9a80e22cd96cdda8","a8f404e4efb2e9382d9800e38c0edf32","a972a3109b54e61161c43aa61e888742","b007c8c9f7fe26412d62e54fadd638c8","b02d4817aaf1a52ecfb256ce6ff7dcb4","c0bf6813fb45d2d345de1bb5f678a387","d1a07842a30b036ea25cadcc828d6b3b","d34a8703b19c4292f746261158041c4c","d5706ba31d22edbe1aeca42072ff1aa6","dcc06c6cb6db587baf04451c4a478b3c","dd0a12e1cd1cd4cc613cefc89f4d3953","df1ee0f2216be2566a581c7cad6b1d4c","e1a3b09d9ff9f1b1553cc9229debd5d6","e21493cacab99c7a32a0237c4f02be3d","f0132183abc2d8e6221b5c52cb4f8f9f","f33ec07e84ab6e48cd39901f011ce320","f3b68ea6f4d49f733f8645fc8551386e","fad209eec2855ebbef1c7d897be731a2"];CanvasXpress.prototype.initDOM=function(){this.$=function(id){return window.document.getElementById(id)};this.$cX=function(t,p,s){var e=window.document.createElement(t);if(p){for(var i in p){e[i]=p[i]}}if(s){for(var i in s){e.style[i]=s[i]}}return e};this.$cXI=function(f,a,o,m,j){try{CanvasXpress}catch(e){return false}var b=document.createElementNS("http://www.w3.org/2000/svg","svg");var e=function(q){var k={};var i=q.split(/class=/);var t="<style>";for(var u=1;u<i.length;u++){var p=i[u].match(/"(.+?)"/);if(p){var s=p[1].split(/\s+/);for(var r=0;r<s.length;r++){var d=s[r];if(CanvasXpress.icons.classes.hasOwnProperty(d)&&!k.hasOwnProperty(d)){t+="."+d+CanvasXpress.icons.classes[d]}}}}t+="</style>";return t};if(CanvasXpress.icons.use.hasOwnProperty(f)){var h='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(f)){h+=CanvasXpress.icons.gradients[f].replace(/&quot;/g,'"')}for(var g=0;g<CanvasXpress.icons.use[f].length;g++){h+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[f][g]].replace(/&quot;/g,'"').replace(/&apos;/g,"'")}var l=e(h);if(!j){j=24}b.setAttribute("xmlns","http://www.w3.org/2000/svg");b.setAttribute("viewBox","0 0 100 100");b.setAttribute("style","width:"+j+"px;height:"+j+"px;box-sizing:border-box;");if(a){for(var g in a){if(g=="className"){b.setAttribute("class",a[g])}else{b.setAttribute(g,a[g]);if(g=="title"){b.setAttribute("title",a[g])}}}}if(o){for(var g in o){b.style[g]=o[g]}}b.innerHTML=l+h}return m?new XMLSerializer().serializeToString(b):b};this.$cXIU=function(b,e,a,l){try{CanvasXpress}catch(f){return false}var j="";var d=function(p){var n={};var k=p.split(/class=/);var s="<style>";for(var t=1;t<k.length;t++){var o=k[t].match(/"(.+?)"/);if(o){var r=o[1].split(/\s+/);for(var q=0;q<r.length;q++){var i=r[q];if(CanvasXpress.icons.classes.hasOwnProperty(i)&&!n.hasOwnProperty(i)){s+="."+i+CanvasXpress.icons.classes[i]}}}}s+="</style>";return s};if(b&&CanvasXpress.icons.use.hasOwnProperty(e)){var g='<rect class="cxnc" x="0" y="0" width="100" height="100" />';if(CanvasXpress.icons.gradients.hasOwnProperty(e)){g+=CanvasXpress.icons.gradients[e].replace(/&quot;/g,'"')}for(var f=0;f<CanvasXpress.icons.use[e].length;f++){g+=CanvasXpress.icons.symbols[CanvasXpress.icons.use[e][f]].replace(/&quot;/g,'"').replace(/&apos;/g,"'")}var h=d(g);if(a){for(var f in a){if(f=="className"){b.setAttribute("class",a[f])}else{b.setAttribute(f,a[f]);if(f=="title"){j="<title>"+a[f]+"</title>"}}}}if(l){for(var f in l){b.style[f]=l[f]}}b.innerHTML=j+h+g}};this.$p=function(s){var t=this;var w=window;var q=t.$w;var p=t[q(0)];var u=t[q(0,true)];var r=s?p:!p?false:!u;if(w[q(8)][q(15)]&&!w[q(8)][q(15)].length){if(t.$v()){r=true}}if(!s&&r){w[q(40)]=function(){return false}}return r};this.$pX=function(c){var t=this;var q=t.$w;var p=t.$(t.target+q(2));if(c&&p){var x=t[q(0)];if(x){var e=t[q(10)](x);if(e==p.value){t[q(0,true)]=true;return true}else{return false}}else{return false}}else{if(p&&p.value!=""){var e=t[q(9)](p.value);t[q(0)]=e;t[q(0,true)]=true;return e}else{return false}}};this.xQ=function(s){var h="";for(var i=0;i<s.length;i++){h+=""+s.charCodeAt(i).toString(16)}return h};this.$h=function(h){var s="";for(var i=0;i<h.length;i+=2){s+=String.fromCharCode(parseInt(h.substr(i,2),16))}return s};this.$w=function(i,n){try{CanvasXpress}catch(e){return false}var q=this.$h||CanvasXpress.instances[0].$h;return i>50?CanvasXpress.colorWords[i]:n?q(CanvasXpress.colorWords[i].split("").reverse().join("")).split("").reverse().join(""):q(CanvasXpress.colorWords[i].split("").reverse().join(""))};this.Ux=function(){try{CanvasXpress}catch(f){return false}if(CanvasXpress.instances.length==1){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:(window.navigator.onLine?"https://www.canvasxpress.org/assets/images/beacon.gif?"+CanvasXpress.factory.client:CanvasXpress.png),title:"",alt:""})}else{this.beaconImage=CanvasXpress.instances[0].beaconImage}};this.$$=function(){try{CanvasXpress}catch(f){return false}var o=this;var j=CanvasXpress;var g=function(i){if(!i){i=j[h[4]]}else{if(i.length>36){return 0}}var c=i.length;var f=Number(i.substring(2,3));var d=Number(i.substring(c-3,c-2));var q=i.substring(3+f,3+f+5)[h[7]]("")[h[8]]()[h[9]]("");var m=i.substring(c-(3+d+5),c-(3+d));return Number(q+""+m+"000")};var l=["686578546f537472696e67","6472617754657874","666163746f7279","73797374656d","72656769737465726564","76616c6964","737562737472696e67","73706c6974","72657665727365","6a6f696e","43616e766173587072657373","4e6f7420612076616c696420636f7079206f6620","556e737570706f727465642056657273696f6e206f6620","20522056657273696f6e","204e6f64652056657273696f6e","697352566965776572","697352436f6e736f6c65","68726566","2f7777772e63616e7661737870726573732e6f72672f646973742f","72616e646f6d496e744265747765656e","666f6e7453697a65","666f6e744e616d65","69734378706c6f74","6378706c6f742042792043616e766173587072657373","736574506978656c496d616765","64697361626c65426561636f6e"];var h=[];for(var e=0;e<l.length;e++){h.push(o.$h(l[e]))}var a=Number(g());var p=Number(o.meta.time.start);var n=isNaN(j[h[2]][h[5]])?Number(g(j[h[2]][h[5]])):0;var k=new RegExp(h[18]).test(j[h[2]][h[17]])||j[h[3]][h[15]]||j[h[3]][h[16]];var b=o[h[22]]?h[23]:h[10];if(!k){if(a-p<0){if(!n||n-p<0){if(j[h[2]][h[5]]){b=h[11]+h[10]}setTimeout(function(){o.$$$(b)},o[h[19]](1,3)*1000)}}}};this.$$$=function(m){var t=this;var w=["6472617754657874","666f6e744e616d65"];var d=[];var s=Math.min(t.width,t.height);var f=s>1200?24:s>800?20:s>500?16:s>300?12:8;var n=Number(t.meta.time.start);var h=t[d[1]]=="rgba(0,0,0,0)";for(var i=0;i<w.length;i++){d.push(t.$h(w[i]))}var a=f+"px "+t[d[1]];if(n%2||h){t[d[0]](m,t.width-(f/2.66),t.height-(f/1.66),a,"rgba(0,0,0,1)","right","middle")}else{t[d[0]](m,t.width-(f/1.33),t.height-f,a,"rgba(0,0,0,1)","left","middle",-Math.PI/2)}};this.$v=function(){var t=this;var w=window;var d=[];var q=t.$w;var x=w[q(8)][q(14)];for(var i in w[q(8)][q(30)]){if(i!="init"){d.push(t[q(12)](w[q(8)][q(30)][i].toString()))}}d=d.sort();t.notice={d:d,x:x};for(var i=0;i<d.length;i++){if(d[i]!=x[i]){return false}}return true};this.HV=function(){var c=this.$(this.target);var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.height=parseInt((c.height/2)-100.5)+"px";l.style.display="block"}};this.Jb=function(){var l=this.$(this.target+"canvasXpressLoadingTimer");if(l){l.style.display="none"}this.loaded=true;this.$$()};this.$b=function(){var t=this;var q=t.$w;var w=window;var s=w[q(8)][q(6)];if(!s[q(46)]&&!s[q(47)]){t[q(44)](q(4),19,0,"38px Arial",t[q(45)],"left","top",Math.PI/4);setTimeout(function(){delete w[q(8)];delete t},1)}};this.kX=function(){var c=this.$cX("canvas").setAttribute("id",this.Ph("-canvasXpress-"));window.document.body.appendChild(c);return c.id};this.Ph=function(t,f){var n=0;var i=this.target+t+n;while(this.meta.ids[i]){n++;i=this.target+t+n}this.meta.ids[i]=true;return f?n:i};this.bD=function(t,p,w,h,a){if(t&&p){var c=this.$(t);if(c){return}else{c=this.$cX("canvas",{id:t,width:w,height:h});this.cg(c)}if(a){p.parentNode.insertBefore(c,p.nextSibling)}else{p.parentNode.insertBefore(c,p)}}};this.cg=function(c,e){if(!e){e=this.meta.canvas.ctx.canvas}CanvasXpress.transferDatasetAttributes(e,c)};this.Ab=function(t){var n=this.$(t);if(n){n.parentNode.removeChild(n)}};this.HJ=function(){var doc=window.document;var w=window.innerWidth||doc.documentElement.clientWidth||doc.body.clientWidth;var h=window.innerHeight||doc.documentElement.clientHeight||doc.body.clientHeight;return[w,h]};this.zV=function(){var d=window.document.documentElement;var l=(window.pageXOffset||d.scrollLeft)-(d.clientLeft||0);var t=(window.pageYOffset||d.scrollTop)-(d.clientTop||0);return[l,t]};this.hW=function(el,d){var w=this.HJ();var b=el.getBoundingClientRect();var c=b.right-(this.width*0.5);var m=b.bottom-(this.height*0.5);return b.left>=0&&b.top>=0&&c<=w[0]&&m<=w[1]};this.qO=function(e,n){return e?e.classList.contains(n):false};this.Qs=function(e,n){if(e){e.classList.add(n)}};this.uz=function(e,n){if(e){e.classList.remove(n)}};this.jK=function(e){var s="";var o=getComputedStyle(e);for(var i=0;i<o.length;i++){s+=o[i]+":"+o.GF(o[i])+";"}return s};this.$d=function(){var t=this;var q=t.$w;var w=window;var e=t.url&&t.url.hasOwnProperty("cXD")&&t.url.cXD==w[q(8)][q(49)];Error.stackTraceLimit=0;(function(){var z=w[q(8)][q(6)];if(!z[q(46)]&&!z[q(47)]&&!e){var o=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&t.$b()}},message:{get:function(){t.$b()}}});var $cl=w[q(8)][q(31)][q(32)];setTimeout($cl.bind(w[q(8)][q(31)],"%c",o))}}())};this.HH=function(e){if(!e){return}try{CanvasXpress}catch(f){e.preventDefault();e.stopPropagation();return false}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(e.preventDefault){e.preventDefault()}else{e.returnValue=false}}};this.cR=function(e){if(!e){return}if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=true}};this.Ho=function(e){return CanvasXpress.system.isIE?"on"+e:e};this.H2=function(el,type){if("createEvent" in document){var e=document.createEvent("HTMLEvents");e.initEvent(type,false,true);el.dispatchEvent(e)}else{var e=document.createEventObject();e.eventType=type;el.fireEvent("on"+e.eventType,e)}};this.ud=function(e){var c={};for(var i in e){c[i]=e[i]}return c};this.Nc=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;if(o.id){if(!m[o.id]){m[o.id]={}}m[o.id][e]=[c,f]}else{if(!m[o]){m[o]={}}m[o][e]=[c,f]}if(CanvasXpress.system.isIE){o.attachEvent(this.Ho(e),c)}else{if(e=="mousewheel"){o.addEventListener(e,c,f);o.addEventListener("DOMMouseScroll",c,f)}else{o.addEventListener(e,c,f)}}}};this.rq=function(o,e,c,f){if(o&&(typeof o)=="string"){o=this.$(o)}if(o&&e&&c){var m=this.meta.events;var k=m[o.id||o];if(k&&k.hasOwnProperty(e)){delete (k[e]);if(CanvasXpress.system.isIE){o.detachEvent(this.Ho(e),c)}else{o.removeEventListener(e,c,f);if(e=="mousewheel"){o.removeEventListener("DOMMouseScroll",c,f)}}var v=this.NU(m[o.id||o]);if(v&&v.length<1){delete (m[o.id||o])}}}};this.K6=function(t,o,e,c,f){if(t&&o&&e&&c){this[t](o,e,c,f)}};this.yH=function(){var m=this.meta.events;for(var i in m){var o=this.$(i)||i;for(var e in m[i]){this.rq(o,e,m[i][0],m[i][1])}}};this.qR=function(){var d=window.document;if(d.selection){d.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.B2=function(e){var o=e.target||e.srcElement;if(typeof(o)!="object"){o=this.$(o)}if(o instanceof SVGElement&&o.ownerSVGElement){o=o.ownerSVGElement}return o};this.dispatchEvent=function(l,e){l.dispatchEvent(e)};this.VY=function(c,t){if(c){var r=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame;if(r){r(c)}else{if(!t){t=1000/60}window.setTimeout(c,t)}}};this.setTimeout=function(d,c){if(this.isR){setTimeout(d,c)}else{var a=this;var b=function(e){return new Promise(function(g,f){if(e){setTimeout(g,e)}else{setTimeout(g,1000)}})};b(c).then(function(){d.apply(a)})}};this.Jn=function(c,d){this.T4("canvasXpress setInterval ready - "+arguments.callee.caller.name+" - "+d);return setInterval(c,d)};if(typeof JSON.decycle!=="function"){JSON.decycle=function decycle(object,replacer){var objects=new WeakMap();return(function derez(value,path){var old_path;var nu;if(replacer!==undefined){value=replacer(value)}if(typeof value==="object"&&value!==null&&!(value instanceof Boolean)&&!(value instanceof Date)&&!(value instanceof Number)&&!(value instanceof RegExp)&&!(value instanceof String)){old_path=objects.get(value);if(old_path!==undefined){return{$ref:old_path}}objects.set(value,path);if(Array.isArray(value)){nu=[];value.forEach(function(element,i){nu[i]=derez(element,path+"["+i+"]")})}else{nu={};Object.keys(value).forEach(function(name){nu[name]=derez(value[name],path+"["+JSON.stringify(name)+"]")})}return nu}return value}(object,"$"))}}if(typeof JSON.retrocycle!=="function"){JSON.retrocycle=function retrocycle($){var px=/^\$(?:\[(?:\d+|"(?:[^\\"\u0000-\u001f]|\\([\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*")\])*$/;(function rez(value){if(value&&typeof value==="object"){if(Array.isArray(value)){value.forEach(function(element,i){if(typeof element==="object"&&element!==null){var path=element.$ref;if(typeof path==="string"&&px.test(path)){value[i]=eval(path)}else{rez(element)}}})}else{Object.keys(value).forEach(function(name){var item=value[name];if(typeof item==="object"&&item!==null){var path=item.$ref;if(typeof path==="string"&&px.test(path)){value[name]=eval(path)}else{rez(item)}}})}}}($));return $}}if(!Array.from){Array.from=(function(){var toStr=Object.prototype.toString;var isCallable=function(fn){return typeof fn==="function"||toStr.call(fn)==="[object Function]"};var toInteger=function(value){var number=Number(value);if(isNaN(number)){return 0}if(number===0||!isFinite(number)){return number}return(number>0?1:-1)*Math.floor(Math.abs(number))};var maxSafeInteger=Math.pow(2,53)-1;var toLength=function(value){var len=toInteger(value);return Math.min(Math.max(len,0),maxSafeInteger)};return function from(arrayLike){var C=this;var items=Object(arrayLike);if(arrayLike==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var mapFn=arguments.length>1?arguments[1]:void undefined;var T;if(typeof mapFn!=="undefined"){if(!isCallable(mapFn)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){T=arguments[2]}}var len=toLength(items.length);var A=isCallable(C)?Object(new C(len)):new Array(len);var k=0;var kValue;while(k<len){kValue=items[k];if(mapFn){A[k]=typeof T==="undefined"?mapFn(kValue,k):mapFn.call(T,kValue,k)}else{A[k]=kValue}k+=1}A.length=len;return A}}())}this.uP=function(dom,clbk,self){var resizeObeserver=new ResizeObserver(function(entries){var t=this;entries.forEach(function(entry){clbk(entry,t,self)})});resizeObeserver.observe(dom)};if(!Array.prototype.fill){Object.defineProperty(Array.prototype,"fill",{value:function(value){if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;var start=arguments[1];var relativeStart=start>>0;var k=relativeStart<0?Math.max(len+relativeStart,0):Math.min(relativeStart,len);var end=arguments[2];var relativeEnd=end===undefined?len:end>>0;var finl=relativeEnd<0?Math.max(len+relativeEnd,0):Math.min(relativeEnd,len);while(k<finl){O[k]=value;k++}return O}})}this.$z=function(){var t=this;var w=window;var q=t.$w;Error.stackTraceLimit=0;var a=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&w[q(41)]()}},message:{get:function(){w[q(41)]()}}});var $cl=w[q(31)][q(32)];setTimeout($cl.bind(w[q(31)],"%c",a))};if(typeof Object.assign!="function"){Object.defineProperty(Object,"assign",{value:function assign(target,varArgs){if(target==null){throw new TypeError("Cannot convert undefined or null to object")}var to=Object(target);for(var index=1;index<arguments.length;index++){var nextSource=arguments[index];if(nextSource!=null){for(var nextKey in nextSource){if(Object.prototype.hasOwnProperty.call(nextSource,nextKey)){to[nextKey]=nextSource[nextKey]}}}}return to},writable:true,configurable:true})}if(!Array.prototype.map){Array.prototype.map=function(callback){var T,A,k;if(this==null){throw new TypeError("this is null or not defined")}var O=Object(this);var len=O.length>>>0;if(typeof callback!=="function"){throw new TypeError(callback+" is not a function")}if(arguments.length>1){T=arguments[1]}A=new Array(len);k=0;while(k<len){var kValue,mappedValue;if(k in O){kValue=O[k];mappedValue=callback.call(T,kValue,k,O);A[k]=mappedValue}k++}return A}}if(!Array.prototype.findIndex){Object.defineProperty(Array.prototype,"findIndex",{value:function(predicate){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(typeof predicate!=="function"){throw new TypeError("predicate must be a function")}var thisArg=arguments[1];var k=0;while(k<len){var kValue=o[k];if(predicate.call(thisArg,kValue,k,o)){return k}k++}return -1}})}if(typeof window.CustomEvent!=="function"){window.CustomEvent=function(event,params){params=params||{bubbles:false,cancelable:false,detail:null};var evt=document.createEvent("CustomEvent");evt.initCustomEvent(event,params.bubbles,params.cancelable,params.detail);return evt}}if(!Array.prototype.includes){Object.defineProperty(Array.prototype,"includes",{value:function(searchElement,fromIndex){if(this==null){throw new TypeError('"this" is null or not defined')}var o=Object(this);var len=o.length>>>0;if(len===0){return false}var n=fromIndex|0;var k=Math.max(n>=0?n:len-Math.abs(n),0);function sameValueZero(x,y){return x===y||(typeof x==="number"&&typeof y==="number"&&isNaN(x)&&isNaN(y))}while(k<len){if(sameValueZero(o[k],searchElement)){return true}k++}return false}})}this.uV=function(a,g,c,h,p){var Q="CanvasXpressToggle";var b=this.$cX("div",{className:Q});var d=this.$cX("label",{className:Q});var f=p?this.$cX("input",{className:Q,params:a,type:"checkbox"}):this.$cX("input",{id:a||this.Ph("-cX-Toggle-"),className:Q,type:"checkbox"});if(g){f.checked=true}var e=this.$cX("div",{className:Q+"Switch"});var j=this.$cX("span",{className:Q,innerHTML:c||""});var i=this.$cX("span",{className:Q,innerHTML:h||""});d.appendChild(j);d.appendChild(f);d.appendChild(e);d.appendChild(i);b.appendChild(d);return b};this.et=function(J,p,u,A,r){if(u!=null&&A!=null){u=parseFloat(u);A=parseFloat(A);if(u>A){var G=A;A=u;u=G}}var o=this.ct(u,A,4);u=o[0];A=o[o.length-1];var y=A-u;var a=(((y*1000000)-(parseInt(y)*1000000))/1000000).toString().replace(/\./,"").length-1;var e=Math.pow(1/10,(a+1));var C=u>0?Math.log10(u):u==0?0:null;var E=A>0?Math.log10(A):A==0?0:null;var c=[];var Q="CanvasXpressRangeSlider";if(C!=null&&E!=null){var I=this.ct(C,E,4);for(var B=0;B<I.length;B++){c.push(this.qo((Math.pow(10,I[B])),a))}c=this.Z0(c)}var b=this.$cX("div",{className:Q+"Container"},{width:r+"px"});var m=this.$cX("div",{className:Q+"ContainerTop"});var g=this.$cX("div",{className:Q+"ContainerTop"},{width:"50%"});var z=this.$cX("span",{className:Q+"ContainerTop",innerHTML:J});var x=this.uV(p+"LinLog",true,"Log","Lin");var F=this.$cX("div",{className:Q+"ContainerBottom"});var t=this.$cX("input",{id:(p+"Min")||this.Ph("-cX-RangeSliderMin-"),className:Q,type:"range",min:u,max:A,value:u,step:e});var w=this.$cX("input",{id:(p+"Max")||this.Ph("-cX-RangeSliderMax-"),className:Q,type:"range",min:u,max:A,value:A,step:e});var f=this.$cX("input",{id:(p+"InputMin")||this.Ph("-cX-RangeSliderInputMin-"),className:Q+"Min",type:"number",min:u,max:A,value:u,step:e});var h=this.$cX("input",{id:(p+"InputMax")||this.Ph("-cX-RangeSliderInputMax-"),className:Q+"Max",type:"number",min:u,max:A,value:A,step:e});var l=this.$cX("div",{className:Q+"Input"});var s=this.$cX("div",{className:Q});var q=this.$cX("div",{className:Q+"Track"});var n=this.$cX("div",{className:Q+"Range"});var k=this.$cX("div",{className:Q+"ThumbLeft"});var d=this.$cX("div",{className:Q+"ThumbRight"});var H=this.$cX("div",{className:Q+"Ticks"});var D=this.$cX("div",{className:Q+"Ticks"},{display:"none"});for(var B=0;B<o.length;B++){H.appendChild(this.$cX("span",{className:Q+"TicksLong",innerHTML:o[B]}));if(B<o.length-1){for(var v=0;v<4;v++){H.appendChild(this.$cX("span",{className:Q+"Ticks",innerHTML:""}))}}}for(var B=0;B<c.length;B++){D.appendChild(this.$cX("span",{className:Q+"TicksLong",innerHTML:c[B]}));if(B<c.length-1){for(var v=0;v<4;v++){D.appendChild(this.$cX("span",{className:Q+"Ticks",innerHTML:""}))}}}if(C==null||E==null){x.style.display="none"}g.appendChild(z);m.appendChild(g);x.firstChild.firstChild.nextSibling.tickLinear=H;x.firstChild.firstChild.nextSibling.tickLog=D;x.firstChild.firstChild.nextSibling.minRange=t;x.firstChild.firstChild.nextSibling.maxRange=w;m.appendChild(x);f.minRange=t;h.maxRange=w;l.appendChild(f);l.appendChild(h);t.decs=a;t.minInput=f;t.maxRange=w;t.minThumb=k;t.range=n;t.linLog=x.firstChild.firstChild.nextSibling;w.decs=a;w.maxInput=h;w.minRange=t;w.maxThumb=d;w.range=n;w.linLog=x.firstChild.firstChild.nextSibling;s.appendChild(q);s.appendChild(n);s.appendChild(k);s.appendChild(d);F.appendChild(l);F.appendChild(t);F.appendChild(w);F.appendChild(s);F.appendChild(H);F.appendChild(D);b.appendChild(m);b.appendChild(F);return b};this.AL=function(){try{return window.self!==window.top}catch(e){return true}};this.Cb=function(){var t=this;var w=window;var q=t.$w;Error.stackTraceLimit=0;var $d=function(){var a=w[q(38)][q(35)](new Error,{toString:{value:function(){(new Error).stack.includes(q(42))&&t.$b()}},message:{get:function(){t.$b()}}});var $cl=w[q(8)][q(31)][q(32)];setTimeout($cl.bind(w[q(8)][q(31)],"%c",a))};var $v=function(){var c=w.navigator.userAgent;var b;var a=c.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(a[1])){b=/\brv[ :]+(\d+)/g.exec(c)||[];return"IE "+(b[1]||"")}if(a[1]==="Chrome"){b=c.match(/\b(OPR|Edge)\/(\d+)/);if(b!=null){return b.slice(1).join(" ").replace("OPR","Opera")}}a=a[2]?[a[1],a[2]]:[w.navigator.appName,w.navigator.appVersion,"-?"];if((b=c.match(/version\/(\d+)/i))!=null){a.splice(1,1,b[1])}return a.join(" ")};var $o=function(){var e=w.navigator.userAgent;var a=w.navigator.platform;var f=["Macintosh","MacIntel","MacPPC","Mac68K"];var b=["Win32","Win64","Windows","WinCE"];var c=["iPhone","iPad","iPod"];var d=null;if(f.indexOf(a)!==-1){d="Mac OS"}else{if(c.indexOf(a)!==-1){d="iOS"}else{if(b.indexOf(a)!==-1){d="Windows"}else{if(/Android/.test(e)){d="Android"}else{if(!d&&/Linux/.test(a)){d="Linux"}}}}}return d};var s=$v().split(" ");var o=$o();w[q(8)][q(31)]=w[q(8)][q(31)]||w[q(31)];w[q(8)][q(6)]={browser:s[0],browserVersion:s[1],os:o,alt:(o=="Mac OS"?"&#8997;":"Alt"),command:"&#8984;",control:(o=="Mac OS"?"&#8963;":"Ctrl"),shift:(o=="Mac OS"?"&#8679;":"Shift"),isNode:typeof exports==="object"&&typeof module!=="undefined",isReact:typeof React!="undefined",isHeadless:(this.url&&this.url.hasOwnProperty("cXD")&&this.url.cXD==w[q(8)][q(49)])||w.navigator.webdriver,isjQuery:typeof $==="function",isReveal:typeof Reveal!="undefined",isZoom:typeof zoom!="undefined",isIE:this.browser=="IE"?true:false,isInIframe:(s[0].match(/safari/i)?true:this.AL())};var z=w[q(8)][q(6)];if(!z[q(46)]&&!z[q(47)]){if(!z[q(48)]){}$d()}}};CanvasXpress.prototype.initSVG=function(){function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}var a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);var j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};var i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};var e=function(m,l){this.__root=m;this.__ctx=l};var k=function(n){var l={width:500,height:500,desc:"",enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.desc=m.desc||l.desc;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__root.setAttribute("desc",this.desc);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};this.BO=k};CanvasXpress.prototype.initInterface=function(){this.wT=function(b){return function(e){b.It();var k=e.target.files[0];var i=k.type;var l=k.name.split(".");var a=new FileReader();var j=l.pop();if(j=="json"){a.onload=function(){try{var c=b.c9(a.result);b.PI();b.layoutValid=false;for(var p in c.config){b[p]=c.config[p]}if(c.afterRender){for(var f=0;f<c.afterRender.length;f++){var g=c.afterRender[f];var d=g[0];var h=g[1]||[];b[d].apply(b,h)}}else{b.j8({func:"loadParamsFile",par:(r)})}}catch(r){alert("Oooops! Not a valid CanvasXpress json parameter file")}};a.readAsText(k)}else{alert("Oooops! Not a valid CanvasXpress json parameter file")}}}(this);this.hU=function(d){var g=[];var f=[];var h=[];var c=[];for(var b=0;b<d.links.length;b++){var a=d.links[b];if(a.source&&a.target&&a.value){h.push(a.source);c.push(a.target);f.push(a.value);g.push("Smp"+(b+1))}}var e={y:{vars:["Weight"],smps:g,data:[f]},x:{Source:h,Target:c}};return{renderTo:"newSankey",data:e,config:{graphType:"Sankey",sankeySource:"Source",sankeyTarget:"Target"}}};this.C6=function(a){var b=this;var c=function(k){var w=0;var g=[];var q=[];var e={};var C=function(f,j,l,i){return Array.prototype.concat.apply(f.map(function(m){if(!e.hasOwnProperty(m.name)){e[m.name]=0}e[m.name]++;if(e[m.name]>1){m.name+=e[m.name]}var p=b.ZD(m);p.level=l||1;p.parent=i||null;return p}),f.map(function(m){w=Math.max(w,(l||1)+1);if(!m.children){g.push(m.name);q.push(m.value||1)}return C(j(m)||[],j,(l||1)+1,m.name)}))};var d=function d(f){return f.children||null};var h=C(d(k),d).map(function(f){f.n=f.children?f.children.length:0;return delete f.children&&f});var B={y:{vars:["Dummy"],smps:g,data:[q]},x:{}};for(var x=0;x<B.y.smps.length;x++){for(var v=0;v<h.length;v++){if(!h[v].n&&B.y.smps[x]==h[v].name){h[v].smp=x;break}}}var n=[];var z=a.name;B.x[z]=[];n.push(z);for(var x=2;x<w-1;x++){B.x[z+x]=[];n.push(z+x)}var A={};for(var x=0;x<h.length;x++){A[h[x].name]=x}for(var x=0;x<n.length;x++){for(var v=0;v<B.y.smps.length;v++){B.x[n[x]][v]=null}}for(var x=0;x<h.length;x++){if(h[x].parent){var r=h[x].parent;var t=A[r];var o=h[x].smp;var u=h[x].level-1;var y=h[t].parent;B.x[z+(u>1?u:"")][o]=h[t].name;while(y){t=A[y];u=h[t].level;B.x[z+(u>1?u:"")][o]=h[t].name;y=h[t].parent}}}return{renderTo:"newTree",data:B,config:{graphType:"Tree",hierarchy:n}}};return c(a)};this.sO=function(b){return function(q,y,a,r){b.It();b.HV();var t=function(c){if(c.config&&c.config.backgroundImage&&!Array.isArray(c.config.backgroundImage)&&c.config.backgroundImage.match(/^javascript:\/\//)&&c.config.backgroundImageSrc){var d=new Image();d.id=c.config.backgroundImage.split("//")[1];d.style.display="none";d.src="data:image/png;base64,"+atob(c.config.backgroundImageSrc);document.body.appendChild(d);CanvasXpress.cacheImages[b.SZ(d.src)]=d}else{if(c.config&&c.config.backgroundImage&&Array.isArray(c.config.backgroundImage)){c.config.backgroundImageMD5=b.s8(c.config.backgroundImage);var d=new Image();d.onload=function(){CanvasXpress.cacheImages[c.config.backgroundImageMD5]=this};d.crossOrigin="anonymous";d.src=b.Bg(c.config.backgroundImage)}}};var v=r?r:q.target?q.target.files[0]:q.files[0];var f=v.type;var x=v.name.split(".");var s=new FileReader();var e=window;if(f=="image/png"){var u=function(g,h){var c="";for(var d=0;d<4;d++){c+=String.fromCharCode(g.getUint8(h+d))}return c=="tEXt"};var w=function(d,h,i){var c="";for(var g=0;g<i;g++){c+=String.fromCharCode(d.getUint8(h+g))}return c.match(/CanvasXpress/)};s.onload=function(){var m=new DataView(this.result);var g=m.getUint32(8);var h=m.getUint32(8+4+4+g+4);if(u(m,8+4+4+g+4+4)&&w(m,8+4+4+g+4+4+4,h)){var n=m.getUint32(8+4+4+g+4+4+4+h+4);var l=8+4+4+g+4+4+4+h+4+4+4;var c="";for(var d=0;d<n;d++){c+=String.fromCharCode(m.getUint8(l+d))}c=c.replace("ReproducibleResearch\0","");var k;try{k=b.c9(decodeURIComponent(c))}catch(j){k=b.c9(c)}var i=b.$w;if(k.config[i(0)]&&CanvasXpress[i(6)][i(7)]){if(b.$v()){e[i(29)](i(4));k={}}else{delete e[i(8)];return true;k={}}}else{if(k.config[i(0)]){k.data=b.$v()?b.c9(b[i(10)](k.data)):{}}}if(y){return k}t(k);if(k.hasOwnProperty("config")){delete (k.config.remoteService)}b.Dz(k,a);b.Jb()}else{b.Jb();b.backgroundImage="data:image/png;base64, "+b.hr(this.result);b.O1({func:"changeAttribute",par:["backgroundImage",b.backgroundImage]});b.backgroundType="image";b.O1({func:"changeAttribute",par:["backgroundType","image"]});b.skipStack=true;b.j8();b.skipStack=false;alert("Oooops! Not a valid CanvasXpress Image\nUsing image as background!")}};s.readAsArrayBuffer(v)}else{if(f=="application/x-bzip2"){s.onload=function(){var c=b.yi(this.result);if(x[1].match(/ml$/)){try{CanvasXpress.loadRemoteData(x[0],c,false,false,b.updateRemoteData)}catch(d){b.Jb();alert("Oooops! Not a valid bz2 file for CanvasXpress")}}else{b.Jb();alert("Oooops! Not a valid bz2 file for CanvasXpress")}};s.readAsBinaryString(v)}else{var z=x.pop();if(z=="cxj"){s.onload=function(){try{var c=b.c9(s.result);if(c.tabs&&c.ref){var m=c.tabs[c.ref[0]].rows[c.ref[1]].cels[c.ref[2]].content;var j=function(){b.MB(c)};t(m);if(m.data||(m&&m.config&&m.config.graphType&&m.config.graphType=="Map")){if(m.config.topoJSON){if(m.config.mapId){delete window[m.config.mapId];delete b.meta.map;delete b.topoJSON}}b.Dz(m,j);b.Jb()}else{if(m.config){b.PI();b.layoutValid=false;for(var d in m.config){b[d]=m.config[d]}if(m.afterRender){for(var l=0;l<m.afterRender.length;l++){var n=m.afterRender[l];var h=n[0];var g=n[1]||[];b[h].apply(b,g)}j()}else{b.j8({func:"loadFile",par:[k,false,j]})}}else{var i=m.error.error}}}else{var i=m.error.error}}catch(k){b.Jb();alert("Oooops! Not a valid CanvasXpress tab panel file")}}}else{if(z=="json"){s.onload=function(){try{var m=b.c9(s.result);t(m);if(m.data||(m&&m.config&&m.config.graphType&&m.config.graphType=="Map")){if(m.config.topoJSON){if(m.config.mapId){delete window[m.config.mapId];delete b.meta.map;delete b.topoJSON}}b.Dz(m,a);b.Jb()}else{if(m.config){b.PI();b.layoutValid=false;for(var d in m.config){b[d]=m.config[d]}if(m.afterRender){for(var l=0;l<m.afterRender.length;l++){var c=m.afterRender[l];var h=c[0];var g=c[1]||[];b[h].apply(b,g)}}else{b.j8({func:"loadFile",par:[k,y,a,r]})}}else{if(m.children&&m.children.length){m=b.C6(m);b.Dz(m,a);b.Jb()}else{if(m.nodes&&m.links){m=b.hU(m);b.Dz(m,a);b.Jb()}else{if(m.type&&m.type.match(/FeatureCollection|Topology/)){var j={data:false,config:{graphType:"Map",topoJSON:m,mapId:"cXMap"}};window.cXMap=m;b.U2(j);b.Jb()}else{var i=m.error.error}}}}}}catch(k){b.Jb();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(z=="geojson"){s.onload=function(){try{var i=b.c9(s.result);b.bO(b.ZD(b.data.y.vars),true);var c=b.ZD(b.data);for(var d=0;d<i.features.length;d++){c.y.vars[d]="Id"+(d+1);c.y.data[d]=[];c.y.data[d][0]=0}if(i.type&&i.type.match(/FeatureCollection|Topology/)){var h={data:c,config:{graphType:"Map",topoJSON:i,mapId:"cXMap"}};window.cXMap=i;b.U2(h);b.Jb()}}catch(g){b.Jb();alert("Oooops! Not a valid geojson file")}}}else{if(z=="svg"){s.onload=function(){try{var d=b.we(s.result);var g=b.$w;if(d.config[g(0)]&&CanvasXpress[g(6)][g(7)]){e[g(29)](g(4));d={}}else{if(d.config[g(0)]){d.data=b.c9(b[g(10)](d.data))}}b.Dz(d,a);b.Jb()}catch(c){b.Jb();alert("Oooops! Not a valid CanvasXpress json file")}}}else{if(z=="txt"||z=="csv"||z=="tsv"||z=="tab"){s.onload=function(){try{var c=s.result;var g;if(b.graphType=="Network"){g=b.dL(b.af(c),false,false,false,b.data);if(g&&!b.pe(g)){var h="";if(g.fail>0){h=g.fail+" records couldn't be mapped to network data"}alert(g.rows+" "+g.type+" records added to network data\n"+h);if(g.type=="node"){b.CR(g.data)}else{b.Gr(g.data)}b.Jb();return}else{g=b.wD(g)}}else{g=b.JA(b.af(c),b.graphType=="Map");if(g&&!b.pe(g)){if(g.addt){alert(g.recs+" records added as an additional data set\n")}else{alert(g.recs+" records added to meta data\n")}b.Yd(g.data,g.addt);b.Jb();return}else{g=b.wD(g)}}g.renderTo=x[0].replace(/\s/g,"").replace(/\(/g,"").replace(/\)/g,"");b.Dz(g,a);b.Jb()}catch(d){b.Jb();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(z=="esv"){s.onload=function(){try{var c=s.result;var g=b.dL(b.af(c),false,false,false,b.data,"edge");g.renderTo=x[0];b.Dz(g,a);b.Jb()}catch(d){b.Jb();alert("Oooops! Not a valid CanvasXpress delimited file")}}}else{if(z=="gml"){s.onload=function(){try{var d=b.FV(s.result);d.renderTo=x[0];b.Dz(d,a);b.Jb()}catch(c){b.Jb();alert("Oooops! Not a valid gml file for CanvasXpress")}}}else{if(z.match(/ml$/)||z=="gexf"){s.onload=function(){try{CanvasXpress.loadRemoteData(x[0],s.result,false,false,b.updateRemoteData)}catch(c){b.Jb();alert("Oooops! Not a valid "+z+" file for CanvasXpress")}}}}}}}}}}s.readAsText(v)}}}}(this);this.R0=function(a){return function(k,i){if(a.editable||i){var m=window;var b=a.$w;if(a.$p()){m[b(29)](b(1));return}a.removeM;var c=a.VF();var l="<link rel='stylesheet' href='https://www.canvasxpress.org/dist/canvasXpress.css' type='text/css'/>\n";l+="<script type='text/javascript' src='https://www.canvasxpress.org/dist/canvasXpress.min.js'><\/script>\n\n";l+="<canvas id='"+a.target+"' width='"+a.width+"' height='"+a.height+"'></canvas>";var d=a.$cX("form",{id:"submitToJSFiddle",method:"post",action:"https://jsfiddle.net/api/post/library/pure/",target:"check"},{display:"none"});document.body.appendChild(d);var h=a.$cX("textarea",{name:"title",value:(a.title||"CanvasXpress")});var j=a.$cX("textarea",{name:"html",value:l});var n=a.$cX("textarea",{name:"js",value:c});var g=a.$cX("button",{type:"submit"});d.appendChild(h);d.appendChild(j);d.appendChild(n);d.appendChild(g);g.click();document.body.removeChild(d)}}}(this);this.Yg=function(a){return function(k,j){if(a.editable||j){var n=window;var b=a.$w;if(a.$p()){n[b(29)](b(1));return}a.It();var d=a.VF().replace(/\'/g,"");var m='<link rel="stylesheet" href="https://www.canvasxpress.org/dist/canvasXpress.css" type="text/css"/>\n';m+='<script type="text/javascript" src="https://www.canvasxpress.org/dist/canvasXpress.min.js"><\/script>\n\n';m+='<canvas id="'+a.target+'" width="'+a.width+'" height="'+a.height+'"></canvas>';var g="https://www.canvasxpress.org/dist/canvasXpress.css;https://www.canvasxpress.org/dist/canvasXpress.min.js";var i='{"title": "'+(a.title||"CanvasXpress")+'", "html": "'+m+'" js: "'+d+'" js_external: "'+g+'"}';i='{"title": "CanvasXpress", "html": "'+m.replace(/"/g,"'")+'", "js": "'+d.replace(/"/g,"'")+'", "js_external": "'+g.replace(/"/g,"'")+'"}';var c=a.$cX("form",{id:"submitToCodePen",method:"post",action:"https://codepen.io/pen/define",target:"_blank"},{display:"none"});document.body.appendChild(c);var l=a.$cX("input",{type:"hidden",name:"data",value:i});var h=a.$cX("button",{type:"submit"});c.appendChild(l);c.appendChild(h);h.click();document.body.appendChild(c)}}}(this);this.PR=function(){this.a3();var e=CanvasXpress.stack[this.target];var b=e.afterRender;var c=[];for(var d=0;d<b.length;d++){if(b[d][0].match(/^sort/)){c.push(this.ZD(b[d]))}}return this.OU({renderTo:e.renderTo,data:this.data,config:this.RO(),afterRender:c,factory:e.factory,system:e.system,version:e.version})};this.eP=function(a){return function(j,i,d,g){var k=window;var c=a.$w;if(a.$pX()){k[c(29)](c(5));return}a.It();var l=i?i+".json":a.saveFilename?a.saveFilename+".json":"cX-"+a.target+".json";l=l.replace(/.json.json$/,".json");CanvasXpress.stack[a.target].factory=CanvasXpress.factory;CanvasXpress.stack[a.target].system=CanvasXpress.system;var h;if(d){h=a.OU({config:CanvasXpress.stack[a.target].config,afterRender:CanvasXpress.stack[a.target].afterRender||[]})}else{if(g||(j&&(j.ctrlKey||j.altKey))){h=a.PR()}else{h=a.OU(a.xt(a.ZD(CanvasXpress.stack[a.target])))}}var b=new Blob([h],{type:"text/plain"});a.Ff(b,l)}}(this);this.mU=function(a){return function(k,i){var g=a.$pX();var c=a.$w;if(g){CanvasXpress.stack[a.target].config[c(0)]=g}a.It();CanvasXpress.stack[a.target].factory=CanvasXpress.factory;CanvasXpress.stack[a.target].system=CanvasXpress.system;a.isSVG=true;var l=a.showTransition;var d=a.xt(a.ZD(CanvasXpress.stack[a.target]));if(g){d.data=a[c(9)](a.uY(d.data))}d=a.isReproducibleResearch?a.uY(d):"";a.showTransition=false;a.meta.canvas.SVG=new this.BO({width:a.width,height:a.height,desc:d});a.Ur(true);var h=a.meta.canvas.SVG.getSerializedSvg();if(a.isReproducibleResearch){a.oC(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var m=i?i+".svg":a.saveFilename?a.saveFilename+".svg":"cX-"+a.target+".svg";m=m.replace(/.svg.svg$/,".svg");var b=new Blob([h],{type:"image/svg+xml"});a.Ff(b,m);a.showTransition=l;delete (a.meta.canvas.SVG);a.isSVG=false}}(this);this.hr=function(c){var e="";var b=new Uint8Array(c);var a=b.byteLength;for(var d=0;d<a;d++){e+=String.fromCharCode(b[d])}return window.btoa(e)};this.QN=function(c){var d=window.atob(c);var a=d.length;var b=new Uint8Array(a);for(var e=0;e<a;e++){b[e]=d.charCodeAt(e)}return b.buffer};this.By=function(){if(this.useLeaflet){var b=this.$("leaflet-"+this.target);if(b){var a=this.meta.canvas.ctx.canvas;var h=this.$cX("canvas",{width:this.width,height:this.height});var c=h.getContext("2d");var e=b.getElementsByTagName("img");for(var d=0;d<e.length;d++){var f=e[d];var j=f._leaflet_pos.x;var g=f._leaflet_pos.y;c.Sx(f,j,g,256,256)}c.Sx(a,0,0,this.width,this.height);return h}}};this.Mk=function(b){return function(c,e,a){try{CanvasXpress}catch(N){c.preventDefault();c.stopPropagation();return false}var L=window;var I=b.width;var H=b.height;var y=b.printMagnification;var G=b.autoScaleFont;var E=b.showTransition;var B=b.skipStack;var A=["outlineWidth","lineThickness","xAxisTickSize","yAxisTickSize","zAxisTickSize","xAxisTickLeftSize","xAxisTickRightSize","yAxisTickTopSize","yAxisTickBottomSize","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize","treemapBorderWidth","errorBarsThickness","ganttDependencyThickness"];if(!CanvasXpress.stack.hasOwnProperty(b.target)){b=CanvasXpress.getObject(CanvasXpress.current.replace("-events",""))}var D=function(d){if(d&&y!=1){for(var f=0;f<A.length;f++){b[A[f]]/=y}b.autoScaleFont=G;b.showTransition=E;b.aI(I,H,true);b.skipStack=B}else{if(y!=1){b.skipStack=true;b.showTransition=false;for(var f=0;f<A.length;f++){b[A[f]]*=y}b.autoScaleFont=true;b.aI(I*y,H*y,true)}}};var O=function(){var i;var h=[];for(var d=0;d<256;d++){i=d;for(var g=0;g<8;g++){i=((i&1)?(3988292384^(i>>>1)):(i>>>1))}h[d]=i}return h};var M=function(i){var h=L.crcTable||(L.crcTable=O());var d=0^(-1);for(var g=0;g<i.length;g++){d=(d>>>8)^h[(d^i.charCodeAt(g))&255]}return(d^(-1))>>>0};var J=function(g,h){var d=new Uint8Array(g.byteLength+h.byteLength);d.set(new Uint8Array(g),0);d.set(new Uint8Array(h),g.byteLength);return d.buffer};var F=function(g){var l="tEXt";var h=g.length;var d=M(l+g);var k=new ArrayBuffer(12+h);var i=new DataView(k);i.setUint32(0,h);for(var j=0;j<l.length;j++){i.setUint8(4+j,l.charCodeAt(j))}for(var j=0;j<g.length;j++){i.setUint8(8+j,g.charCodeAt(j))}i.setUint32(4+4+h,d);return k};var K=function(){var h=false;var i=b.$pX();var g=b.$w;if(i){CanvasXpress.stack[b.target].config[g(0)]=i}if(b.isReproducibleResearch){if(b.printMagnification!=1){delete (CanvasXpress.stack[b.target].config.showTransition)}if(c&&(c.ctrlKey||c.altKey)){h=b.PR()}else{h=b.xt(b.ZD(CanvasXpress.stack[b.target]));if(i){h.data=b[g(9)](b.uY(h.data))}}h=b.uY(h)}else{var d=b.c9(c.ctrlKey||c.altKey?b.PR():b.uY(CanvasXpress.stack[b.target]));d.afterRender=[d.afterRender[0]];h=b.uY(d)}return encodeURIComponent(h)};var P=function(h,j,i,g){var d=J(h,j);d=J(d,i);d=J(d,g);return d};var z=function(h){var d=new FileReader();var g="";if(b.isReproducibleResearch){g+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{g+="<h2>Right click to save image</h2>"}d.onload=function(f){g+="<img width="+b.width+" height="+b.height+" src= '"+f.target.result+"'/>";b.vV(c,g,b.B2(c),{maxWidth:b.width+"px",whiteSpace:"normal"},40,40)};d.readAsDataURL(h)};D();b.It();CanvasXpress.stack[b.target].factory=CanvasXpress.factory;CanvasXpress.stack[b.target].system=CanvasXpress.system;if(!CanvasXpress.factory.valid){b.$$$("CanvasXpress")}var C=b.useLeaflet?b.By():b.meta.canvas.ctx.canvas;C.toBlob(function(g){var h=new FileReader();var d=e?e+".png":b.saveFilename?b.saveFilename+".png":"cX-"+b.target+".png";d=d.replace(/.png.png$/,".png");h.onloadend=function(){var m=new DataView(this.result);var k=m.getUint32(8);var j=8+4+4+k+4;var i=this.result.slice(0,j);var f=this.result.slice(j);var n=F("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var p=F("ReproducibleResearch\0"+K());var o=P(i,n,p,f);var l=new Blob([o],{type:"image/png"});b.meta.base64=b.hr(o);if(a){a(l,d)}else{if(b.printType=="download"){if(b.isReproducibleResearch){b.oC(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}b.Ff(l,d)}else{z(l)}}D(true)};h.readAsArrayBuffer(g)},"image/png");if(b.customizing){}else{if(b.maximized){b.lY(c)}}}}(this);this.NO=function(a){return function(f){var b=a.meta.canvas.ctx;a.meta.canvas.ctx=new this.BO({width:a.width,height:a.height});a.j8({func:"exportToSVG",par:[f]});var c=a.FP(a.meta.canvas.ctx.getSerializedSvg());var d=window.open("",a.target+"-SVG");d.document.write(c);a.meta.canvas.ctx=b;a.j8({func:"exportToSVG",par:[f]});return false}}(this);this.wn=function(a){return this.u4(a)};this.rj=function(e,b){var c="<table>";for(var a=0;a<e.length;a++){c+="<tr><td>";c+=e[a].join("</td><td>");c+="</td></tr>"}c+="</table>";return b?c:window.open().document.write(c)};this.u4=function(e){var c="";for(var a=0;a<e.length;a++){c+=e[a].join("\t")+"\n"}var b=this.$(this.target+"-cX-linkTab");if(!b){b=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});window.document.body.appendChild(b)}b.download=this.target+".tsv";b.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(c);b.click()};this.qT=function(e){var c="";if(e[0].length){c+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';c+='<table class="CanvasXpressDataTable" style="position:inherit;">';c+="<tbody>";c+="<tr>";for(var b=0;b<e[0][0].length;b++){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][0][b];c+="</div>";c+="</th>"}c+="</tr>";for(var b=1;b<e[0].length;b++){c+="<tr>";for(var a=0;a<e[0][b].length;a++){if(a==0){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</th>"}else{if(e[2]&&e[2][b]&&e[2][b][a]){c+='<td class="CanvasXpressTableCell" style="height:18px;background-color:'+e[2][b][a]+'">'}else{c+='<td class="CanvasXpressTableCell" style="height:18px">'}c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</td>"}}c+="</tr>"}c+="</tbody>";c+="</table>";c+="</div>"}return c};this.sF=function(g){var h=[];var b=g.split(/\n(?=(?:(?:[^"]*"){2})*[^"]*$)/);var c=["header","quote","row.names","fill","check.names","stringsAsFactors"];var f=false;for(var e=0;e<b.length;e++){var a=b[e];if(a.match(/library\(canvasXpress\)/)){h.push(a.replace("library(canvasXpress)",'library(<span class="json-value">canvasXpress</span>)'))}else{if(a.match(/canvasXpress\(/)){h.push(a.replace("canvasXpress(",'<span class="json-value">canvasXpress</span>('));f=true}else{if(a.match(/\"http.+\"/)){a=a.replace(/(\"http.+?\")/,'<span class="json-string">$1</span>');for(var d=0;d<c.length;d++){a=a.replace(c[d],'<span class="json-key">'+c[d]+"</span>")}a=a.replace('""','<span class="json-string">""</span>,');a=a.replace(/\"\t\"/,'<span class="json-string">"&#92;t"</span>');a=a.replace("=1,",'=<span class="json-number">1</span>,');a=a.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');a=a.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>');h.push(a)}else{if(f){if(a.match(/\".+?\"/)){a=a.replace(/(\".+?\")/g,'<span class="json-string">$1</span>')}else{if(a.match(/[^xis][\d\.]+/)){a=a.replace(/([\d\.]+)/,'<span class="json-number">$1</span>')}}a=a.replace(/\n/,"&#92;n");a=a.replace(/(\w+)?=/,'<span class="json-key">$1=</span>');a=a.replace(/FALSE/g,'<span class="json-boolean">FALSE</span>');a=a.replace(/TRUE/g,'<span class="json-boolean">TRUE</span>')}h.push(a)}}}}return'<pre class="CanvasXpressCodeContent">\n<code>'+h.join("</code>\n<code>")+"</code>\n</pre>"};this.sN=function(e,d,f,b){var a=this.uY(e,d?d:null,2);if(a.length>10000){f=false}if(f){a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}a=a.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(g){var c="number";if(/^"/.test(g)){if(/:$/.test(g)){g=g.replace(":"," =");c="key"}else{c="string"}}else{if(/true|false/.test(g)){g=g.replace("false","FALSE").replace("true","TRUE");c="boolean"}else{if(/null/.test(g)){g=g.replace("null","NULL");c="null"}}}return f?('<span class="json-'+c+'">'+g+"</span>"):g});if(b){return a.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"").replace(/(\w.+)\s(\w.+)\s=/g,'"$1 $2" =')}else{return a.replace(/\[/g,"list(").replace(/]/g,")").replace(/{/g,"list(").replace(/}/g,")").replace(/^list\(\n/,"").replace(/\)$/,"")}};this.hA=function(){if(this.$p()){return this.$w(1)}var g=[];var m=[];var n,b,q,a,o,h;var k="";var f=CanvasXpress.stack[this.target].data;var p="<span class=json-value>canvasXpress</span>(\n";if(this.meta.config.remote&&!this.M9(this.meta.config.remote.data)){if(this.meta.config.remote.data===false){k+="data = FALSE\n"}else{k+='data = "'+this.meta.config.remote.data+'"\n'}p+="  <span class=json-key>data</span> = data,\n"}else{if(this.graphType=="Map"&&!this.M9(this.meta.config.remote.data)){k+="";p+="  <span class=json-key>data</span> = <span class=json-value>FALSE</span>,\n"}else{if(f.y){g=[];for(var e=0;e<f.y.vars.length;e++){var l=[];for(var d=0;d<f.y.smps.length;d++){l.push(f.y.data[e][d]!=null?f.y.data[e][d]:"NA")}g.push("<span class=json-number>"+l.join("</span>,<span class=json-number>")+"</span>,")}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="vals = c("+g.join("\n")+")\n";q='vars = c(<span class=json-string>"'+f.y.vars.join('"</span>,\n<span class=json-string>"')+'"</span>)\n';a='smps = c(<span class=json-string>"'+f.y.smps.join('"</span>,\n<span class=json-string>"')+'"</span>)\n';o="data = as.data.frame(matrix(vals, <span class=json-key>nrow</span> = <span class=json-number>"+f.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+f.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(vars, smps)))\n";k+=b+q+a+o;p+="  <span class=json-key>data</span> = data,\n"}if(f.x){g=[];m=[];b="";for(var e in f.x){var c=this.meta.data.x&&this.meta.data.x[e]?this.meta.data.x[e].type:this.meta.data.z&&this.meta.data.z[e]?this.meta.data.z[e].type:"fail";if(c=="Numeric"){g.push("<span class=json-number>"+f.x[e].join("</span>,\n<span class=json-number>")+"</span>,")}else{g.push('<span class=json-string>"'+f.x[e].join('"</span>,\n<span class=json-string>"')+'"</span>,')}m.push(e)}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="valx = c("+g.join("\n ")+")\n";if(this.graphType=="Tree"){b=b.replace(/\"\"/g,"NA")}q='varx = c(<span class=json-string>"'+m.join('"</span>,<span class=json-string>"')+'"</span>)\n';o="datx = as.data.frame(matrix(valx, <span class=json-key>nrow</span> = <span class=json-number>"+m.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+f.y.smps.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>TRUE</span>, <span class=json-key>dimnames</span> = list(varx, smps)))\n";k+=b+q+o;p+="  <span class=json-key>smpAnnot</span> = datx,\n"}if(f.z){g=[];m=[];b="";for(var e in f.z){var c=this.meta.data.z&&this.meta.data.z[e]?this.meta.data.z[e].type:this.meta.data.x&&this.meta.data.x[e]?this.meta.data.x[e].type:"fail";if(c=="Numeric"){g.push("<span class=json-number>"+f.z[e].join("</span>,\n<span class=json-number>")+"</span>,")}else{g.push('<span class=json-string>"'+f.z[e].join('"</span>,\n<span class=json-string>"')+'"</span>,')}m.push(e)}g[g.length-1]=g[g.length-1].replace(/,$/,"");b="valz = c("+g.join("\n ")+")\n";a='smpz = c(<span class=json-string>"'+m.join('"</span>,<span class=json-string>"')+'"</span>)\n';o="datz = as.data.frame(matrix(valz, <span class=json-key>nrow</span> = <span class=json-number>"+f.y.vars.length+"</span>, <span class=json-key>ncol</span> = <span class=json-number>"+m.length+"</span>, <span class=json-key>byrow</span> = <span class=json-boolean>FALSE</span>, <span class=json-key>dimnames</span> = list(vars, smpz)))\n";k+=b+a+o;p+="  <span class=json-key>varAnnot</span> = datz,\n"}if(f.nodes){k+="nodes = list(\n"+this.sN(f.nodes,function(j,i){if(j!="layout"){return i}},false,true)+")\n";p+='  <span class=json-key>"nodeData"</span> = nodes,\n'}if(f.edges){k+="edges = list(\n"+this.sN(f.edges,false,false,true)+")\n";p+='  <span class=json-key>"edgeData"</span> = edges,\n'}if(f.groups){k+="groups = list(\n"+this.sN(f.groups,false,false,true)+")\n";p+='  <span class=json-key>"groupData"</span> = groups,\n'}if(f.constraints){k+="constraints = list(\n"+this.sN(f.constraints,false,false,true)+")\n";p+='  <span class=json-key>"constraintData"</span> = constraints,\n'}if(f.venn){k+="venn = data.frame(\n"+this.sN(f.venn.data,false,true)+")\n";p+="  <span class=json-key>vennData</span> = venn,\n";if(f.venn.legend){k+="legn = data.frame(\n"+this.sN(f.venn.legend,false,true)+")\n";p+="  <span class=json-key>vennLegend</span> = legn,\n"}}if(f.tracks){p+="  <span class=json-key>tracks</span> = genome,\n";k+="genome = list(\n"+this.sN(f.tracks,false,true)+")\n"}}}n=this.meta.config.remote?this.ZD(this.meta.config.remote.config):this.ZD(CanvasXpress.stack[this.target].config);if(CanvasXpress.stack[this.target].afterRender&&CanvasXpress.stack[this.target].afterRender.length>1){n.afterRender=this.ZD(CanvasXpress.stack[this.target].afterRender)}p+=this.sN(n,false,true)+")";h="library(<span class=json-value>canvasXpress</span>)\n"+k+p;return"<code> "+h.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.OU=function(d,b,e,a){return e&&d?this.yV(d,b):d?this.uY(d,b,a||2):false};this.yV=function(c,b){if(c){var a=this.uY(c,b?b:null,2);if(a.length>10000){return a}else{a=a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}return a.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(e){var d="number";if(/^"/.test(e)){if(/:$/.test(e)){d="key"}else{d="string"}}else{if(/true|false/.test(e)){d="boolean"}else{if(/null/.test(e)){d="null"}}}return'<span class="json-'+d+'">'+e+"</span>"})}else{return false}};this.WE=function(g,e){var d=function(h){return h.replace(/"/g,"&quot;").replace(/^\s*/g,"").replace(/'\s*\+\s*'/g,"' + '").replace(/'\s*\+\s*Math/g,"' + Math").replace(/\*/g," * ").replace(/\)\//g,") / ").replace(/<(.+?)>/g,"&lt;$1&gt;")};g=g.replace(/{/g,"{\n").replace(/}/g,"\n}");var b=g.split(/\n/);var a=[d(b[0])];var f="  ";if(!e){e=""}for(var c=1;c<b.length;c++){b[c]=d(b[c]);if(b[c].match(/[\w{}]/)){if(b[c].match(/}\s*else\s*\{\s*$/)){f=f.replace("  ","");a.push(e+f+b[c]);f+="  "}else{if(b[c].match(/\{\s*$/)){a.push(e+f+b[c]);f+="  "}else{if(b[c].match(/\}\s*;*\s*$/)){f=f.replace("  ","");a.push(e+f+b[c])}else{a.push(e+f+b[c])}}}}}return a.join("\n")};this.MJ=function(d,a){var c="{\n";if(!a){a="  "}for(var b in d){c+=a+'"'+b+'": '+d[b]+",\n"}a=a.replace("  ","");return c.replace(/,\n$/,"\n")+a+"}"};this.FP=function(n){var f=/(>)\s*(<)(\/*)/g;var t=/ *(.*) +\n/g;var e=/(<.+>)(.+\n)/g;var d=n.replace(f,"$1\n$2$3").replace(t,"$1\n").replace(e,"$1\n$2");var r=0;var b="";var a=d.split("\n");var k=0;var q="other";var v={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var p=0;p<a.length;p++){var h=a[p];var u=Boolean(h.match(/<.+\/>/));var g=Boolean(h.match(/<\/.+>/));var m=Boolean(h.match(/<[^!].*>/));var c=u?"single":g?"closing":m?"opening":"other";var s=q+"->"+c;q=c;var l="";k+=v[s];for(var o=0;o<k;o++){l+="  "}b+=l+h+"\n"}return b};this.tM=function(d){if(this.$p()){return this.$w(1)}var f=this.lb(true).replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var e=this.JP(true).replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None");var c=this.Pu(true);var a=this.B5(true);var b="";b+="<span class=json-key>from</span> canvasxpress.canvas <span class=json-key>import</span> CanvasXpress\n";if(d){b+="<span class=json-key>from</span> canvasxpress.render.jupyter <span class=json-key>import</span> CXNoteBook\n\n"}else{b+="<span class=json-key>from</span> canvasxpress.render.popup <span class=json-key>import</span> CXBrowserPopup\n\n"}b+="cx = CanvasXpress(\n";b+='  render_to = </span>"'+this.target+'"</span>,\n';b+="  data = "+f+",\n";b+="  config = "+e+",\n";if(c){b+="  events = "+c.replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}if(a){b+="  after_render = "+a.replace(/\n/g,"\n  ").replace(/true/g,"True").replace(/false/g,"False").replace(/null/g,"None")+",\n"}b+="  width = <span class=json-number>"+this.width+"</span>,\n";b+="  height = <span class=json-number>"+this.height+"</span>\n";b+=")\n\n";if(d){b+="display = CXNoteBook(cx)\n"}else{b+="display = CXBrowserPopup(cx)\n"}b+="display.render()";return"<code> "+b.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.as=function(){if(this.$p()){return this.$w(1)}var k=JSON.parse(this.meta.config.user.cxplot);var l=JSON.stringify(k.data).replace(/\],/g,"],\n  ");var c=this.pe(k.geoms)?k.geoms:[k.geoms];var a={};var h="";if(k.aes&&k.order){k.aes.meta={};Object.assign(k.aes.meta,k.order);if(!k.aes.hasOwnProperty("x")){for(var b=0;b<c.length;b++){var d=c[b];if(k.layers[d]&&k.layers[d].hasOwnProperty("x")){k.aes.x=k.layers[d].x;break}}}if(!k.aes.hasOwnProperty("y")){for(var b=0;b<c.length;b++){var d=c[b];if(k.layers[d]&&k.layers[d].hasOwnProperty("y")){k.aes.y=k.layers[d].y;break}}}}var m=JSON.stringify(k.aes);var j=["labels","scales","colors","coordinates","theme","facet","config"];h+="<span class=json-key>var</span> data = "+l+";\n\n";h+='<span class=json-key>var</span> cxp = <span class=json-value>new</span> cxplot("canvas", data, aes('+m+"));\n";for(var b=0;b<c.length;b++){var d=a[c[b]]?c[b]+"."+a[c[b]]:c[b];var e=c[b].toLowerCase().replace("geom","geom_").replace("2","_2").replace("filled","_filled").replace("_qql","_qq_l").replace("ridgesgradient","ridges_gradient").replace("ridges","_ridges");if(this[e]&&!this.skipGeoms){h+="cxp.<span class=json-key>"+e+"</span>("+JSON.stringify(k.layers[d])+");\n"}a[d]=a[d]?a[d]+1:1}for(var b=0;b<j.length;b++){if(k[j[b]]){var e="gg_"+j[b];if(this.pe(k[j[b]])){if(k[j[b]].length>0){h+="cxp.<span class=json-key>"+e+"</span>("+JSON.stringify(k[j[b]])+");\n"}}else{h+="cxp.<span class=json-key>"+e+"</span>("+JSON.stringify(k[j[b]])+");\n"}}}return"<code> "+h.replace(/\n/g,"</code>\n<code> ")+"</code>"};this.J9=function(g,f){var a=[["Id"]];for(var e=0;e<this.data.y.vars.length;e++){a[e+1]=[];a[e+1][0]=this.data.y.vars[e]}for(var e=0;e<this.data.y.smps.length;e++){a[0][e+1]=this.data.y.smps[e];for(var d=0;d<this.data.y.vars.length;d++){a[d+1][e+1]=this.data.y.data[d][e]}}if(g&&this.data[g]){if(g=="x"){for(var e in this.data.x){var b=a.length;a[b]=[];a[b][0]=e;for(var d=0;d<this.data.y.smps.length;d++){a[b][d+1]=this.data.x[e][d]}}}else{if(g=="z"){for(var e in this.data.z){var b=a[0].length;a[0][b]=e;for(var d=0;d<this.data.y.vars.length;d++){a[d+1][b]=this.data.z[e][d]}}}}}return f?this.sm(a):a};this.JA=function(a,b){if(this.varIndices.length&&this.smpIndices.length){var g=this;var B=function(i){if(i=="s"){return{y:{smps:g.ZD(g.data.y.smps)},x:{}}}else{return{y:{vars:g.ZD(g.data.y.vars)},z:{}}}};var C={};if(b&&this.data.z&&this.data.z.hasOwnProperty("cXId")){for(var x=0;x<this.data.z.cXId.length;x++){C[this.data.z.cXId[x]]=x}}var k={s:[],v:[]};var l={s:[],v:[]};var s;var v=2;var r=false;for(var x=1;x<a.length;x++){s=this.uL(a[x][0]);if(s>-1){k.s.push([x,s]);continue}s=b&&C.hasOwnProperty(a[x][0])?C[a[x][0]]:this.qv(a[x][0]);if(s>-1){k.v.push([x,s]);continue}}for(var x=1;x<a[0].length;x++){s=b&&C.hasOwnProperty(a[x][0])?C[a[x][0]]:this.qv(a[0][x]);if(s>-1){l.v.push([x,s]);continue}s=this.uL(a[0][x]);if(s>-1){l.s.push([x,s]);continue}}var h=k.s.length>v?k.s.length:0;var f=k.v.length>v?k.v.length:0;var e=l.s.length>v?l.s.length:0;var d=l.v.length>v?l.v.length:0;var z=this.data.y.smps.length;var A=this.data.y.vars.length;if(h||f||e||d){var t=0;if(h==z&&d==A){var D=[];for(var x=0;x<l.v.length;x++){var o=l.v[x][0];var c=l.v[x][1];D[c]=[];for(var w=0;w<k.s.length;w++){var y=k.s[w][0];var q=k.s[w][1];D[c][q]=a[y][o];t++}}r=true}else{if(e==z&&f==A){var D=[];for(var x=0;x<k.v.length;x++){var o=k.v[x][0];var c=k.v[x][1];D[c]=[];for(var w=0;w<l.s.length;w++){var y=l.s[w][0];var q=l.s[w][1];D[c][q]=a[o][y];t++}}r=true}else{if(h>=f&&h>=e&&h>=d){var D=B("s");for(var x=1;x<a[0].length;x++){D.x[a[0][x]]=[];var u=0;for(var w=0;w<k.s.length;w++){var y=k.s[w][0];var q=k.s[w][1];D.x[a[0][x]][q]=a[y][x];t++;u=a[y][x]?u+1:u}if(!u){delete D.x[a[0][x]]}}}else{if(f>=h&&f>=e&&f>=d){var D=B("v");for(var x=1;x<a[0].length;x++){D.z[a[0][x]]=[];var u=0;for(var w=0;w<k.v.length;w++){var y=k.v[w][0];var q=k.v[w][1];D.z[a[0][x]][q]=a[y][x];t++;u=a[y][x]?u+1:u}if(!u){delete D.z[a[0][x]]}}}else{if(e>h&&e>=f&&e>=d){var D=B("s");for(var x=0;x<l.s.length;x++){var o=l.s[x][0];var c=l.s[x][1];var u=0;for(var w=1;w<a.length;w++){if(x==0){D.x[a[w][0]]=[]}D.x[a[w][0]][c]=a[w][o];t++;u=a[w][o]?u+1:u}if(!u){delete D.x[a[w][0]]}}}else{if(d>h&&d>=f&&d>=e){var D=B("v");for(var x=0;x<k.s.length;x++){var o=k.s[x][0];var c=k.s[x][1];var u=0;for(var w=1;w<a.length;w++){if(x==0){D.z[a[w][0]]=[]}D.z[a[w][0]][c]=a[w][o];t++;u=a[w][o]?u+1:u}if(!u){delete D.z[a[w][0]]}}}}}}}}return{data:D,recs:t,addt:r}}else{if(b){var D=this.wD(a);this.data.x=D.data.x;this.data.y.smps=D.data.y.smps;this.data.y.vars=this.ZD(this.data.z.id);this.U2(this.data);var p=this.meta.map.geojson.features;for(var x=0;x<p.length;x++){p[x].properties.key=this.data.y.vars[x];p[x].properties.varId=[x]}return{data:false,recs:this.data.y.smps.length,addt:false}}else{return a}}}return a};this.lG=function(){var b=function(c){return function(d){c.Rdatasets=c.c9(d)}}(this);var a=this.RdatasetsURL+"datasets.json";this.YV(a,false,b)};this.tU=function(a){this.wV(this.RdatasetsURL+"json/"+a+"/datasets.json")};this.Uf=function(){var f=this;var b=this.appendNetworkData.length>0?this.appendNetworkData.shift():false;var d=function(n){var l=function(z){var y={};var B=z[0];var r=0;var w=0;var u=0;var q={};var A=false;for(var x=1;x<z.length;x++){var s=z[x][0];var t=z[x][1];if(f.data.nodeIndices.hasOwnProperty(s)&&f.data.nodeIndices.hasOwnProperty(t)){w++}else{if(f.data.nodeIndices.hasOwnProperty(s)){r++}else{u++}}q[s]=x}if(!r&&!w){for(var x=0;x<f.data.nodes.length;x++){var s=f.data.nodes[x];if(s.hasOwnProperty("extId")&&q.hasOwnProperty(s.extId)){z[q[s.extId]][0]=s.id;r++}}}if(w>r){r=0;w=0;u=0;A="edge";for(var x=1;x<z.length;x++){var s=z[x][0];var t=z[x][1];if(f.data.nodeIndices.hasOwnProperty(s)&&f.data.nodeIndices.hasOwnProperty(t)){w++;y[s+":"+t]={};for(var v=2;v<B.length;v++){y[s+":"+t][B[v]]=z[x][v]}}else{u++}}}else{if(r>8){r=0;w=0;u=0;A="node";for(var x=1;x<z.length;x++){var s=z[x][0];if(f.data.nodeIndices.hasOwnProperty(s)){r++;y[s]={};for(var v=1;v<B.length;v++){y[s][B[v]]=z[x][v]}}else{u++}}}else{return z}}if((A=="edge"&&(w>5||w>=z.length-1))||(A=="node"&&(r>5||r>=z.length-1))){return{data:y,rows:Math.max(r,w),fail:u,type:A}}else{return z}};var o=l(f.af(n));if(o&&!f.pe(o)){var k="";if(o.fail>0){k=o.fail+" records couldn't be mapped to network data"}f.oC(100,150,o.rows+" "+o.type+" records added to network data\n"+k,5000);var p=f.meta.config.user;var e=["colorNodeBy","shapeNodeBy","sizeNodeBy","patternNodeBy","colorEdgeBy","SizeEdgeBy","decorations"];for(var m=0;m<e.length;m++){var j=e[m];if(p.hasOwnProperty(j)){f[j]=p[j]}}if(o.type=="node"){f.CR(o.data)}else{f.Gr(o.data)}if(f.appendNetworkData.length>0){f.Uf()}else{f.j8({func:"appendNetworkDataFromURL"});f.Jb()}}};var c=function(e){if(e.type=="node"){f.CR(e.data)}else{f.Gr(e.data)}if(f.appendNetworkData.length>0){f.Uf()}else{f.j8({func:"appendNetworkDataFromURL"});f.Jb()}};var a=function(e){return function(i){if(b.match(/\.txt$/)||b.match(/\.csv$/)||b.match(/\.tsv$/)||b.match(/\.tab$/)){d(i)}else{e.Jb();alert("Oooops! Not a CanvasXpress Network delimited file")}}}(this);if(b){if(typeof(b)=="string"){var g=null;try{g=JSON.parse(b);return c(g)}catch(h){g=null}g=this.af(b)||null;if(g){return d(b)}if(this.hE(b)){return this.YV(b,false,a)}}else{c(b)}}};this.wV=function(a){this.remoteService=a;this.YV(a,false,this.setDataSetsFromURL)};this.iW=function(a){return function(b){var g=function(i){return function(n){var p=f.c9(n);f.Dz({data:p,ids:f.remoteIds,records:f.remoteIds.length})}}(f);var o=function(){var i=a.$("container-"+a.target).parentNode;while(i.id.match("canvasXpressRemoteWindow")){i=i.parentNode}if(!i.id){i.id=a.Ph("-cX-data-sets-url-container-")}return i.id};var h=a.c9(b);var d=h[0][1];var c=[];for(var j=0;j<h.length;j++){c.push(h[j][0])}var k=o();var m=a.$("container-"+a.target).parentNode;var l=a.Ph("-cX-data-sets-");var e=a.$cX("canvas",{id:l,width:a.originalWidth,height:a.originalHeight});a.cg(e);m.appendChild(e);var f=new CanvasXpress(l,false,{remoteService:a.remoteService});a.remoteIds=c;a.iY(a.target);f.remoteData=h;f.remoteParentId=k;f.remoteIds=c;f.YV(d,false,g)}}(this);this.fO=function(d,b,c,e,f){if(!CanvasXpress.stack){CanvasXpress.stack={}}var a=this.$(this.target);if(a){CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:(this.isCxplot&&this.pe(d)?this.ZD(this.data):d?this.ZD(d):false),config:this.ZD(b)||false,events:c?c:false,info:e?e.toString().replace(/'/g,"'").replace(/"/g,"'"):false,afterRenderInit:f?f:false,afterRender:[["setDimensions",[a.originalWidth,a.originalHeight,true]]],stateCX:[],stateIndexCX:0,noValidate:true}}};this.FE=function(d){if(d.data){if(d.config.stringSampleFactors){for(var b=0;b<d.config.stringSampleFactors.length;b++){var c=d.config.stringSampleFactors[b];if(d.data.x&&d.data.x[c]){for(var a=0;a<d.data.x[c].length;a++){d.data.x[c][a]=d.data.x[c][a]}}}}if(d.config.stringVariableFactors){for(var b=0;b<d.config.stringVariableFactors.length;b++){var c=d.config.stringVariableFactors[b];if(d.data.z&&d.data.z[c]){for(var a=0;a<d.data.z[c].length;a++){d.data.z[c][a]=d.data.z[c][a]}}}}CanvasXpress.stack[this.target].data=d.data}};this.CK=function(){return CanvasXpress.stack[this.target].afterRender};this.tD=function(){var g={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,cola:true,colaConnector:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,events:true,functions:true,gantt:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,lines:true,moveSankeyId:true,movingOn:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"||(this.graphType=="Network"&&this.networkLayoutType=="cola")){g.data=true}var f=Object.keys(this);var a=this.tx(CanvasXpress.config);var e=[];for(var d=0;d<f.length;d++){var h=f[d];if(a.hasOwnProperty(h)){e.push(h)}else{if(!this.pb(this[h])&&!g.hasOwnProperty(h)){e.push(h)}}}var b={};for(var d=0;d<e.length;d++){var h=e[d];b[h]=this.M9(this[h])?this.ZD(this[h],true):this[h]}return b};this.MK=function(a){if(!a){a=0}var b=CanvasXpress.stack[this.target].stateCX[a];for(var e in b){this[e]=b[e]}var d={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.j8({func:"setConfigState",par:[a]});this.skipStack=false;for(var e in d){this[e]=d[e]}};this.O1=function(d){if(!this.skipStack&&d){var i=d.func;var j=d.par?this.UX(d.par):[];var c=d.prop?this.ZD(d.prop):{};var v=new Date().getTime();var w=CanvasXpress.stack[this.target];var e=w?w.afterRender.length:0;if(i&&w){switch(i){case"setDimensions":if(j&&j[0]==this.width&&j[1]==this.height){return}if(j&&j[5]){i="clickGraphMaxMin";j=j[5]>0?[false,false,true]:[false,this.maximized,false]}w.afterRender.push([i,j,{},v]);break;case"broadcastDraw":i=j[0].func;j=j[0]&&j[0].par?this.UX(j[0].par):[];c=j[0]&&j[0].prop||{};if(i){w.afterRender.push([i,j,c,v])}break;case"drawIndicesAfterPannEvent":case"drawIndicesAfterWheelEvent":case"drawRangesAfterWheelEvent":case"updateDragCircular":case"updateDragScatter":case"updateDragNetwork":case"updateDragGenome":case"updateDragMap":case"updateDragMarker":var k=w.afterRender;var b=w.stateCX;var g=i=="updateDragNetwork"&&j[0].shiftKey?false:true;if(e>1&&k[e-1][0]==i&&g){var h=v-k[e-1][3];if(h<1000){k.pop();b.pop()}}w.afterRender.push([i,j,c,v]);break;case"handleWheelEvent":w.afterRender.push([i,j,c,v]);break;case"resortSankeyDONOTUSE":var k=w.afterRender;var b=w.stateCX;if(e>1&&k[e-1][0]=="resortSankey"){var h=v-k[e-1][3];if(h<1000){k.pop();b.pop()}}default:w.afterRender.push([i,j,c,v]);break}if(!this.disableUndoRedoKeys&&w.stateIndexCX<w.stateCX.length-1){w.stateCX.splice(w.stateIndexCX,w.stateCX.length-1)}this.meta.stack.push([i,this.meta.time.start,this.meta.time.elapsed]);if(!this.disableUndoRedoKeys){var r=this.tD();w.stateCX.push(r);w.stateIndexCX=w.stateCX.length-1}}}};this.Ui=function(a){return function(b){a.AM(b,true)}}(this);this.AM=function(a){return function(c,b,f){if(a.maximized){a.lY()}if(a.motionBy){return}a.skipStack=true;a.reproducing=true;a.ZE();a.cY();a.DA(c,true);a.meta.ids={};if(f){a.q3();a.RF(c,true,true)}else{a.Qk(c);if((c&&c.shiftKey)||b){a.RF(c,true)}}}}(this);this.ta=function(a){return function(b){a.h4(b,true)}}(this);this.h4=function(a){return function(j,f,l){var k=a.ZD(CanvasXpress.stack[a.target]);if(!this.isRawData){if(k.data.y){delete k.data.y.data}}this.isQQ=false;this.isCDF=false;k.config.showTransition=f?true:false;if(l){var g=a.ZD(k.afterRender);k.afterRender=[];for(var h=0;h<g.length;h++){var n=g[h];if(n[0]=="addCDFPlot"&&k.config.decorations){delete k.config.decorations.cdf}if(n&&n[4]){k.afterRender.push(n)}}}var b=false;if(a.maximized){a.lY()}a.iY(a.target,true);new CanvasXpress(k)}}(this)};CanvasXpress.prototype.initSave=function(){
/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(g){g.URL=g.URL||g.webkitURL;if(g.Blob&&g.URL){try{new Blob;return}catch(j){}}var i=g.BlobBuilder||g.WebKitBlobBuilder||g.MozBlobBuilder||(function(v){var m=function(F){return Object.prototype.toString.call(F).match(/^\[object\s(.*)\]$/)[1]},E=function s(){this.data=[]},C=function o(H,F,G){this.data=H;this.size=H.length;this.type=F;this.encoding=G},w=E.prototype,B=C.prototype,y=v.FileReaderSync,k=function(F){this.code=this[this.name=F]},x=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),A=x.length,r=v.URL||v.webkitURL||v,z=r.createObjectURL,l=r.revokeObjectURL,q=r,u=v.btoa,p=v.atob,n=v.ArrayBuffer,t=v.Uint8Array,D=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;C.fake=B.fake=true;while(A--){k.prototype[x[A]]=A+1}if(!r.createObjectURL){q=v.URL=function(G){var F=document.createElementNS("http://www.w3.org/1999/xhtml","a"),H;F.href=G;if(!("origin" in F)){if(F.protocol.toLowerCase()==="data:"){F.origin=null}else{H=G.match(D);F.origin=H&&H[1]}}return F}}q.createObjectURL=function(G){var H=G.type,F;if(H===null){H="application/octet-stream"}if(G instanceof C){F="data:"+H;if(G.encoding==="base64"){return F+";base64,"+G.data}else{if(G.encoding==="URI"){return F+","+decodeURIComponent(G.data)}}if(u){return F+";base64,"+u(G.data)}else{return F+","+encodeURIComponent(G.data)}}else{if(z){return z.call(r,G)}}};q.revokeObjectURL=function(F){if(F.substring(0,5)!=="data:"&&l){l.call(r,F)}};w.append=function(J){var L=this.data;if(t&&(J instanceof n||J instanceof t)){var K="",G=new t(J),H=0,I=G.length;for(;H<I;H++){K+=String.fromCharCode(G[H])}L.push(K)}else{if(m(J)==="Blob"||m(J)==="File"){if(y){var F=new y;L.push(F.readAsBinaryString(J))}else{throw new k("NOT_READABLE_ERR")}}else{if(J instanceof C){if(J.encoding==="base64"&&p){L.push(p(J.data))}else{if(J.encoding==="URI"){L.push(decodeURIComponent(J.data))}else{if(J.encoding==="raw"){L.push(J.data)}}}}else{if(typeof J!=="string"){J+=""}L.push(unescape(encodeURIComponent(J)))}}}};w.getBlob=function(F){if(!arguments.length){F=null}return new C(this.data.join(""),F,"raw")};w.toString=function(){return"[object BlobBuilder]"};B.slice=function(I,F,H){var G=arguments.length;if(G<3){H=null}return new C(this.data.slice(I,G>1?F:this.data.length),H,this.encoding)};B.toString=function(){return"[object Blob]"};B.close=function(){this.size=0;delete this.data};return E}(g));g.Blob=function(o,n){var q=n?(n.type||""):"";var m=new i();if(o){for(var p=0,k=o.length;p<k;p++){if(Uint8Array&&o[p] instanceof Uint8Array){m.append(o[p].buffer)}else{m.append(o[p])}}}var l=m.getBlob(q);if(!l.slice&&l.webkitSlice){l.slice=l.webkitSlice}return l};var h=Object.getPrototypeOf||function(k){return k.__proto__};g.Blob.prototype=h(new g.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(g){var h=g.Uint8Array,j=g.HTMLCanvasElement,i=j&&j.prototype,k=/\s*;\s*base64\s*(?:;|$)/i,l="toDataURL",n,m=function(u){var v=u.length,r=new h(v/4*3|0),t=0,x=0,y=[0,0],o=0,w=0,s,p,q;while(v--){p=u.charCodeAt(t++);s=n[p-43];if(s!==255&&s!==q){y[1]=y[0];y[0]=p;w=(w<<6)|s;o++;if(o===4){r[x++]=w>>>16;if(y[1]!==61){r[x++]=w>>>8}if(y[0]!==61){r[x++]=w}o=0}}}return r};if(h){n=new h([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(j&&(!i.toBlob||!i.toBlobHD)){if(!i.toBlob){i.toBlob=function(v,t){if(!t){t="image/png"}if(this.mozGetAsFile){v(this.mozGetAsFile("canvas",t));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(t)){v(this.msToBlob());return}var s=Array.prototype.slice.call(arguments,1),q=this[l].apply(this,s),p=q.indexOf(","),u=q.substring(p+1),o=k.test(q.substring(0,p)),r;if(Blob.fake){r=new Blob;if(o){r.encoding="base64"}else{r.encoding="URI"}r.data=u;r.size=u.length}else{if(h){if(o){r=new Blob([m(u)],{type:t})}else{r=new Blob([decodeURIComponent(u)],{type:t})}}}v(r)}}if(!i.toBlobHD&&i.toDataURLHD){i.toBlobHD=function(){l="toDataURLHD";var o=this.toBlob();l="toDataURL";return o}}else{i.toBlobHD=i.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));var f=typeof window==="object"&&window.window===window?window:typeof self==="object"&&self.self===self?self:typeof global==="object"&&global.global===global?global:this;function e(g,h){if(typeof h==="undefined"){h={autoBom:false}}else{if(typeof h!=="object"){console.warn("Depricated: Expected third argument to be a object");h={autoBom:!h}}}if(h.autoBom&&/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(g.type)){return new Blob([String.fromCharCode(65279),g],{type:g.type})}return g}function b(h,g,i){var j=new XMLHttpRequest();j.open("GET",h);j.responseType="blob";j.onload=function(){a(j.response,g,i)};j.onerror=function(){console.error("could not download file")};j.send()}function c(g){var h=new XMLHttpRequest();h.open("HEAD",g,false);h.send();return h.status>=200&&h.status<=299}function d(h){try{h.dispatchEvent(new MouseEvent("click"))}catch(i){var g=document.createEvent("MouseEvents");g.initMouseEvent("click",true,true,window,0,0,0,80,20,false,false,false,false,0,null);h.dispatchEvent(g)}}var a=f.saveAs||(typeof window!=="object"||window!==f)?function a(){}:"download" in HTMLAnchorElement.prototype?function a(i,j,k){var g=f.URL||f.webkitURL;var h=document.createElement("a");j=j||i.name||"download";h.download=j;h.rel="noopener";if(typeof i==="string"){h.href=i;if(h.origin!==location.origin){c(h.href)?b(i,j,k):d(h,h.target="_blank")}else{d(h)}}else{h.href=g.createObjectURL(i);setTimeout(function(){g.revokeObjectURL(h.href)},40000);setTimeout(function(){d(h)},0)}}:"msSaveOrOpenBlob" in navigator?function a(h,i,j){i=i||h.name||"download";if(typeof h==="string"){if(c(h)){b(h,i,j)}else{var g=document.createElement("a");g.href=h;g.target="_blank";setTimeout(function(){d(g)})}}else{navigator.msSaveOrOpenBlob(e(h,j),i)}}:function a(h,j,g,k){k=k||open("","_blank");if(k){k.document.title=k.document.body.innerText="downloading..."}if(typeof h==="string"){return b(h,j,g)}var l=h.type==="application/octet-stream";var o=/constructor/i.test(f.HTMLElement)||f.safari;var p=/CriOS\/[\d]+/.test(navigator.userAgent);if((p||(l&&o))&&typeof FileReader==="object"){var m=new FileReader();m.onloadend=function(){var q=m.result;q=p?q:q.replace(/^data:[^;]*;/,"data:attachment/file;");if(k){k.location.href=q}else{location=q}k=null};m.readAsDataURL(h)}else{var n=f.URL||f.webkitURL;var i=n.createObjectURL(h);if(k){k.location=i}else{location.href=i}k=null;setTimeout(function(){n.revokeObjectURL(i)},40000)}};this.Ff=a};CanvasXpress.prototype.initConfig=function(){this.cN=function(cat){var d=CanvasXpress.doc;if(!d.M[cat]){d.M[cat]={}}if(!d.M[cat].P){d.M[cat].P=[]}};this.RY=function(base,color,desc,cat,k){this[base+"Color"]=color==false?false:(color||"rgb(0,0,0)");var d=CanvasXpress.doc;var p=[base+"Color"];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[base+"Color"]={C:"Color for the "+desc+"<br>",D:this[base+"Color"],M:cat,T:"color"}};this.ww=function(base,color,desc,cat,k){this[base]=color||"rgb(0,0,0)";var d=CanvasXpress.doc;var p=[base];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[base]={C:"Color for the "+desc+"<br>",D:this[base],M:cat,T:"color"}};this.F3=function(name,def,opts,desc,cat,k){this[name]=def||false;var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,O:opts,T:"string"}};this.QM=function(name,def,opts,desc,cat,k){this[name]=def||"";var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,O:opts,T:"string"}};this.Hx=function(name,def,desc,cat,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"string"}}};this.oV=function(name,def,desc,cat,k){this[name]=def==null?null:(def||0);if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"integer"}}};this.Zq=function(name,def,desc,cat,k){this[name]=def!=null?def:null;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"float"}}};this.gK=function(name,def,desc,cat,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"boolean"}}};this.UZ=function(name,def,desc,cat,k){this[name]=def||[];if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"array"}}};this.jY=function(name,def,desc,cat,k){this[name]=def==false?false:(def||[]);if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"array"}}};this.hM=function(name,def,desc,cat,k){this[name]=def==false?false:{};if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"object"}}};this.L3=function(name,def,desc,cat,k){this[name]=def||{cases:[],comp:[],op:[],type:[],value:[]};if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"filter"}}};this.bN=function(name,def,desc,cat,k){this[name]=def||false;if(k){var d=CanvasXpress.doc;var p=[name];k.push.apply(k,p);this.cN(cat);d.M[cat].P=d.M[cat].P.concat(p);d.P[name]={C:desc+"<br>",D:this[name],M:cat,T:"url"}}};this.YN=function(base,fill,color,size,type,desc,cat,k){this.RY(base,fill||"rgba(255,255,255,0)",desc,cat,k);this.RY(base+"Border",color||"rgba(255,255,255,0)","border in "+desc,cat,k);this.Zq(base+"BorderSize",size||0.5,"Size for the border line in "+desc,cat,k);this.F3(base+"BorderLineType",type||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the border in "+desc,cat,k)};this.oe=function(base,face,color,size,scale,align,line,rotate,margin,desc,cat,k){this.QM(base+"FontStyle",face||"",["","bold","italic","bold italic"],"Font style for the "+desc,cat,k);this.RY(base,color==false?false:(color||"rgb(0,0,0)"),"text in "+desc,cat,k);this.oV(base+"FontSize",size||12,"Font size for the text in "+desc+". Be aware that auto scaling font must be turned off for this property to take effect. A more convenient way to modify the size is to use the "+base+"ScaleFontFactor",cat,k);this.Zq(base+"ScaleFontFactor",scale||1,"Scaling factor used to increase or decrease the "+desc+" font size in the canvas",cat,k);this.F3(base+"Align",align||"center",["left","center","right"],"Align for the "+desc,cat,k);this.F3(base+"Baseline",line||"middle",["top","middle","bottom"],"Baseline for the "+desc,cat,k);this.oV(base+"Rotate",rotate||0,"Rotation in degrees for the "+desc,cat,k);this.Zq(base+"Margin",margin||5,"Margin used in "+desc,cat,k)};this.fQ=function(base,show,newick,pos,color,desc,cat,k){var l=base.toLowerCase();var p=base=="Var"?["top","bottom"]:["left","right"];this.se(base+"Dendrogram",show==false?false:true,desc,cat,k);this.Hx(l+"DendrogramNewick",newick||false,"Dendrogram in Newick format for the "+desc,cat,k);this.wA(l+"Dendrogram",pos,p,desc+" in the plot. It could be top, bottom, right or left depending on the orientation of the graph",cat,k);this.F3("color"+base+"DendrogramBy",color||false,[false],"Name of metadata annotation to color the "+desc,cat,k)};this.Mc=function(base,color,size,len,type,show,desc,cat,k){this.RY(base,color,desc,cat,k);this.Zq(base+"Size",size||0.5,"Size for the "+desc,cat,k);this.Zq(base+"Length",len||null,"Length for the "+desc,cat,k);this.js(base,type,desc,cat,k);this.db(base,show,desc,cat,k)};this.pO=function(base,show,height,desc,cat,k){this.gK(base+"HistogramShow",show==false?false:true,"Flag to show/hide the histogram in the "+desc,cat,k);this.oV(base+"HistogramHeight",height||80,"Size in pixels for the histogram in the "+desc,cat,k)};this.s2=function(base,show,height,pos,desc,cat,k){this.gK(base+"RugShow",show==false?false:true,"Flag to show/hide a data rug in the "+desc,cat,k);this.oV(base+"RugHeight",height||80,"Size in pixels for the data rug in the "+desc,cat,k);this.F3(base+"RugPosition",pos?pos[0]:false,pos,"Position for the data rug in the"+desc,cat,k)};this.wA=function(base,pos,opts,desc,cat,k){this.F3(base+"Position",pos||"right",opts,"Position for the "+desc,cat,k)};this.To=function(base,dir,desc,cat,k){this.F3(base+"Direction",dir||"vertical",["vertical","horizontal"],"Direction for "+desc,cat,k)};this.se=function(base,show,desc,cat,k){this.gK("show"+base,show==false?false:true,"Flag to show/hide the "+desc,cat,k)};this.db=function(base,show,desc,cat,k){this.gK(base+"Show",show==false?false:true,"Flag to show/hide the "+desc,cat,k)};this.js=function(base,style,desc,cat,k){this.F3(base+"LineType",style||"solid",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line for the "+desc,cat,k)};this.LC=function(base,trn,desc,cat,k){this.F3(base+"Transform",trn||false,[false,"log2","log10","exp2","exp10","percentile"],"Type of transformation for values in "+desc,cat,k)};this.Sr=function(base,desc,cat,k){var c=base.toUpperCase();var s=c=="Y"?["Top","Bottom"]:c=="X"?["Right","Left"]:[];var p=c=="Y"?["left","rigth","both"]:c=="X"?["bottom","top","both"]:false;var f=c=="Y"?" on the left":c=="X"?" on the bottom":"";var a=c=="Y"?" on the right":c=="X"?" on the top":"";var t=c=="Z"?10:5;if(c!="R"){this.UZ(base+"Axis",[],"Name of the samples, groups or variables to be displayed in the "+desc,cat,k);this.UZ(base+"AxisIndices",[])}if(c=="X"){this.UZ(base+"Axis2",[],"Name of the samples, groups or variables to be displayed in the second "+desc,cat,k)}this.oV(base+"AxisCurrent",0,"Sample id that is currently displayed in the "+desc+". Important when there are more that one series displayed in the graph",cat,k);this.gK(base+"AxisShow",true,"Flag to show/hide the "+desc+f,cat,k);if(c=="X"||c=="Y"){this.gK(base+"Axis2Show",false,"Flag to show/hide the "+desc+a,cat,k)}if(c!="R"){this.Zq("setMin"+c,null,"Set the minimum value for data in the "+desc,cat,k);this.Zq("setMax"+c,null,"Set the maximum value for data in the "+desc,cat,k)}this.Zq(base+"AxisAbsMin",null);this.Zq(base+"AxisAbsMax",null);this.Hx(base+"AxisMaxStrLength",false);this.Zq(base+"AxisMin",null);this.Zq(base+"AxisMax",null);this.Zq(base+"AxisRange",null);this.Zq(base+"AxisIncr",null);this.Zq(base+"AxisDecs",null);this.gK(base+"AxisExtensionMin",false);this.gK(base+"AxisExtensionMax",false);if(c=="X"){this.Zq("setMin"+c+2,null,"Set the minimum value for data in the second "+desc,cat,k);this.Zq("setMax"+c+2,null,"Set the maximum value for data in the second "+desc,cat,k);this.Zq(base+"Axis2AbsMin",null);this.Zq(base+"Axis2AbsMax",null);this.Hx(base+"Axis2MaxStrLength",false)}this.gK(base+"AxisTime",false,"Flag to force date format in "+desc,cat,k);this.gK(base+"AxisExact",false,"Flag to force exact values in "+desc,cat,k);this.UZ(base+"AxisValues",[]);this.UZ(base+"AxisValuesRaw",[]);this.UZ(base+"AxisMinorValues",[]);if(c=="X"){this.UZ(base+"Axis2Values",[]);this.UZ(base+"Axis2ValuesRaw",[]);this.UZ(base+"Axis2MinorValues",[])}this.LC(base+"Axis",false,desc,cat,k);this.gK(base+"AxisTransformTicks",false,"Flag to transform the values of the ticks in the "+desc,cat,k);this.Zq(base+"AxisCeilValue",null,"Value to ceil the data in the "+desc,cat,k);this.Zq(base+"AxisFloorValue",null,"Value to floor the data in the "+desc,cat,k);this.Zq(base+"AxisFactorValue",null,"Value to factor the data in the "+desc,cat,k);this.Hx(base+"AxisTitle",false,desc+" title "+f,cat,k);this.Hx(base+"Axis2Title",false,desc+"2 title "+a,cat,k);this.gK(base+"AxisTitleDynamic",false,"Set the title for the "+desc+" dynamically as it changes when configured by the user",cat,k);this.Mc(base+"AxisTickGuide","rgb(204,204,204)",0.5,5,"solid",true,"side tick lines indicators in the "+desc+f,cat,k);this.Mc(base+"AxisTick","rgb(204,204,204)",0.5,null,"solid",true,"tick lines across the "+desc,cat,k);for(var i=0;i<s.length;i++){this.Mc(base+"AxisTick"+s[i],"rgb(204,204,204)",0.5,null,"solid",i==1,s[i].toLocaleLowerCase()+" tick line across the "+desc,cat,k)}this.Hx(base+"AxisTickFormat",false,desc+" format for the tick values in the "+desc+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',cat,k);this.oV(base+"AxisTicks",t,"Approx number of tick lines in the "+desc,cat,k);if(c=="X"){this.Hx(base+"Axis2TickFormat",false,desc+" format for the tick values in the second "+desc+'. It could be a string with the sprintf format or an array where the first parameter is the sprintf format and the second parameter is a modification applied to the value before is passed to the sprintf function, i.e. ("/1000", "+ 100", etc.)',cat,k);this.oV(base+"Axis2Ticks",t,"Approx number of tick lines in the second "+desc,cat,k)}this.gK(base+"AxisTicksMinorShow",true,"Flag to show/hide the minor tick lines in the "+desc,cat,k);this.gK(base+"AxisTicksMajorShow",true,"Flag to show/hide the major tick lines in the "+desc,cat,k);if(c=="X"||c=="Y"){this.pO(base+"Axis",false,80,desc,cat,k);if(p){this.s2(base+"Axis",false,15,p,desc,cat,k)}}};this.PI=function(){var k=CanvasXpress.config;this.F3("graphType","Bar",["Bar","Line","Area","AreaLine","BarLine","Boxplot","Dotplot","DotLine","Fish","Gantt","Meter","Heatmap","Stacked","StackedLine","StackedPercent","StackedPercentLine","Tree","Treemap","TagCloud","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Correlation","Pie","Venn","Network","Genome","Circular"],"Specifies the type of graph","General",k);this.F3("graphOrientation","horizontal",["horizontal","vertical"],"Specifies the orientation of one dimensional graphs","General",k);this.Zq("transparency",null,"Percentage of transparency applied to all elements in the visualizations","General",k);this.Zq("transparencyHidden",0.1,"Percentage of transparency applied to elements that are hidden","General",k);this.gK("canvasBox",false,"Flag to draw a box around the canvas","General",k);this.RY("canvasBox","rgb(204,204,204)","box around the canvas","General",k);this.gK("plotBox",false,"Flag to draw a box around the x,y coordinates of the plot","General",k);this.RY("plotBox","rgb(204,204,204)","box around the x,y coordinates of the plot","General",k);this.gK("invertGraph",false,"Flag to invert horizontal one dimensional graphs to plot from right to left","General",k);this.F3("view","canvas",["canvas","table","layout"],"Specify the starting view of the data","General",k);this.gK("isR",false,"Flag to indicate is running from the R library. For developers only","General",k);this.gK("isCxplot",false,"Flag to indicate is using cxplot","General",k);this.gK("isReproducibleResearch",true,"Flag to indicate to track user modifications for Reproducible Research. For developers only","General",k);this.oV("reproduceTime",500,"Time to wait in milliseconds to reproduce user modifications through the UI","General",k);this.F3("printType","download",["download","window"],"Type of printing when the camera icon in the UI is pressed. Download is to download the image while window is to save the image in a new browser window","General",k);this.oV("printMagnification",1,"Print Magnification to produce High Definition images. Courtesy of Baohong Zhang","General",k);this.gK("printThumbnail",false,"Print thumbnail","General",k);this.gK("cacheBase64",false,"Cache image in meta data as Base64","General",k);this.gK("editable",true,"Editable in JS Fiddle and CodePen","General",k);this.gK("highlightGreyOut",false,"Flag to add grey out when highlighting with mouse over","General",k);this.Zq("highlightGreyOutTransparency",0.67,"Fraction of transparency for grey out when highlighting with mouse over","General",k);this.F3("theme","none",["none","economist","excel","tableau","stata","igray","solarized","paulTol","ggplot","wallStreetJournal","cx"],"Themes for the plot. This parameter will overwrite colors, background, axes, etc","General",k);this.gK("useRawLines",false,"Use raw lines rather than potentially crisp lines. Use only with circular graphs and networks","General",k);this.oV("fullTextMeasureCheck",500,"Full thorough check of variable and sample names when more than the specified number. This is useful for large data sets as canvas has not an efficent maner to measure text","General",k);this.Hx("saveFilename",false,"Filename to use when downloading the canvas as an image or as json. If not specified. the filename will be based on the target id of the canvas. cX- + canvas.targetId + extension","General",k);this.gK("skipRender",false,"Flag to skip initial rendering","General",false);this.UZ("tags",[],"Tags","General",k);this.Zq("createVersion",false,"CanvasXpress Version used to create plot. This is parsed from the PNG or JSON data loaded","General",false);this.hM("createFactory",false,"CanvasXpress Factory used to create plot. This is parsed from the PNG or JSON data loaded","General",false);this.hM("metaData",{},"Meta data for files read from a url","General",k);this.Hx("password",false,"Password to protect exploring data","General",k);this.UZ("functions",[],"Functions exposed to the api","General",false);this.hM("aes",{},"Initial Configuration passed to cxplot","cxplot",k);this.hM("ggplot",{},"Initial ggplot configuration passed to cxplot","cxplot",k);this.F3("effect","none",["none","magic","puffIn","openDownLeft","openDownLeftOut","perspectiveDown","rotateDown","twisterInDown","puffOut","openDownRight","openDownRightOut","perspectiveUp","rotateUp","twisterInUp","vanishIn","openUpLeft","openUpLeftOut","perspectiveLeft","rotateLeft","swap","vanishOut","openUpRight","openUpRightOut","perspectiveRight","rotateRight","openDownLeftReturn","perspectiveDownReturn","openDownRightReturn","perspectiveUpReturn","openUpLeftReturn","perspectiveLeftReturn","openUpRightReturn","perspectiveRightReturn","slideDown","swashOut","tinRightOut","bombRightOut","boingInUp","spaceOutUp","slideUp","swashIn","tinLeftOut","bombLeftOut","boingOutDown","spaceOutRight","slideLeft","foolishIn","tinUpOut","spaceOutDown","slideRight","holeOut","tinDownOut","spaceOutLeft","slideDownReturn","tinRightIn","spaceInUp","slideUpReturn","tinLeftIn","spaceInRight","slideLeftReturn","tinUpIn","spaceInDown","slideRightReturn","tinDownIn","spaceInLeft"],"Effect used to show widgets Magic - Ver 1.3.0 - https://minimamente.com","Effect",k);this.Hx("codeEffectIn","slideLeftReturn2","Code Effect In","Effect",k);this.Hx("codeEffectOut","slideLeft","Code Effect Out","Effect",k);this.Hx("customizerEffectIn","slideLeftReturn","Customize Effect In","Effect",k);this.Hx("customizerEffectOut","slideUp2","Customizer Effect Out","Effect",k);this.Hx("datafilterEffectIn","slideRightReturn","Data Filter Effect In","Effect",k);this.Hx("datafilterEffectOut","slideRight","Data Filter Effect Out","Effect",k);this.Hx("datatableEffectIn","slideUpReturn","Data Table Effect In","Effect",k);this.Hx("datatableEffectOut","slideDown3","Data Table Effect Out","Effect",k);this.Hx("tabpanelEffectIn","slideDownReturn2","Tab Panel Effect In","Effect",k);this.Hx("tabpanelEffectOut","slideDown2","Tab Panel Effect Out","Effect",k);this.Hx("motionEffectIn","swashIn","Motion Effect In","Effect",k);this.Hx("motionEffectOut","holeOut","Motion Effect Out","Effect",k);this.Hx("remoteEffectIn","holeIn","Remote Effect In","Effect",k);this.Hx("remoteEffectOut","holeOut","Remote Effect Out","Effect",k);this.Hx("toolbarEffectIn","holeIn","Toolbar Effect In","Effect",k);this.Hx("toolbarEffectOut","holeOut","Toolbar Effect Out","Effect",k);this.Hx("tooltipDivEffectIn","holeOut","Tooltip Div Effect In","Effect",k);this.Hx("tooltipDivEffectOut","spaceInUp","Tooltip Div Effect Out","Effect",k);this.gK("gradient",false,"Flag used to apply gradients to all objects in the graphs","Gradients",k);this.F3("gradientType","radial",["linear","radial"],"Specifies the gradient pattern","Gradients",k);this.F3("gradientOrientation","vertical",["vertical","horizontal"],"Specifies the orientation of the gradient if the gradient type is of the type linear","Gradients",k);this.Zq("gradientRatio",1.3,"Specifies the ratio used to generate linear gradients","Gradients",k);this.gK("adjustAspectRatio",true,"Flag to automatically adjust the size of the bars or points in the one dimensional plots to fit in the provided canvas width and height. If the flag is set to false the width and height of the canvas will be sized according to the number of bars or points in the data set","Aspect Ratio, Space and width",k);this.Zq("percentAspectRatioPlotArea",0.5,"Specifies the minimum percentage for the plotting area","Aspect Ratio, Space and width",k);this.Zq("fixedAspectRatio",0,"Keep fixed aspect ratio expressed as y / x. A zero value is used to ignore otherwise the x and y axes are set accordingly","Aspect Ratio, Space and width",k);this.oV("variableSpace",2,"Pixels between the variables in the one dimensional plots","Aspect Ratio, Space and width",k);this.oV("widthFactor",1,"Factor to adjust the width of the bars in the one dimensional and the three dimensional plots. The greater the number, the wider the bars","Aspect Ratio, Space and width",k);this.oV("dataPointSize",15,"Approximate size for the data points in scatter plots, dotplots and boxplots. The size will be adjusted according to the dimensions of the graph","Aspect Ratio, Space and width",k);this.Zq("dataPointSizeScaleFactor",1,"Factor used to adjust the size of the dataPointSize","Aspect Ratio, Space and width",k);this.oV("adjustAspectRatioMax",3,"Specifies the number of times to try to automatically adjust the size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.oV("adjustAspectRatioYTries",0,"Counter set when trying to automatically adjust the vertical size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.oV("adjustAspectRatioXTries",0,"Counter set when trying to automatically adjust the horizontal size of the canvas when adjustAspectRatio is true","Aspect Ratio, Space and width",false);this.oV("setPlotX",0,"Force the x dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.oV("setPlotY",0,"Force the y dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.oV("setPlotLeft",0,"Force the left dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.oV("setPlotTop",0,"Force the top dimension for the data plot in one dimensional graphs","Aspect Ratio, Space and width",k);this.ww("foreground","rgb(0,0,0)","Specifies the foreground color for text or lines not covered in a more specific configuration property","Foreground and Background",k);this.ww("background","rgb(255,255,255)","Specifies the background color for the canvas","Foreground and Background",k);this.ww("backgroundWindow","rgb(244,244,244)","Specifies the background color for the canvas when the background type is of a type window","Foreground and Background",k);this.F3("backgroundType","solid",["solid","gradient","window","windowGradient","windowSolidGradient","image","windowImage"],"Specifies the style for the background of the canvas. The canvas background is composed of a frame with a window where the data is plotted. Either of these elements the may be a solid or gradient color or an image of your choosing. The colorScheme property will be used If gradient is specified","Foreground and Background",k);this.bN("backgroundImage",false,"Specifies the url for the background image when the background type is of the type image or windowImage","Foreground and Background",k);this.Hx("backgroundImageSrc",false,"Specifies the source for the background image when the background type is of the type image or windowImage","Foreground and Background",k);this.oV("margin",5,"Relative length in pixels for the distance between various objects in the graphs. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true","Margins",k);this.oV("marginLeft",5,"Specifies the length in pixels for the left margin in the canvas","Margins",k);this.oV("marginTop",5,"Specifies the length in pixels for the top margin in the canvas","Margins",k);this.oV("marginBottom",5,"Specifies the length in pixels for the bottom margin in the canvas","Margins",k);this.oV("marginRight",5,"Specifies the length in pixels for the right margin in the canvas","Margins",k);this.se("Shadow",false,"shadows in all graph objects in the canvas. It will be forced to false if the browser is IE","Shadows",k);this.se("TextShadow",false,"shadows in text in the canvas. It will be forced to false if the browser is IE","Shadows",k);this.oV("shadowOffsetX",1,"Length in pixels for the shadow offset in the X axis","Shadows",k);this.oV("shadowOffsetY",1,"Length in pixels for the shadow offset in the Y axis","Shadows",k);this.oV("shadowBlur",2,"Amount in blur for the shadow","Shadows",k);this.RY("shadow","rgba(0,0,0,0.5)","shadow","Shadows",k);this.Hx("topoJSON",false,"TopoJSON map string","Maps",k);this.Hx("mapId",false,"Map Id for the map div in the DOM","Maps",k);this.Hx("mapPropertyId",false,"Map Property Id use to match the data ids to the GeoJSON layer Id","Maps",k);this.F3("mapProjection","mercator",["mercator","albers","orthographic"],"Map projection","Maps",k);this.Zq("mapLatitudeOrigin",23,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",k);this.Zq("mapCentralMeridian",-96,"Map Latitude Of Origin in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",k);this.Zq("mapStandardParallel1",29.5,"Map Standard Parallel 1 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",k);this.Zq("mapStandardParallel2",45.5,"Map Standard Parallel 2 in degrees. (Applicable to Albers projection only). Default adjusts to USA maps","Maps",k);this.gK("mapGraticuleShow",false,"Show Map Graticule","Maps",k);this.F3("mapGraticuleType","solid",["dashed","solid"],"Map Graticule type","Maps",k);this.hM("mapConfig",false,"Map config","Maps",k);this.hM("mapConfigFeatures",false,"Map config for features use to translate and scale","Maps",k);this.UZ("mapSmps",[],"Samples to use in maps","Maps",k);this.UZ("hiddenMapFeatures",[],"Hidden Map features","Maps",k);this.UZ("visibleMapFeatures",[],"Visible Map features. It Overrides the hidden features","Maps",k);this.RY("map","rgb(105,210,230)","maps","Maps",k);this.RY("mapOutline","rgb(204,204,204)","outline of the maps","Maps",k);this.F3("mapMarkerShape","drop",["drop","sphere","square","triangle","star","rhombus","octagon","mdavid","pentagon","rectangle"],"Default shape for the markers in map (if no shapeBy is specified","Maps",k);this.Zq("mapMarkerShapeScaleFactor",1,"Scale factor for the marker shapes","Maps",k);this.gK("useLeaflet",false,"Use leaflet","Maps",k);this.Zq("leafletAlpha",0.7,"Transparency for leaflet layers","Maps",k);this.Zq("leafletZoomAlphaColor",6,"Zoom level before turning transparent the leaflet layers","Maps",k);this.F3("leafletTileType","street",["street","terrain","labels","satellite"],"Leaflet tile type","Maps",k);this.UZ("fonts",[],"Goggle Fonts","Text",k);this.UZ("fontsExternal",[],"External Fonts","Text",k);this.F3("fontName","Arial",Object.keys(CanvasXpress.fonts),"Font name. Web-Safe HTML fonts","Text",k);this.QM("fontStyle","",["","bold","italic","bold italic"],"Font style","Text",k);this.RY("font","rgb(0,0,0)","font","Text",k);this.oV("fontSize",12,"Font size for text in complex plot only. See other categories to modify specific font sizes","Text",k);this.Zq("fontScaleFontFactor",1,"Scaling factor used to increase or decrease the font size in the canvas","Text",k);this.F3("align","center",["right","center","left"],"Default horizontal alignment for drawing text","Text",k);this.F3("baseline","middle",["top","middle","bottom"],"Default vertical alignment for drawing text","Text",k);this.oV("maxTextSize",40,"Maximum size for any text in the canvas","Text",k);this.oV("minTextSize",4,"Minimum size for any text in the canvas","Text",k);this.gK("autoScaleFont",true,"Flag to automatically adjust the font size in many visualization. Please be aware that scaling factors can still modify the font size. This flag needs to be false for the text to accept the specified font size","Text",k);this.oV("scaleTextConstantMult",25,"Constants to autoscale text","Text",false);this.Zq("scaleTextConstantAdd",2,"Constants to autoscale text (extra)","Text",false);this.gK("optimizeTextPosition",false,"Flag to optimize position for text in many plots","Text",k);this.F3("optimizeTextPositionStrategy","annealing",["annealing","greedy","boundingBox","none"],"Startegy to optimize placement of text","Text",k);this.gK("optimizeTextPositionEnforceBounds",false,"Flag to enforce bounds when optimizing position for text in many plots","Text",k);this.gK("optimizeTextPositionRemoveOverlaps",false,"Flag to remove overlaps when optimizing position for text in many plots","Text",k);this.oV("optimizeTextPositionTemperature",1000,"Temperature parameter when optimizing position for text in many plots","Text",k);this.oV("optimizeTextPositionCooling",1,"Cooling parameter when optimizing position for text in many plots","Text",k);this.Hx("title",false,"Title of the graph","Titles and Subtitles",k);this.Hx("subtitle",false,"Subtitle of the graph","Titles and Subtitles",k);this.oe("title","","rgb(0,0,0)",16,1,"center","middle",0,5,"title","Titles and Subtitles",k);this.YN("titleBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",0.5,"solid","title background","Titles and Subtitles",k);this.oe("subtitle","","rgb(0,0,0)",14,1,"center","middle",0,5,"subtitle","Titles and Subtitles",k);this.YN("subtitleBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",0.5,"solid","subtitle background","Titles and Subtitles",k);this.Hx("citation",false,"A reference citation of the graph which is placed at the bottom right corner","Citations or References",k);this.oe("citation","","rgb(0,0,0)",8,1,"right","middle",0,5,"citations","Citations or References",k);this.oV("dashLength",8,"Size in pixels of the length of the dashes and the separation between the dashes in the dashed lines","Lines",k);this.oV("dotLength",1,"Size in pixels of the length between dots in the doted lines","Lines",k);this.Zq("arrowQuadraticFactor",2.3,"Factor to use to bend the quadratic lines","Lines",k);this.F3("arrowHeadType","filledArc",["unFilled","filledStraight","filledArc","filledQuadratic","filledBezier"],"Type for the head of the arrows","Lines",k);this.oV("arrowHeadSize",10,"Size in pixels of the arrow head in arrow lines","Lines",k);this.Zq("arrowHeadAngle",22.5,"The angle for the head of the arrow","Lines",k);this.F3("capType","butt",["butt","round","square"],"Default type of cap for lines","Lines",k);this.F3("joinType","mitter",["mitter","bevel","round"],"Default type for joining lines","Lines",k);this.oV("lineWidthEvent",0.5,"Size in pixels of the width for the events in the lines","Lines",false);this.Zq("outlineWidth",1,"Default width in pixels for lines in networks and other line elements in all visualizations except for the lines in the line plots","Lines",k);this.Zq("lineThickness",1,"Default thickness in pixels for the lines in line plots","Lines",k);this.gK("adjustBezier",false,"Flag to automatically select the bezier line type. the bezier can start from the top or bottom (vertical), or from the side (horizontal). This will be based on the location of the two points joined by the line","Lines",k);this.UZ("lines",["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC"],"Line types in network graphs for the edges (or connections) between network nodes.<br> There are three styles: solid, dashed and dotted and four sub types: straight, bezier, curved (clockwise) and curvedCC (counter clockwise). The line types can be any combination of a style followed by a subtype. By default the type is always a solid straight line so there is no need to specify solid or stright as a style if there is a subtype.<br> Lines can also have elbows which are specified as a 2D-array. In the case a straight solid line each elements in the array will have an x,y coordinate and each segment will be perpendicular to the previous one. For example in this edge object:<br> <i>{ ..., type : line, elbows : [ [20, 40], [60, 80] ], ... }</i><br> A special subtype of line called segmented can also have elbows which are not perpendicalar to each other. For example in this edge object:<br> <i>{ ..., type : segmented, elbows : [ [20, 40], [60, 80] ], ... }</i><br> In the case of a bezier curved each element of the array will have an x,y coordinate for the control point 1, an x,y coordinate for the control point 2 and an x,y coordinate for the end of the line.<br> <i>{ ..., type : bezier, elbows : [ [20, 40, 40, 20, 40, 40], ... ], ... }</i><br> If the property elbow is specified the line will be drawn using the first and last elements of the array rather than the coordinates of the two nodes. A property startX and startY can be used to better adjust the position of the starting line. Similarly, a property endX and endY can be used to better adjust the position of the end line. These properties have a maginitud between -1 to 1 which will be used based on the width and height of the source and target node. For example in the following edge object the line will start in the middle bottom of the source node and will end at the upper left of the target node.<br>  <i>{ ..., type : line, startX : 0, startY : 1, endX : -1, endY : -0.5, ... }</i>","Lines",false);this.UZ("arrows",["arrow","square","round"],"Arrows for the edges (or connections) in network graphs.<br> There are three arrow types: arrow, square and round. They can be at the start or at the end of the line. To specify an arrow at the start of the line include a startArrow property in the edge; to specify an arrow at the end of the line include a endArrow property in the edge. For example in this edge object:<br> <i>{ ..., type : line, startArrow : square, endArrow : arrow, ... }</i>","Lines",false);this.F3("colorScheme","User",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color schemes can be user defined which will take the colors in the color property or one provided in canvasXpress. The order of the colors will be used to sequentially select when a different color is needed in a particular visualization","Colors",k);this.UZ("colors",["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"],"Colors","Colors",k);this.UZ("colorHSV",[0,0,1],"Color HSV. Hue, Saturation and Value used when configuring colors","Colors",false);this.UZ("colorRGB",[1,1,1],"Color RGB. Red, Green, Blue used when configuring colors","Colors",false);this.UZ("colorSpectrum",["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"],"An array with valid color names to create a color brew for the default color indicators","Colors",k);this.UZ("colorSpectrumBreaks",[],"An array with numbers in ascending order for the color spectrum to create discontinuous spectra. It must have the same length of the colorSpectrum array for example [0, 0.3, 1]","Colors",k);this.Zq("colorSpectrumZeroValue",null,"A value to be at the center of the color spectrum to produce symmetrical heatmaps","Colors",k);this.oV("colorSpectrumNumber",100,"Number of colors to use in the color spectrum","Colors",k);this.oV("colorSpectrumTarget",10,"Approximate number of colors to use to build the color spectrum","Colors",k);this.RY("odd","rgb(255,255,255)","odd numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots","Colors",k);this.RY("even","rgb(245,245,245)","even numbers in samples when the property block contrast is set in one dimensional plots or the color for odd number residues in translations in genome plots","Colors",k);this.F3("blindnessType",false,[false,"protanopia","deuteranopia","tritanopia","monochromatic"],"Color Blindness","Colors",k);this.oV("roundedPolygonRadius",5,"Radius for rounded polygons","Shapes",k);this.gK("useRoundRectangles",false,"Use round rectangles in bar graphs, stacked graphs and boxplots","Shapes",k);this.F3("plotStyle","default",["default","ggplot","ggplotSwitched","open","border"],"Style for some shapes used mainly in boxplot, violin and density plots","Data Point Attributes",k);this.UZ("shapes",["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","pentagon","rect3","arc","rectangle","image"],"Array with shapes used in visualizations. The order will dictate the utilization in the visualization","General Attributes",k);this.UZ("sizes",[8,12,16,20,24,28,32,36,40,44,48],"Array with sizes used invisualizations. The order will dictate the utilization in the visualization","General Attributes",k);this.UZ("images",[],"Array of urls of images used in scatter plots. Additional shapes will be used if the array does not contain as many images as needed","General Attributes",k);this.UZ("patterns",["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"],"Patterns used in visualizations to fill objects. This array must contain one or more pattern names and in concert with the color array can be used to specify the pattern colors for all filled objects in the visualizations.. The order will dictate the utilization in the visualization","General Attributes",k);this.UZ("linePatterns",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line Patterns used in line visualizations","General Attributes",k);this.oV("maxSmpStringLen",25,"Maximum length in characters a sample label or description can have so anything above is truncated","Samples",k);this.Hx("smpTitle",false,"Title for the sample axis in one dimensional plots","Samples",k);this.oV("smpLabelInterval",1,"Interval for the sample labels in one dimensional and circular plots","Samples",k);this.gK("smpLabelImage",false,"Use images as sample labels when possible","Samples",k);this.gK("smpLabelImageRound",false,"Use round images as sample labels","Samples",k);this.se("SampleNames",true,"sample names","Samples",k);this.UZ("highlightSmp",[],"Name of samples to highlight","Samples",k);this.RY("smpHighlight","rgb(255,0,0)","higlighted samples","Samples",k);this.oe("smpTitle","","rgb(0,0,0)",13,1,"center","middle",0,5,"sample title","Samples",k);this.oe("smpLabel","","rgb(0,0,0)",12,1,"center","middle",0,5,"sample labels","Samples",k);this.oV("maxVarStringLen",25,"Maximum length in characters a variable label or description can have so anything above is truncated","Variables",k);this.Hx("varTitle",false,"Title for the variables in hetamap plots","Variables",k);this.oV("varLabelInterval",1,"Interval for the variable labels in heatmaps","Variables",k);this.se("VariableNames",true,"variable names","Variables",k);this.UZ("highlightVar",[],"Name of variables to highlight","Variables",k);this.RY("varHighlight","rgb(255,0,0)","higlighted variables","Variables",k);this.oe("varTitle","","rgb(0,0,0)",13,1,"center","middle",0,5,"variable title","Variables",k);this.oe("varLabel","","rgb(0,0,0)",12,1,"center","middle",0,5,"variable labels","Variables",k);this.hM("binConfigurations",{},"Properties for the binning functions","Bins",k);this.oV("maxOverlayStringLen",30,"Maximum length in characters for the sample or variable metadata when included as an overlay. Anything above is truncated","Overlays",k);this.oV("overlaysThickness",18,"Relative length in pixels for the thickness of the colored boxes to classify samples and or variables in one dimensional plots. This value is adjusted acording to the graph dimensions if the adjustAspectRatio parameter is set to true","Overlays",k);this.UZ("smpOverlays",[],"Sample metadata to overlay in one dimensional plots","Overlays",k);this.hM("smpOverlayProperties",{},"Object to assign properties of the sample overlays. The key should be a valid sample annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes","Overlays",k);this.oV("smpOverlaysLegendColumns",1,"Number of columns for the sample overlay legends","Overlays",k);this.se("SmpOverlaysLegend",false,"sample overlay legends","Overlays",k);this.UZ("varOverlays",[],"Variable metadata to overlay in heatmap plots","Overlays",k);this.hM("varOverlayProperties",{},"Object to assign properties of the variable overlays. The key should be a valid variable annotation (metadata) and the value and object with properties like: type, color, spectrum, scheme, showLegend, showName, showBox, rotate, position, thicknes","Overlays",k);this.oV("varOverlaysLegendColumns",1,"Number of columns for the variable overlay legends","Overlays",k);this.se("VarOverlaysLegend",false,"sample overlay legends","Overlays",k);this.wA("overlaysLegend","topRight",["topRight","right","bottomLeft","bottom"],"the variable and sample overlays legend","Overlays",k);this.se("Overlays",true,"overlays in one dimensional plots","Overlays",k);this.se("LevelOverlays",true,"overlay levels (values) in one dimensional plots","Overlays",k);this.oe("overlay","","rgb(0,0,0)",12,1,"center","middle",0,5,"overlays","Overlays",k);this.gK("legendInside",false,"Position the legend inside the graphs","Legends",k);this.oV("legendColumns",1,"Number of columns in legends","Legends",k);this.oV("legendRows",1,"Number of rows in legends","Legends",k);this.hM("legendOrder",false,"Object to specify custom order for the levels in the legends. The key of the object is the name of a valid sample or variable annotation included in the data object. The value for element is an array with the levels for the corresponding factor","Legends",k);this.gK("legendOrderByCols",true,"Draw legends by columns in the graphs","Legends",k);this.UZ("customLegend",[],"Custom legends : Array of objects [{ size : [], shape : [], shapeColor : [], line : [], lineColor : [], lineStart : [], lineEnd : [], text : [], x : number, y : number, title : string }]","Legends",k);this.se("Legend",true,"legend","Legends",k);this.se("ColorNodeLegend",true,"legend node color","Legends",k);this.se("ShapeNodeLegend",true,"legend node shape","Legends",k);this.se("SizeNodeLegend",true,"legend node size","Legends",k);this.se("PatternNodeLegend",true,"legend node pattern","Legends",k);this.se("ColorEdgeLegend",true,"legend edge color","Legends",k);this.se("SizeEdgeLegend",true,"legend edge size","Legends",k);this.se("LegendTitle",true,"the legend title","Legends",k);this.se("LegendBorder",true,"the legend border","Legends",k);this.wA("legend","right",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the legend","Legends",k);this.To("legend","vertical","legend","Legends",k);this.YN("legendBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",0.5,"solid","legend background","Legends",k);this.YN("legendKeyBackground","rgba(255,255,255,0)","rgba(255,255,255,0)",1,"solid","legend key background","Legends",k);this.oe("legendText","","rgb(0,0,0)",12,1,"left","middle",0,8,"legends","Legends",k);this.oe("legendTitle","","rgb(0,0,0)",13,1,"center","middle",0,8,"legends","Legends",k);this.oV("decorationsWidth",20,"Length in pixels of the width for the decorations in the networks","Decorations",k);this.oV("decorationsHeight",40,"Length in pixels of the height for the decorations in the networks","Decorations",k);this.F3("decorationsType","bar",["pie","bar","heatmap","stacked","stackedpercent"],"Type for the decorations in the networks. The types stacked and stackedpercent must be two dimensional. Heatmap could be one or two dimensional","Decorations",k);this.hM("decorations",false,"Name of the node properties to include in the network decorations in the data.nodes object","Decorations",k);this.UZ("decorationsColors",[],"Array of colors used for selection in network decorations not to be confused by its singular form decorationsColor above","Decorations",k);this.hM("decorationsProperties",{},"Object to assign properties like color for the network decorations","Decorations",k);this.gK("decorationsClipped",true,"Clipp decorations to the x,y area of the plot.","Decorations",k);this.Zq("decorationsTransparency",0.2,"Transparency for range decorations","Decorations",k);this.se("Decorations",true,"decorations","Decorations",k);this.se("DecorationsLegend",true,"decoration legends","Decorations",k);this.se("DecorationsBorder",false,"the decoration legends border","Decorations",k);this.wA("decorations","bottom",["topRight","right","bottomRight","bottom","bottomLeft","left","topLeft","top"],"the decorations","Decorations",k);this.YN("decorationsBackground","rgba(255,255,255,0)","rgb(204,204,204)",0.5,"solid","decoration legends background","Decorations",k);this.oe("decorationsText","","rgb(0,0,0)",12,1,"center","middle",0,5,"decoration legends","Decorations",k);this.gK("decorationsOnTop",false,"Draw decorations after drawing the data","Decorations",k);this.gK("decorationsTransform",true,"Transform the data in decorations produced in Cxplot","Decorations",k);this.gK("isGroupedData",false,"Flag to indicate if the data is grouped","Data",false);this.gK("isBoxplotCalc",false,"Flag to indicate if the iqr has been calculated when the graph type is Boxplot","Data",false);this.UZ("groupingFactors",[],"An array that holds the group names used for grouping the data. It must be a category in the data.x object","Data",k);this.UZ("segregateSamplesBy",[],"An array that holds the annotation(s) used to segregate the samples ala Facet way in R. It must be categories in the data.x object","Data",k);this.UZ("segregateVariablesBy",[],"An array that holds the annotation(s) used to segregate the variables ala Facet way in R. It must be categories in the data.z object","Data",k);this.Hx("splitSamplesBy",false,"Factor (in the x data object) used to split the samples ala split in complex heatmap","Data",k);this.Hx("splitVariablesBy",false,"Factor (in the z data object) used to separate the variables ala split in complex heatmap","Data",k);this.oV("splitSeparation",10,"Length in pixels to separate the splits in samples and variables","Data",k);this.F3("summaryType",false,[false,"iqr","median","mean","cor","min","max","count","sum"],"Summary type for the data when grouping","Data",k);this.gK("isTransformedData",false,"Flag to indicate if the data is transformed","Data",false);this.oV("transformBase",10,"Default log or exponential transformation for the data","Data",false);this.F3("transformData",false,[false,"log2","log10","exp2","exp10","percentile","zscore","ratio2","ratio10","save","reset","undo"],"Default transformation type for ALL the data. Data can also be transformed by axis (x,y,z) to give more flexibility. false, save, reset and undo are NOT real transformations. They are only used in the canvasXpress UIs to save the transformed data","Data",k);this.F3("transformAxis","samples",["samples","variables"],"Default axis to use to transform the data when either z-score or ratio transformation is used","Data",k);this.oV("ratioReference",0,"Default index of sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",k);this.F3("ratioSampleReference",false,[false],"Name of the sample used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",k);this.F3("ratioGroupReference",false,[false],"Name of the group used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",k);this.F3("ratioLevelReference","",[],"Name of the level used in ratio transformation. Almost private parameters used within the different CanvasXpress UIs","Data",k);this.gK("transposeData",false,"Flag to transpose data as a parameter. This parameter accomplishes the same as the function transpose at load time","Data",k);this.UZ("asSampleFactors",[],"Array containing variable names. Numeric variable data (in rows) to be treated as a sample factor (move from y to x object). This parameter accomplishes the same as the function switchVarToAnnotation at load time. It can be used in conjunction with the parameter stringSampleFactors to be treated as a string. TO DO: write example","Data",k);this.UZ("asVariableFactors",[],"Array containing sample names. Numeric sample data (in columns) to be treated as a variable factor (move from y to z object). This parameter accomplishes the same as the function switchSmpToAnnotation at load time. It can be used in conjunction with the parameter stringVariableFactors to be treated as a string. TO DO: write example","Data",k);this.UZ("stringSampleFactors",[],"Array containing sample factors. The numeric sample factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for samples at load time. It can be used in conjunction with the parameter asSampleFactors. TO DO: write example","Data",k);this.UZ("stringVariableFactors",[],"Array containing variable factors. The numeric variable factors will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for variables at load time. It can be used in conjunction with the parameter asVariableFactors. TO DO: write example","Data",k);this.UZ("stringNodeAttributes",[],"Array containing node attributes. The numeric node attributes will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for nodes at load time","Data",k);this.UZ("stringEdgeAttributes",[],"Array containing edge attributes. The numeric edge attributes will be treated as strings. This parameter accomplishes the same as the function switchNumericToString for edges at load time","Data",k);this.Hx("histogramData",false,"Flag or sample annotation to create histogram. If true is specified then the histogram will be done with all data","Data",k);this.UZ("appendNetworkData",[],"Array containing additional data files to append to networks. Useful for loading KEGG and Wikipatways to decorate the nodes and the edges","Data",k);this.oe("dataLabel","","rgb(0,0,0)",12,1,"center","middle",0,5,"data labels","Data",k);this.F3("timeFormat","isoDate",["default","shortDate","mediumDate","longDate","fullDate","shortTime","mediumTime","longTime","isoDate","isoTime","isoDateTime","isoUtcDateTime","year","month","day","hour","minute","second"],"Time Format according to date.format.js Steven Levithan <stevenlevithan.com>","Time Series",k);this.gK("isGraphTime",false,"Flag to indicate if the data is a time series so there is no need to plot every time interval. It is boolean in one dimensional plots or a string indicating the axis which is timed x, y or z","Time Series",k);this.UZ("timeValues",[],"Array containing the tick values when the the graph is a time series","Time Series",false);this.UZ("timeValueIndices",[],"Array containing the indices of the values when the the graph is a time series","Time Series",false);this.hM("timeValueProperties",{},"Object with all the time properties needed to plot the data","Time Series",false);this.F3("sortDir","ascending",["ascending","descending"],"Default direction for data sorting. Almost private parameters used within the different CanvasXpress UIs","Data sorting",k);this.gK("sortCaseSensitive",false,"Whether to use case sensitive in ascii sorting. Almost private parameters used within the different CanvasXpress UIs","Data sorting",k);this.hM("sortData",[],"Array of arrays with sorting functions. Each function takes three parameters. The first parameter must be either smp to identify the parameters are related to the samples, var to identify  the parameters are related to the variables, or cat to identify a sample or variable category. The second parameter can be either smp to indicate to sort the sample indices or var to indicate to sort the variable indices. The third parameter is the value for the key referenced by the first parameter. A special case for this parameter could be samples or variables to indicate to sort by the names of the samples or variables respectively. Here are some examples to sort the samples in the data: [ [cat, smp, Factor1] ]   : Sort the samples by the sample category Factor1 [ [var, smp, Variable1] ] : Sort the samples by the value of the Variable1 [ [cat, smp, samples] ]   : Sort the samples by their name.  Important!!!! This parameter will clean the data and remove any variables not used in the dataset at load time","Data sorting",k);this.F3("sortOnGrouping",false,[false,"ascending","descending"],"Sort the name of the groups after sample grouping.<br>","Data sorting",k);this.RY("missingData","rgb(245,245,245)","missing data","Missing Data",k);this.Hx("missingDataValue","NA","String value use to specify missing data","Missing Data",k);this.gK("nanOmit",false,"Flag to omit NaN values in log transformation","Missing Data",k);this.se("ErrorBars",true,"error bars in graphs","Error Bars",k);this.F3("errorBarsType","confidenceInterval95",["standardDeviation","standardErrorMean","confidenceInterval95"],"Type of error bars","Error Bars",k);this.RY("errorBars","rgb(0,0,0)","error bars in dotplots and barplots","Error Bars",k);this.Zq("errorBarsThickness",3,"Thickness for the error bars in dotplots","Error Bars",k);this.oV("errorBarsWidth",2,"Minimum size of the bar in pixels to determine to show or hide error bar ends in the graphs when available","Error Bars",k);this.F3("standardDeviationType","unbiased",["biased","unbiased"],"Type of Standard Deviation. biased uses n as denominator and unbiased uses (n - 1) as denominator where n is the number of values","Error Bars",k);this.oV("randomSeed",8,"Specifies the random seed number to create pseudo random numbers","Random",k);this.gK("pseudoRandom",true,"Flag to indicate to use pseudo random rather than random","Random",k);this.F3("randomMethod","numericalRecipes",["jenkins","numericalRecipes"],"Random method","Random",k);this.gK("randomData",false,"Flag to indicate random data for debug and demonstration purposes","Random",false);this.F3("randomDataDistribution","biased",["range","normal","uniform","symmetrical","biased"],"Distribution for the random data","Random",k);this.gK("randomDataTime",false,"Flag to create or not time series random data for debug and demonstration purposes","Random",k);this.oV("randomDataMin",1,"Minimun value when creating random data","Random",k);this.oV("randomDataMax",100,"Maxmun value when creating random data","Random",k);this.oV("randomDataMean",0,"Mean value when creating random data","Random",k);this.oV("randomDataSigma",1,"Sigma value when creating random data","Random",k);this.oV("randomDataVariables",3,"Default number of variables when creating random data","Random",k);this.oV("randomDataSamples",36,"Default number of samples when creating random data","Random",k);this.oV("randomDataVariableAnnotations",2,"Default number of variable annotations when creating random data","Random",k);this.oV("randomDataSampleAnnotations",2,"Default number of sample annotations when creating random data","Random",k);this.Zq("randomMissingDataPercentage",0,"Default percentage of missing values when creating random data. A value between 0 and 1","Random",k);this.gK("randomNetworkReduce",true,"Flag to create or not a single random network for debug and demonstration purposes","Random",k);this.oV("randomNetworkNodes",40,"Default number of nodes when creating random networks","Random",k);this.oV("randomNetworkNodeEdgesMax",5,"Default number of maximum edges when creating random networks","Random",k);this.gK("randomNetworkAll",true,"Use all types of colors, shapes and edges in random network, otherwise only one color, one shape and straight black lines for the edges","Random",k);this.F3("randomNetworkLayout","forceLayout",["forceDirected","circular","radial","duo","trio","pentagon","hexagon","octagon","star","small","medium","large","huge","lesmiserables","karate"],"Random network layout","Random",k);this.Zq("zoom",1,"Zoom factor for the networks. A number greater than zero","Zooming, Panning and Resizing",k);this.Zq("zoomGlobal",1,"Cumulative zoom factor for the networks","Zooming, Panning and Resizing",false);this.Zq("zoomStep",0.2,"Percentage step for zooming networks and genome panel","Zooming, Panning and Resizing",k);this.gK("zoomScale",true,"Flag to scale nodes and edges in networks with zoom and data points in 3D scatter plots","Zooming, Panning and Resizing",k);this.gK("zoomVariablesDisable",false,"Flag to disable zooming of variables with mouse wheel in Heatmaps","Zooming, Panning and Resizing",k);this.gK("zoomSamplesDisable",false,"Flag to disable zooming of samples with mouse wheel in Heatmaps","Zooming, Panning and Resizing",k);this.gK("zoomDisable",false,"Flag to disable zooming in all plots","Zooming, Panning and Resizing",k);this.Zq("panningX",0,"Number of unit to pan the network in the X dimension","Zooming, Panning and Resizing",k);this.Zq("panningY",0,"Number of unit to pan the network in the Y dimension","Zooming, Panning and Resizing",k);this.Zq("panningGlobalX",0,"Cumulative number of unit to pan the network in the X dimension","Zooming, Panning and Resizing",false);this.Zq("panningGlobalY",0,"Cumulative number of unit to pan the network in the Y dimension","Zooming, Panning and Resizing",false);this.Zq("panningStep",0.2,"Percentage step for panning networks","Zooming, Panning and Resizing",k);this.RY("resizerBackground","rgba(204,204,204,0.7)","div that shows up when resizing the canvas","Zooming, Panning and Resizing",k);this.Sr("x","X axis","X-Axis",k);this.Sr("y","Y axis","Y-Axis",k);this.Sr("z","Z axis","Z-Axis",k);this.gK("rAxisPercentShow",true,"Flag to show on not the percent in each segment in the R axis","R-Axis",k);this.F3("rAxisLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the ticks values in circular plots","R-Axis",k);this.Sr("r","R axis","R-Axis",k);this.Zq("axisExtension",0.1,"Percentage to extend the values of the data to ensure all the data points are plotted inside and not over the edges of the graph","Axis",k);this.F3("axisAlgorithm","rPretty",["heckbert","wilkinson","wilkinsonExtended","rPretty"],"Algorithm used to position tick labels on axes. See An Extension of Wilkinson’s Algorithm for Positioning Tick Labels on Axes. Justin Talbot, Sharon Lin, Pat Hanrahan","Axis",k);this.gK("axisWilkinsonLoose",false,"Flag to indicate whether to use loose positioning when using the wilkinson algorithm to position the labels on the axis. There will not be a difference most of the times","Axis",k);this.gK("axisCoordinate",false,"Flag to coordinate xAxis and xAxis2 in *-Line combination plots","Axis",k);this.Zq("setMax",null,"Maximum value to set the data","Axis",false);this.Zq("setMin",null,"Minimum value to set the data","Axis",false);this.oe("axisTick","","rgb(0,0,0)",12,1,"left","middle",0,5,"axis","Axis",k);this.oe("axisTitle","","rgb(0,0,0)",13,1,"left","middle",0,5,"axis","Axis",k);this.F3("guides",false,[false,"solid","dotted","dashed","dotdash","longdash","twodash"],"This is a thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",k);this.Zq("guidesWidth",1,"The width for the thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",k);this.RY("guides","rgb(204,204,204)","thin line that appears in the middle of the variables and / or samples in one dimensional graphs and multidimensional heatmaps just for aesthetics","Plot area",k);this.gK("blockContrast",false,"A flag to creates a shade between the samples so there are two backgrounds, one for the odd samples and one for the even samples","Plot area",k);this.gK("plotByVariable",false,"Flag to indicate whether to group the data variable rather than by sample","Plot area",k);this.gK("is3DPlot",false,"Flag to create or not a 3D plot","Plot area",k);this.se("DataValues",false,"data values in the one bar graphs","Plot area",k);this.gK("binned",false,"Flag to bin the data points in dotplots and boxplots","Plot area",k);this.F3("binAlignment","center",["left","center","right"],"Alignment for the data points when binned","Plot area",k);this.gK("jitter",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots","Plot area",k);this.Zq("jitterFactor",0.8,"Factor for jittering. The larger the more jitter","Plot area",k);this.gK("sina",false,"Flag to jitter the data points in dotplots, boxplots and scatter2D plots with sina style","Plot area",k);this.RY("objectBorder","rgb(0,0,0)","border of all objects in one dimensional graphs. It turns into the non-transparent fill color if set to false","Plot area",k);this.Zq("objectColorTransparency",1,"The transparency for the color fill of all objects in one dimensional graphs. A value between 0 and 1","Plot area",k);this.oV("dotplotOutlineThreshold",5000,"Maximum number of data points before skipping plotting their outline but only the fill color","Plot area",k);this.gK("linesOnGroups",true,"Flag to create lines on groups when multiple grouping factors are used","Plot area",k);this.F3("lineDecoration","symbol",[false,"dot","symbol","pattern"],"Lines decorations in the line graphs","Line Graphs",k);this.F3("lineErrorType","bar",["bar","area"],"Line error type in the line graphs. The line type must be spline for the area error type. ","Line Graphs",k);this.gK("coordinateLineColor",false,"Flag to used same color in BarLine plots. If set to true the color of the bars and the lines will be coordinated","Line Graphs",k);this.F3("lineType","rect",["rect","solid","spline","dotted","dashed","dotdash","longdash","twodash"],"Type of line used to join the points in line graphs","Line Graphs",k);this.Zq("tension",0.3,"Curvature for the splines and hulls","Line Graphs",k);this.oV("tensionSegments",16,"Number of segments to smooth a quadratic curve","Line Graphs",k);this.UZ("parallelCoordinates",[],"Array used to store and handle a parallel coordinates plot","Line Graphs",false);this.oV("boxplotOutliersRatio",10,"Ratio for the size of the outliers with respect to boxplot","Boxplot Graphs",k);this.RY("boxplotOutliers",false,"outlier data points in boxplots","Boxplot Graphs",k);this.RY("boxplotOutliersBorder",false,"border of outlier data points in boxplots","Boxplot Graphs",k);this.F3("boxplotOutliersShape","circle",["circle","square","triangle","diamond","plus","minus","star","circleOpen","squareOpen","triangleOpen","diamondOpen"],"Shape for the outlier data points","Boxplot Graphs",k);this.F3("boxplotWhiskersType","double",["single","double","none"],"Boxplot whiskers type","Boxplot Graphs",k);this.F3("boxplotType","boxWhiskers",["boxWhiskers","range"],"Boxplot type","Boxplot Graphs",k);this.gK("boxplotNotched",false,"Flag to notch boxplots","Boxplot Graphs",k);this.Zq("boxplotTransparency",0.4,"Fraction to adjust color transparency for the boxplot id individual data points are shown","Boxplot Graphs",k);this.RY("boxplot",false,"boxplot if individual data points are shown","Boxplot Graphs",k);this.gK("boxplotVarWidth",false,"Flag to adjust the width of boxplots. Similar to R if true then the width is proportional to the sqare root of the number of observations","Boxplot Graphs",k);this.Zq("boxplotCoef",1.5,"Number that determines how far the plot ‘whiskers’ extend out from the box","Boxplot Graphs",k);this.F3("boxplotHingeFunction","summary",["summary","fivenum"],"Function to calculate the boxplor hinges. See https://chemicalstatistician.wordpress.com/2013/08/12/exploratory-data-analysis-the-5-number-summary-two-different-methods-in-r-2/","Boxplot Graphs",k);this.se("BoxplotOriginalData",false,"observed data point in boxplots. (Should be called showBoxplotDataPoints)","Boxplot Graphs",k);this.se("ViolinBoxplot",false,"violin plot in boxplots","Boxplot Graphs",k);this.gK("violinTrim",true,"Flag to trim violin plots","Boxplot Graphs",k);this.F3("violinScale","width",["area","count","width"],"Type for scaling violin plots","Boxplot Graphs",k);this.se("BoxplotIfViolin",true,"boxplots when violin plot are show. It does not affect anything unless violins are shown","Boxplot Graphs",k);this.Zq("boxplotWidthRatioIfViolin",0.33,"A number between 0.1 and 1 to adjust the width of the boxplot when violins are shown. It does not affect anything unless violins are shown","Boxplot Graphs",k);this.Zq("violinTransparency",0.4,"Fraction to adjust color transparency for the violins","Boxplot Graphs",k);this.RY("violin",false,"violins. If specified all the violins will have the assigned color; otherwise it will be automatically assigned","Boxplot Graphs",k);this.RY("violinBorder","rgb(0,0,0)","violin borders","Boxplot Graphs",k);this.se("ViolinQuantiles",false,"quantile 0.25 and 0.75 in violin plots","Boxplot Graphs",k);this.Zq("boxplotDataPointTransparency",0.8,"Fraction to adjust color transparency for the data points when displaying original data in boxplots","Boxplot Graphs",k);this.RY("boxplotBorder","rgb(0,0,0)","line of the borders in boxplots","Boxplot Graphs",k);this.RY("boxplotMedian",false,"line of the median of data in boxplots","Boxplot Graphs",k);this.oV("boxplotMedianWidth",2,"Width for the line of the median of data in boxplots","Boxplot Graphs",k);this.gK("boxplotMean",false,"Flag to show mean of data in boxplots","Boxplot Graphs",k);this.RY("boxplotMean","rgb(255,215,0)","data mean in boxplots","Boxplot Graphs",k);this.RY("boxplotMeanBorder","rgb(255,0,0)","border of the data mean in boxplots","Boxplot Graphs",k);this.gK("boxplotConnect",false,"Flag to show data in boxplots connected","Boxplot Graphs",k);this.oV("boxplotConnectWidth",2,"Width for the line of the connection of boxes in boxplots","Boxplot Graphs",k);this.F3("areaType","normal",["normal","stacked","percent"],"Flag to produce normal, stacked, center or percent area graphs","Area Graphs",k);this.F3("dotplotType","normal",["normal","stacked","movement"],"Flag to produce normal, stacked or movement dotplot graphs. Movement plot are only applicable when data is grouped","Dotplot Graphs",k);this.F3("barType","normal",["normal","lollipop","arrow","swimmer"],"Flag to produce normal or lollipop bar graphs","Bar Graphs",k);this.gK("barPath",false,"Show the path for the bar graph","Bar Graphs",k);this.gK("barPathTransparency",0.1,"Transparency for the bar graph path","Bar Graphs",k);this.RY("barPath",false,"bar graph path. If false, it will default to the color of the graph","Bar Graphs",k);this.oV("barLollipopFactor",1.5,"Ratio for the top (dot) of the lollipop in bar graphs. The higher the value the bigger the lollipop. See widthFactor to adjust the bar width (choose a value between 0.5 and 0.6)","Bar Graphs",k);this.gK("barLollipopOpen",false,"Pattern open for th lollipop","Bar Graphs",k);this.F3("swimHigh",false,[false],"Variable to use in Swimmer plot. Defaults to the first variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",k);this.F3("swimStart",false,[false],"Variable to use in Swimmer Plot. Defaults to the second variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",k);this.F3("swimEnd",false,[false],"Variable to use in Swimmer Plot. Defaults to the third variable in the data set. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",k);this.F3("swimStatus",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to Status. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",k);this.F3("swimHighCap",false,[false],"Name of sample annotation to use in Swimmer Plot. Defaults to High Cap. See https://blogs.sas.com/content/graphicallyspeaking/2014/06/22/swimmer-plot/","Bar Graphs",k);this.F3("ganttStart",false,[false],"Variable to use in Gantt plots as start date. Defaults to the first variable in the data set","Gantt Charts",k);this.F3("ganttEnd",false,[false],"Variable to use in Gantt plots as end date. Defaults to the second variable in the data set","Gantt Charts",k);this.F3("ganttCompletion",false,[false],"Variable annotation in the x object to use in Gantt plots as completion percentage. Must be a value between 0 and 1","Gantt Charts",k);this.F3("ganttDependency",false,[false],"Variable annotation in the x object to use in Gantt plots as dependency. Must be a valid sample / group name","Gantt Charts",k);this.F3("ganttDependencyEnd",false,[false],"Variable annotation for the type of ending for the dependency line. Options are arrow, square or round","Gantt Charts",k);this.RY("ganttDependency",false,"variable metadata used for the dependency line. Defaults to rgb(0,0,0)","Gantt Charts",k);this.Zq("ganttDependencyThickness",false,"Variable annotation for the thickness of the dependency line. Defaults to 1","Gantt Charts",k);this.Zq("ganttCompletionTransparency",0.5,"Fraction to adjust color transparency for completion","Gantt Charts",k);this.F3("meterType","gauge",["gauge","speedometer","vertical","horizontal","state","digital","number"],"Type of meter. ","Meter Graphs",k);this.Zq("meterMin",null,"Minimum value in the meter","Meter Graphs",k);this.Zq("meterMax",null,"Maximum value in the meter","Meter Graphs",k);this.Zq("meterStart",270,"Start value for the meter in degrees","Meter Graphs",k);this.Zq("meterEnd",90,"End value for the meter in degrees","Meter Graphs",k);this.UZ("meterSegments",[],"Meter Segments","Meter Graphs",k);this.UZ("meterColors",[],"Meter Colors","Meter Graphs",k);this.F3("meterVar",false,[false],"Name of the variable use to create the meter. The first variable will be used if not specified or if it is non-valid","Meter Graphs",k);this.oV("meterIndex",0,"Variable index to use creating a meter when there are multiple variables","Meter Graphs",false);this.RY("meterNeedle","rgb(0,0,0)","Meter Needle Color","Meter Graphs",k);this.RY("meterBackground","rgb(229,229,229)","Meter Background Color","Meter Graphs",k);this.oV("meterThickness",50,"Thickness in pixels for the vertical, horizontal and state meters","Meter Graphs",k);this.UZ("fishParents",[],"Fish Parents","Fish Graphs",k);this.UZ("fishTimepoints",[],"Fish Timepoints","Fish Graphs",k);this.gK("fishSeparateIndependentClones",false,"Separate indepenent clones","Fish Graphs",k);this.F3("fishShape","polygon",["spline","polygon"],"Fish Shape","Fish Graphs",k);this.UZ("fishAxis",[],"Fish Axis (array with lines across the X Axis)","Fish Graphs",k);this.UZ("fishAxisLabels",[],"Fish Axis Labels (array with names for the lines across the X Axis). Must have the same dimension as the fishAxis","Fish Graphs",k);this.UZ("fishCloneLabels",[],"Fish Clone Labels (array with names for the clones). Must have the same dimension as the fishParents","Fish Graphs",k);this.oV("sankeyNodeWidth",20,"Width for the Sankey nodes","Sankey Diagrams",k);this.oV("sankeyIterations",32,"Number of iterations for the Sankey diagram","Sankey Diagrams",false);this.F3("sankeySource",false,[false],"Name of a sample annotation to use as source in the sankey diagrams","Sankey Diagrams",k);this.F3("sankeyTarget",false,[false],"Name of a sample annotation to use as target in the sankey diagrams","Sankey Diagrams",k);this.RY("sankey","rgba(150,150,150,0.5)","sankey lines (links)","Sankey Diagrams",k);this.gK("sankeyCoordinateColor",false,"Flag to use same color for the nodes and for the lines (links) in the Sankey diagram","Sankey Diagrams",k);this.UZ("hierarchy",[],"Hierarchy for trees and bubble graphs made up of sample annotations present the data x object","Hierarchy",k);this.Hx("hierarchyVar",false,"Variable name to use in the sankey, sunburst and bubble graphs. This is used when the data set has more than a single variable. Otherwise the first variable will be selected","Hierarchy",k);this.oV("hierarchyVarIndex",0,"Variable index to use in the sankey, sunburst and bubble graphs","Hierarchy",false);this.oV("treeNodeSize",5,"Size for the Tree nodes","Trees",false);this.RY("treeLink","rgb(150,150,150)","tree lines (links)","Trees",k);this.RY("treeNodeOutline","rgb(83,105,255)","tree node outline","Trees",k);this.oV("treeLinkWidth",1,"Width for the Tree lines","Trees",k);this.gK("treeCircular",false,"Flag to plot a circular tree layout","Trees",k);this.gK("treeInverted",false,"Flag to plot the tree inverted","Trees",k);this.oV("treeVarIndex",0,"Variable index to use in the tree diagrams","Trees",false);this.oV("treeNodeId",0,"Id for the nodes in the tree","Trees",false);this.gK("variableShowLegend",true,"Flag to show the variable legend","Data Point Attributes",k);this.gK("sampleShowLegend",true,"Flag to show the sample legend. Not implemented!!!!!","Data Point Attributes",k);this.F3("colorBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to color the variables","Data Point Attributes",k);this.gK("colorByShowLegend",true,"Flag to show the colorBy legend","Data Point Attributes",k);this.hM("colorKey",false,"Object to assign custom colors to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object, or the name of an annotation in the data.z object. The value for each key could be either: (1) a scalar with a valid color scheme (see this.meta.def.colorSchemes), or (2) an array with valid colors, or (3) an object to specify custom colors for each of the values of the annotation. A default color will be assigned to a data point whose value was not included the object. CanvasXpress will handle string and numeric annotation approprietly. However, if an object is specified like that one in number (3) the annotation will be treated as categorical even if the annotation is numeric","Data Point Attributes",k);this.Hx("colorByData",false,"String that identify the object containing a two dimensional array with discrete values used to color data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)","Data Point Attributes",k);this.F3("shapeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to shape the variables. When shapeByData is specified shapeBy is used for the title in the legend","Data Point Attributes",k);this.gK("shapeByContinuous",false,"Flag to use pie shapes with continuous data as opposed to by binning the data and show regular shapes","Data Point Attributes",k);this.gK("shapeByShowLegend",true,"Flag to show the shapeBy legend","Data Point Attributes",k);this.hM("shapeKey",false,"Object to assign custom shapes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default shape will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.Hx("shapeByData",false,"String that identify the object containing a two dimensional array with values used to shape data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data2)","Data Point Attributes",k);this.F3("shapeByShape",false,[false,"sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","mdavid"],"String that identify the shape to use in regular and multidimensional heatmaps. shapeByData will take precedence over this property","Data Point Attributes",k);this.F3("sizeBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to size the variables. When sizeByData is specified sizeBy is used for the title in the legend","Data Point Attributes",k);this.gK("sizeByContinuous",false,"Flag to show the size data continuously as opposed to by binning the sizes","Data Point Attributes",k);this.gK("sizeByShowLegend",true,"Flag to show the sizeBy legend","Data Point Attributes",k);this.hM("sizeKey",false,"Object to assign custom sizes to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default size will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.Hx("sizeByData",false,"String that identify the object containing a two dimensional array with values used to size data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data3)","Data Point Attributes",k);this.Hx("outlineBy",false,"Name of the annotation for the outline when drawing a multidimensional Heatmap","Data Point Attributes",k);this.gK("outlineByShowLegend",true,"Flag to show the outlineBy legend","Data Point Attributes",k);this.Hx("outlineByData",false,"String that identify the object containing a two dimensional array with values used to color the outline data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)","Data Point Attributes",k);this.F3("patternBy",false,[false,"variable"],"Name of a variable annotation or a sample name or the string variable to pattern the variables. When patternByData is specified patternBy is used for the title in the legend","Data Point Attributes",k);this.gK("patternByShowLegend",true,"Flag to show the patternBy legend","Data Point Attributes",k);this.hM("patternKey",false,"Object to assign custom patterns to sample annotations and variable annotations included in the data object. The key of the object is the name of an annotation in the data.x object or the name of an annotation in the data.z object. A default pattern will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.Hx("patternByData",false,"String that identify the object containing a two dimensional array with values used to pattern the data points when drawing a multidimensional Heatmap. It must be located within the data.y object (for example: data.y.data4)","Data Point Attributes",k);this.F3("connectBy",false,[false],"Name of a variable annotation to connect the variables","Data Point Attributes",k);this.gK("connectByNoColor",false,"Flag to prevent coloring the lines  by the connectBy annotation. Usefull when connectBy is used along with colorBy to avoid confusion of colors","Data Point Attributes",k);this.RY("connectBy","rgb(204,204,204)","connectBy lines","Data Point Attributes",k);this.oV("connectByWidth",2,"Width for the line of the connectBy line","Data Point Attributes",k);this.gK("connectByShowLegend",true,"Flag to show the connectBy legend","Data Point Attributes",k);this.hM("connectKey",false,"Object to assign custom colors to lines when samples are connected by a sample annotations included in the data object. The key of the object is the name of an annotation in the data.x object. A default connect will be assigned to a data point whose value was not included the object","Data Point Attributes",k);this.hM("connectByData",{},"Internal object with connectBy data","Data Point Attributes",false);this.UZ("treemapBy",[],"Array of sample annotations to treemap the variables. The array may also include sample to use as last level","Data Point Attributes",k);this.F3("stackBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Bar graphs","Data Point Attributes",k);this.F3("dodgeBy",false,[false],"Name of a sample annotation to dodge the samples of each variable in Bar graphs","Data Point Attributes",k);this.F3("lineBy",false,[false],"Name of a sample annotation to stack the samples of each variable in Line graphs","Data Point Attributes",k);this.gK("lineByShowLegend",true,"Flag to show the lineBy legend","Data Point Attributes",k);this.F3("ribbonBy",false,[false],"Name of a sample annotation(s) to create a ribbon of each variable in scatter plots. If a single annotation is passed then it will be used as a standard deviation. If two annotations are passed then, it will be used as upper and lower confidence intervals. Alternatively it could be a pair of arrays witht the actual data. Works in coordination with the lineBy parameter","Data Point Attributes",k);this.F3("motionBy",false,[false,"variable"],"Utility to create dynamic filtering of data in Scatter plots","Data Point Attributes",k);this.F3("markerBy",false,[false,"variable"],"Utility to create dynamic markers in Map. It must have a latitude and longitude metadata too","Data Point Attributes",k);this.F3("ellipseBy",false,[false,"variable"],"Utility to create error ellipses in Scatter plots","Data Point Attributes",k);this.F3("ridgeBy",false,[false],"Utility to create ridgelines in Scatter2D plots","Data Point Attributes",k);this.F3("colorLabelBy",false,[false],"Name of the variable annotation to color the labels in Scatter2D plots","Data Point Attributes",k);this.gK("colorLabelByShowLegend",true,"Flag to show the colorLabelBy legend","Data Point Attributes",k);this.F3("sizeLabelBy",false,[false],"Name of the variable annotation to size the labels in Scatter2D plots","Data Point Attributes",k);this.gK("sizeLabelByShowLegend",true,"Flag to show the sizeLabelBy legend","Data Point Attributes",k);this.oV("motionWidth",250,"Size in pixels for the motion widget when used to reproduce user customizations","Motion Charts",k);this.oe("motionCurrent","","rgb(0,0,0,0.3)",60,1,"center","middle",0,5,"motion charts","Motion Charts",k);this.F3("scatterType",false,[false,"line","bar","dot","area","image","lineImage","lineStep","boxplot","visium","manhattan","bin2d","polygon"],"Type of scatter plot","Scatter Plots",k);this.Zq("scatterLineAlpha",1,"Transparency applied to lines in scatter plots","Scatter Plots",k);this.Zq("scatterPointAlpha",1,"Thickness applied to data points in scatter plots","Scatter Plots",k);this.F3("scatterStreamType","mirror",["mirror","ridge","proportional"],"Type of stream scatter plot","Scatter Plots",k);this.Zq("scatterStreamBandwidth",0.75,"Scatter stream bandwidth. Tensor for the wiggles of the stream wiggles. A vaulue between 0 and 1","Scatter Plots",k);this.oV("scatterStreamNumber",1000,"Number of values for the wiggles","Scatter Plots",k);this.Zq("scatterStreamExtraSpan",0.01,"Scatter stream extra extension for the wiggles. A vaulue between 0 and 1 as in percent","Scatter Plots",k);this.F3("scatterStreamTrueRange","both",["both","min_x","max_x","none"],"Expand the X axis","Scatter Plots",k);this.UZ("scatterStreamWiggles",[],"Order for the streamgraph wiggles","Scatter Plots",k);this.gK("visiumFlip",false,"Invert the data in visium plots. ","Scatter Plots",k);this.gK("visiumPanning",false,"No panning on visium plots so dragging will always zoom","Scatter Plots",k);this.gK("visiumFixedAspectRatio",true,"Fix aspect ratio for visium plots","Scatter Plots",k);this.gK("scatterAxesEqual",false,"Keep same range in both axes","Scatter Plots",k);this.oV("scatterOutlineThreshold",50000,"Maximum number of data points before skipping plotting their outline but only the fill color","Scatter Plots",k);this.UZ("chromosomeLengths",[],"Manhattan Chromosomes length is a sorted array by chromosome with the length in base pairs for each chromosome. It is required when scatterType is manhattan","Scatter Plots",k);this.Hx("manhattanMarkerChromosomeNumber",false,"Sample name included in the data.y.smps object used to map to the chromosome number","Scatter Plots",k);this.F3("manhattanMarkerPosition",false,[false],"Sample name included in the data.y.smps object used to map to the position in base pairs","Scatter Plots",k);this.F3("manhattanMarkerLogPValue",false,[false],"Sample name included in the data.y.smps object used to map to the negative log 10 p value","Scatter Plots",k);this.UZ("manhattanColors",["rgb(128,128,128)","rgb(135,206,235)"],"Colors for the manhattan plots","Scatter Plots",k);this.UZ("manhattanContrastColor","rgba(0,0,0,0.1)","Manhattan contrast color","Scatter Plots",k);this.Zq("groupingFactorWindow",false,"The width for the data when grouping in Scatter2D plots. This is the analogous parameter to cut_width in R. It defaults to a fifth of the data range. The scatterType must be boxplot to take this parameter into effect","Scatter Plots",k);this.RY("function","rgb(0,0,0)","function plots","Scatter Plots",k);this.RY("cXscatter","rgb(0,0,0)","scatter cXplots","Scatter Plots",k);this.se("DataLabels",false,"data labels in scatter plots","Scatter Plots",k);this.gK("isDataLabels",false,"Flag to put a background in data labels","Scatter Plots",k);this.gK("isDataLabelsBackgroundColor",false,"Flag to use the color in the colorDataLabels as a background in data labels","Scatter Plots",k);this.YN("dataLabelBackground","rgb(255,255,255)","rgb(0,0,0)",0.5,"solid","data labels background","Scatter Plots",k);this.F3("selectionMode","highlight",["highlight","ghost","name","filter"],"Mode use to highlight selected data points in visualizations","Data Selection",k);this.RY("selection","rgb(255,0,0)","The color used for selected data points when selection mode is to be highlight","Data Selection",k);this.F3("selectionMetadata",false,[false],"Matadata (or factor) to use to display selected data points instead of the variable name. This metadata has to be in the data.z object. This property is only valid when the selectionMode is name and the visualization is a Scatter plot","Data Selection",k);this.UZ("selectedDataPoints",[],"Variable / Sample names of data points (in the data object) to initially select","Data Selection",k);this.gK("isContour",false,"Flag to show the contour","Contours",k);this.gK("contourFilled",false,"Flag to color the contour plot","Contours",k);this.Zq("contourFilledTransparency",1,"Transparency applied to the filled contours","Contours",k);this.se("ContourBands",true,"contour bands","Contours",k);this.RY("contourBands","rgb(0,0,255)","the bands in contours","Contours",k);this.oV("contourLevelWidth",null,"Width of contour levels","Contours",k);this.oV("contourLevelNumber",10,"Numbe of contour levels. Overridden by contourLevelWidth","Contours",k);this.F3("contourStat","density",["density","ndensity","count"],"Contour density type","Contours",k);this.F3("contourType","normal",["normal","raster","point"],"Contour type","Contours",k);this.UZ("contourLevels",[],"Numeric vector to set the contour levels. It is automatically calculated if not defined using the axisAlgorithm setting and the contourLevelNumber","Contours",k);this.se("ContourLevel",false,"levels in contours","Contours",k);this.se("ContourDataPoints",false,"data points in contours","Contours",k);this.RY("contourDataPoints","rgb(0,0,0)","data points in contours when the contour is filled","Contours",k);this.F3("contourColorScheme","Viridis",["Viridis","YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","BluesDark","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color scheme to use in contours","Contours",k);this.gK("isHistogram",false,"Flag to track conversion of 2D scatter plot into histograms","Histograms",false);this.se("Histogram",false,"data as histogram","Histograms",k);this.Zq("histogramBarWidth",false,"Length in pixels for half of the bar width in the 2D scatter plot histogram","Histograms",false);this.gK("histogramRight",true,"Histogram right is a boolean.  If true, the histogram cells are right-closed (left open) intervals","Histograms",k);this.gK("histogramLowest",true,"Histogram lowest is a boolean. If true, an x[i] equal to the breaks value will be included in the first (or last, for right = FALSE) bar","Histograms",k);this.oV("histogramBins",30,"Approximate number of bins in a histogram. It may vary to the actual number used in the histogram to ensure a pretty size for the intervals in the histogram. Default is the same as in ggplot which is 30","Histograms",k);this.UZ("histogramBreaks",[],"Numeric vector to set the histogram breaks. It is automatically calculated if not defined using the axisAlgorithm setting and the histogramBins","Histograms",k);this.Zq("histogramBinWidth",false,"Width in actual units for the histogram bin","Histograms",k);this.F3("histogramType","dodged",["dodged","staggered","stacked"],"Type of histogram when multiple series are present","Histograms",k);this.se("HistogramDensity",false,"density kernel in histograms","Histograms",k);this.se("HistogramPath",false,"histograms path","Histograms",k);this.se("FilledHistogramPath",false,"filled histogram path","Histograms",k);this.Zq("histogramPathFillTransparency",0.6,"Transparency applied to the filled histogram path","Histograms",k);this.RY("histogramPath",false,"histogram path. If not specified the it defaults to the color of the histogram bars","Histograms",k);this.oV("histogramPathWidth",2,"Width for the line of the histogram path line","Histograms",k);this.se("FilledHistogramDensity",false,"filled histogram density","Histograms",k);this.Zq("histogramDensityFillTransparency",0.6,"Transparency applied to the filled histogram density","Histograms",k);this.se("HistogramDataPoints",false,"original data point in histograms","Histograms",k);this.se("HistogramQuantiles",false,"quantile 0.25 and 0.75 in density plots","Histograms",k);this.se("HistogramMedian",false,"histogram median","Histograms",k);this.F3("histogramMedianLineStyle","dashed",["solid","dotted","dashed","dotdash","longdash","twodash"],"Line type for the histogram median","Histograms",k);this.gK("hideHistogram",false,"Flag to hide the histogram bars","Histograms",k);this.F3("histogramSizeEstimator","sturges",["sturges","freedmanDiaconis","scott"],"Histogram size estimator","Histograms",k);this.F3("histogramStat","count",["density","count"],"Histogram density type","Histograms",k);this.gK("histogramAsDotplot",false,"Flag to use dots as histogram bars","Histograms",k);this.YN("histogramDotplot","rgb(215,48,39)","rgb(0,0,0)",0.5,"solid","data points in dotplot histograms","Histograms",k);this.gK("histogramStackRatio",1,"Stack ratio for dotplot histograms. I has to be a value between 0 and 1","Histograms",k);this.F3("histogramStackDir","down",["down","center","centerwhole"],"Direction to stack the dots in dotplot histograms","Histograms",k);this.hM("isCreateHistogram",false,"Object to store histogram data","Histograms",false);this.se("ScatterDensity",false,"density kernel in histograms","Density Plots",k);this.oV("densityPixels",1000,"Number of pixels to stack on the density plots","Density Plots",k);this.F3("densityKernel","gaussian",["gaussian","rectangular","triangular","epanechnikov","quartic","biweight","cosine","optcosine"],"Histogram density kernels","Density Plots",k);this.F3("densityPosition","normal",["normal","stacked","filled"],"Histogram density position","Density Plots",k);this.F3("bandwidthRule","nrd0",["nrd0","nrd","silverman"],"Bandwidth rule ","Density Plots",k);this.oV("bandwidthCut",3,"Bandwidth cut","Density Plots",k);this.Zq("bandwidthAdjust",1,"Bandwidth adjust for the window","Density Plots",k);this.Zq("ridgelineScale",1.5,"Scale for ridgeline","Ridgeline Plots",k);this.RY("fitLine","rgb(255,215,0)","fit line","Fit Lines",k);this.F3("fitLineStyle","solid",["solid","dotted","dashed","dotdash","longdash","twodash"],"Color for the fit line","Fit Lines",k);this.oV("fitLineWidth",2,"Specifies the width for the fitLine","Fit Lines",k);this.Zq("fitLineTransparency",1,"The transparency for the fit line. A value between 0 and 1","Fit Lines",k);this.se("ConfidenceIntervals",true,"confidence intervals in the regression plots ","Confidence Intervals",k);this.Zq("confidenceLevel",0.95,"Confidence level for regressions and ellipses","Confidence Intervals",k);this.RY("confidenceInterval","rgb(50,50,50)","confidence intervals","Confidence Intervals",k);this.gK("confidenceIntervalColorCoordinate",false,"Flag to color coordinate the confidence intervals and line fit","Confidence Intervals",k);this.se("RegressionFit",false,"Flag to show the regression fit in Scatter2D plots","Regression",k);this.se("RegressionFitEquation",true,"Flag to show the regression fit equation in Scatter2D plots","Regression",k);this.F3("regressionFitEquationPosition","top",["top","bottom"],"Position for the regression fit equation in Scatter2D plots","Regression",k);this.se("RegressionFullRange",false,"full range in regression plots","Regression",k);this.F3("regressionType","linear",["linear","exponential","logarithmic","power","polynomial"],"Type of linear least-squares fitting methods for simple data analysis","Regression",k);this.oV("regressionOrder",2,"Specifies the number of degrees to solve for in polynomial regressions","Regression",k);this.se("LoessFit",false,"Flag to show the loess fit in Scatter2D plots","Loess",k);this.F3("loessDegree",2,[0,1,2],"Loess degree. 0 : Constant, 1 : Linear, 2 : Quadratic","Loess",k);this.oV("loessSteps",30,"Loess steps. Number of steps to smooth the line","Loess",k);this.Zq("loessBandwidth",0.8,"Loess bandwidth. Thickness for the confidence of the loess curve. A vaulue between 0 and 1","Loess",k);this.Zq("loessCell",0.2,"Loess cell. If interpolation is used this controls the accuracy of the approximation via the maximum number of points in a cell in the kd tree. Cells with more than floor(n*span*cell) points are subdivided","Loess",k);this.Zq("loessSpan",0.75,"Loess span. Factor to adjust the gaussian shape of the loess curve. A vaulue between 0 and 1","Loess",k);this.oV("loessIteration",4,"Loess iterations","Loess",false);this.gK("loessNormalize",true,"Flag to normalize loess fit in Scatter2D plots","Loess",k);this.F3("loessFamily","gaussian",["gaussian","symmetric"],"Loess Family. Type of error distribution to be optimized in fitting. The default, gaussian, is fitting with least squares. Fitting with Tukeys biweight M-Estimator is used if family is symmetric","Loess",k);this.F3("loessSurface","interpolate",["direct","interpolate"],"Loess Surface. The fitted surface to be computed exactly (direct) or via interpolation from a kd tree","Loess",k);this.F3("loessStatistics","approximate",["approximate","exact"],"LoessStatistics. The statistics to be computed exactly, approximately or not at all? Exact computation can be very slow ","Loess",k);this.se("KMConfidenceIntervals",true,"confidence intervals in Kaplan-Meier plots ","Kaplan Meier Plots",k);this.Zq("kmConfidenceLevel",0.95,"Confidence level for Kaplan Meier plots","Kaplan Meier Plots",k);this.F3("kmConfidenceIntervalType","log",["ordinary","log","loglog"],"Confidence intervals type for Kaplan Meier estimates","Kaplan Meier Plots",k);this.gK("kmInvertCensored",false,"Flag to indicate whether zero values are censored or not in Kaplan-Meier plots","Kaplan Meier Plots",k);this.gK("kmCensoredRug",false,"Flag to indicate whether to show the censored data as a rug in Kaplan-Meier plots","Kaplan Meier Plots",k);this.Hx("kmTable",false,"Data to show in Kaplan-Meier plots. It must be a numeric factor as it will be aligned to the major ticks in the x Axis","Kaplan Meier Plots",k);this.UZ("quantiles",["0.25","0.5","0.75"],"Array with quantiles to use in quantile regression plots","Quantile Regression Plots",k);this.se("QuantileRegressionFit",false,"Quantile Regression fit in Scatter2D plots","Quantile Regression Plots",k);this.UZ("binplotBins",[],"Approximate number of bins in a bin plot. It may vary considerably to the actual number used in the bin plot to ensure a pretty size for the intervals in the bin plot. ggplots default is 30","Bin Plots",k);this.UZ("binplotBinWidth",[],"Width in actual units for the histogram bin","Bin Plots",k);this.gK("binplotDrop",true,"Flag to drop cells with zero counts in binplots","Bin Plots",k);this.F3("binplotShape","hexagon",["rectangle","hexagon","oval"],"Type for the shape to use in binplots","Bin Plots",k);this.F3("binplotColorScheme","BluesDark",["YlGn","YlGnBu","GnBu","BuGn","PuBuGn","PuBu","BuPu","RdPu","PuRd","OrRd","YlOrRd","YlOrBr","Purples","Blues","BluesDark","Greens","Oranges","Reds","Greys","PuOr","BrBG","PRGn","PiYG","RdBu","RdGy","RdYlBu","Spectral","RdYlGn","Accent","Dark2","Paired","Pastel1","Pastel2","Set1","Set2","Set3","Default","Basic","Light","Favorite","Pastel","Balanced","Rpalette","RlatticeBackground","RlatticeShingle","RlatticeLine","RlatticePolygon","Bootstrap","Economist","EconomistBG","Excel","Excel2","Excel3","GGPlot","Solarized","SolarizedBase","PaulTol","ColorBlind","Tableau","TableauGrey","TableauColorBlind","TableauTrafficLight","TableauPurpleGrey","TableauBlueRed","TableauGreenOrange","TableauCyclic","TableauPairSequential","TableauTripleDiverging","WallStreetJournal","WallStreetJournal2","WallStreetJournal3","WallStreetJournalRedGreen","WallStreetJournalBlackGreen","WallStreetJournalDemRep","Stata","Stata2","Stata3","StataMono","BlackAndWhite","CanvasXpress","CanvasXpressT"],"Color scheme to use in binplots","Bin Plots",k);this.oV("maxDOENumber",8,"Maximum number of graphs when creating a DOE","DOE",k);this.UZ("includeDOE",[],"Array containing the factors to include when exploring the DOE. If left empty all the factors will be included","DOE",k);this.gK("autoexpandDOE",true,"Flag to automatically expand verticaly the extent of the meta data-plots when changing the size of the graphs","DOE",k);this.gK("extendedDOE",true,"Flag to extend DOE to include variables / samples","DOE",k);this.hM("asDOE",false,"Object with configurations to create DOE","DOE",k);this.F3("scatterPlotMatrix",false,[true,false],"Could be a boolean to plot a matrix of 2D scatterplots or a sample annotation to color and segregate the plots","Scatter Plot Matrix",k);this.F3("scatterPlotMatrixType","both",["both","upper","lower","correlation","correlationHistogram","correlationDensity","all","first"],"Type for the matrix of 2D scatterplots. Draw either in both panels, upper only or lower only. Show any combination of correlation, histogram, density and variability (boxplots). Also specify whether to use all versus all or only the first data set","Scatter Plot Matrix",k);this.se("ScatterPlotMatrixLabels",false,"labels in the scatter plot matrix","Scatter Plot Matrix",k);this.Zq("xRotate",45,"Starting number of degrees to rotate graph arround the X axis","3D Attributes",k);this.Zq("yRotate",0,"Starting number of degrees to rotate graph arround the Y axis","3D Attributes",k);this.Zq("zRotate",0,"Starting number of degrees to rotate graph arround the Z axis","3D Attributes",k);this.Zq("x3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the X Axis","3D Attributes",k);this.Zq("y3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Y Axis","3D Attributes",k);this.Zq("z3DRatio",1,"Value between 0 - 1 for adjusting the 3D of the Z Axis","3D Attributes",k);this.se("3DGrid",true,"X,Y,Z grid in 3D plots","3D Attributes",k);this.oV("rotationSensitivity",450,"Factor to adjust the sensitivity of the mouse when rotating the graph","3D Attributes",k);this.oV("rotationStep",2,"Number of degrees used when the plot is automatically rotated","3D Attributes",k);this.Zq("perspectiveFactor",2.2,"Factor to use to make the 3D perspective. The higher the number the more perspective. Perspective of zero is no perspective at all","3D Attributes",k);this.RY("outline3D","rgb(0,0,0)","outline of the 3D Scatters","3D Attributes",k);this.oV("varIndicesStart",-1,"Number that indicates starting point for variables in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.oV("smpIndicesStart",-1,"Number that indicates starting point for samples in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.oV("grpIndicesStart",-1,"Number that indicates starting point for grouped samples in heatmaps when the canvas is zoom in","Heatmap Graphs",false);this.gK("isMultidimensionalData",false,"Flag to indicate if there is more than a single data set","Heatmap Graphs",false);this.gK("heatmapAutoAdjust",false,"Flag to adjust the range of the heatmaps when zooming in/out","Heatmap Graphs",k);this.gK("heatmapCellBox",true,"Flag to print a box around the heatmap cells","Heatmap Graphs",k);this.RY("heatmapCellBox","rgb(102,102,102)","heatmap boxes around the cells","Heatmap Graphs",k);this.Zq("heatmapCellBoxWidth",1,"Width for the heatmap boxes around the cells","Heatmap Graphs",k);this.ww("heatmapCellBoxColorHighlight","rgb(255,215,0)","highlighted heatmap cells","Heatmap Graphs",k);this.Zq("heatmapCellBoxHighlightWidth",1,"Width for the highlighting heatmap boxes around the cells","Heatmap Graphs",k);this.F3("varTitleLabelPosition","bottom",["bottom","top"],"Position for variable labels","Heatmap Graphs",k);this.F3("smpTitleLabelPosition","left",["left","right"],"Position for sample labels","Heatmap Graphs",k);this.se("HeatmapIndicator",true,"heatmap color indicator","Heatmap Graphs",k);this.oV("heatmapIndicatorHeight",35,"Length in pixels for the heatmap indicator","Heatmap Graphs",k);this.oV("heatmapIndicatorWidth",150,"Length in pixels for the heatmap indicator line width used for increase the size of the indicator","Heatmap Graphs",k);this.gK("adjustAspectRatioHeatmapIndicator",true,"Flag to adjust aspect ratio of heatmap indicator. It depends on the adjustAspectRatio parameter; that is, the adjustAspectRatio parameter has to set to true for the adjustAspectRatioHeatmapIndicator to take effect","Heatmap Graphs",k);this.F3("heatmapIndicatorPosition","right",["topLeft","top","topRight","right"],"Position for the heatmap indicator","Heatmap Graphs",k);this.gK("heatmapIndicatorHistogram",false,"Flag to show histogram in the heatmap indicator","Heatmap Graphs",k);this.RY("heatmapIndicatorHistogram","rgb(0,255,255)","heatmap indicator histogram","Heatmap Graphs",k);this.F3("heatmapType","normal",["normal","circle","hexagon","upset"],"Type of Heatmap used to overlay a layer on top of an image. Special for spatial transcriptomics and UpSet plots","Heatmap Graphs",k);this.gK("heatmapCollapse",false,"Flag to collapse cells in heatmaps of type circle or hexagon. If true cells are ploted without outline otherwise the outline is the foreground color","Heatmap Graphs",k);this.gK("isOncoprint",false,"Boolean flag to draw an oncoprint","Oncoprint Graphs",false);this.gK("oncoprintCNA",false,"String to identify the data object to use to draw the copy number alterations; that is the amplifications (which will be colored red) and deletions (which will be colored blue). It MUST be a file with only two categorical levels","Oncoprint Graphs",k);this.gK("oncoprintMUT",false,"String to identify the data object to use to draw the mutations. For example missense, non-synonymous, truncating, etc. Each level will be colored in a shade of green","Oncoprint Graphs",k);this.gK("oncoprintHeatmapSwitch",false,"Switch to Oncoprint or Heatmap visualization. Requieres data in the data object","Oncoprint Graphs",k);this.gK("oncoprintNoAlterations",true,"Switch to show variables and samples without any alterations","Oncoprint Graphs",k);this.gK("oncoprintColSummary",false,"Flag to show column summary in oncoprints","Oncoprint Graphs",k);this.gK("oncoprintRowSummary",false,"Flag to show row summary in oncoprints","Oncoprint Graphs",k);this.se("HeatmapOncoprint",false,"heatmap along with the oncoprint","Oncoprint Graphs",k);this.F3("oncoprintHeatmapPosition","bottom",["right","bottom","left","top"],"Position for the heatmap in the oncoprint","Oncoprint Graphs",k);this.gK("isUpSet",false,"Boolean flag to draw an upset plot","UpSet Plots",false);this.oV("nUpSets",5,"Number of sets to draw","UpSet Plots",k);this.oV("nUpSetIntercepts",40,"Number of intercepts to draw","UpSet Plots",k);this.UZ("upSetSets",[],"Array containing the names of the sets to include","UpSet Plots",k);this.UZ("upSetIntercepts",[],"Array containing the names of the intercepts to include. Sets must be separated by &&","UpSet Plots",k);this.RY("upsetShade","rgb(159,159,159)","row shading in matrix","UpSet Plots",k);this.Zq("upsetShadeAlpha",0.1,"Transparency of shading in matrix","UpSet Plots",k);this.Zq("upsetMatrixDotAlpha",0.2,"Transparency of the empty intersections points in the matrix","UpSet Plots",k);this.RY("upsetMatrix","rgb(59,59,59)","the intersection points","UpSet Plots",k);this.RY("upsetMainBar","rgb(59,59,59)","the main bar plot","UpSet Plots",k);this.RY("upsetSetsBar","rgb(59,59,59)","set bar plot","UpSet Plots",k);this.Zq("upsetPointSizeFactor",1,"Adjust the size of points in matrix plot","UpSet Plots",k);this.Zq("upsetLineSizeFactor",1,"Adjust width of lines in matrix plot","UpSet Plots",k);this.Zq("upsetMatrixPlotBarRatio",0.7,"Ratio between matrix plot and main bar plot","UpSet Plots",k);this.oV("treemapBorderWidth",3,"Width for the treemap border","Treemap Graphs",k);this.RY("treemapBorder","rgb(204,204,204)","treemap header and border","Treemap Graphs",k);this.F3("correlationAxis","samples",["samples","variables"],"Axis used for the correlation","Correlation Graphs",k);this.gK("correlationAnchorLegend",false,"Flag to show a region above the correlation plot that anchror a sample/variable to a position","Correlation Graphs",k);this.oV("correlationAnchorLegendAlignWidth",40,"Length in pixels of the height of the correlation anchor legend","Correlation Graphs",k);this.oV("correlationLabelInterval",1,"Interval for the sample or variable labels in the correlation plot","Correlation Graphs",k);this.F3("correlationType","diamond",["diamond","circle"],"Shape to use in the correlation graphs","Correlation Graphs",k);this.fQ("Var",true,false,"top",false,"variable dendrogram","Dendrograms",k);this.fQ("Smp",true,false,"left",false,"sample dendrogram","Dendrograms",k);this.oV("dendrogramHeight",80,"Size in pixels for the dendrogram","Dendrograms",k);this.RY("dendrogram","rgb(0,0,0)","dendrograms","Dendrograms",k);this.F3("distance","euclidian",["euclidian","manhattan","max"],"Distance metric to use when clustering data","Clustering",k);this.F3("linkage","complete",["single","complete","average"],"Linkage type to use when clustering data","Clustering",k);this.F3("clusterAxis","samples",["samples","variables"],"Axis to use when clustering data","Clustering",k);this.oV("kmeansVarClusters",3,"Number of clusters when clustering variable data with kmeans","Clustering",k);this.oV("kmeansSmpClusters",3,"Number of clusters when clustering sample data with kmeans","Clustering",k);this.oV("maxIterations",500,"Number of maximum iterations when clustering data with kmeans for one dimensional graphs or maximum number of iterations when calculating force direct layout networks","Clustering",k);this.F3("imputeMethod","mean",["mean","median"],"Imputation method for missing data when clustering","Clustering",k);this.gK("samplesClustered",false,"Configuration property to cluster samples","Clustering",k);this.gK("variablesClustered",false,"Configuration property to cluster variables","Clustering",k);this.gK("samplesKmeaned",false,"Configuration property to k-mean samples","Clustering",k);this.gK("variablesKmeaned",false,"Configuration property to k-mean variables","Clustering",k);this.gK("vennLegendColors",false,"Flag to use the venn colors to use for the legends instead of the letters","Venn Diagrams",k);this.oV("vennGroups",4,"Number of groups in the Venn diagram","Venn Diagrams",k);this.UZ("vennCompartments",["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"],"Name for the compartments in the the Venn diagrams","Venn Diagrams",false);this.UZ("vennColors",[],"Colors for the Venn bubles. If not specified the colors will be chosen from the colors array. Colors in this array need to be at least the same number of groups in the Venn diagram","Venn Diagrams",k);this.F3("pieType","separated",["separated","solid"],"Position for the pices of the pie","Pie Charts",k);this.oV("pieSegmentPrecision",0,"Number of decimals for values in the Pie charts","Pie Charts",k);this.oV("pieSegmentSeparation",1,"Length in pixels for the separation of the pieces of the pie charts","Pie Charts",k);this.F3("pieSegmentLabels","inside",["inside","outside"],"Location for the values in the pie charts","Pie Charts",k);this.F3("pieLabelType","percentage",["percentage","value"],"Pie label type to show the percentage of the slice or the actual number","Pie Charts",k);this.Zq("maxPieSectors",20,"Max pie sectors. After that number the sectors will be put in a sector named other","Pie Charts",k);this.se("PieValues",true,"values for the pie","Pie Charts",k);this.se("PieSampleLabel",true,"sample label when plotting multiple pies","Pie Charts",k);this.Zq("startPieSectors",270,"Starting degrees for pie sectors. 0 is equivalent to 3:00 oclock","Pie Charts",k);this.Zq("pieInnerRadius",0,"Percentage of the radius in the pies to remove to make a donut. It must be a number between 0 to 1","Pie Charts",k);this.UZ("pieColors",[],"Pie Colors. Defaults to the parameter colors","Pie Charts",k);this.F3("circularType","normal",["normal","radar","sunburst","chord","bubble"],"Property to set the subtype of circular graph. If set to sunburst or bubble then smpOverlays can be used to build a hierarchy for the graph","Circular Graphs",k);this.oV("chordThickness",28,"Relative length in pixels of the chord thickness in the circular graphs. Only applicable to the chord subtype","Circular Graphs",k);this.F3("chordColor","source",["source","target"],"Color the ribbon according to either the source or the target of the connection","Circular Graphs",k);this.RY("bubble","rgba(204,204,204,0.33)","Bubbles. Only applicable to the bubble subtype","Circular Graphs",k);this.RY("bubbleOutline","rgb(0,0,0)","Outline of bubbles. Only applicable to the bubble subtype","Circular Graphs",k);this.F3("bubbleLabel","auto",["first","last","all","auto","none"],"Position for the labels in bubble circular plot","Circular Graphs",k);this.F3("bubbleLabelPosition","center",["top","center","down"],"Position for the labels in bubble circular plot","Circular Graphs",k);this.F3("bubbleLabelLineType","arch",["line","arch"],"Line type when label is away from the bubble","Circular Graphs",k);this.Zq("circularCenterProportion",0.3,"Proportion of the center of the circular graph to use as void; that is the fraction of the radius in the middle of the graph","Circular Graphs",k);this.oV("arcSegmentsSeparation",8,"Number of degrees to separate the arc segments in the circular plots. The arc segments can be set with the segregateSampleBy property","Circular Graphs",k);this.oV("circularRotate",0,"Number of degrees to rotate the circular graph to adjust the starting point","Circular Graphs",k);this.oV("circularArc",360,"Number of degrees to extend the circular graph","Circular Graphs",k);this.oV("ringSeparation",5,"Number of pixels to separate the rings in the circular plots","Circular Graphs",k);this.UZ("ringGraphType",[],"Array containing the graph type for each ring in the circular plot","Circular Graphs",k);this.UZ("ringGraphWeight",[],"Array containing the proportion of the dimensions for each data ring in the circular plot. It must be a value between 0.1 and 1. If not specified then all ring will be weighted the same","Circular Graphs",k);this.UZ("arcSegmentsRadius",[],"Array containing the proportion of the radius for each arc segment in the circular plot. If not specified then all radius will be the same. The plot will be scaled based of the largest value in the array","Circular Graphs",k);this.UZ("ringsOrder",[],"Array containing the order of the rings. The array includes the levels of the factor specified as either segregateSamplesBy when show the ideogram or segregateVariablesBy when there is no ideogram. It may also include any of the following terms: dendrogram, ideogram, labels, scale, percent and data. If there are sample overlays, the array may also contain any of the factor names include in the this.data.x object. This array supersede any other configurations for example for the sample overlays. CanvasXpress will honored all other configurations if left empty","Circular Graphs",k);this.Hx("rAxis",false,"Radial axis for circular plots. It must be the name of a variable. Only applicable to 2 Dimensional circular plots","Circular Graphs",k);this.gK("rAxisZero",false,"Flag to force the rAxis property to start from zero otherwise it starts from the minimum value","Circular Graphs",k);this.se("CircularConnections",true,"connections in circular graphs","Circular Graphs",k);this.UZ("connections",[],"Array to store connections in circular graphs","Circular Graphs",k);this.Zq("circularLetterSeparationFactor",1.5,"Factor to adjust the spacing between letters in the circular graphs. The greater the number the closer the letters in the labels","Circular Graphs",k);this.Zq("circularConnectionsTransparency",0.5,"Percentage of transparency applied to the connections in the circular graphs","Circular Graphs",k);this.F3("overlayLevelOrientation","circular",["perpendicular","circular"],"Orientation to show the segregation levels","Circular Graphs",k);this.F3("smpLabelOrientation","perpendicular",["perpendicular","circular"],"Orientation to show the sample names","Circular Graphs",k);this.F3("circularLabelsAlign","outside",["inside","outside"],"Position to align the variable and sample names in circular plot","Circular Graphs",k);this.F3("circularScalesAlign","inside",["inside","outside"],"Position to align the percent and radial axes in circular plot","Circular Graphs",k);this.F3("circularAnchorsAlign","inside",["inside","outside"],"Position to align the anchors in circular plot","Circular Graphs",k);this.F3("circularAnchors2Align","outside",["inside","outside"],"Position to align the anchors2 in circular plot","Circular Graphs",k);this.F3("circularDataPosition","distributed",["absolute","distributed"],"Position to align the data in 2D radial graphs and ideograms","Circular Graphs",k);this.oV("circularAnchorLength",15,"Length in pixels of the height of the circular anchor","Circular Graphs",k);this.RY("circularAnchor","rgb(0,0,255)","circular anchor","Circular Graphs",k);this.Hx("ideogramChromosome","chr","Factor name included in the data.z object used to map to the chromosome number","Circular Graphs",k);this.Hx("ideogramChromosomePosition","pos","Factor name included in the data.z object used to map to the chromosome position","Circular Graphs",k);this.se("Ideogram",false,"Human Chromosome Ideogram. Force circular plots to be two dimensional","Ideograms",k);this.F3("ideogram","hg38",["hg19","hg38"],'Ideogram. Additional ideograms can be loaded by appending to the CanvasXpress.chromosomes object. The format of the ideogram is based on the R data for USCS.hg19.chr<br> CanvasXpress.chromosomes = {<br> &nbsp;&nbsp;hg19 : {<br> &nbsp;&nbsp;&nbsp;&nbsp;order : [ 1, 2, 3, 4, 5, 6, 7, 8, ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;data : {<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1 : [ [ 0, 2300000, "p36.33", "gneg" ], ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2 : [ [ 0, 4300000, "p25.3", "gneg" ],  ...],<br> &nbsp;&nbsp;&nbsp;&nbsp;}<br> &nbsp;&nbsp;}<br> }',"Ideograms",k);this.Hx("ideogramChromosomeNumber","1","Chromosome number","Ideograms",k);this.gK("ideogramShowFullChromosome",true,"Show the full chromosome","Ideograms",k);this.oe("ideogramSegment","","rgb(0,0,0)",10,1,"center","middle",0,8,"ideogram segment","Ideograms",k);this.oV("ideogramHeight",20,"Default size in pixels of the ideogram height","Ideograms",k);this.oV("tagCloudTextWeightFactor",1,"Factor weight for text in tag cloud visualizations","Tag Cloud",k);this.oV("tagCloudTextGridSize",8,"Size for the grid in text tag cloud visualizations","Tag Cloud",k);this.Zq("tagCloudTextEllipticity",0.65,"Ellipticity for the for text in tag cloud visualizations","Tag Cloud",k);this.Zq("tagCloudTextRotateRatio",0.1,"Ratio for rotation of text in cloud visualizations","Tag Cloud",k);this.F3("tagCloudShape",false,[false,"circle","cardioid","diamond","square","triangle","triangle2","pentagon","star"],"Shape for the tag cloud","Tag Cloud",k);this.gK("tagCloudMask",false,"Add a shadow for the selected shape","Tag Cloud",k);this.UZ("tagCloudGridPoints",[],"Array to keep state of the used space in the tag cloud visualization","Tag Cloud",false);this.gK("calculateLayout",true,"Flag to force or not to calculate the network layout","Network Graphs",k);this.gK("networkFreeze",false,"Flag to prevent autoscaling for the network layout. Useful when images are part of the network","Network Graphs",k);this.oV("networkMaxIterations",15,"Number of iterations to separate subnetworks","Network Graphs",k);this.gK("networkFreezeOnLoad",false,"Flag to prevent autoscaling for the network layout after loading. Useful when images are part of the network","Network Graphs",k);this.gK("preScaleNetwork",false,"Flag to prescale or not the network. This is an aesthetic parameter to make the graph look nicer... Sometimes..","Network Graphs",k);this.gK("ignoreEventlessOrder",false,"Flag to render all nodes at one time rather that rendering first the eventless nodes and then the non-eventless nodes","Network Graphs",k);this.jY("subNetworks",false,"Array to keep independent networks","Network Graphs",false);this.F3("networkLayoutType","forceDirected",["forceDirected","circular","radial","cola"],"Type of network layout","Network Graphs",k);this.Hx("networkRoot",false,"Node Id of the network root","Network Graphs",k);this.gK("isNetworkMetrics",false,"Flag to calculate all network metrics: betweenness, closeness, eccentricity and degree","Network Graphs",k);this.se("NetworkRadialLayout",false,"radial layout wire","Network Graphs",k);this.gK("is3DNetwork",false,"Flag to create or not a 3D network","Network Graphs",k);this.gK("networkNodesOnTop",true,"Order to use when drawing the nodes and edges in the networks. Useful for very populated netwrok graphs. When is set to true all the edges will be in the background","Network Graphs",k);this.gK("moveParentsWithChildren",false,"Flag to make parents move when a child is moved","Network Graphs",k);this.UZ("highlightNode",[],"Name of nodes in the data.nodes object to highlight","Network Graphs",k);this.RY("nodeHighlight","rgb(255,0,0)","highlighted nodes","Network Graphs",k);this.oV("showNodeNameThreshold",50,"Thereshold used to set the limit to hide or display the name of nodes in a network. If the number of nodes exceed this thereshold then the name will not be shown","Network Graphs",k);this.oV("showNodeNameSizeThreshold",20,"Thereshold used to set the limit to hide or display the name of nodes in a network based on the size of the node. If the number of node size exceed this thereshold then the name will be shown","Network Graphs",k);this.oV("nodeSize",15,"Approximate pixels for the size of the nodes in the network. Automatically adjusted depending on the numebr of nodes in the network","Network Graphs",false);this.Zq("nodeSizeScaleFactor",1,"Scaling factor for increasing size of all nodes in the network","Network Graphs",k);this.RY("edge","rgb(0,0,0)","edges","Network Graphs",k);this.oV("edgeThickness",1,"Default thickness for the edges in the networks","Network Graphs",false);this.Zq("edgeSeparationFactor",1,"Factor to adjust the separation between the edge and the node in the networks","Network Graphs",k);this.F3("labelNodePosition","auto",["auto","center","top","right","bottom","left"],"Default position for the node label","Network Graphs",k);this.oe("node","",false,12,1,"center","middle",0,8,"node","Network Graphs",k);this.RY("node","rgb(245,245,245)","nodes","Network Graphs",k);this.Hx("networkVendor",false,"Network vendor","Network Graphs",k);this.F3("networkProgressBarPosition","bottom",["none","bottom","center","top"],"Position for the progress bar","Network Graphs",k);this.Zq("networkConvergenceThreshold",0.05,"Threshold for the convergence of the network","Network Algorithm Parameters",k);this.F3("attractiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating attractive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log","Network Algorithm Parameters",k);this.F3("repulsiveForceFunction","square",["square","cubic","log","pow","sqrt"],"Type of function to apply when calculating repulsive force in forceDirected network layouts. Fruchterman-Reingold uses square while Eades uses log","Network Algorithm Parameters",k);this.gK("useBarnesHutSimulation",false,"Flag to use Barnes–Hut simulation","Network Algorithm Parameters",k);this.gK("networkDisjoint",true,"Flag to use positioning forces rather than centering forces. Applicable only to force directed layouts that contain multiple subnetworks","Network Algorithm Parameters",k);this.Zq("networkSpeed",0.1,"Network Speed","Network Algorithm Parameters",k);this.Zq("networkGravity",0.75,"Network Gravity","Network Algorithm Parameters",k);this.oV("networkSpringLength",35,"Ideal length for links (springs in physical model)","Network Algorithm Parameters",k);this.Zq("networkSpringCoeff",0.0008,"Hooks law coefficient. 1 - solid spring","Network Algorithm Parameters",k);this.Zq("networkRepulsion",-1,"Coulombs law coefficient. Its used to repel nodes thus should be negative if you make it positive nodes start attract each other","Network Algorithm Parameters",k);this.Zq("networkTheta",0.8,"Theta coefficient from Barnes Hut simulation. Ranged between (0, 1). The closer its to 1 the more nodes algorithm will have to go through. Setting it to one makes Barnes Hut simulation no different from brute-force forces calculation (each node is considered)","Network Algorithm Parameters",k);this.Zq("networkDragCoeff",0.09,"Drag force coefficient. Used to slow down system, thus should be less than 1. The closer it is to 0 the less tight system will be","Network Algorithm Parameters",k);this.oV("networkTimeStep",20,"Default time step (dt) for forces integration","Network Algorithm Parameters",k);this.UZ("barnesHutUpdateQueue",[],"Barnes Hut Queue for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.UZ("barnesHutNodesCache",[],"Barnes Hut node cache for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.oV("barnesHutNodesCacheCurrent",0,"Barnes Hut idex for node cache for performance and avoid Javascript GC","Network Algorithm Parameters",false);this.oV("networkColaLinkDistance",20,"Ideal length for links","Network Cola Algorithm Parameters",k);this.gK("networkColaAvoidOverlaps",true,"Flag to avoid overlaps of nodes in the cola network","Network Cola Algorithm Parameters",k);this.gK("networkColaHandleDisconnected",true,"Handle disconnected nodes in the cola network","Network Cola Algorithm Parameters",k);this.Zq("networkColaConvergenceThreshold",0.01,"Threshold for the convergence of the cola network","Network Cola Algorithm Parameters",k);this.Zq("networkColaGroupCompactness",0.000001,"Compactness for the groups in the cola network","Network Cola Algorithm Parameters",k);this.oV("networkColaSymmetricDiffLinkLengths",5,"Symmetric difference for the link lengths in the cola network","Network Cola Algorithm Parameters",k);this.Zq("networkColaJaccardLinkLength",false,"Ideal length foreach link based on the graph structure around that link. You can use this to create extra space around hub-nodes in dense graphs","Network Cola Algorithm Parameters",k);this.Zq("networkColaJaccardLinkLengthDefault",1,"Default length foreach link based on the graph structure around that link. You can use this to create extra space around hub-nodes in dense graphs","Network Cola Algorithm Parameters",k);this.F3("networkColaFlowLayoutAxis",false,[false,"x","y"],"Causes constraints to be generated such that directed graphs are laid out either from left-to-right or top-to-bottom. A separation constraint is generated in the selected axis for each edge that is not involved in a cycle","Network Cola Algorithm Parameters",k);this.Zq("networkColaFlowLayoutSeparation",10,"Causes constraints to be generated such that directed graphs are laid out either from left-to-right or top-to-bottom. A separation constraint is generated in the selected axis for each edge that is not involved in a cycle","Network Cola Algorithm Parameters",k);this.oV("networkColaStartUnconstrainedIterations",0,"Number of iterations to run unconstrained","Network Cola Algorithm Parameters",k);this.oV("networkColaUserConstraintIterations",0,"Number of user iterations to run unconstrained","Network Cola Algorithm Parameters",k);this.oV("networkColaAllConstraintsIterations",0,"Number of iterations to run all constraints","Network Cola Algorithm Parameters",k);this.oV("networkColaGridSnapIterations",0,"Number of iterations to run grid snap","Network Cola Algorithm Parameters",k);this.gK("networkColaKeepRunning",true,"Flag to keep running the cola network","Network Cola Algorithm Parameters",k);this.gK("networkColaCenterGraph",true,"Flag to center the cola network","Network Cola Algorithm Parameters",k);this.Hx("colorNodeBy",false,"Name of the attribute to color the nodes","Network Node and Edge Attributes",k);this.Hx("shapeNodeBy",false,"Name of the attribute to shape the nods","Network Node and Edge Attributes",k);this.Hx("sizeNodeBy",false,"Name of the attribute to size the nodes","Network Node and Edge Attributes",k);this.Hx("patternNodeBy",false,"Name of the attribute to pattern the nodes","Network Node and Edge Attributes",k);this.Hx("colorEdgeBy",false,"Name of the attribute to color the edges","Network Node and Edge Attributes",k);this.Hx("sizeEdgeBy",false,"Name of the attribute to size the edges","Network Node and Edge Attributes",k);this.Zq("minEdgeSize",0,"Number of pixels to add to the minimum thickness for the edges when the edges are sized by a property. Should be a value between 0 and 1.5","Network Node and Edge Attributes",k);this.Zq("maxEdgeSize",10,"Thickness for the edges when the edges are sized by a property. Should be a value between 10 and 20","Network Node and Edge Attributes",k);this.se("NetworkCommunities",false,"network communities","Network Communities",k);this.gK("calculateNetworkCommunities",true,"Flag to calculate the network communities using the jLouvain algorithm. If this flag is false the property community and communityColor for each node will need to be provided, otherwise all nodes will belong to a single community","Network Communities",k);this.gK("coordinateNetworkConvexHullCommunityColor",false,"Flag to coordinate colors of the nodes with convex hull for the network communities","Network Communities",k);this.Zq("hullScale",1.25,"Scaling factor for extension of the hulls in the network communities","Network Communities",k);this.oV("networkCommunities",null,"Number of network communities","Network Communities",false);this.UZ("networkConvexHulls",[],"Array for the Network community convex hull property object","Network Communities",false);this.oV("genomeTicks",50,"Number of ticks in the genome browser","Genome Browser",k);this.oe("trackName","","rgb(0,0,0)",12,1,"center","middle",0,8,"track name","Genome Browser",k);this.RY("trackFill","rgb(255,255,255)","fill of the tracks in the genome browser","Genome Browser",k);this.RY("trackDir","rgb(0,0,0)","strand direction of the tracks in the genome browser","Genome Browser",k);this.oV("subtracksMaxDefault",8,"Maximum number of subtracks to show in a track","Genome Browser",k);this.oV("showFeatureNameThereshold",20,"Threshehold used to set te limit when there are too many features in the genome browser","Genome Browser",k);this.oe("featureName","","rgb(0,0,0)",12,1,"center","middle",0,8,"feature name","Genome Browser",k);this.RY("featureFill","rgb(255,255,255)","fill of the feature in the genome browser","Genome Browser",k);this.RY("featureDir","rgb(0,0,0)","strand direction of the feature in the genome browser","Genome Browser",k);this.oV("maxFeatureStringLen",30,"Maximum length in characters a feature label can have so anything above is truncated","Genome Browser",k);this.oV("featureWidthDefault",3,"Default size in pixels of the feature width","Genome Browser",k);this.oV("featureHeightDefault",14,"Default size in pixels of the feature height","Genome Browser",k);this.F3("featureSpliceStyle","rect",["rect","broken"],"Default style for splicing in boxes","Genome Browser",k);this.oV("featureTraceHeight",40,"Default size in pixels of the trace height","Genome Browser",k);this.oV("featureTraceTrim",1,"Default triming for nucleotide values in the traces (expressed in percent)","Genome Browser",k);this.gK("featureTracesShow",true,"Flag use to show traces","Genome Browser",k);this.oV("featureQualityHeight",14,"Default size in pixels of the quality height","Genome Browser",k);this.gK("featureQualityValues",false,"Flag use to show values for the quality","Genome Browser",k);this.gK("featureQualityShow",true,"Flag use to show quality","Genome Browser",k);this.oV("featureSignalToNoiseHeight",14,"Default size in pixels of the quality height","Genome Browser",k);this.gK("featureSignalToNoiseValues",false,"Flag use to show values for the quality","Genome Browser",k);this.gK("featureSignalToNoiseShow",true,"Flag use to show quality","Genome Browser",k);this.oV("featureCoordinateHeight",14,"Default size in pixels of the coordinates height","Genome Browser",k);this.gK("featureCoordinateShow",true,"Flag use to show coordinates","Genome Browser",k);this.oV("featureTranslateHeight",14,"Default size in pixels of the translation height","Genome Browser",k);this.gK("featureTranslateShow",true,"Flag use to show tranlation","Genome Browser",k);this.F3("featureTypeDefault","line",["box","bar","heatmap","sequence","triangle","line"],"Default type for the feature in the genome browser","Genome Browser",k);this.gK("featureStaggered",false,"Flag use to stagger the features in the genome panel","Genome Browser",k);this.oe("sequence","","rgb(0,0,0)",12,1,"center","middle",0,8,"sequence","Genome Browser",k);this.RY("sequenceFill",false,"background when showing sequnces in the box or sequence object in the Genome. The default is to use the background of the object. If specied a valid color then all the background of sequences will be uniform","Genome Browser",k);this.RY("sequenceGAP","rgb(255,0,255)","deletions, insertions and gaps in the genome browser","Genome Browser",k);this.RY("sequenceA","rgb(0,103,0)","adenines and alanines in the genome browser","Genome Browser",k);this.RY("sequenceB","rgb(0,0,0)","degenerate C/G/T and asparagines in the genome browser","Genome Browser",k);this.RY("sequenceC","rgb(0,0,255)","cytosines and cysteins in the genome browser","Genome Browser",k);this.RY("sequenceD","rgb(0,0,0)","degenerate A/G/T and aspartic acids in the genome browser","Genome Browser",k);this.RY("sequenceE","rgb(0,0,0)","glutamic acids in the genome browser","Genome Browser",k);this.RY("sequenceF","rgb(0,0,255)","phenylalanines in the genome browser","Genome Browser",k);this.RY("sequenceG","rgb(0,0,0)","guanines and glycines in the genome browser","Genome Browser",k);this.RY("sequenceH","rgb(255,0,0)","degenerate A/C/T and histidines in the genome browser","Genome Browser",k);this.RY("sequenceI","rgb(0,103,0)","isoleucines in the genome browser","Genome Browser",k);this.RY("sequenceK","rgb(255,0,0)","degenerate G/T and lysines in the genome browser","Genome Browser",k);this.RY("sequenceL","rgb(0,103,0)","leucines in the genome browser","Genome Browser",k);this.RY("sequenceM","rgb(0,103,0)","degenerate A/G and methionines in the genome browser","Genome Browser",k);this.RY("sequenceN","rgb(0,0,0)","degenerate A/C/G/T and asparagines in the genome browser","Genome Browser",k);this.RY("sequenceP","rgb(255,165,0)","prolines in the genome browser","Genome Browser",k);this.RY("sequenceQ","rgb(0,0,0)","glutamines in the genome browser","Genome Browser",k);this.RY("sequenceR","rgb(255,0,0)","degenerate A/G and arginines in the genome browser","Genome Browser",k);this.RY("sequenceS","rgb(255,165,0)","degenerate G/C and serines in the genome browser","Genome Browser",k);this.RY("sequenceT","rgb(255,0,0)","thymidines and threonines in the genome browser","Genome Browser",k);this.RY("sequenceU","rgb(255,0,0)","uracils in the genome browser","Genome Browser",k);this.RY("sequenceV","rgb(0,103,0)","degenerate A/C/G and valines in the genome browser","Genome Browser",k);this.RY("sequenceW","rgb(0,0,255)","degenerate A/T and tryptophans in the genome browser","Genome Browser",k);this.RY("sequenceX","rgb(0,0,0)","any aminoacid code in the genome browser","Genome Browser",k);this.RY("sequenceY","rgb(0,0,255)","degenerate C/T and tyrosines in the genome browser","Genome Browser",k);this.RY("sequenceZ","rgb(0,0,0)","glutamines in the genome browser","Genome Browser",k);this.RY("sequenceStart","rgb(0,204,0)","start codon in the genome browser","Genome Browser",k);this.RY("sequenceEnd","rgb(255,0,0)","end codon in the genome browser","Genome Browser",k);this.RY("wire","rgba(204,204,204,0.1)","ticks in the genome browser","Genome Browser",k);this.oV("periodTicksLabels",5,"Number of ticks to skip between values in the genome browser","Genome Browser",k);this.F3("genomeResolution","low",["low","medium","high"],"Number to adjust the splines curvature","Genome Browser",k);this.UZ("trackConfigurableProperties",["name","hideName","hideFeatureNames","type","height","fill","outline","data","hide","connect","subtracksMax","highlight"],"Track configurable properties<br> @tracks {name:[string];Track name;[]}","Genome Browser",k);this.UZ("featureConfigurableProperties",["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"],"Feature configurable properties<br> @features {id:[string];Feature id;[],fill:[color];Color for the feature;[]}","Genome Browser",k);this.UZ("errors",[],"Array containing benign errors produced when rendering canvasXpress","Debug",false);this.gK("debug",false,"Flag to turn on alerts","Debug",k);this.Hx("notice","Debug notices","Debug",false);this.gK("verbose",false,"Flag to turn on/off verbose","Debug",k);this.gK("offline",false,"Flag to work offline","Debug",k);this.se("Version",true,"version when mouse over top-left corner of the canvas","Debug",k);this.se("Code",false,"code for the canvas","Debug",k);this.F3("codeType","params",["pretty","compact","tab","params"],"Output type for the JSON code","Debug",k);this.gK("disableEvents",false,"Flag to disable all events","Events",k);this.gK("disableCode",false,"Flag to disable showing the code","Events",k);this.gK("disableMenu",false,"Flag to disable showing the menu on right clicks","Events",k);this.gK("disableToolbar",false,"Flag to disable showing the toolbar","Events",k);this.gK("disableDataTable",false,"Flag to disable showing data table","Events",k);this.gK("disableDataFilters",false,"Flag to disable showing data filters","Events",k);this.gK("disableCustomizer",false,"Flag to disable the data explorer","Events",k);this.gK("disableTabPanel",false,"Flag to disable the tab panels","Events",k);this.gK("disableCanvas",false,"Flag to disable all canvas events","Events",k);this.gK("disableDrag",false,"Flag to disable drg events in canvas","Events",k);this.gK("disableKeys",false,"Flag to disable key binding events. This prevent some default browser shortcuts and it is system specific. Please see the Event section bellow","Events",k);this.gK("disableShowShortcuts",true,"Flag to disable showing shortcuts","Events",k);this.gK("disablePlusMinusKeys",true,"Flag to disable plus / minus key binding events","Events",k);this.gK("disableUndoRedoKeys",true,"Flag to disable undo / redo key binding events","Events",k);this.gK("disableDocument",false,"Flag to disable mousemove and mouseup in the document","Events",k);this.gK("disableWindow",false,"Flag to disable resizing the canvas when the window is resized. ","Events",k);this.gK("disableWheel",false,"Flag to disable wheel. ","Events",k);this.gK("disableBeacon",false,"Flag to disable beacon. ","Events",k);this.gK("playable",false,"Flag to make the plot playable if there are after rendering functions","Events",k);this.gK("resizable",true,"Flag to disable resizing the canvas by dragging the mouse over the edges","Events",k);this.gK("resizableX",true,"Flag to disable resizing the width of the canvas by dragging the mouse over the edges","Events",k);this.gK("resizableY",true,"Flag to disable resizing the height of canvas by dragging the mouse over the edges","Events",k);this.gK("movable",true,"Flag to disable moving the canvas by dragging the mouse from the move image in the toolbar","Events",k);this.oV("maxSubMenus",25,"Maximum number of submenus in the context menus","Events",k);this.se("PrimaryMenus",false,"primary menus in toolbar","Events",k);this.oV("maxItemMenuCheckbox",10,"Maximum number of items in a menu before it becomes a scroll box","Events",k);this.gK("skipClick",false,"Flag to skip click events after a mouse down event in visualizations where there is a drag capabilities","Events",false);this.oV("infoTimeOut",3000,"Time in milliseconds to wait between updates for the mouse over info to show up","Events",k);this.oV("infoStartTime",new Date().getTime(),"Time in milliseconds to keep track of time","Events",false);this.oV("infoTimeIn",50,"Time in milliseconds to start showing info after a mouse over","Events",k);this.gK("broadcast",true,"Flag to enable broadcasting to other canvasXpress objects in the page","Events",k);this.Hx("broadcastGroup",false,"Group Id for canvas to broadcast to. If not specified then it broadcasts to all canvases","Events",k);this.se("MousePositionOnDrag",true,"mouse position when dragging in relation to the zero coordinate (top-right) of the canvas","Events",k);this.F3("toolbarType","under",["over","under","fixed"],"Toolbar type","Events",k);this.oV("toolbarSize",30,"Height for the toolbar in graphs","Events",k);this.UZ("toolbarItems",["Save","History","Move","Table","Tabs","Explore","Lasso","Customize","Password","Maximize"],"Array containing the items in the toolbar. All items included by default","Events",k);this.gK("lazyLoad",false,"Load canvas only if shown in viewport","Events",k);this.se("Animation",true,"animation for the graphs","Animations and Visualization Transitions",k);this.se("Transition",false,"transitions for the graphs","Animations and Visualization Transitions",k);this.oV("transitionStep",20,"Steps for transition","Animations and Visualization Transitions",k);this.oV("transitionStaggering",10,"Steps for transitionioning data objects","Animations and Visualization Transitions",k);this.F3("transitionFunction","easeInOutQuad",["linear","easeInQuad","easeOutQuad","easeInOutQuad","easeInCubic","easeOutCubic","easeInOutCubic","easeInQuart","easeOutQuart","easeInOutQuart","easeInQuint","easeOutQuint","easeInOutQuint"],"Easing function for the transition","Animations and Visualization Transitions",k);this.Zq("weight",1,"Fraction of the canvas to be used (a value between 0 and 1). Used when multiple graphs are displayed in one canvas. Could be an number or an array of numbers","Combination Plots",false);this.Zq("scaleX",1,"Scale factor for the X axis","Combination Plots",false);this.Zq("scaleY",1,"Scale factor for the Y axis","Combination Plots",false);this.Zq("translateX",0,"Amount to translate for the X axis","Combination Plots",false);this.Zq("translateY",0,"Amount to translate for the Y axis","Combination Plots",false);this.Zq("offsetX",0,"Additional amount to move for the X axis","Combination Plots",false);this.Zq("offsetY",0,"Additional amount to move for the Y axis","Combination Plots",false);this.Zq("layoutWidth",0,"Width of the current segment of the canvas when there are multiple graphs","Combination Plots",false);this.Zq("layoutHeight",0,"Height of the current segment of the canvas when there are multiple graphs","Combination Plots",false);this.Hx("layout","1X1","Topology of the canvas. Number of rows and columns","Combination Plots",false);this.Hx("layoutTopology",false,"Topology of the canvas. Number of columns and rows separated by X. For example: 2X1, 1X3, etc","Combination Plots",k);this.gK("layoutComb",false,"Flag that identify that multiple graphs will be displayed in the canvas. This is the case when ata is segregated, splom, multiple pies or DOE visualizations","Combination Plots",false);this.gK("layoutAdjust",false,"Flag to force recalculating the ranges in the axes when multiple graphs are displayed in the canvas","Combination Plots",k);this.gK("layoutGlobalGroups",false,"Flag to force same groups across all layout plots","Combination Plots",k);this.gK("layoutCollapse",false,"Flag to make layout graphs without any space in between","Combination Plots",k);this.F3("layoutType","wrap",["wrap","rows","cols"],"Type of layout to place the position for the labels in the trellis plot. Identify the axis that will be used to place the first segregating factor. rows will use the first segregating factor in the rows and the second in the columns. cols will use the first segregating factor in the columns and the second in the rows. wrap will wrap the segregating factors putting the sample factors in the columns","Combination Plots",k);this.gK("layoutRemoveEmpty",true,"Flag to remove empty combinations in segregated layouts","Combination Plots",k);this.gK("layoutCanvasCompartments",false,"Flag to draw lines around each graph in the layout in the canvas. Used only when debugging","Combination Plots",k);this.UZ("layoutBoxLabelColors",[],"Layout box label background colors.<br>","Combination Plots",k);this.gK("layoutBoxShow",true,"Flag to draw the layout boxes","Combination Plots",k);this.RY("layoutLabel","rgb(0,0,0)","label text in layout graphs","Combination Plots",k);this.Zq("layoutLabelBoxThickness",30,"Thickness of the layout label boxes","Combination Plots",k);this.gK("layoutLabelShow",true,"Flag to draw the layout label","Combination Plots",k);this.UZ("layoutConfig",[],"Array of object to assign visualization configurations to each layout","Combination Plots",k);this.oV("layoutCurrent",0,"Integer to identify the current graph being displayed in the canvas","Combination Plots",false);this.F3("layoutAxis",3,[1,2,3],"Flag to indicated whether to print axes values when multiple graphs are displayed in the canvas. The possible values are: 1: horizontal, 2: vertical, 3: both","Combination Plots",k);this.oV("imageTimeOut",1000,"Time in milliseconds to wait to load images","Images",k);this.oV("imageMaxTries",10,"Maximum times to try to load images. Used to calculate the timeout which will be imageTimeOut / imageTries which will be 100ms by default","Images",k);this.oV("imageTries",0,"Image try counter","Images",false);this.bN("remoteService",false,"Url used to obtain data remotely thorugh a web service or directly from a file. If the remote service is a file then it expects a json file with a two dimensional array. Each of the arrays should have a key (which will be used in a drop down menu) and a value to point to a url where to get the data. If the remote service is a web service it expects a canvasXpress object. The default parameters for web services are index (to identify the current record number) and dir (to identify the direction; it could be either next or prev)","Remote Procedures",k);this.hM("remoteParams",{},"Object to hold additional parameters used to obtain data remotely. The target property will be always added to the method as well as the direction [next|prev]","Remote Procedures",k);this.F3("remoteDirection","next",["next","prev"],"Direction parameter used to obtain data remotely","Remote Procedures",k);this.gK("remoteAutoPlay",false,"Flag to automatically iterate over remote data sets","Remote Procedures",k);this.oV("remoteAutoPlayDelay",3000,"Time in milliseconds to wait between iterations while automatically going over remote data sets","Remote Procedures",k);this.gK("remoteParamOverride",true,"Flag to override parameters to maintain the state of the graphs when using remote services","Remote Procedures",k);this.F3("remoteTransitionEffect","slide",["none","slide","fade"],"Effect for the remote transitions","Remote Procedures",k);this.gK("remoteAutoSize",true,"Flag to adjust remote graph to current canvas size","Remote Procedures",k);this.Hx("remoteParentId","","Id for the parent holding the remoteWindow to prevent id collisions","Remote Procedures",false);this.oV("remoteDataIndex",0,"Index of the canvasXpress object requested","Remote Procedures",false);this.UZ("remoteIds",[],"Array of the remoteIds passed after a service call","Remote Procedures",false);this.UZ("remoteData",[],"Array for the remote data pased after a service call","Remote Procedures",false);this.gK("remoteUpdating",false,"Flag to indicate that updating data is in progress","Remote Procedures",false);this.bN("RdatasetsURL","https://raw.githubusercontent.com/neuhausi/Rdatasets/master/","URL for R objects","R",false);this.gK("loadRDatasets",false,"Flag to load R datasets from Github","R",k);this.oV("maxDataCustomizerEntries",10000,"Maximum number of samples or variables to display in the data customizer","Data Customizer",k);this.F3("customizerSize","medium",["xsmall","small","medium","large"],"Size for the customizer. Requires re-opening of customizer","Data Customizer",k);this.gK("customizerEntriesAsList",true,"Flag to show entries in scrolling widgets as text. The default is to show them as icons-like","Data Customizer",k);this.gK("customizerGraphMaximize",false,"Flag to maximize the graph when the customizer is called","Data Customizer",k);this.gK("skipConfigurableProperties",true,"Flag to indicate to exclude configurable parameters in the data table and the data filters in Networks and Genome Browser","Data Table/Filter",k);this.UZ("nodesProperties",[],"Two dimensional array with object properties not at the root level for the nodes in the Network graph to include in the Data table and the data filter","Data Table/Filter",k);this.UZ("edgesProperties",[],"Two dimensional array with object properties not at the root level for the edges in the Network graph to include in the Data table and the data filter","Data Table/Filter",k);this.UZ("featuresProperties",[],"Two dimensional array with object properties not at the root level for the features in the Genome graph to include in the Data table and the data filter","Data Table/Filter",k);this.oV("dataFilterWidth",300,"Size in pixels for the data filters","Data Filters",k);this.F3("filterType","and",["and","or"],"Type for the filter. Can be and or or","Data Filters",k);this.F3("filterMode","hide",["hide","color"],"Mode for the legend filters. Can be set to hide the data using transparency or to color the data points with the missingDataColor","Data Filters",k);this.gK("filterSkipNullKeys",false,"Flag to indicate to bypass filtering when a key is non existent in the data objects","Data Filters",k);this.gK("filterSkipNullValues",false,"Flag to indicate to bypass filtering when a value is null","Data Filters",k);this.L3("filterVarBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter variables by their annotation included in the data.z object used in one dimensional plots. Used in the CanvasXpress UIs","Data Filters",k);this.L3("filterSmpBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter samples by their annotation included in the data.x object used in one dimensional plots. Used in the CanvasXpress UIs","Data Filters",k);this.L3("filterNodeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter nodes by their properties used in network graphs. Used in the CanvasXpress UIs","Data Filters",k);this.L3("filterEdgeBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter edges by their properties used in network graphs. Used in the CanvasXpress UIs","Data Filters",k);this.L3("filterFeatureBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter features by their properties used in genome browser. Used in the CanvasXpress UIs","Data Filters",k);this.L3("filterDataBy",{cases:[],comp:[],op:[],type:[],value:[]},"Filter data by their value in the data object used in oncoprints. Used in the CanvasXpress UIs","Data Filters",k);this.gK("dataTableTransposed",true,"Flag to transpose the data in the data table","Data Table",k);this.oV("maxRows",8,"Maximum number of rows to display in the data table","Data Table",k);this.oV("maxCols",6,"Maximum number of columns to display in the data table","Data Table",k);this.oV("colWidth",120,"Mumber of pixels for the width of cells in the data table","Data Table",k);this.oV("rowHeight",32,"Mumber of pixels for the height of cells in the data table","Data Table",k);this.oV("dataTableFontSize",18,"Data table font size","Data Table",k);this.Hx("dataTableFontFamily","unset","Data table font family","Data Table",k);this.gK("refresehDataTableOnDraw",false,"Flag to indicate to refresh data after drawing the plot","Data Table",k);this.se("DataTableOnSelect",false,"Flag to indicate to show data after selecting data in the plot","Data Table",k);this.F3("networkShowDataTable","nodes",["nodes","edges"],"Show nodes or edges on data table","Data Table",k);this.gK("colorDataTable",true,"Flag to color the data table","Data Table",k);this.RY("backgroundDataTable","rgba(255,255,255,0.95)","data table background","Data Table",k);this.Zq("colorDataTableTransparency",0.5,"Transparency for the background of the data table cells if colored","Data Table",k);this.F3("dataTableStyle","modern",[false,"stripped","modern"],"Data table style","Data Table",k);this.oV("startCol",0,"Starting column in the data table","Data Table",false);this.oV("startRow",0,"Starting row in the data table","Data Table",false);this.oV("totalCols",null,"Total columns in the data table","Data Table",false);this.oV("totalRows",null,"Total rows in the data table","Data Table",false);this.UZ("dataTableColumnWidth",[],"Array to store the column width for the data table","Data Table",false);this.UZ("dataTableRowHeight",[],"Array to store the row height for the data table","Data Table",false)};this.Cy=function(t){for(var p in t){if(p=="conditional"){for(var c in t[p]){if(CanvasXpress.graphTypes[c].includes(this.graphType)){for(var q in t[p][c]){this[q]=t[p][c][q]}}}}else{if(p!="colorScheme"&&p!="colors"){this[p]=t[p]}else{if(p=="colorScheme"&&t[p]){this[p]=t[p]}}}}};this.Gf=function(c){if(!c){c=CanvasXpress.stack[this.target]?CanvasXpress.stack[this.target].config:false}if(c&&c.hasOwnProperty("theme")&&c.theme){var t=c.theme.toLowerCase().replace(" ","");var theme="none";switch(t){case"cx":case"canvasxpress":theme="cx";break;case"paultol":theme="paulTol";break;case"wallstreetjournal":case"wallstreet":theme="wallStreetJournal";break;case"blackandwhite":theme="blackAndWhite";break;case"lastairbenderfire":theme="lastAirBender";this.colorScheme="LastAirBenderFire";break;case"lastairbenderair":theme="lastAirBender";this.colorScheme="LastAirBenderAir";break;case"lastairbenderwater":theme="lastAirBender";this.colorScheme="LastAirBenderWater";break;case"lastairbenderearth":theme="lastAirBender";this.colorScheme="LastAirBenderEarth";break;case"gameofthronestargaryen":theme="gameOfThrones";this.colorScheme="GameOfThronesTargaryen";break;case"gameofthronesstark":theme="gameOfThrones";this.colorScheme="GameOfThronesStark";break;case"gameofthronesstannis":theme="gameOfThrones";this.colorScheme="GameOfThronesStannis";break;case"gameofthroneslannister":theme="gameOfThrones";this.colorScheme="GameOfThronesLannister";break;case"gameofthronestyrell":theme="gameOfThrones";this.colorScheme="GameOfThronesTyrell";break;case"gameofthronesmartell":theme="gameOfThrones";this.colorScheme="GameOfThronesMartell";break;case"gameofthronestully":theme="gameOfThrones";this.colorScheme="GameOfThronesTully";break;case"gameofthronesgreyjoy":theme="gameOfThrones";this.colorScheme="GameOfThronesGreyjoy";break;case"gameofthronesmanderly":theme="gameOfThrones";this.colorScheme="GameOfThronesManderly";break;case"gameofthronesarryn":theme="gameOfThrones";this.colorScheme="GameOfThronesArryn";break;default:theme=t;break}if(CanvasXpress.themes.hasOwnProperty(theme)){this.Cy(CanvasXpress.themes[theme])}}};this.d6=function(){var fs=["fontSize","titleFontSize","subtitleFontSize","smpTitleFontSize","smpLabelFontSize","varTitleFontSize","varLabelFontSize","overlayFontSize","dataLabelFontSize","legendTextFontSize","legendTitleFontSize","decorationsTextFontSize","axisTickFontSize","axisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var i=0;i<fs.length;i++){this[fs[i]]=Number(CanvasXpress.doc.P[fs[i]].D)}this.DW()};this.DW=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.dataLabelFont=this.dataLabelFontStyle+" "+this.dataLabelFontSize+"px "+this.fontName;this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.legendTextFont=this.legendTextFontStyle+" "+this.legendTextFontSize+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+this.legendTitleFontSize+"px "+this.fontName;this.decorationsTextFont=this.decorationsTextFontStyle+" "+this.decorationsTextFontSize+"px "+this.fontName;this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.hT=function(){if(this.meta.config.user){delete (this.meta.config.user.skipRender);for(var o in this.meta.config.user){if(this.isCreateHistogram){if(o=="setMaxX"||o=="setMinX"){continue}}if(this.isPivot){if(o=="groupingFactors"){continue}}if(CanvasXpress.doc.P[o]&&CanvasXpress.doc.P[o].hasOwnProperty("T")){if(CanvasXpress.doc.P[o].T=="integer"||CanvasXpress.doc.P[o].T=="float"){this.meta.config.user[o]=this.meta.config.user[o]===null?null:Number(this.meta.config.user[o])}this[o]=this.meta.config.user[o]}else{this[o]=this.meta.config.user[o]}}}};this.ZT=function(a){var o={};if(a){for(var i=0;i<a.length;i++){o[a[i]]=this[a[i]]}}this.PI();for(var i in o){this[i]=o[i]}};this.oy=function(o){if(o){if(o.groupingFactors&&this.groupingFactors.length){if(!this.eC(o.groupingFactors,this.groupingFactors)){this.q0(true)}}this.meta.config.user=o;for(var i in o){this[i]=o[i]}}};this.m5=function(o){if(o){for(var i in o){this[i]=o[i]}}};this.RO=function(a){var that=this;var o={};var k=CanvasXpress.config.sort();var getDefault=function(j){if(that.theme&&CanvasXpress.themes[that.theme]&&CanvasXpress.themes[that.theme].hasOwnProperty(j)){return CanvasXpress.themes[that.theme][j]}else{return CanvasXpress.doc.P[j].D}};var skip={colors:true,shapes:true,images:true,randomSeed:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,trackConfigurableProperties:true,featureConfigurableProperties:true};var cols={background:true,backgroundWindow:true,foreground:true};if(this.isTransformedData){o.isTransformedData=this.isTransformedData}for(var i=0;i<k.length;i++){var j=k[i];if(j.match(/FontSize$/)){continue}if(CanvasXpress.doc.P[j]&&CanvasXpress.doc.P[j].hasOwnProperty("D")){var d=getDefault(j);if(skip.hasOwnProperty(j)){continue}var v=that[j]===undefined?false:that[j];if(typeof(v)=="object"){if(d=="[]"){d=[]}if(d=="{}"){d={}}if(v===null){if(d!=null){o[j]=v}}else{if(j=="sizes"){if(!this.eC(v,d.map(Number))){o[j]=v}}else{if(j=="colorSpectrum"||j=="colors"){var t=[];for(var c=0;c<v.length;c++){var tc=this.GC(v[c],false,true);if(tc){t.push(tc.toLowerCase())}}if(!this.eC(t,d)){o[j]=v}}else{if(j.match("filter")){if(!this.eC(v,d)){o[j]=v}}else{if(!this.eC(v,d)){o[j]=v}}}}}}else{if(j.match(/Color/)||cols.hasOwnProperty(j)){if(this.GC(v)!=this.GC(d)){o[j]=v}}else{if(d!=null&&d.toString().match(/false|true|null/)){if(j=="summaryType"&&v=="raw"){continue}else{if(v.toString()!=d.toString()){o[j]=v}}}else{if(v!=d){o[j]=v}}}}}}if(o.backgroundImage&&o.backgroundImage.match(/javascript:\/\//)){if(CanvasXpress.cacheImages[o.backgroundImage.split("//")[1]]){o.backgroundImageSrc=btoa(CanvasXpress.cacheImages[o.backgroundImage.split("//")[1]].replace("data:image/png;base64,",""))}}if(a){for(var i=0;i<a.length;i++){o[a[i]]=this.configStndBy&&this.configStndBy[a[i]]?this.configStndBy[a[i]]:this[a[i]]}}o.graphType=this.graphType;return o};this.TT=function(){return this.meta.config.user};this.X0=function(o){if(o){for(var i in o){var e=o[i];e=e.substring(10,e.length-2).replace(/&quot;/g,'"');this.events[i]=eval("("+e+")")}}};this.Tg=function(id){var c=this.$(id);if(!c||c.tagName.toLowerCase()!="canvas"){c=this.$cX("canvas",{id:id});window.body.appendChild(c)}return this.Nn(c)};this.Rs=function(){var dpr=window.devicePixelRatio||1;var ctx=this.Nn(this.$cX("canvas"));var bsr=ctx.webkitBackingStorePixelRatio||ctx.mozBackingStorePixelRatio||ctx.msBackingStorePixelRatio||ctx.oBackingStorePixelRatio||ctx.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=dpr/bsr};this.md=function(canvas,dpi){canvas.style.width=canvas.style.width||canvas.width+"px";canvas.style.height=canvas.style.height||canvas.height+"px";var scaleFactor=dpi/96;var width=parseFloat(canvas.style.width);var height=parseFloat(canvas.style.height);var oldScale=canvas.width/width;var backupScale=scaleFactor/oldScale;var backup=canvas.cloneNode(false);this.Nn(backup).drawImage(canvas,0,0);var ctx=this.Nn(canvas);canvas.width=Math.ceil(width*scaleFactor);canvas.height=Math.ceil(height*scaleFactor);ctx.setTransform(backupScale,0,0,backupScale,0,0);ctx.drawImage(backup,0,0);ctx.setTransform(scaleFactor,0,0,scaleFactor,0,0)};this.bf=function(){var c=this.$(this.target);if(c){this.Rs();this.q6();this.meta.canvas.ctx=this.Nn(c);this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.Nn=function(canvas){return canvas.getContext("2d")};this.rU=function(){var c=this.isSVG?this.meta.canvas.SVG:this.isHighlightCanvas?this.meta.canvas.ctx2:this.meta.canvas.ctx;this.currentCanvasContext=c.canvas.id;return c};this.q6=function(){var c=new RegExp("/www.canvasxpress.org/dist/");var head=window.document.getElementsByTagName("head")[0];for(var i=0;i<head.childNodes.length;i++){var e=head.childNodes[i];if(e.type=="text/javascript"&&c.test(e.src)){CanvasXpress.factory.siteSrc=true}}};this.Ay=function(){if(!CanvasXpress.themes){CanvasXpress.themes={};var t=CanvasXpress.themes;var pars=Object.keys(CanvasXpress.themeDef);var name=CanvasXpress.themeDef.names;for(var i=0;i<name.length;i++){var n=name[i];if(!t[n]){t[n]={}}for(var j=0;j<pars.length;j++){var p=pars[j];if(p=="names"){continue}t[n][p]=CanvasXpress.themeDef[p][i]}}t.CanvasXpress=t.cx;t.canvasXpress=t.cx;t.canvasxpress=t.cx;t.paultol=t.paulTol;t.PaulTol=t.paulTol;t.GGPlot=t.ggplot}};this.Y6=function(){var c=CanvasXpress.system;c.isR=this.isR;c.isHTMLWidgets=typeof HTMLWidgets!="undefined";c.isShiny=typeof window.Shiny!=="undefined"&&!!window.Shiny.outputBindings;c.isRViewer=/\bviewer_pane=1\b/.test(window.location);c.isRConsole=c.isHTMLWidgets&&!c.isShiny&&!c.isRViewer;c.isNode=typeof exports==="object"&&typeof module!=="undefined";c.isReact=typeof React!="undefined";c.isHeadless=(this.url&&this.url.hasOwnProperty("cXD")&&this.url.cXD==c.registered)||window.navigator.webdriver;c.isCxplot=this.isCxplot;c.isjQuery=typeof $==="function";c.isReveal=typeof Reveal!="undefined";c.isZoom=typeof zoom!="undefined"};this.cc=function(images){for(var i=0;i<images.length;i++){images[i].style.transform="scale("+(1/Reveal.getScale())+")"}};this.Jq=function(divs){for(var i=0;i<divs.length;i++){divs[i].parentNode.style.overflowX="unset";divs[i].style.transform="scale("+(1/Reveal.getScale())+")"}};this.uk=function(){var that=this;if(CanvasXpress.system.isReveal&&!window.RevealCanvasXpress){var images=document.querySelectorAll("img.CanvasXpress");that.cc(images);var canvases=document.querySelectorAll("canvas.CanvasXpress");for(var i=0;i<canvases.length;i++){canvases[i].parentNode.parentNode.style.overflowX="unset";canvases[i].parentNode.style.transform="scale("+(1/Reveal.getScale())+")";canvases[i]["data-responsive"]=true;canvases[i]["data-aspectRatio"]=parseInt(canvases[i].clientWidth)+":"+parseInt(canvases[i].clientHeight);if(canvases[i].hasAttribute("data-src")&&canvases[i].id){new CanvasXpress({renderTo:canvases[i].id,data:canvases[i].getAttribute("data-src")})}}Reveal.addEventListener("slidechanged",function(event){var images=Reveal.getCurrentSlide().querySelectorAll("img.CanvasXpress");that.cc(images);var canvases=Reveal.getCurrentSlide().querySelectorAll("canvas.CanvasXpress");if(canvases.length){var divs=Reveal.getCurrentSlide().querySelectorAll("div.CanvasXpress-ParentNode");that.Jq(divs)}});Reveal.addEventListener("dblclick",function(event){var target=event.target;if(!target.id){target.id="foobar"}if(target.tagName.toLowerCase()=="img"&&that.qO(target,"CanvasXpress")){var id=that.Ph("-cX-Reveal-"+target.id+"-");var cnv=document.createElement("canvas");cnv.id=id;cnv.width=target.clientWidth;cnv.height=target.clientHeight;cnv["data-responsive"]=true;cnv["data-aspectRatio"]=parseInt(target.clientWidth)+":"+parseInt(target.clientHeight);target.parentNode.insertBefore(cnv,target.nextSibling);target.style.display="none";new CanvasXpress({renderTo:id,data:target.src,callback:function(){var divs=Reveal.getCurrentSlide().querySelectorAll("div.CanvasXpress-ParentNode");that.Jq(divs)}})}});window.RevealCanvasXpress=true}};this.cQ=function(config){CanvasXpress.config=[];this.PI();this.Ay();if(config&&config.graphType){this.graphType=config.graphType}if(this.graphType.match(/Network/)){this.xRotate=0}var k=config?Object.keys(config):[];var x=0;for(var i=0;i<k.length;i++){if(k[i].match(/^remote/)){x++;if(k[i]=="remoteData"||k[i]=="remoteIds"){this[k[i]]=config[k[i]]}}}if(!config||(config&&!config.graphOrientation&&x!=k.length)){if(this.meta.config.user){this.meta.config.user.graphOrientation=this.graphOrientation}}this.Gf(config);if(config){if(!window.cX){CanvasXpress.factory.valid=config.cX;window.cX=CanvasXpress.factory.valid}for(var i in config){if(CanvasXpress.doc.P[i]&&CanvasXpress.doc.P[i].D==null&&config[i]===""){delete config[i]}}if(config.hasOwnProperty("skipRender")){this.skipRender=config.skipRender}if(!config.graphType||config.graphType.match(/Scatter/)){this.dataTableTransposed=false}for(var i=0;i<CanvasXpress.config.length;i++){var o=CanvasXpress.config[i];var t=CanvasXpress.doc.P[o]?CanvasXpress.doc.P[o].T:false;if(config.hasOwnProperty(o)){if(t=="array"){if(config[o] instanceof Array){this[o]=config[o]}else{this[o]=[config[o]];config[o]=[config[o]]}}else{this[o]=config[o]}}}}this.DW();for(var p in this.url){if(this.hasOwnProperty(p)){this[p]=this.url[p]}}this.bf();this.Y6();this.uk();window.pcX={};if(CanvasXpress.system.isShiny){this.disableUndoRedoKeys=true}}};CanvasXpress.prototype.initDate=function(){var a=function(){var b=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,c=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,e=/[^-+\dA-Z]/g,d=function(g,f){g=String(g);f=f||2;while(g.length<f){g="0"+g}return g};return function(j,w,r){var h=a;if(arguments.length==1&&Object.prototype.toString.call(j)=="[object String]"&&!/\d/.test(j)){w=j;j=undefined}j=j?new Date(j):new Date;if(isNaN(j)){throw SyntaxError("invalid date")}w=String(h.masks[w]||w||h.masks["default"]);if(w.slice(0,4)=="UTC:"){w=w.slice(4);r=true}var u=r?"getUTC":"get",n=j[u+"Date"](),f=j[u+"Day"](),k=j[u+"Month"](),q=j[u+"FullYear"](),t=j[u+"Hours"](),l=j[u+"Minutes"](),v=j[u+"Seconds"](),p=j[u+"Milliseconds"](),g=r?0:j.getTimezoneOffset(),i={d:n,dd:d(n),ddd:h.i18n.dayNames[f],dddd:h.i18n.dayNames[f+7],m:k+1,mm:d(k+1),mmm:h.i18n.monthNames[k],mmmm:h.i18n.monthNames[k+12],yy:String(q).slice(2),yyyy:q,h:t%12||12,hh:d(t%12||12),H:t,HH:d(t),M:l,MM:d(l),s:v,ss:d(v),l:d(p,3),L:d(p>99?Math.round(p/10):p),t:t<12?"a":"p",tt:t<12?"am":"pm",T:t<12?"A":"P",TT:t<12?"AM":"PM",Z:r?"UTC":(String(j).match(c)||[""]).pop().replace(e,""),o:(g>0?"-":"+")+d(Math.floor(Math.abs(g)/60)*100+Math.abs(g)%60,4),S:["th","st","nd","rd"][n%10>3?0:(n%100-n%10!=10)*n%10]};return w.replace(b,function(m){return m in i?i[m]:m.slice(1,m.length-1)})}}();a.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'",year:"yyyy",yearMonth:"mmm yyyy",month:"mmmm",day:"dddd",hour:"HH",minute:"MM",second:"ss"};a.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(b,c){return a(this,b,c)};this.qD=function(b){return !isNaN(new Date(b))};this.dateFormat=a};CanvasXpress.prototype.initText=function(){this.g4=function(a){if(this.showTextShadow){if(a){this.meta.canvas.ctx.shadowOffsetX=this.shadowOffsetX;this.meta.canvas.ctx.shadowOffsetY=this.shadowOffsetY;this.meta.canvas.ctx.shadowBlur=this.shadowBlur;this.meta.canvas.ctx.shadowColor=this.shadowColor}else{this.meta.canvas.ctx.shadowOffsetX=0;this.meta.canvas.ctx.shadowOffsetY=0;this.meta.canvas.ctx.shadowBlur=0;this.meta.canvas.ctx.shadowColor=this.background}}};this.cI=function(C,A,z,a,D,u,p,v,j,w,d,g,B){if(C==undefined){C=""}var q=["poly"];var o=this.HU(p);var j=this.DU(C,p,B)*(Math.PI*0.5)/a;D=(D+(u/2))-(j/2)%(Math.PI*2);u=D+j;var n=this.TX(A,z,a,D,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.TX(A,z,a-o,D,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.yd(q)}else{return q}};this.oQ=function(B,z,w,a,C,p,o,q,j,v,g,h,A){if(B==undefined){B=""}if(!A){A=this.rU()}if(B==null){return}if(!A){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(z)||isNaN(w)){if(this.debug){alert("Not a valid coordinate ("+z+", "+w+") to draw "+B)}return}if(!h&&!isNaN(B)){B=this.qo(B)}B=B.toString().replace("\x00","");if(!z){z=0}if(!w){w=0}if(!o){o=this.font}if(!q){q=this.foreground}if(!j){j=this.align}if(!v){v=this.baseline}this.ah(A);A.strokeStyle=this.pe(q)?q[0]:q;A.fillStyle=this.pe(q)?q[0]:q;A.font=o;A.textAlign=j;A.textBaseline=v;this.g4(true);var d=j=="right"?1:-1;var u=this.HU(o);if(((["left","center"].indexOf(j)>-1)&&g)||(j=="right"&&!g)){B=B.split("").reverse().join("");if(this.pe(q)){q=q.reverse()}}A.translate(z,w);C+=(Math.PI*!g);C+=(Math.PI/2)+(p/2);if(j=="center"){for(var k=0;k<B.length;k++){var n=this.DU(B[k],o,A);C+=((n+(k==B.length-1?0:this.circularLetterSeparationFactor))/(a-u))/2*-d}}p=C;this.Dr(C,A);for(var k=0;k<B.length;k++){var n=this.DU(B[k],o,A);p+=(n/2)/(a-u)*d;this.Dr((n/2)/(a-u)*d,A);if(this.pe(q)){A.strokeStyle=q[k];A.fillStyle=q[k]}A.fillText(B[k],0,(g?1:-1)*(0-a+u/2));p+=(n/2+this.circularLetterSeparationFactor)/(a-u)*d;this.Dr((n/2+this.circularLetterSeparationFactor)/(a-u)*d),A}this.eh(A);this.g4(false)};this.lC=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.HU(A);var C=[];var F=k+(r%2?0:w/2)-(r.length*w/2);for(var u=0;u<r.length;u++){C.push(this.Pn(r[u],n,F,A,B,E,D,g,q,p,j));F+=w}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.zL=function(B,w,r,o,q,v,u,e,h,C,z,A){var j=B.split(/\n/);var d=o;if(!d){d=this.font}var n=this.HU(d);var p=r+(j%2?0:n/2)-(j.length*n/2);for(var k=0;k<j.length;k++){this.mG(j[k],w,p,d,q,v,u,e,h,C,z,A);p+=n;if(e&&e<90){w+=n;p-=n}}};this.Pn=function(p,n,l,C,D,F,E,g,r,q,k,u){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.VZ(b[0],b[1],n,l,g));a=a.concat(j.VZ(b[2],b[1],n,l,g));a=a.concat(j.VZ(b[2],b[3],n,l,g));a=a.concat(j.VZ(b[0],b[3],n,l,g));return a};if(p==undefined){p=""}if(k){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(l<this.marginTop+this.offsetY+this.top||l>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.Jg(p)){return this.lC(p,n,l,C,D,F,E,g,r,q,k)}var G=[];var o=this.DU(p,C,u);var z=this.HU(C);var B,e,A,d;var i=0;if(r){while(o>r&&i<10){p=p.substring(0,p.length-1);o=this.DU(p,C,u);i++}}if(F=="left"){B=n;A=B+o}else{if(F=="right"){B=n-o;A=n}else{B=n-(o/2);A=n+(o/2)}}if(E=="top"){e=l;d=e+z}else{if(E=="bottom"){e=l-z;d=l}else{e=l-(z/2);d=l+(z/2)}}G=["rect",B,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.yd(G)}else{return G}};this.mG=function(r,n,j,h,i,l,k,d,e,u,p,q){if(r==undefined){r=""}if(!q){q=this.rU()}var g=0;if(r==null){return}if(this.Jg(r)){return this.zL(r,n,j,h,i,l,k,d,e,u,p,q)}if(!q){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(n)||isNaN(j)){if(this.debug){alert("Not a valid coordinate ("+n+", "+j+") to draw "+r)}return}if(p){if(n<this.marginLeft+this.offsetX+this.left||n>this.marginLeft+this.offsetX+this.left+this.x){return}if(j<this.marginTop+this.offsetY+this.top||j>this.marginTop+this.offsetY+this.top+this.y){return}}if(!n){n=0}if(!j){j=0}if(!h){h=this.font}if(!i){i=this.foreground}if(!l){l=this.align}if(!k){k=this.baseline}var o=this.DU(r,h,q);if(e){while(o>e&&g<10){r=r.substring(0,r.length-1);o=this.DU(r,h,q);g++}}if(d){this.ah(q);q.strokeStyle=i;q.fillStyle=i;q.font=h;this.bp(n,j,q);q.textAlign=l;q.textBaseline=k;this.g4(true);this.Dr(d,q);r=r.toString().replace("\x00","").replace("u0000","");if(u){q.strokeText(r,0,0)}else{q.fillText(r,0,0)}this.eh(q)}else{q.strokeStyle=i;q.fillStyle=i;q.font=h;q.textAlign=l;q.textBaseline=k;this.g4(true);r=r.toString().replace("\x00","").replace("u0000","");if(u){q.strokeText(r,n,j)}else{q.fillText(r,n,j)}}this.g4(false)};this.Jg=function(b){var a=b.toString().split(/\n/);return a.length-1};this.YX=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.NW=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.VO=function(e,g,c){var b=e.split(/\n/);var a=0;if(!c){c=this.rU();if(!c){return 0}}if(!g){g=this.font}c.font=g;for(var d=0;d<b.length;d++){a=Math.max(a,c.measureText(b[d]).width)}return a};this.DU=function(b,c,a){if(!a){a=this.rU()}if(!b||!a){return 0}b=b.toString();if(!c){c=this.font}try{CanvasXpress}catch(d){return false}if(!CanvasXpress.cacheText[c]){CanvasXpress.cacheText[c]={}}if(!CanvasXpress.cacheText[c][b]){a.font=c;if(this.Jg(b)){CanvasXpress.cacheText[c][b]=this.VO(b,c,a)}else{CanvasXpress.cacheText[c][b]=a.measureText(b).width}}return CanvasXpress.cacheText[c][b]};this.Db=function(b,c){var a=this.Jg(b);if(a>0){return(this.HU(c)+this.margin)*(a+1)}else{return this.HU(c)}};this.z2=function(c,i,b,d,a){var g=Math.ceil(i);if(this.fontStyle==false){this.fontStyle=""}var e=this.fontStyle+" "+g+"px "+this.fontName;if(c){while(this.DU(c,e,a)>b&&g>=this.minTextSize){g-=2;e=this.fontStyle+" "+g+"px "+this.fontName}if(d){while(parseInt(g/1.33)>d-2){g--}e=this.fontStyle+" "+g+"px "+this.fontName}}if(this.fontScaleFontFactor!=1){e=this.fontStyle+" "+parseInt(g*this.fontScaleFontFactor)+"px "+this.fontName}return e};this.HU=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.Ss=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.pd=function(c,b){var a=new RegExp("(?![^\\n]{1,"+b+"}$)([^\\n]{1,"+b+"})([\\s|-])","g");return c.toString().replace(a,"$1$2\n").replace(" \n","\n")};this.mn=function(l,h,u){var v=RegExp("(?:\\s|^)(.{1,"+h+"})(?=\\s|$)","g");var k=[];var t=[];var g=[];var p=0;var s=0;var o=this.DU(" ",u||this.font);while((m=v.exec(l))!==null){k.push(m[1])}for(var f=0;f<k.length-1;f++){if(k[f].indexOf(" ")!=-1){while(k[f].length<h){for(var e=0;e<k[f].length-1;e++){if(k[f][e]==" "){k[f]=k[f].substring(0,e)+" "+k[f].substring(e);if(k[f].length==h){break}while(k[f][e]==" "){e++}}}}}t.push(k[f])}t.push(k[k.length-1]);for(var f=0;f<t.length-1;f++){var c=this.DU(t[f],u);if(c>p){p=c;s=f}g.push(c)}for(var f=0;f<t.length-1;f++){var d=parseInt((p-g[f])/o);var e=/\s+/gi;var a=[];var b;if(d>0){while((b=e.exec(t[f]))!=null){a.push(b.index)}if(a.length>d){while(d>0){t[f]=t[f].substring(0,a[d-1])+" "+t[f].substring(a[d-1]);d--}}else{while(g[f]+o<p){t[f]=t[f].replace(" ","  ");g[f]+=o}}}}return t.join("\n")};this.EA=function(a,b){var d=this.HU(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.qo=function(f,e){var c=(!isNaN(e)&&parseInt(e!=null?e:10)>0)?parseFloat(f).toFixed(parseInt(e!=null?e:10)):Number(f);var b=parseFloat(c);if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){var a=b.toExponential(2).toString().replace("e+0","").replace(".00","").replace(/(\.[0-9])(0)/,"$1");if(a.match(/e\+1$/)||a.match(/e\+2$/)||a.match(/e\-1$/)){a=(a*1).toString()}return a}else{return b.toString()}};this.OX=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.NN(g)};this.NN=function(e,j,d){var h="";var b=0;if(e&&e.length>0){if(!j){j=this.font}for(var g=0;g<e.length;g++){if(e[g]){var k=this.DU(e[g].toString(),j,d);if(k>b){h=e[g].toString();b=k}}}}return h};this.fK=function(c,b,a){if(c==null){return""}c=c.toString();if(!c){return""}if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.Oq=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.aL=function(){var k=function(c,a){for(var f=[];a>0;f[--a]=c){}return(f.join(""))};var g=0,n,h=arguments[g++],d=[],e,b,j,l;while(h){if(e=/^[^\x25]+/.exec(h)){d.push(e[0])}else{if(e=/^\x25{2}/.exec(h)){d.push("%")}else{if(e=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gosuxX])/.exec(h)){if(((n=arguments[e[1]||g++])==null)||(n==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(e[7])&&(typeof(n)!="number")){throw ("Expecting number but found "+typeof(n))}switch(e[7]){case"b":n=n.toString(2);break;case"c":n=String.fromCharCode(n);break;case"d":n=parseInt(n);break;case"e":n=e[6]?n.toExponential(e[6]):n.toExponential();break;case"f":n=e[6]?parseFloat(n).toFixed(e[6]):parseFloat(n);break;case"g":n=e[6]?String(Number(n).toPrecision(e[6])):parseFloat(n);break;case"o":n=n.toString(8);break;case"s":n=((n=String(n))&&e[6]?n.substring(0,e[6]):n);break;case"u":n=Math.abs(n);break;case"x":n=n.toString(16);break;case"X":n=n.toString(16).toUpperCase();break}n=(/[def]/.test(e[7])&&e[2]&&n>0?"+"+n:n);j=e[3]?e[3]=="0"?"0":e[3].charAt(1):" ";l=e[5]-String(n).length;b=e[5]?k(j,l):"";d.push(e[4]?n+b:b+n)}else{throw ("Huh ?!")}}}h=h.substring(e[0].length)}return d.join("")};this.EL=function(g){var h=this;var b=(function(n,k){var l=function l(t,s){return !(t.x>=s.x+s.width||t.x+t.width<=s.x||t.y>=s.y+s.height||t.y+t.height<=s.y)};if(l(n,k)){var r=Math.max(n.x,k.x);var p=Math.min(n.x+n.width,k.x+k.width);var q=Math.max(n.y,k.y);var o=Math.min(n.y+n.height,k.y+k.height);return(p-r)*(o-q)}else{return 0}});var i=(function(o){var n=function n(s,v,u,r,t){return{x:s,y:v,width:u,height:r,location:t}};var l=o.x;var q=o.y;var p=o.width;var k=o.height;return[n(l,q,p,k,"bottom-right"),n(l-p,q,p,k,"bottom-left"),n(l-p,q-k,p,k,"top-left"),n(l,q-k,p,k,"top-right"),n(l,q-k/2,p,k,"middle-right"),n(l-p/2,q,p,k,"bottom-center"),n(l-p,q-k/2,p,k,"middle-left"),n(l-p/2,q-k,p,k,"top-center")]});var j=function j(n,l){function k(o){var q=0;for(var p=0;p<o.length;p++){q+=o[p]}return q}return k(n.map(function(p,o){return l===o?0:b(n[l],p)}))};var a=function a(){function s(u){function x(B,A){if(A==null||A>B.length){A=B.length}for(var D=0,C=new Array(A);D<A;D++){C[D]=B[D]}return C}function w(A){if(Array.isArray(A)){return x(A)}}function v(A){if(typeof Symbol!=="undefined"&&Symbol.iterator in Object(A)){return Array.from(A)}}function z(B,A){if(!B){return}if(typeof B==="string"){return x(B,A)}var C=Object.prototype.toString.call(B).slice(8,-1);if(C==="Object"&&B.constructor){C=B.constructor.name}if(C==="Map"||C==="Set"){return Array.from(B)}if(C==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(C)){return x(B,A)}}function y(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}return w(u)||v(u)||z(u)||y()}var r=function r(w,u,v){return[].concat(s(w.slice(0,u)),[v],s(w.slice(u+1)))};var t=function t(v,u){return v<u};var n=null;var k=t;var p=function p(){return 0};var o;var l=function l(v,u){return n-p(o[u],u,o)+p(v,u,r(o,u,v))};var q=function q(w,v){function u(y){var A=0;for(var z=0;z<y.length;z++){A+=y[z]}return A}if(!n){n=u(o.map(function(z,y){return p(z,y,o)}))}var x=l(w,v);if(k(x,n)){return a().locationScore(p).winningScore(k).score(x).rectangles(r(o,v,w))}else{return q}};q.rectangles=function(){if(!arguments.length){return o}o=arguments.length<=0?undefined:arguments[0];return q};q.score=function(){if(!arguments.length){return n}n=arguments.length<=0?undefined:arguments[0];return q};q.winningScore=function(){if(!arguments.length){return k}k=arguments.length<=0?undefined:arguments[0];return q};q.locationScore=function(){if(!arguments.length){return p}p=arguments.length<=0?undefined:arguments[0];return q};return q};var c=function(){var l=h.optimizeTextPositionEnforceBounds;var k=function k(p){return l?p.width*p.height-b(p,l):0};var o=function o(q,p,r){return j(r,p)+k(q)};var n=function n(q){var p=a().locationScore(o).rectangles(q);q.forEach(function(s,r){i(s).forEach(function(t,u){p=p(t,r)})});return p.rectangles()};n.bounds=function(){if(!arguments.length){return l}l=arguments.length<=0?undefined:arguments[0];return n};return n};var d=function(){var s=h.optimizeTextPositionTemperature;var l=h.optimizeTextPositionCooling;var k=h.optimizeTextPositionEnforceBounds;var o=function o(u){return u[r(u)]};var r=function r(u){return Math.floor(h.mc()*u.length)};var t=function t(u){switch(u.location){case"bottom-right":return 0;case"middle-right":case"bottom-center":return u.width*u.height/8}return u.width*u.height/4};var n=function n(u){return k?u.width*u.height-b(u,k):0};var q=function q(v,u,w){return j(w,u)+n(v)+t(v)};var p=function p(z){var u=s;var y=function y(B,A){return Math.exp((A-B)/u)>h.mc()};var x=a().locationScore(q).winningScore(y).rectangles(z);while(u>0){var w=r(z);var v=o(i(z[w]));x=x(v,w);u-=l}return x.rectangles()};p.temperature=function(){if(!arguments.length){return s}s=arguments.length<=0?undefined:arguments[0];return p};p.cooling=function(){if(!arguments.length){return l}l=arguments.length<=0?undefined:arguments[0];return p};p.bounds=function(){if(!arguments.length){return k}k=arguments.length<=0?undefined:arguments[0];return p};return p};var f=function(r){r=r||function(s){return s};function o(s,v){function u(w,z){let minValue;let min=-1;for(var x=0;x<w.length;x++){const y=w[x];if(y!=null&&(minValue===undefined?z(y,y)===0:z(y,minValue)<0)){minValue=y;min=x}}return min}const t=u(s,v);return t<0?undefined:t}var l=(function(u,t,s){var v=t[s];if(typeof v!=="function"){throw new Error("Attempt to rebind ".concat(s," which isn't a function on the source object"))}return function(){for(var w=arguments.length,x=new Array(w),y=0;y<w;y++){x[y]=arguments[y]}var z=v.apply(t,x);return z===t?u:z}});var q=function q(s){return function(t){return s.reduce(function(u,v){return u&&v(u)},t)}};var k=(function(y,s){for(var A=arguments.length,z=new Array(A>2?A-2:0),u=2;u<A;u++){z[u-2]=arguments[u]}var v=q(z);for(var w=0,x=Object.keys(s);w<x.length;w++){var t=x[w];var B=v(t);if(B){y[B]=l(y,s,t)}}return y});var n=function n(t,s){return t[o(t,s)]};var p=function p(t){t=r(t);var u=function u(){var x=t.filter(function(y){return !y.hidden});var w=x.map(function(z,y){return[z,j(x,y)]});var v=n(w,function(z,y){return y[1]-z[1]});if(v[1]>0){v[0].hidden=true}else{return"break"}};while(true){var s=u();if(s==="break"){break}}return t};k(p,r);return p};var e=function(){var k=[0,0];var l=function l(n){return n.map(function(r,q){var p=r.x;var o=r.y;if(p+r.width>k[0]){p-=r.width}if(o+r.height>k[1]){o-=r.height}return{height:r.height,width:r.width,x:p,y:o}})};l.bounds=function(){if(!arguments.length){return k}k=arguments.length<=0?undefined:arguments[0];return l};return l};return{greedy:(h.optimizeTextPositionEnforceBounds?f(c):c),annealing:(h.optimizeTextPositionEnforceBounds?f(d):d),removeOverlaps:f,boundingBox:(h.optimizeTextPositionEnforceBounds?f(e):e),data:g}}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};Date.prototype.addMilliseconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getMilliseconds()+a);return date};Date.prototype.addSeconds=function(a){let date=new Date(this.valueOf());date.setDate(date.getSeconds()+a);return date};Date.prototype.addMinutes=function(a){let date=new Date(this.valueOf());date.setDate(date.getMinutes()+a);return date};Date.prototype.addHours=function(a){let date=new Date(this.valueOf());date.setDate(date.getHours()+a);return date};Date.prototype.addDays=function(a){let date=new Date(this.valueOf());date.setDate(date.getDate()+a);return date};Date.prototype.addMonths=function(a){let date=new Date(this.valueOf());date.setMonth(date.getMonth()+a);return date};Date.prototype.addYears=function(a){let date=new Date(this.valueOf());date.setYear(date.getFullYear()+a);return date};this.xG=function(a){return a.getMilliseconds()};this.Mr=function(a){return a.getSeconds()};this.iB=function(a){return a.getMinutes()+"."+a.getSeconds()};this.Zy=function(a){return a.getMinutes()};this.mO=function(a){return a.getHours()+"."+a.getMinutes()};this.oS=function(a){return a.getHours()};this.ph=function(a){return a.getFullYear()+"."+a.getWeek()};this.jR=function(a){return(a.getMonth()+1)+"."+(a.getDay()+1)};this.j4=function(a){return a.getFullYear()+"."+(a.getMonth()+1)};this.H1=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.yq=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.JQ=function(f,w){var A,j,q,b,p,i,k,g,u,o,d,v,c,x,y,r,t,n,l,z,a,e;f=new Date(f);j=((A=f.getFullYear())+"").slice(-2);p=(i=f.getMonth()+1)<10?("0"+i):i;b=(q=["January","February","March","April","May","June","July","August","September","October","November","December"][i-1]).substring(0,3);u=(o=f.getDate())<10?("0"+o):o;g=(k=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][f.getDay()]).substring(0,3);e=(o>=10&&o<=20)?"th":((a=o%10)==1)?"st":(a==2)?"nd":(a==3)?"rd":"th";w=w.replace("#YYYY#",A).replace("#YY#",j).replace("#MMMM#",q).replace("#MMM#",b).replace("#MM#",p).replace("#M#",i).replace("#DDDD#",k).replace("#DDD#",g).replace("#DD#",u).replace("#D#",o).replace("#th#",e);x=(v=f.getHours());if(x==0){x=24}if(x>12){x-=12}c=x<10?("0"+x):x;d=v<10?("0"+v):v;z=(l=v<12?"am":"pm").toUpperCase();y=(r=f.getMinutes())<10?("0"+r):r;t=(n=f.getSeconds())<10?("0"+n):n;return w.replace("#hhhh#",d).replace("#hhh#",v).replace("#hh#",c).replace("#h#",x).replace("#mm#",y).replace("#m#",r).replace("#ss#",t).replace("#s#",n).replace("#ampm#",l).replace("#AMPM#",z)};this.gJ=function(b,a){if(b){if(this.timeFormat=="year"||b>this.times.year*2){if(b/(a||2)>=this.times.year){return"addYears"}else{return"addMonths"}}else{if(this.timeFormat=="month"||b>this.times.week){return"addDays"}else{if(b<this.times.second){return"addMilliseconds"}else{if(b<this.times.minute){return"addSeconds"}else{if(b<this.times.hour){return"addMinutes"}else{if(b<this.times.day){return"addHours"}else{return"addDays"}}}}}}}else{return"addDays"}};this.TC=function(b){var a=this.gJ(b);switch(a){case"addYears":return"year";case"addMonths":return"month";case"addDays":return"shortDate";case"addHours":return"hour";case"addMinutes":return"minute";case"addSeconds":case"addMilliseconds":return"second"}};this.H5=function(p,k,o){var b=new Date(p);var h=new Date(k);var m=h-b;var g=this.gJ(m);var a=[];var f=[];while(b<h){var l=new Date(b);l=l[g](1);b=Date.parse(l);a.push(b)}var c=Math.max(1,Math.floor(a.length/(o-1)));for(var j=0;j<a.length;j++){if(j%c==0){if(a[j]>=0){f.push(a[j])}}}var l=f[1]-f[0];f.unshift(f[0]-l);f.push(f[f.length-1]+l);return f};this.PK=function(){var h=this.S9();if(h.length){var k=Date.parse(h[0]);var a=Date.parse(h[h.length-1]);var g=a-k;var c=this.gJ(g,h.length);this.timeValues=[this.dateFormat(new Date(k)[c](-1),this.timeFormat)];this.timeValueIndices=[-1];while(k<=a){var j=new Date(k);var e=this.dateFormat(j,this.timeFormat);var b=this.uL(this.timeFormat.match(/year|hour|minute|second/)?Number(e):e);this.timeValues.push(e);this.timeValueIndices.push(b);j=j[c](1);k=Date.parse(j)}}else{return[]}};this.wz=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w.labs:this.data.y.smps;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.length;c++){e=Date.parse(h[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.S9=function(){var j=this.isGroupedData?this.data.w.labs:this.data.y.smps;var b=false;var h=[];for(var c=0;c<j.length;c++){var a=j[c];var e=this.timeFormat;switch(this.timeFormat){case"Year":case"year":a+="/01/02";e="isoDate";break;case"Month":case"month":a="2018/"+CanvasXpress.dates[a]+"/02";e="isoDate";break;case"Day":case"day":a="2018/01/"+CanvasXpress.dates[a];e="isoDate";break}if(!this.qD(a)){this.isGraphTime=false;alert("Invalid Date! Graph converted from Time Graph");return[]}var g=Date.parse(this.dateFormat(a,e));if(isNaN(g)){if(this.isExample){h=this.wz();return h}else{b=true;break}}else{h.push(new Date(g))}}h.sort(function(f,d){return f-d});return b?false:h}};CanvasXpress.prototype.initColor=function(){this.GC=function(j,e,g){var k=j;if(k){k=k.toString();k=k.replace(/\s/g,"");var b=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(k);var d=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(k);var i=(/^#?([0-9abcdef]{6})/i).exec(k);var a=(/^([0-9abcdef]{6})/i).exec(k);if(CanvasXpress.colorNames.hasOwnProperty(k)){k=this.bq(CanvasXpress.colorNames[k])}else{if(b!=null){k=b[0]}else{if(d!=null){k=d[0]}else{if(i!=null){k=this.bq(i[0])}else{if(a!=null){k=this.bq("#"+a[0])}else{if(k=="[objectCanvasGradient]"){return j}else{k=false}}}}}}}k=k&&e!=null?this.xh(k,e,true):k?k:false;return k&&g?this.rW(k):k};this.O5=function(e,b){b=(b==0)?0:(b||10);var d=this.uT(e,true);d[1]-=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.ck(e)};this.z9=function(e,b){b=(b==0)?0:(b||10);var d=this.uT(e,true);d[1]+=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";this.ck(e)};this.sw=function(a){a=a.toString();a=this.GC(a).replace("rgba(","").replace("rgb(","").replace(")","").split(",");return(a[3]&&Number(a[3])<0.5)||parseInt(a[0])*0.299+parseInt(a[1])*0.587+parseInt(a[2])*0.114>100?"#000000":"#FFFFFF"};this.P1=function(a){return this.O5(a,100)};this.Mz=function(e,b){b=(b==0)?0:(b||10);var d=this.uT(e,true);d[2]+=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";return this.ck(e)};this.PE=function(e,b){b=(b==0)?0:(b||10);var d=this.uT(e,true);d[2]-=Math.min(1,Math.max(0,b/100));e="hsl("+Math.floor(d[0]*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)";return this.ck(e)};this.lc=function(e,b){b=(b==0)?0:(b||10);var d=this.Kv(e);d[0]=Math.max(0,Math.min(255,d[0]-Math.round(255*-(b/100))));d[1]=Math.max(0,Math.min(255,d[1]-Math.round(255*-(b/100))));d[2]=Math.max(0,Math.min(255,d[2]-Math.round(255*-(b/100))));return"rgb("+d[0]+","+d[1]+","+d[2]+")"};this.d1=function(b){var a=this.uT(b,true);a[0]=(a[0]+180)%360;b="hsl("+Math.floor(a[0]*100)+","+Math.floor(a[1]*100)+"%,"+Math.floor(a[2]*100)+"%)";return this.ck(b)};this.Lt=function(e){var b=this.uT(e,true);var d=(b[0]+120)%360;var a=(b[0]+240)%360;return[e,this.ck("hsl("+Math.floor(d*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)"),this.ck("hsl("+Math.floor(a*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)")]};this.r8=function(f){var d=this.uT(f,true);var e=(d[0]+90)%360;var b=(d[0]+180)%360;var a=(d[0]+270)%360;return[f,this.ck("hsl("+Math.floor(e*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)"),this.ck("hsl("+Math.floor(b*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)"),this.ck("hsl("+Math.floor(a*100)+","+Math.floor(d[1]*100)+"%,"+Math.floor(d[2]*100)+"%)")]};this.Wr=function(g){var e=this.uT(g,true);var f=(e[0]+72)%360;var d=(e[0]+144)%360;var b=(e[0]+216)%360;var a=(e[0]+288)%360;return[g,this.ck("hsl("+Math.floor(f*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(d*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(b*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(a*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)")]};this.QE=function(h){var e=this.uT(h,true);var f=(e[0]+60)%360;var d=(e[0]+120)%360;var b=(e[0]+180)%360;var a=(e[0]+240)%360;var g=(e[0]+300)%360;return[h,this.ck("hsl("+Math.floor(f*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(d*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(b*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(a*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)"),this.ck("hsl("+Math.floor(g*100)+","+Math.floor(e[1]*100)+"%,"+Math.floor(e[2]*100)+"%)")]};this.wt=function(e){var b=this.uT(e,true);var d=(b[0]+72)%360;var a=(b[0]+216)%360;return[e,this.ck("hsl("+Math.floor(d*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)"),this.ck("hsl("+Math.floor(a*100)+","+Math.floor(b[1]*100)+"%,"+Math.floor(b[2]*100)+"%)")]};this.Rh=function(m,e){var l=[];var o=this.Kv(m);var a=Math.min(255,Math.max(0,o[0]));var k=Math.min(255,Math.max(0,o[0]));var p=Math.min(255,Math.max(0,o[0]));var h=this.Qc(a,255,a/(e+1));var d=this.Qc(k,255,k/(e+1));var q=this.Qc(p,255,p/(e+1));for(var j=0;j<h.length;j++){l.unshift("rgb("+Math.floor(h[j])+","+Math.floor(d[j])+","+Math.floor(q[j])+")")}return l};this.sj=function(j,e){j=this.rW(this.GC(j)).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.bq(j.toString(16))};this.rW=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{if(b&&b.match(/^rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}}};this.uT=function(n,c){var j=this.Kv(n);var a=j[0]/255;var k=j[1]/255;var o=j[2]/255;var p=Math.max(a,k,o);var f=Math.min(a,k,o);var i,q;var e=(p+f)/2;if(p==f){i=0;q=0}else{var m=p-f;q=e>0.5?m/(2-p-f):m/(p+f);switch(p){case a:i=(k-o)/m+(k<o?6:0);break;case k:i=(o-a)/m+2;break;case o:i=(a-k)/m+4;break}i/=6}if(c){return[i,q,e]}else{return"hsl("+Math.floor(i*100)+","+Math.floor(q*100)+"%,"+Math.floor(e*100)+"%)"}};this.oL=function(j,e){var d=this.GC(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rW(d):d}else{return j}};this.bq=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.ck=function(n){var j=n.split(",");var i=Number(j[0].replace(/\s/g,"").replace("hsl(",""))/100;var o=Number(j[1].replace(/\s/g,"").replace("%",""))/100;var f=Number(j[2].replace(/\s/g,"").replace("%)",""))/100;if(o==0){return"rgb("+f+","+f+","+f+")"}else{var e=function(h,g,b){if(b<0){b+=1}if(b>1){b-=1}if(b<1/6){return h+(g-h)*6*b}if(b<1/2){return g}if(b<2/3){return h+(g-h)*(2/3-b)*6}return h};var c=f<0.5?f*(1+o):f+o-f*o;var d=2*f-c;var a=Math.round(e(d,c,i+1/3)*255);var k=Math.round(e(d,c,i)*255);var m=Math.round(e(d,c,i-1/3)*255);return"rgb("+a+","+k+","+m+")"}};this.xh=function(i,d,b,h,e){if(i){if(i instanceof CanvasGradient){return i}if(e){i=this.kK(i,b)}var a=i.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){i=this.GC(i);a=i&&i.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}var g=d!=null&&!a[2]?Math.min(Number(d),1):a&&a[2]!=null?Math.min(Number(a[2]),1):1;return h?"rgba("+a[1]+",0)":a?"rgba("+a[1]+","+g+")":false}else{return false}};this.kK=function(d,b){if(d){if(d instanceof CanvasGradient){return d}var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);if(!a||!b){d=this.GC(d);a=d&&d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i)}return a?"rgb("+a[1]+")":false}else{return false}};this.JW=function(d,b){if(!b){d=this.GC(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?null:a[2]!=null?Number(a[2]):null}};this.Kc=function(e,b){if(!b){e=this.GC(e)}var d;if(e&&e.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return !a?false:a[2]!=null&&a[2]==0?true:false}else{return false}}};this.QX=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.GC(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.Du(e));var h=parseInt(this.Du(d));var m=parseInt(this.Du(n));if(k.length>0){var o=parseFloat(this.Du(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.Kv=function(f){f=this.GC(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.Nm=function(f,d){var b=this.Kv(f);var e=Math.ceil(0.3*b[0]+0.59*b[1]+0.11*b[2]);if(d!=null){return"rgba("+e+","+e+","+e+","+d+")"}else{return"rgb("+e+","+e+","+e+")"}};this.ny=function(S,I){var q=this.Kv(this.GC(S,I));var J=q[0];var Q=q[1];var T=q[2];var x=[0.7465,0.2535,1.273463,-0.073894];var A=[1.4,-0.04,0.968437,0.003331];var u=[1.748,0,0.062921,0.292119];if(J==0&&Q==0&&T==0){return"rgb(0,0,0)"}var l;switch(this.blindnessType){case"protanopia":l=x;break;case"deuteranopia":l=A;break;case"tritanopia":l=u;break;case"monochromatic":var S=Math.ceil((J*0.212656+J*0.715158+J*0.072186));return"rgb("+S+","+S+","+S+")"}var F=l[0];var D=l[1];var K=l[2];var z=l[3];var n=1;var y=Math.pow(J,2.2);var B=Math.pow(Q,2.2);var C=Math.pow(T,2.2);var i=y*0.412424+B*0.357579+C*0.180464;var h=y*0.212656+B*0.715158+C*0.072185;var f=y*0.019332+B*0.119193+C*0.950444;var k=i/(i+h+f);var j=h/(i+h+f);var w=(j-D)/(k-F);var L=j-k*w;var e=(z-L)/(w-K);var a=(w*e)+L;i=e*h/a;f=(1-(e+a))*h/a;var O=0.312713*h/0.329016;var M=0.358271*h/0.329016;var G=O-i;var E=M-f;var H=G*3.24071+E*-0.498571;var N=G*-0.969258+E*0.0415557;var R=G*0.0556352+E*1.05707;var d=i*3.24071+h*-1.53726+f*-0.498571;var o=i*-0.969258+h*1.87599+f*0.0415557;var s=i*0.0556352+h*-0.203996+f*1.05707;var U=((H<0?0:1)-d)/H;var m=((N<0?0:1)-o)/N;var p=((R<0?0:1)-s)/R;var P=[(U>1||U<0)?0:U,(m>1||m<0)?0:m,(p>1||m<0)?0:p];P=Math.max.apply(null,P);d=d+(P*H);o=o+(P*N);s=s+(P*R);d=Math.pow(d,1/2.2);o=Math.pow(o,1/2.2);s=Math.pow(s,1/2.2);J=Math.ceil(d);Q=Math.ceil(o);T=Math.ceil(s);if(J>255){J-=255}if(Q>255){Q-=255}if(T>255){T-=255}return"rgb("+J+","+Q+","+J+")"};this.ss=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.hd=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.OS=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.z7=function(f,e,d,c,b,a){if(this.gradientType=="radial"){return this.g1(f,e,d,b,a,true)}else{return this.S4(f,e,d,c,b,a,true)}};this.S4=function(d,o,a,m,j,l,k){if(!k){this.ah()}var p=this.rU();var h=p.createLinearGradient(d,o,a,m);if(!j){j=this.colorSpectrum}else{if(this.GC(j)&&(!this.pe(j)||j.length<2)){j=[j,"rgb(0,0,0)"]}}if(!l||!this.pe(l)){l=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var q=1/(j.length-1);var e=q;for(var f=0;f<j.length;f++){j[f]=this.GC(j[f])}h.addColorStop(l[0]||0,this.transparency!=null?this.xh(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(l[f]||e,this.transparency!=null?this.xh(j[0]):j[f]);e+=q}return h};this.g1=function(p,k,a,j,m,l){if(!l){this.ah()}var q=this.rU();var d=a/5.5;var h=q.createRadialGradient(p-d,k-d,1,p,k,a);if(!j){j=this.colorSpectrum}else{if(this.GC(j)&&(!this.pe(j)||j.length<2)){j=[j,"rgb(0,0,0)"]}}if(!m||!this.pe(m)){m=this.graphType=="Heatmap"?[]:this.colorSpectrumBreaks}var t=1/(j.length-1);var e=t;h.addColorStop(m[0]||0,this.transparency!=null?this.xh(j[0]):j[0]);for(var f=1;f<j.length;f++){h.addColorStop(m[f]||e,this.transparency!=null?this.xh(j[0]):j[f]);e+=t}return h};this.YP=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.Xt(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.Xt(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.Xt=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.gl(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.gl=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.lj=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.oi(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.oi=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.od=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.Dm=function(){return this.pa(CanvasXpress.colorNames)};this.ms=function(){return this.pa(CanvasXpress.colorSchemes)};this.Y4=function(b){var c=/^#?[0-9a-fA-F]{6}$/i;var a=/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/;if(c.test(b)){return b.substring(b.length-6,b.length)}else{if(a.test(b)){return this.rW(b)}else{var d=b.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(d)){return CanvasXpress.colorNames[d]}else{throw new Error(b+" is not a valid color.")}}}};this.Wk=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.Wy=function(a,d){var g=this;var c=function(l){var j=function(t,q){var n=a.grads[l];var s=n.min;var z=n.max;var p=n.scol.replace("#","").substring(t,q);var A=n.ecol.replace("#","").substring(t,q);var w=d<s?s:d>z?z:d;var i=z-s;var x=parseInt(p,16);var m=parseInt(A,16);var u=(m-x)/i;if(isNaN(u)){u=0}var o=Math.round(u*(w-s)+x);var y=o.toString(16);return y.length==1?"0"+y:y};var k=j(0,2);var h=j(2,4);var b=j(4,6);return g.bq("#"+k+h+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{for(var e=0;e<a.grads.length;e++){if(a.grads[e].min<=d&&a.grads[e].max>d){return c(e)}}var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return isNaN(e)?"rgba(0,0,0,0)":c(e)}};this.No=function(L,C,F,g,f,c){var h=L||this.colorSpectrum;var B=this.graphType=="Genome";if(C!=null&&F!=null&&C==F){F+=0.1}var G=C!=null&&f&&f.length?Math.min(C,f[0]):C!=null?C:this.minData!=null?this.minData:0;var o=F!=null&&f&&f.length?Math.max(F,f[f.length-1]):F!=null?F:this.maxData!=null?this.maxData:100;var J=!B&&!c&&this.setMinX!=null?this.setMinX:null;var w=!B&&!c&&this.setMaxX!=null?this.setMaxX:null;var D,t;var M=[];if(g==null){zero=(G+o)/2}else{zero=g;var D=g-G;var t=o-g;if(D>t){o=g+D}else{G=g-t}}var q=this[this.axisAlgorithm](Math.min(J||G,w||o),Math.max(J||G,w||o),5,this.isGraphTime,this.axisWilkinsonLoose);if(o==Math.abs(G)&&g==0&&q.length%2){q[Math.floor(q.length/2)]=0}var H=(q[q.length-1]-q[0])/(h.length-1);var a=this.Pi(q[1]-q[0]);var d=[];for(var E=0;E<q.length;E++){d[E]=q[E].toFixed(a)}var e=this.NN(d);var I=this.DU(e.toString(),this.font);var m=q[q.length-1]-q[0];var u=[];if(f&&f.length>1&&f.length==h.length){for(var E=0;E<f.length;E++){f[E]=Number(f[E]);u.push(this.qo(f[E].toString()))}e=this.NN(u);I=this.DU(e.toString(),this.font);f=f.sort(function(l,i){return l-i});var x=f[0];var A=Math.ceil(100/h.length)+1;for(var E=1;E<f.length;E++){var k=f[E];var K=this.Qc(x,k,false,A);x=K.pop();M=M.concat(K)}M.push(x);this.colorSpectrumNumber=M.length}else{M=this.Qc(q[0],q[q.length-1],false,this.colorSpectrumNumber)}var j={spectrum:h,stops:f,z:g,colors:[],smooth:[],grads:[],rmin:G,rmax:o,min:(f&&f.length>1?f[0]:q[0]),max:(f&&f.length>1?f[f.length-1]:q[q.length-1]),range:m,zero:zero,vals:q,valStr:d,incr:H,decs:a,breaks:M,maxLevLen:I,maxLevChr:e.toString().length,maxLevStr:e};for(var E=0;E<h.length-1;E++){var y={scol:this.Y4(h[E]),ecol:this.Y4(h[E+1]),min:(f&&f.length>1?f[E]:q[0]+(H*E)),max:(f&&f.length>1?f[E+1]:q[0]+(H*(E+1)))};j.grads.push(y)}for(var E=0;E<this.colorSpectrumNumber;E++){v=this.Wy(j,M[E]);j.colors.push(v)}return j};this.PF=function(d,e){this.FX();if(!this.meta.def.colorBrew||d){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.No(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.No(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var b=this.meta.def.colorBrew;if(e){if(this.isTransformedData){var c=this.isHistogram?0.000001:this.minData;var a=this.maxData;switch(this.isTransformedData){case"log2":c=Math.log(c)/Math.LN2;a=Math.log(a)/Math.LN2;break;case"log10":c=Math.log(c)/Math.LN10;a=Math.log(a)/Math.LN10;break;case"exp2":c=Math.pow(2,c);a=Math.pow(2,a);break;case"exp10":c=Math.pow(10,c);a=Math.pow(10,a);break}if(!this.a0(c,true)||!this.a0(a,true)){c=this.K9(this.data.y.trans);a=this.Gy(this.data.y.trans)}this.meta.def.colorBrew=this.No(this.colorSpectrum,c,a,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{this.meta.def.colorBrew=this.No(this.colorSpectrum,this.minData||b.rmin,this.maxData||b.rmax,this.colorSpectrumZeroValue||b.z,this.colorSpectrumBreaks||b.stops)}}else{this.meta.def.colorBrew=this.No(this.colorSpectrum,b.rmin,b.rmax,b.z,b.stops)}}}}};this.cr=function(b,m,j){if(!b){b=8}if(!m||!CanvasXpress.colorSchemes.hasOwnProperty(m)){m=this.colorScheme}var k=this.NU(CanvasXpress.colorSchemes[m]);k.sort(function(d,c){return d-c});if(CanvasXpress.colorSchemes[m]){if(CanvasXpress.colorSchemes[m][b]){return CanvasXpress.colorSchemes[m][b]}else{if(k[k.length-1]==256){var g=this.Ir(b);var a=[];for(var e=0;e<b;e++){var l=Math.max(0,Math.min(255,Math.floor(g[e]*256)));a.push(CanvasXpress.colorSchemes[m][256][l])}return a}else{if(b>k[k.length-1]){if(j){b--;while(!CanvasXpress.colorSchemes[m][b]){b--}return this.ZD(CanvasXpress.colorSchemes[m][b])}else{var h=b-k.length;b--;while(!CanvasXpress.colorSchemes[m][b]){b--}var a=this.ZD(CanvasXpress.colorSchemes[m][b]);for(var e=0;e<h;e++){a.push(CanvasXpress.colorSchemes[m][b][e%CanvasXpress.colorSchemes[m][b].length])}}return a}else{b++;while(!CanvasXpress.colorSchemes[m][b]){b++}return CanvasXpress.colorSchemes[m][b]}}}}else{return this.colors}};this.FX=function(){if(this.blindnessType&&!this.meta.def.colorSpectrum){this.meta.def.colorSpectrum=this.ZD(this.colorSpectrum);var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.ny(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{if(this.meta.def.colorSpectrum&&this.meta.def.blindnessTypeSpectrum!=this.blindnessType){if(this.blindnessType){var b=[];for(var a=0;a<this.colorSpectrum.length;a++){b.push(this.ny(this.colorSpectrum[a]))}this.colorSpectrum=b;delete this.meta.def.colorBrew}else{this.colorSpectrum=this.ZD(this.meta.def.colorSpectrum)}}}this.meta.def.blindnessTypeSpectrum=this.blindnessType};this.s5=function(l,e){var f=this;var a=false;var j;var c=function(p){if(f.data[p]){if(f.colorBy){return f.data[p].hasOwnProperty(f.colorBy)&&f.meta.data[p][f.colorBy].colors?f.meta.data[p][f.colorBy].colors.length:f.data.y.smps.length}else{var o=f.data.y.smps.length;for(var n in f.meta.data[p]){if(f.meta.data[p][n].levels){o=Math.max(o,f.meta.data[p][n].levels.length)}}return o}}return f.data.y.smps.length};if(this.colorScheme=="User"){j=this.ZD(this.colors)}else{if(this.colorScheme=="ColorSpectrum"){var k=this.colorSpectrumNumber;this.colorSpectrumNumber=this.graphType=="Circular"?Math.max(this.data.y.vars.length,this.data.y.smps.length):this.data.y.vars.length;var m=this.No(this.colorSpectrum,0,this.data.y.vars.length);j=m.colors;this.colorSpectrumNumber=k}else{if(CanvasXpress.colorSchemes[this.colorScheme]){var b;var h=this.NU(CanvasXpress.colorSchemes[this.colorScheme]);h.sort(function(n,i){return n-i});h=parseInt(h[h.length-1]);if(l&&l.type=="String"){b=l.levels.length}else{if(this.graphType.match(/Scatter/)){if(this.layoutValid){b=c("z")}else{if(this.colorBy&&this.meta.data.hasOwnProperty("z")&&this.meta.data.z.hasOwnProperty(this.colorBy)&&this.meta.data.z[this.colorBy].colors){b=this.meta.data.z[this.colorBy].levels.length}else{b=this.data.y.smps.length}}}else{if(this.graphType.match(/Treemap|TagCloud|Sankey|Tree|Circular/)){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/Venn/)){b=this.vennGroups}else{if(this.graphType.match(/Pie/)){b=this.data.y.vars.length}else{if(this.graphType.match(/Network|Genome|Correlation/)){b=h}else{if(this.graphType=="ParallelCoordinates"){b=this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)&&this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.data.y.smps.length}else{if(this.graphType.match(/BarLine|DotLine/)&&this.coordinateLineColor&&(!this.isGroupedData||!this.colorBy)){b=Math.max(this.xAxis.length,this.xAxis2.length)}else{if(this.colorBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorBy)){b=this.meta.data.x[this.colorBy].colors?this.meta.data.x[this.colorBy].colors.length:this.meta.data.x[this.colorBy].levels?this.meta.data.x[this.colorBy].levels.length:this.data.y.vars.length}else{b=this.data.y.vars.length}}}}}}}}}if(CanvasXpress.colorSchemes[this.colorScheme][b]){j=CanvasXpress.colorSchemes[this.colorScheme][b]}else{if(b>h){b--;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b--}}else{b++;while(!CanvasXpress.colorSchemes[this.colorScheme][b]){b++}}j=CanvasXpress.colorSchemes[this.colorScheme][b]}if(this.meta.def.colors){this.meta.def.colors=this.ZD(j);a=true}}else{j=CanvasXpress.colorSchemes.Balanced[20]}}}if((this.blindnessType&&!this.meta.def.colors)||a){this.meta.def.colors=this.ZD(j);if(this.blindnessType){var g=[];for(var d=0;d<j.length;d++){g.push(this.ny(j[d]))}j=g}}else{if(this.meta.def.colors&&this.meta.def.blindnessTypeColors!=this.blindnessType){j=this.ZD(this.meta.def.colors);if(this.blindnessType){var g=[];for(var d=0;d<j.length;d++){g.push(this.ny(j[d]))}j=g}}}this.meta.def.blindnessTypeColors=this.blindnessType;for(var d=0;d<j.length;d++){j[d]=this.GC(j[d])}if(!l){this.colors=j}this.ut(j,l)};this.CZ=function(){var b=[];for(var c=0;c<this.colors.length;c++){b.push(this.GC(this.colors[c]))}if(b.length>0){this.colors=b}var a=[];for(var c=0;c<this.colorSpectrum.length;c++){a.push(this.GC(this.colorSpectrum[c]))}if(a.length>0){this.colorSpectrum=a}}};CanvasXpress.prototype.initAttributes=function(){this.n8=function(c,b,d,a){if(!a){a=this.rU()}if(this.transparency!=null){c=this.xh(c,this.transparency,true)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.S3(true,a)};this.Ei=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left-1;d=this.marginTop+this.offsetY+this.top-1;a=this.x+2;e=this.y+2}return[b,d,a,e]};this.TO=function(a,e,i){if(this.graphType=="Tree"){return}if(!e){e=this.rU()}this.ah(e);var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}e.rect(d,f,c,g);e.clip();this.meta.state.clip=[d,f,c,g];if(i){this.skipSaveRestore()}};this.ZO=function(a,b){if(this.graphType=="Tree"){return}this.eh(a);this.TO([0,0,0,0],a);this.eh(a);this.meta.state.clip=false;if(b){this.skipSaveRestore()}};this.Ae=function(a){this.S3(false,a)};this.S3=function(c,a){if(this.showShadow){if(!a){a=this.rU()}var b="rgba(255,255,255,0)";if(c){a.shadowOffsetX=this.shadowOffsetX;a.shadowOffsetY=this.shadowOffsetY;a.shadowBlur=this.shadowBlur;a.shadowColor=this.shadowColor}else{a.shadowOffsetX=0;a.shadowOffsetY=0;a.shadowBlur=0;a.shadowColor=this.background;a.strokeStyle="rgba(255,255,255,0)";a.fillStyle="rgba(255,255,255,0)"}}};this.yr=function(c,h,b,g,i){if(this.graphType=="Network"){return this.gW(c,h,b,g,i)}var f=~~(c+0.5);var a=~~(h+0.5);var d=~~(b+0.5);var j=~~(g+0.5);if(Math.abs(f-d)==1){f=(f+d)/2;d=f}else{f+=0.5;d+=0.5}if(Math.abs(a-j)==1){a=(a+j)/2;j=a}else{a+=0.5;j+=0.5}if(!i){i=this.rU()}if(f==d&&a==j){var e=this.lineThickness/1.5;i.fillRect(f,a,e,e)}else{i.moveTo(f,a);i.lineTo(d,j)}i.stroke()};this.gW=function(c,e,b,d,a){if(!a){a=this.rU()}a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.lg=function(c,e,b,d,a){if(c==b){c=(((c+0.5)<<1)>>1)+0.5;b=c}else{if(e==d){e=(((e+0.5)<<1)>>1)+0.5;d=e}}if(!a){a=this.rU()}a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.us=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.zy=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.RW=function(n,l,h){var k,j,d,m;if(!l){l=this.Ei();l[2]+=l[0];l[3]+=l[1]}if(!h){h=[]}var g=n.length;var e=this.us(n[0],l);var c=[];for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.us(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){h.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.zy(k,j,e,l);e=this.us(k,l)}else{j=this.zy(k,j,d,l);d=this.us(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.Lg=function(k,j,c){var h,d,g,a,e;if(!j){j=this.Ei();j[2]+=j[0];j[3]+=j[1]}if(c){xy=[];for(var f=1;f<k.length;f+=2){xy.push([k[f],k[f+1]])}}else{xy=k}for(var b=1;b<=8;b*=2){h=[];d=xy[xy.length-1];g=!(this.us(d,j)&b);for(var f=0;f<xy.length;f++){a=xy[f];e=!(this.us(a,j)&b);if(e!==g){h.push(this.zy(d,a,b,j))}if(e){h.push(a)}d=a;g=e}xy=h;if(!xy.length){break}}if(c){k=["poly"];for(var f=0;f<h.length;f++){k.push(h[f][0]);k.push(h[f][1])}return k}return h};this.sM=function(e,l,d,j,b,h,m,g){if((e===d&&l===j)||(b===m&&h===g)){return false}var f=((g-h)*(d-e)-(m-b)*(j-l));if(f===0){return false}var c=((m-b)*(l-h)-(g-h)*(e-b))/f;var a=((d-e)*(l-h)-(j-l)*(e-b))/f;if(c<0||c>1||a<0||a>1){return false}var k=e+c*(d-e);var i=l+c*(j-l);return[k,i]};this.B7=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.Ei()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"arrow":case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":d=this.p1(f[0]-(f[2]/2));p=this.p1(f[1]-(f[3]/2));c=this.p1(d+f[2]);n=this.p1(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"pentagon":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.st=function(T,F,a,D,al,af,S,X,H,g,ai,aj,V,Y,Z,G){var ab=this.graphType=="Network"?this.lineWidthEvent:this.lineWidthEvent*4;var W=[];var M=["poly"];var U,ah,ag,J;if(this.pe(H)){U=H[0];ah=H[1]}else{U=H;ah=H}if(this.pe(g)){ag=g[0];J=g[1]}else{ag=g;J=g}if(!this.a0(ag,true)){ag=0}if(!this.a0(U,true)){U=0}if(!this.a0(J,true)){J=0}if(!this.a0(ah,true)){ah=0}T=this.T5(T,F,a,D,al,U,ag);if(T.match(/error/)){if(this.showErrorBars&&this.mT([F,a,D,al,S])){F=Math.ceil(F);D=Math.ceil(D);a=Math.ceil(a);al=Math.ceil(al);S=Math.ceil(S);var O=S/2;if(S>0){M=["poly",F,a-ab,D-ab,al-ab,D-ab,al-O,D+ab,al-O,D+ab,al+O,D-ab,al+O,D-ab,al+ab,F,a+ab]}else{M=["poly",D-ab,al+ab,D-O,al+ab,D-O,al-ab,D+O,al-ab,D+O,al+ab,D+ab,al+ab,F+ab,a,F-ab,a]}}else{return false}}else{if(T=="spline"||T=="cardinalSpline"){if(F.length<3){return F.length<2?false:this.st("line",F[0],a[0],F[1],a[1],af,S,X,U,ag,ai,aj,V,Y,Z)}for(var ae=0;ae<F.length;ae++){M.push(F[ae],a[ae]-ab);W.push(a[ae]+ab,F[ae])}M=M.concat(W.reverse())}else{if(T=="arch"){if(F.length!=3||a.length!=3){return false}for(var ae=0;ae<F.length;ae++){if(!this.mT([F[ae],a[ae]])){return false}}W=this.Ys(F[0],a[0],F[1],a[1],F[2],a[2],0.25,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.Ys(F[0],a[0],F[1],a[1],F[2],a[2],0.25);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T=="arc"){M=["poly"];W=this.TX(F,a,D,U,ag,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.TX(F,a,D-ab,U,ag);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T=="quadratic"){var y=this.eH(F,a,D,al,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(V))*(V>0?-1:1));var E=this.GP(F,a,D,al,U,ag,T,V);var z=this.th(E[0],E[1],y[0],y[1],ab);var x=this.th(y[0],y[1],E[2],E[3],ab);W=this.Ys(z[0],z[1],z[4],z[5],x[4],x[5],0.1,true);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}var Q=[];W=this.Ys(z[2],z[3],z[6],z[7],x[6],x[7],0.1,true);for(var ae=0;ae<W.length;ae++){Q.push(W[ae][1],W[ae][0])}M=M.concat(Q.reverse())}else{if(T=="roundLine"){M=["poly",F-ab,a,F-ab,al+ab,D,al+ab,D,al-ab,F+ab,al-ab,F+ab,a]}else{if(this.mT([F,a,D,al])){var K=this.GP(F,a,D,al,U,ag,T);F=K[0];a=K[1];D=K[2];al=K[3];if(ai){K=this.B7("line",[F,a,D,al],aj);if(K){F=K[0];a=K[1];D=K[2];al=K[3]}else{return false}}if(V&&this.pe(V)&&V.length>0){if(this.ZL(V)){if(T.match(/bezier/i)){if(V[0].length==6){var ak=[V[0][0],V[0][1]];for(var ae=0;ae<V.length;ae++){ak=ak.concat(V[ae])}ak.push(V[V.length-1][0],V[V.length-1][1]);var h=this.ZD(ak);for(var ae=0;ae<V.length;ae++){W=this.Uv(h[0],h[1]-ab,h[2],h[3]-ab,h[4],h[5]-ab,h[6],h[7]-ab,0.1,true);for(var ad=0;ad<W.length;ad++){M.push(W[ad][0],W[ad][1])}for(var ad=0;ad<6;ad++){h.shift()}}h=this.ZD(ak);var Q=[];for(var ae=0;ae<V.length;ae++){W=this.Uv(h[0],h[1]+ab,h[2],h[3]+ab,h[4],h[5]+ab,h[6],h[7]+ab,0.1,true);for(var ad=0;ad<W.length;ad++){Q.push(W[ad][1],W[ad][0])}for(var ad=0;ad<6;ad++){h.shift()}}M=M.concat(Q.reverse())}else{if(V.length==4){var z=this.th(V[0][0],V[0][1],V[1][0],V[1][1],ab);var x=this.th(V[2][0],V[2][1],V[3][0],V[3][1],ab);W=this.Uv(z[0],z[1],z[4],z[5],x[0],x[1],x[4],x[5],0.1,true);for(var ad=0;ad<W.length;ad++){M.push(W[ad][0],W[ad][1])}W=this.Uv(z[2],z[3],z[6],z[7],x[2],x[3],x[6],x[7],0.1,true);var Q=[];for(var ad=0;ad<W.length;ad++){Q.push(W[ad][1],W[ad][0])}M=M.concat(Q.reverse())}else{var C=this.th(V[0][0],V[0][1],V[V.length-1][0],V[V.length-1][1],ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}else{if(V.length>2){M=["poly"];var P=[];for(var ae=0;ae<V.length-1;ae++){P.push([V[ae][0],V[ae][1]])}for(var ae=V.length-1;ae>=1;ae--){P.push([V[ae][0],V[ae][1]])}W=this.CI(P,ab,1);for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{var C=this.th(V[0][0],V[0][1],V[1][0],V[1][1],ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}else{return false}}else{if(T.match(/curved/i)){var B=F==D&&a==al&&G;var u=this.Ma(F,a,D,al);var R=this.HA(F,a,u[0],u[1]);var N=(U||0)/R;var I=(ag||0)/R;var A=T.match(/curvedcc/i)&&F>D?false:!T.match(/curvedcc/i)&&D>=F?true:false;var r=D>=F?Math.asin((u[1]-a)/R):Math.asin(-(u[1]-a)/R);var ac=r+Math.PI;var o=[];var d=0;var aa=false;if(B){if(r<0){r+=Math.PI*2}var v=G.size;var L=G.size*0.5;switch(G.pos){case"top":o=[F,a-v,L,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":o=[F+v,a-v,L,Math.PI,Math.PI*0.5,false];break;case"right":o=[F+v,a,L,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":o=[F+v,a+v,L,Math.PI*1.5,Math.PI,false];break;case"bottom":o=[F,a+v,L,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":o=[F-v,a+v,L,0,Math.PI*1.5,false];break;case"left":o=[F-v,a,L,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":o=[F-v,a-v,L,Math.PI*0.5,0,false];break}d=0.25}else{if(D>=F){o=[u[0],u[1],Math.max(0,R),r-I,ac+N,A]}else{aa=true;o=[u[0],u[1],Math.max(0,R),ac-I,r+N,!A]}}M=["poly"];W=this.sZ(o[0],o[1],o[2]+ab,(aa?o[4]-(Math.PI*2):o[3]),(aa?o[3]:o[4]),o[5]*(aa?-1:1));for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}W=this.sZ(o[0],o[1],o[2]-ab,(aa?o[4]-(Math.PI*2):o[3]),(aa?o[3]:o[4]),o[5]*(aa?1:-1));for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(T.match(/bezier/i)){var l=(F+D)/2;var k=(a+al)/2;if(T.match(/beziery/i)){W=this.Uv(F,a-ab,F,k-ab,D,k-ab,D,al-ab,0.25,true)}else{W=this.Uv(F,a-ab,l,a-ab,l,al-ab,D,al-ab,0.25,true)}for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}if(T.match(/beziery/i)){W=this.Uv(F,a+ab,F,k+ab,D,k+ab,D,al+ab,0.25)}else{W=this.Uv(F,a+ab,l,a+ab,l,al+ab,D,al+ab,0.25)}for(var ae=0;ae<W.length;ae++){M.push(W[ae][0],W[ae][1])}}else{if(F==D&&a!=al){M=["poly",F-ab,a,F+ab,a,D+ab,al,D-ab,al]}else{if(a==al&&F!=D){M=["poly",F,a-ab,D,a-ab,D,al+ab,F,al+ab]}else{var C=this.th(F,a,D,al,ab);M=["poly",C[0],C[1],C[2],C[3],C[6],C[7],C[4],C[5]]}}}}}}else{return false}}}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?M:this.yd(M)}else{return M}};this.mh=function(c,a){if(!a){a=this.rU()}if(!c){c="solid"}var b=[];this.tempCap=a.lineCap;if(c.match(/blank/i)){b=CanvasXpress.R.lty[0]}else{if(c.match(/solid/i)){b=CanvasXpress.R.lty[1]}else{if(c.match(/dashed/i)){b=CanvasXpress.R.lty[2];b=[this.dashLength,this.dashLength-2]}else{if(c.match(/dotted/i)){b=CanvasXpress.R.lty[3];b=[this.dotLength,this.dotLength+2]}else{if(c.match(/dotdash/i)){b=CanvasXpress.R.lty[4]}else{if(c.match(/longdash/i)){b=CanvasXpress.R.lty[5]}else{if(c.match(/twodash/i)){b=CanvasXpress.R.lty[6]}}}}}}}a.setLineDash(b)};this.SC=function(a){if(!a){a=this.rU()}a.lineCap=this.tempCap;a.setLineDash([])};this.T5=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.I1=function(U,E,a,C,an,af,T,Y,I,g,aj,al,X,Z,ab,F,R,G){if(!G){G=this.rU()}this.mh(U,G);var W,ai,ah,L;if(this.pe(I)){W=I[0];ai=I[1]}else{W=I;ai=I}if(this.pe(g)){ah=g[0];L=g[1]}else{ah=g;L=g}if(!this.a0(ah,true)){ah=0}if(!this.a0(W,true)){W=0}if(!this.a0(L,true)){L=0}if(!this.a0(ai,true)){ai=0}U=this.T5(U,E,a,C,an,W,ah);var k=false;var H=function(b){switch(b){case"arrow":k=0;break;case"square":k=1;break;case"round":k=2;break;case"roundDocked":k=false;break}};if(!U){U="solid"}if(U.match(/error/)){if(this.showErrorBars&&this.mT([E,a,C,an,T])){E=Math.ceil(E);C=Math.ceil(C);a=Math.ceil(a);an=Math.ceil(an);T=Math.ceil(T);var Q=T/2;this.n8(af,false,Y,G);if(!this.Kc(af,true)){G.beginPath();this.yr(E,a,C,an,G);if(Math.abs(T)>this.errorBarsWidth){if(T>0){this.yr(C,an-Q,C,an+Q,G)}else{this.yr(C-Q,an,C+Q,an,G)}}}}this.Ae(G)}else{if(U.match(/spline|cardinalSpline/i)){if(E.length<3){return E.length<2?false:this.I1(U.match(/dashedSpline/i)?"dashedLine":"line",E[0],a[0],E[1],a[1],af,T,Y,I,g,aj,al,X,Z,ab,false,false,G)}var V=[];var ak=[];var ag=0;for(var ae=0;ae<E.length;ae++){if(this.mT([E[ae],a[ae]])){ak.push(E[ae],a[ae]);ag+=2}else{return}}this.n8(af,T,Y,G);if(!this.Kc(af,true)){if(U.match(/spline/i)){for(var ae=0;ae<ag-4;ae+=2){V=V.concat(this.UJ(ak[ae],ak[ae+1],ak[ae+2],ak[ae+3],ak[ae+4],ak[ae+5]))}G.beginPath();G.moveTo(ak[0],ak[1]);G.quadraticCurveTo(V[0],V[1],ak[2],ak[3]);for(var ae=2;ae<ag-5;ae+=2){G.bezierCurveTo(V[2*ae-2],V[2*ae-1],V[2*ae],V[2*ae+1],ak[ae+2],ak[ae+3])}G.moveTo(ak[ag-2],ak[ag-1]);G.quadraticCurveTo(V[2*ag-10],V[2*ag-9],ak[ag-4],ak[ag-3]);G.stroke()}else{ak=this.Jz(ak);G.beginPath();G.moveTo(ak[0],ak[1]);for(var ae=2;ae<ak.length-1;ae+=2){G.lineTo(ak[ae],ak[ae+1])}G.stroke()}}this.Ae(G)}else{if(U.match(/arch/)){if(E.length!=3||a.length!=3){return false}for(var ae=0;ae<E.length;ae++){if(!this.mT([E[ae],a[ae]])){return false}}this.n8(af,T,Y,G);if(!this.Kc(af,true)){G.beginPath();G.moveTo(E[0],a[0]);G.quadraticCurveTo(E[1],a[1],E[2],a[2]);G.stroke()}this.Ae(G);if(ab){H(ab);this.e0(E[1],a[1],E[2],a[2],af,T,k,false,G)}if(Z){H(Z);this.e0(E[0],a[0],E[1],a[1],af,T,k,true,G)}}else{if(U=="arc"){this.n8(af,T,Y,G);G.beginPath();G.arc(E,a,Math.max(0,C),ai,L,false);G.stroke();this.Ae(G)}else{if(U=="quadratic"){this.n8(af,T,Y,G);var y=this.eH(E,a,C,an,false,Math.min(1,this.arrowQuadraticFactor*Math.abs(X))*(X>0?-1:1));var D=this.GP(E,a,C,an,ai,L,U,X);var am=this.Ys(D[0],D[1],y[0],y[1],D[2],D[3],0.1,true);G.beginPath();G.moveTo(D[0],D[1]);G.quadraticCurveTo(y[0],y[1],D[2],D[3]);G.stroke();this.Ae(G);if(ab){E=am[9][0];a=am[9][1];C=D[2];an=D[3];H(ab);this.e0(E,a,C,an,af,T,k,false,G)}if(Z){E=am[1][0];a=am[1][1];C=D[0];an=D[1];H(Z);this.e0(E,a,C,an,af,T,k,true,G)}}else{if(U=="roundLine"){this.n8(af,T,Y,G);G.beginPath();G.moveTo(E,a);if(a>an){G.lineTo(E,an+this.roundedPolygonRadius);if(E>C){G.quadraticCurveTo(E,an,E+this.roundedPolygonRadius,an)}else{G.quadraticCurveTo(E,an,E-this.roundedPolygonRadius,an)}}else{G.lineTo(E,an-this.roundedPolygonRadius);if(E>C){G.quadraticCurveTo(E,an,E-this.roundedPolygonRadius,an)}else{G.quadraticCurveTo(E,an,E+this.roundedPolygonRadius,an)}}G.lineTo(C,an);G.stroke();this.Ae(G);if(ab){H(ab);this.e0(E,an,C,an,af,T,k,false,G)}if(Z){H(Z);this.e0(E,an,C,an,af,T,k,true,G)}}else{if(this.mT([E,a,C,an])){var M=this.GP(E,a,C,an,ai,L,U);var j=this.GP(E,a,C,an,Z?W:ai,ab?ah:L,U);E=M[0];a=M[1];C=M[2];an=M[3];if(aj){M=this.B7("line",[E,a,C,an],al);if(M){E=M[0];a=M[1];C=M[2];an=M[3]}else{return false}}if(X&&this.pe(X)&&X.length>0){var O=X.length-1;if(this.ZL(X)){this.n8(af,T,Y,G);if(U.match(/bezier/i)){if(!this.Kc(af,true)){if(X[0].length==6){G.beginPath();G.moveTo(X[0][0],X[0][1]);for(var ae=0;ae<X.length;ae++){G.bezierCurveTo(X[ae][0],X[ae][1],X[ae][2],X[ae][3],X[ae][4],X[ae][5])}G.stroke();var am;if(ab){am=this.Uv(X[O][0],X[O][1],X[O][0],X[O][1],X[O][2],X[O][3],X[O][4],X[O][5],0.1,true);E=am[9][0];a=am[9][1];C=am[10][0];an=am[10][1];H(ab);this.e0(E,a,C,an,af,T,k,false,G)}if(Z){am=this.Uv(X[0][0],X[0][1],X[0][0],X[0][1],X[0][2],X[0][3],X[0][4],X[0][5],0.1,true);E=am[1][0];a=am[1][1];C=am[0][0];an=am[0][1];H(Z);this.e0(E,a,C,an,af,T,k,true,G)}}else{if(X.length==4){G.beginPath();G.moveTo(X[0][0],X[0][1]);G.bezierCurveTo(X[1][0],X[1][1],X[2][0],X[2][1],X[3][0],X[3][1]);G.stroke();var am=this.Uv(X[0][0],X[0][1],X[1][0],X[1][1],X[2][0],X[2][1],X[3][0],X[3][1],0.1,true);if(ab){E=am[9][0];a=am[9][1];C=X[3][0];an=X[3][1];H(ab);this.e0(E,a,C,an,af,T,k,false,G)}if(Z){E=am[1][0];a=am[1][1];C=X[1][0];an=X[1][1];H(Z);this.e0(E,a,C,an,af,T,k,true,G)}}else{G.beginPath();G.moveTo(X[0][0],X[0][1]);this.yr(X[O][0],X[O][1],false,false,G);G.stroke();if(ab){E=X[O-1][0];a=X[O-1][1];C=X[O][0];an=X[O][1];H(ab);this.e0(E,a,C,an,af,T,k,false,G)}if(Z){E=X[0][0];a=X[0][1];C=X[1][0];an=X[1][1];H(Z);this.e0(E,a,C,an,af,T,k,true,G)}}}}}else{if(!this.Kc(af,true)){G.beginPath();this.yr(X[0][0],X[0][1],X[1][0],X[1][1],G);for(var ae=1;ae<O;ae++){this.yr(X[ae][0],X[ae][1],X[ae+1][0],X[ae+1][1],G)}if(ab){E=X[O-1][0];a=X[O-1][1];C=X[O][0];an=X[O][1];H(ab);this.e0(E,a,C,an,af,T,k,false,G)}if(Z){E=X[0][0];a=X[0][1];C=X[1][0];an=X[1][1];H(Z);this.e0(E,a,C,an,af,T,k,true,G)}}}this.Ae(G)}else{return false}}else{if(U.match(/curved/i)){var B=E==C&&a==an&&F;var v=this.Ma(E,a,C,an);var S=Math.max(1,this.HA(E,a,v[0],v[1]));var P=(W||0)/S;var K=(ah||0)/S;var h=(ai||0)/S;var J=(L||0)/S;var A=U.match(/curvedcc/i)&&E>C?false:!U.match(/curvedcc/i)&&C>=E?true:false;var u=C>=E?Math.asin((v[1]-a)/S):Math.asin(-(v[1]-a)/S);var ad=u+Math.PI;var r=[];var z=[];var aa=this.arrowHeadSize;this.n8(af,T,Y,G);if(!this.Kc(af,true)){var d=0;var ac=false;if(B){if(u<0){u+=Math.PI*2}if(F.dir){ab=false;Z=F.end}else{ab=F.end;Z=false}var x=F.size;var N=F.size*0.5;this.arrowHeadSize=Math.ceil(F.size/3);switch(F.pos){case"top":r=[E,a-x,N,Math.PI*0.75,Math.PI*0.25,false];break;case"topRight":r=[E+x,a-x,N,Math.PI,Math.PI*0.5,false];break;case"right":r=[E+x,a,N,Math.PI*1.25,Math.PI*0.75,false];break;case"bottomRight":r=[E+x,a+x,N,Math.PI*1.5,Math.PI,false];break;case"bottom":r=[E,a+x,N,Math.PI*1.75,Math.PI*1.25,false];break;case"bottomLeft":r=[E-x,a+x,N,0,Math.PI*1.5,false];break;case"left":r=[E-x,a,N,Math.PI*0.25,Math.PI*1.75,false];break;case"topLeft":r=[E-x,a-x,N,Math.PI*0.5,0,false];break}d=0.25}else{if(C>=E){r=[v[0],v[1],Math.max(0,S),u-J,ad+h,A];z=[v[0],v[1],Math.max(0,S),u-K,ad+P,A]}else{ac=true;r=[v[0],v[1],Math.max(0,S),ad-J,u+h,!A];z=[v[0],v[1],Math.max(0,S),ad-K,u+P,!A]}}G.beginPath();G.arc(r[0],r[1],r[2],r[3]+(ab?d:0),r[4]-(Z?d:0),r[5]);G.stroke()}this.Ae(G);var am;if(ab||Z){am=this.sZ(z[0],z[1],z[2],(ac?z[4]-(Math.PI*2):z[3]),(ac?z[3]:z[4]),z[5]*(ac?-1:1))}if(ab||(ac&&Z)){E=am[15][0];a=am[15][1];C=am[16][0];an=am[16][1];if(ac&&Z){H(Z)}else{H(ab)}this.e0(E,a,C,an,af,T,k,false,G)}if(Z||(ac&&ab)){E=am[1][0];a=am[1][1];C=am[0][0];an=am[0][1];if(ac&&ab){H(ab)}else{H(Z)}this.e0(E,a,C,an,af,T,k,true,G)}this.arrowHeadSize=aa}else{if(U.match(/bezier/i)){var o=(E+C)/2;var l=(a+an)/2;var am;this.n8(af,T,Y,G);if(!this.Kc(af,true)){G.beginPath();G.moveTo(E,a);if(this.graphType=="Tree"&&this.treeCircular&&R){G.bezierCurveTo(R[2],R[3],R[0],R[1],C,an);am=this.Uv(E,a,R[0],R[1],R[0],R[1],C,an,0.1,true)}else{if(U.match(/beziery/i)){G.bezierCurveTo(E,l,C,l,C,an);am=this.Uv(E,a,E,l,C,l,C,an,0.1,true)}else{G.bezierCurveTo(o,a,o,an,C,an);am=this.Uv(E,a,o,a,o,an,C,an,0.1,true)}}G.stroke()}this.Ae(G);if(ab){E=am[9][0];a=am[9][1];C=am[10][0];an=am[10][1];H(ab);this.e0(E,a,C,an,af,T,k,false,G)}if(Z){C=am[0][0];an=am[0][1];E=am[1][0];a=am[1][1];H(Z);this.e0(E,a,C,an,af,T,k,true,G)}}else{if(U.match(/needle/i)){this.n8(af,T,Y,G);var y=this.th(E,a,C,an,T);if(!this.Kc(af,true)){G.beginPath();G.moveTo(y[0],y[1]);G.lineTo(C,an);G.lineTo(y[2],y[3]);G.closePath();G.stroke();G.fill();G.arc(E,a,T*3,0,Math.PI*2);G.stroke();G.fill()}this.Ae(G)}else{this.n8(af,T,Y,G);if(!this.Kc(af,true)){G.beginPath();if(U.match(/R$/)||this.useRawLines){this.gW(E,a,C,an,G)}else{this.yr(E,a,C,an,G)}}this.Ae(G);if(ab){H(ab);this.e0(j[0],j[1],j[2],j[3],af,T,k,false,G)}if(Z){H(Z);this.e0(j[0],j[1],j[2],j[3],af,T,k,true,G)}}}}}}else{this.SC(G);return false}}}}}}}this.SC(G)};this.e0=function(c,m,b,l,k,n,j,h,p){if(!p){p=this.rU()}var e=function(t,w,f,z){var s=[];for(var u=0;u<t.length;u++){s.push([(t[u][0]*Math.cos(w))-(t[u][1]*Math.sin(w)),(t[u][0]*Math.sin(w))+(t[u][1]*Math.cos(w))])}var v=[];for(var u=0;u<s.length;u++){v.push([s[u][0]+f,s[u][1]+z])}return v};if(j==0){return this.uo(c,m,b,l,k,n,1,p)}else{this.n8(k,j==1?n:n,false,p);if(j==1){var q=b-c;var o=l-m;var a=n?n/2:this.outlineWidth/2;var d=e([[-a,-this.arrowHeadSize],[-a,this.arrowHeadSize]],Math.atan2(o,q),b,l);p.beginPath();p.moveTo(d[0][0],d[0][1]);for(var g=1;g<d.length;g++){if(!isNaN(d[g][0])&&!isNaN(d[g][1])){p.lineTo(d[g][0],d[g][1])}}p.closePath();p.stroke()}else{if(j==2){p.beginPath();p.arc(b,l,Math.max(0,Math.max((this.arrowHeadSizes/2)-1,1)*1.3),0,Math.PI*2,true);p.closePath();p.fill()}else{}}this.Ae(p)}};this.uo=function(x,e,u,c,y,m,o,q){var r=function(T,w,R,h,P,d){q.save();q.beginPath();q.moveTo(T,w);q.lineTo(R,h);q.lineTo(P,d);switch(v){case 0:var V=Math.sqrt(((P-T)*(P-T))+((d-w)*(d-w)));q.arcTo(R,h,T,w,m*(m<1.01?0.55:0.25)*V);q.fill();break;case 1:q.beginPath();q.moveTo(T,w);q.lineTo(R,h);q.lineTo(P,d);q.lineTo(T,w);q.fill();break;case 2:q.stroke();break;case 3:var I=(T+R+P)/3;var G=(w+h+d)/3;q.quadraticCurveTo(I,G,T,w);q.fill();break;case 4:var S,Q,s,f,V;var L=5;if(P==T){V=d-w;S=(R+T)/2;s=(R+T)/2;Q=h+V/L;f=h-V/L}else{V=Math.sqrt(((P-T)*(P-T))+((d-w)*(d-w)));var N=(T+P)/2;var H=(w+d)/2;var O=(N+R)/2;var U=(H+h)/2;var M=(d-w)/(P-T);var K=(V/(2*Math.sqrt(M*M+1)))/L;var J=M*K;S=O-K;Q=U-J;s=O+K;f=U+J}q.bezierCurveTo(S,Q,s,f,T,w);q.fill();break}q.restore()};if(!q){q=this.rU()}var v=0;switch(this.arrowHeadType){case"unFilled":v=2;break;case"filledStraight":v=1;break;case"filledArc":v=0;break;case"filledQuadratic":v=3;break;case"filledBezier":v=4;break}var n=o!=null?o:1;var z=this.arrowHeadAngle*Math.PI/180;var B=this.arrowHeadSize;var l,k,C,A;var p=Math.sqrt((u-x)*(u-x)+(c-e)*(c-e));var j=(p-B/3)/p;if(n==1||n==3){l=Math.round(x+(u-x)*j);k=Math.round(e+(c-e)*j)}else{l=u;k=c}if(n==2||n==3){C=x+(u-x)*(1-j);A=e+(c-e)*(1-j)}else{C=x;A=e}this.n8(y,m,false,q);var F=Math.atan2(c-e,u-x);var t=Math.abs(B/Math.cos(z));if(n==1||n==3){var b=F+Math.PI+z;var i=u+Math.cos(b)*t;var g=c+Math.sin(b)*t;var a=F+Math.PI-z;var E=u+Math.cos(a)*t;var D=c+Math.sin(a)*t;r(i,g,u,c,E,D,v)}if(n==2||n==3){var b=F+z;var i=x+Math.cos(b)*t;var g=e+Math.sin(b)*t;var a=F-z;var E=x+Math.cos(a)*t;var D=e+Math.sin(a)*t;r(i,g,x,e,E,D,v)}};this.vL=function(l,j,a,q,h,p,g,m,o){var k,i,n,d,b;var c=m!=null?m:1;if(c==1||c==3){k=Math.cos(q)*a+l;i=Math.sin(q)*a+j;n=Math.atan2(l-k,i-j);if(p){d=k+10*Math.cos(n);b=i+10*Math.sin(n)}else{d=k-10*Math.cos(n);b=i-10*Math.sin(n)}this.uo(k,i,d,b,g,m,2,o)}if(c==2||c==3){k=Math.cos(h)*a+l;i=Math.sin(h)*a+j;n=Math.atan2(l-k,i-j);if(p){d=k-10*Math.cos(n);b=i-10*Math.sin(n)}else{d=k+10*Math.cos(n);b=i+10*Math.sin(n)}this.uo(k,i,d,b,g,m,2,o)}};this.yY=function(b){var h=function(c){c.strokeStyle="rgb(29,137,182)";var j=[4,6,9,12,16,21,27,14,17,21,26];var l=[27,21,16,12,9,6,4,26,21,17,14];for(var k=0;k<j.length;k++){c.moveTo(j[k],l[k]);c.arc(j[k],l[k],2,0,Math.PI*2)}c.moveTo(3,32);c.arc(3,32,2,Math.PI,0);c.moveTo(13,32);c.arc(13,32,2,Math.PI,0);c.moveTo(32,3);c.arc(32,3,2,Math.PI*0.5,Math.PI*1.5);c.moveTo(32,13);c.arc(32,13,2,Math.PI*0.5,Math.PI*1.5);j=[[7,11],[8,12],[11,14],[14,17],[18,20],[22,24],[28,29]];l=[[28,29],[22,24],[18,20],[14,17],[11,14],[8,12],[7,11]];for(var k=0;k<j.length;k++){c.moveTo(j[k][0],l[k][0]);c.lineTo(j[k][1],l[k][1])}c.stroke()};var g=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(3,0);c.arc(3,0,2,Math.PI,0,true);c.moveTo(3,5);c.arc(3,5,2,Math.PI,0);c.moveTo(6,1);c.lineTo(8,4);c.lineTo(10,1);c.moveTo(13,0);c.arc(13,0,2,Math.PI,0,true);c.moveTo(13,5);c.arc(13,5,2,Math.PI,0);c.stroke()};var d=function(c){c.strokeStyle="rgb(29,137,182)";c.moveTo(0,3);c.arc(0,3,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,3);c.arc(5,3,2,Math.PI*1.5,Math.PI*0.5,true);c.moveTo(1,6);c.lineTo(4,8);c.lineTo(1,10);c.moveTo(0,13);c.arc(0,13,2,Math.PI*1.5,Math.PI*0.5);c.moveTo(5,13);c.arc(5,13,2,Math.PI*1.5,Math.PI*0.5,true);c.stroke()};if(!b){b=this.rU()}var e;var f=this.$cX("canvas");f.width=5;f.height=5;var a=this.Nn(f);if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.hatchForward=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.hatchReverse=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeVertical")){f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();CanvasXpress.cachePatterns.stripeVertical=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("stripeHorizontal")){a.clearRect(0,0,3,3);a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.stripeHorizontal=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("polkaDot")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.fill();CanvasXpress.cachePatterns.polkaDot=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossHatch")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.crossHatch=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("crossStripe")){f.width=3;f.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.crossStripe=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squares")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.strokeRect(1,1,4,4);a.stroke();CanvasXpress.cachePatterns.squares=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("circles")){a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,1,0,Math.PI*2);a.stroke();CanvasXpress.cachePatterns.circles=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("plus")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.plus=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("minus")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.minus=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("bars")){f.width=7;f.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();CanvasXpress.cachePatterns.bars=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesHorizontal")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,5);a.lineTo(2.5,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("squiglesVertical")){f.width=5;f.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,2.5);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.squiglesVertical=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickForward")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(3,0);a.lineTo(0,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(2,5);a.lineTo(5,2);a.lineTo(5,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickForward=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("brickReverse")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(2,0);a.lineTo(5,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(0,5);a.lineTo(0,2);a.lineTo(3,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickReverse=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("art")){a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.moveTo(0,5);a.lineTo(5,0);a.stroke();CanvasXpress.cachePatterns.art=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("pcx")){a.clearRect(0,0,5,5);a.beginPath();a.moveTo(2,0);a.lineTo(0,0);a.lineTo(0,3);a.lineTo(2,3);a.stroke();a.beginPath();a.moveTo(3,3);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,3);a.lineTo(3,5);a.stroke();CanvasXpress.cachePatterns.pcx=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchForward3")){f.width=5;f.height=3;a.clearRect(0,0,5,3);a.beginPath();a.moveTo(0,0);a.lineTo(5,3);a.stroke();CanvasXpress.cachePatterns.hatchForward3=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("hatchReverse3")){a.clearRect(0,0,5,3);a.beginPath();a.moveTo(5,0);a.lineTo(0,3);a.stroke();CanvasXpress.cachePatterns.hatchReverse3=b.createPattern(f,"repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTop")){f.width=5;f.height=16;a.clearRect(0,0,5,16);d(a);CanvasXpress.cachePatterns.membraneTop=b.createPattern(f,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBottom")){f.width=5;f.height=16;a.clearRect(0,0,5,16);a.translate(5,0);a.scale(-1,1);d(a);CanvasXpress.cachePatterns.membraneBottom=b.createPattern(f,"repeat-x")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneRight")){f.width=16;f.height=5;a.clearRect(0,0,16,5);g(a);CanvasXpress.cachePatterns.membraneRight=b.createPattern(f,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneLeft")){f.width=16;f.height=5;a.clearRect(0,0,16,5);a.translate(0,5);a.scale(1,-1);g(a);CanvasXpress.cachePatterns.membraneLeft=b.createPattern(f,"repeat-y")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTL")){f.width=32;f.height=32;a.clearRect(0,0,32,32);h(a);CanvasXpress.cachePatterns.membraneTL=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBL")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(0,32);a.scale(1,-1);h(a);CanvasXpress.cachePatterns.membraneBL=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneTR")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,0);a.scale(-1,1);h(a);CanvasXpress.cachePatterns.membraneTR=b.createPattern(f,"no-repeat")}if(!CanvasXpress.cachePatterns.hasOwnProperty("membraneBR")){f.width=32;f.height=32;a.clearRect(0,0,32,32);a.translate(32,32);a.scale(-1,-1);h(a);CanvasXpress.cachePatterns.membraneBR=b.createPattern(f,"no-repeat")}};this.E1=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.rO=function(h){var v=function(x,r,i){i.x=r.x-x.x;i.y=r.y-x.y;i.len=Math.sqrt(i.x*i.x+i.y*i.y);i.nx=i.x/i.len;i.ny=i.y/i.len;i.ang=Math.atan2(i.ny,i.nx)};var s=[];for(var t=0;t<h.length;t++){s.push({x:h[t][0],y:h[t][1]})}var m=[];var o=this.roundedPolygonRadius;var e={};var d={};var u=s.length;var c=s[u-1];for(var t=0;t<u;t++){var b=s[(t)%u];var a=s[(t+1)%u];v(b,c,e);v(b,a,d);var j=e.nx*d.ny-e.ny*d.nx;var p=e.nx*d.nx-e.ny*-d.ny;var w=Math.asin(j);var q=1;var f=false;if(p<0){if(w<0){w=Math.PI+w}else{w=Math.PI-w;q=-1;f=true}}else{if(w>0){q=-1;f=true}}var g;var n=w/2;var z=Math.abs(Math.cos(n)*o/Math.sin(n));if(z>Math.min(e.len/2,d.len/2)){z=Math.min(e.len/2,d.len/2);g=Math.abs(z*Math.sin(n)/Math.cos(n))}else{g=o}var l=b.x+d.nx*z;var k=b.y+d.ny*z;l+=-d.ny*g*q;k+=d.nx*g*q;m.push([l,k,g,e.ang+Math.PI/2*q,d.ang-Math.PI/2*q,f]);c=b;b=a}return m};this.zG=function(j,i,k,d,e,c,b,a,g,l){if(!l){l=this.rU()}this.ah(l);this.bp(j,i,l);if(a){this.Dr(a,l)}if(this.transparency!=null){e=this.xh(e,this.transparency,true)}if(this.gradient){if(this.gradientType=="radial"){l.fillStyle=this.z7(0,0,Math.max(Math.abs(k),Math.abs(d)),false,e)}else{l.fillStyle=this.z7(0,0,k,d,e)}}else{if(b){switch(b){case"closed":case"solid":l.fillStyle=e;break;case"open":break;default:if(e){if(e.match(/0.1\)$/)&&c.match(/0.1\)$/)){l.globalAlpha=0.1}}l.fillStyle=CanvasXpress.cachePatterns[b]?CanvasXpress.cachePatterns[b]:e;break}}else{l.fillStyle=e}}l.strokeStyle=c?c:this.foreground;l.lineWidth=g?g:this.outlineWidth;l.lineJoin=this.joinType;if((k&&l.lineWidth>=k)||(d&&l.lineWidth>=d)){l.strokeStyle=e}this.S3(true,l)};this.Iq=function(d,c,b){if(!b){b=this.rU()}if(d&&d.length>1){var a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.beginPath();b.moveTo(a[0]+0.5,a[1]+0.5);while(d.length>0){a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.lineTo(a[0]+0.5,a[1]+0.5)}if(!c){b.closePath()}}};this.f0=function(b,d,c,a){if(!a){a=this.rU()}if(c&&c=="open"){a.stroke()}else{if(d==b||a.strokeStyle==a.fillStyle){a.fill()}else{a.fill();a.stroke()}}};this.qY=function(a,d,c,b){if(!b){b=this.rU()}b.globalAlpha=1;this.S3(false,b);if(c){}this.eh(b)};this.VU=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"||v=="arrow"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.Ei()}switch(v){case"arc2":K=this.TX(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.TX(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.TX(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=this.Lg(N.concat(K.reverse()),false,true);break;case"violin":case"fish":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.Uv(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.Uv(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.Ys(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.TX(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.Ys(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.TX(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"roundpolygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2)}else{N.push(m[E],l[E]-2);K.unshift(m[E],l[E]+2)}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"drop":case"teardrop":case"marker":N=["circle",m,l-n,g];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"arrow":case"box":case"rect":case"rectangle":case"roundrect":case"roundrectt":case"roundrectb":case"roundrectr":case"roundrectl":case"roundrecttr":case"roundrecttl":case"roundrectbr":case"roundrectbl":case"roundrect2":case"roundrectd":case"roundrecto":case"brace":case"square":case"pentagon":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.VU("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.VU("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.VU("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.VU("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.VU("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.VU("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.VU("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.yd(N)}else{return N}};this.wS=function(ab,W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av,O){var T,ay,k,aA,ae,aj;if(!O){O=this.rU()}if(af){switch(af){case"closed":case"solid":case"open":case"round":break;default:var aB=af;af="closed";this.wS(ab,W,V,Y,ap,aq,aq,af,ad,U,ax,az,ac,at,Z,av);af=aB;break}}switch(ab){case"polygon":case"roundpolygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":case"fish":var al=Number.MAX_VALUE;var R=Number.MAX_VALUE*-1;var ak=Number.MAX_VALUE;var P=Number.MAX_VALUE*-1;ay=[];T=[];if(W.length==V.length){if(ab=="spline"&&W.length<5){return this.wS("polygon",W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av)}if(ab=="arch"&&(W.length!=6||V.length!=6||Y.length!=4||ap.length!=2)){return false}if(ab=="bezier"){if(this.mT(W)&&this.mT(V)&&this.mT(ap)){for(var ao=0;ao<W.length;ao++){al=Math.min(al,W[ao]);R=Math.max(R,W[ao]);ak=Math.min(ak,V[ao]);P=Math.max(P,V[ao]);T.push([W[ao],V[ao]])}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0]-=W;T[ao][1]-=V;ay.push(T[ao][0],T[ao][1])}}else{return false}}else{if(ab=="confidence"){if(W.length>2){for(var ao=0;ao<W.length;ao++){if(W[ao][0]!=null&&W[ao][1]!=null&&V[ao][0]!=null&&V[ao][1]!=null&&this.mT([W[ao][0],W[ao][1],V[ao][0],V[ao][1]])){al=Math.min(al,Math.min(W[ao][0],W[ao][1]));R=Math.max(R,Math.max(W[ao][0],W[ao][1]));ak=Math.min(ak,Math.min(V[ao][0],V[ao][1]));P=Math.max(P,Math.max(V[ao][0],V[ao][1]));T.push([[W[ao][0],W[ao][1]],[V[ao][0],V[ao][1]]])}}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0][0]-=W;T[ao][0][1]-=W;T[ao][1][0]-=V;T[ao][1][1]-=V;ay.push([T[ao][0][0],T[ao][0][1]],[T[ao][1][0],T[ao][1][1]])}}else{return false}}else{if(ab=="violin"||ab=="fish"){if(W[0].length==V[0].length&&W[1].length==V[1].length&&W[0].length==W[1].length){for(var ao=0;ao<W[0].length;ao++){if(this.mT([W[0][ao],W[1][ao],V[0][ao],V[1][ao]])){al=Math.min(al,Math.min(W[0][ao],W[1][ao]));R=Math.max(R,Math.max(W[0][ao],W[1][ao]));ak=Math.min(ak,Math.min(V[0][ao],V[1][ao]));P=Math.max(P,Math.max(V[0][ao],V[1][ao]));T.push([[W[0][ao],W[1][ao]],[V[0][ao],V[1][ao]]])}}W=(al+R)/2;V=(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0][0]-=W;T[ao][0][1]-=W;T[ao][1][0]-=V;T[ao][1][1]-=V;ay.push([T[ao][0][0],T[ao][0][1]],[T[ao][1][0],T[ao][1][1]])}}else{return false}}else{for(var ao=0;ao<W.length;ao++){if(W[ao]&&V[ao]&&this.mT([W[ao],V[ao]])){al=Math.min(al,W[ao]);R=Math.max(R,W[ao]);ak=Math.min(ak,V[ao]);P=Math.max(P,V[ao]);T.push([W[ao],V[ao]])}}W=ab=="arch"?W[1]:(al+R)/2;V=ab=="arch"?V[1]:(ak+P)/2;for(var ao=0;ao<T.length;ao++){T[ao][0]-=W;T[ao][1]-=V;ay.push(T[ao][0],T[ao][1])}}}}}else{return false}break;default:if(this.mT([W,V,Y,ap])){if(ax){T=this.B7(ab,[W,V,Y,ap],az);if(T){if(T.length==4){Y=Math.max(1,T[2]);ap=Math.max(1,T[3]);W=T[0]+(Y/2);V=T[1]+(ap/2)}else{if(T.length==2){W=T[0];V=T[1]}}}else{return false}}else{Y=Math.max(1,Y);ap=Math.max(1,ap)}k=Y/2;aA=ap/2;ae=ap/Y;aj=1.5}else{return false}break}switch(ab){case"image":var N=Array.isArray(Z)?this.backgroundImageMD5:this.SZ(Z);if(Z&&(CanvasXpress.cacheImages[N]||CanvasXpress.images[Z])){this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);if(CanvasXpress.images[Z]){this.Sx(CanvasXpress.images[Z],-k*this.zoom,-aA*this.zoom,Y*this.zoom,ap*this.zoom,false,false,false,false,aq,af,O)}else{this.Sx(CanvasXpress.cacheImages[N],-k*this.zoom,-aA*this.zoom,Y*this.zoom,ap*this.zoom,false,false,false,false,aq,af,O)}}else{if(N&&N=="canvasXpress"){return}else{return this.wS("rectangle",W,V,Y,ap,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",af,ad,U,ax,az,ac,at,Z,av)}}break;case"circle":case"sphere":case"circleOpen":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);if(!this.Kc(aq,true)||!this.Kc(ag,true)){O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,false);O.closePath();this.f0(aq,ag,af,O)}break;case"drop":case"teardrop":case"marker":var F=k*2/3;var E=F*0.5;var S=this.graphType=="Map"?-F*3:0;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.arc(0,S,Math.max(0,k),0,Math.PI,true);O.bezierCurveTo(-k,S+k,0,S+E,0,S+(F*3));O.bezierCurveTo(0,S+E,k,S+k,k,S);O.closePath();this.f0(aq,ag,af,O);O.beginPath();O.arc(0,S,Math.max(0,k*0.3),0,Math.PI*2,true);O.closePath();this.f0("white","black",af,O);break;case"arrow":T=[[-k,-aA],[k,-aA],[k,aA],[-k,aA]];if(ad){ad=false;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);var F=ap/4;O.beginPath();O.moveTo(k-ap,-aA);O.lineTo(k-ap,-aA-F);O.lineTo(k,0);O.lineTo(k-ap,aA+F);O.lineTo(k-ap,aA);O.lineTo(-k,aA);O.lineTo(-k,-aA);O.closePath();this.f0(aq,ag,af,O)}else{this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);var v=Y/4;O.beginPath();O.moveTo(-k,-aA+Y);O.lineTo(-k-v,-aA+Y);O.lineTo(0,-aA);O.lineTo(k+v,-aA+Y);O.lineTo(k,-aA+Y);O.lineTo(k,aA);O.lineTo(-k,aA);O.closePath();this.f0(aq,ag,af,O)}break;case"box":case"rect":T=[[-k,-aA],[k,-aA],[k,aA],[-k,aA]];this.zG(Math.round(W),Math.round(V),Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(k,-aA);O.lineTo(k,aA);O.lineTo(-k,aA);O.closePath();this.f0(aq,ag,af,O);break;case"rectangle":T=[[-k,-aA],[k,-aA],[k,aA],[-k,aA]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);if(af&&af=="open"){O.strokeRect(-k,-aA,Y,ap)}else{if(ag==aq||O.strokeStyle==O.fillStyle){O.fillRect(-k,-aA,Y,ap)}else{O.fillRect(-k,-aA,Y,ap);O.strokeRect(-k,-aA,Y,ap)}}break;case"rect2":return this.wS("rectangle",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"rect3":return this.wS("rectangle",W,V,Y,Y/3,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"roundrectt":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA);O.lineTo(k,aA);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.f0(aq,ag,af,O);break;case"roundrectb":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA);O.lineTo(-k,-aA);O.closePath();this.f0(aq,ag,af,O);break;case"roundrectr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k,-aA);O.closePath();this.f0(aq,ag,af,O);break;case"roundrectl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k,aA);O.lineTo(k,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.f0(aq,ag,af,O);break;case"roundrecttr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA);O.lineTo(k,aA);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k,-aA);O.closePath();this.f0(aq,ag,af,O);break;case"roundrecttl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA);O.lineTo(k,aA);O.lineTo(k,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.f0(aq,ag,af,O);break;case"roundrectbr":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA);O.lineTo(-k,-aA);O.closePath();this.f0(aq,ag,af,O);break;case"roundrectbl":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap:Y;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k,aA);O.lineTo(k,-aA);O.lineTo(-k,-aA);O.closePath();this.f0(aq,ag,af,O);break;case"roundrecto":var X=Y<ap?k:aA;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();if(Y<ap){O.arc(0,-aA+X,X,Math.PI,0);O.lineTo(k,aA-X);O.arc(0,aA-X,X,0,Math.PI);O.lineTo(-k,-aA+X)}else{O.arc(-k+X,0,X,Math.PI*0.5,Math.PI*1.5);O.lineTo(k-X,-aA);O.arc(k-X,0,X,Math.PI*1.5,Math.PI*0.5);O.lineTo(-k+X,aA)}O.closePath();this.f0(aq,ag,af,O);break;case"roundrect":case"roundrect2":case"roundrectd":var X=Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius?this.roundedPolygonRadius:Y>ap?ap/4:Y/4;if(ab=="roundrect2"){X*=4}this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.f0(aq,ag,af,O);if(ab=="roundrectd"&&Y>this.roundedPolygonRadius&&ap>this.roundedPolygonRadius){Y-=this.roundedPolygonRadius;ap-=this.roundedPolygonRadius;k=Y/2;aA=ap/2;O.beginPath();O.moveTo(-k,-aA+X);O.lineTo(-k,aA-X);O.quadraticCurveTo(-k,aA,-k+X,aA);O.lineTo(k-X,aA);O.quadraticCurveTo(k,aA,k,aA-X);O.lineTo(k,-aA+X);O.quadraticCurveTo(k,-aA,k-X,-aA);O.lineTo(-k+X,-aA);O.quadraticCurveTo(-k,-aA,-k,-aA+X);O.closePath();this.f0(aq,ag,af,O)}break;case"brace":var X=Y>ap?ap/4:Y/4;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(-k,-aA);O.bezierCurveTo(-k,0,0,0,0,aA);O.bezierCurveTo(0,0,k,0,k,-aA);this.f0(aq,ag,af,O);break;case"square":case"squareOpen":T=[[-k,-k],[k,-k],[k,k],[-k,k]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"triangle":case"triangleOpen":if(Y==ap){return this.wS("equilateral",W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av)}T=[[0,-aA],[k,aA],[-k,aA]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"triangle2":if(Y==ap){return this.wS("equilateral2",W,V,Y,ap,aq,ag,af,ad,U,ax,az,ac,at,Z,av)}T=[[0,aA],[k,-aA],[-k,-aA]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"equilateral":var X=Y*Math.sqrt(3)/6;var j=X/2;var H=Math.sqrt((X*X)-(j*j));T=[[0,-aA],[k,aA],[-k,aA]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"equilateral2":var X=Y*Math.sqrt(3)/6;var j=X/2;var H=Math.sqrt((X*X)-(j*j));T=[[0,aA],[k,-aA],[-k,-aA]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"diamond":case"rhombus":case"diamondOpen":T=[[0,-aA],[k,0],[0,aA],[-k,0]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"hexagon":var g=2*Math.PI/6;var T=[];for(var aw=0;aw<6;aw++){T.push([k*Math.sin(g*aw),aA*Math.cos(g*aw)])}this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"pentagon":var au=Y/3;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();for(var ao=0;ao<5;ao++){var G=(ao/5)*Math.PI*2+(-Math.PI/2);O.lineTo(Math.cos(G)*au,Math.sin(G)*au)}O.closePath();this.f0(aq,ag,af,O);break;case"octagon":var aC=Y/4;var an=ap/4;T=[[-aC,-aA],[aC,-aA],[k,-an],[k,an],[aC,aA],[-aC,aA],[-k,an],[-k,-an]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"oval":case"ovald":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.ah(O);this.QY(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,true);O.closePath();this.eh(O);this.f0(aq,ag,af,O);if(ab=="ovald"){Y-=this.margin*2;ap-=this.margin*2;ae=ap/Y;this.ah(O);this.QY(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI*2,true);O.closePath();this.eh(O);this.f0(aq,ag,af,O)}break;case"oval2":return this.wS("oval",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"oval3":return this.wS("oval",W,V,Y,Y/3,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"arc":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.ah(O);this.QY(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI,true);if(af!="open"){O.closePath()}this.eh(O);this.f0(aq,ag,af,O);break;case"arc2":var J=ap*Math.cos(ac);var aF=ap*Math.sin(ac);var I=ap*Math.cos(at);var aD=ap*Math.sin(at);var D=this.GP(0,0,J,aF,0,Y,"line");var B=this.GP(0,0,I,aD,0,Y,"line");this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(D[2],D[3]);O.lineTo(J,aF);O.arc(0,0,Math.max(0,ap),ac,at,false);O.lineTo(B[2],B[3]);O.arc(0,0,Math.max(0,ap-Y),at,ac,true);O.closePath();this.f0(aq,ag,af,O);break;case"arc3":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.ah(O);this.QY(1,ae,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),0,Math.PI,true);this.eh(O);this.f0(aq,ag,af,O);break;case"arch":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(T[0][0],T[0][1]);O.quadraticCurveTo(T[1][0],T[1][1],T[2][0],T[2][1]);O.arc(0,0,Math.max(0,ap[0]),Y[3],Y[2],true);O.quadraticCurveTo(T[4][0],T[4][1],T[5][0],T[5][1]);O.arc(0,0,Math.max(0,ap[1]),Y[1],Y[0],true);O.closePath();this.f0(aq,ag,af,O);break;case"path":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T,af=="open");this.f0(aq,ag,af,O);break;case"roundpolygon":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);T=this.rO(T);O.beginPath();for(var ao=0;ao<T.length;ao++){O.arc(T[ao][0],T[ao][1],T[ao][2],T[ao][3],T[ao][4])}O.closePath();this.f0(aq,ag,af,O);break;case"polygon":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T,af=="open"&&aq);this.f0(aq,ag,af,O);break;case"spline":var aa=[];var ai=[];var K=[];ai.push(ay.shift());ai.push(ay.shift());K.push(ay.pop());K.unshift(ay.pop());var ah=ay.length;for(var ao=0;ao<ah-4;ao+=2){aa=aa.concat(this.UJ(ay[ao],ay[ao+1],ay[ao+2],ay[ao+3],ay[ao+4],ay[ao+5]))}this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ai[0],ai[1]);O.lineTo(ay[0],ay[1]);O.quadraticCurveTo(aa[0],aa[1],ay[2],ay[3]);for(var ao=2;ao<ah-5;ao+=2){O.bezierCurveTo(aa[2*ao-2],aa[2*ao-1],aa[2*ao],aa[2*ao+1],ay[ao+2],ay[ao+3])}O.quadraticCurveTo(aa[2*ah-10],aa[2*ah-9],ay[ah-2],ay[ah-1]);O.lineTo(K[0],K[1]);O.lineTo(ai[0],ai[1]);this.f0(aq,ag,af,O);break;case"hull":var am;var ah=1;var L=[];while(ay.length>1){L.push([ay.shift(),ay.shift()])}var aa=this.bW(L);var q=[[L[0][0],L[0][1],aa[aa.length-1][0],aa[aa.length-1][1],aa[0][0],aa[0][1],L[1][0],L[1][1]]];for(var ao=1;ao<L.length-1;ao++){q.push([L[ao][0],L[ao][1],aa[ah][0],aa[ah][1],aa[ah+1][0],aa[ah+1][1],L[ao+1][0],L[ao+1][1]]);ah+=2}q.push([L[ao][0],L[ao][1],aa[ah][0],aa[ah][1],aa[ah+1][0],aa[ah+1][1],L[0][0],L[0][1]]);this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(q[0][0],q[0][1]);for(var ao=0;ao<q.length;ao++){O.bezierCurveTo(q[ao][2],q[ao][3],q[ao][4],q[ao][5],q[ao][6],q[ao][7])}this.f0(aq,ag,af,O);break;case"violin":var ah=ay.length;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0][0],ay[1][0]);for(var ao=2;ao<ah;ao+=2){O.lineTo(ay[ao][0],ay[ao+1][0])}O.lineTo(ay[ah-2][1],ay[ah-1][1]);for(var ao=2;ao<ah;ao+=2){var aE=(ah-1)-ao;O.lineTo(ay[aE-1][1],ay[aE][1])}O.lineTo(ay[0][0],ay[1][0]);this.f0(aq,ag,af,O);break;case"fish":var ah=ay.length;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0][0],ay[1][0]);for(var ao=2;ao<ah;ao+=2){var A=(ay[ao-2][0]+ay[ao][0])/2;O.bezierCurveTo(A,ay[ao-1][0],A,ay[ao+1][0],ay[ao][0],ay[ao+1][0])}O.lineTo(ay[ah-2][1],ay[ah-1][1]);for(var ao=2;ao<ah;ao+=2){var aE=(ah-1)-ao;var A=(ay[aE+1][1]+ay[aE-1][1])/2;O.bezierCurveTo(A,ay[aE+2][1],A,ay[aE][1],ay[aE-1][1],ay[aE][1])}O.lineTo(ay[0][0],ay[1][0]);this.f0(aq,ag,af,O);break;case"confidence":var ah=ay.length;var aa=[];var Q=[];for(var ao=0;ao<ah-4;ao+=2){var aE=(ah-1)-ao;aa=aa.concat(this.UJ(ay[ao][0],ay[ao+1][0],ay[ao+2][0],ay[ao+3][0],ay[ao+4][0],ay[ao+5][0]));Q=Q.concat(this.UJ(ay[aE-1][1],ay[aE][1],ay[aE-3][1],ay[aE-2][1],ay[aE-5][1],ay[aE-4][1]))}this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0][0],ay[1][0]);O.quadraticCurveTo(aa[0],aa[1],ay[2][0],ay[3][0]);for(var ao=2;ao<ah-5;ao+=2){O.bezierCurveTo(aa[2*ao-2],aa[2*ao-1],aa[2*ao],aa[2*ao+1],ay[ao+2][0],ay[ao+3][0])}O.quadraticCurveTo(aa[2*ah-10],aa[2*ah-9],ay[ah-2][0],ay[ah-1][0]);O.lineTo(ay[ah-2][1],ay[ah-1][1]);O.quadraticCurveTo(Q[0],Q[1],ay[ah-4][1],ay[ah-3][1]);for(var ao=2;ao<ah-5;ao+=2){var aE=(ah-1)-ao;O.bezierCurveTo(Q[2*ao-2],Q[2*ao-1],Q[2*ao],Q[2*ao+1],ay[aE-3][1],ay[aE-2][1])}O.quadraticCurveTo(Q[2*ah-10],Q[2*ah-9],ay[0][1],ay[1][1]);O.lineTo(ay[0][0],ay[1][0]);this.f0(aq,ag,af,O);break;case"bezier":this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(ay[0],ay[1]);O.bezierCurveTo(ay[2],ay[3],ay[4],ay[5],ay[6],ay[7]);O.lineTo(ay[6],ay[7]+ap);O.bezierCurveTo(ay[4],ay[5]+ap,ay[2],ay[3]+ap,ay[0],ay[1]+ap);O.lineTo(ay[0],ay[1]);this.f0(aq,ag,af,O);break;case"ellipse":var a=k*0.5522848;var ar=aA*0.5522848;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.moveTo(0,aA);O.bezierCurveTo(0,aA-ar,k-a,0,k,0);O.bezierCurveTo(k+a,0,Y,aA-ar,Y,aA);O.bezierCurveTo(Y,aA+ar,k+a,ap,k,ap);O.bezierCurveTo(k-a,ap,0,aA+ar,0,aA);O.closePath();this.f0(aq,ag,af,O);break;case"ellipse2":return this.wS("ellipse",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"ellipse3":return this.wS("ellipse",W,V,Y,Y/3,aq,ag,af,ad,U,ax,az,ac,at,Z,av);break;case"plus":T=[[-aj,-aA],[aj,-aA],[aj,-aj],[k,-aj],[k,aj],[aj,aj],[aj,aA],[-aj,aA],[-aj,aj],[-k,aj],[-k,-aj],[-aj,-aj],[-aj,-aA]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"minus":T=[[-k,-aj],[k,-aj],[k,aj],[-k,aj],[-k,-aj]];this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.Iq(T);this.f0(aq,ag,af,O);break;case"mdavid":var au=Y/3;var C=Math.PI/6;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.ah(O);this.QY(0.8,0.8,O);this.Dr(M*0.45,O);O.beginPath();O.moveTo(au,0);for(var ao=0;ao<11;ao++){this.Dr(C,O);if(ao%2==0){O.lineTo((au/0.55),0)}else{O.lineTo(au,0)}}O.closePath();this.eh(O);this.f0(aq,ag,af,O);break;case"star":var m=(Y/4);var M=Math.PI/5;this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);this.ah(O);this.QY(0.7,0.7,O);this.Dr(M*0.45,O);O.beginPath();O.moveTo(m,0);for(var ao=0;ao<9;ao++){this.Dr(M,O);if(ao%2==0){O.lineTo((m/0.35),0)}else{O.lineTo(m,0)}}O.closePath();this.eh(O);this.f0(aq,ag,af,O);break;case"pie":if(typeof(ac)=="undefined"){ac=0}if(typeof(at)=="undefined"){at=Math.PI*2}this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);O.beginPath();O.arc(0,0,Math.max(0,Y/2),ac,at,false);O.lineTo(0,0);O.closePath();this.f0(aq,ag,af,O);break;case"pie0":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/5,Z,av);break;case"pie1":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/3.5,Z,av);break;case"pie2":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/2,Z,av);break;case"pie3":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI/1.5,Z,av);break;case"pie4":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI,Z,av);break;case"pie5":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.2,Z,av);break;case"pie6":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.4,Z,av);break;case"pie7":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.6,Z,av);break;case"pie8":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*1.8,Z,av);break;case"pie9":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,0,Math.PI*2,Z,av);break;case"pacman":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,Math.PI*1/4,Math.PI*7/4,Z,av);break;case"pacman2":return this.wS("pie",W,V,Y,Y/2,aq,ag,af,ad,U,ax,az,Math.PI*5/4,Math.PI*3/4,Z,av);break;case"pch0":this.wS("square",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch1":this.wS("circle",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch2":this.wS("equilateral",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch3":this.zG(W,V,Y,ap,aq,ag,"open",false,U,O);O.moveTo(0,-aA);this.yr(0,-aA,0,aA,O);O.stroke();O.moveTo(-k,0);this.yr(-k,0,k,0,O);O.stroke();this.f0(aq,ag,af,O);break;case"pch4":this.zG(W,V,Y,ap,aq,ag,"open",false,U,O);O.moveTo(-k,-aA);this.yr(-k,-aA,k,aA,O);O.stroke();O.moveTo(k,-aA);this.yr(k,-aA,-k,aA,O);O.stroke();this.f0(aq,ag,af,O);break;case"pch5":this.wS("diamond",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch6":this.wS("equilateral2",W,V,Y,Y,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch7":this.wS("pch0",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch4",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch8":this.wS("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch4",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch9":this.wS("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch5",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch10":this.wS("pch1",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch11":this.wS("pch2",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch6",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch12":this.wS("pch0",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch3",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch13":this.wS("pch1",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch4",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch14":this.wS("pch0",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);this.wS("pch6",W,V,Y,ap,aq,ag,"open",false,U,ax,az,ac,at,Z,av);break;case"pch15":case"pch22":this.wS("square",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch16":case"pch21":this.wS("circle",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch17":case"pch24":this.wS("equilateral",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch18":case"pch23":this.wS("diamond",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch19":this.wS("circle",W,V,Y+2,Y+2,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch20":this.wS("circle",W,V,Math.max(2,Y-2),Math.max(2,Y-2),aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;case"pch25":this.wS("equilateral2",W,V,Y,Y,aq||this.foreground,ag,"closed",false,U,ax,az,ac,at,Z,av);break;default:this.zG(W,V,Y,ap,aq,ag,af,ad,U,O);break}if(ab=="box"||ab=="rect"){this.qY(Math.round(W),Math.round(V),ad,O)}else{this.qY(W,V,ad,O)}};this.Cv=function(k){var s=k.naturalWidth;var l=k.naturalHeight;var o=this.RI(k);var m=o.ctx.getImageData(0,0,s,l).data;for(var f=0;f<l;f++){var t=l-(f+1);for(var e=0;e<s;e++){var d=parseInt(m[t][e][0]*255);var n=parseInt(m[t][e][1]*255);var p=parseInt(m[t][e][2]*255);var q=m[t][e][3]?parseInt(m[t][e][3]*255):255;o.ctx.fillStyle="rgba("+d+","+n+","+p+","+q+")";o.ctx.fillRect(e,f,1,1)}}return o.toDataURL("img/png")};this.RI=function(a){var b=this.$cX("canvas",{width:a.naturalWidth,height:a.naturalHeight});b.ctx=this.Nn(b);b.ctx.drawImage(a,0,0);return b};this.KZ=function(e,k){var m=this.RI(e);var b=k?this.Kv(k):false;var j=m.ctx.getImageData(0,0,e.naturalWidth,e.naturalHeight);var l=j.data;for(var e=0;e<l.length;e+=4){var h=0.34*l[e]+0.5*l[e+1]+0.16*l[e+2];if(h>220){h=255;l[e]=h;l[e+1]=h;l[e+2]=h;l[e+3]=0}else{l[e]=k?b[0]:h;l[e+1]=k?b[1]:h;l[e+2]=k?b[2]:h}}m.ctx.putImageData(j,0,0);return m};this.Bg=function(l){var k=l.length;var q=l[0].length;var n=this.$cX("canvas",{width:q,height:k});n.ctx=this.Nn(n);n.ctx.clearRect(0,0,q,k);for(var f=0;f<k;f++){var s=k-(f+1);for(var e=0;e<q;e++){var d=parseInt(l[s][e][0]*255);var m=parseInt(l[s][e][1]*255);var o=parseInt(l[s][e][2]*255);var p=l[s][e][3]?parseInt(l[s][e][3]*255):255;n.ctx.fillStyle="rgba("+d+","+m+","+o+","+p+")";if(this.scatterType=="visium"&&this.visiumFlip){n.ctx.fillRect(e,f,1,1)}else{n.ctx.fillRect(e,s,1,1)}}}if(this.scatterType=="visium"){this.backgroundImageRows=k;this.backgroundImageCols=q}return n.toDataURL("img/png")};this.Sx=function(x,v,m,j,y,D,s,p,F,g,o,u){if(!u){u=this.rU()}try{v=parseInt(Math.round(v||0));m=parseInt(Math.round(m||0));j=parseInt(Math.round(j||x.naturalWidth));y=parseInt(Math.round(y||x.naturalHeight));if(this.scatterType=="visium"){if(this.visiumFlip){var A=this.xAxisMin;var z=this.xAxisMax;var b=x.naturalHeight-this.yAxisMax;var c=x.naturalHeight-this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=this.yAxisMax;u.scale(a,G);u.drawImage(x,A,n,f,E,v+k,m+B,f,E);u.scale(1/a,1/G)}else{var A=this.xAxisMin;var z=this.xAxisMax;var b=this.yAxisMax;var c=this.yAxisMin;var f=z-A;var E=b-c;var a=j/f;var G=y/E;var k=(j-f)/2;var B=(y-E)/2;var n=x.naturalHeight-this.yAxisMax;u.scale(a,G);u.drawImage(x,A,n,f,E,v+k,m+B,f,E);u.scale(1/a,1/G)}}else{if(D&&s&&p&&F){D=parseInt(Math.round(D));s=parseInt(Math.round(s));p=parseInt(Math.round(p));F=parseInt(Math.round(F));u.drawImage(x,v,m,j,y,D,s,p,F);u.drawImage(this.KZ(x,g),v,m,j,y,D,s,p,F)}else{if(g&&g=="b&w"){u.drawImage(this.KZ(x),v,m,j,y)}else{if(g){u.drawImage(x,v,m,j,y);u.drawImage(this.KZ(x,g),v,m,j,y)}else{if(o=="round"){var q=Math.max(j,y)/2;this.ah(u);u.arc(v+q,m+q,q,0,Math.PI*2);u.clip();u.drawImage(x,v,m,j,y);this.eh(u);this.TO([0,0,0,0],u);this.eh(u)}else{u.drawImage(x,v,m,j,y)}}}}}}catch(C){var d=this;d.T4(C);setTimeout(function(){d.j8({func:"drawImage",par:[x,v,m,j,y,D,s,p,F,g]})},100)}};this.xB=function(k){if(!k){k=this.rU()}var f=document.createElementNS("http://www.w3.org/2000/svg","svg");var i=f.createSVGMatrix();k.getTransform=function(){return i};var j=[];var g=k.save;k.save=function(){j.push(i.dR(0,0));return g.call(k)};var h=k.restore;k.restore=function(){i=j.pop();return h.call(k)};var c=k.scale;k.scale=function(n,m){i=i.scaleNonUniform(n,m);return c.call(k,n,m)};var d=k.rotate;k.rotate=function(m){i=i.rotate(m*180/Math.PI);return d.call(k,m)};var b=k.translate;k.translate=function(n,m){i=i.dR(n,m);return b.call(k,n,m)};var a=k.transform;k.transform=function(n,m,s,r,q,p){var o=f.createSVGMatrix();o.a=n;o.b=m;o.c=s;o.d=r;o.e=q;o.f=p;i=i.multiply(o);return a.call(k,n,m,s,r,q,p)};var e=k.setTransform;k.setTransform=function(n,m,r,q,p,o){i.a=n;i.b=m;i.c=r;i.d=q;i.e=p;i.f=o;return e.call(k,n,m,r,q,p,o)};var l=f.createSVGPoint();k.transformedPoint=function(m,n){l.x=m;l.y=n;return l.matrixTransform(i.inverse())}};this.r9=function(b,a){if(!CanvasXpress.system.isIE&&b){if(!a){a=this.rU()}a.globalCompositeOperation=b;this.meta.state.globalCompositeOperation=b}};this.HR=function(a,e,c,d,b){if(!b){b=this.rU()}b.clearRect(a,e,c,d)};this.bp=function(a,c,b){if(!b){b=this.rU()}b.translate(a,c);this.meta.state.translate[0]+=a;this.meta.state.translate[1]+=c};this.Dr=function(b,a){if(!a){a=this.rU()}a.rotate(b);this.meta.state.rotate[0]+=b};this.QY=function(a,c,b){if(!b){b=this.rU()}b.scale(a,c);this.meta.state.scale[0]*=a;this.meta.state.scale[1]*=c};this.ah=function(a){if(!a){a=this.rU()}a.save();this.meta.state.save++;this.meta.state.last={translate:[this.meta.state.translate[0],this.meta.state.translate[1]],scale:[this.meta.state.scale[0],this.meta.state.scale[1]],rotate:[this.meta.state.rotate[0]]}};this.eh=function(a){if(!a){a=this.rU()}a.restore();this.meta.state.translate[0]=this.meta.state.last.translate[0];this.meta.state.translate[1]=this.meta.state.last.translate[1];this.meta.state.scale[0]=this.meta.state.last.scale[0];this.meta.state.scale[1]=this.meta.state.last.scale[1];this.meta.state.rotate[0]=this.meta.state.last.rotate[0];this.meta.state.save--}};CanvasXpress.prototype.initRangeAlgorithms=function(){this.BW=function(h,d){if(h==undefined){h=0}var g=h;var e=h.toString();var k=e.indexOf("999999");var i=e.indexOf("000000");var j=e.indexOf(".");var b=k>=0&&j<k?k:i>=0?i:null;if(b!=null){g=e.substring(0,b);f=Math.pow(10,g.length-(g.indexOf(".")+1));return Number(Math.round(Number(e)*f)/f)}else{return d?Number.parseFloat(e).toFixed(d):Number(e)}};this.Xb=function(d,m,b,g){var c=function(i,n){var q;var r=Math.floor(Math.log(i)/Math.LN10);var p=i/Math.pow(10,r);if(n){if(p<1.5){q=1}else{if(p<3){q=2}else{if(p<7){q=5}else{q=10}}}}else{if(p<1){q=1}else{if(p<2){q=2}else{if(p<5){q=5}else{q=10}}}}return q*Math.pow(10,r)};if(d>m){var h=m;d=m;d=h}else{if(m-d<1e-8){m+=0.1}}var l=[];var j=c(m-d,false);var o=c(j/(b-1),true);var a=Math.floor(d/o)*o;var k=Math.ceil(m/o)*o;for(var e=a;e<=k;e+=o){l.push(this.BW(e))}if(l[0]==l[l.length-1]){var l=[];for(var e=a;e<=k;e+=o){l.push(e)}}return g?l:this.Z0(l)};this.t6=function(c,l,a,h){var b=function(B,D,C,A){var w=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var y=D-B;var t=C-1;var q=1-Math.abs(C-A)/A;var F=y/t;var v=Math.floor(Math.log(F)/Math.LN10);var G=Math.pow(10,v);var r=null;for(var E=0;E<w.length;E++){var u=w[E]*G;var H=Math.floor(B/u)*u;var n=H+t*u;if(H<=B&&n>=D){var x=1-(E-(H<=0&&n>=0?1:0))/w.length;var s=(D-B)/(n-H);if(s>0.8){var z=q+x+s;if(r==null||z>r.score){r={lmin:H,lmax:n,lstep:u,score:z}}}}}if(!r){r={lmin:B,lmax:D,lstep:1,score:0}}return r};if(c>l){var j=l;c=l;c=j}else{if(l-c<1e-8){}}var m=[];var e=null;var o=[];for(var g=Math.max(Math.floor(a/2),2);g<=Math.ceil(6*a);g++){o.push(g)}for(var g=0;g<o.length;g++){var d=o[g];var p=b(c,l,d,a);if((p!=null&&e==null)||(p&&e&&p.score>e.score)){e=p}}for(var g=e.lmin;g<=e.lmax;g+=e.lstep){m.push(this.BW(g))}if(m[0]==m[m.length-1]){var m=[];for(var g=e.lmin;g<=e.lmax;g+=e.lstep){m.push(g)}}return h?m:this.Z0(m)};this.i0=function(a,B,T,d,E){var C=2.22e-14;var l=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var L=function(c,w,m,g,z,aa){var k=w.length;var s=l(c,w);var ab=(g%aa<C||aa-(g%aa)<C)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+ab};var M=function(s,m,g){var w=m.length;var k=l(s,m);var c=1;return 1-k/(w-1)-g+c};var o=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var u=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var r=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var Z=function(g,c){return g>=c?2-(g-1)/(c-1):1};var h=[1,5,2,2.5,4,3];var I=[0.25,0.2,0.5,0.05];var S=h.length;var N={score:-2};var J=[];if(a>B){var p=a;a=B;B=p}else{if(B-a<1e-8){}}var V=1;while(V<Number.POSITIVE_INFINITY){for(var W=0;W<S;W++){var P=h[W];var x=M(P,h,V);if((I[0]*x+I[1]+I[2]+I[3]<N.score)){V=Number.POSITIVE_INFINITY;break}var U=2;while(U<Number.POSITIVE_INFINITY){var t=Z(U,T);if((I[0]*x+I[1]+I[2]*t+I[3]<N.score)){break}var G=(B-a)/(U+1)/V/P;var H=Math.ceil(Math.log(G)/Math.LN10);while(H<Number.POSITIVE_INFINITY){var F=V*P*Math.pow(10,H);var D=u(a,B,F*(U-1));if((I[0]*x+I[1]*D+I[2]*t+I[3]<N.score)){break}var y=Math.floor(B/F)*V-(U-1)*V;var R=Math.ceil(a/F)*V;if(y>R){H++;continue}for(var A=y;A<=R;A++){var v=A*(F/V);var O=v+F*(U-1);var e=F;var K=L(P,h,V,v,O,e);var Y=o(a,B,v,O);var X=r(U,T,a,B,v,O);var b=I[0]*K+I[1]*Y+I[2]*X+I[3];if(b>N.score&&(!E||(v<=a&&O>=B))){N={lmin:v,lmax:O,lstep:e,score:b}}}H++}U++}}V++}for(var W=N.lmin;W<=N.lmax;W+=N.lstep){J.push(this.BW(W))}if(J[0]==J[J.length-1]){var J=[];for(var W=N.lmin;W<=N.lmax;W+=N.lstep){J.push(W)}}return d?J:this.Z0(J)};this.ct=function(l,m,z,i){if(l>m){var y=m;m=l;l=y}if(isNaN(l)||isNaN(m)){return[]}var v=Math.floor(z%3);var g=0.75;var x=1.5;var e=0.5+1.5*x;var w=2e-20;var j=0;var b,s,c;var o=Number.EPSILON;var u=1.25;var a=1e-10;var n=m-l;if(n==0&&m==0){b=1;s=true}else{b=Math.max(Math.abs(l),Math.abs(m));c=1+((e>=1.5*x+0.5)?1/(1+x):1.5/(1+e));c*=parseInt(Math.max(1,z))*o;s=n<b*c*3}if(s){if(b>10){b=9+b/10}b*=g;if(v>1){b/=v}}else{b=n;if(isFinite(n)){if(z>1){b/=z}else{if(z<2){b=m*0.5}else{b=m/z-l/z}}}}var r=w*Number.MIN_VALUE;if(r==0){r=Number.MIN_VALUE}if(b<r){alert("Error in rPretty: very small range");b=r}else{if(b>Number.MAX_VALUE/u){alert("Error in rPretty: very large range");b=Number.MAX_VALUE/u}}var d=Math.pow(10,Math.floor(Math.log10(b)));var q=d;if((2*d)-b<x*(b-q)){q=2*d;if((5*d)-b<e*(b-q)){q=5*d;if((10*d)-b<x*(b-q)){q=10*d}}}var B=Math.floor(l/q+a);var A=Math.ceil(m/q-a);if(j&&(j>1||!s)){if(l!=0){l*=(1-o)}else{l=-Number.MIN_VALUE}if(m!=0){m*=(1+o)}else{m=Number.MIN_VALUE}}while(B*q>l+(a*q)){B--}while(!isFinite(B*q)){B++}while(A*q<m-(a*q)){A++}while(!isFinite(B*q)){B--}var t=Math.floor(0.5+A-B);if(t<v){t=v-t;if(l==0&&B==0&&m!=0){A+=t}else{if(m==0&&A==0&&l!=0){B-=t}else{if(B>=0){A+=t/2;B-=t/2+t%2}else{B-=t/2;A+=t/2+t%2}}}z=v}else{z=t}if(B*q<l){l=B*q}if(A*q>m){m=A*q}var p=this.Qc(l,m,false,z+1);return i?p:this.Z0(p)}};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.Y5=function(c,g,h,f,j){if(this.Q7()){return}var e=this[h];if(f){var a={};if(this.pe(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=true}}else{a[c]=true}for(var d in a){if(e.includes(d)){e=this.tv(d,e);delete (a[d])}}for(var d in a){e.push(d)}this[h]=e}else{if(g){var a={};var k=[];if(this.pe(c)){var b=c.length;for(var d=0;d<b;d++){a[c[d]]=1}}else{a[c]=1}var b=e.length;for(var d=0;d<b;d++){if(!a.hasOwnProperty(e[d])){k.push(e[d])}}this[h]=k}else{if(this.pe(c)){var b=c.length;for(var d=0;d<b;d++){e.push(c[d])}}else{e.push(c)}}}if(j){this.j8({func:"modifyObjectArray",par:[c,g,h,f,j]})}};this.tx=function(b){var d={};if(b&&this.pe(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]]=true}}return d};this.uM=function(c){var f=[];if(c&&this.pe(c)){var g=c.length;for(var e=0;e<g;e++){f[e]=[];if(c[e]&&this.pe(c[e])){var b=c[e].length;for(var d=0;d<b;d++){f[e][c[e][d]]=true}}}}return f};this.JJ=function(b){var d={};if(b&&this.pe(b)){var e=b.length;for(var c=0;c<e;c++){d[b[c]+""]=c}}return d};this.DF=function(e,d){var h=[];if(!this.pe(e)){e=this.j1(e)}var f=this.tx(this.j1(d));for(var g=0;g<e.length;g++){if(f.hasOwnProperty(e[g].toString())){h.push(e[g])}}return h};this.tv=function(e,b){if(this.pe(b)){var d=[];var f=b.length;for(var c=0;c<f;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.pb=function(a){return a&&typeof a==="function";var b={};return a&&b.toString.call(a)==="[object Function]"};this.pe=function(a){return Array.isArray(a)};this.M9=function(a){return a instanceof Object};this.rk=function(b){return this.a9(b).length==b.length};this.I6=function(b){var d=b.length;if(this.isR){for(var c=0;c<d;c++){if(this.M9(b[c])){return false}else{if(b[c]==null){continue}else{if(typeof(b[c])=="string"){if(b[c].toLowerCase()!="true"&&b[c].toLowerCase()!="false"&&b[c]!==""){return false}}}}}}else{for(var c=0;c<d;c++){if(this.M9(b[c])){return false}else{if(b[c]!==true&&b[c]!==false&&b[c]!==""&&b[c]!==null){return false}}}}return true};this.j1=function(a){return this.pe(a)?a:[a]};this.eS=function(j,d){if(this.data[j]&&this.data[j][d]){var g=this.data[j][d];var e=this.o5(g);var b={};var h=false;for(var f=0;f<e.length;f++){if(e[f]!=null&&(e[f].toString().match(/\[/)||e[f].toString().match(/\]/)||e[f].toString().match(/\{/)||e[f].toString().match(/\}/))){h=true;b[e[f]]=e[f].toString().replace(/\[/,"(").replace(/\]/,")").replace(/\{/,"(").replace(/\}/,")")}else{if(e[f]==null){b[e[f]]=null}}}if(h){for(var f=0;f<g.length;f++){if(g[f]){g[f]=b[g[f]]}}}}};this.NU=function(a){return this.pe(a)?a:this.M9(a)?Object.keys(a):[]};this.o5=function(a){if(this.pe(a)){return this.a9(a)}else{if(this.M9(a)){return Object.keys(a)}else{return[a]}}};this.a9=function(b){var g=b.length;var e=[];var f=new Set();for(var d=0;d<g;d++){var c=b[d];if(f.has(c)){continue}f.add(c);e.push(c)}return e};this.UW=function(a){if(this.pe(a)){return this.a9(a)}else{if(this.M9(a)){return this.a9(this.NU(a))}else{return[a]}}};this.gG=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.mc()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.ZM=function(c){var f=[];var d=this.pe(c);c=this.j1(c);var b=c.length;for(var e=0;e<b;e++){f.push(Number(c[e]))}return d?f:f[0]};this.pQ=function(d,c){return d.map(function(b,a){return[d[a],c[a]]})};this.Aj=function(b,a){return b.map(function(d,c){return d[a]})};this.Py=function(c,b){if(c==null||typeof(c)!="object"){return b}if(b==null||typeof(b)!="object"){return c}if(Object.assign){return Object.assign({},c,b)}else{for(var a in c){if(c.hasOwnProperty(a)){b[a]=c[a]}}return b}};this.vy=function(c,a){var b=this;if(c==null||typeof(c)!="object"){return c}if(this.pe(c)){return c.map(function(d){return b.pe(d)?d.slice():b.vy(d,a)})}else{if(a){return this.M9(c)?Object.assign({},c):this.c9(this.uY(c))}else{return this.c9(this.uY(c))}}};this.ZD=function(f,e){var d={bubble:true,gantt:true,sankey:true,tree:true,cola:true,colaConnector:true};if(this.M9(f)&&f.config&&f.config.decorations&&f.config.decorations.marker){var a=f.config.decorations.marker;for(var c=0;c<a.length;c++){if(a[c].text){a[c].text=a[c].text.replace(/\n/g,"__nl__")}}}if(typeof f==="string"){return f.replace(/"/g,"'")}else{if(f&&typeof f=="object"){if(f.constructor.name!="Object"&&f.constructor.name!="Array"){return undefined}}else{if(f&&typeof f!=="object"){return f}}}if(!f){return f}if(Object.prototype.toString.apply(f)==="[object Array]"){var g=[];var b=f.length;for(var c=0;c<b;c++){g[c]=this.ZD(f[c])}return g}var g={};for(c in f){if(typeof f[c]=="object"){if(f[c]&&f[c].constructor.name!="Object"&&f[c].constructor.name!="Array"){delete f[c];continue}}if(e&&d.hasOwnProperty(c)){continue}if((f[c]&&f.hasOwnProperty(c))||f[c]===false||f[c]===0){g[c]=this.ZD(f[c],c=="data")}}return g};this.eC=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.a0=function(b,a){if(a){return !isNaN(parseFloat(b))&&isFinite(b)}else{return b===null||b===undefined?true:!isNaN(parseFloat(b))&&isFinite(b)}};this.ZM=function(a){if(this.a0(a,true)){return a}else{return Number.NaN}};this.ZL=function(a){var e=a.length;for(var d=0;d<e;d++){var c=a[d].length;for(var b=0;b<c;b++){if(!this.a0(a[d][b])){return false}}}return true};this.mT=function(a){var c=a.length;for(var b=0;b<c;b++){if(!this.a0(a[b])){return false}}return true};this.ns=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null){return false}}return true};this.WB=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!==""){return false}}return true};this.tr=function(a){var c=function(e){if(toString.call(e)==="[object Date]"){return true}if(typeof e.replace==="function"){e.replace(/^\s+|\s+$/gm,"")}var g=/(^\d{1,4}?[\.|\\/|-]\d{1,2}?[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return g.test(e)};var d=a.length;for(var b=0;b<d;b++){if(a[b]!=null&&!c(a[b])){return false}}return true};this.tV=function(a){var c=a.length;for(var b=0;b<c;b++){if(a[b]!=null&&!CanvasXpress.dates.hasOwnProperty(a[b])){return false}}return true};this.Qy=function(a){var b=function(e){return CanvasXpress.countries.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]!=null&&!b(a[c])){return false}}return true};this.KY=function(a){var b=function(e){return CanvasXpress.usa.hasOwnProperty(e)};var d=a.length;for(var c=0;c<d;c++){if(a[c]!=null&&!b(a[c])){return false}}return true};this.ZY=function(a){var d=this;var c=function(f){return d.GC(f)};var e=a.length;for(var b=0;b<e;b++){if(a[b]!=null&&!c(a[b])){return false}}return true};this.XK=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.DJ=function(){if(this.graphType=="Heatmap"){if(this.meta.tree){return false}else{if(this.varOverlays.length+this.smpOverlays.length>0){return false}else{if(this.isMultidimensionalData){return false}}}return true}};this.FI=function(){var b=this.data.y.vars.length;var c=this.data.x?this.NU(this.data.x):[];var a=c.length;return(this.data.x||b+a==3)?true:false};this.Oo=function(j,g,l,d){var c={};var f=[];var e=[];var a=j.length;for(var b=0;b<a;b++){if(!c[j[b][g]]){c[j[b][g]]={}}c[j[b][g]][j[b][l]]=j[b][d];if(f.indexOf(j[b][l])==-1){f.push(j[b][l])}}f=this.P5(f);var k=[];k.push("Vars");k.push.apply(k,f);e.push(k);for(var h in c){k=[];k.push(h);a=f.length;for(var b=0;b<a;b++){k.push(c[h][f[b]]||"")}e.push(k)}return e};this.sm=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.cM=function(a,c){var d=[];var e=a.length;for(var b=0;b<e;b++){if(this.a0(a[b],c)){d.push(a[b])}}return d};this.xj=function(b,a,e){var d=[];if(a){var f=this.smpIndices.length;for(var c=0;c<f;c++){d.push(b[this.smpIndices[c]])}d=this.cM(d,true)}else{if(e){var f=this.varIndices.length;for(var c=0;c<f;c++){d.push(b[this.varIndices[c]])}d=this.cM(d,true)}else{d=this.cM(b,true)}}return d};this.RL=function(j,h,g,e){var d=[];var c=[];if(g){var b=this.smpIndices.length;for(var f=0;f<b;f++){var k=this.cM([j[this.smpIndices[f]],h[this.smpIndices[f]]],true);if(k.length==2){d.push(j[this.smpIndices[f]]);c.push(h[this.smpIndices[f]])}}}else{if(e){var b=this.varIndices.length;for(var f=0;f<b;f++){var k=this.cM([j[this.varIndices[f]],h[this.varIndices[f]]],true);if(k.length==2){d.push(j[this.varIndices[f]]);c.push(h[this.varIndices[f]])}}}else{var b=j.length;for(var f=0;f<b;f++){var k=this.cM([j[f],h[f]],true);if(k.length==2){d.push(j[f]);c.push(h[f])}}}}return[d,c]};this.u5=function(a){tmp=a.reverse();return tmp};this.p1=function(a){return((a+0.5)<<1)>>1};this.TS=function(){return this.isGroupedData&&(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Gantt")};this.vN=function(g){var c=g.split("/");var e=c[0].split(".");var d=["0","0","0","0"];if(!/\d+\.\d+\.\d+\.\d+/.test(c[1])){d=("1".repeat(parseInt(c[1],10))+"0".repeat(32-parseInt(c[1],10))).match(/.{1,8}/g);d=d.map(function(h){return parseInt(h,2)})}else{d=c[1].split(".").map(function(h){return parseInt(h,10)})}var b=d.map(function(h){return h^255});var a=e.map(function(i,h){return i&d[h]});var f=e.map(function(i,h){return i|b[h]});return[a.join("."),f.join(".")]};this.eN=function(a){return((a>>>24)+"."+(a>>16&255)+"."+(a>>8&255)+"."+(a&255))};this.Y3=function(a){return a.split(".").reduce(function(c,b){return(c<<8)+parseInt(b,10)},0)>>>0};this.s8=function(b){var d=function(o,q){var p=o[0];var n=o[1];var s=o[2];var r=o[3];p=a(p,n,s,r,q[0],7,-680876936);r=a(r,p,n,s,q[1],12,-389564586);s=a(s,r,p,n,q[2],17,606105819);n=a(n,s,r,p,q[3],22,-1044525330);p=a(p,n,s,r,q[4],7,-176418897);r=a(r,p,n,s,q[5],12,1200080426);s=a(s,r,p,n,q[6],17,-1473231341);n=a(n,s,r,p,q[7],22,-45705983);p=a(p,n,s,r,q[8],7,1770035416);r=a(r,p,n,s,q[9],12,-1958414417);s=a(s,r,p,n,q[10],17,-42063);n=a(n,s,r,p,q[11],22,-1990404162);p=a(p,n,s,r,q[12],7,1804603682);r=a(r,p,n,s,q[13],12,-40341101);s=a(s,r,p,n,q[14],17,-1502002290);n=a(n,s,r,p,q[15],22,1236535329);p=i(p,n,s,r,q[1],5,-165796510);r=i(r,p,n,s,q[6],9,-1069501632);s=i(s,r,p,n,q[11],14,643717713);n=i(n,s,r,p,q[0],20,-373897302);p=i(p,n,s,r,q[5],5,-701558691);r=i(r,p,n,s,q[10],9,38016083);s=i(s,r,p,n,q[15],14,-660478335);n=i(n,s,r,p,q[4],20,-405537848);p=i(p,n,s,r,q[9],5,568446438);r=i(r,p,n,s,q[14],9,-1019803690);s=i(s,r,p,n,q[3],14,-187363961);n=i(n,s,r,p,q[8],20,1163531501);p=i(p,n,s,r,q[13],5,-1444681467);r=i(r,p,n,s,q[2],9,-51403784);s=i(s,r,p,n,q[7],14,1735328473);n=i(n,s,r,p,q[12],20,-1926607734);p=f(p,n,s,r,q[5],4,-378558);r=f(r,p,n,s,q[8],11,-2022574463);s=f(s,r,p,n,q[11],16,1839030562);n=f(n,s,r,p,q[14],23,-35309556);p=f(p,n,s,r,q[1],4,-1530992060);r=f(r,p,n,s,q[4],11,1272893353);s=f(s,r,p,n,q[7],16,-155497632);n=f(n,s,r,p,q[10],23,-1094730640);p=f(p,n,s,r,q[13],4,681279174);r=f(r,p,n,s,q[0],11,-358537222);s=f(s,r,p,n,q[3],16,-722521979);n=f(n,s,r,p,q[6],23,76029189);p=f(p,n,s,r,q[9],4,-640364487);r=f(r,p,n,s,q[12],11,-421815835);s=f(s,r,p,n,q[15],16,530742520);n=f(n,s,r,p,q[2],23,-995338651);p=l(p,n,s,r,q[0],6,-198630844);r=l(r,p,n,s,q[7],10,1126891415);s=l(s,r,p,n,q[14],15,-1416354905);n=l(n,s,r,p,q[5],21,-57434055);p=l(p,n,s,r,q[12],6,1700485571);r=l(r,p,n,s,q[3],10,-1894986606);s=l(s,r,p,n,q[10],15,-1051523);n=l(n,s,r,p,q[1],21,-2054922799);p=l(p,n,s,r,q[8],6,1873313359);r=l(r,p,n,s,q[15],10,-30611744);s=l(s,r,p,n,q[6],15,-1560198380);n=l(n,s,r,p,q[13],21,1309151649);p=l(p,n,s,r,q[4],6,-145523070);r=l(r,p,n,s,q[11],10,-1120210379);s=l(s,r,p,n,q[2],15,718787259);n=l(n,s,r,p,q[9],21,-343485551);o[0]=e(p,o[0]);o[1]=e(n,o[1]);o[2]=e(s,o[2]);o[3]=e(r,o[3])};var k=function(v,p,o,n,u,r){p=e(e(p,v),e(n,r));return e((p<<u)|(p>>>(32-u)),o)};var a=function(p,o,v,u,n,r,q){return k((o&v)|((~o)&u),p,o,n,r,q)};var i=function(p,o,v,u,n,r,q){return k((o&u)|(v&(~u)),p,o,n,r,q)};var f=function(p,o,v,u,n,r,q){return k(o^v^u,p,o,n,r,q)};var l=function(p,o,v,u,n,r,q){return k(v^(o|(~u)),p,o,n,r,q)};var j=function(q){txt="";var t=q.length;var r=[1732584193,-271733879,-1732584194,271733878];var p;for(p=64;p<=q.length;p+=64){d(r,m(q.substring(p-64,p)))}q=q.substring(p-64);var o=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];for(p=0;p<q.length;p++){o[p>>2]|=q.charCodeAt(p)<<((p%4)<<3)}o[p>>2]|=128<<((p%4)<<3);if(p>55){d(r,o);for(p=0;p<16;p++){o[p]=0}}o[14]=t*8;d(r,o);return r};var m=function(o){var p=[];var n;for(n=0;n<64;n+=4){p[n>>2]=o.charCodeAt(n)+(o.charCodeAt(n+1)<<8)+(o.charCodeAt(n+2)<<16)+(o.charCodeAt(n+3)<<24)}return p};var h="0123456789abcdef".split("");var g=function(q){var p="";var o=0;for(;o<4;o++){p+=h[(q>>(o*8+4))&15]+h[(q>>(o*8))&15]}return p};var c=function(n){for(var o=0;o<n.length;o++){n[o]=g(n[o])}return n.join("")};var e=function(o,n){return(o+n)&4294967295};return c(j(this.uY(b)))}};CanvasXpress.prototype.initPlotUtils=function(){this.nW=function(){var n=this.canvasBoxColor;var m=this.height;var s=this.width;var g=this.left;var d=this.right;var p=this.bottom;var u=this.top;var j=this.marginLeft;var e=this.marginRight;var q=this.marginBottom;var a=this.marginTop;var o=this.layoutLeft;var k=this.layoutRight;var f=this.layoutBottom;var i=this.layoutTop;this.tA({p:["drawShape","rectangle",(j+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,n,"open"],t:"Size"});this.tA({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u)+(this.y/2),this.x,this.y,false,"red","open"],t:"Size"});this.tA({p:["drawShape","rectangle",(j+this.offsetX+g+this.x)+(d/2),(a+this.offsetY+u)+(this.y/2),d,this.y,false,"blue","open"],t:"Size"});this.tA({p:["drawShape","rectangle",(j+this.offsetX)+(g/2),(a+this.offsetY+u)+(this.y/2),g,this.y,false,"blue","open"],t:"Size"});this.tA({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY)+(u/2),this.x,u,false,"blue","open"],t:"Size"});this.tA({p:["drawShape","rectangle",(j+this.offsetX+g)+(this.x/2),(a+this.offsetY+u+this.y)+(p/2),this.x,p,false,"blue","open"],t:"Size"});return};this.P8=function(a){if(this.canvasBox&&(this.graphType!="Network"||a)){this.tA({p:["disableGradientTransparencyShadow"],t:"Size"});this.tA({p:["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.canvasBoxColor,"open"],t:"Size"});this.tA({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.Kn=function(){if(this.backgroundType.match("window")){this.tA({p:["disableGradientTransparencyShadow"],t:"Size"});var c=this.graphType.match(/Sankey/)?this.margin*6:0;var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(!this.layoutValid){this.tA({p:["drawShape","rectangle",this.width*0.5,this.height*0.5,this.width,this.height,this.background,this.background],t:"Size"})}if(this.backgroundType=="windowSolidGradient"){var d=this.S4(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b);this.tA({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,d,d],t:"Size"})}else{if(this.backgroundType=="windowImage"){this.tA({p:["drawShape","image",a+(this.x/2),b+(this.y/2),this.x-c,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{var e=this.graphType=="Treemap"&&this.isDOE?"rgba(0,0,0,0)":this.backgroundWindow;this.tA({p:["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x-c,this.y,e,e],t:"Size"})}}this.tA({p:["enableGradientTransparencyShadow"],t:"Size"})}};this.WP=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.It();alert(e);return false}return true};this.RG=function(){if(!this.isDOE){if(this.WP()){if(this.layoutValid&&this.data.l){if(this.segregateSamplesBy.length==0){}else{if(!this.data.l.smps){this.Zv(this.segregateSamplesBy,true)}}if(this.segregateVariablesBy.length==0){}else{if(!this.data.l.vars){this.Je(this.segregateVariablesBy,true)}}}else{if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.Xz(true)}else{if(this.segregateSamplesBy.length>0){this.Zv(this.segregateSamplesBy,true)}else{if(this.segregateVariablesBy.length>0){this.Je(this.segregateVariablesBy,true)}}}}}}};this.RV=function(){if(this.smpOverlays.length>0){var a=[];for(var c=0;c<this.smpOverlays.length;c++){if(this.smpOverlays[c]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[c]))){a.push(this.smpOverlays[c])}else{if(this.qv(this.smpOverlays[c])>=0){this.data.x[this.smpOverlays[c]]=this.data.y.data[this.qv(this.smpOverlays[c])];this.zN("x",this.smpOverlays[c]);a.push(this.smpOverlays[c])}}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var c=0;c<this.varOverlays.length;c++){if(this.varOverlays[c]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[c]))){a.push(this.varOverlays[c])}else{if(this.uL(this.varOverlays[c])>=0){var e=[];var d=this.uL(this.varOverlays[c]);for(var b=0;b<this.data.y.vars.length;b++){e.push(this.data.y.data[b][d])}this.data.z[this.varOverlays[c]]=e;this.zN("z",this.varOverlays[c]);a.push(this.varOverlays[c])}}}this.varOverlays=a}};this.Ce=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}};this.tl=function(){return this.colorBy||this.shapeBy||this.sizeBy||this.lineBy||this.patternBy};this.AO=function(){var a=this;var b=function(){if(a.isTransitionOn){CanvasXpress.transitions[a.target].push([a.isSegregatable]);return true}else{return false}};return !b()&&!this.isDOE&&!CanvasXpress.graphTypes.NonSegregatable.includes(this.graphType)};this.uf=function(){if(this.graphType.match(/Gantt|Circular|Fish|Meter|Network|Correlation|Genome|Pie|Scatter3D|TagCloud|Venn/)||this.is3DPlot||this.scatterPlotMatrix||this.isContour||this.isOncoprint){return false}return true};this.W6=function(){if(this.decorations.length){var c=this.meta.data.nodes;var a=[];for(var b=0;b<this.decorations.length;b++){if(c.hasOwnProperty(this.decorations[b])){a.push(this.decorations[b])}}this.decorations=a}}};CanvasXpress.prototype.initConfigUtils=function(){this.VQ=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.yQ=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.SZ=function(a){return a?a.substring(a.lastIndexOf("/")+1):"canvasXpress"};this.R2=function(){var b=0;var a;this.b9();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.HU(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.HU(this.subtitleFont))*a.length}b+=this.margin}return b};this.b9=function(){this.QK(this.width,"titleFont");this.ra(this.title,"titleFont",this.width);this.QK(this.width,"subtitleFont");this.ra(this.subtitle,"subtitleFont",this.width)};this.pP=function(){this.b9();if(this.title){var a=this.title.split(/\n/);var e=this.marginTop+((this.HU(this.titleFont)+this.margin)*a.length);if(this.subtitle){a=this.subtitle.split(/\n/);e+=(this.HU(this.subtitleFont)+this.margin)*a.length}if(this.titleColorBackground){this.tA({p:["drawShape","rectangle",this.width/2,e/2,this.width,e,this.titleColorBackground,this.titleColorBackground],t:"Titles"})}var c=this.Db(this.title,this.titleFont);var b=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;var f=this.marginTop+(c/2);this.tA({p:["drawText",this.title,b,f,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"],t:"Titles"});if(this.subtitle){var d=this.Db(this.subtitle,this.subtitleFont);b=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.tA({p:["drawText",this.subtitle,b,f+(c/2)+this.margin+(d/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"],t:"Titles"})}}};this.Pl=function(){var b=0;var a;this.Xo();if(this.citation){a=this.citation.split(/\n/);b+=(this.margin+this.HU(this.citationFont))*a.length;b+=this.margin}return b};this.Xo=function(){var b=20*this.printMagnification;this.QK(this.width,"citationFont",b);var a=this.DU(this.citation,this.citationFont);var c=1;while(a>this.width||c>9){b/=2;this.QK(this.width,"citationFont",b);a=this.DU(this.citation,this.citationFont);c++}return};this.zD=function(){if(this.citation){var a=this.width-this.margin;var b=this.height-this.margin;this.tA({p:["drawText",this.citation,a,b,this.citationFont,this.citationColor,"right","bottom"],t:"Citations"})}};this.b3=function(){this.q4();return this.HU(this.font)};this.q4=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.QK=function(f,c,a){if(!f||!c){return}var b={titleFont:18,subtitleFont:14,decorationsTextFont:12,axisTickFont:12,axisTitleFont:13,smpLabelFont:12,smpTitleFont:(this.graphType=="Meter"?15:13),varLabelFont:12,varTitleFont:13,legendTextFont:12,legendTitleFont:13,dataLabelFont:12,overlayFont:12,citationFont:8,motionCurrentFont:60};var e=c.replace("Font","ScaleFontFactor");this[c+"Size"]=parseInt(Math.min(Math.max(parseInt(((f/80)+b[c])*this[e]),this.minTextSize),a||this.maxTextSize));this[c]=this[c+"Style"]+" "+this[c+"Size"]+"px "+this.fontName};this.ra=function(b,c,g){if(b&&c&&g){var e=this.HU(this[c]);var a=this.DU(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.DU(b,this[c])}}};this.cq=function(d){if(this.adjustAspectRatio&&this.graphType!="Genome"){var a=this.meta.config.orig;var e=["ringSeparation","roundedPolygonRadius","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","xAxisHistogramHeight","xAxisRugHeight","yAxisHistogramHeight","yAxisRugHeight","dataPointSize","layoutLabelBoxThickness"];var f=["legendTextMargin","legendTitleMargin","axisTickMargin","axisTitleMargin","xAxisTickGuideLength","yAxisTickGuideLength","zAxisTickGuideLength"];for(var b=0;b<f.length;b++){e.push(f[b])}if(this.adjustAspectRatioHeatmapIndicator){e.push("heatmapIndicatorHeight");e.push("heatmapIndicatorWidth")}if(d){for(var b=0;b<e.length;b++){if(a[e[b]]){this[e[b]]=a[e[b]];delete (a[e[b]])}}}else{for(var b=0;b<e.length;b++){if(!a[e[b]]){a[e[b]]=this[e[b]]}}for(var b=0;b<e.length;b++){this[e[b]]=Number(Math.max(0.5,Math.min(this.width,this.height)*this[e[b]]/833).toFixed(1))}}}};this.lX=function(){if(this.adjustAspectRatio&&this.graphType!="Genome"){if(this.graphType=="Network"&&!this.isLayoutDone){this.setTimeout(this.resetAspectRatioProperties,50)}else{this.cq(true)}}};this.h0=function(b,e){var h;if(this.isGroupedData){var a=this.data.w.grps[e];if(a){this.isGroupedData=false;h=this.GF(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.GF(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.background}}this.isGroupedData=true}else{h=this.GF(b,e,"colorBy")}}else{h=this.GF(b,e,"colorBy")}return h};this.dX=function(a,c){if(this.pe(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varLabelColor};this.ej=function(c,b){if(this.pe(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpLabelColor};this.hJ=function(e,a,f){if(this.pe(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==e){return this.nodeHighlightColor}}}else{if(this.highlightNode==e){return this.nodeHighlightColor}}var d=this.QS(e);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!d;return d&&this.selectionMode=="highlight"?this.selectionColor:b&&a?this.xh(a,0.1,true):a?a:f?false:this.nodeColor};this.Pw=function(f,d,a){if(this.pe(this.highlightNode)){for(var c=0;c<this.highlightNode.length;c++){if(this.highlightNode[c]==f||this.highlightNode[c]==d){return this.nodeHighlightColor}}}else{if(this.highlightNode==f||this.highlightNode==d){return this.nodeHighlightColor}}var e=this.QS(f)||this.QS(d);var b=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!e;return e&&this.selectionMode=="highlight"?this.selectionColor:b?this.xh(a,0.1,true):a?a:this.nodeColor};this.VN=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.qv(a);if(b>-1){return this.GF(b,false,"colorVarDendrogramBy")}}return this.dX(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.uL(c);if(b>-1){return this.GF(false,b,"colorSmpDendrogramBy")}}return this.ej(c,true)}};this.cF=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.nD=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.il=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.Np=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.Tx=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.ZD(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.t5=function(){for(var a in this.binConfigurations){return true}return false};this.PW=function(){var b=this.$h;var i=b("666163746f7279");var g=b("636c69656e74");var e=b("656e636f6465");var j=b("76616c6964");var k=b("757365724964");var a=b("76657273696f6e");var f=b("68726566");var d=b("736574506978656c496d616765");CanvasXpress[i][g]=this[e]([CanvasXpress[i][j]||0,this[k],CanvasXpress[i][a],this[f]].join("::"));this[d]()};this.XN=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.dl=function(f,e){if(f){var c=this.treemapBorderWidth&&!this.isDOE?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpLabelFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.GG=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.dl(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.mJ=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.dl(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.er=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.GG(a,b,c,d)}else{return this.mJ(a,b,c,d)}};this.NH=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.dl(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.er(c,b,f,h)}return}var d=a[0];if(this.XN(c,b)>=this.XN([d].concat(c),b)){this.NH(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.er(c,b,f,h);this.NH(a,[],g.orientation,g,d.title)}};this.hC=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.NH(a.slice(1),[a[0]],c,g,a[0].title)};this.NM=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.hC(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.NM(a,d)}}return b};this.Zh=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){var e=1;if(this.tagCloudShapeFunction!=="circle"){e=this.tagCloudShapeFunction(c/b*2*Math.PI)}d.push([this.tagCloudGridCenter[0]+a*e*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*e*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.ub=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.mc()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.mc()*Math.PI)};this.NB=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=this.$cX("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.DU(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.dC=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.JG=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.UR=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.JG(e+a[b][0],c+a[b][1])}};this.Ad=function(c,i,g,d){var k=this;var m=this.ub();var e=this.NB(c,i,m);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var j=this.xh(g,0,true);var f=this.ve();var p=this.W4();while(a--){var n=this.Zh(this.tagCloudGridMaxRadius-a);n=[].concat(n);this.gG(n);var h=n.some(function o(q){var w=Math.floor(q[0]-e.gw/2);var v=Math.floor(q[1]-e.gh/2);var z=e.gw;var s=e.gh;var r=e.fontSize+"px "+k.fontName;var l="1px "+k.fontName;if(!k.dC(w,v,z,s,e.occupied)){return false}var u=((w+e.gw/2)*k.tagCloudTextGridSize);var t=((v+e.gh/2)*k.tagCloudTextGridSize);k.renderTagCloud.push([["drawText",c,u+f,t+p,r,g,"center","middle",-m],d,false,null,false,[k.width/2,k.height/2,l,j,-Math.PI*2]]);k.UR(w,v,e);return true});if(h){return true}}return false};this.Kj=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize);this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.eO()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.eO=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.RE(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.x,this.y));if(h>b){this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.x*this.y)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.Ov=function(g){var e=this.randomSeed;this.renderTagCloud=[];this.Kj(g);var j=this.varIndices[0];for(var b=0;b<this.smpIndices.length;b++){var a=this.smpIndices[b];var h=this.RE(j,a);var k=this.colorBy?this.GF(j,a,"colorBy"):this.foreground;if(!this.Ad(this.data.y.smps[a],h,k,[j,a])){this.k2();this.renderTagCloud=[];if(this.pseudoRandom){this.randomSeed=e}this.Ov(0.9);break}}if(this.pseudoRandom){this.randomSeed=e}};this.pv=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.f6=function(b,a,g){var i;if((this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)||(this.plotStyle=="open"&&!g)){i=this.kK(b,true)}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){var d=this.layoutValid?this.data.y.vars.length*this.data.y.smps.length:this.varIndices.length*this.smpIndices.length;if(d>this.dotplotOutlineThreshold){i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor}else{i=this.graphType=="Boxplot"&&!this.showViolinBoxplot?this.boxplotBorderColor:this.objectBorderColor?this.objectBorderColor:this.kK(b,true)}}else{i=this.objectBorderColor&&this.graphType!="Map"?this.objectBorderColor:this.kK(b,true)}}if(a){var f=this.QS(a);var e=this.C3(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;i=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.xh(i,0.1,true):i}return i};this.Nb=function(b,a,g){var i=(this.plotStyle=="open"&&!g)&&(!this.isDOE||!this.layoutCurrent);var j=this.xh(b,(i?0:this.objectColorTransparency),true);if(a){var f=this.QS(a);var e=this.C3(a[0]);var d=this.selectionMode=="ghost"&&CanvasXpress.selector.selections&&!f;j=e?this.varHighlightColor:f&&this.selectionMode=="highlight"?this.selectionColor:d?this.xh(j,0.1,true):j;if(this.transparency!=null){j=this.xh(this.kK(j,true),this.transparency,true)}}return j};this.C3=function(a){if(this.highlightVar.length&&a!=null){var b=this.data.y.vars[a];return this.highlightVar.includes(b)}};this.hD=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.eG=function(){delete (this.cacheColors)};this.Cl=function(){if(!this.cacheColors){this.cacheColors={}}if(!this.cacheColors[this.colorScheme]){this.cacheColors[this.colorScheme]={}}};this.b6=function(n,q,m){this.Cl();var e={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.IZ(n)};var b=this.cr(n.length);for(var l=0;l<n.length;l++){var h=q?this.varIndices[l]:l;var a=n[h]/e.tot;var g=q?this.data.y.vars[h]:l;var o;if(m&&m[l%m.length]){o=m[l%m.length]}else{if(this.cacheColors[this.colorScheme].hasOwnProperty(g)){o=this.cacheColors[this.colorScheme][g]}else{o=this.pieColors[l]||b[l%b.length];this.cacheColors[this.colorScheme][g]=o}}if(this.a0(a,true)){e.data[h]=a;e.raw[h]=n[h];if(l>=this.maxPieSectors-1){e.oprc+=a;e.idso.push(h);e.no++}else{e.ids.push(h)}e.cols.push(o)}}if(e.no){e.ids.push(-1)}return e};this.zK=function(u,h,g,t,I,w){var f=this;var q=function(){for(var a=0;a<u.ids.length;a++){if(u.data[u.ids[a]]&&u.data[u.ids[a]]>-1&&!f.a0(u.data[u.ids[a]],true)){return false}}return true};if(q()){var z,d;var m=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var A=this.pieSegmentLabels=="inside"?t-(t/3):t+(t/6);var G=0;var C=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var o=this.graphType=="Network"||this.graphType!="Pie"?I[E]:k>-1?[k,C]:u.idso;var e=this.graphType=="Map"?u.cols[E]:this.Nb(u.cols[E],o,this.isDOE);var D=this.f6(e,this.graphType=="Map"?E:o);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var H=(z+d)/2;var B=(d-z)/32;var J=this.graphType=="Network"||this.graphType=="Map"?"Decorations":this.graphType!="Pie"?"Overlays":"Data";var D=this.pieType=="separated"?this.background:this.f6(e);if(this.graphType=="Network"||this.graphType=="Map"){this.tA({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:(this.graphType=="Map"?I[0]:I[E]),m:w,t:J,h:this.vK(this.graphType=="Map"?I[0][0]:I[E])})}else{if(this.graphType!="Pie"){this.tA({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I[E],t:J})}else{if(k>-1){I=this.isDOE?[k,C,"Facet-"+this.layoutCurrent]:[k,C];this.tA({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:I,t:J,h:this.vK(I[0])})}else{this.tA({p:["drawShape","pie",h,g,(t*2),t,e,D,"closed",false,1,false,false,z,d],i:u.idso,t:J})}}}var F=u.ids.length>1?h-Math.sin(H-(Math.PI/2))*A:h;var b=u.ids.length>1?g+Math.cos(H-(Math.PI/2))*A:g;if(this.graphType!="Network"&&this.graphType!="Map"&&this.showPieValues&&(d-z)>0.05){if(this.pieLabelType=="value"){this.tA({p:["drawText",u.raw[k],F,b,this.axisTickFont,this.axisTickColor,"center","middle"],t:J})}else{this.tA({p:["drawText",this.aL("%."+this.pieSegmentPrecision+"f",v*100)+"%",F,b,this.axisTickFont,this.axisTickColor,"center","middle"],t:J})}}G+=v}G=0;d=null;if(u.ids.length>1&&this.graphType!="Map"){for(var E=0;E<u.ids.length;E++){var k=u.ids[E];var v=k>-1?u.data[k]:u.oprc;var e=this.Nb(u.cols[E]);z=d!=null?parseFloat(d):parseFloat((Math.PI*(2*G))+m);d=parseFloat(z+(Math.PI*(2*(v))));var D=this.pieType=="separated"?this.background:this.f6(e);this.tA({p:["drawShape","pie",h,g,(t*2),t,false,D,"open",false,this.pieSegmentSeparation,false,false,z,d],s:true,t:J});G+=v}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1&&this.graphType!="Map"){this.tA({p:["drawShape","circle",h,g,t*this.pieInnerRadius*2,t*this.pieInnerRadius*2,this.background,this.background,"closed"],t:J})}}};this.Be=function(ai,ah,Z,R,O,U,Q,L,Y,W,al,V,ap,X,af,ab,N,ao){var P,M,ag,T;var K=this;var j=function(a){return K.isGroupedData?N.smps[K.data.w.smps[K.grpIndices[a]]]:N.smps[K.data.y.smps[K.smpIndices[a]]]};var S=this.variableSpace/2;var ae=O/2;var ad=ao?"Overlays":this.graphType=="Network"?"Decorations":"Data";var am=0.0675;var H=am;if(W=="vertical"||this.graphType=="Network"){for(var ac=0;ac<ai.length;ac++){P=((ai[ac]-Y)*Q)-L;var aj;var aa=(N&&N.cap&&N.cap[j(ac)])||this.barType=="arrow"?"arrow":this.useRoundRectangles&&P>0?"roundrectt":this.useRoundRectangles?"roundrectb":"rectangle";var A=this.Nb(N?N.fill[j(ac)]:al[ac],ap[ac]);var an=O-this.variableSpace>5?this.f6(A,ap[ac]):A;var J=this.vK(ap[ac][0],ap[ac][1]);if(this.a0(P,true)&&H>=am){if(this.barPath){var B=this.xh(this.barPathColor||A,this.barPathTransparency);this.tA({p:["drawShape","rectangle",(Z+S)+((O-this.variableSpace)/2),L+(this.y/2),O-this.variableSpace,this.y*2,B,B],t:"Decorations"})}if(P<0){aj=this.tA({p:["drawShape",aa,(Z+S)+((O-this.variableSpace)/2),R+(-P/2),O-this.variableSpace,-P,A,an,V[ac],false,false,af],i:ap[ac],m:X,t:ad,h:J})}else{aj=this.tA({p:["drawShape",aa,(Z+S)+((O-this.variableSpace)/2),R-(P/2),O-this.variableSpace,P,A,an,V[ac],false,false,af],i:ap[ac],m:X,t:ad,h:J})}ag=R-P;T=Z+ae;if(ah[ac]&&this.a0(ah[ac],true)){M=(ah[ac]/2)*Q;this.tA({p:["drawLine","error",T,ag,T,ag-M,this.errorBarsColor,-ae,"butt"],g:aj,t:ad,h:J});this.tA({p:["drawLine","error",T,ag,T,ag+M,this.errorBarsColor,-ae,"butt"],g:aj,t:ad,h:J})}if(N){var I=j(ac);for(var ak in N){if(ak!="cap"&&ak!="high"&&ak!="color"&&ak!="fill"){if(N[ak][I]){for(var F=0;F<N[ak][I].length;F++){var E=((N[ak][I][F][0]-Y)*Q)-L;var G=((N[ak][I][F][1]-Y)*Q)-L;var D=(Z+S)+((O-this.variableSpace)/2);this.tA({p:["drawShape",this.shapes[0],D,R-E,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J});if(!this.a0(G,true)){G=P-this.margin}else{this.tA({p:["drawShape",this.shapes[1],D,R-G,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J})}this.tA({p:["drawLine","line",D,R-E,D,R-G,N.color[ak],this.margin],g:aj,t:ad,h:J})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.tA({p:["drawText",this.qo(ai[ac]),T,R-(P+(this.margin/4)),this.smpLabelFont,A,"center","bottom"],g:aj,t:ad,h:J})}H=0}Z+=this.pe(U)?U[ac+1]-U[ac]:U;H+=this.pe(U)?U[ac+1]-U[ac]:U}}else{for(var ac=0;ac<ai.length;ac++){P=((ai[ac]-Y)*Q)-L;var aj;var aa=(N&&N.cap&&N.cap[j(ac)])||this.barType=="arrow"?"arrow":!this.useRoundRectangles?"rectangle":ab||P<0?"roundrectl":"roundrectr";var A=this.Nb(N?N.fill[j(ac)]:al[ac],ap[ac]);var an=O-this.variableSpace>5?this.f6(A,ap[ac]):A;var J=this.vK(ap[ac][0],ap[ac][1]);if(this.a0(P,true)&&H>=am){if(this.barPath){var B=this.xh(this.barPathColor||A,this.barPathTransparency);this.tA({p:["drawShape","rectangle",L+(this.x/2),(R+S)+((O-this.variableSpace)/2),this.x*2,O-this.variableSpace,B,B],t:"Decorations"})}if(P<0){if(ab){aj=this.tA({p:["drawShape",aa,((Z+ab)-L)+(-P/2),(R+S)+((O-this.variableSpace)/2),-P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}else{aj=this.tA({p:["drawShape",aa,(Z+P)+(-P/2),(R+S)+((O-this.variableSpace)/2),-P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}}else{if(ab){aj=this.tA({p:["drawShape",aa,((Z+ab)-(P+L))+(P/2),(R+S)+((O-this.variableSpace)/2),P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}else{aj=this.tA({p:["drawShape",aa,Z+(P/2),(R+S)+((O-this.variableSpace)/2),P,O-this.variableSpace,A,an,V[ac],aa=="arrow"?true:false,false,af],i:ap[ac],m:X,t:ad,h:J})}}ag=ab?(Z+ab)-(P+L):Z+P;T=R+ae;if(ah[ac]&&this.a0(ah[ac],true)){M=(ah[ac]/2)*Q;this.tA({p:["drawLine","error",ag,T,ag+M,T,this.errorBarsColor,ae,"butt"],g:aj,t:ad,h:J});this.tA({p:["drawLine","error",ag,T,ag-M,T,this.errorBarsColor,ae,"butt"],g:aj,t:ad,h:J})}if(N){var I=j(ac);for(var ak in N){if(ak!="cap"&&ak!="high"&&ak!="color"&&ak!="fill"){if(N[ak][I]){for(var F=0;F<N[ak][I].length;F++){var E=((N[ak][I][F][0]-Y)*Q)-L;var G=((N[ak][I][F][1]-Y)*Q)-L;var C=(R+S)+((O-this.variableSpace)/2);this.tA({p:["drawShape",this.shapes[0],Z+E,C,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J});if(!this.a0(G,true)){G=P-this.margin}else{this.tA({p:["drawShape",this.shapes[1],Z+G,C,O/2,O/2,N.color[ak],N.color[ak]],g:aj,t:ad,h:J})}this.tA({p:["drawLine","line",Z+E,C,Z+G,C,N.color[ak],this.margin],g:aj,t:ad,h:J})}}}}}if(this.showDataValues&&this.barType!="lollipop"){this.tA({p:["drawText",this.qo(ai[ac]),ag+(this.margin/4),T,this.smpLabelFont,al[ac],"left","middle"],g:aj,t:ad,h:J})}H=0}R+=this.pe(U)?U[ac+1]-U[ac]:U;H+=this.pe(U)?U[ac+1]-U[ac]:U}}};this.pn=function(aj,ai,aa,T,R,af,S,Z,X,al,V,U,ao,ah,ag,ab,I,an,y){var O=this;var M=function(){var b=[[],[]];if(X=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var v=function(aM,aL,aC,ax,au,aH,aw,aB,aA,aN,az,ay,aO,aK,aJ,aD,av,b,aF){var z=0;var at=aF[0].xy;var aI=[];var n=[];var p=[];var ar=[];var aG=[];for(var aE=0;aE<aF.length;aE++){if(aF[aE].split!=z){O.pn(aI,n,(aA=="vertical"?at:aC),(aA=="vertical"?ax:at),au,p,aw,aB,aA,aN,ar,ay,aG,aK,aJ,aD,av,b);z=aF[aE].split;at=aF[aE].xy;aI=[aM[aE]];n=[aL[aE]||null];p=[aH[aE]||at];ar=[az[aE]];aG=[aO[aE]]}else{aI.push(aM[aE]);n.push(aL[aE]||null);p.push(aH[aE]||aF[aE].xy);ar.push(az[aE]);aG.push(aO[aE])}}O.pn(aI,n,(aA=="vertical"&&O.graphType!="ParallelCoordinates"?at:aC),(aA=="vertical"?ax:at),au,p,aw,aB,aA,aN,ar,ay,aG,aK,aJ,aD,av,b)};var W,C,B,A,j,aq,ap,ak,N,D,L;var Q=null;var F=null;var K=R/2;var J=this.dataPointSize*0.5;var am=V=="open"?al:this.objectBorderColor||al;var Y=aj.length-1;var P=[[],[]];var r=[[],[]];var ac=[];var E=this.qv(I);var ae=an?"Overlays":"Data";var G=this.lineThickness;if(y){return v(aj,ai,aa,T,R,af,S,Z,X,al,V,U,ao,ah,ag,ab,I,an,y)}else{if(X=="vertical"){C=aa;B=aa+(this.pe(af)?af[1]-af[0]:af);if(Q==null){Q=C}if(this.QS([E])){al=this.varHighlightColor;G+=2}for(var ad=1;ad<aj.length;ad++){W=ad-1;if(this.M9(S)){j=T-((aj[W]-S[W].min)*S[W].units);aq=T-((aj[ad]-S[ad].min)*S[ad].units)}else{j=T-((aj[W]-Z)*S);aq=T-((aj[ad]-Z)*S)}if(F==null){F=j}L=this.lineBy?this.vK(false,false,"Property:"+this.lineBy+":"+ao[W][2]+":x"):false;if(this.a0(j,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){ak=this.tA({p:["drawShape",U,C,j,J,J,al,am,V[W],false,false,ag],i:ao[W],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[W][0],ao[W][1])})}else{ak=this.tA({p:["drawShape","sphere",C,j,J,J,this.xh(al,0,true),"rgba(0,0,0,0)",V[W],false,false,ag],i:ao[W],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[W][0],ao[W][1])})}if(this.showDataValues){this.tA({p:["drawText",this.qo(aj[W]),C,j-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:ae,h:this.lineBy?L:this.vK(ao[W][0],ao[W][1])})}if(!N){N=ak}if(this.a0(ai[W],true)){ap=(ai[W]/2)*this.M9(S)?S[W].units:S;if(this.lineErrorType=="bar"){this.tA({p:["drawLine","error",C,j,C,j+ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)});this.tA({p:["drawLine","error",C,j,C,j-ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)})}else{r[0].push([C,C]);r[1].push([j+ap,j-ap]);ac.push([C,j])}}if(this.lineType=="spline"){P[0].push(C);P[1].push(j)}}if((this.lineType!="spline"&&this.a0(j,true)&&this.a0(aq,true))||aj.length<3){ak=this.tA({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(V[W]||"solid"):this.lineType,C,j,B,aq,al,G,"butt",false,false,ag],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)})}else{if(this.lineType=="spline"&&!this.a0(aq,true)){ak=this.tA({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)});P=[[],[]];Q=null;F=null}}if(!N){N=ak}if(r[0].length>0&&!this.a0(aq,true)){var x=this.xh(al,0.3,true);if(this.lineType=="spline"){this.tA({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}else{var H=M();this.tA({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}r=[[],[]];ac=[]}C=B;B+=(this.pe(af)?af[ad+1]-af[ad]:af)}L=this.lineBy?this.vK(false,false,"Property:"+this.lineBy+":"+ao[Y][2]+":x"):false;if(this.a0(aq,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){ak=this.tA({p:["drawShape",U,C,aq,J,J,al,am,V[Y],false,false,ag],i:ao[Y],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[Y][0],ao[Y][1])})}else{ak=this.tA({p:["drawShape","sphere",C,aq,J,J,this.xh(al,0,true),"rgba(0,0,0,0)",V[Y],false,false,ag],i:ao[Y],m:ah,g:N,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[Y][0],ao[Y][1])})}if(this.showDataValues){this.tA({p:["drawText",this.qo(aj[Y]),C,aq-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:ae,h:this.lineBy?L:this.vK(ao[Y][0],ao[Y][1])})}if(!N){N=ak}if(this.a0(ai[Y],true)){ap=(ai[Y]/2)*this.M9(S)?S[Y].units:S;if(this.lineErrorType=="bar"){this.tA({p:["drawLine","error",C,aq,C,aq+ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.vK(E)});this.tA({p:["drawLine","error",C,aq,C,aq-ap,al,-K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.vK(E)})}else{if(ad==aj.length){r[0].push([C,C]);r[1].push([aq+ap,aq-ap]);ac.push([C,aq])}}}if(this.lineType=="spline"){P[0].push(C);P[1].push(aq)}}if(this.lineType=="spline"){ak=this.tA({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)})}if(!N){N=ak}if(r[0].length>0){var x=this.xh(al,0.3,true);if(this.lineType=="spline"){this.tA({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}else{var H=M();this.tA({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}}}else{j=T;aq=T+(this.pe(af)?af[1]-af[0]:af);if(F==null){F=j}for(var ad=1;ad<aj.length;ad++){W=ad-1;if(this.M9(S)){C=ab?aa+ab-((aj[W]-S[W].min)*S[W].units):aa+((aj[W]-S[W].min)*S[W].units);B=ab?aa+ab-((aj[ad]-S[ad].min)*S[ad].units):aa+((aj[ad]-S[ad].min)*S[ad].units)}else{C=ab?aa+ab-((aj[W]-Z)*S):aa+((aj[W]-Z)*S);B=ab?aa+ab-((aj[ad]-Z)*S):aa+((aj[ad]-Z)*S)}if(Q==null){Q=C}L=this.lineBy?this.vK(false,false,"Property:"+this.lineBy+":"+ao[W][2]+":x"):false;if(this.a0(C,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){this.tA({p:["drawShape",U,C,j,J,J,al,am,V[W],false,false,ag],i:ao[W],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[W][0],ao[W][1])})}else{this.tA({p:["drawShape","sphere",C,j,J,J,this.xh(al,0,true),"rgba(0,0,0,0)",V[W],false,false,ag],i:ao[W],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[W][0],ao[W][1])})}if(this.showDataValues){this.tA({p:["drawText",this.qo(aj[W]),C,j-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:ae,h:this.lineBy?L:this.vK(ao[W][0],ao[W][1])})}if(this.a0(ai[W],true)){A=(ai[W]/2)*this.M9(S)?S[W].units:S;if(this.lineErrorType=="bar"){ak=this.tA({p:["drawLine","error",C,j,C+A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.vK(E)});if(!N){N=ak}this.tA({p:["drawLine","error",C,j,C-A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.vK(E)})}else{r[0].push([C+A,C-A]);r[1].push([j,j]);ac.push([C,j])}}if(this.lineType=="spline"){P[0].push(C);P[1].push(j)}}if((this.lineType!="spline"&&this.a0(C,true)&&this.a0(B,true))||aj.length<3){ak=this.tA({p:["drawLine",this.lineDecoration=="pattern"||this.patternBy?(V[W]||"solid"):this.lineType,C,j,B,aq,al,G,"butt",false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)})}else{if(this.lineType=="spline"&&!this.a0(B,true)){ak=this.tA({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)});P=[[],[]];Q=null;F=null}}if(!N){N=ak}if(r[1].length>0&&!this.a0(B,true)){var x=this.xh(al,0.3,true);if(this.lineType=="spline"){this.tA({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}else{var H=M();this.tA({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}r=[[],[]];ac=[]}j=aq;aq+=(this.pe(af)?af[ad+1]-af[ad]:af)}L=this.lineBy?this.vK(false,false,"Property:"+this.lineBy+":"+ao[Y][2]+":x"):false;if(this.a0(B,true)){if(this.lineDecoration&&this.lineDecoration!="pattern"&&U){this.tA({p:["drawShape",U,B,j,J,J,al,am,V[Y],false,false,ag],i:ao[Y],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[Y][0],ao[Y][1])})}else{this.tA({p:["drawShape","sphere",B,j,J,J,this.xh(al,0,true),"rgba(0,0,0,0)",V[Y],false,false,ag],i:ao[Y],m:ah,b:[Q,F],t:ae,h:this.lineBy?L:this.vK(ao[Y][0],ao[Y][1])})}if(this.showDataValues){this.tA({p:["drawText",this.qo(aj[Y]),B,j-this.margin,this.smpLabelFont,this.smpLabelColor,"center","bottom"],t:ae,h:this.lineBy?L:this.vK(ao[Y][0],ao[Y][1])})}if(this.a0(ai[Y],true)){A=(ai[Y]/2)*this.M9(S)?S[Y].units:S;if(this.lineErrorType=="bar"){ak=this.tA({p:["drawLine","error",B,j,B+A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.vK(E)});if(!N){N=ak}this.tA({p:["drawLine","error",B,j,B-A,j,al,K,"butt"],i:["Line:"+I+":"+E],g:N,t:ae,h:this.lineBy?L:this.vK(E)})}else{r[0].push([B+A,B-A]);r[1].push([j,j]);ac.push([B,j])}}if(this.lineType=="spline"){P[0].push(B);P[1].push(j)}}if(this.lineType=="spline"){ak=this.tA({p:["drawLine","spline",P[0],P[1],false,false,al,G,false,false,false,ag],i:["Line:"+I+":"+E],b:[Q,F],t:ae,h:this.lineBy?L:this.vK(E)})}if(!N){N=ak}if(r[1].length>0){var x=this.xh(al,0.3,true);if(this.lineType=="spline"){this.tA({p:["drawShape","confidence",r[0],r[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}else{var H=M();this.tA({p:["drawShape","path",H[0],H[1],false,false,x,x,"closed"],i:["Line-Error:"+I+":"+E],b:ac,t:ae,h:this.lineBy?L:this.vK(E)})}}}}};this.Rd=function(U,N,F,C,W,I,R,E,y,J,V,H,X,L,O,S,T){var m=F;var B=N;var s=this;var Y=T?"Overlays":"Data";var h=function(a){var c=0;if(s.dodgeBy){for(var b=0;b<U.length;b++){if(U[b]!=0){c++}}}return a/c};var Q=function(c,e,b,d,a){return s.NM(c,{width:d,height:a,left:e,top:b})};var A=h(C);if(J=="vertical"){F=m-y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P==U.length-1&&this.useRoundRectangles?"roundrectt":"rectangle";var x=this.Nb(V[P],X[P]);var r=C>5?this.f6(x,X[P]):x;if(this.graphType=="Network"){this.tA({p:["drawShape",M,N+(C/2),F-(D/2),C,D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,D);this.O3(K,0,0)}else{if(this.dodgeBy){var j=this.vK(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.tA({p:["drawShape",M,N+(A/2),F-(D/2),A,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.vK(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.vK(X[P][0],X[P][1]);var G=this.tA({p:["drawShape",M,N+(C/2),F-(D/2),C,D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.tA({p:["drawText",this.qo(U[P]),N+(C/2),F-(D/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}F=m-y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":"roundrectb";var x=this.Nb(V[P],X[P]);var r=C>5?this.f6(x,X[P]):x;if(this.graphType=="Network"){this.tA({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,V[P],V[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N,F-D,C,-D);this.O3(K,0,0)}else{if(this.dodgeBy){var j=this.vK(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.tA({p:["drawShape",M,N+(A/2),F-(D/2),A,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.vK(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.vK(X[P][0],X[P][1]);var G=this.tA({p:["drawShape",M,N+(C/2),F-(D/2),C,-D,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.tA({p:["drawText",this.qo(U[P]),N+(C/2),F-(D/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){N+=A}else{F-=D}}}}else{N=B+y;for(var P=0;P<U.length;P++){if(U[P]>0){var D=I?(U[P]*100/R[0])*E:U[P]*E;var M=P<U.length-1||!this.useRoundRectangles?"rectangle":O?"roundrectl":"roundrectr";var x=this.Nb(V[P],X[P]);var r=C>5?this.f6(x,X[P]):x;if(O){if(this.graphType=="Network"){this.tA({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,D,C);this.O3(K,0,0)}else{if(this.dodgeBy){var j=this.vK(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.tA({p:["drawShape",M,N+O-(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.vK(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.vK(X[P][0],X[P][1]);var G=this.tA({p:["drawShape",M,N+O-(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.tA({p:["drawText",this.qo(U[P]),N+O-(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.tA({p:["drawShape",M,N+(D/2),F+(C/2),D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,D,C);this.O3(T,0,0)}else{if(this.dodgeBy){var j=this.vK(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.tA({p:["drawShape",M,N+(D/2),F+(A/2),D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.vK(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.vK(X[P][0],X[P][1]);var G=this.tA({p:["drawShape",M,N+(D/2),F+(C/2),D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.tA({p:["drawText",this.qo(U[P]),N+(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}N=B+y;for(var P=U.length-1;P>=0;P--){if(U[P]<0){var D=I?(U[P]*100/-R[1])*E:U[P]*E;var M=P>0||!this.useRoundRectangles?"rectangle":O?"roundrectr":"roundrectl";var x=this.Nb(V[P],X[P]);var r=C>5?this.f6(x,X[P]):x;if(O){if(this.graphType=="Network"){this.tA({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var K=Q(W[P],N+O-D,F,-D,C);this.O3(K,0,0)}else{if(this.dodgeBy){var j=this.vK(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.tA({p:["drawShape",M,N+O-(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.vK(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.vK(X[P][0],X[P][1]);var G=this.tA({p:["drawShape",M,N+O-(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.tA({p:["drawText",this.qo(U[P]),N+O-(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N-=D}}else{if(this.graphType=="Network"){this.tA({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,V[P],V[P],H[P]],i:X[P],m:L,t:"Decorations"})}else{if(W){var T=Q(W[P],N,F,-D,C);this.O3(T,0,0)}else{if(this.dodgeBy){var j=this.vK(false,false,"Property:"+this.dodgeBy+":"+X[P][4]+":x");var G=this.tA({p:["drawShape",M,N+(D/2),F+(A/2),-D,A,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j})}else{var j=this.stackBy?this.vK(false,false,"Property:"+this.stackBy+":"+X[P][4]+":x"):this.vK(X[P][0],X[P][1]);var G=this.tA({p:["drawShape",M,N+(D/2),F+(C/2),-D,C,x,r,H[P]],i:X[P],m:L,b:S,t:Y,h:j});if(this.showDataValues){this.tA({p:["drawText",this.qo(U[P]),N+(D/2),F+(C/2),this.smpLabelFont,this.smpLabelColor,"center","middle"],g:G,t:Y,h:j})}}}}if(this.dodgeBy){F+=A}else{N+=D}}}}}};this.WF=function(ai,Z,S,Q,ae,T,ag,V,J,D,m,X,af,ak,W,an,al,M,G,am){var Y=ai.length-1;var aa=af&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var ao=-D*J;var C=m*J;var ad=am?"Overlays":"Data";var L=function(b,a){for(var c=a+1;c<ai[b].length;c++){if(ai[b][c]>0){return 1}else{if(ai[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ai[0].length;ac++){A[ac]=ag=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ai.length;ac++){var ah=Z;var P=af?[]:[Z];var N=af?[]:[S-ao];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.a0(ai[ac][ab],true)){if(!af){P.push(ah-T);N.push(S-ao)}if(af&&this.lineType=="spline"){this.tA({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],i:an[ac],m:al,b:S-ao,t:ad,h:this.vK(an[ac][0])})}else{if(D>=0&&Y>0&&ag!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var ap=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);ap.push([N[ac],E[ac]])}this.tA({p:["drawShape","confidence",F,ap,this.width,this.height,this.Nb(ak[Y],an[Y]),this.f6(ak[Y],an[Y]),W[Y]],i:an[Y],m:al,b:S-ao,t:ad,h:this.vK(an[Y][0])})}else{this.tA({p:["drawShape",aa,P,N,this.width,this.height,this.Nb(ak[ac],an[ac]),this.f6(ak[ac],an[ac]),W[ac]],i:an[ac],m:al,b:S-ao,t:ad,h:this.vK(an[ac][0])})}}if(G){var u=this.xh(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.tA({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.tA({p:["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[ah+T];N=af?[]:[S-ao]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;P.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(ai[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ai[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(ao)}}}}}else{N.push(S-R)}}ah+=T}if(!af){P.push(Z+Q);N.push(S-ao)}U.push([P,N,ak[ac],W[ac],an[ac]])}}else{for(var ac=0;ac<ai[0].length;ac++){A[ac]=M?Z+M:ag=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ai.length;ac++){var ah=S;var P=af?[]:M?[Z+M]:[Z+ao];var N=af?[]:[S];var H=0;var aj,K;for(var ab=0;ab<ai[0].length;ab++){if(!this.a0(ai[ac][ab],true)){if(!af){P.push(M?Z+M:Z+ao);N.push(ah-T)}if(af&&this.lineType=="spline"){this.tA({p:["drawLine",aa,P,N,false,false,ak[ac],this.lineThickness],i:an[ac],m:al,b:Z+ao,t:ad,h:this.vK(an[ac][0])})}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&ag!="normal"){N.shift();var F=[];var ap=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);ap.push([N[ac-1],N[ac-1]])}this.tA({p:["drawShape","confidence",F,ap,this.width,this.height,this.Nb(ak[Y],an[Y]),this.f6(ak[Y],an[Y]),W[Y]],i:an[Y],m:al,b:Z+ao,t:ad,h:this.vK(an[Y][0])})}else{this.tA({p:["drawShape",aa,P,N,this.width,this.height,this.Nb(ak[ac],an[ac]),this.f6(ak[ac],an[ac]),W[ac]],i:an[ac],m:al,b:Z+ao,t:ad,h:this.vK(an[ac][0])})}}if(G){var u=this.xh(ak[ac],0,true);for(var I=0;I<P.length;I++){aj=this.tA({p:["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],i:[an[ac][0],G[I]],s:true,t:ad});if(!af){this.tA({p:["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],i:[an[ac][0],G[I]],g:aj,s:true,t:ad})}}}P=af?[]:[M?Z+M:Z+ao];N=af?[]:[ah+T]}else{var R=ag=="percent"?((ai[ac][ab]-D)*100/V[ab])*J:(ai[ac][ab]-(ag=="stacked"&&D<0?0:D))*J;N.push(ah);if(ag&&(ag=="stacked"||ag=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ai[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ai[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(ao)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ah+=T}if(!af){P.push(M?Z+M:Z+ao);N.push(S+ae)}U.push([P,N,ak[ac],W[ac],an[ac]])}}while(Y>=0){var aj,K;var ab=U.pop();if(af){if(this.lineType=="spline"){this.tA({p:["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.vK(ab[4][0])})}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var aj=this.tA({p:["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],i:ab[4],m:al,g:K,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.vK(ab[4][0])});if(K==null){K=aj}}}}else{if(D>=0&&Y>0&&ag!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);ap.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.tA({p:["drawShape","confidence",F,ap,this.width,this.height,this.Nb(ab[2]),this.f6(ab[2]),ab[3]],i:ab[4],m:al,b:S-ao,t:ad,h:this.vK(ab[4][0])})}else{ab[1].shift();ab[1].pop();var F=[];var ap=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);ap.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.tA({p:["drawShape","confidence",F,ap,this.width,this.height,this.Nb(ab[2]),this.f6(ab[2]),ab[3]],i:ab[4],m:al,b:Z+ao,t:ad,h:this.vK(ab[4][0])})}}else{if(ag=="normal"||ag=="stacked"){this.tA({p:["drawShape",aa,ab[0],ab[1],this.width,this.height,this.Nb(ab[2]),this.f6(ab[2]),ab[3]],i:ab[4],m:al,b:X=="vertical"?S-ao:Z+ao,t:ad,h:this.vK(ab[4][0])})}else{if(X=="vertical"){var ap=[];for(var ac=1;ac<ab[1].length-1;ac++){ap.push([ab[1][ac],ab[1][0]])}this.tA({p:["drawShape","confidence",F,ap,this.width,this.height,this.Nb(ab[2]),this.f6(ab[2]),ab[3]],i:ab[4],m:al,b:S-ao,t:ad,h:this.vK(ab[4][0])})}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.tA({p:["drawShape","confidence",F,ap,this.width,this.height,this.Nb(ab[2]),this.f6(ab[2]),ab[3]],i:ab[4],m:al,b:Z+ao,t:ad,h:this.vK(ab[4][0])})}}}}if(G){var u=this.xh(ab[2],0,true);var g=Math.min(10,T);for(var ac=1;ac<ab[0].length-1;ac++){if(this.isGraphTime&&G[ac-1]<0){continue}aj=this.tA({p:["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],i:[ab[4][0],G[ac-1]],s:true,t:ad});if(!af){if(X=="vertical"){this.tA({p:["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}else{this.tA({p:["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],i:[ab[4][0],G[ac-1]],g:aj,s:true,t:ad})}}}}Y--}};this.XI=function(aw,al,ad,aa,ag,ac,ak,ai,ax,ah,az,ar,x,Z){var X=this;var aj=this.segregateSamplesBy.length&&this.isGroupedData&&this.groupingFactors.includes(this.segregateSamplesBy[0]);var F=function(f){var d;if(X.layoutValid&&!X.isDOE){if(X.segregateVariablesBy.length>0){d=f}else{if(X.segregateSamplesBy.length>0){var a=!aj?[X.data.l.name[X.layoutCurrent],X.data.w.glab[f]].join("::"):X.data.w.labs[f]?X.data.w.labs[f]:X.data.w.glab[f];for(var c=0;c<n.g[H].length;c++){if(n.g[H][c].density.name==a){d=c;break}}}}}else{d=X.grpIndices[f]}return n.g[H][d]};var I=function(a){if(X.showBoxplotOriginalData){if(X.plotStyle=="ggplot"){return X.background;return X.xh(X.Nb(ax[a],az[a]),X.boxplotTransparency,true,false,true)}else{return X.xh(X.Nb(ax[a],az[a]),X.boxplotTransparency,true,false,true)}}else{return X.Nb(ax[a],az[a])}};var Y=function(a){return ai=="vertical"?ad-((a-ak)*ac):al+((a-ak)*ac)};var n=this.meta.data.d;var H=this.qv(Z);var ae=this.variableSpace/2;var ap=aa/2;var L=ap/2;var J=L/2;var au=aa/this.boxplotOutliersRatio;var K={};var W={};var P=false;var U=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?(aa-this.variableSpace)*this.boxplotWidthRatioIfViolin:aa-this.variableSpace;var T=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?aa*this.boxplotWidthRatioIfViolin:0;var S=this.isGroupedData&&this.showViolinBoxplot&&this.isRawData?T/2:ap;var b=Math.max(1,aa/4);if(ai=="vertical"){for(var ao=0;ao<aw.length;ao++){if(this.isGraphTime&&az[ao][1]<0){al+=this.pe(ag)?ag[ao]:ag;continue}var V=this.showBoxplotOriginalData?this.vK(az[ao][0]):this.scatterPlotMatrix&&this.scatterType=="boxplot"?this.vK(false,false,az[ao][1]):this.vK(az[ao][0],az[ao][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&aw[ao].length>1){var E=F(this.layoutValid?az[ao][1]:ao);if(E){this.sP(E,al+(aa/2),ad,aa/this.varIndices.length,ac,ak,ai,ar[ao],x[ao],az[ao],V,aw[ao]);if(!this.showBoxplotIfViolin){P=true}}}var af=al+ap;var ab=[];var D=[];var Q=this.showBoxplotOriginalData||this.showViolinBoxplot?ar[ao]:ax[ao];for(var an=0;an<5;an++){ab.push(Y(aw[ao][an]));D.push(ab[ab.length-1].toString())}if(this.graphType=="Heatmap"){az[ao]=false}if(!P){var R=(al+ae)+((aa-this.variableSpace)/2);var at=ab[3]+((ab[2]-ab[3])/2);var aq=U;var ay=ab[2]-ab[3];var e=this.boxplotNotched?Y(aw[ao][7][0]):false;var am=this.boxplotNotched?Y(aw[ao][7][1]):false;var N=I(ao);var M=this.plotStyle.match(/open|border|ggplotSwitched/)?this.kK(N):this.boxplotBorderColor;var G=this.boxplotMedianColor||M;if(this.boxplotColor){N=this.boxplotColor}var av,O,A;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){aq=U*aw[ao][8];T+=(U-aq)/2}if(this.boxplotNotched&&this.boxplotType!="range"){if(this.showViolinBoxplot){O=[al+(aa-ae-T)-b,al+ae+T,al+ae+T,al+(aa-ae-T),al+(aa-ae-T),al+ae+T+b,al+(aa-ae-T)-b]}else{O=[al+ae+T+b,al+ae+T,al+ae+T,al+(aa-ae-T),al+(aa-ae-T),al+(aa-ae-T)-b,al+ae+T+b]}A=[ab[4],e,ab[2],ab[2],e,ab[4],ab[4]];av=this.tA({p:["drawShape","polygon",O,A,false,false,N,M,ah[ao]],i:az[ao],b:ad,t:"Data",h:V});A=[ab[4],am,ab[3],ab[3],am,ab[4],ab[4]];this.tA({p:["drawShape","polygon",O,A,false,false,N,M,ah[ao]],i:az[ao],g:av,b:ad,t:"Data",h:V})}else{if(this.boxplotType=="range"){av=this.tA({p:["drawLine","line",R,ab[1],R,ab[0],this.plotStyle=="open"?M:N,au,"round"],i:az[ao],b:ad,t:"Data",h:V})}else{av=this.tA({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",R,at,aq,ay,N,M,ah[ao]],i:az[ao],b:ad,t:"Data",h:V})}}if(this.o5(D).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.tA({p:["drawLine","median",al+ae+T+b,ab[4],al+(aa-ae-T)-b,ab[4],G,this.boxplotMedianWidth,"butt"],i:az[ao],g:av,t:"Data",h:V})}else{if(this.boxplotType=="range"){this.tA({p:["drawShape","sphere",R,ab[4],au*2.5,au*2.5,this.plotStyle=="open"?M:N,this.plotStyle=="open"?M:N],i:az[ao],g:av,t:"Data",h:V})}else{this.tA({p:["drawLine","median",R-(aq/2),ab[4],R+(aq/2),ab[4],G,this.boxplotMedianWidth,"butt"],i:az[ao],g:av,t:"Data",h:V})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){if(ab[0]>ab[2]){this.tA({p:["drawLine","line",af,ab[2],af,ab[0],M,false,"butt"],i:az[ao],g:av,t:"Data",h:V})}if(ab[1]<ab[3]){this.tA({p:["drawLine","line",af,ab[3],af,ab[1],M,false,"butt"],i:az[ao],g:av,t:"Data",h:V})}}else{if(this.boxplotWhiskersType=="double"){if(ab[0]>ab[2]){this.tA({p:["drawLine","error",af,ab[2],af,ab[0],M,-S,"butt"],i:az[ao],g:av,t:"Data",h:V})}if(ab[1]<ab[3]){this.tA({p:["drawLine","error",af,ab[3],af,ab[1],M,-S,"butt"],i:az[ao],g:av,t:"Data",h:V})}}}}}if(this.boxplotMean){this.tA({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",af,Y(aw[ao][6]),L,L,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:az[ao],g:av,b:ad,t:"Data",h:V})}if(aw[ao][5]&&!this.showBoxplotOriginalData){for(var an=0;an<aw[ao][5].length;an++){var k=this.boxplotOutliersShape;var B=this.boxplotOutliersColor||(this.plotStyle.match(/ggplot/)?M:N);var C=this.boxplotOutliersBorderColor||M;this.tA({p:["drawShape",k,af,Y(aw[ao][5][an]),au,au,B,C,ah[ao]],i:az[ao],g:av,b:ad,t:"Data",h:V})}}}if(!K.hasOwnProperty(Q)){K[Q]=[];W[Q]=this.ZD(az[ao])}K[Q].push([al+ae+(aa/2),ab[4]]);al+=this.pe(ag)?ag[ao+1]-ag[ao]:ag}}else{for(var ao=0;ao<aw.length;ao++){if(this.isGraphTime&&az[ao][1]<0){ad+=this.pe(ag)?ag[ao]:ag;continue}var V=this.showBoxplotOriginalData?this.vK(az[ao][0]):this.vK(az[ao][0],az[ao][1],false,true);if(this.isGroupedData&&this.showViolinBoxplot&&this.isRawData&&aw[ao].length>1){var E=F(this.layoutValid?az[ao][1]:ao);if(E){this.sP(E,al,ad+(aa/2),aa/this.varIndices.length,ac,ak,ai,ar[ao],x[ao],az[ao],V,aw[ao]);if(!this.showBoxplotIfViolin){P=true}}}var af=ad+ap;var ab=[];var D=[];var Q=this.showBoxplotOriginalData||this.showViolinBoxplot?ar[ao]:ax[ao];for(var an=0;an<5;an++){ab.push(Y(aw[ao][an]));D.push(ab[ab.length-1].toString())}if(this.graphType=="Heatmap"){az[ao]=false}if(!P){var R=ab[2]+((ab[3]-ab[2])/2);var at=(ad+ae)+((aa-this.variableSpace)/2);var aq=ab[3]-ab[2];var ay=U;var e=this.boxplotNotched?Y(aw[ao][7][0]):false;var am=this.boxplotNotched?Y(aw[ao][7][1]):false;var N=I(ao);var M=this.plotStyle.match(/open|border|ggplotSwitched/)?this.kK(N):this.boxplotBorderColor;var G=this.boxplotMedianColor||M;if(this.boxplotColor){N=this.boxplotColor}var av,O,A;if(this.boxplotVarWidth&&this.graphType!="Scatter2D"){ay=U*aw[ao][8];T+=(U-ay)/2}if(this.boxplotNotched&&this.boxplotType!="range"){O=[ab[4],e,ab[2],ab[2],e,ab[4],ab[4]];if(this.showViolinBoxplot){A=[ad+(aa-ae-T)-b,ad+ae+T,ad+ae+T,ad+(aa-ae-T),ad+(aa-ae-T),ad+ae+T+b,ad+(aa-ae-T)-b]}else{A=[ad+ae+T+b,ad+ae+T,ad+ae+T,ad+(aa-ae-T),ad+(aa-ae-T),ad+(aa-ae-T)-b,ad+ae+T+b]}av=this.tA({p:["drawShape","polygon",O,A,false,false,N,M,ah[ao]],i:az[ao],b:ad,t:"Data",h:V});O=[ab[4],am,ab[3],ab[3],am,ab[4],ab[4]];this.tA({p:["drawShape","polygon",O,A,false,false,N,M,ah[ao]],i:az[ao],g:av,b:ad,t:"Data",h:V})}else{if(this.boxplotType=="range"){av=this.tA({p:["drawLine","line",ab[0],at,ab[1],at,this.plotStyle=="open"?M:N,au,"round"],i:az[ao],b:al,t:"Data",h:V})}else{av=this.tA({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",R,at,aq,ay,N,M,ah[ao]],i:az[ao],b:al,t:"Data",h:V})}}if(this.o5(D).length!=0){if(this.boxplotNotched&&this.boxplotType!="range"){this.tA({p:["drawLine","median",ab[4],ad+ae+T+b,ab[4],ad+(aa-ae-T)-b,G,this.boxplotMedianWidth,"butt"],i:az[ao],g:av,t:"Data",h:V})}else{if(this.boxplotType=="range"){this.tA({p:["drawShape","sphere",ab[4],at,au*2.5,au*2.5,this.plotStyle=="open"?M:N,this.plotStyle=="open"?M:N],i:az[ao],g:av,t:"Data",h:V})}else{this.tA({p:["drawLine","median",ab[4],at-(ay/2),ab[4],at+(ay/2),G,this.boxplotMedianWidth,"butt"],i:az[ao],g:av,t:"Data",h:V})}}if(this.boxplotType!="range"){if(this.boxplotWhiskersType=="single"){if(ab[2]>ab[0]){this.tA({p:["drawLine","line",ab[2],af,ab[0],af,M,false,"butt"],i:az[ao],g:av,t:"Data",h:V})}if(ab[3]<ab[1]){this.tA({p:["drawLine","line",ab[3],af,ab[1],af,M,false,"butt"],i:az[ao],g:av,t:"Data",h:V})}}else{if(this.boxplotWhiskersType=="double"){if(ab[2]>ab[0]){this.tA({p:["drawLine","error",ab[2],af,ab[0],af,M,S,"butt"],i:az[ao],g:av,t:"Data",h:V})}if(ab[3]<ab[1]){this.tA({p:["drawLine","error",ab[3],af,ab[1],af,M,S,"butt"],i:az[ao],g:av,t:"Data",h:V})}}}}}if(this.boxplotMean){this.tA({p:["drawShape",this.useRoundRectangles?"roundrect":"rectangle",Y(aw[ao][6]),af,L,L,this.boxplotMeanColor,this.boxplotMeanBorderColor],i:az[ao],g:av,b:al,t:"Data",h:V})}if(aw[ao][5]&&!this.showBoxplotOriginalData){for(var an=0;an<aw[ao][5].length;an++){var k=this.boxplotOutliersShape;var B=this.boxplotOutliersColor||(this.plotStyle.match(/ggplot/)?M:N);var C=this.boxplotOutliersBorderColor||M;this.tA({p:["drawShape",k,Y(aw[ao][5][an]),af,au,au,B,C,ah[ao]],i:az[ao],g:av,b:al,t:"Data",h:V})}}}if(!K.hasOwnProperty(Q)){K[Q]=[];W[Q]=this.ZD(az[ao])}K[Q].push([ab[4],ad+ae+(aa/2)]);ad+=this.pe(ag)?ag[ao+1]-ag[ao]:ag}}if(this.boxplotConnect){for(var Q in K){if(K[Q].length>1){var av=this.tA({p:["drawLine","line",K[Q][0][0],K[Q][0][1],K[Q][1][0],K[Q][1][1],Q,this.boxplotConnectWidth,"butt"],i:["Line:",W[Q][0],W[Q][1]],t:"Data",h:V});for(var ao=1;ao<K[Q].length-1;ao++){this.tA({p:["drawLine","line",K[Q][ao][0],K[Q][ao][1],K[Q][ao+1][0],K[Q][ao+1][1],Q,this.boxplotConnectWidth,"butt"],i:["Line:",W[Q][0],W[Q][1]],g:av,t:"Data",h:V})}}}}};this.gc=function(R,E,T,H,L,C,P,B,K,F,S,U){var y=function(a){return L+((a-K)*B)};var x=null;for(var N=0;N<R.length;N++){var J=y(R[N][0]);var f=y(R[N][1]);var A=J+((f-J)/2);var e=C+(P/2);var W=f-J;var v=E[N]?W*E[N]:false;var w=this.Nb(S[N],U[N]);var g=this.xh(w,this.ganttCompletionTransparency,true);var s=this.f6(w,U[N]);var r=this.vK(false,U[N][0]);var D=this.tA({p:["drawShape","roundrect",A,e,W,P,g,g,F[N]],i:U[N],g:x,b:L,t:"Data",h:r});if(!x){x=D}if(E[N]){if(E[N]==1){this.tA({p:["drawShape","roundrect",A,e,W,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}else{this.tA({p:["drawShape","roundrectl",A-((W-v)/2),e,v,P,w,w,F[N]],i:U[N],g:x,b:L,t:"Data",h:r})}}this.tA({p:["drawShape","roundrect",A,e,W,P,false,s,"open"],i:U[N],g:x,b:L,t:"Data",h:r});if(H.length){for(var M=0;M<H.length;M++){var I=y(H[M][0]);this.tA({p:["drawShape","triangle2",I,C,P/3,P/3,w,s],i:[].concat(U[N].concat(H[M][1])),g:x,b:L,t:"Data",h:r})}}if(T[N]){var G=y(T[N][0]);var X=y(T[N][1]);var V=T[N][2]+(P/2);var Q=e==V?X:G+((X-G)/2);var n=e==V?V:V+(P/2);var O=A-(W/2);var k=e;this.tA({p:["drawLine",n==k?"line":"roundLine",Q,n,O,k,this.f6(T[N][4]),T[N][5],"butt",0,0,false,false,false,false,T[N][3]],i:U[N],g:x,b:L,t:"Data",h:r})}}};this.sP=function(s,J,B,N,A,H,F,Q,E,D,g,O){var k=[];var L=[];var e=[];var G=[];var b=[[],[]];var I,f,r,n,w,a,R,P;var S=s.density.maxY>0?s.density.maxY:0.000001;switch(this.violinScale){case"area":I=N/S*S/s.scale*0.9/this.widthFactor;break;case"count":I=N/S*s.density.sumY/s.area*0.9/this.widthFactor;break;case"width":I=N/S*0.9/this.widthFactor;break}var C=this.xh(this.violinColor||Q,this.showBoxplotOriginalData&&!this.violinColor&&this.plotStyle!="ggplot"?0:this.violinTransparency,true);if(this.violinTrim){f=[];for(var M=s.density.trim[0];M<s.density.trim[1];M++){f.push(s.density.xy[M])}}else{f=s.density.xy}if(F=="vertical"){for(var M=0;M<f.length;M++){r=(f[M][1]*I);n=((f[M][0]-H)*A);k.push(J-r);L.push(B-n);e.push(J+r);G.push(B-n);b[0].push(J);b[1].push(B-n)}}else{for(var M=0;M<f.length;M++){r=((f[M][0]-H)*A);n=(f[M][1]*I);k.push(J+r);L.push(B-n);e.push(J+r);G.push(B+n);b[0].push(J+r);b[1].push(B)}}if(k.length>1&&L.length>1){this.tA({p:["drawShape","violin",[k,e],[L,G],false,false,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g});if(this.showViolinQuantiles){r=O;for(M=2;M<=4;M++){if(F=="vertical"){for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=f[K][1]*I;P=B-((r[M]-H)*A);this.tA({p:["drawLine","solid",J-R,P,J+R,P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}else{for(var K=0;K<f.length;K++){if(f[K][0]>r[M]){R=J+((r[M]-H)*A);P=f[K][1]*I;this.tA({p:["drawLine","solid",R,B-P,R,B+P,this.violinBorderColor,1.5],t:"Decorations",h:g});break}}}}}}else{if(F=="vertical"){r=J;n=B-((s.density.median[0]-H)*A)}else{r=J+((s.density.median[0]-H)*A);n=B}this.tA({p:["drawShape","circle",r,n,this.margin,this.margin,C,this.violinBorderColor,E],i:D,b:b,t:"Data",h:g})}};this.E9=function(ap,an,ac,U,ah,X,T,ab,V,Z,aq,ad,Y,aw,R,W,Q,J,I,at){var P=this;var E=function(h){var l=P.segregateSamplesBy.length&&P.isGroupedData&&P.groupingFactors.includes(P.segregateSamplesBy[0]);var c=P.meta.data.d;var k=P.qv(J);var e;if(P.layoutValid&&!P.isDOE){if(P.segregateVariablesBy.length>0){e=h}else{if(P.segregateSamplesBy.length>0){var a=!l?[P.data.l.name[P.layoutCurrent],P.data.w.glab[h]].join("::"):P.data.w.labs[h]?P.data.w.labs[h]:P.data.w.glab[h];for(var d=0;d<c.g[k].length;d++){if(c.g[k][d].density.name==a){e=d;break}}}}}else{if(P.isGroupedData){e=P.grpIndices[h]}}return c.g&&c.g[k]?c.g[k][e]:!P.isGroupedData&&c.v?c.v[k]:false};var H=function(l,c){var a=c[0];var j=0;var e="";var m={n:{},arr:{}};for(var h=0;h<l.length;h++){var d=l[h]!=null?l[h].toString():"";if(!m.n.hasOwnProperty(d)){m.n[d]=0;m.arr[d]=[]}m.n[d]++;if(m.n[d]>j){j=m.n[d];e=d}}if(m.n[e]*a>ah){a=ah*(P.binAlignment=="center"?1:0.5)/m.n[e]}for(var d in m.n){switch(P.binAlignment){case"bottom":case"right":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--}break;case"top":case"left":case"centerwhole":m.arr[d].push(0);m.n[d]--;while(m.n[d]>0){var k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break;case"center":if(m.n[d]%2){m.arr[d].push(0);m.n[d]--}else{m.arr[d].push(-a/2);m.n[d]--;m.arr[d].push(a/2);m.n[d]--}while(m.n[d]>0){var k=m.arr[d][0];m.arr[d].unshift(k-a);m.n[d]--;k=m.arr[d][m.arr[d].length-1];m.arr[d].push(k+a);m.n[d]--}break}}return m.arr};var A=[];var ag=at?"Overlays":"Data";if(Z=="vertical"){for(var af=0;af<ap.length;af++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var ar=this.dotplotType=="movement"?false:this.binned?H(ap[af],V[af]):false;var F=this.dotplotType=="movement"?false:this.jitter||this.sina?this.QP(this.qn(0,ap[af].length),false,ah*this.jitterFactor*0.5*this.widthFactor):false;if(this.sina&&this.isGroupedData){var D=E(af);this.cZ(F,D,ap[af],ah)}for(var ae=0;ae<ap[af].length;ae++){if(this.isGraphTime&&ap[af][ae]==null){continue}var aa=this.dotplotType=="movement"?0:this.binned&&ar[ap[af][ae]]?ar[ap[af][ae].toString()].shift():this.jitter?F[ae]:0;var f=aw?aw[af][ae]:false;var S=U-((ap[af][ae]-ab)*T);var L=this.Nb(aq[af][ae],f);var M=this.plotStyle=="open"?this.kK(L):this.f6(L,f);if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){f.push("Lollipop")}if(this.a0(S,true)){var ao;A.push([ac+aa,S,V[af][ae]/2,f]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ae>0){var N=A.length-1;var C=A.length-2;while(!this.a0(A[C][1],true)&&C>=0){C--}if(this.a0(A[C][1],true)){var av=A[N];var am=A[C];var al=this.xh(L,0.2);this.tA({p:["drawShape","polygon",[av[0]-av[2],am[0]-am[2],am[0]+am[2],av[0]+av[2]],[av[1],am[1],am[1],av[1]],false,false,al,al],t:"Decorations",h:this.vK(av[3][0],av[3][1])||this.vK(am[3][0],am[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){ao=this.tA({p:["drawShape",Y[af][ae],ac+aa,S,V[af][ae],V[af][ae],this.background,L,ad[af][ae],false,2,W],i:f,m:R,b:U,t:ag,h:this.vK(f[0],f[1])})}else{if(this.plotStyle!="open"&&V[af][ae]<2.5){ao=this.tA({p:["drawShape",Y[af][ae],ac+aa,S,V[af][ae],V[af][ae],L,L,ad[af][ae],false,false,W],i:f,m:R,b:U,t:ag,h:this.vK(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}else{ao=this.tA({p:["drawShape",Y[af][ae],ac+aa,S,V[af][ae],V[af][ae],L,M,ad[af][ae],false,false,W],i:f,m:R,b:U,t:ag,h:this.vK(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}}if(this.showDataValues){this.tA({p:["drawText",this.qo(ap[af][ae]),ac+aa,S,this.smpLabelFont,this.barLollipopOpen?L:this.foreground,"center","middle"],g:ao,t:ag,h:this.vK(f[0],f[1])})}if(!this.isGroupedData){if(an[af]&&an[af][ae]&&this.a0(an[af][ae],true)){var au=(an[af][ae]/2)*T;this.tA({p:["drawLine","error",ac+aa,S,ac+aa,S+au,L,-ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.vK(f[0],f[1])});this.tA({p:["drawLine","error",ac+aa,S,ac+aa,S-au,L,-ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.vK(f[0],f[1])})}}}else{A.push([ac+aa,Number.NaN,V[af][ae]/2,f])}}if(this.showErrorBars&&this.isGroupedData&&an[af]&&an[af]&&this.a0(an[af][0],true)&&this.a0(an[af][1],true)){var S=U-((an[af][0]-ab)*T);var au=(an[af][1]/2)*T;var f=aw?[aw[af][0][0],aw[af][0][1],"error"]:false;this.tA({p:["drawShape","diamond",ac,S,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,W],h:this.vK(false,aw[af][0][0]),t:ag});this.tA({p:["drawLine","line",ac,S-au,ac,S+au,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,W],h:this.vK(false,aw[af][0][0]),t:ag})}}ac+=this.pe(X)?X[af+1]-X[af]:X}}else{for(var af=0;af<ap.length;af++){if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){var ar=this.dotplotType=="movement"?false:this.binned?H(ap[af],V[af]):false;var F=this.dotplotType=="movement"?false:this.jitter||this.sina?this.QP(this.qn(0,ap[af].length),false,ah*this.jitterFactor*0.5*this.widthFactor):false;if(this.sina&&this.isGroupedData){var D=E(af);this.cZ(F,D,ap[af],ah)}for(var ae=0;ae<ap[af].length;ae++){if(this.isGraphTime&&ap[af][ae]==null){continue}var aa=this.dotplotType=="movement"?0:this.binned&&ar[ap[af][ae]]?ar[ap[af][ae].toString()].shift():this.jitter?F[ae]:0;var f=aw?aw[af][ae]:false;var S=Q?ac+Q-((ap[af][ae]-ab)*T):ac+((ap[af][ae]-ab)*T);var L=this.Nb(aq[af][ae],f);var M=this.plotStyle=="open"?this.kK(L):this.f6(L,f);if(this.graphType.match(/Bar/)&&this.barType=="lollipop"){f.push("Lollipop")}if(this.a0(S,true)){var ao;A.push([S,U+aa,V[af][ae]/2,f]);if(this.graphType.match(/Dot/)&&this.dotplotType=="movement"&&ae>0){var N=A.length-1;var C=A.length-2;while(!this.a0(A[C][0],true)&&C>=0){C--}if(this.a0(A[C][0],true)){var av=A[N];var am=A[C];var al=this.xh(L,0.2);this.tA({p:["drawShape","polygon",[av[0],am[0],am[0],av[0]],[av[1]-av[2],am[1]-am[2],am[1]+am[2],av[1]+av[2]],false,false,al,al],t:"Decorations",h:this.vK(av[3][0],av[3][1])||this.vK(am[3][0],am[3][1])})}}if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData&&this.barLollipopOpen){ao=this.tA({p:["drawShape",Y[af][ae],S,U+aa,V[af][ae],V[af][ae],this.background,L,ad[af][ae],false,2,W],i:f,m:R,b:ac,t:ag,h:this.vK(f[0],f[1])})}else{if(this.plotStyle!="open"&&V[af][ae]<2.5){ao=this.tA({p:["drawShape",Y[af][ae],S,U+aa,V[af][ae],V[af][ae],L,L,ad[af][ae],false,false,W],i:f,m:R,b:ac,t:ag,h:this.vK(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}else{ao=this.tA({p:["drawShape",Y[af][ae],S,U+aa,V[af][ae],V[af][ae],L,M,ad[af][ae],false,false,W],i:f,m:R,b:ac,t:ag,h:this.vK(f[0],this.isGroupedData||(this.graphType=="Dotplot"&&f[2]!=null)?f[2]:f[1])})}}if(this.showDataValues){this.tA({p:["drawText",this.qo(ap[af][ae]),S,U+aa,this.smpLabelFont,this.barLollipopOpen?L:this.foreground,"center","middle"],g:ao,t:ag,h:this.vK(f[0],f[1])})}if(!this.isGroupedData){if(an[af]&&an[af][ae]&&this.a0(an[af][ae],true)){var au=(an[af][ae]/2)*T;this.tA({p:["drawLine","error",S,U+aa,S+au,U+aa,L,ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.vK(f[0],f[1])});this.tA({p:["drawLine","error",S,U+aa,S-au,U+aa,L,ah,"butt",false,false,true],i:f,g:ao,t:ag,h:this.vK(f[0],f[1])})}}}else{A.push([Number.NaN,U+aa,V[af][ae]/2,f])}}}if(this.showErrorBars&&this.isGroupedData&&an[af]&&an[af]&&this.a0(an[af][0],true)&&this.a0(an[af][1],true)){var S=ac+((an[af][0]-ab)*T);var au=(an[af][1]/2)*T;var f=aw?[aw[af][0][0],aw[af][0][1],"error"]:false;this.tA({p:["drawShape","diamond",S,U,this.margin*this.errorBarsThickness,this.margin*this.errorBarsThickness,this.errorBarsColor,this.errorBarsColor,"closed",false,false,W],h:this.vK(false,false,"Var-"+aw[af][0][0]),t:ag});this.tA({p:["drawLine","line",S-au,U,S+au,U,this.errorBarsColor,this.errorBarsThickness,"butt",false,false,W],h:this.vK(false,false,"Var-"+aw[af][0][0]),t:ag})}U+=this.pe(X)?X[af+1]-X[af]:X}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var g=this.meta.data.x[this.connectBy];var G=0;var ai=this.NU(this.connectByData);var b=this.cr(ai.length);var K={};if(this.isGraphTime){for(var af=0;af<this.timeValueIndices.length;af++){if(this.timeValueIndices[af]>0){K[af.toString()]=this.timeValueIndices[af]}}}for(var af in this.connectByData){var ao;var O=null;var ap=this.connectByData[af];var L=this.connectByNoColor?this.connectByColor:g&&g.type!="Numeric"?g.connects[g.order[af]%g.connects.length]:b[G%b.length];if(ap.length>1){for(var ae=1;ae<ap.length;ae++){var S=this.isGraphTime?A[K[ap[ae-1]]]:A[ap[ae-1]];var au=this.isGraphTime?A[K[ap[ae]]]:A[ap[ae]];if(S&&au){ao=this.tA({p:["drawLine","line",S[0],S[1],au[0],au[1],L,this.connectByWidth,"butt",S[2],au[2],W],i:["Line:"+this.connectBy+" "+af,S[3][0],S[3][2],au[3][2]],g:O,t:ag,h:this.vK(false,S[3][2])});if(O==null){O=ao}}}}G++}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(A);if(I){var g=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var af in this.connectByData){var ap=this.connectByData[af];if(ap.length>1){for(var ad=0;ad<this.connectByDataVar[0].length;ad++){for(var ae=1;ae<ap.length;ae++){var S=this.connectByDataVar[ap[ae-1]][ad];var au=this.connectByDataVar[ap[ae]][ad];var ak=af;if(S&&au){var B=this.data.y.vars[S[3][0]];var aj=this.data.y.vars[au[3][0]];var z=this.data.y.smps[S[3][(this.isGroupedData?2:1)]];var x=this.data.y.smps[au[3][(this.isGroupedData?2:1)]];if(z==x){ak=B+" - "+aj+" ("+z+")"}else{ak=B+" ("+z+") - "+aj+" ("+x+")"}}this.tA({p:["drawLine","line",S[0],S[1],au[0],au[1],this.connectByColor,this.connectByWidth,"butt",S[2],au[2],W],i:["Line:"+this.connectBy+" "+ak],t:ag,h:this.vK(false,S[3][2])})}}}}}}}};this.z3=function(I,D,x,k,F,H,M,G,A,L,z){var s=1;var g=D;var y=0.75;var C=this.meta.vals;var K=this.plotInfo.variables;if(!C.colors){C.colors={}}for(var E=0;E<I.length;E++){var n=I[E];var J=this.isContour?"rgba(0,0,0,0)":n==null||!this.a0(n,true)?this.missingDataColor:C.colors[n.toString()]?C.colors[n.toString()]:this.Wk(L,n);var B=H&&z?this.xh(J,z,true):H?J:this.heatmapCellBoxColor;var j=K[E].xy+(y/2);C.colors[n==null?"null":n.toString()]=J;if(z){J=this.xh(J,z,true)}if(this.graphType=="Network"){if(this.shapeByShape){this.tA({p:["drawShape",this.shapeByShape,D+(k/2),x+(F/2),k/2,F/2,J,B,A[E]],i:M[E],m:G,t:"Decorations",h:this.vK(M[E])})}else{this.tA({p:["drawShape","rectangle",D+(k/2),x+(F/2),k,F,J,J,A[E]],i:M[E],m:G,t:"Decorations",h:this.vK(M[E])})}}else{if(this.shapeByShape){this.tA({p:["drawShape",this.shapeByShape,j+(k/2),x+(F/2),k/2,F/2,J,B,A?A[E]:false],i:M[E],m:G,t:"Data",h:this.vK(M[E][0],M[E][1])})}else{if(E>0&&E<I.length-1){if(s>=1){this.tA({p:["drawShape","rect",j,x+((F+y)/2),k+y,F+y,J,J,A?A[E]:false],i:M[E],m:G,b:[g,x+((F+y)/2),0,F+y],h:this.vK(M[E][0],M[E][1]),t:"Data"});s=0}}else{this.tA({p:["drawShape","rect",j,x+((F+y)/2),k+y,F+y,J,J,A?A[E]:false],i:M[E],m:G,b:[g,x+((F+y)/2),0,F+y],h:this.vK(M[E][0],M[E][1]),t:"Data"})}}}if(this.showDataValues){this.tA({p:["drawText",this.qo(n),(j+((k+y)/2))-2,(x+F)-2,this.smpLabelFont,this.foreground,"right","bottom"],t:"Data"})}D+=k;s+=k}};this.O3=function(B,u,p,C,D){var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){if(c){f.tA({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.f6(d.color),"open",false,d.outline,C,D],b:r,t:"Data"})}else{f.tA({p:["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,f.Nb(d.color,d.index),f.f6(d.color,d.index),"closed",false,false,C,D],i:d.index,b:r,t:"Data",h:f.vK(d.index[0],d.index[1])})}if(d.label){var b=f.DU(d.label,f.overlayFont);if(b+f.margin<d.coords.width&&f.overlayFontSize+f.margin<d.coords.height){if(c){f.tA({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.xh(f.foreground,0.5,true),"center","middle"],t:"Data"})}else{f.tA({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"left","top"],t:"Data"})}}else{if(b+f.margin<d.coords.height&&f.overlayFontSize+f.margin<d.coords.width){if(c){f.tA({p:["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.xh(f.foreground,0.5,true),"center","middle",-Math.PI/2],t:"Data"})}else{f.tA({p:["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"right","top",-Math.PI/2],t:"Data"})}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth&&!this.isDOE?1:0;var E=this.isDOE?0:this.treemapBorderWidth;var o=E*2;var e=this.smpLabelFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.tA({p:["disableGradientTransparencyShadow"],t:"Data"});if(a.coords.border>1){this.tA({p:["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D],t:"Data"});this.tA({p:["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>0){this.tA({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}else{if(a.coords.border>-1){this.tA({p:["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D],t:"Data"})}}}var z=this.DU(a.title,this.smpLabelFont);if(z+this.margin<n&&this.smpLabelFontSize<=e&&a.coords.height>e+(E/2)){this.tA({p:["drawText",a.title,m+this.margin,j+(this.smpLabelFontSize/2),this.smpLabelFont,this.foreground,"left","middle"],t:"Data"})}this.tA({p:["enableGradientTransparencyShadow"],t:"Data"})}if(a.children){s(a.children)}else{k(a)}}};this.gg=function(b){var f=b.links[0].target.x-b.links[0].source.x;for(var a=0;a<b.links.length;a++){var c=b.links[a];this.tA({p:["drawShape","bezier",c.plotX,c.plotY,f,c.dy,this.Nb(c.color),this.f6(c.color),false,c.colors],i:c.tooltip,b:[this.left,this.top+this.y/2,f,c.dy],t:"Data"})}for(var a=0;a<b.nodes.length;a++){var e=b.nodes[a];this.tA({p:["drawShape","rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground],i:e.tooltip,b:[this.left,this.top+this.y/2,e.dx,e.dy],t:"Data"});this.tA({p:["drawText",e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayColor,"center","middle",-Math.PI/2],i:[e.tooltip[0]+":T"],t:"Data"})}};this.Fe=function(a,f){if(this.data.tree&&this.data.tree.plot){var l=this.data.tree.plot;var k=this.treeNodeSize;var d=k/2;var h=k/4;var e=a=="vertical"?true:false;var g=this;var j=function(u){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=g.vK(false,u.id);g.tA({p:["drawShape",u.data.shape,m,t,u.data.size,u.data.size,g.Nb(u.data.color,u.id),g.treeNodeOutlineColor,u.data.pattern,false,g.treeLinkWidth],i:["Tree-Node:"+u.id],b:[b,i],t:"Data",h:q});if(u.children){for(var p=0;p<u.children.length;p++){j(u.children[p])}if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.tA({p:["drawText",u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"left":"right","middle",o],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.tA({p:["drawText",u.data.name,m-r,t-s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"right":"left","middle",o-Math.PI],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){if(u.parent){g.tA({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelColor,"right","middle",Math.PI/2],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.tA({p:["drawText",u.data.name,m,t-((k/2)+g.margin),g.smpLabelFont,g.smpLabelColor,"center","bottom"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{g.tA({p:["drawText",u.data.name,m-((k/2)+g.margin),t,g.smpLabelFont,g.smpLabelColor,"right","middle"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}else{if(g.treeCircular){var o=(Math.PI/2)-u.angle;var r=(((k/2)+g.margin)*Math.cos(o))*(g.treeInverted?-1:1);var s=(((k/2)+g.margin)*Math.sin(o))*(g.treeInverted?-1:1);if(u.angle<=Math.PI){g.tA({p:["drawText",u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"right":"left","middle",o],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}else{g.tA({p:["drawText",u.data.name,m+r,t+s,g.smpLabelFont,g.smpLabelColor,g.treeInverted?"left":"right","middle",o-Math.PI],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}else{if(e){g.tA({p:["drawText",u.data.name,m,t+(k/2)+g.margin,g.smpLabelFont,g.smpLabelColor,"left","middle",Math.PI/2],i:["Tree-Text-:"+u.id],b:[b,i],t:"Data",h:q})}else{g.tA({p:["drawText",u.data.name,m+(k/2)+g.margin,t,g.smpLabelFont,g.smpLabelColor,"left","middle"],i:["Tree-Text:"+u.id],b:[b,i],t:"Data",h:q})}}}if(u._children){g.tA({p:["drawLine","line",m-h,t,m+h,t,g.foreground],i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q});g.tA({p:["drawLine","line",m,t-h,m,t+h,g.foreground],i:["Tree-Line2:"+u.id],b:[b,i],t:"Data",h:q})}else{if(u.children){g.tA({p:["drawLine","line",m-h,t,m+h,t,g.foreground],i:["Tree-Line1:"+u.id],b:[b,i],t:"Data",h:q})}}};var c=function(u){if(u.children){for(var o=0;o<u.children.length;o++){c(u.children[o])}}if(u.parent){var m=e?u.x0:u.y0;var t=e?u.y0:u.x0;var q=e?u.parent.x0:u.parent.y0;var s=e?u.parent.y0:u.parent.x0;var r=u._clicked?[q,s,q,s]:[b,i,b,i];var p=g.vK(false,u.id);g.tA({p:["drawLine","bezier",q,s,m,t,g.treeLinkColor,g.treeLinkWidth,false,false,false,false,false,false,false,false,false,g.treeCircular?[u.mx,u.my,u.mx2,u.my2]:false],i:[u.parent.id+":"+u.id],b:r,t:"Data",h:p});u._clicked=false}};var b=e?l.x0:l.y0;var i=e?l.y0:l.x0;c(l);if(!f){j(l)}}};this.lB=function(c){if(this.Q7()){return}var b=[];this.QR(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.j8({func:"zoomOncoprintVariables",par:[c]})}};CanvasXpress.prototype.init3dUtils=function(){this.iT=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.tc=function(){this.iT();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.gR=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.VJ=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h}};CanvasXpress.prototype.initApiUtils=function(){this.Hl=function(){return this.validGraphTypes};this.ZR=function(){this.initializeAttributes()};this.ak=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.gZ=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.a2=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.kg=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.ai=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.TZ=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.kn=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.N0=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.eX=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.iH=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.im=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.l4=function(){var b=["linear","exponential","logarithmic","power","polynomial","regression","normal","nonlinear","area","line","reg","nor","nlfit"];if(this.decorations){for(var a=0;a<b.length;a++){if(this.decorations[b[a]]){return true}}}else{return false}};this.p4=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.Bj=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.YX(a[b])+"Line")}}return e};this.mQ=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","pentagon","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","roundpolygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.x6=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.qj=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.tO=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.wo=function(){return this.graphType.match(/BarLine|StackedLine|StackedPercentLine|AreaLine|DotLine/)};this.um=function(){return this.isHistogram&&this.segregateVariablesBy.length+this.segregateSamplesBy.length>0};this.Gt=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.Y5(c,b,a)};this.y6=function(a){return this.tx(a?this.highlightVar:this.highlightSmp)};this.Ev=function(g){if(this.Q7()){return}var e=[];if(!this.pe(g)){for(var d=0;d<arguments.length;d++){e.push(this.ZD(arguments[d]))}g=this.ZD(e)}else{e=this.ZD(g)}var b;var c=this;var a=e.shift();var f=this.ZD(e);while(f.length>1){b=f.shift();if(!c[b]){c[b]={}}c=c[b]}b=f.shift();c[b]=b=="showLegend"?!c[b]:isNaN(a)?a:Number(a);this.j8({func:"modifyOverlaysProperties",par:[g]})};this.xK=function(b,a){this.Y5(b,a,"smpOverlays")};this.v8=function(b,a){this.Y5(b,a,"varOverlays")};this.eI=function(){return this.tx(this.smpOverlays)};this.t2=function(){return this.tx(this.varOverlays)};this.i4=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.Mb=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.Nv=function(){return this.graphType.match(/Scatter/)?this.Mb():this.i4()};this.E3=function(){return this.graphType.match(/scatter/i)?this.Ry():this.getVariablesAsArray};this.Ry=function(){var d=this.kL();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.Ek=function(){var d=this.PB();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.rK=function(a){return this.JR("nodes",a)};this.Jp=function(a){return this.JR("edges",a)};this.WZ=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.NU(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.Ng=function(l,r,q,k,s){var h={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var c={};c[l]={o:{},t:"string"};if(r){c[l]["o"]=this.tx(this.data.y[l])}else{for(var f=0;f<this[h[l]["idx"]].length;f++){c[l]["o"][this.data.y[l][this[h[l]["idx"]][f]]]=true}}if(k||s){var n=k?this.qv(q):this.uL(q,true);if(this.pe(q)){for(var b=0;b<q.length;b++){var n=k?this.qv(q[b]):this.uL(q[b],true);if(n>-1){c[q[b]]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q[b]];c[q[b]]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.w8(g);c[q[b]]["o"]={min:a[0],max:a[1]}}}}}else{var n=k?this.qv(q):this.uL(q,true);if(n>-1){c={};c[q]={o:{},t:"numeric"};if(r){var e=this.meta.data.y.range[q];c[q]["o"]={min:e.min,max:e.max}}else{var g=[];if(k){for(var f=0;f<this.smpIndices.length;f++){g.push(this.data.y.data[n][this.smpIndices[f]])}}else{for(var f=0;f<this.varIndices.length;f++){g.push(this.data.y.data[this.varIndices[f]][n])}}var a=this.w8(g);c[q]["o"]={min:a[0],max:a[1]}}}}}if(this.data[h[l]["spc"]]){for(var j in this.data[h[l]["spc"]]){if(q&&j!=q){continue}var e=this.meta.data[h[l]["spc"]][j];c[j]={o:{},t:e.type.toLowerCase()};if(r){if(e.type=="Numeric"){c[j]["t"]="numeric";c[j]["o"]={min:e.rmin,max:e.rmax}}else{c[j]["t"]="string";c[j]["o"]=this.ZD(e.levels)}}else{for(var f=0;f<this[h[l]["idx"]].length;f++){var d=this.d2(this[h[l]["idx"]][f],h[l]["spc"],j,true);if(!c[j]["o"].hasOwnProperty(d)){c[j]["o"][d]=true}}if(c[j]["t"]=="numeric"){var g=[];for(var d in c[j]["o"]){for(var f=0;f<c[j]["o"][d];f++){g.push(d)}}var a=this.w8(g);c[j]["o"]={min:a[0],max:a[1]}}}}}return c};this.JR=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.RX(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.NU(this[d+"Data"])}else{return false}};this.nn=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.RX(d,b,this[g+"Properties"])}}this.WZ(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.w8(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.cH=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.tx(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.RX(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.NU(this.featuresData)};this.RX=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.k4=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.TU=function(a){this.P7(a,1)};this.SK=function(a){this.P7(a,-1)};this.aj=function(b,a){if(this.Q7()){return}this.clusterAxis="samples";if(b||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.ym()}if(!a){this.j8({func:"clusterSamples",par:[b,a]})}};this.gS=function(b,a){if(this.Q7()){return}this.clusterAxis="variables";if(b||!this.varDendrogramNewick){this.varDendrogramNewick=this.ym()}if(!a){this.j8({func:"clusterVariables",par:[b,a]})}};this.xx=function(e,d){if(this.Q7()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.AS();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.smpOverlays.includes("k-Means-S")){this.smpOverlays.push("k-Means-S")}this.zN("x","k-Means-S",false,true);this.PQ("cat","smp","k-Means-S",true)}if(!d){this.j8({func:"kmeansSamples",par:[e,d]})}};this.US=function(e,d){if(this.Q7()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.AS();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.varOverlays.includes("k-Means-V")){this.varOverlays.push("k-Means-V")}this.zN("z","k-Means-V",false,true);this.PQ("cat","var","k-Means-V",true)}if(!d){this.j8({func:"kmeansVariables",par:[e,d]})}};this.bt=function(e,c,h,g){if(this.graphType=="Circular"&&this.circularType=="bubble"){var d=this.data.bubble.root.children;for(var f=0;f<d.length;f++){var a=d[f];if(a.data.name==e){a.label.x+=c;a.label.y+=h;if(!g){this.j8({func:"modifyLabelCoordinates",par:[e,c,h,g]})}else{this.O1({func:"modifyLabelCoordinates",par:[e,c,h,g]})}return}}}}};CanvasXpress.prototype.initDimensionUtils=function(){this.k2=function(a,o,e){var c=this.margin;var j=this.meta.canvas.canvasPixelRatio;if(a||o||e){if(o||e){if(o){this.width=o;this.originalWidth=o}if(e){this.height=e;this.originalHeight=e}}else{if(a){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=c+this.R2();this.left=c;this.right=c;this.bottom=c;this.IX()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width*j;this.meta.canvas.ctx.canvas.height=this.height*j;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width*j;this.meta.canvas.ctx2.canvas.height=this.height*j;this.meta.canvas.ctx2.canvas.style.width=this.width+"px";this.meta.canvas.ctx2.canvas.style.height=this.height+"px";this.meta.canvas.ctx.scale(j,j);this.meta.canvas.ctx2.scale(j,j)}if(this.useLeaflet){return}this.tA({p:["disableGradientTransparencyShadow"],t:"Size"});if(this.backgroundType=="image"){if(this.graphType=="Network"){var n=this.scaleFactorX||1;var l=this.scaleFactorY||1;var b=this.offsetX*n;var q=this.offsetY*l;var k=this.maxX?this.maxX*n:this.maxX;var d=this.maxY?this.maxY*l:this.maxY;var p=this.colorNodeBy||(this.decorations.length&&this.showDecorations)?"b&w":false;CanvasXpress.system.isRStudio=this.AL()&&this.isR?true:false;if(CanvasXpress.system.isRStudio){this.tA({p:["drawShape","image",(k/2)+b,(d/2)+q,k,d,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}else{this.Sx(CanvasXpress.cacheImages[this.SZ(this.backgroundImage)],0,0,this.maxX,this.maxY,b,q,k,d,p)}}else{this.tA({p:["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="windowImage"){if(this.graphType=="Network"){this.tA({p:["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage],t:"Size"})}}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"){this.tA({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.background,this.background],t:"Size"})}else{var i=this.S4(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0);this.tA({p:["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,i,i],t:"Size"})}}}this.tA({p:["enableGradientTransparencyShadow"],t:"Size"})};this.eb=function(a,b){this.aI(a,false,b)};this.kx=function(b,a){this.aI(false,b,a)};this.sH=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.uH=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.aI=function(j,b,l,k,i,a){if(this.Q7()){return}if(!this.resizable){return}if(j<5||b<5){return}if(j&&b){if(Math.abs(this.width-j)<5&&Math.abs(this.height-b)<5){return}}if(!j||!this.resizableX){j=this.width}if(!b||!this.resizableY){b=this.height}var g=this.meta.canvas.ctx.canvas;j=g.originalWidth=parseInt(j);b=g.originalHeight=parseInt(b);this.vs(l);if(!this.reproducing){this.AT(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.j8({width:j,height:b,func:"setDimensions",par:[j,b,l,k,i,a]});this.sp();if(k){var d=this;setTimeout(function(){d.jy()},k)}else{this.jy()}if(i){try{i()}catch(f){}}};this.cA=function(){var a=this.margin;var b=this.meta.canvas.ctx.canvas;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.R2();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)}};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.u6=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition&&!this.legendPosition.toLowerCase().match("top")&&!this.legendPosition.toLowerCase().match("bottom")&&!this.legendPosition.toLowerCase().match("right")&&!this.legendPosition.toLowerCase().match("left")){if(this.graphType!="Pie"){this.legendPosition="right"}}}if(this.graphType=="Pie"&&this.layoutValid){this.legendPosition="right"}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid&&!this.UL("legendPosition")){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="top"&&this.legendPosition!="bottom"&&this.legendPosition!="right"&&this.legendPosition!="left"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.cV=function(){if(this.autoScaleFont){var e=(1-this.percentAspectRatioPlotArea);var b=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var c=this.layoutComb&&this.isDOE?this.layoutHeight:this.height;var a=this.K9(b*e,c*e);this.QK(a,"legendTextFont");this.QK(a,"legendTitleFont")}else{this.legendTextFont=this.legendTextFontStyle+" "+parseInt(this.legendTextFontSize)+"px "+this.fontName;this.legendTitleFont=this.legendTitleFontStyle+" "+parseInt(this.legendTitleFontSize)+"px "+this.fontName}};this.zS=function(c,o,m,f,k,i){var g="solid";var n=this.useRoundRectangles?"roundrect":"rectangle";var q=i?this.showDecorationsBorder:this.showLegendBorder;var j=i?this.decorationsBackgroundColor:this.legendBackgroundColor;var b=!q?"rgba(255,255,255,0)":i?this.decorationsBackgroundBorderColor:this.legendBackgroundBorderColor;var e=!q?0:i?this.decorationsBackgroundBorderSize:this.legendBackgroundBorderSize;var p=[0,0,this.width,this.height];this.ss();this.tA({p:["drawShape",n,c+(m/2),o+(f/2),m,f,j,b,g,false,e,true,p],i:[-1],m:k,t:"Legends"});this.hd()};this.jT=function(l,k,n,f,b,c,g){this.zS(l,k,n,f,c,g);if(b&&this.showLegendTitle){var j=this.HU(this.legendTitleFont);var e=j/2;var a=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-n/2:n/2;k+=this.legendTitleMargin+e;this.tA({p:["drawText",b,l+(n/2)+a,k,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"});k+=e+this.legendTitleMargin-this.legendBackgroundBorderSize;this.ss();if(this.showLegendBorder){this.tA({p:["drawLine","line",l,k,l+n,k,this.legendBackgroundBorderColor,this.legendBackgroundBorderSize],t:"Legends"})}this.hd()}};this.vD=function(m,k,o,q,j,l,a,n,d,f,e){return this.tA({p:["drawShape",o,m,k,q,q,j,l,a,false,n],i:d,g:f,t:"Legends",h:e})};this.QL=function(l,k,n,o,j,m,d,f,e){var b=l-(o/1.1);var a=l+(o/1.1);return this.tA({p:["drawLine",n,b,k,a,k,j,m],i:d,g:f,t:"Legends",h:e})};this.dQ=function(a,m,d,k,l,b,j,e){return this.tA({p:["drawText",d,a,m,k,l,"left","middle"],i:b,g:j,t:"Legends",h:e})};this.Fh=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j||0,Math.ceil(this.HU(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(k*0.6);var v;if(this.isDataLabelsBackgroundColor){v=this.vD(e,a,"rectangle",k,C,this.dataLabelColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(u)?u:["legend-key-"+u],z,w)}else{v=this.vD(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(u)?u:["legend-key-"+u],z,w)}if(!z){z=v}if(this.isDataLabelsBackgroundColor){this.tA({p:["drawText","a",e,a,this.legendTextFont,this.dataLabelColor,"center","middle"],i:this.pe(u)?u:["legend-letter-"+u],g:z,t:"Legends",h:w})}else{this.tA({p:["drawText","a",e,a,this.legendTextFont,C,"center","middle"],i:this.pe(u)?u:["legend-letter-"+u],g:z,t:"Legends",h:w})}this.dQ(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.pe(u)?u:["legend-text-"+u],z,w)};this.Gl=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j||0,Math.ceil(this.HU(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(k*0.4);var v=this.vD(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(u)?u:["legend-key-"+u],z,w);if(!z){z=v}this.vD(e,a,f,A,C,D,n,1,this.pe(u)?u:["legend-shape-"+u],z,w);this.dQ(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.pe(u)?u:["legend-text-"+u],z,w)};this.CV=function(e,a,f,j,C,D,n,B,m,r,u,z,w){var o=this.legendTextMargin;var k=Math.max(j[1],Math.ceil(this.HU(this.legendTextFont)))+o;var E=Math.ceil(k/2);var A=Math.ceil(j[0]);var v=this.vD(e,a,"rectangle",k,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(u)?u:["legend-key-"+u],z,w);if(!z){z=v}this.vD(e,a,f,A,C,D,n,1,this.pe(u)?u:["legend-shape-"+u],z,w);this.dQ(e+E+o,a,r,this.legendTextFont,this.legendTextColor,this.pe(u)?u:["legend-text-"+u],z,w)};this.nG=function(e,a,j,k,E,F,o,D,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k[1],Math.ceil(this.HU(this.legendTextFont)))+r;var G=Math.ceil(m/2);var C=Math.ceil(k[0]);var w=this.vD(e,a,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(v)?v:["legend-key-"+v],A,z);if(!A){A=w}var B=" "+parseInt((this.EQ(k[0],k[1],j)/10)+14)+"px "+this.fontName;this.tA({p:["drawText","a",e,a,B,this.foreground,"center","middle"],i:this.pe(v)?v:["legend-letter-"+v],g:A,t:"Legends",h:z});this.dQ(e+G+r,a,u,this.legendTextFont,this.legendTextColor,this.pe(v)?v:["legend-text-"+v],A,z)};this.SO=function(f,e,k,m,F,j,r,E,o,v,z,C,B){var u=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.HU(this.legendTextFont)))+u;var G=Math.ceil(n/2);var D=Math.ceil(n*0.6);var a=Math.ceil(D*0.5);var b=(isNaN(j)||!j)?1.5:j;var A=this.vD(f,e,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(z)?z:["legend-key-"+z],C,B);if(!C){C=A}this.QL(f,e,E,a,o,b,this.pe(z)?z:["legend-line-"+z],C,B);this.dQ(f+G+u,e,v,this.legendTextFont,this.legendTextColor,this.pe(z)?z:["legend-text-"+z],C,B)};this.C1=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.HU(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.6);var a=Math.ceil(B*0.5);var w=this.vD(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.QL(f,e,C,a,n,j,this.pe(v)?v:["legend-line-"+v],A,z);this.dQ(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.pe(v)?v:["legend-text-"+v],A,z)};this.zM=function(f,e,j,k,D,E,o,C,n,u,v,A,z){var r=this.legendTextMargin;var m=Math.max(k||0,Math.ceil(this.HU(this.legendTextFont)))+r;var F=Math.ceil(m/2);var B=Math.ceil(m*0.3);var a=Math.ceil(F*0.8);var w=this.vD(f,e,"rectangle",m,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(v)?v:["legend-key-"+v],A,z);if(!A){A=w}this.vD(f,e,j,B,D,E,o,1,this.pe(v)?v:["legend-shape-"+v],A,z);this.QL(f,e,C,a,n,2.5,this.pe(v)?v:["legend-line-"+v],A,z);this.dQ(f+F+r,e,u,this.legendTextFont,this.legendTextColor,this.pe(v)?v:["legend-text-"+v],A,z)};this.JN=function(k,j,m,n,H,I,v,G,u,z,B,E,D){var w=this.legendTextMargin;var o=Math.max(n||0,Math.ceil(this.HU(this.legendTextFont)))+w;var J=Math.ceil(o/2);var F=Math.ceil(o*0.75);var A=Math.ceil(o*0.4);var K=Math.ceil(F*0.6);var a=Math.ceil(F*0.5);var f=v||"solid";var e=this.plotStyle=="ggplotSwitched"?H:I;var r=this.plotStyle=="ggplotSwitched"?I:H;var C=this.vD(k,j,"rectangle",o,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(B)?B:["legend-key-"+B],E,D);if(!E){E=C}this.tA({p:["drawLine",f,k,j-K,k,j+K,e,1],i:this.pe(B)?B:["legend-vline-"+B],g:E,t:"Legends",h:D});this.tA({p:["drawShape","rectangle",k,j,F,A,r,e,v,false,1],i:this.pe(B)?B:["legend-shape-"+B],g:E,t:"Legends",h:D});this.QL(k,j,f,a*1.1,e,1,this.pe(B)?B:["legend-hline-"+B],E,D);this.dQ(k+J+w,j,z,this.legendTextFont,this.legendTextColor,this.pe(B)?B:["legend-text-"+B],E,D)};this.xw=function(j,f,k,m,F,G,u,E,o,w,z,C,B){var v=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.HU(this.legendTextFont)))+v;var H=Math.ceil(n/2);var D=Math.ceil(n*0.75);var a=Math.ceil(D*0.35);var r=this.xh(F,0.5);var e=u||"solid";var A=this.vD(j,f,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(z)?z:["legend-key-"+z],C,B);if(!C){C=A}this.vD(j,f,"rectangle",D,r,r,u,1,this.pe(z)?z:["legend-shape-"+z],C,B);this.QL(j,f,E,a,G,1.5,this.pe(z)?z:["legend-line-"+z],C,B);this.dQ(j+H+v,f,w,this.legendTextFont,this.legendTextColor,this.pe(z)?z:["legend-text-"+z],C,B)};this.ii=function(j,f,k,m,F,G,r,E,o,v,z,C,B){var u=this.legendTextMargin;var n=Math.max(m||0,Math.ceil(this.HU(this.legendTextFont)))+u;var H=Math.ceil(n/2);var D=Math.ceil(n*0.75);var w=Math.ceil(n*0.3);var a=Math.ceil(D*0.5);var e=r||"solid";var A=this.vD(j,f,"rectangle",n,this.legendKeyBackgroundColor,this.legendKeyBackgroundBorderColor,"closed",this.legendKeyBackgroundBorderSize,this.pe(z)?z:["legend-key-"+z],C,B);if(!C){C=A}if(this.graphOrientation=="vertical"){this.tA({p:["drawLine",e,j,f-a,j,f+a,G,1.5],i:this.pe(z)?z:["legend-line-"+z],g:C,t:"Legends",h:B});this.tA({p:["drawShape","circle",j,f-(w*0.7),w,w,F,G,r,false,1],i:this.pe(z)?z:["legend-shape-"+z],g:C,t:"Legends",h:B})}else{this.tA({p:["drawLine",e,j-a,f,j+a,f,G,1.5],i:this.pe(z)?z:["legend-line-"+z],g:C,t:"Legends",h:B});this.tA({p:["drawShape","circle",j+a-(w*0.3),f,w,w,F,G,r,false,1],i:this.pe(z)?z:["legend-shape-"+z],g:C,t:"Legends",h:B})}this.dQ(j+H+u,f,v,this.legendTextFont,this.legendTextColor,this.pe(z)?z:["legend-text-"+z],C,B)};this.va=function(B,z,C,D,w,A,f,u,a,j,k,r,n){var e=this.legendTextMargin;var v=Math.max(D||0,Math.ceil(this.HU(this.legendTextFont)))+e;var m=Math.ceil(v/2);var o=this.vD(B,z,"rectangle",v,w,A,f,1,this.pe(k)?k:["legend-shape-"+k],r,n);if(!r){r=o}this.dQ(B+m+e,z,j,this.legendTextFont,this.legendTextColor,this.pe(k)?k:["legend-text-"+k],r,n)};this.TM=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*14/833).toFixed(1))*this.legendTextScaleFontFactor};this.fS=function(k){var e=k.text.length;var x=this.TM();var B=k.size;if(B){for(var o=0;o<B.length;o++){if(B[o]){x=Math.max(x,B[o])}}}var A=this.DU(k.title&&this.showLegendTitle?k.title:"",this.legendTitleFont)+(this.legendTitleMargin*2);var j=this.DU(this.NN(k.text),this.legendTextFont);var v=this.HU(this.legendTextFont);var u=this.HU(this.legendTitleFont);var y=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/y);var z=Math.max(A,((j+x+(this.legendTextMargin*2))*y)+(this.legendTextMargin*2));var b=(a*(Math.max(x,v)+this.legendTextMargin))+this.legendTextMargin;var p=k.title&&this.showLegendTitle?b+u+(this.legendTitleMargin*2):b;if(!this.legend[k.id]){this.legend[k.id]={}}this.legend[k.id].columns=y;this.legend[k.id].meta=k;this.legend[k.id].width=z;this.legend[k.id].height=p};this.HI=function(h,s,e,u){this.setPropertyLegendIter=u||0;if(this.setPropertyLegendIter>3){return}var a=this.NW(h)+"By";if((this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network"))||h=="sample"){var w,j,t;if(s){w=this[a];if(e.type=="Numeric"&&((h.match(/shape/i)&&!this.shapeByContinuous)||(h.match(/size/i)&&!this.sizeByContinuous))){j=" "+s+" - "+s+" ";if(e){e.maxLevStrMod=j;e.isRange=true}}else{j=s}t=e&&e.sizes?e.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){w=this[a];j=this.meta.data.x[this[a]].maxLevStrMod||this.meta.data.x[this[a]].maxLevStr;t=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){w=this[a];j=this.meta.data.z[this[a]].maxLevStrMod||this.meta.data.z[this[a]].maxLevStr;t=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){w=this[a];j=this.meta.data.nodes[this[a]].maxLevStr;t=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){w=this[a];j=this.meta.data.edges[this[a]].maxLevStr;t=this.meta.data.edges[this[a]].sizes||this.sizes}else{w=0;j=0;t=this.sizes}}}}}var q=this.TM();if(h=="size"||h=="sizeNode"||h=="sizeLabel"){for(var k=0;k<this.legend[h].n;k++){if(t[k]){q=Math.max(q,t[k])}}}else{if(h=="sample"){w=0;j=this.legend.sample.maxStr}}if(j.length>this.maxTextSize){j=j.substring(0,this.maxTextSize-3)+"..."}var o=this.HU(this.legendTextFont);var n=this.HU(this.legendTitleFont);var r=this.legendColumns;var y=r>this.legend[(h=="outline"?"color":h)].n?this.legend[(h=="outline"?"color":h)].n:r;var b=Math.ceil(this.legend[(h=="outline"?"color":h)].n/y);var v=this.showLegendTitle?this.DU(w,this.legendTitleFont)+(this.legendTitleMargin*2):0;var x=((this.DU(j,this.legendTextFont)+Math.max(q,o)+this.legendTextMargin*2)*y)+(this.legendTextMargin*2);this.legend[(h=="outline"?"color":h)].columns=y;this.legend[(h=="outline"?"color":h)].width=Math.max(v,x);this.legend[(h=="outline"?"color":h)].height=(b*(Math.max(q,o)+this.legendTextMargin))+this.legendTextMargin+(h=="sample"?0:(this.showLegendTitle?n+(this.legendTitleMargin*2)+(n<16?n:0):0));if(this.graphType=="Map"&&this.mapProjection=="orthographic"){this.legend[(h=="outline"?"color":h)].width=0;this.legend[(h=="outline"?"color":h)].height=0}else{if(this.legend[(h=="outline"?"color":h)].height>this.height){this.legendColumns++;this.legend[(h=="outline"?"color":h)].columns++;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.HI(h,s,e,this.setPropertyLegendIter+1)}else{if(this.legend[(h=="outline"?"color":h)].width>this.width&&this.legend[(h=="outline"?"color":h)].columns>1){this.legendColumns--;this.legend[(h=="outline"?"color":h)].columns--;this.maxTextSize=Math.max(10,this.maxTextSize-5);this.HI(h,s,e,this.setPropertyLegendIter+1)}}}}};this.sB=function(d,c){var a=this.NW(d)+"By";var n=0;var i=0;var k=this.HU(this.legendTextFont);var j=this.HU(this.legendTitleFont);if(this[a]||d=="decoration"||d=="contour"||d=="bin2d"){switch(d){case"color":case"colorNode":case"colorEdge":case"outline":case"decoration":case"contour":case"bin2d":var b=this.showLegendTitle?this.DU(this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||"",this.legendTitleFont)+(this.legendTitleMargin*2):0;var e=c.maxLevLen+(this.legendTextMargin*3);if(this.legendPosition.match(/top|bottom/)){if(this.showLegendTitle){i+=j+(this.legendTitleMargin*2)}i+=this.heatmapIndicatorHeight+(this.legendTextMargin*3)+k;n=this.heatmapIndicatorWidth+Math.max(b,e)}else{i=this.heatmapIndicatorWidth+(this.legendTextMargin*2)+(this.showLegendTitle?j+(this.legendTitleMargin*2):0);n=this.heatmapIndicatorHeight+Math.max(b,e)+(this.legendTextMargin*2)}break;case"shape":case"shapeNode":case"shapeEdge":case"size":case"sizeNode":case"sizeEdge":this.HI(d,c.maxLevStr,c);return;case"pattern":case"patternNode":case"patternEdge":n=0;i=0;break}}this.legend[(d=="outline"?"color":d)].width=n;this.legend[(d=="outline"?"color":d)].height=i};this.UK=function(){this.legend.decoration.width=0;this.legend.decoration.height=0;this.legend.decoration.maxLabel=0;this.legend.decoration.columns=this.legendColumns;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var o=this.HU(this.decorationsTextFont);var h=this.decorations;var n=0;var m=["nlfit","reg","nor","area"];var g=[96,45,30,0,0,0,0];var k=[5,2,1,0,0,0,0];for(var f=0;f<m.length;f++){if(h[m[f]]){var b=k[f]?this.DU(this.aL("%"+g[f]+"s","X"),this.decorationsTextFont)+(this.decorationsTextMargin*k[f])+this.decorationsTextMargin:0;var l=0;for(var c=0;c<h[m[f]].length;c++){var e=this.DU(h[m[f]][c].label,this.decorationsTextFont);l=Math.max(e,l);this.legend.decoration.maxLabel=Math.max(l,this.legend.decoration.maxLabel)}n=Math.max(n,this.decorationsTextMargin+l+this.decorationsTextMargin+b);this.legend.decoration.height=(h[m[f]].length*(o+this.decorationsTextMargin))+o+this.decorationsTextMargin}}if(this.graphType=="Map"&&h.pie&&h.pie[0]&&h.pie[0].smps&&h.pie[0].smps.length){var l=0;var a=this.HU(this.decorationsTextFont);for(var f=0;f<h.pie[0].smps.length;f++){var e=this.DU(h.pie[0].smps[f],this.decorationsTextFont);l=Math.max(e,l);this.legend.decoration.maxLabel=Math.max(l,this.legend.decoration.maxLabel)}n=Math.max(n,(l+(this.decorationsTextMargin*3)+(a*2))*Math.min(h.pie[0].smps.length,this.legend.decoration.columns));this.legend.decoration.height+=(Math.ceil(h.pie[0].smps.length/Math.min(h.pie[0].smps.length,this.legend.decoration.columns))*a*1.5)+(this.decorationsTextMargin*2)}this.legend.decoration.width=n}};this.t3=function(){this.legend.oncoprint.width=0;this.legend.oncoprint.height=0;this.legend.oncoprint.colors={};if(this.isOncoprint){var g=this.ZD(this.meta.data[this.oncoprintCNA].levels);var h=this.ZD(this.meta.data[this.oncoprintCNA].colors);var b=[];g.push("No Alteration");h.push("rgb(220,220,220");for(var e=0;e<g.length;e++){b.push("CNA")}var k=g.length;if(this.oncoprintMUT){g=g.concat(this.ZD(this.meta.data[this.oncoprintMUT].levels));h=h.concat(this.ZD(this.meta.data[this.oncoprintMUT].colors));for(var e=k;e<g.length;e++){b.push("MUT")}}var j=[];var f=[];for(var e=0;e<g.length;e++){if(g[e]){j.push(g[e]);f.push(b[e]);this.legend.oncoprint.colors[g[e]]=h[e];if(h[e]=="rgb(220,220,220"){this.legend.oncoprintMutations=j.length}}}var d=this.NN(j,this.legendTextFont);var c=this.DU(d,this.legendTextFont);var a=Math.ceil(c+5+(this.margin*8));var h=Math.floor(this.width/a);var l=Math.ceil(j.length/h);this.legend.oncoprint.width=a*h;this.legend.oncoprint.height=((21+this.margin)*l)+this.margin;this.legend.oncoprint.rows=l;this.legend.oncoprint.cols=h;this.legend.oncoprint.labels=j;this.legend.oncoprint.objects=f}};this.v1=function(){this.legend.sample.width=0;this.legend.sample.height=0;this.legend.sample.columns=this.legendColumns;this.legend.sample.maxStr="";this.legend.sample.maxStrLen=0;this.legend.sample.n=1;var k=this.HU(this.legendTextFont);var g=0;var h=0;var a=[];var b={};if(this.ridgeBy&&this.dataStndBy.y.smps.length==1){return}if(this.colorBy&&this.meta.data.x&&this.meta.data.x.hasOwnProperty(this.colorBy)&&((this.xAxisIndices&&this.xAxisIndices.length==1)||(this.yAxisIndices&&this.yAxisIndices.length==1))){return}if(this.isHistogram&&this.um()){for(var d=0;d<this.data.l.axes.length;d++){for(var c=0;c<this.data.l.axes[d].yAxis.length;c++){if(this.data.l.axes[d].yAxis[c]){if(this.segregateVariablesBy.length||!this.data.l.axes[d].yAxis[c].match(":")){b[this.data.l.axes[d].yAxis[c].split(":")[0]]=true}else{if(this.data.l.axes.length==this.dataStndBy.y.smps.length){b[this.data.l.axes[d].yAxis[c].split(":")[1]]=true}else{b[this.data.l.axes[d].yAxis[c]]=true}}}}}a=this.NU(b)}if(this.graphType.match(/Scatter/)){h=this.ridgeBy?this.dataStndBy.y.smps.length:Math.max(this.xAxisIndices.length,this.yAxisIndices.length);if(this.ridgeBy){g=this.DU(this.fK(this.NN(this.dataStndBy.y.smps),this.maxSmpStringLen),this.legendTextFont)}else{if(this.isHistogram){g=this.DU(this.fK(this.NN(this.data.y.smps),this.maxSmpStringLen),this.legendTextFont);h=this.data.y.smps.length-1;if(this.um()){h=a.length;g=this.DU(this.fK(this.NN(a),this.maxSmpStringLen),this.legendTextFont)}else{if(this.histogramAsDotplot&&this.colorBy){g=0}}}else{if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var d=0;d<this.xAxisIndices.length;d++){var f=this.fK(this.xAxis[d],this.maxSmpStringLen)+" vs "+this.fK(this.yAxis[d],this.maxSmpStringLen);var e=this.DU(f,this.legendTextFont);if(e>g){this.legend.sample.maxStr=f}g=Math.max(e,g)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){if(this.yAxisIndices.length==1){this.legend.sample.maxStr=this.fK(this.NN(this.xAxis),this.maxSmpStringLen)}else{this.legend.sample.maxStr=this.fK(this.NN(this.xAxis),this.maxSmpStringLen)+" vs "+this.fK(this.yAxis[0],this.maxSmpStringLen)}g=this.DU(this.legend.sample.maxStr,this.legendTextFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){if(this.xAxisIndices.length==1){this.legend.sample.maxStr=this.fK(this.NN(this.yAxis),this.maxSmpStringLen)}else{this.legend.sample.maxStr=this.fK(this.NN(this.yAxis),this.maxSmpStringLen)+" vs "+this.fK(this.xAxis[0],this.maxSmpStringLen)}g=this.DU(this.legend.sample.maxStr,this.legendTextFont)}}}}}}if(g){this.legend.sample.n=h;this.legend.sample.maxStrLen=g;this.legend.sample.width=((k+g+(this.legendTextMargin*2))*this.legend.sample.columns)+(this.legendTextMargin*2);this.legend.sample.height=(Math.ceil(h/this.legend.sample.columns)*(k+this.legendTextMargin))+this.legendTextMargin}}};this.BY=function(o){if(this.showLegend){this.legend.variable.width=0;this.legend.variable.height=0;this.legend.variable.columns=o||(this.varIndices&&this.legendColumns>this.varIndices.length?this.varIndices.length:this.legendColumns);var h=this;var r=this.legend.variable.columns;if(!this.variableShowLegend){return}var i=function(){if(h.circularType.match(/normal/)){if(h.ringGraphType.length){for(var d=0;d<h.ringGraphType.length;d++){if(h.ringGraphType[d]!="heatmap"){return true}}return false}}return true};var g=function(){if(h.isDOE&&h.layoutCurrentDOE){if(h.layoutCurrentDOE){if(h.meta.data.x&&h.meta.data.x.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.x[h.layoutCurrentDOE]}else{if(h.meta.data.z&&h.meta.data.z.hasOwnProperty(h.layoutCurrentDOE)){return h.meta.data.z[h.layoutCurrentDOE]}}}}return h.meta.data.y};var c=g();var a=this.HU(this.legendTextFont);if(this.graphType=="Fish"){var s=this.HU(this.legendTextFont);var b=this.varIndices.length;var f=this.fK(c.maxVarStr,this.maxVarStringLen);this.legend.variable.width=((a+(this.legendTextMargin*2)+this.DU(f,this.legendTextFont))*r)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,r))*(s+this.legendTextMargin))+(this.legendTextMargin*2)}if(this.graphType=="Pie"){var b=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var f=this.isDOE&&this.layoutCurrentDOE?this.fK(c.maxLevStr,this.maxVarStringLen):this.fK(c.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&f.length<5){f=this.fK("Other",this.maxVarStringLen)}var e=this.DU(f,this.legendTextFont)+a+(this.legendTextMargin*3);var q=this.layoutComb&&this.isDOE?this.layoutWidth:this.width;var k=(1-this.percentAspectRatioPlotArea);this.legend.variable.width=e>q*k?q*k:this.DU(f,this.legendTextFont)+a+(this.legendTextMargin*5);this.legend.variable.height=((a+this.legendTextMargin)*b)+(this.legendTextMargin*2)}else{if(this.layoutValid&&this.segregateVariablesBy.length>0&&!this.graphType.match(/Scatter/)){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{if(!this.colorBy||(this.colorBy&&this.colorBy=="variable")){var s=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.DU(s,this.legendTextFont))*r)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(this.varIndices.length/Math.min(b,r))*(a+this.legendTextMargin))+this.legendTextMargin}else{return}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var s=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.HU(this.legendTextFont)):this.HU(this.legendTextFont);var b=this.varIndices.length;var f=this.fK(c.maxVarStr,this.maxVarStringLen);this.legend.variable.width=s+this.DU(f,this.legendTextFont)+((this.legendTextMargin*2)*Math.min(b,r))+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,r))*(s+this.legendTextMargin))+(this.legendTextMargin*2)}else{if(!this.colorBy&&(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine")){var s=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.xAxisVarIndices.length+this.xAxis2VarIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.DU(s,this.legendTextFont))*r)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(b/Math.min(b,r))*(a+this.legendTextMargin))+this.legendTextMargin}else{if(!this.colorBy&&(this.graphType=="Bar"||(this.graphType=="Line"&&!this.lineBy)||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var s=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var b=this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.DU(s,this.legendTextFont))*r)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(this.varIndices.length/Math.min(b,r))*(a+this.legendTextMargin))+this.legendTextMargin}else{if(this.graphType=="Circular"){if(!this.showIdeogram&&i()){var s=c.maxVarChr>this.maxVarStringLen?c.maxVarStr.substring(0,this.maxVarStringLen):c.maxVarStr;var j=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legend.variable.width=((a+(this.legendTextMargin*2)+this.DU(s,this.legendTextFont))*r)+(this.legendTextMargin*2);this.legend.variable.height=(Math.ceil(j/Math.min(j,r))*(a+this.legendTextMargin))+this.legendTextMargin}}}}}}}if(this.legend.variable.height>this.height){this.legend.variable.columns++;this.maxVarStringLen=Math.max(10,this.maxVarStringLen-5);this.BY(this.legend.variable.columns)}}};this.fE=function(){var a=this.data.venn.legend?this.NN(this.data.venn.legend):"N/A";this.legend.width=this.DU(a,this.legendTextFont)+(this.margin*6);this.legend.height=this.margin+this.margin+((this.HU(this.legendTextFont)+this.margin)*this.vennGroups)};this.Fg=function(){var b=this.HU(this.legendTextFont)+2;var t=this.TM();var l=Math.max(b,t);var d=["varOverlays","smpOverlays"];var f=["varOverlayProperties","smpOverlayProperties"];var z=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legend.overlays.layout=[];this.legend.overlays.width=0;this.legend.overlays.height=0;var r=this.margin;var p=this.margin;var a=0;var k=0;var n=0;var C=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)&&this.graphType!="Circular"){for(var x=0;x<d.length;x++){if(this[d[x]].length>0&&this[z[x]]){for(var u=0;u<this[d[x]].length;u++){var g=0;var y=0;var q=this[d[x]][u];if(q!="-"){var B=d[x]=="varOverlays"?"z":"x";var s=this.meta.data[B][q];var v=this.DU(s.maxLevStr,this.legendTextFont);var A=this.DU(q,this.legendTitleFont);var e=this[f[x]][q].legendColumns||this[d[x]+"LegendColumns"];if(this.graphType=="Circular"||(this[f[x]][q]&&this[f[x]][q].showLegend)){C=true;if(this[f[x]][q].type=="Default"){if(s.type=="String"){g=Math.max(A,v+l+(this.margin*3))*e;y=((Math.max(b,t)+this.margin)*Math.ceil(s.levels.length/e))+b+this.margin}else{if(this.overlaysLegendPosition.match(/right/i)){g=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+v,A);y=this.heatmapIndicatorWidth+(this.margin*3)+b}else{g=this.heatmapIndicatorWidth+(this.margin*3)+b;y=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+v,A)}}}else{if(this[f[x]][q].type.match(/Area|Bar|Dotplot|Line|Stacked|Pie|Treemap/)){g=Math.max(b,t)+A+(this.margin*2);y=Math.max(b,t)+this.margin}else{continue}}if(!this.legend.overlays[q]){this.legend.overlays[q]={}}this.legend.overlays[q].width=g;this.legend.overlays[q].height=y;if(this.overlaysLegendPosition.match(/right/i)){if(k+this.margin+y>(this.height-(this.top+this.bottom))){r+=this.margin+g;a=g;k=y;if(this.legend.overlays.layout[n]){n++}this.legend.overlays.layout[n]=[[B,q,g,y]]}else{if(g>a){r+=(g-a);a=g}k+=y;if(!this.legend.overlays.layout[n]){this.legend.overlays.layout[n]=[]}this.legend.overlays.layout[n].push([B,q,g,y])}}else{if(a+this.margin+g>(this.width-(this.left+this.right))){p+=this.margin+y;a=g;k=y;if(this.legend.overlays.layout[n]){n++}this.legend.overlays.layout[n]=[[B,q,g,y]]}else{if(y>k){p+=(y-k);k=y}a+=g;if(!this.legend.overlays.layout[n]){this.legend.overlays.layout[n]=[]}this.legend.overlays.layout[n].push([B,q,g,y])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legend.overlays.width=C?r+this.margin:0;this.legend.overlays.height=C?k+this.margin:0}else{this.legend.overlays.width=C?a+this.margin:0;this.legend.overlays.height=C?p+this.margin:0}};this.UT=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legend.layout=[];this.legend.width=0;this.legend.height=0;var a=this.margin;var l=this.margin;var c=0;var k=0;var j=0;var f=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge","decoration"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","sample","contour","bin2d","colorLabel","sizeLabel"];for(var d=0;d<f.length;d++){var b="show"+this.YX(f[d])+"Legend";var g=this.legend[f[d]].width;var e=this.legend[f[d]].height;if(f[d]=="decoration"&&!this.showDecorations){continue}if(f[d]=="size"&&this.graphType=="Map"&&this.decorations&&this.decorations.pie){continue}if(g>0){if(this.graphType=="Network"&&f[d]!="decoration"&&!this[b]){continue}if(this.legendPosition.match(/right|left/i)){if(k+this.margin+e>this.height){a+=this.margin+g;c=g;k=e;this.legend.layout[j]=[f[d]];j++}else{if(g>c){a+=(g-c);c=g}k+=e;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(f[d])}}else{if(c+this.margin+g>this.width){l+=this.margin+e;c=g;k=e;this.legend.layout[d]=[f[d]];j++}else{if(e>k){l+=(e-k);k=e}c+=g;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(f[d])}}}}for(var d=0;d<this.customLegend.length;d++){this.customLegend[d].id="custom"+d;this.fS(this.customLegend[d]);var g=this.legend["custom"+d].width;var e=this.legend["custom"+d].height;if(this.legendPosition.match(/right|left/i)){if(k+this.margin+e>this.height){a+=this.margin+g;c=g;k=e;this.legend.layout[j]=[this.customLegend[d].id];j++}else{if(g>c){a+=(g-c);c=g}k+=e;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(this.customLegend[d].id)}}else{if(c+this.margin+g>this.width){l+=this.margin+e;c=g;k=e;this.legend.layout[d]=[this.customLegend[d].id];j++}else{if(e>k){l+=(e-k);k=e}c+=g;if(!this.legend.layout[j]){this.legend.layout[j]=[]}this.legend.layout[j].push(this.customLegend[d].id)}}}this.legend.width=c==0&&a==this.margin?0:this.legendPosition.match(/right|left/i)?a+this.margin:c+this.margin;this.legend.height=k==0&&l==this.margin?0:this.legendPosition.match(/right|left/i)?k+this.margin:l+this.margin}};this.Pc=function(w){var k=this;var j=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge"]:this.connectByNoColor?["color","shape","size","pattern","outline"]:["color","shape","size","line","pattern","outline","connect","contour","bin2d","colorLabel","sizeLabel"];var z=["colorByData","shapeByData","sizeByData","patternByData","outlineByData"];var v=function(a,b,x){var y=b=="outline"?"color":b;var p=(k.NW(y)+"s").replace("Node","").replace("Edge","").replace("Label","").replace("decorations","colors");delete (k.legend[y].levels);k.legend[y].meta=a;k.legend[y].meta.title=k[y+"By"];if(x){k.legend[y].meta.vals=k.colorSpectrumBreaks.length?k.colorSpectrumBreaks:k.ct(x[0],x[1],5);k.legend[y].meta.decs=k.Pi(x[1]-x[0]);k.legend[y].meta.maxLevStr=k.NN(k.legend[(b=="outline"?"color":b)].meta.vals);k.legend[y].meta.maxLevLen=k.DU(k.legend[y].meta.maxLevStr,k.font);k.legend[y].meta.maxLevChr=k.legend[y].meta.maxLevStr.toString().length}if(k.ridgeBy&&k.colorBy=="data"){k.legend[y].meta.min=k.legend[y].meta.vals[0];k.legend[y].meta.max=k.legend[y].meta.vals[k.legend[y].meta.vals.length-1]}k.legend[y].max=k.legend[y].meta.maxLevStr;k.legend[y].n=k.legend[y].meta.vals.length;if(!k.legend[y].m){k.legend[y].m=[]}for(var o=0;o<k.legend[y].meta.vals.length;o++){k.legend[y].m[k.legend[y].meta.vals[o].toString()]=y=="connect"?k.colors[o]:y=="contour"?k.Wk(a,k.legend[y].meta.vals[o]):y=="bin2d"?k.Wk(a,k.legend[y].meta.vals[o]):k[p][o%k[p].length]}k.sB(b,k.legend[y].meta)};var n=function(G,N,C,I,D){var K=0;var A=0;var F=false;var H={};var b={};var a=G[k.NW(I).replace("Node","").replace("Edge","").replace("Label","")+"s"]||k[k.NW(I).replace("Node","").replace("Edge","").replace("Label","")+"s"];var E=k.isGroupedData&&k.graphType!="Dotplot"&&k.graphType!="Boxplot"&&!k.showBoxplotOriginalData&&k.groupingFactors.length==1;if(N=="x"){var x;if(k.graphType=="Scatter2D"){x=k.xAxisIndices.length==1?k.yAxisIndices:k.yAxisIndices.length==1?k.xAxisIndices:k.smpIndices}else{x=k.isGroupedData?k.grpIndices:k.smpIndices}for(var L=0;L<x.length;L++){var y=x[L];if(k.isGroupedData&&(k.graphType=="Dotplot"||k.graphType=="Boxplot"||k.barType=="swimmer"||k.graphType=="Gantt"||k.stackBy||k.lineBy||k.dodgeBy)){k.isGroupedData=false;for(var J=0;J<k.data.w.grps[y].length;J++){var B=k.d2(k.data.w.grps[y][J],N,k[C]);b[B]=true}k.isGroupedData=true}else{var B;if(k.isGroupedData){k.isGroupedData=false;B=k.fU(k[C],k.data.w.grps[L],true);k.isGroupedData=true}else{B=k.d2(y,N,k[C])}b[B]=true}}}else{if(N=="z"){if((k.graphType=="Map"&&k.varIndices.length<G.levels.length)||(k.isCreateHistogram&&k.histogramAsDotplot)){for(var L=0;L<G.levels.length;L++){var B=G.levels[L];b[B]=true}}else{for(var L=0;L<k.varIndices.length;L++){var y=k.varIndices[L];var B=k.d2(y,N,k[C]);b[B]=true}}}else{if(N=="m"){for(var L=0;L<k.varIndices.length;L++){for(var J=0;J<k.smpIndices.length;J++){var B=D[k.varIndices[L]][k.smpIndices[J]];b[B]=true}}}else{if(N=="modified"){G.order={};for(var L=0;L<G.levels.length;L++){b[G.levels[L]]=true;G.order[G.levels[L]]=L}}else{if(N=="nodes"||N=="edges"){G.order={};for(var L=0;L<G.levels.length;L++){b[G.levels[L]]=true;G.order[G.levels[L]]=L}}}}}}b=k.NU(b);if(G.type=="Numeric"){if(G.orderS){b.sort(function(l,i){return G.orderS[l]-G.orderS[i]})}else{b.sort(function(l,i){return l-i});G.orderS={};for(var L=0;L<b.length;L++){G.orderS[b[L]]=L}}}else{b.sort(function(l,i){return G.order[l]-G.order[i]})}for(var L=0;L<b.length;L++){var B=b[L]!=null?b[L]:"NA";var M=k.DU(B,k.legendTextFont);if(M>K){K=M;k.legend[I].max=B}H[B]=(G.type=="Numeric"?G.orderS[B]:G.order[B])%a.length;k.legend[I].m[B]=a[H[B]];A++}k.legend[I].levels=b;F=N=="m"||N=="modified"?k.legend[I].max:false;k.legend[I].n=A;k.legend[I].meta=G;k.HI(I,F,G)};if(!this.hiddenLegends){this.hiddenLegends={}}this.u6();this.cV();if(this.graphType=="Meter"||this.graphType=="Correlation"){return}else{if(this.graphType=="Venn"){this.fE();return}else{if(this.graphType=="Network"){for(var h=0;h<j.length;h++){var f=j[h];var u=this.NW(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0;if(this[c]){var e=this.meta.data[f.match("Node")?"nodes":"edges"][this[c]];if(e.type=="Numeric"){v(e,f)}else{n(e,f.match("Node")?"nodes":"edges",c,f)}}}if(this.decorations.length&&this.decorationsType=="heatmap"&&this.meta.data.decorations.n&&this.showDecorations){var e=this.meta.data.decorations;var f="decoration";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0;v(e,f)}}else{if(this.isMultidimensionalData){for(var h=0;h<z.length;h++){if(this.data.y[this[z[h]]]){var d=this.data.y[this[z[h]]];var e=this.meta.data[this[z[h]]];var f=z[h].replace("ByData","");var u=this.NW(f);var c=u+"By";this.legend[(f=="outline"?"color":f)].m=[];this.legend[(f=="outline"?"color":f)].n=0;if(e.type=="Numeric"){v(e,f)}else{n(e,"m",c,f,d)}}}}else{if(this.scatterType=="bin2d"){for(var h=0;h<j.length;h++){var f=j[h];var u=this.NW(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0}if(!this.meta.data.b.g){var q=this.xAxisIndices[this.xAxisCurrent];var g=this.yAxisIndices[this.yAxisCurrent];var t=this.nO(q,"x");var s=this.nO(g,"y");var r=this.xp(t,s);this.meta.data.b.g=r;this.meta.data.b.c=r.brew}var f="bin2d";var e=this.meta.data.b.c;v(e,f)}else{if(this.isContour&&this.contourFilled){for(var h=0;h<j.length;h++){var f=j[h];var u=this.NW(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0}if(!this.meta.data.q.g.length||!this.meta.data.q.g[0]||!this.meta.data.q.g[0].data){this.L0(this.isContour,true)}var f="contour";var e=this.meta.data.q.g[0].data.colorBrew;v(e,f)}else{for(var h=0;h<j.length;h++){var f=j[h];var u=this.NW(j[h]);var c=u+"By";this.legend[f].m={};this.legend[f].n=0;this.legend[f].width=0;this.legend[f].height=0;if(w){continue}if(this.graphType=="Scatter2D"&&this.lineBy&&(this.ribbonBy||this.isCxplot)&&this.colorBy==this.lineBy&&c=="colorBy"){continue}if(this[c]){if(this.data.x&&this.data.x.hasOwnProperty(this[c])){var e=this.meta.data.x[this[c]];this[u+"ByType"]="x";if(e.type=="Numeric"&&!e[c]){v(e,f)}else{n(e,"x",c,f)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[c])){var e=this.meta.data.z[this[c]];this[u+"ByType"]="z";if(e.type=="Numeric"&&!e[c]){v(e,f,this.colorSpectrumBreaks.length?true:false)}else{n(e,"z",c,f)}}else{if(this.uL(this[c])>-1&&this.meta.data.y.range[this[c]]){var e=this.meta.data;if(e.modified&&e.modified.z&&e.modified.z[this[c]]){e=e.modified.z;if(!e.meta){e.meta={}}e.meta[this[c]]={levels:e[this[c]]};n(e.meta[this[c]],"modified",c,f)}else{e=e.y.range[this[c]];v(e,f,[e.min,e.max])}}else{if(this[c]=="variable"){k.legend[f].n=this.varIndices.length}else{if(this.ridgeBy&&this[c]=="data"){v({type:"Numeric"},f,[this.xAxisMin,this.xAxisMax])}else{if(this.isCreateHistogram&&this.histogramAsDotplot&&this.dataStndBy&&this.dataStndBy.z&&this.dataStndBy.z.hasOwnProperty(this[c])){var e=this.meta.data.z[this[c]];if(e.type=="Numeric"&&!e[c]){v(e,f)}else{n(e,"z",c,f)}}}}}}}}}}}}}}}this.UK();this.v1();this.BY();this.t3();this.Fg();this.UT()};this.SY=function(c,b){if(c){if(b){var a=this.e7(b);c.x=a.x;c.y=a.y}this.customLegend.push(c)}};this.wi=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.customLegend.length;a++){if(this.customLegend[a].id!=c.id){b.push(this.customLegend[a])}}this.customLegend=b}};this.iN=function(){if(this.decorationsClipped){this.tA({p:["setClipArea",this.Ei()],t:"Decorations"})}var aq=this.marginLeft+this.offsetX+this.left;var al=this.marginTop+this.offsetY+this.top;var aA=this.decorations;var az=["line","text","label","point","range","image"];if(this.showDecorations&&aA){if(this.graphType.match(/Scatter/)){var aC=["linear","exponential","logarithmic","power","polynomial"];for(var av=0;av<aC.length;av++){if(aA[aC[av]]){var aB=aA[aC[av]];for(var au=0;au<aB.length;au++){var bc=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[au];var aX=this.yAxisIndices.length==1?this.yAxisIndices[0]:this.yAxisIndices[au];var a6=this.zB(bc);var aR=this.zB(aX);var Y=aA[aC[av]][au].color||this.colors[au%this.colors.length];var aZ=[];var P=this.varIndices.sort(function(f,d){return a6[f]-a6[d]});for(var at=0;at<P.length;at++){var e=P[at];aZ.push([a6[e],aR[e]])}var ao=this[aC[av]+"Regression"](aZ);var a5=[];var a0=[];if(ao&&ao.predict){for(var at=0;at<ao.predict.length;at++){S=aq+((ao.predict[at][0]-this.xAxisMin)*this.xAxisUnit);q=(al+this.y)-((ao.predict[at][1]-this.yAxisMin)*this.yAxisUnit);a5.push(S);a0.push(q)}if(a5.length>0){this.tA({p:["drawLine","spline",a5,a0,false,false,Y,1],i:["Decor-"+aC[av]+"-"+au],t:"Decorations"})}}}}}if(aA.nlfit||aA.nonlinear){var r,aa,p;var P=this.varIndices;var S,q;var aI=aA.nlfit?aA.nlfit:aA.nonlinear;for(var av=0;av<aI.length;av++){var a5=[];var a0=[];var Y=av%this.colors.length;var a=Number(this.ZA(this.yAxisTransform,aI[av].param[0]));var bf=Number(this.ZA(this.yAxisTransform,aI[av].param[1]));var be=Number(aI[av].param[2]);var bd=Number(aI[av].param[3]);var an=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[av];var a6=this.zB(an);if(this.xAxisTransform=="percentile"){r=this.w8(a6);p=r[0];aa=r[1]}P.sort(function(f,d){return a6[f]-a6[d]});Y=aI[av].color?aI[av].color:this.colors[Y];for(var au=0;au<P.length;au++){var K=P[au];var af=this.RE(K,an);var ae;var X=[];if(af>0){if(au>0){var a4=P[au-1];var a8=this.RE(a4,an);if(a8>0){var ag=(af-a8)/25;for(var at=0;at<25;at++){X.push(a8);a8+=ag}}}else{X=[af]}for(var at=0;at<X.length;at++){if(aI[av].type=="reg"){ae=a+((bf-a)/(1+be/(Math.pow(X[at],bd))))}else{ae=a+((bf-a)/(1+(Math.pow((X[at]/be),bd))))}if(this.xAxisTransform){X[at]=this.xAxisTransform=="percentile"?this.EQ(p,aa,X[at]):this.ZA(this.xAxisTransform,X[at])}S=aq+((X[at]-this.xAxisMin)*this.xAxisUnit);q=(al+this.y)-((ae-this.yAxisMin)*this.yAxisUnit);a5.push(S);a0.push(q)}}}if(a5.length>0){this.tA({p:["drawShape","path",a5,a0,false,false,Y,Y,"open",false,false,true],i:["Decor-Non-Lin-"+au+"-"+av],t:"Decorations"});if(aI[av].type=="reg"){ae=a+((bf-a)/(1+be/(Math.pow(be,bd))))}else{ae=a+((bf-a)/(1+(Math.pow((be/be),bd))))}if(this.xAxisTransform){be=this.xAxisTransform=="percentile"?this.EQ(p,aa,be):this.ZA(this.xAxisTransform,be)}S=aq+((be-this.xAxisMin)*this.xAxisUnit);q=(al+this.y)-((ae-this.yAxisMin)*this.yAxisUnit);var aY=this.tA({p:["drawLine","dottedLine",aq,q,S,q,Y],i:["Decor-Non-Lin-EC-h"+au+"-"+av],t:"Decorations"});this.tA({p:["drawLine","dottedLine",S,q,S,(al+this.y),Y],i:["Decor-Non-Lin-EC-v"+au+"-"+av],g:aY,t:"Decorations"})}}}if(aA.reg||aA.regression){var aB=aA.reg?aA.reg:aA.regression;for(var av=0;av<aB.length;av++){if(aB[av].slope&&aB[av].intercept){var Y=aB[av].color?aB[av].color:this.colors[av%this.colors.length];var R=this.xh(Y,0.3,true);var u=this.GF(av,false,"patternBy");var aD=aB[av].style?aB[av].style:this.fitLineStyle;var bb=Number(aB[av].slope);var ax=Number(aB[av].intercept);var ar=aB[av].id;var T=aB[av].cor;var H="y ~ "+this.qo(bb,this.yAxisDecs+1)+"x + "+this.qo(ax,this.yAxisDecs+1)+(T?" (r = "+this.qo(T,3)+")":"");var ai=aB[av].ci?aB[av].ci:false;var U=ai?ai.length-1:false;var S=this.showRegressionFullRange||!ai?this.xAxisMin:ai[0][0];var q=(bb*S)+ax;var Q=this.showRegressionFullRange||!ai?this.xAxisMax:ai[U][0];var o=(bb*Q)+ax;S=aq+(S*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);Q=aq+(Q*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);o=(al+this.y)-(o*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var aT=this.RW([[S,q],[Q,o]]);if(aT.length){this.tA({p:["drawLine",aD,aT[0][0][0],aT[0][0][1],aT[0][1][0],aT[0][1][1],Y,2],i:["Decor-Reg-"+av,ar],t:"Decorations",h:this.vK(false,false,ar)})}if(ai){var I=[];var F=[];var aM=[];for(var au=0;au<ai.length;au++){q=ai[au][1];o=ai[au][2];S=aq+(ai[au][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(q*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);o=(al+this.y)-(o*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);I.push([S,S]);F.push([q,o]);aM.push([S,(q+o)/2])}if(this.showConfidenceIntervals){this.tA({p:["drawShape","confidence",I,F,false,false,R,this.isCxplot?R:Y,u],i:[H+":Confidence",ar],b:aM,t:"Decorations",h:this.vK(false,false,ar)})}}}}}if(aA.nor||aA.normal){var a7=aA.nor?aA.nor:aA.normal;for(var av=0;av<a7.length;av++){if(a7[av].mu&&a7[av].sigma){var O=[];var M=[];var aZ=[];var S,q;var Y=av%this.colors.length;var aN=a7[av].mu;var aJ=a7[av].sigma;var C=a7[av].start?a7[av].start:a7[av].yAxis?this.yAxisMin:this.xAxisMin;var aw=a7[av].end?a7[av].end:a7[av].yAxis?this.yAxisMax:this.xAxisMax;var aQ=120;if(C<aN&&aN<aw){var a8,aS,D,n;var ag=(aN-C)/aQ;var G=aJ*aJ;var ay=1/Math.sqrt(2*Math.PI*G);if(a7[av].yAxis){D=a7[av].max?a7[av].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);n=D/ay;a8=C;for(var au=0;au<aQ-1;au++){aS=(ay*Math.pow(Math.E,-Math.pow(a8-aN,2)/G));aZ.push([a8,aS]);S=aq+(aS*n);q=(al+this.y)-(a8*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);O.push(S);M.push(q);a8+=ag}ag=(aw-aN)/aQ;a8=aN;for(var au=0;au<aQ;au++){aS=(ay*Math.pow(Math.E,-Math.pow(a8-aN,2)/G));aZ.push([a8,aS]);S=aq+(aS*n);q=(al+this.y)-(a8*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);O.push(S);M.push(q);a8+=ag}Y=a7[av].color?a7[av].color:this.colors[Y];this.tA({p:["drawShape","path",O,M,false,false,Y,Y,"open",false,false,true],i:["Decor-Nor-"+av],t:"Decorations"})}else{D=a7[av].max?a7[av].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);n=D/ay;a8=C;for(var au=0;au<aQ-1;au++){aS=(ay*Math.pow(Math.E,-Math.pow(a8-aN,2)/G));aZ.push([a8,aS]);S=aq+(a8*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(aS*n);O.push(S);M.push(q);a8+=ag}ag=(aw-aN)/aQ;a8=aN;for(var au=0;au<aQ;au++){aS=(ay*Math.pow(Math.E,-Math.pow(a8-aN,2)/G));aZ.push([a8,aS]);S=aq+(a8*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);q=(al+this.y)-(aS*n);O.push(S);M.push(q);a8+=ag}Y=a7[av].color?a7[av].color:this.colors[Y];this.tA({p:["drawShape","path",O,M,false,false,Y,Y,"open",false,false,true],i:["Decor-Nor-"+av],t:"Decorations"})}}}}}for(var av=0;av<az.length;av++){if(aA[az[av]]){for(var au=0;au<aA[az[av]].length;au++){if(aA[az[av]][au].x!=null||aA[az[av]][au].y!=null){var S,q,Q,o,b,aH,aG;aA[az[av]][au].id=aA[az[av]][au].id==null?this.Ph("-decoration-"):aA[az[av]][au].id;var af=aA[az[av]][au].x!=null?aA[az[av]][au].x:null;var ae=aA[az[av]][au].y!=null?aA[az[av]][au].y:null;var N=aA[az[av]][au].x2!=null?aA[az[av]][au].x2:null;var m=aA[az[av]][au].y2!=null?aA[az[av]][au].y2:null;var aW=aA[az[av]][au].width?aA[az[av]][au].width:(az[av]=="point"?this.dataPointSize*1:1);var E=aA[az[av]][au].height?aA[az[av]][au].height:(az[av]=="point"?this.dataPointSize*1:1);var J=aA[az[av]][au].color?aA[az[av]][au].color:this.colors[au%this.colors.length];var aE=aA[az[av]][au].type?aA[az[av]][au].type:az[av];var v=aA[az[av]][au].label||false;var B=aA[az[av]][au].wrap||false;var A=aA[az[av]][au].justify||false;var aP=aA[az[av]][au].font||this.decorationsTextFont;var Z=aA[az[av]][au].color||this.decorationsTextColor;var aF=aA[az[av]][au].background||this.background;var a9=aA[az[av]][au].align||"left";var aD=az[av]=="line"&&aE!="line"?aE:aA[az[av]][au].style?aA[az[av]][au].style:"line";var W=aA[az[av]][au].shape||"circle";var ad=aA[az[av]][au].src||false;if(this.isCxplot&&this.decorationsTransform){if(this.xAxisTransform){if(af){af=this.ZA(this.xAxisTransform,af)}if(N){N=this.ZA(this.xAxisTransform,N)}}if(this.yAxisTransform){if(ae){ae=this.ZA(this.yAxisTransform,ae)}if(m){m=this.ZA(this.yAxisTransform,m)}}}var z=this.pe(af)&&this.pe(ae)&&N==null&&m==null;if(az[av]=="range"||az[av]=="point"){if(az[av]=="point"&&aA[az[av]][au].width){aW=aA[az[av]][au].width*this.xAxisUnit}if(az[av]=="point"&&aA[az[av]][au].height){E=aA[az[av]][au].height*this.yAxisUnit}}if(this.isCreateHistogram){if(af!=null){af-=this.isCreateHistogram.min}if(N!=null){N-=this.isCreateHistogram.min}}if(aA[az[av]][au].scope){var aK=this.layoutValid?false:true;if(this.layoutValid){var ak=this.data.l.name[this.layoutCurrent];if(!this.pe(ak)){ak=[ak]}for(var at=0;at<ak.length;at++){if(aA[az[av]][au].scope.toString()==ak[at].toString().replace("\x00","")){aK=true;break}}}if(!aK){continue}}if(z){var aL=null;for(var at=1;at<af.length;at++){S=aq+((af[at-1]-this.xAxisMin)*this.xAxisUnit);Q=aq+((af[at]-this.xAxisMin)*this.xAxisUnit);q=al+this.y-((ae[at-1]-this.yAxisMin)*this.yAxisUnit);o=al+this.y-((ae[at]-this.yAxisMin)*this.yAxisUnit);aG=v?v:"";if(au==1){aL=this.tA({p:["drawLine",aD,S,q,Q,o,J,aW],i:[aG+":Decoration-"+at],t:"Decorations"})}else{this.tA({p:["drawLine",aD,S,q,Q,o,J,aW],i:[aG+":Decoration-"+at],g:aL,t:"Decorations"})}}}else{if(af!=null&&ae!=null&&N!=null&&m!=null&&(az[av].match(/line|range/))){S=aq+((af-this.xAxisMin)*this.xAxisUnit);Q=aq+((N-this.xAxisMin)*this.xAxisUnit);q=al+this.y-((ae-this.yAxisMin)*this.yAxisUnit);o=al+this.y-((m-this.yAxisMin)*this.yAxisUnit);aG=aA[az[av]][au].tooltip||("("+af+","+ae+") &rarr; ("+N+","+m+")");if(az[av]=="range"){b=Math.abs(Q-S);aH=Math.abs(o-q);this.tA({p:["drawShape","rectangle",(S+Q)/2,(q+o)/2,b,aH,J,aA[az[av]][au].outline||J,aA[az[av]][au].pattern,aA[az[av]][au].rotate],i:[aG+":Decoration-"+au],t:"Decorations"})}else{this.tA({p:["drawLine",aD,S,q,Q,o,J,aW],i:[aG+":Decoration-"+au],t:"Decorations"})}}else{if(af!=null){S=aq+((af-this.xAxisMin)*this.xAxisUnit);if(az[av]=="line"||az[av]=="range"){q=al;Q=az[av]=="range"&&N!=null?aq+((N-this.xAxisMin)*this.xAxisUnit):S;o=q+this.y;if(az[av]=="range"){aG=aA[az[av]][au].tooltip||"x "+(this.isCreateHistogram?af+this.isCreateHistogram.min:af)+" &rarr; "+(this.isCreateHistogram?N+this.isCreateHistogram.min:N);b=Math.abs(Q-S);aH=Math.abs(o-q);this.tA({p:["drawShape","rectangle",(S+Q)/2,(q+o)/2,b,aH,J,aA[az[av]][au].outline||J,aA[az[av]][au].pattern,aA[az[av]][au].rotate],i:[aG+":Decoration-"+au],t:"Decorations"})}else{aG=aA[az[av]][au].tooltip||"x &rarr; "+(this.isCreateHistogram?af+this.isCreateHistogram.min:af);this.tA({p:["drawLine",aD,S,q,Q,o,J,aW],i:[aG+":Decoration-"+au],t:"Decorations"})}}else{if((az[av]=="point"||az[av]=="text"||az[av]=="label")&&ae!=null){q=al+this.y-((ae-this.yAxisMin)*this.yAxisUnit);Q=S;o=q;if(az[av]=="point"){aG=aA[az[av]][au].tooltip||this.qo(aA[az[av]][au].x,this.xAxisDecs)+", "+this.qo(aA[az[av]][au].y,this.yAxisDecs);this.tA({p:["drawShape",W,S,q,aW,E,J,J],i:[aG+":Decoration-"+au],t:"Decorations"})}else{aG=aA[az[av]][au].tooltip||v}}}}else{if(ae!=null){q=al+this.y-((ae-this.yAxisMin)*this.yAxisUnit);if(az[av]=="line"||az[av]=="range"){S=aq;Q=S+this.x;o=az[av]=="range"&&m!=null?al+this.y-((m-this.yAxisMin)*this.yAxisUnit):q;if(az[av]=="range"){aG=aA[az[av]][au].tooltip||"y "+ae+" &rarr; "+m;b=Math.abs(Q-S);aH=Math.abs(o-q);this.tA({p:["drawShape","rectangle",(S+Q)/2,(q+o)/2,b,aH,J,aA[az[av]][au].outline||J,aA[az[av]][au].pattern,aA[az[av]][au].rotate],i:[aG+":Decoration-"+au],t:"Decorations"})}else{aG=aA[az[av]][au].tooltip||"y &rarr; "+ae;this.tA({p:["drawLine",aD,S,q,Q,o,J,aW],i:[aG+":Decoration-"+au],t:"Decorations"})}}else{if((az[av]=="point"||az[av]=="text"||az[av]=="label")&&af!=null){S=aq+((af-this.xAxisMin)*this.xAxisUnit);Q=S;o=q;if(az[av]=="point"){aG=aA[az[av]][au].tooltip||this.qo(aA[az[av]][au].x,this.xAxisDecs)+", "+this.qo(aA[az[av]][au].y,this.yAxisDecs);this.tA({p:["drawShape",W,S,q,aW,E,J,J],i:[aG+":Decoration-"+au],t:"Decorations"})}else{aG=aA[az[av]][au].tooltip||v}}}}}}}if(S&&q&&v&&!z){if(aA[az[av]][au].y2!=null&&az[av]=="line"){var aV=this.yR(S,q,Q,o);if(a9=="right"){this.tA({p:["drawText",v,Q,o,aP,Z,"right","bottom",aV],t:"Decorations"})}else{if(a9=="center"){this.tA({p:["drawText",v,(S+Q)/2,(q+o)/2,aP,Z,"center","bottom",aV],t:"Decorations"})}else{this.tA({p:["drawText",v,S,q,aP,Z,"left","bottom",aV],t:"Decorations"})}}}else{var w=(az[av]=="text"||az[av]=="label")?-this.decorationsTextFontSize*0.5:this.margin;if(A){v=this.mn(v,A,aP)}else{if(B){v=this.pd(v,B)}}if(az[av]=="label"){var b=this.DU(v,aP)+this.margin*2;var aH=this.Db(v,aP)-this.margin*2}if(a9=="right"){this.tA({p:["drawShape","roundrect",S+w-((b/2)-(this.margin*3)),o-(w+this.margin),b,aH,aF,Z],t:"Decorations"});this.tA({p:["drawText",v,Q-w,o-w,aP,Z,"right","bottom"],t:"Decorations"})}else{if(a9=="center"){this.tA({p:["drawShape","roundrect",S+w+this.margin,o-(w+this.margin),b,aH,aF,Z],t:"Decorations"});this.tA({p:["drawText",v,(S+Q)/2,o-w,aP,Z,"center","bottom"],t:"Decorations"})}else{this.tA({p:["drawShape","roundrect",S+w+(b/2)-this.margin,o-(w+this.margin),b,aH,aF,Z],t:"Decorations"});this.tA({p:["drawText",v,S+w,o-w,aP,Z,"left","bottom"],t:"Decorations"})}}}}else{if(S&&q&&aW&&E&&az[av]=="image"&&ad){this.tA({p:["drawShape","image",S,q,aW,E,false,false,false,false,false,false,false,false,false,ad],t:"Decorations"})}}}}}}}else{if(aA.line){for(var av=0;av<aA.line.length;av++){var S,q,Q,o;aA.line[av].id=aA.line[av].id==null?this.Ph("-decoration-"):aA.line[av].id;var aK=true;var aE=aA.line[av].type||"line";var J=aA.line[av].color;var aj=this.ZA(this.isTransformedData,aA.line[av].value||0);var v=aA.line[av].label||false;var aW=aA.line[av].width||1;var a9=aA.line[av].align||"left";var aO=aA.line[av].scope||false;if(this.graphOrientation=="vertical"){S=this.marginLeft+this.offsetX+this.left;Q=S+this.x;q=this.marginTop+this.offsetY+this.top+this.y-((aj-this.xAxisMin)*this.xAxisUnit);o=q;aK=q<=this.marginTop+this.offsetY+this.top+this.y&&q>=this.marginTop+this.offsetY+this.top?true:false}else{S=this.marginLeft+this.offsetX+this.left+((aj-this.xAxisMin)*this.xAxisUnit);Q=S;q=this.marginTop+this.offsetY+this.top;o=q+this.y;aK=S<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(aK&&aO){if(this.layoutValid){aK=false;var ak=this.j1(this.data.l.name[this.layoutCurrent]);for(var au=0;au<ak.length;au++){if(aO==ak[au]){aK=true}}}}if(aK){var ab=this.isR?6:3;if(v){if(this.graphOrientation=="vertical"){if(a9=="right"){this.tA({p:["drawText",v,Q-this.margin,o-this.margin,this.decorationsTextFont,this.decorationsTextColor,"right","bottom"],t:"Decorations"})}else{if(a9=="center"){this.tA({p:["drawText",v,S+(this.x/2),o-this.margin,this.decorationsTextFont,this.decorationsTextColor,"center","bottom"],t:"Decorations"})}else{this.tA({p:["drawText",v,S+this.margin,o-this.margin,this.decorationsTextFont,this.decorationsTextColor,"left","bottom"],t:"Decorations"})}}}else{if(a9=="right"){this.tA({p:["drawText",v,Q+(this.margin*2),o-(this.margin*ab),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}else{if(a9=="center"){this.tA({p:["drawText",v,Q+(this.margin*2),q+(this.y/2),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}else{this.tA({p:["drawText",v,Q+(this.margin*2),q+(this.margin*ab),this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Decorations"})}}}}var aG=aA.line[av].tooltip||("&rarr; "+aj);this.tA({p:["drawLine",aE,S,q,Q,o,J,aW],i:[aG+":Decoration"+av],t:"Decorations"})}}}if(aA.point){for(var av=0;av<aA.point.length;av++){aA.point[av].id=aA.point[av].id==null?this.Ph("-decoration-"):aA.point[av].id;var aK=true;var V=this.uL(aA.point[av].smp);var aj=this.ZA(this.isTransformedData,aA.point[av].value||0);var J=aA.point[av].color||this.foreground;var aW=(aA.point[av].width||1)*this.dataPointSize;var E=(aA.point[av].height||1)*this.dataPointSize;var W=aA.point[av].shape||"circle";var S=V!=null&&V>=0?this.smpInfo[V]-this.margin:null;var q=(aj-this.xAxisMin)*this.xAxisUnit;if(S!=null&&q!=null){if(this.graphOrientation=="vertical"){q=this.marginTop+this.offsetY+this.top+this.y-q;aK=q<=this.marginTop+this.offsetY+this.top+this.y&&q>=this.marginTop+this.offsetY+this.top?true:false}else{S=this.marginLeft+this.offsetX+this.left+q;q=this.smpInfo[V];aK=S<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(aK){var aG=aA.point[av].smp+"("+aj+")";this.tA({p:["drawShape",W,S,q,aW,E,J,J,"closed"],i:[aG+":Decoration"+av],t:"Decorations"})}}}}if(aA.marker){for(var av=0;av<aA.marker.length;av++){if(aA.marker[av].type=="range"){if(aA.marker[av].sample&&aA.marker[av].sample2){var g=this.uL(aA.marker[av].sample);var c=this.uL(aA.marker[av].sample2);if(g!=null&&g>=0&&c!=null&&c>=0){aA.marker[av].id=aA.marker[av].id==null?this.Ph("-decoration-"):aA.marker[av].id;var S=this.smpInfo[g]-this.blockSeparation;var Q=this.smpInfo[c]+this.blockSeparation;var b=Math.abs(Q-S);var ac=this.xh(aA.marker[av].color,this.decorationsTransparency);this.tA({p:["drawShape","rectangle",(S+Q)/2,this.top+(this.y/2)+this.margin,b,this.y,ac,ac],t:"Decorations"})}}}}}if(aA.error){for(var av=0;av<aA.error.length;av++){if(aA.error[av].sample){var S,q,Q,o,N,m,L,h;var am=this.data.w?this.plotInfo.indices.indexOf(this.data.w.smps.indexOf(aA.error[av].sample)):this.data.y.smps.indexOf(aA.error[this.plotInfo.indices[av]].sample);var ap=this.data.w?av:am;var aU=this.data.w?am:av;var ba=this.ZA(this.isTransformedData,aA.error[ap].min||this.xAxisMin);var D=this.ZA(this.isTransformedData,aA.error[ap].max||this.xAxisMax);var aK=true;var aE=aA.error[ap].type||"line";var J=aA.error[ap].color||this.foreground;var ah=aA.error[ap].size||1;var aW=(aA.error[ap].width||1)*this.dataPointSize*4;var aO=aA.error[ap].scope||false;if(am!=null){aA.error[ap].id=aA.error[ap].id==null?this.Ph("-decoration-"):aA.error[ap].id;if(this.graphOrientation=="vertical"){S=this.smpInfo[aU];q=this.marginTop+this.offsetY+this.top+this.y-((ba-this.xAxisMin)*this.xAxisUnit);Q=S;o=this.marginTop+this.offsetY+this.top+this.y-((D-this.xAxisMin)*this.xAxisUnit);N=S-aW;m=q;L=S+aW;h=o}else{S=this.marginLeft+this.offsetX+this.left+((ba-this.xAxisMin)*this.xAxisUnit);q=this.smpInfo[aU];Q=this.marginLeft+this.offsetX+this.left+((D-this.xAxisMin)*this.xAxisUnit);o=q;N=S;m=q-aW;L=Q;h=q+aW}if(aK&&aO){if(this.layoutValid){aK=false;var ak=this.j1(this.data.l.name[this.layoutCurrent]);for(var au=0;au<ak.length;au++){if(aO==ak[au]){aK=true}}}}if(aK){var aY=this.tA({p:["drawLine",aE,S,q,Q,o,J,ah],i:["Error-"+aA.error[ap].sample+":Decoration"+av],t:"Decorations"});if(this.graphOrientation=="vertical"){this.tA({p:["drawLine",aE,N,m,L,m,J,ah],i:["Error-"+aA.error[ap].sample+":Decoration"+av],g:aY,t:"Decorations"});this.tA({p:["drawLine",aE,N,h,L,h,J,ah],i:["Error-"+aA.error[ap].sample+":Decoration"+av],g:aY,t:"Decorations"})}else{this.tA({p:["drawLine",aE,N,m,N,h,J,ah],i:["Error-"+aA.error[ap].sample+":Decoration"+av],g:aY,t:"Decorations"});this.tA({p:["drawLine",aE,L,m,L,h,J,ah],i:["Error-"+aA.error[ap].sample+":Decoration"+av],g:aY,t:"Decorations"})}}}}}}}}if(this.decorationsClipped){this.tA({p:["resetClipArea"],t:"Decorations"})}};this.hi=function(){if(this.isOncoprint){var b=(this.width/2)-(this.legend.oncoprint.width/2);var p=this.height-(this.marginBottom+this.legend.oncoprint.height-this.margin);var a=0;var o=this.legend.oncoprint.width/this.legend.oncoprint.cols;var k=2;this.tA({p:["drawShape","rect",this.width/2,p+(this.legend.oncoprint.height/2)-this.margin,this.legend.oncoprint.width,this.legend.oncoprint.height,this.background,this.background],i:[-1],m:["-legend-oncoprint"],t:"Legends"});for(var g=0;g<this.legend.oncoprint.rows;g++){var d=b;for(var e=0;e<this.legend.oncoprint.cols;e++){if(a<this.legend.oncoprint.labels.length){var h=this.legend.oncoprint.labels[a];var m=this.legend.oncoprint.objects[a];if(a<this.legend.oncoprintMutations){this.tA({p:["drawShape","rect",d+2.5,p+10.5,5,21,this.legend.oncoprint.colors[h]],i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.tA({p:["drawText",h,d,p+10.5+k,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});d+=o}else{this.tA({p:["drawShape","rect",d+2.5,p+10.5,5,21,"rgb(220,220,220"],i:["Onc-"+h+"-"+m],t:"Legends"});this.tA({p:["drawShape","rect",d+2.5,p+10.5,5,7,this.legend.oncoprint.colors[h]],i:["Onc-"+h+"-"+m],t:"Legends"});d+=5+this.margin;this.tA({p:["drawText",h,d,p+10.5+k,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});d+=o}a++}}p+=21+this.margin}}};this.KU=function(A,e){var g=this;var b=function(D,j,i){if(g.um()){return c[D]}else{if(g.xAxisIndices.length==1){return g.fK(i,g.maxSmpStringLen)}else{if(g.yAxisIndices.length==1){return g.fK(j,g.maxSmpStringLen)}else{return g.fK(i,g.maxSmpStringLen)+" vs "+g.fK(j,g.maxSmpStringLen)}}}};var d=function(i,j){if(g.showHistogram1){return g.meta.data.s.density.Global.sets[i].color}else{if(g.isCreateHistogram){if(g.isCreateHistogram.colors&&g.isCreateHistogram.colors.length<g.legend.sample.n&&g.isCreateHistogram.factor){if(g.cacheColors[g.colorScheme].hasOwnProperty(j)){return g.cacheColors[g.colorScheme][j]}else{return m&&m.hasOwnProperty(g.isCreateHistogram.factor)&&m[g.isCreateHistogram.factor].colors?m[g.isCreateHistogram.factor].colors[i]:g.colors[i%g.colors.length]}}else{if(g.isCreateHistogram.colors&&g.isCreateHistogram.colors.length==g.legend.sample.n){if(g.densityPosition=="filled"&&g.graphType=="Scatter2D"){return g.isCreateHistogram.colors[g.legend.sample.n-(1+i)]}else{return g.isCreateHistogram.colors[i]}}else{return g.cacheColors[g.colorScheme].hasOwnProperty(j)?g.cacheColors[g.colorScheme][j]:g.colors[i%g.colors.length]}}}else{return g.colors[i%g.colors.length]}}};var x=function(j){if(g.isCreateHistogram){if(!g.xAxisIndices.length&&!g.yAxisIndices.length){var i;if(g.um()){i=g.uL(c[j]);if(i<0){i=j+1}}else{i=g.uL(g.data.l.axes[0].yAxis[j])}return"Series:0:"+i}else{if(g.data.l&&g.data.l.axes&&g.data.l.axes[w]&&g.data.l.axes[w].yAxis&&g.data.l.axes[w].yAxis[t]&&!g.data.l.axes[w].yAxis[t].match(":")){return"Series:0:"+g.data.l.ids[j+1]}else{return g.xAxisIndices.length==g.yAxisIndices.length?"Series:"+g.xAxisIndices[j]+":"+g.yAxisIndices[j]:g.xAxisIndices.length>g.yAxisIndices.length?"Series:"+g.xAxisIndices[j]+":0":"Series:0:"+g.yAxisIndices[j]}}}else{return g.xAxisIndices.length==g.yAxisIndices.length?"Series:"+g.xAxisIndices[j]+":"+g.yAxisIndices[j]:g.xAxisIndices.length>g.yAxisIndices.length?"Series:"+g.xAxisIndices[j]+":0":"Series:0:"+g.yAxisIndices[j]}};var r=A;var B=e;var v=0;var q=this.HU(this.legendTextFont);var u=q/2;e+=this.legendTextMargin+u;this.zS(r,B,this.legend.sample.width,this.legend.sample.height,"-legend-sample");var h=this.legend.sample.columns||this.legendColumns;var z=this.legend.sample.width/h;var a=Math.ceil(this.legend.sample.n/h);var m=g.meta.data.z;var c=[];var y={};if(this.ridgeBy){for(var w=0;w<a;w++){for(var t=0;t<h;t++){A=r+((this.legendTextMargin+z)*t);if(v<this.legend.sample.n){var o=this.fK(this.dataStndBy.y.smps[v],this.maxSmpStringLen);var f=this.colors[v%this.colors.length];var C="Series:0:"+v;var k=A+u+this.legendTextMargin;this.Gl(k,e,"circle",q,this.Nb(f),this.f6(f),"closed","solid",this.background,o,[C],null,this.vK(false,false,C));v++}}e+=q+this.legendTextMargin}}else{if(this.isHistogram&&this.um()){for(var w=0;w<this.data.l.axes.length;w++){for(var t=0;t<this.data.l.axes[w].yAxis.length;t++){if(this.data.l.axes[w].yAxis[t]){if(this.segregateVariablesBy.length||!this.data.l.axes[w].yAxis[t].match(":")){y[this.data.l.axes[w].yAxis[t].split(":")[0]]=true}else{if(this.data.l.axes.length==this.dataStndBy.y.smps.length){y[this.data.l.axes[w].yAxis[t].split(":")[1]]=true}else{y[this.data.l.axes[w].yAxis[t]]=true}}}}}c=this.NU(y)}}if(!this.ridgeBy){for(var w=0;w<a;w++){for(var t=0;t<h;t++){A=r+((this.legendTextMargin+z)*t);if(v<this.legend.sample.n){var l=this.isCreateHistogram?"solid":this.GF(w,false,"patternBy");var n=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[v]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[v];var p=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[v]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[v]:this.xAxis[this.xAxisCurrent];var C=x(v);var o=b(v,p,n);var f=d(v,o);var s=this.shapes[v%this.shapes.length];var k=A+u+this.legendTextMargin;if(this.isCreateHistogram){var s=this.histogramAsDotplot?"circle":"rectangle";this.Gl(k,e,s,q,this.Nb(f),this.f6(f),l,"solid",this.background,o,[C],null,this.vK(false,false,C))}else{if(this.colorBy){if(this.scatterType=="line"){this.SO(k,e,"circle",q,this.Nb(f),this.Nb(f),"solid","line",this.Nb(f),o,[C],null,this.vK(false,false,C))}else{this.Gl(k,e,"circle",q,this.background,this.Nb(f),"open","solid",this.background,o,[C],null,this.vK(false,false,C))}}else{if(this.isKM){f=this.Nb(f);this.xw(k,e,"rectangle",q,f,f,"closed","solid",f,o,[C],null,this.vK(false,false,C))}else{if(this.scatterType=="line"){if(this.shapeBy=="sample"){this.zM(k,e,s,q,this.Nb(f),this.Nb(f),"solid","line",this.Nb(f),o,[C],null,this.vK(false,false,C))}else{this.SO(k,e,"circle",q,this.Nb(f),this.Nb(f),"solid","line",this.Nb(f),o,[C],null,this.vK(false,false,C))}}else{this.Gl(k,e,"circle",q,this.Nb(f),this.f6(f),l,"solid",this.background,o,[C],null,this.vK(false,false,C))}}}}}else{break}v++}e+=q+this.legendTextMargin}}};this.SP=function(F,c){var k=this;var s=F;var H=c;var r=this.HU(this.legendTextFont);var x=r/2;var y=0;var h=this.layoutValid&&!this.isDOE&&this.tO()&&this.meta.config.user.graphType&&this.meta.config.user.graphType!=this.graphType?this.meta.config.user.graphType:this.graphType;var n=function(){if(k.circularType.match(/normal/)){if(k.ringGraphType.length){for(var j=0;j<k.ringGraphType.length;j++){if(k.ringGraphType[j]!="heatmap"){return true}}return false}}return true};var m=function(i){if(i<k.xAxisVarIndices.length){return k.colors[i%k.colors.length]}else{return k.colors[(i-k.xAxisVarIndices.length)%k.colors.length]}};if(this.legend.variable.width==0||this.legend.variable.height==0||!this.variableShowLegend){return}else{if(h=="Circular"&&this.circularType.match(/sunburst|bubble/)){return}else{if(h=="Pie"){var E=!this.layoutComb?this.width-(F+(this.legendTextMargin*1.5)):this.isDOE?this.layoutWidth-((F-this.offsetX)+(this.legendTextMargin*1.5)):999999;if(this.isDOE&&this.legend.variable.width>E){this.legend.variable.width=E}this.zS(s,H,this.legend.variable.width,this.legend.variable.height,"-legend-variable");F+=x+this.legendTextMargin;c+=r;for(var C=0;C<this.varPie.ids.length;C++){var e=false;var q=this.varPie.ids[C];var f=this.varPie.cols[C];var v=q>-1?this.fK(this.data.y.vars[q],this.maxVarStringLen):"Other";if(E>0){while((this.DU(v,this.legendTextFont)+r+(this.legendTextMargin*3))>E&&v.length>1){v=v.substring(0,v.length-1);e=true}if(e){v=v+"..."}}this.Gl(F,c,"circle",r,this.Nb(f),this.f6(f),"closed","solid",this.background,v,["PieVar-"+q],null,this.vK(false,false,"Var-"+q));c+=r+this.legendTextMargin;if(this.layoutComb){if((c-this.offsetY)>this.layoutHeight){this.tA({p:["drawText","...",F+r,c,this.legendTextFont,this.legendTextColor,"left","bottom"],t:"Legends"});break}}else{if(c>this.height){this.tA({p:["drawText","...",F+r,c,this.legendTextFont,this.legendTextColor,"left","bottom"],t:"Legends"});break}}}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){this.zS(s,H,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var B=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],r):r;var G=B/2;var l=this.legend.variable.columns||(this.legendColumns>this.varIndices.length?this.varIndices.length:this.legendColumns);var D=this.legend.variable.width/l;var a=Math.ceil(this.varIndices.length/l);c+=(this.legendTextMargin*3);for(var C=0;C<a;C++){for(var w=0;w<l;w++){F=s+(this.legendTextMargin+(D*w));if(y<this.varIndices.length){var q=this.varIndices[y];var f=h=="Circular"||(this.colorBy&&this.colorBy=="variable")?y%this.colors.length:0;var t=this.shapeBy&&this.shapeBy=="variable"?y%this.shapes.length:0;var A=this.sizeBy&&this.sizeBy=="variable"?this.sizes[y%this.sizes.length]:B;var p=this.patternBy&&this.patternBy=="variable"?this.patterns[y%this.patterns.length]:this.GF(q,false,"patternBy");var o=F+G;var v=this.fK(this.data.y.vars[q],this.maxVarStringLen);var b=this.vK(false,false,"Var-"+q);this.Gl(o,c,this.shapes[t],A,this.Nb(this.colors[f]),this.f6(this.colors[f]),p,"solid",this.background,v,["Var-"+q],null,b)}else{break}y++}c+=B+this.legendTextMargin}}else{if(h=="BarLine"||h=="DotLine"||h=="AreaLine"||h=="StackedLine"||h=="StackedPercentLine"){this.zS(s,H,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var g=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var l=this.legend.variable.columns||(this.legendColumns>g.length?g.length:this.legendColumns);var D=this.legend.variable.width/l;var a=Math.ceil(g.length/l);c+=this.legendTextMargin+(r/2);for(var C=0;C<a;C++){for(var w=0;w<l;w++){F=s+(r/2)+this.legendTextMargin+(D*w);if(y<g.length){var q=y<this.xAxisVarIndices.length?this.xAxisVarIndices[y]:this.xAxis2VarIndices[y-this.xAxisVarIndices.length];var f=this.theme=="blackAndWhite"?"rgb(0,0,0)":this.coordinateLineColor?m(y):this.pv(this.data.y.vars[q]);var p=this.GF(q,false,"patternBy");var v=this.fK(this.data.y.vars[q],this.maxVarStringLen);var b=this.vK(false,false,"Var-"+q);if(y<this.xAxisVarIndices.length){var t=h=="DotLine"?"circle":this.useRoundRectangles?"roundrect":"rectangle";this.Gl(F,c,t,r,this.Nb(f),this.f6(f),p,"solid",this.background,v,["Var-"+q],null,b)}else{var u=this.lineDecoration=="pattern"?this.linePatterns[y%this.linePatterns.length]:"line";var t=this.lineDecoration=="symbol"?this.shapes[(y-this.xAxisVarIndices.length)%this.shapes.length]:"circle";var f=this.Nb(f);if(this.lineDecoration&&this.lineDecoration!="pattern"&&!this.segregateVariablesBy.length&&h!="DotLine"&&h!="AreaLine"){this.zM(F,c,t,r,f,f,"closed","solid",f,v,["Var-"+q],null,b)}else{this.SO(F,c,t,r,f,f,p,u,f,v,["Var-"+q],null,b)}}}else{break}y++}c+=r+this.legendTextMargin}}else{if(h=="Bar"||h=="Line"||h=="ParallelCoordinates"||h=="Area"||h=="Dotplot"||h=="Stacked"||h=="StackedPercent"||h=="Boxplot"||h=="Fish"){this.zS(s,H,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var l=this.legend.variable.columns||(this.legendColumns>this.varIndices.length?this.varIndices.length:this.legendColumns);var D=this.legend.variable.width/Math.min(this.varIndices.length,l);var a=Math.ceil(this.varIndices.length/Math.min(this.varIndices.length,l));c+=this.legendTextMargin+(r/2);for(var C=0;C<a;C++){for(var w=0;w<Math.min(this.varIndices.length,l);w++){F=s+(r/2)+this.legendTextMargin+(D*w);if(y<this.varIndices.length){var q=this.varIndices[y];var f=this.theme=="blackAndWhite"&&h=="Line"?"rgb(0,0,0)":this.Nb(this.pv(this.data.y.vars[q]));var z=this.f6(f);var p=this.GF(q,false,"patternBy");var v=this.fK(this.data.y.vars[q],this.maxVarStringLen);var b=this.vK(false,false,"Var-"+q);if(h=="Boxplot"){f=this.boxplotColor?this.boxplotColor:f;z=this.boxplotBorderColor?this.boxplotBorderColor:z}if(h=="Line"||h=="ParallelCoordinates"){var t=this.lineDecoration=="symbol"?this.shapes[y%this.shapes.length]:"circle";var u=this.lineDecoration=="pattern"?this.linePatterns[y%this.linePatterns.length]:"line";if(this.lineDecoration&&(this.lineDecoration=="symbol"||this.lineDecoration=="dot")){this.zM(F,c,t,r,f,f,p,"solid",f,v,["Var-"+q],null,b)}else{this.SO(F,c,t,r,f,f,p,u,f,v,["Var-"+q],null,b)}}else{if(h=="Dotplot"||(h=="Boxplot"&&this.showBoxplotOriginalData)){var t="circle";this.Gl(F,c,t,r,f,z,p,"solid",this.background,v,["Var-"+q],null,b)}else{if(h=="Bar"&&this.barType=="lollipop"){this.ii(F,c,t,r,f,z,p,"solid",this.background,v,["Var-"+q],null,b)}else{var t=this.useRoundRectangles?"roundrect":"rectangle";if(h=="Boxplot"&&(!this.showBoxplotOriginalData||this.boxplotColor)){if(this.plotStyle=="ggplotSwitched"){z=this.boxplotColor}this.JN(F,c,t,r,f,z,p,"solid",this.background,v,["Var-"+q],null,b)}else{this.Gl(F,c,t,r,f,z,p,"solid",this.background,v,["Var-"+q],null,b)}}}}}else{break}y++}c+=r+this.legendTextMargin}}else{if(h=="Circular"&&!this.showIdeogram&&n()){this.zS(s,H,this.legend.variable.width,this.legend.variable.height,"-legend-variable");var d=[];if(this.rAxisIndex>=0){for(var C=0;C<this.varIndices.length;C++){if(C==this.rAxisIndex){continue}d.push(this.varIndices[C])}}else{d=this.varIndices}var l=this.legend.variable.columns||(this.legendColumns>d.length?d.length:this.legendColumns);var D=this.legend.variable.width/l;var a=Math.ceil(d.length/l);c+=this.legendTextMargin+(r/2);for(var C=0;C<a;C++){for(var w=0;w<l;w++){F=s+(r/2)+this.legendTextMargin+(D*w);if(y<d.length){var q=d[y];if(this.data.y.vars[q]){var f=this.colors[y%this.colors.length];var p=this.GF(q,false,"patternBy");var v=this.fK(this.data.y.vars[q],this.maxVarStringLen);this.Gl(F,c,this.useRoundRectangles?"roundrect":"rectangle",r,this.Nb(f),this.f6(f),p,"solid",this.background,v,["Var-"+q],null,b)}}else{break}y++}c+=r+this.legendTextMargin}}}}}}}}};this.Sh=function(){if(this.showLegend){var j=this.HU(this.legendTextFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.GC(this.vennColors[0])?this.GC(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.GC(this.vennColors[1])?this.GC(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.GC(this.vennColors[2])?this.GC(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.GC(this.vennColors[3])?this.GC(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.GC(this.vennColors[0])?this.GC(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.GC(this.vennColors[1])?this.GC(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.GC(this.vennColors[2])?this.GC(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.GC(this.vennColors[0])?this.GC(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.GC(this.vennColors[1])?this.GC(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.GC(this.vennColors[0])?this.GC(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.tA({p:["drawText",a[f]+": ",d,g,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.DU(b,this.legendTextFont)>this.x)?this.z2(b,j,this.x-this.margin):this.legendTextFont;if(!this.vennLegendColors){this.tA({p:["drawText",b,c,g,e,this.legendTextColor,"left","middle"],t:"Legends"})}else{this.tA({p:["drawText",b,d,g,e,h[f],"left","middle"],t:"Legends"})}g+=this.margin+j}}};this.p3=function(p,a,k,y,h,u){if(u||h||this.colorBy||this.outlineBy||this.colorLabelBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy||this.graphType=="Genome"||this.scatterType=="bin2d"||(this.isContour&&this.contourFilled)||(this.graphType=="Network"&&this.decorations.length&&this.decorationsType=="heatmap"&&this.showDecorations&&!this.colorNodeBy&&!this.colorEdgeBy)){var B=this;var v=function(Q,j){if(j==undefined){if(!k.decs||k.decs>3){k.decs=B.Pi(Q[1]-Q[0])}j=k.decs}var P=[];for(var c=0;c<Q.length;c++){P[c]=Q[c].toFixed(j)}return P};var b=function(c){if(B.heatmapIndicatorWidth<250){if(c.length==9){c=[c[0],c[4],c[8]]}else{if(c.length==8||c.length==7){c=[c[0],c[2],c[4],c[6]]}else{if(c.length==6||c.length==5){c=[c[0],c[2],c[4]]}}}}return c};var M=function(){var U=B[x]&&B[x].toString().match(/top|bottom/)&&!w;var P=C;var R=(!U||B.graphType=="Map")&&l&&B.showLegendTitle?r+B.legendTitleFontSize+(B.legendTitleMargin*2):l&&B.showLegendTitle?r+B.legendTitleFontSize+(B.legendTitleMargin*2):r;var j=U?B.heatmapIndicatorWidth:B.heatmapIndicatorHeight;var S=U?B.heatmapIndicatorHeight:B.heatmapIndicatorWidth;var T=B.theme=="GGPlot"?"rgb(255,255,255)":"rgb(0,0,0)";B.tA({p:["drawShape","rectangle",P+(j/2),R+(S/2),j,S,false,T,"open"],t:"Legends"});if(U){for(var Q=0;Q<g.length;Q++){if(g[Q]>P&&g[Q]<(P+j)){B.tA({p:["drawLine","line",g[Q],R,g[Q],R+B.margin,T,1],t:"Legends"});B.tA({p:["drawLine","line",g[Q],R+S,g[Q],R+S-B.margin,T,1],t:"Legends"})}}}else{for(var Q=0;Q<g.length;Q++){if(g[Q]>R&&g[Q]<(R+S)){B.tA({p:["drawLine","line",P,g[Q],P+B.margin,g[Q],T,1],t:"Legends"});B.tA({p:["drawLine","line",P+j,g[Q],P+j-B.margin,g[Q],T,1],t:"Legends"})}}}};var l=this.scatterType=="bin2d"?"n":(y||k.title);var x=u?"overlaysLegendPosition":h?"heatmapIndicatorPosition":"legendPosition";var E=u?u:h?0:this.legendTextColorWidth?this.legendTextColorWidth/2:10;var C=p;var r=a;var n=this.HU(this.legendTitleFont);var o=this.heatmapIndicatorHeight;var O=this.heatmapIndicatorHeight;var L=this.graphType=="Genome"?k.brew.min:k.min;var t=this.graphType=="Genome"?k.brew.max:k.max;var D=this.graphType=="Genome"?k.brew.vals:k.vals;var d=k.valStr?k.valStr:k.colorBrew&&k.colorBrew.valStr?k.colorBrew.valStr:v(D);var F=this.heatmapIndicatorWidth/(t-L);var J=10;var G=this.graphType=="Circular"||(this.isContour&&!k.colorBrew)||this.scatterType=="bin2d"?k:k.colorBrew?k.colorBrew:this.meta.def.colorBrew;var f=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var w=x=="overlaysLegendPosition"&&this[x]=="topRight"?true:false;var e=this.legendTitleFont;var N=this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram?this.l0():false;var g=[];var A=[];if(N&&this.heatmapIndicatorOverlap){p+=this.DU(N.maxStr,this.legendTextFont);C=p}if(this[x]&&!this[x].toString().match(/top|bottom/)&&!w){if(l&&this.showLegendTitle){p+=(this.DU(l,this.legendTextFont)-this.heatmapIndicatorHeight)/2;C=p}}if(this[x]&&this[x].toString().match(/top|bottom/)&&!w){if(l){if(this.showLegendTitle){var z=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-(this.heatmapIndicatorWidth/2):(this.heatmapIndicatorWidth/2);a+=this.legendTitleMargin+(n/2);this.tA({p:["drawText",l,p+(this.heatmapIndicatorWidth/2)+z,a,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"});a+=this.legendTitleMargin+(n/2)}}A=[p,p+this.heatmapIndicatorWidth];this.tA({p:["setClipArea",[p,a,this.heatmapIndicatorWidth,this.heatmapIndicatorHeight]],t:"Legends"});for(var I=0;I<this.colorSpectrumNumber;I++){var K=this.transparency!=null?this.xh(G.colors[I],this.transparency,true):G.colors[I];this.tA({p:["drawLine","line",p,a,p,a+O,K,J],t:"Legends"});p+=f}this.tA({p:["resetClipArea"],t:"Legends"});p=C;a+=O+this.legendTextMargin;if(G&&G.stops&&G.stops.length){var q=0;for(var I=0;I<G.stops.length;I++){for(var H=0;H<this.colorSpectrumNumber;H++){if(G.breaks[H]>=G.stops[I]){p=C+(H*f);g.push(p);var m=(this.DU(this.qo(G.stops[I].toString()),this.legendTextFont)/2);if(p-m>q||I==0||I==G.stops.length-1){this.tA({p:["drawText",this.qo(G.stops[I]),p,a,e,this.legendTextColor,"center","top"],t:"Legends"});q=p+m}break}}}}else{if(N){D=b(D);d=v(D,0);this.Ht(N,C,r-0.5)}else{if(this.graphType=="Map"){D=b(D);d=v(D,0)}}for(var I=0;I<D.length;I++){p=C+((D[I]-L)*F);g.push(p);if(p>=A[0]&&p<=A[1]){this.tA({p:["drawText",d[I],p,a,this.legendTextFont,this.legendTextColor,"center","top"],t:"Legends"})}}}}else{if(l){if(this.showLegendTitle){a+=this.legendTitleMargin+(n/2);var z=this.legendTitleAlign=="center"?0:this.legendTitleAlign=="left"?-(E+(this.legendTitleMargin*2)):(E+(this.legendTitleMargin*2));this.tA({p:["drawText",l,p+E+(this.legendTitleMargin*2),a,this.legendTitleFont,this.legendTitleColor,this.legendTitleAlign,"middle"],t:"Legends"});a+=this.legendTitleMargin+(n/2)}}var s=a;A=[a+this.heatmapIndicatorWidth,a];this.tA({p:["setClipArea",[p,a,this.heatmapIndicatorHeight,this.heatmapIndicatorWidth]],t:"Legends"});a+=(this.colorSpectrumNumber*f);for(var I=0;I<this.colorSpectrumNumber;I++){var K=this.transparency!=null?this.xh(G.colors[I],this.transparency,true):G.colors[I];this.tA({p:["drawLine","line",p,a,p+o,a,K,J],t:"Legends"});a-=f}this.tA({p:["resetClipArea"],t:"Legends"});p+=o+this.legendTextMargin;a=s;if(G&&G.stops&&G.stops.length){a+=this.colorSpectrumNumber*f;var q=a;for(var I=0;I<G.stops.length;I++){for(var H=0;H<this.colorSpectrumNumber;H++){if(G.breaks[H]>=G.stops[I]){O=a-(H*f);g.push(O);if(O+this.legendTextFontSize<q||I==0||I==G.stops.length-1){this.tA({p:["drawText",this.qo(G.stops[I]),p,O,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"});q=O}break}}}}else{a+=this.colorSpectrumNumber*f;var s=-((this.legendTitleMargin*2)+n);for(var I=0;I<D.length;I++){var O=a-((D[I]-L)*F);if(O>(r+s)){g.push(O);if(O<=A[0]&&O>=A[1]){this.tA({p:["drawText",d[I],p,O,this.legendTextFont,this.legendTextColor,"left","middle"],t:"Legends"})}}}}}M()}};this.l0=function(){var k=[];for(var f=0;f<this.data.y.vars.length;f++){for(var e=0;e<this.data.y.smps.length;e++){var n=this.RE(f,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);if(n!=null&&n!==""&&!isNaN(n)){k.push(n)}}}var g=this.w8(k);var c=g[0];var m=g[1];var r=this[this.histogramSizeEstimator](k);var q=Math.ceil((m-c)/r);if(r>1000){q*=r/1000;r=1000}var h=[];for(var f=0;f<r;f++){h[f]=0}for(var f=0;f<this.data.y.vars.length;f++){for(var e=0;e<this.data.y.smps.length;e++){var n=this.RE(f,e,false,this.xAxisTransform,this.xAxisFloorValue,this.xAxisCeilValue,this.xAxisFactorValue);if(n!=null&&n!==""&&!isNaN(n)){var p=parseInt((n-c)/q);h[p]++}}}c=0;m=0;for(var f=0;f<r;f++){c=Math.min(c,h[f]);m=Math.max(m,h[f])}var l=this[this.axisAlgorithm](c,m,3,this.isGraphTime,this.axisWilkinsonLoose);var o=this.NN(l);var b=(this.heatmapIndicatorWidth-1)/r;var a=this.heatmapIndicatorHeight/l[l.length-1];return{range:g,min:c,max:m,size:q,bins:r,hist:h,vals:l,maxStr:o,unitsX:b,unitsY:a}};this.Ht=function(h,c,m){var l;var j=c;var d=m+this.heatmapIndicatorHeight;var n=h.bins;var g=h.hist;var k=h.vals;var b=h.unitsX;var a=h.unitsY;var f=1.5;this.tA({p:["drawLine","line",j-this.margin,m,j-this.margin,d,this.foreground],t:"Legends"});for(var e=0;e<k.length;e++){m=(k[e]*a);this.tA({p:["drawLine","line",j-(this.margin*2),d-m,j-this.margin,d-m,this.foreground],t:"Legends"});this.tA({p:["drawText",this.qo(k[e]),j-(this.margin*3),d-m,this.legendTextFont,this.legendTextColor,"right","middle"],t:"Legends"})}m=(g[0]*a);this.tA({p:["drawLine","line",j,d,j,d-m,this.heatmapIndicatorHistogramColor,f],t:"Legends"});for(var e=0;e<n;e++){m=(g[e]*a);this.tA({p:["drawLine","line",j,d-m,j+b,d-m,this.heatmapIndicatorHistogramColor,f],t:"Legends"});if(e<n-1){l=(g[e+1]*a);this.tA({p:["drawLine","line",j+b,d-m,j+b,d-l,this.heatmapIndicatorHistogramColor,f],t:"Legends"})}j+=b}this.tA({p:["drawLine","line",j,d-l,j,d,this.heatmapIndicatorHistogramColor,f],t:"Legends"})};this.qP=function(a){if(a){if(this.graphType=="Network"){return(this[a+"By"]&&this.meta.data.edges[this[a+"By"]])||(this[a+"By"]&&this.meta.data.nodes[this[a+"By"]])}else{return(this[a+"By"]&&this.isMultidimensionalData)||(this.isContour&&this.contourType=="point")||(this.histogramAsDotplot&&this.colorBy)||(this[a+"By"]&&((this.data.x&&this.data.x.hasOwnProperty(this[a+"By"]))||(this.data.z&&this.data.z.hasOwnProperty(this[a+"By"]))||this.uL(this[a+"By"])>-1))}}else{if(this.graphType=="Network"){return(this.colorEdgeBy&&this.meta.data.edges[this.colorEdgeBy])||(this.colorNodeBy&&this.meta.data.nodes[this.colorNodeBy])||(this.decorations.length&&this.decorationsType=="heatmap")}else{return(this.colorBy&&this.isMultidimensionalData)||(this.outlineBy&&this.isMultidimensionalData)||(this.isContour&&this.contourFilled)||this.scatterType=="bin2d"||(this.histogramAsDotplot&&this.colorBy)||(this.data.x&&this.data.x.hasOwnProperty(this.lineBy))||(this.data.z&&this.data.z.hasOwnProperty(this.lineBy))||(this.colorLabelBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorLabelBy))||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))||this.uL(this.colorBy)>-1||(this.colorBy=="data"&&this.ridgeBy)))}}};this.Aa=function(a,c,e,d){if(this.graphType=="Map"){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);c+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}var b=this.graphType=="Scatter2D"&&this.lineBy&&(this.ribbonBy||this.isCxplot)&&this.colorBy==this.lineBy&&d=="color";if(this.qP()&&!b){if((e.type=="Numeric"&&!e.colorBy)||(this.isContour&&this.contourFilled)||this.scatterType=="bin2d"){this.p3(a,c,(this.isTransformedData&&this.graphType!="Heatmap")?this.hD():this.isContour?this.meta.data.q.g[0].data.colorBrew:this.scatterType=="bin2d"?this.meta.data.b.c:e)}else{this.xN(d,a,c,e)}}};this.Pk=function(a,b,d,c){this.xN(c,a,b,d)};this.Vd=function(a,b,d,c){this.xN(c,a,b,d)};this.s3=function(a,b,d,c){this.xN(c,a,b,d)};this.pi=function(a,b,d,c){this.xN(c,a,b,d)};this.xN=function(s,o,a,e){var D=this;var m=function(){if(D.graphType.match(/Boxplot|Bar/)){if(!D.showBoxplotOriginalData&&!D.boxplotColor&&!D.showViolinBoxplot){return D.useRoundRectangles?"roundrect":"rectangle"}else{return"circle"}}else{return"circle"}};var G=this.NW(s);if(this.qP(G)){var f=s.replace("Node","").replace("Label","").replace("contour","size")=="size"?0:this.TM();if(s.replace("Node","").replace("Label","").replace("contour","size")=="size"){var J=e.sizes?e.sizes.length:this.sizes.length;for(var K=0;K<(this.isContour?e.vals.length:(this.legend.size.n||e.levels.length));K++){f=Math.max(f,e.sizes?e.sizes[K%J]:this.sizes[K%J])}}var P=this.HU(this.legendTitleFont);var v=this.HU(this.legendTextFont);var t=this.legend[s].columns||this.legendColumns;var y=t>this.legend[s].n?this.legend[s].n:t;var x=Math.ceil(this.legend[s].n/y);var b=this.legend[s].width/y;var q=a+(this.showLegendTitle?this.legendTitleMargin+(P/2):this.legendTextMargin+(v/2));var d=Math.max(f,v);var u=0;var k=s.replace("Node","").replace("Edge","").replace("Label","")=="color"&&this.outlineBy?this.outlineBy:this[G+"By"];this.jT(o,a,this.legend[s].width,this.legend[s].height,k,"-legend-"+G);if(this.showLegendTitle){q+=P+this.legendTitleMargin;if(f>v+this.legendTextMargin){q+=this.legendTextMargin+(P<16?P:0)}}var L=this.legend[s].levels||this.pa(this.legend[s].m);var H=e.origin?e.origin:this.meta.data.modified?"modified":this.isOncoprint||this.isMultidimensionalData?this[G+"ByData"]:this.graphType=="Network"?(s.match(/Node/)?"filterNodeBy":"filterEdgeBy"):"y";for(var F=0;F<x;F++){for(var N=0;N<y;N++){var C=o+this.legendTextMargin+(f/2)+(b*N);if(u<this.legend[s].n&&u>=0){var g=L[u];var M;if(e.type=="Numeric"&&((s=="shape"&&!this.shapeByContinuous)||(s=="size"&&!this.sizeByContinuous)||(s=="sizeNode"&&!this.sizeByContinuous)||(s=="sizeEdge"&&!this.sizeByContinuous))){M=F==0&&N==0?"<= "+g:F==x-1&&N==y-1?L[u-1]+" - "+g:Number(L[u-1])+" - "+g}else{M=g.length>this.maxTextSize?g.substring(0,this.maxTextSize-3)+"...":g}var h=m();var B=s=="colorLabel"?this.GC(e.colors[u]):e.colorBy&&e.colorBy.hasOwnProperty(g)?this.GC(e.colorBy[g]):this.legend.color.m?this.GC(this.legend.color.m[g]):e.colors?this.GC(e.colors[u]):this.background;if(this.graphType=="Boxplot"&&this.showViolinBoxplot){B=this.xh(B,this.violinTransparency,true)}var E=this.Nb(B);var Q=this.outlineBy?this.Nb(B):this.graphType=="Scatter2D"&&this.scatterType=="visium"?this.Nb(B):this.f6(B);var B=this.outlineBy?"rgba(0,0,0,0)":this.Nb(B);var j="closed";var w="solid";var A=["PropertyKey:"+k+":"+g+":"+H];var I=this.graphType=="Boxplot"&&s!="connect"&&(!this.showBoxplotOriginalData||this.boxplotColor)&&!this.showViolinBoxplot;var O=this.vK(false,false,"Property:"+k+":"+g+":"+H);if(s.replace("Node","").replace("Edge","").replace("Label","")=="color"){if(this.colorLabelBy){this.Fh(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(this.outlineBy){this.Gl(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if((this.graphType=="Scatter2D"&&(this.scatterType=="line"||this.isQQ))||(this.graphType=="Line"&&this.patternBy)){this.SO(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(this.isKM){this.SO(C,q,h,f,B,Q,j,w,E,M,A,null,O);if(this.showConfidenceIntervals){B=this.xh(B,0.3,false,false,true);this.xw(C,q,"rectangle",f,B,B,j,w,E,M,A,null,O)}}else{if(this.showRegressionFit){this.zM(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(I){if(this.plotStyle=="ggplotSwitched"){Q=this.boxplotColor}this.JN(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(this.graphType=="Boxplot"||(this.graphType=="Scatter2D"&&this.scatterType=="stream")){h="rectangle"}if(this.lineBy){this.zM(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{this.Gl(C,q,h,f,B,Q,j,w,E,M,A,null,O)}}}}}}}}else{if(s.replace("Node","").replace("Edge","").replace("Label","")=="shape"){h=e.shapeBy&&e.shapeBy.hasOwnProperty(g)?e.shapeBy[g]:this.legend.shape.m?this.legend.shape.m[g]:e.shapes[u];B=this.background;Q=this.foreground;this.Gl(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(s.replace("Node","").replace("Edge","").replace("Label","").replace("contour","size")=="size"){var z=e.sizes?e.sizes.length:this.sizes.length;var n=s=="sizeLabel"?e.sizes:e.sizeBy&&e.sizeBy.hasOwnProperty(g)?e.sizeBy[g]:s=="contour"?this.sizes[u%z]:this.legend.size.m?this.legend.size.m[g]:e.sizes[u%z];B=this.background;Q=this.foreground;if(s.match(/Edge/)){n=((parseInt(this.EQ(e.min,e.max,Number(M.split(/=|-/)[1])))/100)*4)+0.5;this.C1(C,q,n,f,B,Q,j,w,Q,M,A,null,O)}else{if(this.sizeLabelBy){this.nG(C,q,n[u],[n[0],n[n.length-1]],B,Q,j,w,E,M,A,null,O)}else{this.CV(C,q,h,[n,f],B,Q,j,w,E,M,A,null,O)}}}else{if(s.replace("Node","").replace("Edge","").replace("Label","")=="pattern"){if(this.graphType.match(/parallelcoordinates|line/i)){w=e.linePatternBy&&e.linePatternBy.hasOwnProperty(g)?e.linePatternBy[g]:e.linePatterns[u];E="rgb(0,0,0)";this.SO(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{B=this.background;Q=this.foreground;j=e.patternBy&&e.patternBy.hasOwnProperty(g)?e.patternBy[g]:this.legend.Patterns?this.legend.Patterns[g]:e.patterns[u];h=this.isOncoprint?"rectangle":h;if(I){if(this.plotStyle=="ggplotSwitched"){Q=this.boxplotColor}this.JN(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(this.graphType=="Boxplot"){h="rectangle"}this.Gl(C,q,h,f,B,Q,j,w,E,M,A,null,O)}}}else{if(s=="connect"){E=e.connectBy&&e.connectBy.hasOwnProperty(g)?e.connectBy[g]:this.legend.connects?this.legend.connects[g]:e.connects[u];this.SO(C,q,h,f,B,Q,j,w,E,M,A,null,O)}else{if(s=="line"){if(this.ribbonBy){E=e.lineBy&&e.lineBy.hasOwnProperty(g)?e.lineBy[g]:e.colors[u];this.xw(C,q,h,f,E,E,j,w,E,M,A,null,O)}else{E=this.colorBy!=this.lineBy?(this.graphType=="Scatter2D"&&this.showLoessFit?this.fitLineColor:"rgb(0,0,0)"):e.colors[u];w=this.colorBy!=this.lineBy?e.linePatterns[u%e.linePatterns.length]:j;if(this.graphType=="Scatter2D"&&this.scatterType=="area"){h="rectangle";this.Gl(C,q,h,f,E,Q,j,w,E,M,A,null,O)}else{this.SO(C,q,h,f,B,Q,j,w,E,M,A,null,O)}}}}}}}}}u++}q+=this.legendTextMargin+d}}};this.gV=function(G,d,m,I,x){var A=x.text.length;var C=this.TM();var v=x.size;if(v){for(var E=0;E<v.length;E++){if(v[E]){C=Math.max(C,v[E])}}}var b=this.HU(this.legendTitleFont);var k=this.HU(this.legendTextFont);var o=this.legendColumns>A?A:this.legendColumns;var h=Math.ceil(A/o);var p=m/o;var F=d+(x.title?this.legendTitleMargin+(b/2):this.legendTextMargin+(k/2));var u=Math.max(C,k);var l=0;this.jT(G,d,m,I,x.title,"-legend-"+x.id);if(x.title){F+=b+(this.legendTitleMargin*2)}for(var w=0;w<h;w++){for(var H=0;H<o;H++){var s=G+this.legendTextMargin+(C/2)+(p*H);if(l<A){var a=x.text&&x.text[l]?x.text[l]:false;var B=x.shape&&x.shape[l]?x.shape[l]:false;var y=x.shapeColor&&x.shapeColor[l]?x.shapeColor[l]:this.background;var g=x.shapeBorderColor&&x.shapeBorderColor[l]?x.shapeBorderColor[l]:this.foreground;var q=x.line&&x.line[l]?x.line[l]:false;var D=x.shapePattern&&x.shapePattern[l]?x.shapePattern[l]:"closed";var j=x.lineType&&x.lineType[l]?x.lineType[l]:"solid";var z=x.lineColor&&x.lineColor[l]?x.lineColor[l]:this.foreground;var f=x.lineWidth&&x.lineWidth[l]?x.lineWidth[l]:1.5;var t=a;var e=this.vK(false,false,"legend-text-"+a);if(a){if(B&&q){this.zM(s,F,B,C,y,g,D,j,z,a,t,null,e)}else{if(B){this.Gl(s,F,B,C,y,g,D,j,z,a,t,null,e)}else{if(q){this.SO(s,F,B,C,y,f,D,j,z,a,t,null,e)}else{this.va(s,F,B,C,y,g,D,j,z,a,t,null,e)}}}}}l++}F+=this.legendTextMargin+u}};this.v6=function(r,o,m,x,p,z,n){var s=this.TM();var c=this.HU(this.legendTextFont)+2;var q=Math.max(s,c);var d=0;this.zS(r,o,m,x,"-legend");this.tA({p:["drawText",z,r+(m/2),o+this.margin+(c/2),this.legendTitleFont,this.legendTitleColor,"center","middle"],t:"Legends"});d=o+c+this.margin;if(this.showLegendBorder){this.tA({p:["drawLine","line",r,d,r+m,d,this.legendBackgroundBorderColor],t:"Legends"})}d+=this.margin;if(!n){n=1}var b=m/n;var e=Math.ceil(p.levels.length/n);var f=0;var a=d;var g=p.origin?p.origin:this.meta.data.modified?"modified":"y";for(var v=0;v<e;v++){for(var u=0;u<n;u++){var y=r+this.margin+(b*u);if(f<p.levels.length){var k=p.type=="String"?p.colors[f]:this.Wk(p.colorBrew,p.levels[f]);this.tA({p:["drawShape",this.useRoundRectangles?"rounderect":"square",y+(q/2),a+(q/2),q,q,this.Nb(k),this.f6(k)],i:["Property:"+z+":"+p.levels[f]+":"+g],t:"Legends",h:this.vK(false,false,"Property:"+z+":"+p.levels[f]+":"+g)});this.tA({p:["drawText",p.levels[f],y+q+this.margin,a+(q/2),this.legendTextFont,this.legendTextColor,"left","middle"],i:["Property:"+z+":"+p.levels[f]+":"+g],t:"Legends",h:this.vK(false,false,"Property:"+z+":"+p.levels[f]+":"+g)})}else{break}f++}a+=q}};this.Lz=function(b,o,j,d,n,g,f){var e=this.TM();var c=this.HU(this.legendTextFont)+2;var m=Math.max(e,c);var i=o;var a=b+this.margin;var k=f.color;this.tA({p:["drawShape",this.useRoundRectangles?"rounderect":"square",a+(m/2),i+(m/2),m,m,this.Nb(k),this.f6(k)],i:["Property:"+g+":"+g+":y"],t:"Legends",h:this.vK(false,false,"Property:"+g+":"+g+":y")});this.tA({p:["drawText",g,a+m+this.margin,i+(m/2),this.legendTextFont,this.legendTextColor,"left","middle"],i:["Property:"+g+":"+g+":y"],t:"Legends",h:this.vK(false,false,"Property:"+g+":"+g+":y")})};this.pf=function(p,k){if(this.graphType.match(/Scatter/)){var y=this.decorations;var o=this.HU(this.decorationsTextFont);var f=this.DU(this.aL("%15s","X"),this.decorationsTextFont);var m=y.linear||y.exponential||y.logarithmic||y.power||y.polynomial||y.normal||y.nonlinear||y.nor||y.nlfit?f:0;var n=p+(m?this.legend.decoration.maxLabel+f:this.decorationsTextMargin);var x=n;var A=k;var b=A;this.legend.decoration.curX=p;this.legend.decoration.curY=k;this.zS(p,(k-((o/2)+this.decorationsTextMargin)),this.legend.decoration.width,this.legend.decoration.height+this.decorationsTextMargin,"-legend-decorations",true);if(y.nlfit||y.nonlinear){this.tA({p:["drawText","Min",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText","Max",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText","EC50",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText","Slope",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText","p-Val",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText","F-Chg",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});var a=y.nlfit?y.nlfit:y.nonlinear;b+=o+this.decorationsTextMargin;for(var u=0;u<a.length;u++){var q=u%this.colors.length;q=a[u].color?a[u].color:this.colors[q];x=(n+this.decorationsTextMargin)-f;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){x+=this.decorationsTextMargin+this.HU(this.axisTitleFont)+this.decorationsTextMargin}this.tA({p:["drawText",a[u].label,x,b,this.decorationsTextFont,q,"right","middle"],t:"Legends"});x=n;for(var s=0;s<6;s++){var B=a[u].param[s];if(s<2){B=this.ZA(this.yAxisTransform,B)}else{if(s==2){}}this.tA({p:["drawText",this.qo(B,this.yAxisDecs+6),x,b,this.decorationsTextFont,q,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin}b+=o+this.decorationsTextMargin}}if(y.nor||y.normal){var c=y.nor?y.nor:y.normal;this.tA({p:["drawText","Mu",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText","Sigma",x,b,this.decorationsTextFont,this.decorationsTextColor,"right","middle"],t:"Legends"});b+=o+this.decorationsTextMargin;for(var u=0;u<c.length;u++){var q=u%this.colors.length;q=c[u].color?c[u].color:this.colors[q];x=(n+this.decorationsTextMargin)-f;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){x+=this.decorationsTextMargin+this.HU(this.axisTitleFont)+this.decorationsTextMargin}this.tA({p:["drawText",c[u].label,x,b,this.decorationsTextFont,q,"right","middle"],t:"Legends"});x=n;this.tA({p:["drawText",this.qo(c[u].mu,this.xAxisDecs+1),x,b,this.decorationsTextFont,q,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;this.tA({p:["drawText",this.qo(c[u].sigma,this.xAxisDecs+2),x,b,this.decorationsTextFont,q,"right","middle"],t:"Legends"});x+=f+this.decorationsTextMargin;b+=o+this.decorationsTextMargin}}if(y.line){for(var u=0;u<y.line.length;u++){if(y.line[u].label){for(var u=0;u<y.line.length;u++){var q=y.line[u].color?y.line[u].color:this.colors[u%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){x+=this.decorationsTextMargin+this.HU(this.axisTitleFont)+this.decorationsTextMargin}this.tA({p:["drawText",y.line[u].label,x,b,this.decorationsTextFont,q,"left","middle"],t:"Legends"});b+=o+this.decorationsTextMargin}}}}if(y.area){for(var u=0;u<y.area.length;u++){if(y.area[u].label){var q=y.area[u].color?y.area[u].color:this.colors[u%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){x+=this.decorationsTextMargin+this.HU(this.axisTitleFont)+this.decorationsTextMargin}this.tA(["drawText",y.area[u].label,x,b,this.decorationsTextFont,q,"left","middle"]);b+=o+this.decorationsTextMargin}}}}else{if(this.graphType=="Map"&&this.decorations.pie&&this.decorations.pie[0]&&this.decorations.pie[0].smps&&this.decorations.pie[0].smps.length){var y=this.decorations.pie[0];var o=this.HU(this.decorationsTextFont);var e=o/2;var g=this.legend.decoration.columns||this.legendColumns;var z=Math.ceil(y.smps.length/g);var w=this.legend.decoration.width/g;var r=0;var n=p;var A=k;var v=A+e;for(var u=0;u<z;u++){for(var s=0;s<g;s++){x=n+(this.decorationsTextMargin+(w*s));if(r<y.smps.length){var f=y.colors[r];var h=x+e;this.tA({p:["drawShape","circle",h,v,o,o,f,this.background],t:"Legends"});this.tA({p:["drawText",y.smps[r],h+e+this.decorationsTextMargin,v,this.decorationsTextFont,this.decorationsTextColor,"left","middle"],t:"Legends"})}else{break}r++}v+=(e*2)+this.margin}}}};this.uw=function(c){if(c){delete (this.legend.decoration.curX);delete (this.legend.decoration.curY);delete (this.legend.decoration.x);delete (this.legend.decoration.y)}var a=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","sample","bin2d","colorLabel","sizeLabel"];for(var b=0;b<a.length;b++){this.legend[a[b]].width=0;this.legend[a[b]].height=0;if(c){delete (this.legend[a[b]].curX);delete (this.legend[a[b]].curY);delete (this.legend[a[b]].x);delete (this.legend[a[b]].y)}}};this.xy=function(B,s,o){var k,g,r;var n=-1;var A=-1;var f=this;var c=this.graphType=="Network"?0:this.offsetX;var b=this.graphType=="Network"?0:this.offsetY;var d=function(){for(var l=0;l<f.legend.layout.length;l++){if(f.legend.layout[l]){for(var h=0;h<f.legend.layout[l].length;h++){if(f.legend.layout[l][h]==B){return[l,h]}}}}return[-1,-1]};if(this.legend.layout){var e=d();n=e[0];A=e[1];if(n>-1&&A>-1){var a=0;var p=0;if(this.legendPosition.match(/right|left/i)){for(var v=0;v<n;v++){var m=0;if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[v].length;u++){m=Math.max(m,this.legend[this.legend.layout[v][u]].width+this.margin)}}a+=m}if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[n].length;u++){p+=this.legend[this.legend.layout[n][u]].height+this.margin}}}else{for(var v=0;v<n;v++){var z=0;if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[v].length;u++){z=Math.max(z,this.legend[this.legend.layout[v][u]].height+this.margin)}}p+=z}if(this.legend.layout[v]){for(var u=0;u<this.legend.layout[n].length;u++){a+=this.legend[this.legend.layout[n][u]].width+this.margin}}}if(this.legendPosition.match(/right|left/i)){o=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.UL("legendPosition")))?this.marginTop+this.layoutTop:A==0?this.marginTop+b+this.top:o;k=s+a+(this.graphType=="Network"?-10:0);r=this.legendPosition.match(/top/)?this.margin:this.legendPosition.match(/bottom/)?this.y-(p+this.margin):((this.y-p)/2);g=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.UL("legendPosition")))?(this.height-p)/2:A==0?this.marginTop+b+this.top+r:o;s=A==this.legend.layout[n].length-1?s+a:s;o=g+this.legend[this.legend.layout[n][A]].height+this.margin}else{s=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.UL("legendPosition")))?this.marginLeft+this.layoutLeft:A==0?this.marginLeft+c+this.left:s;k=A==0&&(this.scatterPlotMatrix||(this.layoutValid&&!this.UL("legendPosition")))?(this.width-a)/2:A==0?this.marginLeft+c+this.left+((this.x-a)/2)+this.margin:s+this.margin;g=o+p;s=k+this.legend[this.legend.layout[n][A]].width+this.margin;o=A==this.legend.layout[n].length-1?o+p:o}}}return[k,g,s,o]};this.xl=function(){var c,h;if(this.graphType=="Pie"&&this.layoutValid){if(this.legendPosition=="right"){c=this.width-(this.marginRight+this.legend.variable.width+this.margin);h=(this.height/2)-(this.legend.variable.height/2)}else{c=(this.width/2)-(this.legend.variable.width/2);h=this.height-(this.marginBottom+this.legend.variable.height+this.margin)}}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return[0,0]}else{if(this.layoutValid&&this.graphType!="Pie"){var d=this.width-(this.marginLeft+(this.layoutLeft||this.margin)+(this.layoutRight||this.margin)+this.marginRight);var b=this.height-(this.marginTop+(this.layoutTop||this.margin)+(this.layoutBottom||this.margin)+this.marginBottom);var j=this.legend.variable.height+this.legend.overlays.height+(this.margin*-0.5);var e=this.legend.variable.width+this.legend.overlays.width+(this.margin*-0.5);c=this.legendPosition=="right"?this.width-(this.marginRight+e):this.legendPosition=="left"?this.marginLeft+this.margin:this.marginLeft+(this.layoutLeft||this.margin)+(d/2)-(e/2);h=this.legendPosition=="bottom"?this.height-(this.marginBottom+j):this.legendPosition=="top"?this.marginTop+this.margin+this.R2():this.marginTop+(this.layoutTop||this.margin)+(b/2)-(j/2)}else{var f=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;var a=this.legend.variable.height;var i=this.legend.variable.width;if(this.legendInside||this.graphType=="Pie"){switch(this.legendPosition){case"bottomRight":c=f+this.x-(i+this.margin);h=k+this.y-(a+this.margin);break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y-(this.graphType=="Pie"?0:(a+this.margin));break;case"bottomLeft":c=f+this.margin;h=k+this.y-(a+this.margin);break;case"left":c=f+this.margin-(this.graphType=="Pie"?(i+this.margin):0);h=k+(this.y/2)-(a/2);break;case"topLeft":c=f+this.margin;h=k+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=k+this.margin-(this.graphType=="Pie"?(a+this.margin):0);break;case"topRight":c=f+this.x-(i+this.margin);h=k+this.margin;break;default:c=f+this.x-(this.graphType=="Pie"?0:(i+this.margin));h=k+(this.y/2)-(a/2)}}else{var m=this.overlaysLegendPosition.match(/top|bottom/i)?this.legend.overlays.height:0;var g=this.overlaysLegendPosition.match(/right|left/i)?this.legend.overlays.width:0;switch(this.legendPosition){case"bottomRight":c=f+this.x+this.right-(i+g+this.margin);h=k+this.y-a;break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y+this.bottom-(a+m+this.margin);break;case"bottomLeft":c=this.marginLeft+this.offsetX+this.margin;h=k+this.y-a;break;case"left":c=this.marginLeft+this.offsetX+this.margin;h=k+(this.y/2)-(a/2);break;case"topLeft":h=k;c=this.marginLeft+this.offsetX+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=this.marginTop+this.offsetY+this.margin+this.R2();break;case"topRight":h=k;c=f+this.x+this.right-(i+g+this.margin);break;default:c=f+this.x+this.right-(i+g+this.margin);h=k+(this.y/2)-(a/2)}}}}}return[c,h]};this.up=function(){var j=0;var h=0;var g=0;var d=0;var a=0;var i=0;var c=this.graphType=="Network"?10:this.offsetX;var b=this.graphType=="Network"?10:this.offsetY;var e=this.marginLeft+c+this.left+this.margin;var k=this.marginTop+b+this.top+this.margin;if(this.scatterPlotMatrix||(this.layoutValid&&!this.UL("legendPosition"))){if(this.legendPosition=="left"){g=this.marginLeft+this.margin}else{g=this.width+this.margin-(this.marginRight+(this.legend.width||0))}if(this.legendPosition=="top"){d=this.marginTop+this.margin+this.R2()}else{d=this.height+this.margin-(this.marginBottom+(this.legend.height||0))}j=g-(this.legend.decoration.width+this.margin);h=d-(this.legend.decoration.height+this.margin)}else{if(this.legendInside){if(this.legend.decoration.width>0&&this.legend.decoration.height>0){var f=this.legend.decoration.width+(this.margin*2);switch(this.decorationsPosition){case"bottomRight":j=e+this.x-f;h=k+this.y-(this.legend.decoration.height+this.margin);break;case"bottom":j=e+(this.x/2)-(this.legend.decoration.width/2);h=k+this.y-(this.legend.decoration.height+this.margin);break;case"bottomLeft":j=e+this.margin;h=k+this.y-(this.legend.decoration.height+this.margin);break;case"left":j=e+this.margin;h=k+(this.y/2)-(this.legend.decoration.height/2);break;case"topLeft":j=e+this.margin;h=k+(this.margin*2);break;case"top":j=e+(this.x/2)-(this.legend.decoration.width/2);h=k+(this.margin*2);break;case"topRight":j=e+this.x-f;h=k+(this.margin*2);break;default:j=e+this.x-f;h=k+(this.y/2)-(this.legend.decoration.height/2);break}}if(this.legend.width>0&&this.legend.height>0){switch(this.legendPosition){case"bottomRight":g=e+this.x-this.legend.width;d=k+this.y-this.legend.height;break;case"bottom":g=e+(this.x/2)-(this.legend.width/2);d=k+this.y-this.legend.height;break;case"bottomLeft":g=e;d=k+this.y-this.legend.height;break;case"left":g=e;d=k+(this.y/2)-(this.legend.height/2);break;case"topLeft":g=e;d=k;break;case"top":g=e+(this.x/2)-(this.legend.width/2);d=k;break;case"topRight":g=e+this.x-this.legend.width;d=k;break;default:g=e+this.x-this.legend.width;d=k+(this.y/2)-(this.legend.height/2);break}}}else{switch(this.decorationsPosition){case"bottom":j=e+(this.x/2)-(this.legend.decoration.width/2);h=k+this.y+this.bottom-this.legend.decoration.height;break;default:j=e+this.x+this.right-(this.legend.decoration.width+(this.margin*2));h=k+(this.y/2)-(this.legend.decoration.height/2);break}a=this.legendPosition==this.decorationsPosition?this.legend.decoration.width:0;i=this.legendPosition==this.decorationsPosition?this.legend.decoration.height:0;switch(this.legendPosition){case"bottomRight":g=e+this.x+this.right-(this.legend.width+a);d=k+this.y-(this.legend.height/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legend.width}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"&&this.showHeatmapIndicator){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break;case"bottom":g=e+(this.x/2)-(this.legend.width/2);d=k+this.y+this.bottom-(this.legend.height+(i?i+this.margin:0));if(this.graphType=="Scatter3D"||this.is3DPlot){d+=this.legend.height}break;case"bottomLeft":g=this.marginLeft+c+this.margin;d=k+this.y-(this.legend.height/2);break;case"left":g=this.marginLeft+c+this.margin;d=k+(this.y/2)-(this.legend.height/2);break;case"topLeft":g=this.marginLeft+c+this.margin;d=k+(this.legend.height/2);break;case"top":g=e+(this.x/2)-(this.legend.width/2);d=this.marginTop+b+this.margin+this.R2();break;case"topRight":g=e+this.x+this.right-(this.legend.width+a);d=k+(this.legend.height/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legend.width}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"&&this.showHeatmapIndicator){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break;default:g=e+this.x+this.right-(this.legend.width+a);d=k+(this.y/2)-(this.legend.height/2);if(this.graphType=="Scatter3D"||this.is3DPlot){g+=this.legend.width}if(this.isMultidimensionalData&&this.heatmapIndicatorPosition=="right"&&this.showHeatmapIndicator){g-=(this.heatmapIndicatorHeight+this.meta.def.colorBrew.maxLevLen+this.margin)}if(this.scatterType=="visium"){g-=this.margin*3}break}}}return[j,h,g,d]};this.m2=function(a,b,c){this.p3(a,b,false,c)};this.qL=function(a){if(this.graphType=="Meter"){return}else{if(this.graphType=="Fish"){var b=this.xl();this.SP(b[0],b[1])}else{if(this.graphType=="Venn"){this.Sh()}else{if(this.graphType=="Circular"){if(this.circularType.match(/sunburst|bubble/)){this.Yi(a)}else{if(this.showLegend){this.gk();var b=this.xl();this.SP(b[0],b[1])}}}else{if(this.graphType=="Network"){this.Yi()}else{if(this.graphType.match(/Scatter/)||this.is3DPlot||((this.tl()||this.connectBy)&&(CanvasXpress.graphTypes.AttGraphs.includes(this.graphType)||this.graphType=="Map"))){this.Yi(a);if(this.isOncoprint){this.hi()}this.gk()}else{if(this.graphType=="Pie"&&this.layoutValid&&!this.isDOE){if(this.layoutCurrent==this.data.l.smps.length-1){this.MX()}}else{this.MX();this.gk()}}}}}}}};this.MX=function(){if(this.showLegend&&((this.graphType!="Heatmap")||(this.graphType=="Heatmap"&&this.tl()))){if(this.isMultidimensionalData||(this.tl()&&CanvasXpress.graphTypes.AttGraphs.includes(this.graphType))){if(this.isOncoprint){this.hi()}this.Yi()}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return}var c=this.xl();var a=c[0];var b=c[1];if(this.legend.variableX&&this.legend.variableY){a=this.legend.variableX;b=this.legend.variableY}this.legend.variableCurX=a;this.legend.variableCurY=b;this.SP(a,b)}}else{if(this.isOncoprint){this.hi()}}};this.gk=function(){var v,f;if(this.overlaysLegendPosition.match(/right/i)){v=this.layoutValid?this.marginTop+this.layoutTop:this.marginTop+this.offsetY+this.top;if(this.overlaysLegendPosition=="right"){v+=(this.y/2)-(this.legend.overlays.height/2)}f=this.layoutValid?this.width-(this.marginRight+this.layoutRight+this.legend.overlays.width):this.width-(this.marginRight+this.legend.overlays.width);if(this.graphType=="Heatmap"&&this.heatmapIndicatorPosition=="right"){f-=this.Sw()-this.margin}}else{v=this.layoutValid?this.height-(this.marginBottom+this.layoutBottom+this.legend.overlays.height):this.height-(this.marginBottom+this.legend.overlays.height);f=this.layoutValid?this.marginLeft+this.layoutLeft:this.marginLeft+this.offsetX+this.left;if(this.overlaysLegendPosition=="bottom"){f+=(this.x/2)-(this.legend.overlays.width/2)}}var y=v;var g=f;for(var n=0;n<this.legend.overlays.layout.length;n++){var r=this.legend.overlays.layout[n];var u,d,e,a,b;var x=mw=0;var s=mh=0;for(var k=0;k<r.length;k++){u=r[k][0];d=r[k][1];mw=Math.max(x,r[k][2]);mh=Math.max(s,r[k][3])}for(var k=0;k<r.length;k++){u=r[k][0];d=r[k][1];e=this.meta.data[u][d];x=this.legend.overlays[d].width;s=this.legend.overlays[d].height;b=u=="z"?this.varOverlayProperties:this.smpOverlayProperties;a=b[d].legendColumns?b[d].legendColumns:u=="z"?this.varOverlaysLegendColumns:this.smpOverlaysLegendColumns;if(e.type=="String"){this.v6(g,y,x,s,e,d,a)}else{if(b[d].type=="Default"){this.p3(g,y,e,d,false,x/2)}else{this.Lz(g,y,x,s,e,d,b[d]);y-=(this.margin*1)}}if(this.overlaysLegendPosition.match(/right/i)){y+=s+this.margin}else{g+=x+this.margin}}if(this.overlaysLegendPosition.match(/right/i)){g+=mw+this.margin;y=v}else{g=f;y+=mh+this.margin}}};this.Yi=function(g){var o=this.up();if(this.showDecorations&&this.showDecorationsLegend&&this.decorations&&!this.layoutValid){if(this.legend.decoration.x!=null&&this.legend.decoration.y!=null){this.pf(this.legend.decoration.x,this.legend.decoration.y)}else{this.pf(o[0],o[1])}}if(this.showLegend){var l=this.graphType=="Network"?["colorNode","shapeNode","sizeNode","patternNode","colorEdge","sizeEdge","decoration"]:this.scatterPlotMatrix?["color","shape","size","pattern","variable"]:this.connectByNoColor?["color","shape","size","pattern","variable","sample"]:["color","shape","size","line","pattern","connect","variable","sample","contour","bin2d","colorLabel","sizeLabel"];var f=o[2];var p=o[3];var u=this.isContour&&this.contourType=="Point"?"Size":"Color";for(var j=0;j<l.length;j++){var t=this.legend[l[j]].width;var k=this.legend[l[j]].height;var s=this.legend[l[j]].x;var n=this.legend[l[j]].y;var b=this.um()&&l[j]=="sample";if(t>0){if(g&&!b){this.HI(l[j]);t=this.legend[l[j]].width;k=this.legend[l[j]].height}var a=this.YX(l[j]);var e=("draw"+a+"Legend").replace("Node","").replace("Edge","").replace("Label","").replace("Decoration","color").replace("Contour",u).replace("Bin2d",u).replace("Line","Color");var d=this.legend[l[j]].meta;var r=this.xy(l[j],f,p);if(s&&n){this[e](s,n,d,l[j]);this.legend[l[j]].curX=s;this.legend[l[j]].curY=n}else{if(r[0]&&r[1]){this[e](r[0],r[1],d,l[j]);this.legend[l[j]].curX=r[0];this.legend[l[j]].curY=r[1]}}if(this.legendPosition.match(/right|left/i)){p=r[3]+this.margin}else{f=r[2]+this.margin}}}for(var j=0;j<this.customLegend.length;j++){if(this.graphType=="Network"&&!this.showDecorations){continue}var c="custom"+j;var t=this.legend[c].width;var k=this.legend[c].height;var s=this.legend[c].x;var n=this.legend[c].y;var r=this.xy(c,f,p);if(s&&n){this.gV(s,n,t,k,this.customLegend[j]);this.legend[c].curX=s;this.legend[c].curY=n}else{this.gV(r[0],r[1],t,k,this.customLegend[j]);this.legend[c].curX=r[0];this.legend[c].curY=r[1]}if(this.legendPosition.match(/right|left/i)){p=r[3]+this.margin}else{f=r[2]+this.margin}}}}};CanvasXpress.prototype.initMarkerUtils=function(){this.sG=function(){if(this.markerIds&&this.markerIds.vars.length&&(this.markerIds.smps.length||this.graphType.match(/Scatter/))){if(!this.decorations){this.decorations={}}if(!this.decorations.marker){this.decorations.marker=[]}var a={};if(this.graphType.match(/Scatter/)){if(!this.markerIds.smps.length){this.markerIds.smps=[this.xAxis[0],this.yAxis[0]]}a={sample:this.ZD(this.markerIds.smps),variable:this.markerIds.vars[0],type:"none",text:this.markerIds.vars[0],position:"center"}}else{if(this.markerIds.smps.length==2&&this.markerIds.vars.length==1){a={sample:this.markerIds.smps[0],sample2:this.markerIds.smps[1],variable:this.markerIds.vars[0],variable2:this.markerIds.vars[0],type:"comparison",text:this.markerIds.smps[0]+" - "+this.markerIds.smps[1]}}else{if(this.markerIds.smps.length==1&&this.markerIds.vars.length==1){a={sample:this.markerIds.smps[0],variable:this.markerIds.vars[0],type:"none",text:this.markerIds.smps[0],position:"center"}}}}this.Sp(a);this.TG(a);this.decorations.marker.push(a);this.j8({func:"createMarker",par:[],prop:{markerIds:this.ZD(this.markerIds)}});this.markerIds={smps:[],vars:[]}}else{if(!this.decorations){this.decorations={}}if(!this.decorations.line){this.decorations.line=[]}a={x:0,color:"rgb(0,0,0)",id:this.Ph("-decoration-")};this.decorations.line.push(a);this.markerIds={smps:[],vars:[]}}};this.fT=function(c){var a=this.yn(true);for(var b=0;b<a.length;b++){if(a[b].id==c){a.splice(b,1);break}}if(!this.decorations.marker.length){delete this.decorations.marker}this.j8({func:"removeMarkerObject",par:[c]})};this.yn=function(a){if(this.decorations&&this.decorations.marker){return a?this.decorations.marker:this.ZD(this.decorations.marker)}return[]};this.j9=function(c){var a=this.yn();for(var b=0;b<a.length;b++){if(a[b].id==c){return a[b]}}return false};this.U1=function(){var d=[];if(this.decorations&&this.decorations.marker){var b=this.decorations.marker;for(var c=0;c<b.length;c++){if(b[c].variable){var a=this.qv(b[c].variable);if(a>=0){d[a]=true}}}}return d};this.e9=function(a){if(this.layoutValid&&this.data.l&&this.data.l.comp&&this.segregateSamplesBy.length&&this.segregateVariablesBy.length){if(!a.variable){return[]}var b=this.pe(a.variable)?a.variable[0]:a.variable;for(var c=0;c<this.data.l.comp[this.layoutCurrent][0].length;c++){var d=this.data.l.comp[this.layoutCurrent][0][c];var e=this.data.y.vars[d];if(e==b){return[d]}}return[]}else{return !a.variable?[]:this.pe(a.variable)?this.qv(a.variable):this.qv([a.variable])}};this.jD=function(d){var c=this.graphType.match(/Treemap|Stacked|Dotplot/)||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)?true:false;var n=[];if(this.layoutValid&&this.data.l&&this.data.l.smps&&this.data.l.smps[this.layoutCurrent]){for(var g=0;g<this.data.l.smps[this.layoutCurrent].length;g++){if(this.data.l.smps[this.layoutCurrent][g]==d.sample){if(((this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Dotplot")&&this.isGroupedData&&this.data.w){var q=false;for(var f=0;f<this.data.w.grps.length;f++){for(var e=0;e<this.data.w.grps[f].length;e++){if(this.data.l.ids[this.layoutCurrent][g]==this.data.w.grps[f][e]){n.push(f);n.push(this.data.l.ids[this.layoutCurrent][g]);q=true}}if(q){break}}}else{n.push(this.data.l.ids[this.layoutCurrent][g])}break}}if(!n.length&&this.isGroupedData&&this.data.w){for(var g=0;g<this.data.w.labs.length;g++){if(this.data.w.labs[g].replace("\x00","")==d.sample){n.push(g)}}}if(d.scope&&this.pe(d.scope)){if(this.isGroupedData&&this.data.w&&n.length){if(d.scope.length>1){if(this.data.l.name[this.layoutCurrent].includes(d.scope[0])&&this.data.l.name[this.layoutCurrent].includes(d.scope[1])){n=[n[0]]}else{n=null}}else{if(this.data.l.name[this.layoutCurrent].includes(d.scope[0])){n=[n[0]]}else{n=null}}}else{if(this.data.x){for(var g=0;g<n.length;g++){var o=n[g];var l=0;for(var a in this.data.x){if(d.scope.includes(this.data.x[a][o])){l++}}if(l==d.scope.length){n=o;break}}if(this.pe(n)){n=[n[0]]}}else{n=[n[0]]}}}}else{n=!d.sample?[]:this.pe(d.sample)?this.uL(d.sample,c):this.uL([d.sample],c);if(!n.length&&this.isGroupedData&&this.data.w){for(var g=0;g<this.data.w.grps.length;g++){var b=this.data.w.labs[g].replace("\x00","");if(d.sample[0].toString().replace("\x00","")==b){n.unshift(g);q=true;break}}}if(((this.graphType=="Boxplot"&&this.showBoxplotOriginalData)||this.graphType=="Dotplot")&&this.isGroupedData&&this.data.w){if(n.length){var q=false;for(var g=0;g<this.data.w.grps.length;g++){for(var f=0;f<this.data.w.grps[g].length;f++){if(n[0]==this.data.w.grps[g][f]){n.unshift(g);q=true;break}}if(q){break}}}else{n=!d.sample?[]:this.pe(d.sample)?this.uL(d.sample):this.uL([d.sample])}}}return n};this.ti=function(f){var e=this.meta.render.objects;var c=[];for(var b=0;b<e.length;b++){var d=e[b];if(d.type=="Data"&&d.idx){var a=d.idx.join(":");if(a==f||a==f+":false"||a==f+":true"||a==f+":box"){if(this.layoutValid){if(d.layout==this.layoutCurrent){c.push(d)}}else{c.push(d)}}}}if(c.length){return c[0]}return false};this.ma=function(a){return(a.fontStyle||this.decorationsTextFontStyle)+" "+(parseInt(a.fontSize)||this.decorationsTextFontSize)+"px "+this.fontName};this.DN=function(d,j){var g=d.textLength*0.5;var n=d.textHeight*0.5;var e=d.tx<=j[2].left[0]-g;var a=d.tx>=j[2].right[0]+g;var o=d.ty<=j[2].top[1]-n;var k=d.ty>=j[2].bottom[1]+n;var i=1.1;if(o&&e){d.line[2]+=g*i;d.line2=[d.line[2],d.line[3]-n,d.line[2],d.line[3]+n]}else{if(o&&a){d.line[2]-=g*i;d.line2=[d.line[2],d.line[3]-n,d.line[2],d.line[3]+n]}else{if(k&&a){d.line[2]-=g*i;d.line2=[d.line[2],d.line[3]-n,d.line[2],d.line[3]+n]}else{if(k&&e){d.line[2]+=g*i;d.line2=[d.line[2],d.line[3]-n,d.line[2],d.line[3]+n]}else{if(o){d.line[3]+=n;d.line2=[d.line[2]-g,d.line[3],d.line[2]+g,d.line[3]]}else{if(a){d.line[2]-=g*i;d.line2=[d.line[2],d.line[3]-n,d.line[2],d.line[3]+n]}else{if(k){d.line[3]-=n;d.line2=[d.line[2]-g,d.line[3],d.line[2]+g,d.line[3]]}else{if(e){d.line[2]+=g*i;d.line2=[d.line[2],d.line[3]-n,d.line[2],d.line[3]+n]}else{delete (d.line);delete (d.line2)}}}}}}}}};this.TG=function(a){var b=this.M9(a.render)?a.render:this.meta.render.objects[a.render];var d=this.EP(b,"center",true,2);a.x=d[0];a.y=d[1]};this.Sp=function(b,c){if(!b.variable){return false}var n,l,q,h,e;var a=this.graphType.match(/Treemap|Stacked|Dotplot/)||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)?true:false;var j=this.e9(b);var g=b.variable2&&this.pe(b.variable2)?this.qv(b.variable2):b.variable2?this.qv([b.variable2]):false;var k=this.jD(b);var i=b.sample2&&this.pe(b.sample2)?this.uL(b.sample2,a):b.sample2?this.uL([b.sample2],a):false;var p=j.concat(k).join(":");var o=this.ti(p);var d=b.position&&b.position!="false"?b.position:"center";if(o&&o.area){switch(b.type){case"range":case"comparison":n=g.concat(i).join(":");l=this.ti(n);h=this.EP(o,"top",false,4);e=this.EP(l,"top",false,4);q=[(h[0]+e[0])/2,Math.min(h[1],e[1])-(this.HU(this.ma(b))*0.5)];b.tx=b.offsetX?q[0]+b.offsetX:q[0];b.ty=b.offsetY?q[1]+b.offsetY:q[1];b.line=[h[0],Math.min(h[1],e[1]),e[0],Math.min(h[1],e[1])];b.render=o.n;b.render2=l.n;b.position="top";b.id=b.id==null?this.Ph("-marker-"):b.id;break;case"none":case"line":case"square":case"arrow":case"curvedcw":case"curvedacw":case"annotation":default:h=this.EP(o,d,false,(b.x&&b.y?0:2),b.x,b.y);q=[h[0],h[1]];if(b.x&&b.y){q=h[3]}b.tx=c?b.curX:b.offsetX?q[0]+b.offsetX:q[0];b.ty=c?b.curY:b.offsetY?q[1]+b.offsetY:q[1];b.line=c?[h[2].center[0],h[2].center[1],b.tx,b.ty]:[h[2].center[0],h[2].center[1],q[0],q[1]];b.text=b.text.replace(/__nl__/g,"\n");b.textLength=this.DU(b.text,this.ma(b));b.textHeight=this.Db(b.text,this.ma(b));this.DN(b,h);b.render=o.n;b.id=b.id==null?this.Ph("-marker-"):b.id;break}return b}return false};this.Op=function(c){if(c&&this.decorations&&this.decorations.marker){for(var b=0;b<this.decorations.marker.length;b++){var a=this.decorations.marker[b];if(c==a.id){return a}}}};this.Wp=function(a){if(this.layoutValid){var c=this.layoutCurrent==false?0:this.layoutCurrent!=null?this.layoutCurrent:(this.layoutValidN||0);var b=this.layoutParams[c];if(a.si!=null||a.render){if(a.hasOwnProperty("layout")){if(a.layout!=c){return false}}return a.ty>this.offsetY&&a.ty<this.offsetY+(b.height||this.height)&&a.tx>this.offsetX&&a.tx<this.offsetX+(b.width||this.width)}else{return false}}else{return a.ty>0&&a.ty<this.height&&a.tx>0&&a.tx<this.width}};this.b2=function(a){if(a){this.oF();this.isHighlightCanvas=true}else{if(this.moveMarker){return}}if(this.decorations&&this.decorations.marker){var A=this.decorations.marker;var v=[];if(this.layoutValid&&this.data.l&&!this.isDOE){var r=this.data.l.name[this.layoutCurrent];for(var z=0;z<A.length;z++){if(!this.pe(A[z].scope)){A[z].scope=[A[z].scope]}if(A[z].scope){if(this.pe(r)){if(this.pe(A[z].scope)){var C=r.sort().join("").replace("\x00","");var p=A[z].scope.sort().join("").replace("\x00","");if(C==p){v.push(z)}}else{if(r.includes(A[z].scope[0])){v.push(z)}}}else{if(r==A[z].scope[0]){v.push(z)}}}else{v.push(z)}}}else{for(var z=0;z<A.length;z++){v.push(z)}}for(var z=0;z<v.length;z++){delete (A[v[z]].tx);delete (A[v[z]].ty);delete (A[v[z]].layout);var u=this.Sp(A[v[z]],a);if(u&&u.tx&&u.ty){if(this.Wp(u)||a){var g=u.scope||false;if(g){var f=this.layoutValid?false:true;if(this.layoutValid){var h=this.data.l.name[this.layoutCurrent];if(!this.pe(h)){h=[h]}for(var y=0;y<h.length;y++){var t=h[y].toString().replace("\x00","");if(this.pe(g)){for(var x=0;x<g.length;x++){if(g[x].toString()==t){f=true;break}}}else{if(g.toString()==t){f=true;break}}}}if(!f){continue}}var e=u.rotate?Math.PI*u.rotate/180:false;u.color=u.color||"rgb(0,0,0)";u.align=u.align||"center";u.baseline=u.baseline||"middle";u.width=u.width||1;u.type=u.type||"line";u.lineColor=u.lineColor||this.foreground;var o=this.tA({p:["drawText",u.text,u.tx,u.ty,this.ma(u),u.color,u.align,u.baseline,e],g:u.render||null,i:["Marker:"+u.id],t:"Decorations",d:this.moveMarker?true:false});if(!a){if(u.type.match(/line|square|comparison/)&&u.line){this.tA({p:["drawLine","line",u.line[0],u.line[1],u.line[2],u.line[3],u.lineColor,u.width],g:u.render||o,t:"Decorations",d:this.moveMarker?true:false})}else{if(u.type.match(/arrow/)){this.tA({p:["drawLine","line",u.line[2],u.line[3],u.line[0],u.line[1],u.lineColor,u.width,false,false,false,false,false,false,false,"arrow"],g:u.render||o,t:"Decorations",d:this.moveMarker?true:false})}else{if(u.type.match(/curved/)){var B=u.type=="curvedcw"?Math.PI/2:-Math.PI/2;var w=[(u.line[0]+u.line[2])*0.5,(u.line[1]+u.line[3])*0.5];var b=Math.atan2(u.line[3]-u.line[1],u.line[2]-u.line[0])+B;var c=[w[0]+25*Math.cos(b),w[1]+25*Math.sin(b)];this.tA({p:["drawLine","arch",[u.line[2],c[0],u.line[0]],[u.line[3],c[1],u.line[1]],false,false,u.lineColor,u.width,false,false,false,false,false,false,false,"arrow"],g:u.render||o,t:"Decorations",d:this.moveMarker?true:false})}}}if(u.type=="comparison"){this.tA({p:["drawLine","line",u.line[0],u.line[1]-this.margin,u.line[0],u.line[1]+this.margin,u.lineColor,u.width],g:u.render||o,t:"Decorations",d:this.moveMarker?true:false});this.tA({p:["drawLine","line",u.line[2],u.line[3]-this.margin,u.line[2],u.line[3]+this.margin,u.lineColor,u.width],g:u.render||o,t:"Decorations",d:this.moveMarker?true:false})}else{if(u.type=="square"&&u.line2){this.tA({p:["drawLine","line",u.line2[0],u.line2[1],u.line2[2],u.line2[3],u.lineColor,u.width],g:u.render||o,t:"Decorations",d:this.moveMarker?true:false})}}}u.curX=u.tx;u.curY=u.ty}}}}if(a){this.isHighlightCanvas=false}};this.S0=function(f){var g=[];var e=["line","point","text","range"];if(this.decorations){for(var c=0;c<e.length;c++){if(this.decorations[e[c]]){for(var b=0;b<this.decorations[e[c]].length;b++){var a=f?this.decorations[e[c]][b]:this.ZD(this.decorations[e[c]][b]);a.type=e[c];g.push(a)}}}}return g};this.wb=function(c){var b=this.S0();for(var a=0;a<b.length;a++){if(b[a].id==c){return b[a]}}return false};this.Sq=function(d){var c=["line","point","text","range"];for(var b=0;b<c.length;b++){if(this.decorations[c[b]]&&this.decorations[c[b]].length){for(var a=0;a<this.decorations[c[b]].length;a++){if(this.decorations[c[b]][a].id==d){this.decorations[c[b]].splice(a,1);if(!this.decorations[c[b]].length){delete this.decorations[c[b]]}break}}}}this.j8({func:"removeDecorationObject",par:[d]})}};CanvasXpress.prototype.initFilterUtils=function(){this.A8=function(l){this.hiddenLegends[l.id]=this.hiddenLegends[l.id]?false:true;var c=!this.hiddenLegends[l.id];var m=this.showTransition;this.showTransition=false;switch(l.type){case"var":this.yK(l.type+"s","exact",(this.pe(l.name)?l.name:[l.name]),c);break;case"smp":this.mB(l.type+"s","exact",(this.pe(l.name)?l.name:[l.name]),c);break;case"series":if(this.um()){var b=(!this.segregateVariablesBy.length||this.segregateVariablesBy[0]!=this.isCreateHistogram.factor)?l.name[1].split(":")[1]:(this.segregateVariablesBy[0]==this.isCreateHistogram.factor)?l.name[1].split(":")[0]:false;if(b){l.name=[l.name[0]];for(var e=0;e<this.data.y.smps.length;e++){var g=this.data.y.smps[e].split(":");for(var d=0;d<g.length;d++){if(g[d]==b){l.name.push(this.data.y.smps[e]);continue}}}}}this.mB("smps","exact",(this.pe(l.name)?l.name:[l.name]),c);break;case"meta":var k=this.isOncoprint||this.isMultidimensionalData&&!this.meta.data[l.object][l.factor]&&this.meta.data[l.object]?this.meta.data[l.object]:this.meta.data[l.object][l.factor];switch(l.object){case"x":if(k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.V4(l.factor,"between",[f,a],c)}else{this.V4(l.factor,"exact",(this.pe(l.level)?l.level:[l.level]),c)}break;case"z":if(k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.Oc(l.factor,"between",[f,a],c)}else{this.Oc(l.factor,"exact",(this.pe(l.level)?l.level:[l.level]),c)}break;case"y":var k=this.shapeBy==l.factor?this.legendShapeMeta:this.sizeBy==l.factor?this.legendSizeMeta:false;if(!k){return}var h=0;for(var e=0;e<k.vals.length;e++){if(Number(l.level)==k.vals[e]){h=e;break}}var a=k.vals[h];var f=h==0?Number(l.level)-1e-9:k.vals[h-1]+1e-9;this.Oc(l.factor,"between",[f,a],c);break;case"modified":if(this.meta.data.modified.x&&this.meta.data.modified.x.meta&&this.meta.data.modified.x.meta[l.factor]){alert("Ooops! Needs to develop this case!")}else{if(this.meta.data.modified.z&&this.meta.data.modified.z.meta&&this.meta.data.modified.z.meta[l.factor]){this.Dd("filterSmpBy",l.factor,"exact",[this.meta.data.modified.z.meta[l.factor].order[l.level]],c)}}break;default:if(k&&k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.SS(l.object,"between",[f,a],c)}else{this.SS(l.object,"exact",[l.level],c)}break}break;case"data":this.SS(l.object,"exact",[l.name],c);break;case"network":var k=l.object=="filterNodeBy"&&this.meta.data.nodes?this.meta.data.nodes[l.factor]:l.object=="filterEdgeBy"&&this.meta.data.edges?this.meta.data.edges[l.factor]:false;if(k&&k.type=="Numeric"){var h=k.order[l.level];var a=Number(l.level);var f=k.isRange&&h==0?Number(l.level)-k.incr:k.isRange?(k.levels[h-1]+1e-8):Number(l.level);this.SS(l.factor,"between",[f,a],c,false,l.object)}else{this.SS(l.factor,"exact",[l.level],c,false,l.object)}}this.showTransition=m};this.yK=function(f,e,c,d,a){this.Dd("filterVarBy","vars",e,c,d,a)};this.Oc=function(f,e,c,d,a){this.Dd("filterVarBy",f,e,c,d,a)};this.mB=function(f,e,c,d,a){this.Dd("filterSmpBy","smps",e,c,d,a)};this.V4=function(c,f,d,e,a){this.Dd("filterSmpBy",c,f,d,e,a)};this.SS=function(h,f,d,e,a,g){this.Dd(g||"filterDataBy",h,f,d,e,a)};this.Dd=function(l,n,e,q,a,r){if(this.Q7()){return}var j={min:">=",max:"<=",between:"between",like:"like",exact:"exact"};var c={hidden:{},unhidden:{},vs:q,op:!a};var p;this.HV();var m=this.ZD(this[l]);var k=this.TS();if(!r&&a){this.BU(true,true,false,r);this.Js(k,!r);p={hiddenVars:this.ZD(this.hiddenVars),hiddenSmps:this.ZD(this.hiddenSmps),hiddenGrps:this.ZD(this.hiddenGrps),hiddenMapFeatures:this.ZD(this.hiddenMapFeatures),hiddenNodes:this.ZD(this.hiddenNodes),hiddenEdges:this.ZD(this.hiddenEdges)}}this[l]=m;if(a){for(var f=0;f<this[l].comp.length;f++){if(this[l].comp[f]==n&&this[l].op[f]==j[e]&&this[l].cases[f]==false&&this[l].type[f]=="Legend"&&this.eC(this[l].value[f],q)){this[l].comp.splice(f,1);this[l].op.splice(f,1);this[l].cases.splice(f,1);this[l].type.splice(f,1);this[l].value.splice(f,1)}}}else{this[l].comp.push(n);this[l].op.push(j[e]);this[l].cases.push(false);this[l].type.push("Legend");this[l].value.push(q)}this.BU(true,true,false,r);this.Js(k,!r);if(this.isGroupedData&&this.smpIndices.length>0){var d=this.ZD(this.data.w.grpIdxs);this.rR(this.groupingFactors,false,d,true,true,false,k?false:true)}this.p6(p,c);this.j8({func:"filterUserData",par:[l,n,e,q,a,r],prop:{hiddenLegends:this.hiddenLegends}});this.userEvents.clicklegend.call(this,c,this.lastEvent,this)};this.p6=function(a,f){var g=["hiddenVars","hiddenSmps","hiddenGrps","hiddenMapFeatures","hiddenNodes","hiddenEdges"];for(var c=0;c<g.length;c++){var e=g[c];f.hidden[e]=[];f.unhidden[e]=[];if(!f.op){if(a[e]){for(var d=0;d<a[e].length;d++){if(!this[e][d]&&a[e][d]){switch(e){case"hiddenVars":f.unhidden[e][this.data.y.vars[d]]=true;break;case"hiddenSmps":f.unhidden[e][this.data.y.smps[d]]=true;break;case"hiddenGrps":f.unhidden[e][this.data.w.smps[d]]=true;break;case"hiddenMapFeatures":f.unhidden[e][vs[0]]=true;break;case"hiddenNodes":f.unhidden[e][this.data.nodes[d].id]=true;break;case"hiddenEdges":f.unhidden[e][this.data.edges[d].id]=true;break}}}}}else{if(this[e]){for(var d=0;d<this[e].length;d++){if(this[e][d]){switch(e){case"hiddenVars":f.hidden[e][this.data.y.vars[d]]=true;break;case"hiddenSmps":f.hidden[e][this.data.y.smps[d]]=true;break;case"hiddenGrps":f.hidden[e][this.data.w.smps[d]]=true;break;case"hiddenMapFeatures":f.hidden[e][f.vs[0]]=true;break;case"hiddenNodes":f.hidden[e][this.data.nodes[d].id]=true;break;case"hiddenEdges":f.hidden[e][this.data.edges[d].id]=true;break}}}}}if(this[e]){this[e+"Local"]={};for(var d=0;d<this[e].length;d++){this[e+"Local"][this.data.y.vars[d]]=this[e][d]}}}};this.fZ=function(){if(this.data.bubble){var g={};var d=this.data.bubble.root.descendants();for(var e=0;e<d.length;e++){var a=d[e];if(a.label&&(a.label.x||a.label.y)){var f=a.depth+":"+a.data.name;g[f]={x:a.label.x,y:a.label.y}}}delete this.data.bubble;this.bubbleDeleted=g}};this.Js=function(E,H){if(this.isDOE){return}this.HV();var y={};var P={};var b={};var J=false;var F=this;var w=function(){var a=[];if(F.graphType.match(/line/i)&&F.xAxis.length&&F.xAxis2.length){a=F.qv(F.xAxis);return a.concat(F.qv(F.xAxis2))}else{return F.varIndices}};var G=function(n,s,g){if(s.hasOwnProperty(n)){return s[n]}else{if(n.match(":::")){var d=n.split(":::");if(g[d[1]]){d[1]=parseInt(d[1]);for(var k=0;k<g[d[1]].length;k++){var h=g[d[1]][k];if(s.hasOwnProperty(h)){s=s[h]}else{return false}}if(s.hasOwnProperty(d[0])){return s[d[0]]}}}return false}};var o=function(a){var d={s:[],v:[]};if(F.filterSmpBy.comp.length){for(var g=0;g<F.filterSmpBy.comp.length;g++){if(F.filterSmpBy.comp[g]){if(a&&F.filterSmpBy.type[g]!="Legend"){continue}d.s[g]=F.uL(F.filterSmpBy.comp[g])}}}if(F.filterVarBy.comp.length){for(var g=0;g<F.filterVarBy.comp.length;g++){if(F.filterVarBy.comp[g]){if(a&&F.filterVarBy.type[g]!="Legend"){continue}d.v[g]=F.qv(F.filterVarBy.comp[g])}}}return d};var I=function(aa){var ad=F.motionBy?F.Qc(0,F.data.y.vars.length-1,1):F.graphType.match(/line/i)?w():F.varIndices;var v=o(aa);var p=[];var a;var k=false;for(var s=0;s<ad.length;s++){var ae=ad[s];var h=false;var ac=false;a=F.filterSmpBy;if(a.comp.length>0){for(var n=0;n<a.comp.length;n++){if(a.comp[n]){if(aa&&a.type[n]!="Legend"){continue}var ab=v.s[n];if(ab>=0){k=true;var g=A(F.data.y.data[ae][ab],a.op[n],a.value[n],a.cases[n]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;ac=true;break}}else{if(g){h=true;break}}}}}}a=F.filterVarBy;if(a.comp.length>0&&!ac){for(var n=0;n<a.comp.length;n++){if(a.comp[n]){if(aa&&a.type[n]!="Legend"){continue}var ab=v.v[n];if(ab==-1){k=true;var d=a.comp[n]=="vars"?F.data.y.vars[ae]:F.d2(ae,"z",a.comp[n]);var g=A(d,a.op[n],a.value[n],a.cases[n]);if(F.filterType=="and"&&!aa){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){p.push(ae)}}return k?p:false};var M=function(ad,ac){if(F.isGroupedData&&(!E||ac)){var ag=F.grpIndices;var v=[];var a;var p=false;for(var aa=0;aa<ag.length;aa++){var ah=ag[aa];var h=false;var af=false;a=F.filterSmpBy;if(a.comp.length>0){for(var s=0;s<a.comp.length;s++){if(a.comp[s]){if(ad&&a.type[s]!="Legend"){continue}p=true;if(a.comp[s]=="smps"){var g=false;for(var n=0;n<F.data.w.grps[ah].length;n++){if(A(F.data.y.smps[F.data.w.grps[ah][n]],a.op[s],a.value[s],a.cases[s])){g=true;break}}if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;af=true;break}}else{if(g||h){h=true;break}}}else{var g=A(F.data.w.factors[a.comp[s]][aa],a.op[s],a.value[s],a.cases[s]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;af=true;break}}else{if(g||h){h=true;break}}}}}}if(h){v.push(ah)}}}else{var ag=F.smpIndices;var ab=o(ad);var v=[];var a;var p=false;for(var aa=0;aa<ag.length;aa++){var ah=ag[aa];var h=false;var af=false;a=F.filterVarBy;if(a.comp.length>0){for(var s=0;s<a.comp.length;s++){if(a.comp[s]){if(ad&&a.type[s]!="Legend"){continue}var ae=ab.v[s];if(ae>=0){p=true;var g=A(F.data.y.data[ae][ah],a.op[s],a.value[s],a.cases[s]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;af=true;break}}else{if(g){h=true;break}}}}}}a=F.filterSmpBy;if(a.comp.length>0&&!af){for(var s=0;s<a.comp.length;s++){if(a.comp[s]){if(ad&&a.type[s]!="Legend"){continue}var ae=ab.s[s];if(ae==-1){p=true;var d=a.comp[s]=="smps"?F.data.y.smps[ah]:F.d2(ah,"x",a.comp[s],true);var g=A(d,a.op[s],a.value[s],a.cases[s]);if(F.filterType=="and"&&!ad){if(g){h=true}else{h=false;break}}else{if(g||h){h=true;break}}}}}}if(h){v.push(ah)}}}return p?v:false};var A=function(j,p,h,g){if(!p){return true}if(F.filterSkipNullValues&&(j==null||j=="")){return true}if(p==">"){return parseFloat(j)-parseFloat(h)>0}else{if(p==">="){return parseFloat(j)-parseFloat(h)>0||parseFloat(j)-parseFloat(h)==0}else{if(p=="<"){return parseFloat(j)-parseFloat(h)<0}else{if(p=="<="){return parseFloat(j)-parseFloat(h)<0||parseFloat(j)-parseFloat(h)==0}else{if(p=="between"){return(parseFloat(j)-parseFloat(h[0])>0||parseFloat(j)-parseFloat(h[0])==0)&&(parseFloat(j)-parseFloat(h[1])<0||parseFloat(j)-parseFloat(h[1])==0)}else{if(p=="="||p=="=="){return parseFloat(j)-parseFloat(h)==0}else{if(p=="null"){return j==null}else{if(p=="not null"){return j!=null}else{if(p=="exact"){for(var d=0;d<h.length;d++){if((j+"").toString()==(h[d]+"").toString()){return true}}return false}else{if(p=="like"||p=="not like"){var k=false;if(g){for(var d=0;d<h.length;d++){if((j+"").search(h[d]+"")!=-1||h[d].toString()==j.toString()){k=true;if(p=="like"){break}}}}else{var a=(j+"").toLowerCase();for(var d=0;d<h.length;d++){var n=(h[d]+"").toLowerCase();if(a.search(n)!=-1||a.toString()==n.toString()){k=true;if(p=="like"){break}}}}return p=="like"?k:!k}}}}}}}}}}};if(this.graphType=="Genome"&&this.filterFeatureBy.comp.length>0){for(var U=0;U<this.filterFeatureBy.comp.length;U++){if(this.filterFeatureBy.comp[U]){for(var T=0;T<this.data.tracks.length;T++){var q=this.data.tracks[T];var c=q.data;for(var S=0;S<c.length;S++){var B=c[S];if(this.filterSkipNullKeys&&!B.hasOwnProperty(this.filterFeatureBy.comp[U])){continue}var K=G(this.filterFeatureBy.comp[U],B,this.featuresProperties);if(!A(K,this.filterFeatureBy.opp[U],this.filterFeatureBy.value[U],this.filterFeatureBy.cases[U])){B.hide=this.filterType=="and"?true:y[T+":"+S]?false:true;P[T+":"+S]=true}else{y[T+":"+S]=true;if(this.filterType=="or"&&P[T+":"+S]){B.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.comp.length>0||this.filterEdgeBy.comp.length)){for(var U=0;U<this.filterNodeBy.comp.length;U++){if(this.filterNodeBy.comp[U]){for(var T=0;T<this.data.nodes.length;T++){if(this.filterSkipNullKeys&&!this.data.nodes[T].hasOwnProperty(this.filterNodeBy.comp[U])){continue}var K=G(this.filterNodeBy.comp[U],this.data.nodes[T],this.nodesProperties);var R=this.data.nodes[T].id;if(A(K,this.filterNodeBy.op[U],this.filterNodeBy.value[U],this.filterNodeBy.cases[U])){if(H){this.hiddenNodes[R]=!this.hiddenNodes[R]}else{this.data.nodes[T].hide=!this.data.nodes[T].hide}}}}}for(var U=0;U<this.filterEdgeBy.comp.length;U++){if(this.filterEdgeBy.comp[U]){var r={};for(var T=0;T<this.data.edges.length;T++){var z=this.data.nodes[this.data.nodeIndices[this.data.edges[T].id1]];var x=this.data.nodes[this.data.nodeIndices[this.data.edges[T].id2]];var D=z.id+":"+x.id;if(this.filterSkipNullKeys&&!this.data.edges[T].hasOwnProperty(this.filterEdgeBy.comp[U])){continue}if(r[D]&&H){continue}r[D]=true;var K=G(this.filterEdgeBy.comp[U],this.data.edges[T],this.edgesProperties);if(A(K,this.filterEdgeBy.op[U],this.filterEdgeBy.value[U],this.filterEdgeBy.cases[U])){if(H){this.hiddenEdges[D]=!this.hiddenEdges[D]}else{this.data.edges[T].hide=!this.data.edges[T].hide}}}}}}else{if(this.isCreateHistogram&&!H){if(this.filterVarBy.length>0){var Y=this.dataStndBy;var V=this.data.y.histogram;this.T4("Not implemented Yet")}}else{if(this.graphType=="Scatter2D"&&this.scatterPlotMatrix&&this.scatterPlotMatrixType.match(/correlation|all/)&&!H){if(this.filterVarBy.length>0){this.T4("Not implemented Yet")}}else{if(this.filterDataBy.comp.length>0){var N=[];var e=this.filterDataBy;for(var U=0;U<this.varIndices.length;U++){var K=this.varIndices[U];var W=false;for(var T=0;T<this.smpIndices.length;T++){var L=this.smpIndices[T];for(var S=0;S<e.comp.length;S++){var u=this.data.y[e.comp[S]][K][L];var t=e.value[S]=="No Alteration"?[""]:e.value[S];var C=A(u,e.op[S],t,e.cases[S]);if(this.filterType=="and"&&!H){if(C){W=true}else{W=false;break}}else{if(C){W=true;break}}}if(W){break}}if(W){N.push(K)}}if(H){for(var U=0;U<N.length;U++){this.hiddenVars[N[U]]=true}}}else{if(this.filterVarBy.comp.length>0||this.filterSmpBy.comp.length>0){var N=I(H);var Q=M(H);var m=this.isGroupedData&&this.layoutValid?M(H,true):false;this.fZ();delete this.data.tree;if(H&&N){for(var U=0;U<N.length;U++){this.hiddenVars[N[U]]=true}}else{if(N){this.varIndices=N}}if(this.isGroupedData&&!E){if(H&&Q){for(var U=0;U<Q.length;U++){this.hiddenGrps[Q[U]]=true}}else{if(Q){this.grpIndices=Q}}}else{if(H&&Q){for(var U=0;U<Q.length;U++){this.hiddenSmps[Q[U]]=true}if(this.graphType.match(/Scatter/)){if(this.axesType=="X"&&this.xAxisIndices.length>1){if(this.hiddenSmps[this.yAxisIndices[0]]){this.hiddenSmps[this.yAxisIndices[0]]=false}}else{if(this.axesType=="Y"&&this.yAxisIndices.length>1){if(this.hiddenSmps[this.xAxisIndices[0]]){this.hiddenSmps[this.xAxisIndices[0]]=false}}}}}else{if(Q){this.smpIndices=Q}}}if(m&&H){this.hiddenGrpsLayout=[];for(var U=0;U<m.length;U++){this.hiddenGrpsLayout[m[U]]=true}}else{this.hiddenGrpsLayout=false}}else{this.hiddenGrpsLayout=false}}}}}}if(this.layoutComb&&this.layoutParams&&!this.graphType.match(/Scatter/)){this.vM();var l=this.tx(this.varIndices);var f=this.tx(this.smpIndices);for(var U=0;U<this.data.l.comp.length;U++){var O=this.layoutParams[U];var K=O.startingVarIndices;var L=O.startingSmpIndices;var X=O.startingGrpIndices;var Z=[];if(K){for(var T=0;T<K.length;T++){if(l.hasOwnProperty(K[T])){Z.push(K[T])}}O.varIndices=Z}Z=[];if(this.isGroupedData){if(X){for(var T=0;T<X.length;T++){if(f.hasOwnProperty(X[T])){Z.push(X[T])}}O.grpIndices=Z}}else{if(L){for(var T=0;T<L.length;T++){if(f.hasOwnProperty(L[T])){Z.push(L[T])}}O.smpIndices=Z}}}}};this.sn=function(f,b){var e=this;var d=function(g){if(b!=null&&e[g].comp.length>0){e[g].comp.splice(b,1);e[g].op.splice(b,1);e[g].value.splice(b,1);e[g].cases.splice(b,1);e[g].type.splice(b,1)}else{e[g].comp=[];e[g].op=[];e[g].value=[];e[g].cases=[];e[g].type=[]}};var a=f?[f]:["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"];this.hiddenLegends={};for(var c=0;c<a.length;c++){d(a[c])}this.fZ();delete this.data.tree};this.vK=function(b,c,a,d){if(this.graphType=="Network"){return b?this.hiddenNodes[b]:c?this.hiddenEdges[c]:a?this.hiddenLegends[a]:false}else{if(this.graphType=="Boxplot"&&!a){if(!this.showBoxplotOriginalData){if(this.hiddenGrps){return this.hiddenVars[b]||this.hiddenGrps[c]}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}else{if(c!=null){if(this.hiddenGrps){return this.hiddenVars[b]||(d?this.hiddenGrps[c]:this.hiddenSmps[c])}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}else{return this.hiddenVars[b]}}}else{if(this.graphType=="Gantt"){return a?this.hiddenLegends[a]:this.hiddenSmps[c]}else{if(this.graphType=="Dotplot"){return a?this.hiddenLegends[a]:(this.hiddenVars[b]||this.hiddenSmps[c])}else{if(this.graphType=="Bar"&&this.is3DPlot){return a?this.hiddenLegends[a]:this.hiddenVars[b]}else{if(a){return this.hiddenLegends[a]}else{if(this.isGroupedData&&this.hiddenGrps){return this.hiddenVars[b]||this.hiddenGrps[c]}else{return this.hiddenVars[b]||this.hiddenSmps[c]}}}}}}}}};CanvasXpress.prototype.initClusterUtils=function(){this.k5=function(){if(this.smpDendrogramNewick&&(!this.toDoFilter||!this.toDoFilter.hasOwnProperty("sample"))){this.smpDendrogram={};this.U0(this.smpDendrogramNewick,"smpDendrogram")}if(this.varDendrogramNewick&&(!this.toDoFilter||!this.toDoFilter.hasOwnProperty("variable"))){this.varDendrogram={};this.U0(this.varDendrogramNewick,"varDendrogram")}};this.U0=function(a,d){var k=this;var w=0;var b=[];var t={};var c=0;var g=0;var u=0;var p=0;var j=[];var z=0;var A=0;this[d+"NodeId"]=0;var q=a.split(/\s*(;|\(|\)|,|:)\s*/);var l=function(D){var x=[];for(var C=0;C<D.length;C++){x.push(D[C].mid)}return k.Du(x)};var o=function(C){if(C.children){C.depth=g++;z=Math.max(z,C.depth);for(var x=0;x<C.children.length;x++){o(C.children[x]);if(C.children[x].children){C.children[x].mid=l(C.children[x].children)}}g--;p++}else{C.depth=g;u++}};var e=function(C){if(C.children){for(var x=0;x<C.children.length;x++){e(C.children[x]);if(C.children[x].children){C.children[x].len=1+z-C.children[x].depth}}}else{C.len=1+z-C.depth}};for(var y=0;y<q.length;y++){if(!w){var h=q[y];switch(h){case"(":var B={};t.children=[B];b.push(t);t=B;break;case",":if(b.length>0){var B={};b[b.length-1].children.push(B);t=B}else{w++}break;case")":t=b.pop();t.nodeId=this[d+"NodeId"]++;break;case":":break;default:var m=q[y-1];if(m==")"||m=="("||m==","){t.name=h;if(h&&!t.children){var s=d=="smpDendrogram"?this.uL(h):this.qv(h);if(s==-1){s=parseInt(h);t.name=d=="smpDendrogram"?this.data.y.smps[s]:this.data.y.vars[s];t.idx=s}else{t.idx=s}j.push(t.idx);t.ord=c++;t.mid=t.ord}}else{if(m==":"){t.height=parseFloat(h);A++}}}}else{if(w<3){this.U0("("+a+")",d);return}else{alert(d+"is not in a valid Newick format");this[d]=false;if(d=="varDendrogram"){this.varDendrogramNewick=false}else{this.smpDendrogramNewick=false}return}}}o(t);e(t);t.max=z+1;t.leafs=u;t.useHeight=A==p;t.mid=l(t.children);t.axis=d;this[d]=t;var r={labl:d=="varDendrogram"?"variable":"sample",show:d=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram",data:d=="varDendrogram"?"vars":"smps",indx:d=="varDendrogram"?"varIndices":"smpIndices",strt:d=="varDendrogram"?"varIndicesStart":this.isGroupedData?"grpIndicesStart":"smpIndicesStart"};if(this[r.show]){var f;if(this[r.strt]<0){if(u!=this.data.y[r.data].length){f="Dude! The length of the "+r.labl+" nodes in the dendrogram ("+u+") is different to that one in the data ("+this.data.y[r.data].length+"). This ain't gonna work!";this.T4(f);if(this.verbose){this.oC(100,100,f,3000)}this[r.show]=false}else{if(u!=this[r.indx].length){f="Ooops! Cannot show dendrogram with "+u+" nodes when only "+this[r.indx].length+" "+r.labl+" are visible.";this.T4(f);if(this.verbose){this.oC(100,100,f,3000)}this[r.show]=false}else{this[r.indx]=j}}}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}else{if(this[r.strt]<0){this[r.indx]=j}else{var v=this[r.strt]+this[r.indx].length;this[r.indx]=[];for(var y=this[r.strt];y<v;y++){this[r.indx].push(j[y])}}}};this.q5=function(b){var d="";if(b.children){var a=[];for(var c=0;c<b.children.length;c++){a.push(this.q5(b.children[c]))}if(a.length>0){d="("+a.join(",")+")"}}else{d=b.idx}if(b.height){d+=":"+this.aL("%.1f",b.height)}return d};this.LI=function(b,a){b=this.cM(b,true);a=this.cM(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=Math.pow(b[c]-a[c],2)}e=Math.sqrt(e)}return e};this.kp=function(b,a){b=this.cM(b,true);a=this.cM(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=Math.abs(b[c]-a[c])}}return e};this.F8=function(b,a){b=this.cM(b,true);a=this.cM(a,true);var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e=Math.max(e,Math.abs(b[c]-a[c]))}}return e};this.nT=function(f,c){var e=Number.POSITIVE_INFINITY;var a=0;for(var d=0;d<c.length;d++){var b=this[this.distance+"Distance"](f,c[d]);if(b<e){e=b;a=d}}return a};this.X3=function(c,b){c=this.cM(c,true);b=this.cM(b,true);var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.rw=function(b,a){if(this.pe(b)&&this.pe(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.pe(b[c])&&this.pe(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.Z3=function(b,a){b=this.cM(b,true);a=this.cM(a,true);var d=0;if(b.length==a.length){for(var c=0;c<b.length;c++){d+=b[c]*a[c]}}return d};this.lP=function(a,c){a=this.cM(a,true);for(var b=0;b<a.length;b++){a[b]*=c}return a};this.n2=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.ao=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a!=null){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.hY=function(c){var b=this;var a=c.slice(0);a.sort(function(){return(Math.round(b.mc())-0.5)});return a.slice(0,this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters)};this.gq=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(this.mc()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.rw(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.so=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.yJ=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.uL(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.qv(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.c1=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.so(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.so(e)}g=a[c]}h[c][b]=g}}}return h};this.ym=function(){var n=function(){var i=a[s][0].id;var d=a[r][0].id;if(i<0&&d>=0){return true}else{if(i<0&&d<0){return d>i}else{if(i>=0&&d>=0){return i>d}else{return false}}}};var h;var z=this.c1();var v=this.yJ();var o=[];var e=[];var B=[];var a=[];if(!this.meta.tree){this.meta.tree={}}var u=this.meta.tree;u[this.clusterAxis]=[];for(var y=0;y<z.length;y++){o[y]=[]}o[0][0]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length-1;y++){for(var x=y+1;x<z.length;x++){o[x][x]=Number.POSITIVE_INFINITY;o[y][x]=this[this.distance+"Distance"](z[y],z[x]);o[x][y]=o[y][x]}}for(var y=0;y<z.length;y++){e[y]=0;for(var x=0;x<z.length;x++){if(o[y][e[y]]>o[y][x]){e[y]=x}}}for(var y=0;y<z.length;y++){a[y]=[];a[y][0]=this.ao(v[y],null,null,0,z[y]);B[y]=1}var b=-1;for(var q=0;q<z.length-1;q++){var s=0;for(var y=0;y<z.length;y++){if(o[y][e[y]]<o[s][e[s]]){s=y}}var r=e[s];if(n()){var c=r;r=s;s=c}var f=a[s][0];var t=a[r][0];var g=this.n2(f.size,f.centroid,t.size,t.centroid);var A=this.ao(b,f,t,o[s][r],g);a[s].splice(0,0,A);for(var x=0;x<z.length;x++){if(this.linkage=="single"){if(o[s][x]>o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="complete"){if(o[s][x]<o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="average"){o[x][s]=o[s][x]=((B[s]*o[s][x])+(B[r]*o[r][x]))/(B[s]+B[r])}}}}B[s]+=B[r];o[s][s]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length;y++){o[y][r]=o[r][y]=Number.POSITIVE_INFINITY}for(var x=0;x<z.length;x++){if(e[x]==r){e[x]=s}}for(var x=0;x<z.length;x++){for(var w=0;w<z.length;w++){if(o[w][x]<o[w][e[w]]){e[w]=x}}}h=A;u[this.clusterAxis].push([f.id,t.id,h.dist]);b--}return this.on(h,true)};this.AR=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.on=function(k,g,j){var h="";var e="";var f=false;if(this.AR(k)){f=true;if(isNaN(k.id)){h=this.clusterAxis=="variables"?this.qv(k.id):this.uL(k.id)}else{h=k.id}}else{var b;var c=this.on(k.left,g,true);var a=this.on(k.right,g,false);if(k.mid){for(var d=0;d<k.mid.length;d++){if(g&&k.mid[d].dist){e+=","+k.mid[d].id+":"+k.mid[d].dist}else{e+=","+k.mid[d].id}e+=k.mid[d].id}}h="("+c+e+","+a+")"}if(g&&!f){h+=":"+this.aL("%.1f",k.dist)}return h};this.AS=function(){var p=this.c1();var q=this.hY(p);var m=new Array(p.length);var b=this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters;var n=new Array(b);var s=0;var v=true;while(v){for(var e=0;e<p.length;e++){m[e]=this.nT(p[e],q)}v=false;for(var c=0;c<b;c++){var l=[];for(var e=0;e<m.length;e++){if(m[e]==c){l.push(p[e])}}if(!l.length){continue}var o=q[c];var u=new Array(o.length);for(var f=0;f<o.length;f++){var h=0;for(var e=0;e<l.length;e++){if(!isNaN(l[e][f])){h+=l[e][f]}}u[f]=h/l.length;if(u[f]!=o[f]){v=true}}q[c]=u;n[c]=l}s++;if(s>this.maxIterations){v=false}}var r=[];for(var e=0;e<b;e++){r[e]={distance:this[this.distance+"Distance"](q[0],q[e]),assign:e}}r=r.sort(function(g,d){return g.distance-d.distance});var a={};for(var e=0;e<r.length;e++){a[r[e].assign]=e}for(var e=0;e<m.length;e++){var t=a[m[e]]+1;if(t>9){m[e]="K"+t}else{m[e]="K-0"+t}}return m}};CanvasXpress.prototype.initSortUtils=function(){this.vX=function(h){if(this.Q7()){return}var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.mT(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.aS()}this.j8({func:"sortNetworkIndices",par:[h]})};this.oP=function(){if(this.isOncoprint){if(this.meta.data.z){var c=["Altered-Vars"];for(var b in this.meta.data.z){if(b.match(/delet/i)){c.unshift(b);break}}for(var b in this.meta.data.z){if(b.match(/ampli/i)){c.unshift(b);break}}this.AW("vars","desc",c)}if(this.meta.data.x){var c=["Altered-Smps"];for(var b in this.meta.data.x){if(b.match(/delet/i)){c.unshift(b);break}}for(var b in this.meta.data.x){if(b.match(/ampli/i)){c.unshift(b);break}}this.AW("smps","desc",c)}}};this.AW=function(d,l,b,c,p,q){var e=this.sortCaseSensitive;var s=Number.MAX_VALUE*-1;var w=function(m,i){if(m==null){m=""}if(i==null){i=""}if(e){return(m.toString()).localeCompare(i.toString())}else{return(m.toString().toLowerCase()).localeCompare(i.toString().toLowerCase())}};var g=function(m,i){if(m==null){m=s}if(i==null){i=s}return m-i};var j="";var n;var a=[];var r=this.meta.data;var y=[];for(var u=0;u<this.varIndices.length;u++){y.push(this.varIndices[u])}y.sort(function(m,i){return m-i});var x=[];for(var u=0;u<this.smpIndices.length;u++){x.push(this.smpIndices[u])}x.sort(function(m,i){return m-i});var v=[];if(this.grpIndices&&this.grpIndices.length){for(var u=0;u<this.grpIndices.length;u++){v.push(this.grpIndices[u])}}else{if(this.isGroupedData&&this.data.w){v=this.data.w.grpIdxs}}if(b){b=this.j1(b)}if(c){c=this.j1(c)}if(p){p=this.j1(p)}if(!l){l=this.sortDir}if(b&&d=="vars"){for(var u=0;u<b.length;u++){var f=b[u];a.push(this.ZD(this.data.z[f]));j+=r.z[f].type=="Numeric"?"N":"S"}n="varIndices"}else{if(b&&d=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.AW(d,l,b,c,p,q);this.isGroupedData=true}for(var u=0;u<b.length;u++){var f=b[u];a.push(this.ZD(this.isGroupedData?this.data.w.factors[f]:this.data.x[f]));j+=r.x[f].type=="Numeric"?"N":"S"}n=this.isGroupedData?"grpIndices":"smpIndices"}else{if(q){if(q=="varIndex"||q=="smpIndex"||q=="grpIndex"){k=q=="grpIndex"?v:q=="smpIndex"?x:y;n=q=="grpIndex"?"grpIndices":q=="smpIndex"?"smpIndices":"varIndices";if(this.sortDir=="ascending"){k=k.sort(function(m,i){return m-i})}else{k=k.sort(function(m,i){return i-m})}this[n]=k;if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n]=this.sortDir=="ascending"?this.layoutParams[u][n].sort(function(m,i){return m-i}):this.layoutParams[u][n].sort(function(m,i){return i-m});this.layoutParams[u].dragged=true}}j="I"}else{var u=c?parseInt(this.qv(c[0])):parseInt(this.uL(p[0]));a.push(this.ZD(this.data.y[q][u]));j="N"}}else{if(c){for(var u=0;u<c.length;u++){a.push(this.zB(c[u]-1,y,q));j+="N"}n="varIndices"}else{if(p){if(this.isGroupedData){this.isGroupedData=false;this.AW(d,l,b,c,p,q);this.isGroupedData=true}var z=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:q?this.data.y[q]:this.data.y.data;for(var u=0;u<p.length;u++){var h=p[u]-1;if(!z[h]){h=0}a.push(this.ZD(z[h]));j+="N"}n=this.isGroupedData?"grpIndices":"smpIndices"}else{if(this.isGroupedData){this.isGroupedData=false;this.AW(d,l,b,c,p,q);this.isGroupedData=true}a.push(this.ZD(this.isGroupedData?this.data.w.smps:d=="vars"?this.data.y.vars:this.data.y.smps));n=this.isGroupedData?"grpIndices":d=="vars"?"varIndices":"smpIndices";j="S"}}}}}var k=n=="grpIndices"?v:n=="smpIndices"?x:y;switch(j){case"I":break;case"S":k.sort(function(m,i){return w(a[0][m],a[0][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return w(a[0][m],a[0][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"N":k.sort(function(m,i){return g(a[0][m],a[0][i])});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])});this.layoutParams[u].dragged=true}}break;case"SS":k.sort(function(m,i){return w(a[0][m],a[0][i])||w(a[1][m],a[1][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return w(a[0][m],a[0][i])||w(a[1][m],a[1][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"SN":k.sort(function(m,i){return w(a[0][m],a[0][i])||g(a[1][m],a[1][i])});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return w(a[0][m],a[0][i])||g(a[1][m],a[1][i])});this.layoutParams[u].dragged=true}}break;case"NN":k.sort(function(m,i){return g(a[0][m],a[0][i])||g(a[1][m],a[1][i])});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])||g(a[1][m],a[1][i])});this.layoutParams[u].dragged=true}}break;case"NS":k.sort(function(m,i){return g(a[0][m],a[0][i])||w(a[1][m],a[1][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])||w(a[1][m],a[1][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"SSS":k.sort(function(m,i){return w(a[0][m],a[0][i])||w(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return w(a[0][m],a[0][i])||w(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"SSN":k.sort(function(m,i){return w(a[0][m],a[0][i])||w(a[1][m],a[1][i])||g(a[2][m],a[2][i])});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){w(a[0][m],a[0][i])||w(a[1][m],a[1][i])||g(a[2][m],a[2][i])});this.layoutParams[u].dragged=true}}break;case"SNS":k.sort(function(m,i){return w(a[0][m],a[0][i])||g(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return w(a[0][m],a[0][i])||g(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"NSS":k.sort(function(m,i){return g(a[0][m],a[0][i])||w(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])||w(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"NNN":k.sort(function(m,i){return g(a[0][m],a[0][i])||g(a[1][m],a[1][i])||g(a[2][m],a[2][i])});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])||g(a[1][m],a[1][i])||g(a[2][m],a[2][i])});this.layoutParams[u].dragged=true}}break;case"NNS":k.sort(function(m,i){return g(a[0][m],a[0][i])||g(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])||g(a[1][m],a[1][i])||w(a[2][m],a[2][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"NSN":k.sort(function(m,i){return g(a[0][m],a[0][i])||w(a[1][m],a[1][i])||g(a[2][m],a[2][i])||(m-i)});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return g(a[0][m],a[0][i])||w(a[1][m],a[1][i])||g(a[2][m],a[2][i])||(m-i)});this.layoutParams[u].dragged=true}}break;case"SNN":k.sort(function(m,i){return w(a[0][m],a[0][i])||g(a[1][m],a[1][i])||g(a[2][m],a[2][i])});if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].sort(function(m,i){return w(a[0][m],a[0][i])||g(a[1][m],a[1][i])||g(a[2][m],a[2][i])});this.layoutParams[u].dragged=true}}break}if(l!="ascending"&&l!="asc"&&j!="I"){k.reverse();if(this.layoutValid&&this.layoutParams){for(var u=0;u<this.layoutParams.length;u++){this.layoutParams[u][n].reverse();this.layoutParams[u].dragged=true}}}this.sorting=[d,l,b,c,p,q];this[n]=k;if(this.isGroupedData&&n=="grpIndices"&&this.data.w&&this[n].length==this.data.w.grpIdxs.length){this.data.w.grpIdxs=this.ZD(k)}};this.wj=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.GU=function(a){return !this.mT(a)};this.pa=function(b){var a=Object.keys(b);if(this.GU(a)){if(this.sortCaseSensitive){return a.sort()}else{return a.sort(function(d,c){return d.toLowerCase().localeCompare(c.toLowerCase())})}}else{return a.sort(function(d,c){return d-c})}};this.P5=function(d){var c={};var a;for(var b=0;b<d.length;b++){if(d[b].match(/^\d+\-\d+/)){a=d[b].split(/\-/);c[b]=Number(a[0])}else{if(d[b].match(/^\>\d+/)){a=d[b].split(/\>/);c[b]=Number(a[1])+1e-8}else{if(d[b].match(/^\<\d+/)){a=d[b].split(/\</);c[b]=Number(a[1])-1e-8}else{if(d[b].match(/^\d+/)){a=d[b];c[b]=a}else{return d.sort(function(f,e){if(f===e){return 0}if(f==="null"){return 1}if(e==="null"){return -1}return f<e?-1:1})}}}}}d.sort(function(f,e){c[f]-c[e]});return d};this.rf=function(){delete this.sorting};this.Vi=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n};this.a3=function(){var c={y:{vars:[],smps:[],data:[]}};var g=[];var h=[];var f=false;var a=this.data.l?true:false;for(var d=0;d<this.varIndices.length;d++){var k=this.varIndices[d];c.y.vars[d]=this.data.y.vars[k];g.push(d)}for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.y.smps[b]=this.data.y.smps[e];h.push(b)}for(var d=0;d<this.varIndices.length;d++){var k=this.varIndices[d];c.y.data[d]=[];for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.y.data[d][b]=this.data.y.data[k][e]}}if(this.data.x){c.x={};for(var d in this.data.x){c.x[d]=[];for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.x[d][b]=this.data.x[d][e]}}}if(this.data.z){c.z={};for(var d in this.data.z){c.z[d]=[];for(var b=0;b<this.varIndices.length;b++){var e=this.varIndices[b];c.z[d][b]=this.data.z[d][e]}}}else{if(c.y.vars.length!=this.data.y.vars.length){c.z={};for(var d=0;d<this.data.y.vars.length;d++){if(!c.y.vars.includes(this.data.y.vars[d])){c.z[this.data.y.vars[d]]=[];for(var b=0;b<this.smpIndices.length;b++){var e=this.smpIndices[b];c.z[this.data.y.vars[d]][b]=this.data.y.data[d][e]}}}f="z"}}this.data=c;this.varIndices=g;this.smpIndices=h;this.startingVarIndices=g;this.startingSmpIndices=h;if(f){this.zN(f)}if(this.isGroupedData){this.isGroupedData=false;this.rR(this.groupingFactors,false,false,false,true)}if(this.segregateVariablesBy.length+this.segregateSamplesBy.length>0){this.H7(this.segregateVariablesBy,this.segregateSamplesBy)}}};CanvasXpress.prototype.initNumeric=function(){this.xS=function(s,m){var M=function(S){var U=this.length,T;for(T=0;T<U;++T){if(this[T]===S){return T}}return -1};var p=(Array.prototype.indexOf)?Array.prototype.indexOf:M;var a=function a(S){var V,U;function T(W){var X=[];while(typeof W==="object"){X.push(W.length);W=W[0]}return X}if(typeof S==="object"){V=S[0];if(typeof V==="object"){U=V[0];if(typeof U==="object"){return T(S)}return[S.length,V.length]}return[S.length]}return[]};var D=function(W,T,S){if(typeof S==="undefined"){S=0}var X=W[S],U=Array(X),V;if(S===W.length-1){for(V=X-2;V>=0;V-=2){U[V+1]=T;U[V]=T}if(V===-1){U[0]=T}return U}for(V=X-1;V>=0;V--){U[V]=D(W,T,S+1)}return U};var R=function(Z,Y){var S=function(ap,ao){var aj,ah,af,ad,ac,ab,al,an,ak,ai,ag,am,aq,ae;ad=ap.length;ac=ao.length;ab=ao[0].length;al=Array(ad);for(aj=ad-1;aj>=0;aj--){an=Array(ab);ak=ap[aj];for(af=ab-1;af>=0;af--){ai=ak[ac-1]*ao[ac-1][af];for(ah=ac-2;ah>=1;ah-=2){ag=ah-1;ai+=ak[ah]*ao[ah][af]+ak[ag]*ao[ag][af]}if(ah===0){ai+=ak[0]*ao[0][af]}an[af]=ai}al[aj]=an}return al};var V=function(ac,ad,ab){var af=ac.length,ae;for(ae=af-1;ae>0;--ae){ab[ae]=ac[ae][ad];--ae;ab[ae]=ac[ae][ad]}if(ae===0){ab[0]=ac[0][ad]}};var W=function(am,al){var an=V,ab=al.length,ao=Array(ab);var ae=am.length,ad=al[0].length,ac=new Array(ae),aj;var ag=aa;var ai,ah,af,ak;--ab;--ae;for(ai=ae;ai!==-1;--ai){ac[ai]=Array(ad)}--ad;for(ai=ad;ai!==-1;--ai){an(al,ai,ao);for(ah=ae;ah!==-1;--ah){ak=0;aj=am[ah];ac[ah][ai]=ag(aj,ao)}}return ac};var T=function(ab,ag){var af=ab.length,ae=ag.length,ad;var ac=Array(af);for(ad=af-1;ad>=0;ad--){ac[ad]=aa(ab[ad],ag)}return ac};var U=function(ai,ah){var aq,ap,ao,al,ak,aj,aw,au,at,af,an,ag,ad,ar,ae,ac,ab,am,av;al=ai.length;ak=ah[0].length;aw=Array(ak);for(ao=ak-1;ao>=0;ao--){af=ai[al-1]*ah[al-1][ao];for(ap=al-2;ap>=1;ap-=2){an=ap-1;af+=ai[ap]*ah[ap][ao]+ai[an]*ah[an][ao]}if(ap===0){af+=ai[0]*ah[0][ao]}aw[ao]=af}return aw};var aa=function(ab,ag){var ad,af=ab.length,ae,ac=ab[af-1]*ag[af-1];for(ad=af-2;ad>=1;ad-=2){ae=ad-1;ac+=ab[ad]*ag[ad]+ab[ae]*ag[ae]}if(ad===0){ac+=ab[0]*ag[0]}return ac};var X=a;switch(X(Z).length*1000+X(Y).length){case 2002:if(Y.length<10){return S(Z,Y)}else{return W(Z,Y)}case 2001:return T(Z,Y);case 1002:return U(Z,Y);case 1001:return aa(Z,Y);case 1000:return mulVS(Z,Y);case 1:return mulSV(Z,Y);case 0:return Z*Y;default:throw new Error("dot only works on vectors and matrices")}};var k=function(X){var V,W,U,Y=X.length,S=Array(Y),T;for(V=Y-1;V>=0;V--){T=Array(Y);W=V+2;for(U=Y-1;U>=W;U-=2){T[U]=0;T[U-1]=0}if(U>V){T[U]=0}T[V]=X[V];for(U=V-1;U>=1;U-=2){T[U]=0;T[U-1]=0}if(U===0){T[0]=0}S[V]=T}return S};var C=function(S){var V=Math.min(S.length,S[0].length),U,T=Array(V);for(U=V-1;U>=1;--U){T[U]=S[U][U];--U;T[U]=S[U][U]}if(U===0){T[0]=S[0][0]}return T};var G=function(S){return k(D([S],1))};var I=function(S,Y,V,T,W){if(T===V.length-1){W(S,Y);return}var U,X=V[T];for(U=X-1;U>=0;U--){I(typeof S==="object"?S[U]:S,typeof Y==="object"?Y[U]:Y,V,T+1,W)}};var L=function(S,Z,W,T,X){if(T===W.length-1){return X(S,Z)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;--V){U[V]=L(typeof S==="object"?S[V]:S,typeof Z==="object"?Z[V]:Z,W,T+1,X)}return U};var A=function(S,V,T,W){if(T===V.length-1){W(S);return}var U,X=V[T];for(U=X-1;U>=0;U--){A(S[U],V,T+1,W)}};var H=function(S,W,T,X){if(T===W.length-1){return X(S)}var V,Y=W[T],U=Array(Y);for(V=Y-1;V>=0;V--){U[V]=H(S[V],W,T+1,X)}return U};var d=function(){var X=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag[af]}return ae};var Y=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac+ag[af]}return ae};var Z=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]+ag}return ae};var S=arguments.length,V,ab=arguments[0],aa;var T=X,W=Z,U=Y;for(V=1;V!==S;++V){aa=arguments[V];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,W)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab+=aa}}}return ab};var x=function(){var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag[af]}return ae};var T=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac-ag[af]}return ae};var V=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]-ag}return ae};var U=arguments.length,Y,ab=arguments[0],aa;var W=S,Z=V,X=T;for(Y=1;Y!==U;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,W)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,X)}else{ab-=aa}}}return ab};var c=function(){var Z=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag[af]}return ae};var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac*ag[af]}return ae};var ab=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]*ag}return ae};var S=arguments.length,V,Y=arguments[0],X;var T=Z,W=ab,U=aa;for(V=1;V!==S;++V){X=arguments[V];if(typeof Y==="object"){if(typeof X==="object"){Y=L(Y,X,a(Y),0,T)}else{Y=L(Y,X,a(Y),0,W)}}else{if(typeof X==="object"){Y=L(Y,X,a(X),0,U)}else{Y*=X}}}return Y};var K=function(){var aa=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag[af]}return ae};var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac/ag[af]}return ae};var S=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]/ag}return ae};var T=arguments.length,W,Z=arguments[0],Y;var U=aa,X=S,V=ab;for(W=1;W!==T;++W){Y=arguments[W];if(typeof Z==="object"){if(typeof Y==="object"){Z=L(Z,Y,a(Z),0,U)}else{Z=L(Z,Y,a(Z),0,X)}}else{if(typeof Y==="object"){Z=L(Z,Y,a(Y),0,V)}else{Z/=Y}}}return Z};var h=function(){var ab=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag[af]}return ae};var S=function(ac,ag){var ad=ag.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac!==ag[af]}return ae};var T=function(ac,ag){var ad=ac.length;var af,ae=Array(ad);for(af=ad-1;af!==-1;--af){ae[af]=ac[af]!==ag}return ae};var U=arguments.length,X,aa=arguments[0],Z;var V=ab,Y=T,W=S;for(X=1;X!==U;++X){Z=arguments[X];if(typeof aa==="object"){if(typeof Z==="object"){aa=L(aa,Z,a(aa),0,V)}else{aa=L(aa,Z,a(aa),0,Y)}}else{if(typeof Z==="object"){aa=L(aa,Z,a(Z),0,W)}else{aa=aa!==Z}}}return aa};var u=function(){var T=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var U=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var X=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.atan2;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,Y,ab=arguments[0],aa;var V=T,Z=X,W=U;for(Y=1;Y!==S;++Y){aa=arguments[Y];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,V)}else{ab=L(ab,aa,a(ab),0,Z)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,W)}else{ab=u(ab,aa)}}}return ab};var w=function(){var X=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah[ag])}return af};var Y=function(ad,ah){var ae=ah.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad,ah[ag])}return af};var aa=function(ad,ah){var ae=ad.length;var ag,af=Array(ae);var ac=Math.max;for(ag=ae-1;ag!==-1;--ag){af[ag]=ac(ad[ag],ah)}return af};var S=arguments.length,V,ab=arguments[0],Z;var T=X,W=aa,U=Y;for(V=1;V!==S;++V){Z=arguments[V];if(typeof ab==="object"){if(typeof Z==="object"){ab=L(ab,Z,a(ab),0,T)}else{ab=L(ab,Z,a(ab),0,W)}}else{if(typeof Z==="object"){ab=L(ab,Z,a(Z),0,U)}else{ab=w(ab,Z)}}}return ab};var O=function(){var V=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah[ag])}return ae};var X=function(ac,ah){var ad=ah.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac,ah[ag])}return ae};var Z=function(ac,ah){var ad=ac.length;var ag,ae=Array(ad);var af=Math.min;for(ag=ad-1;ag!==-1;--ag){ae[ag]=af(ac[ag],ah)}return ae};var S=arguments.length,W,ab=arguments[0],aa;var T=V,Y=Z,U=X;for(W=1;W!==S;++W){aa=arguments[W];if(typeof ab==="object"){if(typeof aa==="object"){ab=L(ab,aa,a(ab),0,T)}else{ab=L(ab,aa,a(ab),0,Y)}}else{if(typeof aa==="object"){ab=L(ab,aa,a(aa),0,U)}else{ab=O(ab,aa)}}}return ab};var q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=-(V[aa])}return Z};if(typeof S!=="object"){return -(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var v=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);for(aa=Y-1;aa!==-1;--aa){Z[aa]=(V[aa])}return Z};if(typeof S!=="object"){return(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var y=function(S){var X=function(Y){var Z=Y.length;var ab,aa=Array(Z);var V=Math.abs;for(ab=Z-1;ab!==-1;--ab){aa[ab]=V(Y[ab])}return aa};if(typeof S!=="object"){return y(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var f=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.cos;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return f(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var Q=function(S){var U=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.exp;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return Q(S)}var W;var T=U;var X=a(S);return H(S,X,0,T)};var o=function(T){var S=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.log;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof T!=="object"){return o(T)}var W;var U=S;var X=a(T);return H(T,X,0,U)};var r=function(S){var X=function(V){var Z=V.length;var ab,aa=Array(Z);var Y=Math.sin;for(ab=Z-1;ab!==-1;--ab){aa[ab]=Y(V[ab])}return aa};if(typeof S!=="object"){return r(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var F=function(S){var X=function(V){var Y=V.length;var aa,Z=Array(Y);var ab=Math.sqrt;for(aa=Y-1;aa!==-1;--aa){Z[aa]=ab(V[aa])}return Z};if(typeof S!=="object"){return F(S)}var U;var T=X;var W=a(S);return H(S,W,0,T)};var J=function(S,Y,V){var X=function(aa){var ae=aa.length;var ad,ac;var ab=0;for(ad=ae-1;ad!==-1;--ad){ac=aa[ad];ab+=ac*ac}return ab};var U=0;if(typeof S!=="object"){T=S;U+=T*T;return U}if(typeof Y==="undefined"){Y=a(S)}if(typeof V==="undefined"){V=0}if(V===Y.length-1){return X(S)}var T;var Z=S.length,W;for(W=Z-1;W!==-1;--W){T=arguments.callee(S[W]);U+=T*T}return U};var t=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=T[W];X[Y-1]=V[W];--W;X=Z[W];X[Y]=T[W];X[Y-1]=V[W]}if(W===0){X=Z[0];X[Y]=T[0];X[Y-1]=V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=V[W];--W;Z[W][0]=V[W]}if(W===0){Z[0][0]=V[0]}}return Z};var n=function(aa){var Y,W,U=aa.length,S=aa[0].length,Z=Array(S),V,T,X;for(W=0;W<S;W++){Z[W]=Array(U)}for(Y=U-1;Y>=1;Y-=2){T=aa[Y];V=aa[Y-1];for(W=S-1;W>=1;--W){X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W];--W;X=Z[W];X[Y]=-T[W];X[Y-1]=-V[W]}if(W===0){X=Z[0];X[Y]=-T[0];X[Y-1]=-V[0]}}if(Y===0){V=aa[0];for(W=S-1;W>=1;--W){Z[W][0]=-V[W];--W;Z[W][0]=-V[W]}if(W===0){Z[0][0]=-V[0]}}return Z};var l=function(S){return Math.sqrt(J(S))};var j=function(S,W,V){var T=a(S);function U(X,Z){var ab,Y=W[Z],ac=V[Z]-Y,aa=Array(ac);if(Z===T.length-1){for(ab=ac;ab>=0;ab--){aa[ab]=X[ab+Y]}return aa}for(ab=ac;ab>=0;ab--){aa[ab]=U(X[ab+Y],Z+1)}return aa}return U(S,0)};var e=function(S,X,W,V){var T=a(S);function U(Y,ad,aa){var ab,Z=X[aa],ac=W[aa]-Z;if(aa===T.length-1){for(ab=ac;ab>=0;ab--){Y[ab+Z]=ad[ab]}}for(ab=ac;ab>=0;ab--){U(Y[ab+Z],ad[ab],aa+1)}}U(S,V,0);return S};var i=function(T,ab,aa){var W=ab.length,V=aa.length;var Y,X;var S=Array(W),Z,U;for(Y=W-1;Y!==-1;--Y){S[Y]=Array(V);Z=S[Y];U=T[ab[Y]];for(X=V-1;X!==-1;--X){Z[X]=U[aa[X]]}}return S};var B=function(Z,Y){if(typeof Z==="number"||typeof Y==="number"){return c(Z,Y)}var ac=a(Z),aa=a(Y);if(ac.length!==1||aa.length!==1){throw new Error("numeric: tensor product is only defined for vectors")}var U=ac[0],T=aa[0],S=Array(U),ab,W,V,X;for(W=U-1;W>=0;W--){ab=Array(T);X=Z[W];for(V=T-1;V>=3;--V){ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V];--V;ab[V]=X*Y[V]}while(V>=0){ab[V]=X*Y[V];--V}S[W]=ab}return S};var g=function g(S,T){this.x=S;this.y=T};g.prototype={};g.prototype.add=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(d(S.x,T.x),d(S.y,T.y))}return new g(d(S.x,T.x),S.y)}if(T.y){return new g(d(S.x,T.x),T.y)}return new g(d(S.x,T.x))};g.prototype.sub=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(S.x,T.x),x(S.y,T.y))}return new g(x(S.x,T.x),S.y)}if(T.y){return new g(x(S.x,T.x),q(T.y))}return new g(x(S.x,T.x))};g.prototype.mul=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(c(S.x,T.x),c(S.y,T.y)),d(c(S.x,T.y),c(S.y,T.x)))}return new g(c(S.x,T.x),c(S.y,T.x))}if(T.y){return new g(c(S.x,T.x),c(S.x,T.y))}return new g(c(S.x,T.x))};g.prototype.reciprocal=function(){if(this.y){var S=d(c(this.x,this.x),c(this.y,this.y));return new g(K(this.x,S),K(q(this.y),S))}return new g(K(1,this.x))};g.prototype.div=function(S){if(!(S instanceof g)){S=new g(S)}if(S.y){return this.mul(S.reciprocal())}if(this.y){return new g(K(this.x,S.x),K(this.y,S.x))}return new g(K(this.x,S.x))};g.prototype.dot=function(T){var S=this;if(!(T instanceof g)){T=new g(T)}if(S.y){if(T.y){return new g(x(R(S.x,T.x),R(S.y,T.y)),d(R(S.x,T.y),R(S.y,T.x)))}return new g(R(S.x,T.x),R(S.y,T.x))}if(T.y){return new g(R(S.x,T.x),R(S.x,T.y))}return new g(R(S.x,T.x))};g.prototype.transpose=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),T(U))}return new g(T(S))};g.prototype.transjugate=function(){var T=t,S=this.x,U=this.y;if(U){return new g(T(S),n(U))}return new g(T(S))};g.prototype.exp=function(){var S=this;var T=Q(S.x);if(S.y){return new g(c(f(S.y),T),c(r(S.y),T))}return new g(T)};g.prototype.conj=function(){var S=this;if(S.y){return new g(S.x,q(S.y))}return new g(S.x)};g.prototype.neg=function(){var S=this;if(S.y){return new g(q(S.x),q(S.y))}return new g(q(S.x))};g.prototype.sin=function(){var S=this;if(S.y){return S.exp().sub(S.neg().exp()).div(new g(0,2))}return new g(r(S.x))};g.prototype.cos=function(){var S=this;if(S.y){return S.exp().add(S.neg().exp()).div(2)}return new g(f(S.x))};g.prototype.abs=function(){var S=this;if(S.y){return new g(F(d(c(S.x,S.x),c(S.y,S.y))))}return new g(y(S.x))};g.prototype.log=function(){var S=this;if(S.y){var T=new g(u(S.y,S.x)),U=S.abs();return new g(o(U.x),T.x)}return new g(o(S.x))};g.prototype.norm2=function(){var S=this;if(S.y){var T=J;return Math.sqrt(T(S.x)+T(S.y))}return l(S.x)};g.prototype.get=function(V){var S=this.x,X=this.y,T=0,U,W=V.length;if(X){while(T<W){U=V[T];S=S[U];X=X[U];T++}return new g(S,X)}while(T<W){U=V[T];S=S[U];T++}return new g(S)};g.prototype.set=function(U,aa){var Y=this.x,W=this.y,T=0,Z,S=U.length,X=aa.x,V=aa.y;if(S===0){if(V){this.y=V}else{if(W){this.y=undefined}}this.x=Y;return this}if(V){if(W){}else{W=D(a(Y),0);this.y=W}while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;W[Z]=V;return this}if(W){while(T<S-1){Z=U[T];Y=Y[Z];W=W[Z];T++}Z=U[T];Y[Z]=X;if(X instanceof Array){W[Z]=D(a(X),0)}else{W[Z]=0}return this}while(T<S-1){Z=U[T];Y=Y[Z];T++}Z=U[T];Y[Z]=X;return this};g.prototype.getRows=function(W,U){var Z=U-W+1,T;var X=Array(Z),V,S=this.x,Y=this.y;for(T=W;T<=U;T++){X[T-W]=S[T]}if(Y){V=Array(Z);for(T=W;T<=U;T++){V[T-W]=Y[T]}return new g(X,V)}return new g(X)};g.prototype.setRows=function(X,V,T){var U;var Y=this.x,W=this.y,S=T.x,Z=T.y;for(U=X;U<=V;U++){Y[U]=S[U-X]}if(Z){if(!W){W=D(a(Y),0);this.y=W}for(U=X;U<=V;U++){W[U]=Z[U-X]}}else{if(W){for(U=X;U<=V;U++){W[U]=D([S[U-X].length],0)}}}return this};g.prototype.getRow=function(T){var S=this.x,U=this.y;if(U){return new g(S[T],U[T])}return new g(S[T])};g.prototype.setRow=function(U,T){var W=this.x,V=this.y,S=T.x,X=T.y;W[U]=S;if(X){if(!V){V=D(a(W),0);this.y=V}V[U]=X}else{if(V){V=D([S.length],0)}}return this};g.prototype.getBlock=function(W,V){var T=this.x,U=this.y,S=j;if(U){return new g(S(T,W,V),S(U,W,V))}return new g(S(T,W,V))};g.prototype.setBlock=function(Z,Y,U){if(!(U instanceof g)){U=new g(U)}var T=this.x,X=this.y,S=e,W=U.x,V=U.y;if(V){if(!X){this.y=D(a(this),0);X=this.y}S(T,Z,Y,W);S(X,Z,Y,V);return this}S(T,Z,Y,W);if(X){S(X,Z,Y,D(a(W),0))}};g.rep=function(U,T){if(!(T instanceof g)){T=new g(T)}var S=T.x,W=T.y,V=D;if(W){return new g(V(U,S),V(U,W))}return new g(V(U,S))};g.diag=function(T){if(!(T instanceof g)){T=new g(T)}var S=T.x,U=T.y;if(U){return new g(k(S),k(U))}return new g(k(S))};g.eig=function(){if(this.y){throw new Error("eig: not implemented for complex matrices.")}return N(this.x)};g.identity=function(S){return new g(G(S))};g.prototype.getDiag=function(){var S=this.x,T=this.y;if(T){return new g(C(S),C(T))}return new g(C(S))};var P=function(S){var T=v(S);var U=S[0]>=0?1:-1;var V=U*l(S);T[0]+=V;var W=l(T);if(W===0){throw new Error("eig: internal error")}return K(T,W)};var b=function(ac){var ag=a(ac);if(ag.length!==2||ag[0]!==ag[1]){throw new Error("numeric: toUpperHessenberg() only works on square matrices")}var X=ag[0],aa,Z,Y,ad,af,V=v(ac),U,S,ae,T,ab=G(X),W;for(Z=0;Z<X-2;Z++){ad=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){ad[aa-Z-1]=V[aa][Z]}if(l(ad)>0){af=P(ad);U=j(V,[Z+1,Z],[X-1,X-1]);S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){ae=V[aa];T=S[aa-Z-1];for(Y=Z;Y<X;Y++){ae[Y]-=2*T[Y-Z]}}U=j(V,[0,Z+1],[X-1,X-1]);S=B(R(U,af),af);for(aa=0;aa<X;aa++){ae=V[aa];T=S[aa];for(Y=Z+1;Y<X;Y++){ae[Y]-=2*T[Y-Z-1]}}U=Array(X-Z-1);for(aa=Z+1;aa<X;aa++){U[aa-Z-1]=ab[aa]}S=B(af,R(af,U));for(aa=Z+1;aa<X;aa++){W=ab[aa];T=S[aa-Z-1];for(Y=0;Y<X;Y++){W[Y]-=2*T[Y]}}}}return{H:V,Q:ab}};var z=function(af,V){if(typeof V==="undefined"){V=10000}af=v(af);var ah=v(af);var ai=a(af),am=ai[0],ae,ag,av,au,at,ar,X,S,W,aa=G(am),ac,ab,al,ak,aj,aq,ao,an,ap;if(am<3){return{Q:aa,B:[[0,am-1]]}}var aw=2.220446049250313e-16;for(ap=0;ap<V;ap++){for(ao=0;ao<am-1;ao++){if(Math.abs(af[ao+1][ao])<aw*(Math.abs(af[ao][ao])+Math.abs(af[ao+1][ao+1]))){var Z=z(j(af,[0,0],[ao,ao]),V);var Y=z(j(af,[ao+1,ao+1],[am-1,am-1]),V);al=Array(ao+1);for(aq=0;aq<=ao;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=ao;aq++){aa[aq]=ak[aq]}al=Array(am-ao-1);for(aq=ao+1;aq<am;aq++){al[aq-ao-1]=aa[aq]}ak=R(Y.Q,al);for(aq=ao+1;aq<am;aq++){aa[aq]=ak[aq-ao-1]}return{Q:aa,B:Z.B.concat(d(Y.B,ao+1))}}}av=af[am-2][am-2];au=af[am-2][am-1];at=af[am-1][am-2];ar=af[am-1][am-1];S=av+ar;X=(av*ar-au*at);W=j(af,[0,0],[2,2]);if(S*S>=4*X){var U,T;U=0.5*(S+Math.sqrt(S*S-4*X));T=0.5*(S-Math.sqrt(S*S-4*X));W=d(x(R(W,W),c(W,U+T)),k(D([3],U*T)))}else{W=d(x(R(W,W),c(W,S)),k(D([3],X)))}ae=[W[0][0],W[1][0],W[2][0]];ag=P(ae);al=[af[0],af[1],af[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<am;an++){ab[an]-=2*aj[an]}}al=j(af,[0,0],[am-1,2]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=0;an<3;an++){ab[an]-=2*aj[an]}}al=[aa[0],aa[1],aa[2]];ak=B(ag,R(ag,al));for(aq=0;aq<3;aq++){ac=aa[aq];aj=ak[aq];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}var ad;for(ao=0;ao<am-2;ao++){for(an=ao;an<=ao+1;an++){if(Math.abs(af[an+1][an])<aw*(Math.abs(af[an][an])+Math.abs(af[an+1][an+1]))){var Z=z(j(af,[0,0],[an,an]),V);var Y=z(j(af,[an+1,an+1],[am-1,am-1]),V);al=Array(an+1);for(aq=0;aq<=an;aq++){al[aq]=aa[aq]}ak=R(Z.Q,al);for(aq=0;aq<=an;aq++){aa[aq]=ak[aq]}al=Array(am-an-1);for(aq=an+1;aq<am;aq++){al[aq-an-1]=aa[aq]}ak=R(Y.Q,al);for(aq=an+1;aq<am;aq++){aa[aq]=ak[aq-an-1]}return{Q:aa,B:Z.B.concat(d(Y.B,an+1))}}}ad=Math.min(am-1,ao+3);ae=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){ae[aq-ao-1]=af[aq][ao]}ag=P(ae);al=j(af,[ao+1,ao],[ad,am-1]);ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ab=af[aq];aj=ak[aq-ao-1];for(an=ao;an<am;an++){ab[an]-=2*aj[an-ao]}}al=j(af,[0,ao+1],[am-1,ad]);ak=B(R(al,ag),ag);for(aq=0;aq<am;aq++){ab=af[aq];aj=ak[aq];for(an=ao+1;an<=ad;an++){ab[an]-=2*aj[an-ao-1]}}al=Array(ad-ao);for(aq=ao+1;aq<=ad;aq++){al[aq-ao-1]=aa[aq]}ak=B(ag,R(ag,al));for(aq=ao+1;aq<=ad;aq++){ac=aa[aq];aj=ak[aq-ao-1];for(an=0;an<am;an++){ac[an]-=2*aj[an]}}}}throw new Error("numeric: eigenvalue iteration does not converge -- increase maxiter?")};var N=function(ak,W){var T=b(ak);var X=z(T.H,W);var an=ak.length,at,ap,ar=false,ai=X.B,ae=R(X.Q,R(T.H,t(X.Q)));var Z=new g(R(X.Q,T.Q)),ag;var ao=ai.length,aq;var ax,aw,av,au,V,U,S,ad,ac,aj,ah,ab,aa;var ay=Math.sqrt;for(ap=0;ap<ao;ap++){at=ai[ap][0];if(at===ai[ap][1]){}else{aq=at+1;ax=ae[at][at];aw=ae[at][aq];av=ae[aq][at];au=ae[aq][aq];if(aw===0&&av===0){continue}V=-ax-au;U=ax*au-aw*av;S=V*V-4*U;if(S>=0){if(V<0){ad=-0.5*(V-ay(S))}else{ad=-0.5*(V+ay(S))}ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab);aj=(ax-ad)/ab;ah=aw/ab}else{aa=ay(aa);aj=av/aa;ah=(au-ad)/aa}ag=new g([[ah,-aj],[aj,ah]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}else{ad=-0.5*V;ac=0.5*ay(-S);ab=(ax-ad)*(ax-ad)+aw*aw;aa=av*av+(au-ad)*(au-ad);if(ab>aa){ab=ay(ab+ac*ac);aj=(ax-ad)/ab;ah=aw/ab;ad=0;ac/=ab}else{aa=ay(aa+ac*ac);aj=av/aa;ah=(au-ad)/aa;ad=ac/aa;ac=0}ag=new g([[ah,-aj],[aj,ah]],[[ad,ac],[ac,-ad]]);Z.setRows(at,aq,ag.dot(Z.getRows(at,aq)))}}}var Y=Z.dot(ak).dot(Z.transjugate()),an=ak.length,af=g.identity(an);for(aq=0;aq<an;aq++){if(aq>0){for(ap=aq-1;ap>=0;ap--){var al=Y.get([ap,ap]),am=Y.get([aq,aq]);if(h(al.x,am.x)||h(al.y,am.y)){ad=Y.getRow(ap).getBlock([ap],[aq-1]);ac=af.getRow(aq).getBlock([ap],[aq-1]);af.set([aq,ap],(Y.get([ap,aq]).neg().sub(ad.dot(ac))).div(al.sub(am)))}else{af.setRow(aq,af.getRow(ap));continue}}}}for(aq=0;aq<an;aq++){ad=af.getRow(aq);af.setRow(aq,ad.div(ad.norm2()))}af=af.transpose();af=Z.transjugate().dot(af);return{lambda:Y.getDiag(),E:af}};var E=function(ab){var ag=a(ab),ah=Math.abs,V=ag[0],U=ag[1];var T=v(ab),ad,aa;var ac=G(V),S,af;var Z,Y,W,ab;for(Y=0;Y<U;++Y){var X=-1;var ae=-1;for(Z=Y;Z!==V;++Z){W=ah(T[Z][Y]);if(W>ae){X=Z;ae=W}}aa=T[X];T[X]=T[Y];T[Y]=aa;af=ac[X];ac[X]=ac[Y];ac[Y]=af;ab=aa[Y];for(W=Y;W!==U;++W){aa[W]/=ab}for(W=U-1;W!==-1;--W){af[W]/=ab}for(Z=V-1;Z!==-1;--Z){if(Z!==Y){ad=T[Z];S=ac[Z];ab=ad[Y];for(W=Y+1;W!==U;++W){ad[W]-=aa[W]*ab}for(W=U-1;W>0;--W){S[W]-=af[W]*ab;--W;S[W]-=af[W]*ab}if(W===0){S[0]-=af[0]*ab}}}}return ac};switch(s){case"inv":return E(m);case"eig":return N(m)}}};CanvasXpress.prototype.initjLouvain=function(){this.WO=function(){var l=-1;var k=1e-7;var i;var y;var s={};var a;function d(C){var B={};C.forEach(function(E,D){B[E]=true});return Object.keys(B)}function x(D){var C=[];for(var B in D){if(D.hasOwnProperty(B)){C.push(D[B])}}return C}function v(E,C){var B=E._assoc_mat[C]?Object.keys(E._assoc_mat[C]):[];var D=0;B.forEach(function(F,G){var H=E._assoc_mat[C][F]||1;if(C==F){H*=2}D+=H});return D}function f(D,C){if(typeof D._assoc_mat[C]=="undefined"){return[]}var B=Object.keys(D._assoc_mat[C]);return B}function g(D,C,B){return D._assoc_mat[C]?D._assoc_mat[C][B]:undefined}function A(C){var B=0;C.edges.forEach(function(D){B+=D.weight});return B}function c(D,C){e(D,C);var B=D.edges.map(function(E){return E.id1+"_"+E.id2}).indexOf(C.id1+"_"+C.id2);if(B!=-1){D.edges[B].weight=C.weight}else{D.edges.push(C)}}function z(B){var C={};B.forEach(function(E,D){E.weight=E.weight||1;C[E.id1]=C[E.id1]||{};C[E.id1][E.id2]=E.weight;C[E.id2]=C[E.id2]||{};C[E.id2][E.id1]=E.weight});return C}function e(C,B){C._assoc_mat[B.id1]=C._assoc_mat[B.id1]||{};C._assoc_mat[B.id1][B.id2]=B.weight;C._assoc_mat[B.id2]=C._assoc_mat[B.id2]||{};C._assoc_mat[B.id2][B.id1]=B.weight}function t(D){if(D==null||typeof(D)!="object"){return D}var B=D.constructor();for(var C in D){B[C]=t(D[C])}return B}function p(D,B,C){B.nodes_to_com={};B.total_weight=0;B.internals={};B.degrees={};B.gdegrees={};B.loops={};B.total_weight=A(D);if(typeof C=="undefined"){D.nodes.forEach(function(G,E){B.nodes_to_com[G]=E;var F=v(D,G);if(F<0){throw"Bad graph type, use positive weights!"}B.degrees[E]=F;B.gdegrees[G]=F;B.loops[G]=g(D,G,G)||0;B.internals[E]=B.loops[G]})}else{D.nodes.forEach(function(I,G){var E=C[I];B.nodes_to_com[I]=E;var H=v(D,I);B.degrees[E]=(B.degrees[E]||0)+H;B.gdegrees[I]=H;var J=0;var F=f(D,I);F.forEach(function(K,L){var M=D._assoc_mat[I][K];if(M<=0){throw"Bad graph type, use positive weights"}if(C[K]==E){if(K==I){J+=M}else{J+=M/2}}});B.internals[E]=(B.internals[E]||0)+J})}}function o(C){var E=C.total_weight;var B=0;var D=d(x(C.nodes_to_com));D.forEach(function(F,G){var I=C.internals[F]||0;var H=C.degrees[F]||0;if(E>0){B=B+I/E-Math.pow((H/(2*E)),2)}});return B}function m(D,E,B){var C={};var F=f(E,D);F.forEach(function(G,H){if(G!=D){var I=E._assoc_mat[D][G]||1;var J=B.nodes_to_com[G];C[J]=(C[J]||0)+I}});return C}function u(D,C,E,B){B.nodes_to_com[D]=+C;B.degrees[C]=(B.degrees[C]||0)+(B.gdegrees[D]||0);B.internals[C]=(B.internals[C]||0)+E+(B.loops[D]||0)}function r(D,C,E,B){B.degrees[C]=((B.degrees[C]||0)-(B.gdegrees[D]||0));B.internals[C]=((B.internals[C]||0)-E-(B.loops[D]||0));B.nodes_to_com[D]=-1}function j(F){var D=0;var B=t(F);var C={};var E=Object.keys(F);E.forEach(function(H){var I=F[H];var G=typeof C[I]=="undefined"?-1:C[I];if(G==-1){C[I]=D;G=D;D=D+1}B[H]=G});return B}function b(F,B){var D=true,G=0,E=o(B),C=E;while(D&&G!=l){E=C;D=false;G+=1;F.nodes.forEach(function(J,I){var M=B.nodes_to_com[J];var O=(B.gdegrees[J]||0)/(B.total_weight*2);var L=m(J,F,B);r(J,M,(L[M]||0),B);var N=M;var H=0;var K=Object.keys(L);K.forEach(function(P,Q){var R=L[P]-(B.degrees[P]||0)*O;if(R>H){H=R;N=P}});u(J,N,L[N]||0,B);if(N!=M){D=true}});C=o(B);if(C-E<k){break}}}function h(C,G){var B={nodes:[],edges:[],_assoc_mat:{}};var D,F;var E=x(C);B.nodes=B.nodes.concat(d(E));G.edges.forEach(function(I,H){F=I.weight||1;var L=C[I.id1];var J=C[I.id2];D=(g(B,L,J)||0);var K=(D+F);c(B,{source:L,target:J,weight:K})});return B}function w(C,E){var B=t(C[0]);for(var D=1;D<E+1;D++){Object.keys(B).forEach(function(H,G){var I=H;var F=B[H];B[I]=C[D][F]})}return B}function n(J,D){if(J.edges.length==0){var C={};J.nodes.forEach(function(L,K){C[L]=L});return C}var F={};p(s,F,D);var H=o(F);var I=[];b(s,F);var B=o(F);var G=j(F.nodes_to_com);I.push(G);H=B;var E=h(G,s);p(E,F);while(true){b(E,F);B=o(F);if(B-H<k){break}G=j(F.nodes_to_com);I.push(G);H=B;E=h(G,E);p(E,F)}return I}var q=function(){var B={};var C=n(s,a);return w(C,C.length-1)};q.nodes=function(B){if(arguments.length>0){i=B}return q};q.edges=function(C){if(typeof i=="undefined"){throw"Please provide the graph nodes first!"}if(arguments.length>0){y=C;var B=z(C);s={nodes:i,edges:y,_assoc_mat:B}}return q};q.partition_init=function(B){if(arguments.length>0){a=B}return q};return q}};CanvasXpress.prototype.initCola=function(){(function(b){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=b()}else{if(typeof define==="function"&&define.amd){define([],b)}else{var a;if(typeof window!=="undefined"){a=window}else{if(typeof global!=="undefined"){a=global}else{if(typeof self!=="undefined"){a=self}else{a=this}}}a.cola=b()}}})(function(){var c,b,a;return(function(){function d(j,l,h){function k(m,n){if(!l[m]){if(!j[m]){var q="function"==typeof require&&require;if(!n&&q){return q(m,!0)}if(f){return f(m,!0)}var e=new Error("Cannot find module '"+m+"'");throw e.code="MODULE_NOT_FOUND",e}var o=l[m]={exports:{}};j[m][0].call(o.exports,function(i){var p=j[m][1][i];return k(p||i)},o,o.exports,d,j,l,h)}return l[m].exports}for(var f="function"==typeof require&&require,g=0;g<h.length;g++){k(h[g])}return k}return d})()({1:[function(e,f,d){function g(h){for(var i in h){if(!d.hasOwnProperty(i)){d[i]=h[i]}}}Object.defineProperty(d,"__esModule",{value:true});g(e("./src/adaptor"));g(e("./src/d3adaptor"));g(e("./src/descent"));g(e("./src/geom"));g(e("./src/gridrouter"));g(e("./src/handledisconnected"));g(e("./src/layout"));g(e("./src/layout3d"));g(e("./src/linklengths"));g(e("./src/powergraph"));g(e("./src/pqueue"));g(e("./src/rbtree"));g(e("./src/rectangle"));g(e("./src/shortestpaths"));g(e("./src/vpsc"));g(e("./src/batch"))},{"./src/adaptor":2,"./src/batch":3,"./src/d3adaptor":4,"./src/descent":7,"./src/geom":8,"./src/gridrouter":9,"./src/handledisconnected":10,"./src/layout":11,"./src/layout3d":12,"./src/linklengths":13,"./src/powergraph":14,"./src/pqueue":15,"./src/rbtree":16,"./src/rectangle":17,"./src/shortestpaths":18,"./src/vpsc":19}],2:[function(f,g,e){var h=(this&&this.__extends)||(function(){var k=function(m,l){k=Object.setPrototypeOf||({__proto__:[]} instanceof Array&&function(o,n){o.__proto__=n})||function(q,n){for(var o in n){if(n.hasOwnProperty(o)){q[o]=n[o]}}};return k(m,l)};return function(n,l){k(n,l);function m(){this.constructor=n}n.prototype=l===null?Object.create(l):(m.prototype=l.prototype,new m())}})();Object.defineProperty(e,"__esModule",{value:true});var i=f("./layout");var d=(function(l){h(k,l);function k(n){var q=l.call(this)||this;var m=q;var p=n;if(p.trigger){q.trigger=p.trigger}if(p.kick){q.kick=p.kick}if(p.drag){q.drag=p.drag}if(p.on){q.on=p.on}q.dragstart=q.dragStart=i.Layout.dragStart;q.dragend=q.dragEnd=i.Layout.dragEnd;return q}k.prototype.trigger=function(m){};k.prototype.kick=function(){};k.prototype.drag=function(){};k.prototype.on=function(m,n){return this};return k}(i.Layout));e.LayoutAdaptor=d;function j(k){return new d(k)}e.adaptor=j},{"./layout":11}],3:[function(g,h,f){Object.defineProperty(f,"__esModule",{value:true});var j=g("./layout");var k=g("./gridrouter");function i(m,o,n,l){m.cola.start(0,0,0,10,false);var p=e(m.cola.nodes(),m.cola.groups(),n,l);return p.routeEdges(m.powerGraph.powerEdges,o,function(q){return q.source.routerNode.id},function(q){return q.target.routerNode.id})}f.gridify=i;function e(n,m,p,l){n.forEach(function(q){q.routerNode={name:q.name,bounds:q.bounds.inflate(-p)}});m.forEach(function(q){q.routerNode={bounds:q.bounds.inflate(-l),children:(typeof q.groups!=="undefined"?q.groups.map(function(r){return n.length+r.id}):[]).concat(typeof q.leaves!=="undefined"?q.leaves.map(function(r){return r.index}):[])}});var o=n.concat(m).map(function(r,q){r.routerNode.id=q;return r.routerNode});return new k.GridRouter(o,{getChildren:function(q){return q.children},getBounds:function(q){return q.bounds}},p-l)}function d(p,o,s){var m;p.nodes.forEach(function(n,t){return n.index=t});new j.Layout().avoidOverlaps(false).nodes(p.nodes).links(p.links).powerGraphGroups(function(n){m=n;m.groups.forEach(function(t){return t.padding=s})});var r=p.nodes.length;var l=[];var q=p.nodes.slice(0);q.forEach(function(n,t){return n.index=t});m.groups.forEach(function(n){var t=n.index=n.id+r;q.push(n);if(typeof n.leaves!=="undefined"){n.leaves.forEach(function(u){return l.push({source:t,target:u.index})})}if(typeof n.groups!=="undefined"){n.groups.forEach(function(u){return l.push({source:t,target:u.id+r})})}});m.powerEdges.forEach(function(n){l.push({source:n.source.index,target:n.target.index})});new j.Layout().size(o).nodes(q).links(l).avoidOverlaps(false).linkDistance(30).symmetricDiffLinkLengths(5).convergenceThreshold(0.0001).start(100,0,0,0,false);return{cola:new j.Layout().convergenceThreshold(0.001).size(o).avoidOverlaps(true).nodes(p.nodes).links(p.links).groupCompactness(0.0001).linkDistance(30).symmetricDiffLinkLengths(5).powerGraphGroups(function(n){m=n;m.groups.forEach(function(t){t.padding=s})}).start(50,0,100,0,false),powerGraph:m}}f.powerGraphGridLayout=d},{"./gridrouter":9,"./layout":11}],4:[function(f,g,e){Object.defineProperty(e,"__esModule",{value:true});var j=f("./d3v3adaptor");var h=f("./d3v4adaptor");function i(k){if(!k||d(k)){return new j.D3StyleLayoutAdaptor()}return new h.D3StyleLayoutAdaptor(k)}e.d3adaptor=i;function d(k){var l=/^3\./;return k.version&&k.version.match(l)!==null}},{"./d3v3adaptor":5,"./d3v4adaptor":6}],5:[function(e,f,d){var g=(this&&this.__extends)||(function(){var k=function(m,l){k=Object.setPrototypeOf||({__proto__:[]} instanceof Array&&function(o,n){o.__proto__=n})||function(q,n){for(var o in n){if(n.hasOwnProperty(o)){q[o]=n[o]}}};return k(m,l)};return function(n,l){k(n,l);function m(){this.constructor=n}n.prototype=l===null?Object.create(l):(m.prototype=l.prototype,new m())}})();Object.defineProperty(d,"__esModule",{value:true});var h=e("./layout");var i=(function(k){g(l,k);function l(){var o=k.call(this)||this;o.event=d3.dispatch(h.EventType[h.EventType.start],h.EventType[h.EventType.tick],h.EventType[h.EventType.end]);var m=o;var n;o.drag=function(){if(!p){var p=d3.behavior.drag().origin(h.Layout.dragOrigin).on("dragstart.d3adaptor",h.Layout.dragStart).on("drag.d3adaptor",function(q){h.Layout.drag(q,d3.event);m.resume()}).on("dragend.d3adaptor",h.Layout.dragEnd)}if(!arguments.length){return p}this.call(p)};return o}l.prototype.trigger=function(n){var m={type:h.EventType[n.type],alpha:n.alpha,stress:n.stress};this.event[m.type](m)};l.prototype.kick=function(){var m=this;d3.timer(function(){return k.prototype.tick.call(m)})};l.prototype.on=function(m,n){if(typeof m==="string"){this.event.on(m,n)}else{this.event.on(h.EventType[m],n)}return this};return l}(h.Layout));d.D3StyleLayoutAdaptor=i;function j(){return new i()}d.d3adaptor=j},{"./layout":11}],6:[function(e,f,d){var g=(this&&this.__extends)||(function(){var j=function(l,k){j=Object.setPrototypeOf||({__proto__:[]} instanceof Array&&function(n,m){n.__proto__=m})||function(o,m){for(var n in m){if(m.hasOwnProperty(n)){o[n]=m[n]}}};return j(l,k)};return function(m,k){j(m,k);function l(){this.constructor=m}m.prototype=k===null?Object.create(k):(l.prototype=k.prototype,new l())}})();Object.defineProperty(d,"__esModule",{value:true});var h=e("./layout");var i=(function(j){g(k,j);function k(m){var o=j.call(this)||this;o.d3Context=m;o.event=m.dispatch(h.EventType[h.EventType.start],h.EventType[h.EventType.tick],h.EventType[h.EventType.end]);var l=o;var n;o.drag=function(){if(!p){var p=m.drag().subject(h.Layout.dragOrigin).on("start.d3adaptor",h.Layout.dragStart).on("drag.d3adaptor",function(q){h.Layout.drag(q,m.event);l.resume()}).on("end.d3adaptor",h.Layout.dragEnd)}if(!arguments.length){return p}arguments[0].call(p)};return o}k.prototype.trigger=function(m){var l={type:h.EventType[m.type],alpha:m.alpha,stress:m.stress};this.event.call(l.type,l)};k.prototype.kick=function(){var m=this;var l=this.d3Context.timer(function(){return j.prototype.tick.call(m)&&l.stop()})};k.prototype.on=function(l,m){if(typeof l==="string"){this.event.on(l,m)}else{this.event.on(h.EventType[l],m)}return this};return k}(h.Layout));d.D3StyleLayoutAdaptor=i},{"./layout":11}],7:[function(f,g,e){Object.defineProperty(e,"__esModule",{value:true});var d=(function(){function j(){this.locks={}}j.prototype.add=function(l,k){this.locks[l]=k};j.prototype.clear=function(){this.locks={}};j.prototype.isEmpty=function(){for(var k in this.locks){return false}return true};j.prototype.apply=function(m){for(var k in this.locks){m(Number(k),this.locks[k])}};return j}());e.Locks=d;var i=(function(){function j(k,p,o){if(o===void 0){o=null}this.D=p;this.G=o;this.threshold=0.0001;this.numGridSnapNodes=0;this.snapGridSize=100;this.snapStrength=1000;this.scaleSnapByMaxH=false;this.random=new h();this.project=null;this.x=k;this.k=k.length;var r=this.n=k[0].length;this.H=new Array(this.k);this.g=new Array(this.k);this.Hd=new Array(this.k);this.a=new Array(this.k);this.b=new Array(this.k);this.c=new Array(this.k);this.d=new Array(this.k);this.e=new Array(this.k);this.ia=new Array(this.k);this.ib=new Array(this.k);this.xtmp=new Array(this.k);this.locks=new d();this.minD=Number.MAX_VALUE;var m=r,l;while(m--){l=r;while(--l>m){var q=p[m][l];if(q>0&&q<this.minD){this.minD=q}}}if(this.minD===Number.MAX_VALUE){this.minD=1}m=this.k;while(m--){this.g[m]=new Array(r);this.H[m]=new Array(r);l=r;while(l--){this.H[m][l]=new Array(r)}this.Hd[m]=new Array(r);this.a[m]=new Array(r);this.b[m]=new Array(r);this.c[m]=new Array(r);this.d[m]=new Array(r);this.e[m]=new Array(r);this.ia[m]=new Array(r);this.ib[m]=new Array(r);this.xtmp[m]=new Array(r)}}j.createSquareMatrix=function(p,m){var o=new Array(p);for(var l=0;l<p;++l){o[l]=new Array(p);for(var k=0;k<p;++k){o[l][k]=m(l,k)}}return o};j.prototype.offsetDir=function(){var p=this;var n=new Array(this.k);var m=0;for(var o=0;o<this.k;++o){var k=n[o]=this.random.getNextBetween(0.01,1)-0.5;m+=k*k}m=Math.sqrt(m);return n.map(function(l){return l*=p.minD/m})};j.prototype.computeDerivatives=function(y){var R=this;var N=this.n;if(N<1){return}var S;var V=new Array(this.k);var Z=new Array(this.k);var o=new Array(this.k);var s=0;for(var l=0;l<N;++l){for(S=0;S<this.k;++S){o[S]=this.g[S][l]=0}for(var B=0;B<N;++B){if(l===B){continue}var t=N;var F=0;while(t--){F=0;for(S=0;S<this.k;++S){var H=V[S]=y[S][l]-y[S][B];F+=Z[S]=H*H}if(F>1e-9){break}var P=this.offsetDir();for(S=0;S<this.k;++S){y[S][B]+=P[S]}}var p=Math.sqrt(F);var M=this.D[l][B];var D=this.G!=null?this.G[l][B]:1;if(D>1&&p>M||!isFinite(M)){for(S=0;S<this.k;++S){this.H[S][l][B]=0}continue}if(D>1){D=1}var Y=M*M,J=2*D*(p-M)/(Y*p),E=F*p,X=2*-D/(Y*E);if(!isFinite(J)){console.log(J)}for(S=0;S<this.k;++S){this.g[S][l]+=V[S]*J;o[S]-=this.H[S][l][B]=X*(2*E+M*(Z[S]-F))}}for(S=0;S<this.k;++S){s=Math.max(s,this.H[S][l][l]=o[S])}}var G=this.snapGridSize/2;var T=this.snapGridSize;var z=this.snapStrength;var Q=z/(G*G);var L=this.numGridSnapNodes;for(var C=0;C<L;++C){for(S=0;S<this.k;++S){var K=this.x[S][C];var O=K/T;var U=O%1;var I=O-U;var W=Math.abs(U);var A=(W<=0.5)?K-I*T:(K>0)?K-(I+1)*T:K-(I-1)*T;if(-G<A&&A<=G){if(this.scaleSnapByMaxH){this.g[S][C]+=s*Q*A;this.H[S][C][C]+=s*Q}else{this.g[S][C]+=Q*A;this.H[S][C][C]+=Q}}}}if(!this.locks.isEmpty()){this.locks.apply(function(k,m){for(S=0;S<R.k;++S){R.H[S][k][k]+=s;R.g[S][k]-=s*(m[S]-y[S][k])}})}};j.dotProd=function(m,l){var k=0,n=m.length;while(n--){k+=m[n]*l[n]}return k};j.rightMultiply=function(k,l,o){var n=k.length;while(n--){o[n]=j.dotProd(k[n],l)}};j.prototype.computeStepSize=function(m){var l=0,n=0;for(var k=0;k<this.k;++k){l+=j.dotProd(this.g[k],m[k]);j.rightMultiply(this.H[k],m[k],this.Hd[k]);n+=j.dotProd(m[k],this.Hd[k])}if(n===0||!isFinite(n)){return 0}return 1*l/n};j.prototype.reduceStress=function(){this.computeDerivatives(this.x);var l=this.computeStepSize(this.g);for(var k=0;k<this.k;++k){this.takeDescentStep(this.x[k],this.g[k],l)}return this.computeStress()};j.copy=function(o,l){var k=o.length,r=l[0].length;for(var q=0;q<k;++q){for(var p=0;p<r;++p){l[q][p]=o[q][p]}}};j.prototype.stepAndProject=function(m,n,o,k){j.copy(m,n);this.takeDescentStep(n[0],o[0],k);if(this.project){this.project[0](m[0],m[1],n[0])}this.takeDescentStep(n[1],o[1],k);if(this.project){this.project[1](n[0],m[1],n[1])}for(var l=2;l<this.k;l++){this.takeDescentStep(n[l],o[l],k)}};j.mApply=function(k,q,p){var o=k;while(o-->0){var l=q;while(l-->0){p(o,l)}}};j.prototype.matrixApply=function(k){j.mApply(this.k,this.n,k)};j.prototype.computeNextPosition=function(k,l){var o=this;this.computeDerivatives(k);var n=this.computeStepSize(this.g);this.stepAndProject(k,l,this.g,n);if(this.project){this.matrixApply(function(q,p){return o.e[q][p]=k[q][p]-l[q][p]});var m=this.computeStepSize(this.e);m=Math.max(0.2,Math.min(m,1));this.stepAndProject(k,l,this.e,m)}};j.prototype.run=function(n){var m=Number.MAX_VALUE,l=false;while(!l&&n-->0){var k=this.rungeKutta();l=Math.abs(m/k-1)<this.threshold;m=k}return m};j.prototype.rungeKutta=function(){var l=this;this.computeNextPosition(this.x,this.a);j.mid(this.x,this.a,this.ia);this.computeNextPosition(this.ia,this.b);j.mid(this.x,this.b,this.ib);this.computeNextPosition(this.ib,this.c);this.computeNextPosition(this.c,this.d);var k=0;this.matrixApply(function(o,n){var m=(l.a[o][n]+2*l.b[o][n]+2*l.c[o][n]+l.d[o][n])/6,p=l.x[o][n]-m;k+=p*p;l.x[o][n]=m});return k};j.mid=function(n,l,k){j.mApply(n.length,n[0].length,function(o,m){return k[o][m]=n[o][m]+(l[o][m]-n[o][m])/2})};j.prototype.takeDescentStep=function(l,n,k){for(var m=0;m<this.n;++m){l[m]=l[m]-k*n[m]}};j.prototype.computeStress=function(){var p=0;for(var x=0,t=this.n-1;x<t;++x){for(var w=x+1,m=this.n;w<m;++w){var o=0;for(var q=0;q<this.k;++q){var y=this.x[q][x]-this.x[q][w];o+=y*y}o=Math.sqrt(o);var s=this.D[x][w];if(!isFinite(s)){continue}var r=s-o;var k=s*s;p+=r*r/k}}return p};j.zeroDistance=1e-10;return j}());e.Descent=i;var h=(function(){function j(k){if(k===void 0){k=1}this.seed=k;this.a=214013;this.c=2531011;this.m=2147483648;this.range=32767}j.prototype.getNext=function(){this.seed=(this.seed*this.a+this.c)%this.m;return(this.seed>>16)/this.range};j.prototype.getNextBetween=function(l,k){return l+this.getNext()*(k-l)};return j}());e.PseudoRandom=h},{}],8:[function(q,f,K){var I=(this&&this.__extends)||(function(){var L=function(N,M){L=Object.setPrototypeOf||({__proto__:[]} instanceof Array&&function(P,O){P.__proto__=O})||function(Q,O){for(var P in O){if(O.hasOwnProperty(P)){Q[P]=O[P]}}};return L(N,M)};return function(O,M){L(O,M);function N(){this.constructor=O}O.prototype=M===null?Object.create(M):(N.prototype=M.prototype,new N())}})();Object.defineProperty(K,"__esModule",{value:true});var k=q("./rectangle");var J=(function(){function L(){}return L}());K.Point=J;var o=(function(){function L(N,P,M,O){this.x1=N;this.y1=P;this.x2=M;this.y2=O}return L}());K.LineSegment=o;var l=(function(L){I(M,L);function M(){return L!==null&&L.apply(this,arguments)||this}return M}(J));K.PolyPoint=l;function j(M,L,N){return(L.x-M.x)*(N.y-M.y)-(N.x-M.x)*(L.y-M.y)}K.isLeft=j;function E(M,N,L){return j(M,N,L)>0}function v(M,N,L){return j(M,N,L)<0}function H(Q){var V=Q.slice(0).sort(function(S,P){return S.x!==P.x?P.x-S.x:P.y-S.y});var N=Q.length,U;var Y=0;var M=V[0].x;for(U=1;U<N;++U){if(V[U].x!==M){break}}var O=U-1;var X=[];X.push(V[Y]);if(O===N-1){if(V[O].y!==V[Y].y){X.push(V[O])}}else{var L,T=N-1;var R=V[N-1].x;for(U=N-2;U>=0;U--){if(V[U].x!==R){break}}L=U+1;U=O;while(++U<=L){if(j(V[Y],V[L],V[U])>=0&&U<L){continue}while(X.length>1){if(j(X[X.length-2],X[X.length-1],V[U])>0){break}else{X.length-=1}}if(U!=Y){X.push(V[U])}}if(T!=L){X.push(V[T])}var W=X.length;U=L;while(--U>=O){if(j(V[T],V[O],V[U])>=0&&U>O){continue}while(X.length>W){if(j(X[X.length-2],X[X.length-1],V[U])>0){break}else{X.length-=1}}if(U!=Y){X.push(V[U])}}}return X}K.ConvexHull=H;function z(N,M,L){M.slice(0).sort(function(P,O){return Math.atan2(P.y-N.y,P.x-N.x)-Math.atan2(O.y-N.y,O.x-N.x)}).forEach(L)}K.clockwiseRadialSweep=z;function d(L,M){if(L.polyIndex===M.length-1){return M[0]}return M[L.polyIndex+1]}function t(L,M){if(L.polyIndex===0){return M[M.length-1]}return M[L.polyIndex-1]}function m(N,L){var M=L.slice(0);M.push(L[0]);return{rtan:x(N,M),ltan:C(N,M)}}function x(Q,N){var T=N.length-1;var M,L,S;var R,O;if(v(Q,N[1],N[0])&&!E(Q,N[T-1],N[0])){return 0}for(M=0,L=T;;){if(L-M===1){if(E(Q,N[M],N[L])){return M}else{return L}}S=Math.floor((M+L)/2);O=v(Q,N[S+1],N[S]);if(O&&!E(Q,N[S-1],N[S])){return S}R=E(Q,N[M+1],N[M]);if(R){if(O){L=S}else{if(E(Q,N[M],N[S])){L=S}else{M=S}}}else{if(!O){M=S}else{if(v(Q,N[M],N[S])){L=S}else{M=S}}}}}function C(R,N){var T=N.length-1;var M,L,S;var Q,O;if(E(R,N[T-1],N[0])&&!v(R,N[1],N[0])){return 0}for(M=0,L=T;;){if(L-M===1){if(v(R,N[M],N[L])){return M}else{return L}}S=Math.floor((M+L)/2);O=v(R,N[S+1],N[S]);if(E(R,N[S-1],N[S])&&!O){return S}Q=v(R,N[M+1],N[M]);if(Q){if(!O){L=S}else{if(v(R,N[M],N[S])){L=S}else{M=S}}}else{if(O){M=S}else{if(E(R,N[M],N[S])){L=S}else{M=S}}}}}function G(M,L,P,O,R,Q){var T,S;T=P(L[0],M);S=O(M[T],L);var N=false;while(!N){N=true;while(true){if(T===M.length-1){T=0}if(R(L[S],M[T],M[T+1])){break}++T}while(true){if(S===0){S=L.length-1}if(Q(M[T],L[S],L[S-1])){break}--S;N=false}}return{t1:T,t2:S}}K.tangent_PolyPolyC=G;function D(M,L){var N=i(L,M);return{t1:N.t2,t2:N.t1}}K.LRtangent_PolyPolyC=D;function i(M,L){return G(M,L,x,C,E,v)}K.RLtangent_PolyPolyC=i;function u(M,L){return G(M,L,C,C,v,v)}K.LLtangent_PolyPolyC=u;function h(M,L){return G(M,L,x,x,E,E)}K.RRtangent_PolyPolyC=h;var g=(function(){function L(N,M){this.t1=N;this.t2=M}return L}());K.BiTangent=g;var B=(function(){function L(){}return L}());K.BiTangents=B;var s=(function(M){I(L,M);function L(){return M!==null&&M.apply(this,arguments)||this}return L}(J));K.TVGPoint=s;var n=(function(){function L(P,N,M,O){this.id=P;this.polyid=N;this.polyvertid=M;this.p=O;O.vv=this}return L}());K.VisibilityVertex=n;var p=(function(){function L(M,N){this.source=M;this.target=N}L.prototype.length=function(){var N=this.source.p.x-this.target.p.x;var M=this.source.p.y-this.target.p.y;return Math.sqrt(N*N+M*M)};return L}());K.VisibilityEdge=p;var y=(function(){function L(V,O){this.P=V;this.V=[];this.E=[];if(!O){var R=V.length;for(var U=0;U<R;U++){var Q=V[U];for(var S=0;S<Q.length;++S){var T=Q[S],aa=new n(this.V.length,U,S,T);this.V.push(aa);if(S>0){this.E.push(new p(Q[S-1].vv,aa))}}if(Q.length>1){this.E.push(new p(Q[0].vv,Q[Q.length-1].vv))}}for(var U=0;U<R-1;U++){var Y=V[U];for(var S=U+1;S<R;S++){var W=V[S],ab=A(Y,W);for(var N in ab){var Z=ab[N],M=Y[Z.t1],X=W[Z.t2];this.addEdgeIfVisible(M,X,U,S)}}}}else{this.V=O.V.slice(0);this.E=O.E.slice(0)}}L.prototype.addEdgeIfVisible=function(N,M,P,O){if(!this.intersectsPolys(new o(N.x,N.y,M.x,M.y),P,O)){this.E.push(new p(N.vv,M.vv))}};L.prototype.addPoint=function(Q,O){var R=this.P.length;this.V.push(new n(this.V.length,R,0,Q));for(var N=0;N<R;++N){if(N===O){continue}var P=this.P[N],M=m(Q,P);this.addEdgeIfVisible(Q,P[M.ltan],O,N);this.addEdgeIfVisible(Q,P[M.rtan],O,N)}return Q.vv};L.prototype.intersectsPolys=function(M,P,O){for(var N=0,Q=this.P.length;N<Q;++N){if(N!=P&&N!=O&&e(M,this.P[N]).length>0){return true}}return false};return L}());K.TangentVisibilityGraph=y;function e(L,O){var R=[];for(var N=1,Q=O.length;N<Q;++N){var M=k.Rectangle.lineIntersection(L.x1,L.y1,L.x2,L.y2,O[N-1].x,O[N-1].y,O[N].x,O[N].y);if(M){R.push(M)}}return R}function A(P,O){var ab=P.length-1,aa=O.length-1;var af=new B();for(var ad=0;ad<=ab;++ad){for(var ac=0;ac<=aa;++ac){var N=P[ad==0?ab:ad-1];var M=P[ad];var L=P[ad==ab?0:ad+1];var Y=O[ac==0?aa:ac-1];var X=O[ac];var U=O[ac==aa?0:ac+1];var T=j(N,M,X);var Z=j(M,Y,X);var Q=j(M,X,U);var S=j(Y,X,M);var R=j(X,N,M);var ae=j(X,M,L);if(T>=0&&Z>=0&&Q<0&&S>=0&&R>=0&&ae<0){af.ll=new g(ad,ac)}else{if(T<=0&&Z<=0&&Q>0&&S<=0&&R<=0&&ae>0){af.rr=new g(ad,ac)}else{if(T<=0&&Z>0&&Q<=0&&S>=0&&R<0&&ae>=0){af.rl=new g(ad,ac)}else{if(T>=0&&Z<0&&Q>=0&&S<=0&&R>0&&ae<=0){af.lr=new g(ad,ac)}}}}}}return af}K.tangents=A;function w(N,M){for(var L=1,O=M.length;L<O;++L){if(v(M[L-1],M[L],N)){return false}}return true}function F(M,L){return !M.every(function(N){return !w(N,L)})}function r(P,O){if(F(P,O)){return true}if(F(O,P)){return true}for(var N=1,Q=P.length;N<Q;++N){var L=P[N],M=P[N-1];if(e(new o(M.x,M.y,L.x,L.y),O).length>0){return true}}return false}K.polysOverlap=r},{"./rectangle":17}],9:[function(g,e,h){Object.defineProperty(h,"__esModule",{value:true});var i=g("./rectangle");var k=g("./vpsc");var f=g("./shortestpaths");var m=(function(){function n(q,p,o){this.id=q;this.rect=p;this.children=o;this.leaf=typeof o==="undefined"||o.length===0}return n}());h.NodeWrapper=m;var l=(function(){function n(s,o,r,q,p){if(q===void 0){q=null}if(p===void 0){p=null}this.id=s;this.x=o;this.y=r;this.node=q;this.line=p}return n}());h.Vert=l;var j=(function(){function n(r,p){this.s=r;this.t=p;var q=n.findMatch(r,p);var u=p.slice(0).reverse();var o=n.findMatch(r,u);if(q.length>=o.length){this.length=q.length;this.si=q.si;this.ti=q.ti;this.reversed=false}else{this.length=o.length;this.si=o.si;this.ti=p.length-o.ti-o.length;this.reversed=true}}n.findMatch=function(z,y){var p=z.length;var o=y.length;var w={length:0,si:-1,ti:-1};var q=new Array(p);for(var u=0;u<p;u++){q[u]=new Array(o);for(var r=0;r<o;r++){if(z[u]===y[r]){var x=q[u][r]=(u===0||r===0)?1:q[u-1][r-1]+1;if(x>w.length){w.length=x;w.si=u-x+1;w.ti=r-x+1}}else{q[u][r]=0}}}return w};n.prototype.getSequence=function(){return this.length>=0?this.s.slice(this.si,this.si+this.length):[]};return n}());h.LongestCommonSubsequence=j;var d=(function(){function n(q,s,A){var w=this;if(A===void 0){A=12}this.originalnodes=q;this.groupPadding=A;this.leaves=null;this.nodes=q.map(function(C,D){return new m(D,s.getBounds(C),s.getChildren(C))});this.leaves=this.nodes.filter(function(C){return C.leaf});this.groups=this.nodes.filter(function(C){return !C.leaf});this.cols=this.getGridLines("x");this.rows=this.getGridLines("y");this.groups.forEach(function(C){return C.children.forEach(function(D){return w.nodes[D].parent=C})});this.root={children:[]};this.nodes.forEach(function(C){if(typeof C.parent==="undefined"){C.parent=w.root;w.root.children.push(C.id)}C.ports=[]});this.backToFront=this.nodes.slice(0);this.backToFront.sort(function(C,D){return w.getDepth(C)-w.getDepth(D)});var v=this.backToFront.slice(0).reverse().filter(function(C){return !C.leaf});v.forEach(function(C){var D=i.Rectangle.empty();C.children.forEach(function(E){return D=D.union(w.nodes[E].rect)});C.rect=D.inflate(w.groupPadding)});var r=this.midPoints(this.cols.map(function(C){return C.pos}));var u=this.midPoints(this.rows.map(function(C){return C.pos}));var x=r[0],p=r[r.length-1];var t=u[0],y=u[u.length-1];var z=this.rows.map(function(C){return({x1:x,x2:p,y1:C.pos,y2:C.pos})}).concat(u.map(function(C){return({x1:x,x2:p,y1:C,y2:C})}));var o=this.cols.map(function(C){return({x1:C.pos,x2:C.pos,y1:t,y2:y})}).concat(r.map(function(C){return({x1:C,x2:C,y1:t,y2:y})}));var B=z.concat(o);B.forEach(function(C){return C.verts=[]});this.verts=[];this.edges=[];z.forEach(function(C){return o.forEach(function(F){var J=new l(w.verts.length,F.x1,C.y1);C.verts.push(J);F.verts.push(J);w.verts.push(J);var G=w.backToFront.length;while(G-->0){var I=w.backToFront[G],H=I.rect;var E=Math.abs(J.x-H.cx()),D=Math.abs(J.y-H.cy());if(E<H.width()/2&&D<H.height()/2){J.node=I;break}}})});B.forEach(function(E,C){w.nodes.forEach(function(J,K){J.rect.lineIntersections(E.x1,E.y1,E.x2,E.y2).forEach(function(L,M){var N=new l(w.verts.length,L.x,L.y,J,E);w.verts.push(N);E.verts.push(N);J.ports.push(N)})});var D=Math.abs(E.y1-E.y2)<0.1;var I=function(K,J){return D?J.x-K.x:J.y-K.y};E.verts.sort(I);for(var H=1;H<E.verts.length;H++){var G=E.verts[H-1],F=E.verts[H];if(G.node&&G.node===F.node&&G.node.leaf){continue}w.edges.push({source:G.id,target:F.id,length:Math.abs(I(G,F))})}})}n.prototype.avg=function(o){return o.reduce(function(p,q){return p+q})/o.length};n.prototype.getGridLines=function(s){var r=[];var p=this.leaves.slice(0,this.leaves.length);while(p.length>0){var o=p.filter(function(t){return t.rect["overlap"+s.toUpperCase()](p[0].rect)});var q={nodes:o,pos:this.avg(o.map(function(t){return t.rect["c"+s]()}))};r.push(q);q.nodes.forEach(function(t){return p.splice(p.indexOf(t),1)})}r.sort(function(u,t){return u.pos-t.pos});return r};n.prototype.getDepth=function(o){var p=0;while(o.parent!==this.root){p++;o=o.parent}return p};n.prototype.midPoints=function(o){var r=o[1]-o[0];var q=[o[0]-r/2];for(var p=1;p<o.length;p++){q.push((o[p]+o[p-1])/2)}q.push(o[o.length-1]+r/2);return q};n.prototype.findLineage=function(p){var o=[p];do{p=p.parent;o.push(p)}while(p!==this.root);return o.reverse()};n.prototype.findAncestorPathBetween=function(p,o){var r=this.findLineage(p),s=this.findLineage(o),q=0;while(r[q]===s[q]){q++}return{commonAncestor:r[q-1],lineages:r.slice(q).concat(s.slice(q))}};n.prototype.siblingObstacles=function(p,o){var t=this;var s=this.findAncestorPathBetween(p,o);var q={};s.lineages.forEach(function(u){return q[u.id]={}});var r=s.commonAncestor.children.filter(function(u){return !(u in q)});s.lineages.filter(function(u){return u.parent!==s.commonAncestor}).forEach(function(u){return r=r.concat(u.parent.children.filter(function(v){return v!==u.id}))});return r.map(function(u){return t.nodes[u]})};n.getSegmentSets=function(A,v,u){var t=[];for(var o=0;o<A.length;o++){var w=A[o];for(var q=0;q<w.length;q++){var C=w[q];C.edgeid=o;C.i=q;var B=C[1][v]-C[0][v];if(Math.abs(B)<0.1){t.push(C)}}}t.sort(function(x,s){return x[0][v]-s[0][v]});var z=[];var r=null;for(var p=0;p<t.length;p++){var C=t[p];if(!r||Math.abs(C[0][v]-r.pos)>0.1){r={pos:C[0][v],segments:[]};z.push(r)}r.segments.push(C)}return z};n.nudgeSegs=function(w,v,o,D,B,A){var C=D.length;if(C<=1){return}var E=D.map(function(x){return new k.Variable(x[0][w])});var r=[];for(var G=0;G<C;G++){for(var F=0;F<C;F++){if(G===F){continue}var q=D[G],p=D[F],t=q.edgeid,s=p.edgeid,z=-1,u=-1;if(w=="x"){if(B(t,s)){if(q[0][v]<q[1][v]){z=F,u=G}else{z=G,u=F}}}else{if(B(t,s)){if(q[0][v]<q[1][v]){z=G,u=F}else{z=F,u=G}}}if(z>=0){r.push(new k.Constraint(E[z],E[u],A))}}}var H=new k.Solver(E,r);H.solve();E.forEach(function(y,I){var J=D[I];var K=y.position();J[0][w]=J[1][w]=K;var x=o[J.edgeid];if(J.i>0){x[J.i-1][1][w]=K}if(J.i<x.length-1){x[J.i+1][0][w]=K}})};n.nudgeSegments=function(A,w,u,o,v){var z=n.getSegmentSets(A,w,u);for(var q=0;q<z.length;q++){var D=z[q];var B=[];for(var p=0;p<D.segments.length;p++){var C=D.segments[p];B.push({type:0,s:C,pos:Math.min(C[0][u],C[1][u])});B.push({type:1,s:C,pos:Math.max(C[0][u],C[1][u])})}B.sort(function(x,s){return x.pos-s.pos+x.type-s.type});var r=[];var t=0;B.forEach(function(s){if(s.type===0){r.push(s.s);t++}else{t--}if(t==0){n.nudgeSegs(w,u,A,r,o,v);r=[]}})}};n.prototype.routeEdges=function(q,s,r,u){var v=this;var t=q.map(function(w){return v.route(r(w),u(w))});var o=n.orderEdges(t);var p=t.map(function(w){return n.makeSegments(w)});n.nudgeSegments(p,"x","y",o,s);n.nudgeSegments(p,"y","x",o,s);n.unreverseEdges(p,t);return p};n.unreverseEdges=function(o,p){o.forEach(function(q,r){var s=p[r];if(s.reversed){q.reverse();q.forEach(function(t){t.reverse()})}})};n.angleBetween2Lines=function(p,o){var s=Math.atan2(p[0].y-p[1].y,p[0].x-p[1].x);var r=Math.atan2(o[0].y-o[1].y,o[0].x-o[1].x);var q=s-r;if(q>Math.PI||q<-Math.PI){q=r-s}return q};n.isLeft=function(p,o,q){return((o.x-p.x)*(q.y-p.y)-(o.y-p.y)*(q.x-p.x))<=0};n.getOrder=function(r){var o={};for(var q=0;q<r.length;q++){var s=r[q];if(typeof o[s.l]==="undefined"){o[s.l]={}}o[s.l][s.r]=true}return function(p,t){return typeof o[p]!=="undefined"&&o[p][t]}};n.orderEdges=function(s){var x=[];for(var t=0;t<s.length-1;t++){for(var r=t+1;r<s.length;r++){var w=s[t],v=s[r],o=new j(w,v);var y,q,p;if(o.length===0){continue}if(o.reversed){v.reverse();v.reversed=true;o=new j(w,v)}if((o.si<=0||o.ti<=0)&&(o.si+o.length>=w.length||o.ti+o.length>=v.length)){x.push({l:t,r:r});continue}if(o.si+o.length>=w.length||o.ti+o.length>=v.length){y=w[o.si+1];p=w[o.si-1];q=v[o.ti-1]}else{y=w[o.si+o.length-2];q=w[o.si+o.length];p=v[o.ti+o.length]}if(n.isLeft(y,q,p)){x.push({l:r,r:t})}else{x.push({l:t,r:r})}}}return n.getOrder(x)};n.makeSegments=function(u){function t(w){return{x:w.x,y:w.y}}var s=function(x,w,y){return Math.abs((w.x-x.x)*(y.y-x.y)-(w.y-x.y)*(y.x-x.x))<0.001};var q=[];var p=t(u[0]);for(var r=1;r<u.length;r++){var o=t(u[r]),v=r<u.length-1?u[r+1]:null;if(!v||!s(p,o,v)){q.push([p,o]);p=o}}return q};n.prototype.route=function(H,G){var y=this;var p=this.nodes[H],A=this.nodes[G];this.obstacles=this.siblingObstacles(p,A);var w={};this.obstacles.forEach(function(s){return w[s.id]=s});this.passableEdges=this.edges.filter(function(I){var t=y.verts[I.source],s=y.verts[I.target];return !(t.node&&t.node.id in w||s.node&&s.node.id in w)});for(var x=1;x<p.ports.length;x++){var F=p.ports[0].id;var E=p.ports[x].id;this.passableEdges.push({source:F,target:E,length:0})}for(var x=1;x<A.ports.length;x++){var F=A.ports[0].id;var E=A.ports[x].id;this.passableEdges.push({source:F,target:E,length:0})}var z=function(s){return s.source},r=function(s){return s.target},C=function(s){return s.length};var o=new f.Calculator(this.verts.length,this.passableEdges,z,r,C);var D=function(M,L,J){var I=y.verts[M],s=y.verts[L],N=y.verts[J];var K=Math.abs(N.x-I.x),t=Math.abs(N.y-I.y);if(I.node===p&&I.node===s.node||s.node===A&&s.node===N.node){return 0}return K>1&&t>1?1000:0};var q=o.PathFromNodeToNodeWithPrevCost(p.ports[0].id,A.ports[0].id,D);var B=q.reverse().map(function(s){return y.verts[s]});B.push(this.nodes[A.id].ports[0]);return B.filter(function(s,t){return !(t<B.length-1&&B[t+1].node===p&&s.node===p||t>0&&s.node===A&&B[t-1].node===A)})};n.getRoutePath=function(N,v,G,F){var B={routepath:"M "+N[0][0].x+" "+N[0][0].y+" ",arrowpath:""};if(N.length>1){for(var I=0;I<N.length;I++){var E=N[I];var A=E[1].x,z=E[1].y;var D=A-E[0].x;var C=z-E[0].y;if(I<N.length-1){if(Math.abs(D)>0){A-=D/Math.abs(D)*v}else{z-=C/Math.abs(C)*v}B.routepath+="L "+A+" "+z+" ";var H=N[I+1];var M=H[0].x,u=H[0].y;var K=H[1].x;var t=H[1].y;D=K-M;C=t-u;var L=n.angleBetween2Lines(E,H)<0?1:0;var J,r;if(Math.abs(D)>0){J=M+D/Math.abs(D)*v;r=u}else{J=M;r=u+C/Math.abs(C)*v}var s=Math.abs(J-A);var q=Math.abs(r-z);B.routepath+="A "+s+" "+q+" 0 0 "+L+" "+J+" "+r+" "}else{var w=[A,z];var p,o;if(Math.abs(D)>0){A-=D/Math.abs(D)*F;p=[A,z+G];o=[A,z-G]}else{z-=C/Math.abs(C)*F;p=[A+G,z];o=[A-G,z]}B.routepath+="L "+A+" "+z+" ";if(F>0){B.arrowpath="M "+w[0]+" "+w[1]+" L "+p[0]+" "+p[1]+" L "+o[0]+" "+o[1]}}}}else{var E=N[0];var A=E[1].x,z=E[1].y;var D=A-E[0].x;var C=z-E[0].y;var w=[A,z];var p,o;if(Math.abs(D)>0){A-=D/Math.abs(D)*F;p=[A,z+G];o=[A,z-G]}else{z-=C/Math.abs(C)*F;p=[A+G,z];o=[A-G,z]}B.routepath+="L "+A+" "+z+" ";if(F>0){B.arrowpath="M "+w[0]+" "+w[1]+" L "+p[0]+" "+p[1]+" L "+o[0]+" "+o[1]}}return B};return n}());h.GridRouter=d},{"./rectangle":17,"./shortestpaths":18,"./vpsc":19}],10:[function(e,f,d){Object.defineProperty(d,"__esModule",{value:true});var g={PADDING:10,GOLDEN_SECTION:(1+Math.sqrt(5))/2,FLOAT_EPSILON:0.0001,MAX_INERATIONS:100};function i(n,t,z,r,p,k){if(p===void 0){p=1}if(k===void 0){k=true}var q=0,o=0,C=t,y=z,p=typeof p!=="undefined"?p:1,r=typeof r!=="undefined"?r:0,E=0,l=0,u=0,v=0,s=[];if(n.length==0){return}A(n);x(n,p);if(k){D(n)}function A(w){w.forEach(function(H){G(H)});function G(L){var I=Number.MAX_VALUE,H=Number.MAX_VALUE,K=0,J=0;L.array.forEach(function(N){var M=typeof N.width!=="undefined"?N.width:r;var O=typeof N.height!=="undefined"?N.height:r;M/=2;O/=2;K=Math.max(N.x+M,K);I=Math.min(N.x-M,I);J=Math.max(N.y+O,J);H=Math.min(N.y-O,H)});L.width=K-I;L.height=J-H}}function D(w){w.forEach(function(I){var G={x:0,y:0};I.array.forEach(function(K){G.x+=K.x;G.y+=K.y});G.x/=I.array.length;G.y/=I.array.length;var H={x:G.x-I.width/2,y:G.y-I.height/2};var J={x:I.x-H.x+C/2-E/2,y:I.y-H.y+y/2-l/2};I.array.forEach(function(K){K.x+=J.x;K.y+=J.y})})}function x(K,S){var M=Number.POSITIVE_INFINITY;var P=0;K.sort(function(U,T){return T.height-U.height});u=K.reduce(function(U,T){return U.width<T.width?U.width:T.width});var J=G=u;var Q=w=j(K);var L=0;var I=Number.MAX_VALUE;var H=Number.MAX_VALUE;var N=-1;var R=Number.MAX_VALUE;var O=Number.MAX_VALUE;while((R>u)||O>g.FLOAT_EPSILON){if(N!=1){var G=Q-(Q-J)/g.GOLDEN_SECTION;var I=m(K,G)}if(N!=0){var w=J+(Q-J)/g.GOLDEN_SECTION;var H=m(K,w)}R=Math.abs(G-w);O=Math.abs(I-H);if(I<M){M=I;P=G}if(H<M){M=H;P=w}if(I>H){J=G;G=w;I=H;N=1}else{Q=w;w=G;H=I;N=0}if(L++>100){break}}m(K,P)}function m(H,G){s=[];E=0;l=0;v=o;for(var w=0;w<H.length;w++){var I=H[w];B(I,G)}return Math.abs(F()-p)}function B(H,I){var G=undefined;for(var w=0;w<s.length;w++){if((s[w].space_left>=H.height)&&(s[w].x+s[w].width+H.width+g.PADDING-I)<=g.FLOAT_EPSILON){G=s[w];break}}s.push(H);if(G!==undefined){H.x=G.x+G.width+g.PADDING;H.y=G.bottom;H.space_left=H.height;H.bottom=H.y;G.space_left-=H.height+g.PADDING;G.bottom+=H.height+g.PADDING}else{H.y=v;v+=H.height+g.PADDING;H.x=q;H.bottom=H.y;H.space_left=H.height}if(H.y+H.height-l>-g.FLOAT_EPSILON){l=H.y+H.height-o}if(H.x+H.width-E>-g.FLOAT_EPSILON){E=H.x+H.width-q}}function j(G){var w=0;G.forEach(function(H){return w+=H.width+g.PADDING});return w}function F(){return(E/l)}}d.applyPacking=i;function h(j,t){var s={};var u={};var n=[];var r=0;for(var l=0;l<t.length;l++){var q=t[l];var o=q.source;var m=q.target;if(u[o.index]){u[o.index].push(m)}else{u[o.index]=[m]}if(u[m.index]){u[m.index].push(o)}else{u[m.index]=[o]}}for(var l=0;l<j.length;l++){var k=j[l];if(s[k.index]){continue}p(k,true)}function p(y,x){if(s[y.index]!==undefined){return}if(x){r++;n.push({array:[]})}s[y.index]=r;n[r-1].array.push(y);var w=u[y.index];if(!w){return}for(var v=0;v<w.length;v++){p(w[v],false)}}return n}d.separateGraphs=h},{}],11:[function(h,e,l){Object.defineProperty(l,"__esModule",{value:true});var m=h("./powergraph");var i=h("./linklengths");var k=h("./descent");var n=h("./rectangle");var g=h("./shortestpaths");var j=h("./geom");var f=h("./handledisconnected");var d;(function(q){q[q.start=0]="start";q[q.tick=1]="tick";q[q.end=2]="end"})(d=l.EventType||(l.EventType={}));function p(q){return typeof q.leaves!=="undefined"||typeof q.groups!=="undefined"}var o=(function(){function q(){var r=this;this._canvasSize=[1,1];this._linkDistance=20;this._defaultNodeSize=10;this._linkLengthCalculator=null;this._linkType=null;this._avoidOverlaps=false;this._handleDisconnected=true;this._running=false;this._nodes=[];this._groups=[];this._rootGroup=null;this._links=[];this._constraints=[];this._distanceMatrix=null;this._descent=null;this._directedLinkConstraints=null;this._threshold=0.01;this._visibilityGraph=null;this._groupCompactness=0.000001;this.event=null;this.linkAccessor={getSourceIndex:q.getSourceIndex,getTargetIndex:q.getTargetIndex,setLength:q.setLinkLength,getType:function(s){return typeof r._linkType==="function"?r._linkType(s):0}}}q.prototype.on=function(s,r){if(!this.event){this.event={}}if(typeof s==="string"){this.event[d[s]]=r}else{this.event[s]=r}return this};q.prototype.trigger=function(r){if(this.event&&typeof this.event[r.type]!=="undefined"){this.event[r.type](r)}};q.prototype.kick=function(){while(!this.tick()){}};q.prototype.tick=function(){if(this._alpha<this._threshold){this._running=false;this.trigger({type:d.end,alpha:this._alpha=0,stress:this._lastStress});return true}var w=this._nodes.length,r=this._links.length;var v,t;this._descent.locks.clear();for(t=0;t<w;++t){v=this._nodes[t];if(v.fixed){if(typeof v.px==="undefined"||typeof v.py==="undefined"){v.px=v.x;v.py=v.y}var u=[v.px,v.py];this._descent.locks.add(t,u)}}var s=this._descent.rungeKutta();if(s===0){this._alpha=0}else{if(typeof this._lastStress!=="undefined"){this._alpha=s}}this._lastStress=s;this.updateNodePositions();this.trigger({type:d.tick,alpha:this._alpha,stress:this._lastStress});return false};q.prototype.updateNodePositions=function(){var r=this._descent.x[0],u=this._descent.x[1];var t,s=this._nodes.length;while(s--){t=this._nodes[s];t.x=r[s];t.y=u[s]}};q.prototype.nodes=function(r){if(!r){if(this._nodes.length===0&&this._links.length>0){var t=0;this._links.forEach(function(u){t=Math.max(t,u.source,u.target)});this._nodes=new Array(++t);for(var s=0;s<t;++s){this._nodes[s]={}}}return this._nodes}this._nodes=r;return this};q.prototype.groups=function(r){var s=this;if(!r){return this._groups}this._groups=r;this._rootGroup={};this._groups.forEach(function(t){if(typeof t.padding==="undefined"){t.padding=1}if(typeof t.leaves!=="undefined"){t.leaves.forEach(function(u,w){if(typeof u==="number"){(t.leaves[w]=s._nodes[u]).parent=t}})}if(typeof t.groups!=="undefined"){t.groups.forEach(function(u,v){if(typeof u==="number"){(t.groups[v]=s._groups[u]).parent=t}})}});this._rootGroup.leaves=this._nodes.filter(function(t){return typeof t.parent==="undefined"});this._rootGroup.groups=this._groups.filter(function(t){return typeof t.parent==="undefined"});return this};q.prototype.powerGraphGroups=function(s){var r=m.getGroups(this._nodes,this._links,this.linkAccessor,this._rootGroup);this.groups(r.groups);s(r);return this};q.prototype.avoidOverlaps=function(r){if(!arguments.length){return this._avoidOverlaps}this._avoidOverlaps=r;return this};q.prototype.handleDisconnected=function(r){if(!arguments.length){return this._handleDisconnected}this._handleDisconnected=r;return this};q.prototype.flowLayout=function(s,r){if(!arguments.length){s="y"}this._directedLinkConstraints={axis:s,getMinSeparation:typeof r==="number"?function(){return r}:r};return this};q.prototype.links=function(r){if(!arguments.length){return this._links}this._links=r;return this};q.prototype.constraints=function(r){if(!arguments.length){return this._constraints}this._constraints=r;return this};q.prototype.distanceMatrix=function(r){if(!arguments.length){return this._distanceMatrix}this._distanceMatrix=r;return this};q.prototype.size=function(r){if(!r){return this._canvasSize}this._canvasSize=r;return this};q.prototype.defaultNodeSize=function(r){if(!r){return this._defaultNodeSize}this._defaultNodeSize=r;return this};q.prototype.groupCompactness=function(r){if(!r){return this._groupCompactness}this._groupCompactness=r;return this};q.prototype.linkDistance=function(r){if(!r){return this._linkDistance}this._linkDistance=typeof r==="function"?r:+r;this._linkLengthCalculator=null;return this};q.prototype.linkType=function(r){this._linkType=r;return this};q.prototype.convergenceThreshold=function(r){if(!r){return this._threshold}this._threshold=typeof r==="function"?r:+r;return this};q.prototype.alpha=function(r){if(!arguments.length){return this._alpha}else{r=+r;if(this._alpha){if(r>0){this._alpha=r}else{this._alpha=0}}else{if(r>0){if(!this._running){this._running=true;this.trigger({type:d.start,alpha:this._alpha=r});this.kick()}}}return this}};q.prototype.getLinkLength=function(r){return typeof this._linkDistance==="function"?+(this._linkDistance(r)):this._linkDistance};q.setLinkLength=function(s,r){s.length=r};q.prototype.getLinkType=function(r){return typeof this._linkType==="function"?this._linkType(r):0};q.prototype.symmetricDiffLinkLengths=function(s,r){var t=this;if(r===void 0){r=1}this.linkDistance(function(u){return s*u.length});this._linkLengthCalculator=function(){return i.symmetricDiffLinkLengths(t._links,t.linkAccessor,r)};return this};q.prototype.jaccardLinkLengths=function(s,r){var t=this;if(r===void 0){r=1}this.linkDistance(function(u){return s*u.length});this._linkLengthCalculator=function(){return i.jaccardLinkLengths(t._links,t.linkAccessor,r)};return this};q.prototype.start=function(u,r,v,V,K,s){var R=this;if(u===void 0){u=0}if(r===void 0){r=0}if(v===void 0){v=0}if(V===void 0){V=0}if(K===void 0){K=true}if(s===void 0){s=true}var T,S,P=this.nodes().length,A=P+2*this._groups.length,Q=this._links.length,H=this._canvasSize[0],U=this._canvasSize[1];var F=new Array(A),E=new Array(A);var I=null;var O=this._avoidOverlaps;this._nodes.forEach(function(w,x){w.index=x;if(typeof w.x==="undefined"){w.x=H/2,w.y=U/2}F[x]=w.x,E[x]=w.y});if(this._linkLengthCalculator){this._linkLengthCalculator()}var z;if(this._distanceMatrix){z=this._distanceMatrix}else{z=(new g.Calculator(A,this._links,q.getSourceIndex,q.getTargetIndex,function(w){return R.getLinkLength(w)})).DistanceMatrix();I=k.Descent.createSquareMatrix(A,function(){return 2});this._links.forEach(function(w){if(typeof w.source=="number"){w.source=R._nodes[w.source]}if(typeof w.target=="number"){w.target=R._nodes[w.target]}});this._links.forEach(function(y){var x=q.getSourceIndex(y),w=q.getTargetIndex(y);I[x][w]=I[w][x]=y.weight||1})}var J=k.Descent.createSquareMatrix(A,function(x,w){return z[x][w]});if(this._rootGroup&&typeof this._rootGroup.groups!=="undefined"){var T=P;var B=function(x,w,D,y){I[x][w]=I[w][x]=D;J[x][w]=J[w][x]=y};this._groups.forEach(function(w){B(T,T+1,R._groupCompactness,0.1);if(typeof w.bounds==="undefined"){F[T]=H/2,E[T++]=U/2;F[T]=H/2,E[T++]=U/2}else{F[T]=w.bounds.x,E[T++]=w.bounds.y;F[T]=w.bounds.X,E[T++]=w.bounds.Y}})}else{this._rootGroup={leaves:this._nodes,groups:[]}}var C=this._constraints||[];if(this._directedLinkConstraints){this.linkAccessor.getMinSeparation=this._directedLinkConstraints.getMinSeparation;C=C.concat(i.generateDirectedEdgeConstraints(P,this._links,this._directedLinkConstraints.axis,(this.linkAccessor)))}this.avoidOverlaps(false);this._descent=new k.Descent([F,E],J);this._descent.locks.clear();for(var T=0;T<P;++T){var M=this._nodes[T];if(M.fixed){M.px=M.x;M.py=M.y;var L=[M.x,M.y];this._descent.locks.add(T,L)}}this._descent.threshold=this._threshold;this.initialLayout(u,F,E);if(C.length>0){this._descent.project=new n.Projection(this._nodes,this._groups,this._rootGroup,C).projectFunctions()}this._descent.run(r);this.separateOverlappingComponents(H,U,s);this.avoidOverlaps(O);if(O){this._nodes.forEach(function(w,x){w.x=F[x],w.y=E[x]});this._descent.project=new n.Projection(this._nodes,this._groups,this._rootGroup,C,true).projectFunctions();this._nodes.forEach(function(w,x){F[x]=w.x,E[x]=w.y})}this._descent.G=I;this._descent.run(v);if(V){this._descent.snapStrength=1000;this._descent.snapGridSize=this._nodes[0].width;this._descent.numGridSnapNodes=P;this._descent.scaleSnapByMaxH=P!=A;var t=k.Descent.createSquareMatrix(A,function(x,w){if(x>=P||w>=P){return I[x][w]}return 0});this._descent.G=t;this._descent.run(V)}this.updateNodePositions();this.separateOverlappingComponents(H,U,s);return K?this.resume():this};q.prototype.initialLayout=function(t,r,w){if(this._groups.length>0&&t>0){var v=this._nodes.length;var s=this._links.map(function(x){return({source:x.source.index,target:x.target.index})});var u=this._nodes.map(function(x){return({index:x.index})});this._groups.forEach(function(y,x){u.push({index:y.index=v+x})});this._groups.forEach(function(y,x){if(typeof y.leaves!=="undefined"){y.leaves.forEach(function(z){return s.push({source:y.index,target:z.index})})}if(typeof y.groups!=="undefined"){y.groups.forEach(function(z){return s.push({source:y.index,target:z.index})})}});new q().size(this.size()).nodes(u).links(s).avoidOverlaps(false).linkDistance(this.linkDistance()).symmetricDiffLinkLengths(5).convergenceThreshold(0.0001).start(t,0,0,0,false);this._nodes.forEach(function(x){r[x.index]=u[x.index].x;w[x.index]=u[x.index].y})}else{this._descent.run(t)}};q.prototype.separateOverlappingComponents=function(u,r,v){var x=this;if(v===void 0){v=true}if(!this._distanceMatrix&&this._handleDisconnected){var s=this._descent.x[0],w=this._descent.x[1];this._nodes.forEach(function(y,z){y.x=s[z],y.y=w[z]});var t=f.separateGraphs(this._nodes,this._links);f.applyPacking(t,u,r,this._defaultNodeSize,1,v);this._nodes.forEach(function(y,z){x._descent.x[0][z]=y.x,x._descent.x[1][z]=y.y;if(y.bounds){y.bounds.setXCentre(y.x);y.bounds.setYCentre(y.y)}})}};q.prototype.resume=function(){return this.alpha(0.1)};q.prototype.stop=function(){return this.alpha(0)};q.prototype.prepareEdgeRouting=function(r){if(r===void 0){r=0}this._visibilityGraph=new j.TangentVisibilityGraph(this._nodes.map(function(s){return s.bounds.inflate(-r).vertices()}))};q.prototype.routeEdge=function(y,H,A){if(H===void 0){H=5}var F=[];var w=new j.TangentVisibilityGraph(this._visibilityGraph.P,{V:this._visibilityGraph.V,E:this._visibilityGraph.E}),s={x:y.source.x,y:y.source.y},r={x:y.target.x,y:y.target.y},v=w.addPoint(s,y.source.index),t=w.addPoint(r,y.target.index);w.addEdgeIfVisible(s,r,y.source.index,y.target.index);if(typeof A!=="undefined"){A(w)}var J=function(K){return K.source.id},x=function(K){return K.target.id},u=function(K){return K.length()},B=new g.Calculator(w.V.length,w.E,J,x,u),z=B.PathFromNodeToNode(v.id,t.id);if(z.length===1||z.length===w.V.length){var I=n.makeEdgeBetween(y.source.innerBounds,y.target.innerBounds,H);F=[I.sourceIntersection,I.arrowStart]}else{var E=z.length-2,D=w.V[z[E]].p,C=w.V[z[0]].p,F=[y.source.innerBounds.rayIntersection(D.x,D.y)];for(var G=E;G>=0;--G){F.push(w.V[z[G]].p)}F.push(n.makeEdgeTo(C,y.target.innerBounds,H))}return F};q.getSourceIndex=function(r){return typeof r.source==="number"?r.source:r.source.index};q.getTargetIndex=function(r){return typeof r.target==="number"?r.target:r.target.index};q.linkId=function(r){return q.getSourceIndex(r)+"-"+q.getTargetIndex(r)};q.dragStart=function(r){if(p(r)){q.storeOffset(r,q.dragOrigin(r))}else{q.stopNode(r);r.fixed|=2}};q.stopNode=function(r){r.px=r.x;r.py=r.y};q.storeOffset=function(s,r){if(typeof s.leaves!=="undefined"){s.leaves.forEach(function(t){t.fixed|=2;q.stopNode(t);t._dragGroupOffsetX=t.x-r.x;t._dragGroupOffsetY=t.y-r.y})}if(typeof s.groups!=="undefined"){s.groups.forEach(function(t){return q.storeOffset(t,r)})}};q.dragOrigin=function(r){if(p(r)){return{x:r.bounds.cx(),y:r.bounds.cy()}}else{return r}};q.drag=function(s,r){if(p(s)){if(typeof s.leaves!=="undefined"){s.leaves.forEach(function(t){s.bounds.setXCentre(r.x);s.bounds.setYCentre(r.y);t.px=t._dragGroupOffsetX+r.x;t.py=t._dragGroupOffsetY+r.y})}if(typeof s.groups!=="undefined"){s.groups.forEach(function(t){return q.drag(t,r)})}}else{s.px=r.x;s.py=r.y}};q.dragEnd=function(r){if(p(r)){if(typeof r.leaves!=="undefined"){r.leaves.forEach(function(s){q.dragEnd(s);delete s._dragGroupOffsetX;delete s._dragGroupOffsetY})}if(typeof r.groups!=="undefined"){r.groups.forEach(q.dragEnd)}}else{r.fixed&=~6}};q.mouseOver=function(r){r.fixed|=4;r.px=r.x,r.py=r.y};q.mouseOut=function(r){r.fixed&=~4};return q}());l.Layout=o},{"./descent":7,"./geom":8,"./handledisconnected":10,"./linklengths":13,"./powergraph":14,"./rectangle":17,"./shortestpaths":18}],12:[function(g,e,k){Object.defineProperty(k,"__esModule",{value:true});var f=g("./shortestpaths");var j=g("./descent");var n=g("./rectangle");var i=g("./linklengths");var d=(function(){function o(p,q){this.source=p;this.target=q}o.prototype.actualLength=function(p){var q=this;return Math.sqrt(p.reduce(function(t,s){var r=s[q.target]-s[q.source];return t+r*r},0))};return o}());k.Link3D=d;var m=(function(){function o(p,r,q){if(p===void 0){p=0}if(r===void 0){r=0}if(q===void 0){q=0}this.x=p;this.y=r;this.z=q}return o}());k.Node3D=m;var l=(function(){function o(q,p,s){var t=this;if(s===void 0){s=1}this.nodes=q;this.links=p;this.idealLinkLength=s;this.constraints=null;this.useJaccardLinkLengths=true;this.result=new Array(o.k);for(var r=0;r<o.k;++r){this.result[r]=new Array(q.length)}q.forEach(function(u,x){for(var y=0,w=o.dims;y<w.length;y++){var z=w[y];if(typeof u[z]=="undefined"){u[z]=Math.random()}}t.result[0][x]=u.x;t.result[1][x]=u.y;t.result[2][x]=u.z})}o.prototype.linkLength=function(p){return p.actualLength(this.result)};o.prototype.start=function(r){var u=this;if(r===void 0){r=100}var q=this.nodes.length;var w=new h();if(this.useJaccardLinkLengths){i.jaccardLinkLengths(this.links,w,1.5)}this.links.forEach(function(v){return v.length*=u.idealLinkLength});var s=(new f.Calculator(q,this.links,function(v){return v.source},function(v){return v.target},function(v){return v.length})).DistanceMatrix();var p=j.Descent.createSquareMatrix(q,function(z,v){return s[z][v]});var y=j.Descent.createSquareMatrix(q,function(){return 2});this.links.forEach(function(v){var z=v.source,A=v.target;return y[z][A]=y[A][z]=1});this.descent=new j.Descent(this.result,p);this.descent.threshold=0.001;this.descent.G=y;if(this.constraints){this.descent.project=new n.Projection(this.nodes,null,null,this.constraints).projectFunctions()}for(var t=0;t<this.nodes.length;t++){var x=this.nodes[t];if(x.fixed){this.descent.locks.add(t,[x.x,x.y,x.z])}}this.descent.run(r);return this};o.prototype.tick=function(){this.descent.locks.clear();for(var q=0;q<this.nodes.length;q++){var p=this.nodes[q];if(p.fixed){this.descent.locks.add(q,[p.x,p.y,p.z])}}return this.descent.rungeKutta()};o.dims=["x","y","z"];o.k=o.dims.length;return o}());k.Layout3D=l;var h=(function(){function o(){}o.prototype.getSourceIndex=function(p){return p.source};o.prototype.getTargetIndex=function(p){return p.target};o.prototype.getLength=function(p){return p.length};o.prototype.setLength=function(q,p){q.length=p};return o}())},{"./descent":7,"./linklengths":13,"./rectangle":17,"./shortestpaths":18}],13:[function(f,d,g){Object.defineProperty(g,"__esModule",{value:true});function e(p,o){var q={};for(var r in p){q[r]={}}for(var r in o){q[r]={}}return Object.keys(q).length}function m(p,o){var r=0;for(var q in p){if(typeof o[q]!=="undefined"){++r}}return r}function h(p,r){var q={};var o=function(t,s){if(typeof q[t]==="undefined"){q[t]={}}q[t][s]={}};p.forEach(function(w){var t=r.getSourceIndex(w),s=r.getTargetIndex(w);o(t,s);o(s,t)});return q}function k(p,o,r,s){var q=h(p,s);p.forEach(function(v){var u=q[s.getSourceIndex(v)];var t=q[s.getTargetIndex(v)];s.setLength(v,1+o*r(u,t))})}function n(p,q,o){if(o===void 0){o=1}k(p,o,function(s,r){return Math.sqrt(e(s,r)-m(s,r))},q)}g.symmetricDiffLinkLengths=n;function j(p,q,o){if(o===void 0){o=1}k(p,o,function(s,r){return Math.min(Object.keys(s).length,Object.keys(r).length)<1.1?0:m(s,r)/e(s,r)},q)}g.jaccardLinkLengths=j;function i(u,p,q,s){var r=l(u,p,s);var o={};r.forEach(function(w,v){return w.forEach(function(x){return o[x]=v})});var t=[];p.forEach(function(w){var z=s.getSourceIndex(w),A=s.getTargetIndex(w),y=o[z],x=o[A];if(y!==x){t.push({axis:q,left:z,right:A,gap:s.getMinSeparation(w)})}});return t}g.generateDirectedEdgeConstraints=i;function l(B,t,q){var p=[];var z=0;var D=[];var y=[];function G(I){I.index=I.lowlink=z++;D.push(I);I.onStack=true;for(var L=0,K=I.out;L<K.length;L++){var H=K[L];if(typeof H.index==="undefined"){G(H);I.lowlink=Math.min(I.lowlink,H.lowlink)}else{if(H.onStack){I.lowlink=Math.min(I.lowlink,H.index)}}}if(I.lowlink===I.index){var J=[];while(D.length){H=D.pop();H.onStack=false;J.push(H);if(H===I){break}}y.push(J.map(function(w){return w.id}))}}for(var u=0;u<B;u++){p.push({id:u,out:[]})}for(var s=0,o=t;s<o.length;s++){var A=o[s];var x=p[q.getSourceIndex(A)],E=p[q.getTargetIndex(A)];x.out.push(E)}for(var C=0,r=p;C<r.length;C++){var F=r[C];if(typeof F.index==="undefined"){G(F)}}return y}g.stronglyConnectedComponents=l},{}],14:[function(g,e,h){Object.defineProperty(h,"__esModule",{value:true});var o=(function(){function p(r,s,q){this.source=r;this.target=s;this.type=q}return p}());h.PowerEdge=o;var f=(function(){function p(v,q,t,s){var u=this;this.linkAccessor=t;this.modules=new Array(v);this.roots=[];if(s){this.initModulesFromGroup(s)}else{this.roots.push(new l());for(var r=0;r<v;++r){this.roots[0].add(this.modules[r]=new i(r))}}this.R=q.length;q.forEach(function(z){var y=u.modules[t.getSourceIndex(z)],w=u.modules[t.getTargetIndex(z)],x=t.getType(z);y.outgoing.add(x,w);w.incoming.add(x,y)})}p.prototype.initModulesFromGroup=function(y){var x=new l();this.roots.push(x);for(var w=0;w<y.leaves.length;++w){var u=y.leaves[w];var s=new i(u.id);this.modules[u.id]=s;x.add(s)}if(y.groups){for(var v=0;v<y.groups.length;++v){var r=y.groups[v];var t={};for(var q in r){if(q!=="leaves"&&q!=="groups"&&r.hasOwnProperty(q)){t[q]=r[q]}}x.add(new i(-1-v,new k(),new k(),this.initModulesFromGroup(r),t))}}return x};p.prototype.merge=function(u,r,v){if(v===void 0){v=0}var t=u.incoming.intersection(r.incoming),s=u.outgoing.intersection(r.outgoing);var w=new l();w.add(u);w.add(r);var q=new i(this.modules.length,s,t,w);this.modules.push(q);var x=function(z,y,A){z.forAll(function(C,B){C.forAll(function(E){var D=E[y];D.add(B,q);D.remove(B,u);D.remove(B,r);u[A].remove(B,E);r[A].remove(B,E)})})};x(s,"incoming","outgoing");x(t,"outgoing","incoming");this.R-=t.count()+s.count();this.roots[v].remove(u);this.roots[v].remove(r);this.roots[v].add(q);return q};p.prototype.rootMerges=function(u){if(u===void 0){u=0}var v=this.roots[u].modules();var r=v.length;var q=new Array(r*(r-1));var s=0;for(var x=0,t=r-1;x<t;++x){for(var w=x+1;w<r;++w){var z=v[x],y=v[w];q[s]={id:s,nEdges:this.nEdges(z,y),a:z,b:y};s++}}return q};p.prototype.greedyMerge=function(){for(var s=0;s<this.roots.length;++s){if(this.roots[s].modules().length<2){continue}var r=this.rootMerges(s).sort(function(u,t){return u.nEdges==t.nEdges?u.id-t.id:u.nEdges-t.nEdges});var q=r[0];if(q.nEdges>=this.R){continue}this.merge(q.a,q.b,s);return true}};p.prototype.nEdges=function(t,q){var s=t.incoming.intersection(q.incoming),r=t.outgoing.intersection(q.outgoing);return this.R-s.count()-r.count()};p.prototype.getGroupHierarchy=function(s){var u=this;var q=[];var r={};n(this.roots[0],r,q);var t=this.allEdges();t.forEach(function(x){var w=u.modules[x.source];var v=u.modules[x.target];s.push(new o(typeof w.gid==="undefined"?x.source:q[w.gid],typeof v.gid==="undefined"?x.target:q[v.gid],x.type))});return q};p.prototype.allEdges=function(){var q=[];p.getEdges(this.roots[0],q);return q};p.getEdges=function(q,r){q.forAll(function(s){s.getEdges(r);p.getEdges(s.children,r)})};return p}());h.Configuration=f;function n(q,r,p){q.forAll(function(s){if(s.isLeaf()){if(!r.leaves){r.leaves=[]}r.leaves.push(s.id)}else{var t=r;s.gid=p.length;if(!s.isIsland()||s.isPredefined()){t={id:s.gid};if(s.isPredefined()){for(var u in s.definition){t[u]=s.definition[u]}}if(!r.groups){r.groups=[]}r.groups.push(s.gid);p.push(t)}n(s.children,t,p)}})}var i=(function(){function p(u,r,q,t,s){if(r===void 0){r=new k()}if(q===void 0){q=new k()}if(t===void 0){t=new l()}this.id=u;this.outgoing=r;this.incoming=q;this.children=t;this.definition=s}p.prototype.getEdges=function(q){var r=this;this.outgoing.forAll(function(s,t){s.forAll(function(u){q.push(new o(r.id,u.id,t))})})};p.prototype.isLeaf=function(){return this.children.count()===0};p.prototype.isIsland=function(){return this.outgoing.count()===0&&this.incoming.count()===0};p.prototype.isPredefined=function(){return typeof this.definition!=="undefined"};return p}());h.Module=i;function d(p,s){var r={};for(var q in p){if(q in s){r[q]=p[q]}}return r}var l=(function(){function p(){this.table={}}p.prototype.count=function(){return Object.keys(this.table).length};p.prototype.intersection=function(r){var q=new p();q.table=d(this.table,r.table);return q};p.prototype.intersectionCount=function(q){return this.intersection(q).count()};p.prototype.contains=function(q){return q in this.table};p.prototype.add=function(q){this.table[q.id]=q};p.prototype.remove=function(q){delete this.table[q.id]};p.prototype.forAll=function(r){for(var q in this.table){r(this.table[q])}};p.prototype.modules=function(){var q=[];this.forAll(function(r){if(!r.isPredefined()){q.push(r)}});return q};return p}());h.ModuleSet=l;var k=(function(){function p(){this.sets={};this.n=0}p.prototype.count=function(){return this.n};p.prototype.contains=function(r){var q=false;this.forAllModules(function(s){if(!q&&s.id==r){q=true}});return q};p.prototype.add=function(r,q){var t=r in this.sets?this.sets[r]:this.sets[r]=new l();t.add(q);++this.n};p.prototype.remove=function(s,q){var r=this.sets[s];r.remove(q);if(r.count()===0){delete this.sets[s]}--this.n};p.prototype.forAll=function(r){for(var q in this.sets){r(this.sets[q],Number(q))}};p.prototype.forAllModules=function(q){this.forAll(function(s,r){return s.forAll(q)})};p.prototype.intersection=function(r){var q=new p();this.forAll(function(t,s){if(s in r.sets){var u=t.intersection(r.sets[s]),v=u.count();if(v>0){q.sets[s]=u;q.n+=v}}});return q};return p}());h.LinkSets=k;function j(p,q){return Object.keys(d(p,q)).length}function m(q,p,t,s){var w=q.length,v=new f(w,p,t,s);while(v.greedyMerge()){}var u=[];var r=v.getGroupHierarchy(u);u.forEach(function(y){var x=function(z){var A=y[z];if(typeof A=="number"){y[z]=q[A]}};x("source");x("target")});return{groups:r,powerEdges:u}}h.getGroups=m},{}],15:[function(e,g,d){Object.defineProperty(d,"__esModule",{value:true});var f=(function(){function i(j){this.elem=j;this.subheaps=[]}i.prototype.toString=function(j){var m="",k=false;for(var l=0;l<this.subheaps.length;++l){var n=this.subheaps[l];if(!n.elem){k=false;continue}if(k){m=m+","}m=m+n.toString(j);k=true}if(m!==""){m="("+m+")"}return(this.elem?j(this.elem):"")+m};i.prototype.forEach=function(j){if(!this.empty()){j(this.elem,this);this.subheaps.forEach(function(k){return k.forEach(j)})}};i.prototype.count=function(){return this.empty()?0:1+this.subheaps.reduce(function(k,j){return k+j.count()},0)};i.prototype.min=function(){return this.elem};i.prototype.empty=function(){return this.elem==null};i.prototype.contains=function(k){if(this===k){return true}for(var j=0;j<this.subheaps.length;j++){if(this.subheaps[j].contains(k)){return true}}return false};i.prototype.isHeap=function(j){var k=this;return this.subheaps.every(function(l){return j(k.elem,l.elem)&&l.isHeap(j)})};i.prototype.insert=function(k,j){return this.merge(new i(k),j)};i.prototype.merge=function(k