% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_tables_list.R
\name{search_cansim_cubes}
\alias{search_cansim_cubes}
\title{Search through Statistics Canada data cubes}
\usage{
search_cansim_cubes(search_term, refresh = FALSE)
}
\arguments{
\item{search_term}{User-supplied search term used to find Statistics Canada data cubes with matching titles, table numbers, subject and survey codes.}

\item{refresh}{Default is \code{FALSE}. The underlying cube list is cached for the duration of the R sessions and will regenerate the cube list if set to \code{TRUE}}
}
\value{
A tibble with available Statistics Canada data cubes, listing title, Statistics Canada data cube catalogue number, deprecated CANSIM table number, survey and subject.
}
\description{
Searches through Statistics Canada data cubes using a search term.
}
\examples{
\donttest{
search_cansim_cubes("Labour force")
}

}
