\name{eventTiming}
\alias{eventTiming}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Estimate the time of events in tumor data
}
\description{
Estimate the proportion of time spent between different chromosomal abnormalities based on the allele frequencies of mutated locations. 
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
eventTiming	(x, m, history, totalCopy, 
	method = c("fullMLE","partialMLE", "Bayes"), 
	type = c("gain", "CNLOH"), seqError = 0, bootstrapCI = NULL, 
	B = if (method =="Bayes") 10000 else 500, CILevel = 0.95, normCont = 0, 
	verbose = TRUE, returnAssignments = FALSE, coverageCutoff = 1,
	minMutations = 10, init = NULL, maxiter = 100, tol= 1e-04, 
	mutationId = 1:length(x),...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ vector. the number of reads/fragments containing the variant
%%     ~~Describe \code{x} here~~
}
  \item{m}{ vector. the number of reads/fragments covering the location with the variant (the coverage)
%%     ~~Describe \code{m} here~~
}
  \item{history}{ a matrix, based on the history of the region (see Details)
%%     ~~Describe \code{history} here~~
}
  \item{totalCopy}{ integer. the total number of copies of the tumor DNA for this region 
%%     ~~Describe \code{totalCopy} here~~
}
\item{method}{what estimation method to use, one of ``fullMLE",``partialMLE",``Bayes" }
  \item{type}{ type of region, either a gain or a CNLOH region
%%     ~~Describe \code{type} here~~
}
\item{seqError}{Probability of sequencing error}
  \item{bootstrapCI}{ type of bootstrap confidence interval to calculate, one of ``parametric", ``nonparametric". If NULL, then the confidence interval is not calculated
%%     ~~Describe \code{bootstrapCI} here~~
}
  \item{B}{ number of bootstrap samples to take (or simulations from the posterior for Bayesian estimation)
%%     ~~Describe \code{B} here~~
}
\item{CILevel}{
	At what level the confidence intervals should be calculated.
}
  \item{normCont}{ the proportion of normal contamination, between 0 and 1.
%%     ~~Describe \code{normCont} here~~
}
  \item{verbose}{ logical. Whether to give additional warnings as the program is running. 
%%     ~~Describe \code{verbose} here~~
}
  \item{returnAssignments}{ logical. Whether to return the probabilistic assignments of mutations to allele frequencies generated by the EM algorithm. Also returns the x,m values for those that pass the filter.
%%     ~~Describe \code{returnAssignments} here~~
}
  \item{coverageCutoff}{ minimum value for m[i]; any entries with m[i]<coverageCutoff are ignored in estimation.
%%     ~~Describe \code{coverageCutoff} here~~
}
  \item{minMutations}{ minimum number of mutations required. }
  \item{init}{ initial value of multinomial parameter q passed to estimateQ. 
%%     ~~Describe \code{init} here~~
}
  \item{maxiter}{maximum number of iterations in calculation q.
%%     ~~Describe \code{maxiter} here~~
}
  \item{tol}{tolerance in the convergence of q
%%     ~~Describe \code{tol} here~~
}
\item{mutationId}{identification values of the mutations (vector of the same length as x and m). Default is indexing values, 1:length(x). Used when returnAssignments=TRUE so that the assignments of the mutations to allele frequencies can be linked with the original mutations if there has been filtering in eventTiming, e.g. due to depth of coverage. 
}
  \item{...}{Arguments passed to internal fitting function for Bayesian Method. For example, `alpha' gives the Dirichlet prior of the bayesian estimate (default=1), `tdf' gives the number of degrees of freedom for the t proposal density used in the bayesian estimate (default=4), `bayesApproxMethod' gives the method for calculating the approximate distribution (default is ``sir"; ``inv" is for K=1 when the problem is 1-dimensional and one can easily grid and get the approximate posterior density and cdf).
}

}

% \details{
% %%  ~~ If necessary, more details than the description above ~~
% }
\value{
A list with values
 \item{pi }{estimate of pi vector}
 \item{piCI }{bootstrap confidence interval, if requested}
\item{q}{estimate of the multinomial parameter q}
\item{perLocationProb}{output from estimateQ giving per location P(P[i]|X[i],q), if requested. Only locations used in the estimation are included.}
\item{optimDetails}{optimization details from estimateQ}
\item{call}{list of the parameters of the call to the function: history, totalCopy, type, exactAllele, normCont, coverageCutoff, minMutations. In addition, `alleleSet' is included in this list, which is the set of possible alleles for this history, after adjusting for normal contamination. }
}
\references{
Durinck S, et al. (2011). ``Temporal Dissection of Tumorigenesis in Primary Cancers." Cancer Discovery, 1(2): 137--143.
Greenman CD, et al. (2012). ``Estimation of rearrangement phylogeny for cancer genomes." Genome Research, 22(2): 346--361.
Purdom E, et al. (2013). ``Timing Chromosomal Abnormalities within Cancer Samples.'' Bioinformatics, 29(24): 3113--3120.
}
\author{
Elizabeth Purdom
}

\examples{
data(mutData)
ACNLOH<-matrix(c(1,3,1,0),ncol=2,nrow=2,byrow=TRUE)
onlyMuts<-subset(mutData,is.na(rsID) & position <= 1.8E7)
onlyMuts$t_depth<-onlyMuts$t_ref_count+onlyMuts$t_alt_count
x<-eventTiming(x=onlyMuts$t_alt_count,m=onlyMuts$t_depth,
    history=ACNLOH,totalCopy=2,type="CNLOH",normCont=0.22)
x$pi #estimate of time of stages
x$q #estimate of the multinomial (likelihood of each of the alleles)
x$call$alleleSet #possible set of alleles after 
                #adjusting for normal contamination
}
