% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal-state.R
\name{normal_state}
\alias{normal_state}
\title{Normalize US State Abbreviations}
\usage{
normal_state(
  state,
  abbreviate = TRUE,
  na = c("", "NA"),
  na_rep = FALSE,
  valid = NULL
)
}
\arguments{
\item{state}{A vector of US state names or abbreviations.}

\item{abbreviate}{If TRUE (default), replace state names with the 2-digit
abbreviation using the built-in \code{state.abb} and \code{state.name} vectors.}

\item{na}{A vector of values to make \code{NA}.}

\item{na_rep}{logical; If \code{TRUE}, make all single digit repeating strings
\code{NA} (removes valid "AA" code for "American Armed Forces").}

\item{valid}{A vector of valid abbreviations to compare to and remove those
not shared.}
}
\value{
A vector of normalized 2-digit state abbreviations.
}
\description{
Return consistent version of a state \emph{abbreviations} using \verb{stringr::str_*()}
functions. Letters are capitalized, all non-letters characters are removed,
and excess whitespace is trimmed and squished, and then \code{\link[=abbrev_full]{abbrev_full()}} is
called with \link{usps_state}.
}
\examples{
normal_state(
  state = c("VT", "N/A", "Vermont", "XX", "ZA"),
  abbreviate = TRUE,
  na = c("", "NA"),
  na_rep = TRUE,
  valid = NULL
)
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
