% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple.cc.R
\name{simple.cc}
\alias{simple.cc}
\title{simple.cc}
\usage{
simple.cc(s1, s2, norm = FALSE)
}
\arguments{
\item{s1}{the first numeric vector (required)}

\item{s2}{the second numeric vector (required)}

\item{norm}{if `TRUE` the final difference is divided by the length of the longest vector}
}
\value{
Returns an integer, which is the start of s1 relative to s2.
E.g., -1 means that s1 has to be moved one step back to be aligned with s2.
}
\description{
Simple cross correlation of two vectors. Uses zero embedding to find optimal overlap. Also
has an option to normalise by the longest vector (divides final difference by length).
This version returns the time difference for best overlap.
}
\examples{
s1 = c(0, 0, 0, 1, 1, 2, 0)
s2 = c(0, 0, 2, 2, 3, 0, 0, 0, 0)
offset = simple.cc(s1, s2) # -1
index_s1 = seq(1, length(s1)) + offset # align
plot(s2, type = 'b')
points(index_s1, s1, col = 2, type = 'b')
}
