% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_utils.R
\name{classifyConstructs}
\alias{classifyConstructs}
\title{Internal: Classify structural model terms by type}
\usage{
classifyConstructs(.terms = args_default()$.terms)
}
\arguments{
\item{.terms}{A vector of construct names to be classified.}
}
\value{
A named list of length equal to the number of terms provided containing
a data frame with columns "\emph{Term_class}", "\emph{Component}",
"\emph{Component_type}", and "\emph{Component_freq}".
}
\description{
Classify terms of the structural model according to their type.
}
\details{
Classification is required to estimate nonlinear structural relationships.
Currently the following terms are supported
\itemize{
\item Single, e.g., \code{eta1}
\item Quadratic, e.g., \code{eta1.eta1}
\item Cubic, e.g., \code{eta1.eta1.eta1}
\item Two-way interaction, e.g., \code{eta1.eta2}
\item Three-way interaction, e.g., \code{eta1.eta2.eta3}
\item Quadratic and two-way interaction, e.g., \code{eta1.eta1.eta3}
}
Note that exponential terms are modeled as "interactions with itself"
as in i.e., \code{eta1^3 = eta1.eta1.eta1}.
}
\keyword{internal}
