% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/child_weight.R
\name{child_weight}
\alias{child_weight}
\title{Dynamic Children Weight Change Model}
\usage{
child_weight(age, sex, FM = child_reference_FFMandFM(age, sex)$FM,
  FFM = child_reference_FFMandFM(age, sex)$FFM, EI = NA,
  richardsonparams = list(K = NA, Q = NA, B = NA, A = NA, nu = NA, C = NA),
  days = 365, dt = 1, checkValues = TRUE)
}
\arguments{
\item{age}{(vector) Age of individual (yrs)}

\item{sex}{(vector) Sex either \code{"female"} or \code{"male"}}

\item{FM}{(vector) Fat Mass at Baseline}

\item{FFM}{(vector) Fat Free Mass at Baseline}

\item{EI}{(matrix) Numeric Matrix with energy intake}

\item{richardsonparams}{(list) List of parameters for Richardson's curve for energy. See details.

\strong{ Optional }}

\item{days}{(numeric) Days to run the model.}

\item{dt}{(double) Time step for Rungue-Kutta method}

\item{checkValues}{(boolean) Checks whether values of fat mass and free fat mass are possible}
}
\description{
Estimates weight given age, sex, fat mass, and fat free mass,
}
\details{
\code{richardsonparams} is a named list of parameters:
\code{K}, \code{A}, \code{Q}, \code{C}, \code{B}, \code{nu}
which result in Richardon's curve:
\deqn{A + \frac{K-A}{(C + Q exp(-B*t))^{1/nu}}}
The Richardson's curve is another option for modelling the energy
intake for a child: by specifying the parameters no energy input
is needed; instead Energy is assumed to follow the equation:
\deqn{EI(t) = A + \frac{K-A}{(C + Q exp(-B*t))^{1/nu}}}
}
\examples{
#EXAMPLE 1: INDIVIDUAL MODELLING
#--------------------------------------------------------
#For one child with default energy intake
child_weight(6,"male")

#For a child with specific energy intake
child_weight(6,"male",2.5, 16, as.matrix(rep(2000, 365)), days = 365)

#Using Richardson's energy
girl <- child_weight(6,"female", days=365, dt = 5, 
                     richardsonparams = list(K = 2700, Q = 10, 
                     B = 12, A = 3, nu = 4, C = 1))
plot(girl$Body_Weight[1,])

#EXAMPLE 2: DATASET MODELLING
#--------------------------------------------------------
#Antropometric data
FatFree <- c(32, 17.2, 18.8, 20, 24.1)
Fat     <- c(4.30, 2.02, 3.07, 1.12, 2.93)
ages    <- c(10, 6.2, 5.4, 4, 4.1)
sexes   <- c("male", "female", "female", "male", "male") 

#With specific energy intake
eintake <- matrix(rep(2000, 365*5), ncol = 5)

#Returns a weight change matrix and other matrices
model_weight <- child_weight(ages, sexes, Fat, FatFree, eintake)

model_weight_2 <- child_weight(ages, sexes, Fat, FatFree, 
                    richardsonparams = list(K = 2700, Q = 10, 
                    B = 12, A = 3, nu = 4, C = 1))
         
}
\references{
Hall, K. D., Butte, N. F., Swinburn, B. A., & Chow, C. C. (2013). 
\emph{Dynamics of childhood growth and obesity: development and validation of a 
quantitative mathematical model}. The Lancet Diabetes & Endocrinology, 1(2), 97-105.

Haschke, F. (1989). \emph{Body Composition During Adolescence.} 
Body Composition Measurements in Infants and Children.
Ross Laboratories Columbus, OH, 76–83.

Fomon, Samuel J, Ferdinand Haschke, Ekhard E Ziegler, and Steven E Nelson. 1982. 
\emph{Body Composition of Reference Children from Birth to Age 10 Years.}
The American Journal of Clinical Nutrition 35 (5). Am Soc Nutrition: 1169–75.
 
Ellis, Kenneth J, Roman J Shypailo, Steven A Abrams, and William W Wong. 2000. 
\emph{The Reference Child and Adolescent Models of Body Composition: A Contemporary Comparison.} 
Annals of the New York Academy of Sciences 904 (1). Wiley Online Library: 374–82.
 
Deurenberg, Paul, Jan A Weststrate, and Jaap C Seidell. 1991. 
\emph{Body Mass Index as a Measure of Body Fatness: Age-and Sex-Specific Prediction Formulas.} 
British Journal of Nutrition 65 (2). Cambridge University Press: 105–14.

Katan, Martijn B, Janne C De Ruyter, Lothar DJ Kuijper, Carson C Chow, Kevin D Hall, and Margreet R Olthof. 2016.
\emph{Impact of Masked Replacement of Sugar-Sweetened with Sugar-Free Beverages on Body Weight Increases with Initial Bmi:
Secondary Analysis of Data from an 18 Month Double–Blind Trial in Children.} 
PloS One 11 (7). Public Library of Science: e0159771.
}
\seealso{
@\code{\link{adult_weight}} for the weight change model for adults;
\code{\link{model_plot}} for plotting the results and 
\code{\link{model_mean}} for aggregate data estimation.
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
